"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isURLSearchParams = isURLSearchParams;
exports.isBlob = isBlob;
exports.isAbortSignal = isAbortSignal;
exports.isArrayBuffer = isArrayBuffer;
exports.isAbortError = isAbortError;

function cov_20h2bmyl99() {
  var path = "/home/xxczaki/dev/node-fetch/src/utils/is.js";
  var hash = "59cf56b6bdcb176792387a7c8f013e5a5db59a40";
  var global = new Function("return this")();
  var gcv = "__coverage__";
  var coverageData = {
    path: "/home/xxczaki/dev/node-fetch/src/utils/is.js",
    statementMap: {
      "0": {
        start: {
          line: 7,
          column: 13
        },
        end: {
          line: 7,
          column: 31
        }
      },
      "1": {
        start: {
          line: 17,
          column: 1
        },
        end: {
          line: 27,
          column: 3
        }
      },
      "2": {
        start: {
          line: 37,
          column: 1
        },
        end: {
          line: 44,
          column: 3
        }
      },
      "3": {
        start: {
          line: 54,
          column: 1
        },
        end: {
          line: 57,
          column: 3
        }
      },
      "4": {
        start: {
          line: 67,
          column: 1
        },
        end: {
          line: 67,
          column: 39
        }
      },
      "5": {
        start: {
          line: 77,
          column: 1
        },
        end: {
          line: 77,
          column: 38
        }
      }
    },
    fnMap: {
      "0": {
        name: "isURLSearchParams",
        decl: {
          start: {
            line: 16,
            column: 16
          },
          end: {
            line: 16,
            column: 33
          }
        },
        loc: {
          start: {
            line: 16,
            column: 42
          },
          end: {
            line: 28,
            column: 1
          }
        },
        line: 16
      },
      "1": {
        name: "isBlob",
        decl: {
          start: {
            line: 36,
            column: 16
          },
          end: {
            line: 36,
            column: 22
          }
        },
        loc: {
          start: {
            line: 36,
            column: 31
          },
          end: {
            line: 45,
            column: 1
          }
        },
        line: 36
      },
      "2": {
        name: "isAbortSignal",
        decl: {
          start: {
            line: 53,
            column: 16
          },
          end: {
            line: 53,
            column: 29
          }
        },
        loc: {
          start: {
            line: 53,
            column: 38
          },
          end: {
            line: 58,
            column: 1
          }
        },
        line: 53
      },
      "3": {
        name: "isArrayBuffer",
        decl: {
          start: {
            line: 66,
            column: 16
          },
          end: {
            line: 66,
            column: 29
          }
        },
        loc: {
          start: {
            line: 66,
            column: 38
          },
          end: {
            line: 68,
            column: 1
          }
        },
        line: 66
      },
      "4": {
        name: "isAbortError",
        decl: {
          start: {
            line: 76,
            column: 16
          },
          end: {
            line: 76,
            column: 28
          }
        },
        loc: {
          start: {
            line: 76,
            column: 37
          },
          end: {
            line: 78,
            column: 1
          }
        },
        line: 76
      }
    },
    branchMap: {
      "0": {
        loc: {
          start: {
            line: 18,
            column: 2
          },
          end: {
            line: 26,
            column: 36
          }
        },
        type: "binary-expr",
        locations: [{
          start: {
            line: 18,
            column: 2
          },
          end: {
            line: 18,
            column: 28
          }
        }, {
          start: {
            line: 19,
            column: 2
          },
          end: {
            line: 19,
            column: 37
          }
        }, {
          start: {
            line: 20,
            column: 2
          },
          end: {
            line: 20,
            column: 37
          }
        }, {
          start: {
            line: 21,
            column: 2
          },
          end: {
            line: 21,
            column: 34
          }
        }, {
          start: {
            line: 22,
            column: 2
          },
          end: {
            line: 22,
            column: 37
          }
        }, {
          start: {
            line: 23,
            column: 2
          },
          end: {
            line: 23,
            column: 34
          }
        }, {
          start: {
            line: 24,
            column: 2
          },
          end: {
            line: 24,
            column: 34
          }
        }, {
          start: {
            line: 25,
            column: 2
          },
          end: {
            line: 25,
            column: 35
          }
        }, {
          start: {
            line: 26,
            column: 2
          },
          end: {
            line: 26,
            column: 36
          }
        }],
        line: 18
      },
      "1": {
        loc: {
          start: {
            line: 38,
            column: 2
          },
          end: {
            line: 43,
            column: 36
          }
        },
        type: "binary-expr",
        locations: [{
          start: {
            line: 38,
            column: 2
          },
          end: {
            line: 38,
            column: 28
          }
        }, {
          start: {
            line: 39,
            column: 2
          },
          end: {
            line: 39,
            column: 42
          }
        }, {
          start: {
            line: 40,
            column: 2
          },
          end: {
            line: 40,
            column: 33
          }
        }, {
          start: {
            line: 41,
            column: 2
          },
          end: {
            line: 41,
            column: 37
          }
        }, {
          start: {
            line: 42,
            column: 2
          },
          end: {
            line: 42,
            column: 42
          }
        }, {
          start: {
            line: 43,
            column: 2
          },
          end: {
            line: 43,
            column: 36
          }
        }],
        line: 38
      },
      "2": {
        loc: {
          start: {
            line: 55,
            column: 2
          },
          end: {
            line: 56,
            column: 32
          }
        },
        type: "binary-expr",
        locations: [{
          start: {
            line: 55,
            column: 2
          },
          end: {
            line: 55,
            column: 28
          }
        }, {
          start: {
            line: 56,
            column: 2
          },
          end: {
            line: 56,
            column: 32
          }
        }],
        line: 55
      }
    },
    s: {
      "0": 0,
      "1": 0,
      "2": 0,
      "3": 0,
      "4": 0,
      "5": 0
    },
    f: {
      "0": 0,
      "1": 0,
      "2": 0,
      "3": 0,
      "4": 0
    },
    b: {
      "0": [0, 0, 0, 0, 0, 0, 0, 0, 0],
      "1": [0, 0, 0, 0, 0, 0],
      "2": [0, 0]
    },
    _coverageSchema: "1a1c01bbd47fc00a2c39e90264f33305004495a9",
    hash: "59cf56b6bdcb176792387a7c8f013e5a5db59a40"
  };
  var coverage = global[gcv] || (global[gcv] = {});

  if (!coverage[path] || coverage[path].hash !== hash) {
    coverage[path] = coverageData;
  }

  var actualCoverage = coverage[path];

  cov_20h2bmyl99 = function () {
    return actualCoverage;
  };

  return actualCoverage;
}

cov_20h2bmyl99();

/**
 * Is.js
 *
 * Object type checks.
 */
const NAME = (cov_20h2bmyl99().s[0]++, Symbol.toStringTag);
/**
 * Check if `obj` is a URLSearchParams object
 * ref: https://github.com/node-fetch/node-fetch/issues/296#issuecomment-307598143
 *
 * @param  {*} obj
 * @return {boolean}
 */

function isURLSearchParams(object) {
  cov_20h2bmyl99().f[0]++;
  cov_20h2bmyl99().s[1]++;
  return (cov_20h2bmyl99().b[0][0]++, typeof object === 'object') && (cov_20h2bmyl99().b[0][1]++, typeof object.append === 'function') && (cov_20h2bmyl99().b[0][2]++, typeof object.delete === 'function') && (cov_20h2bmyl99().b[0][3]++, typeof object.get === 'function') && (cov_20h2bmyl99().b[0][4]++, typeof object.getAll === 'function') && (cov_20h2bmyl99().b[0][5]++, typeof object.has === 'function') && (cov_20h2bmyl99().b[0][6]++, typeof object.set === 'function') && (cov_20h2bmyl99().b[0][7]++, typeof object.sort === 'function') && (cov_20h2bmyl99().b[0][8]++, object[NAME] === 'URLSearchParams');
}
/**
 * Check if `obj` is a W3C `Blob` object (which `File` inherits from)
 *
 * @param  {*} obj
 * @return {boolean}
 */


function isBlob(object) {
  cov_20h2bmyl99().f[1]++;
  cov_20h2bmyl99().s[2]++;
  return (cov_20h2bmyl99().b[1][0]++, typeof object === 'object') && (cov_20h2bmyl99().b[1][1]++, typeof object.arrayBuffer === 'function') && (cov_20h2bmyl99().b[1][2]++, typeof object.type === 'string') && (cov_20h2bmyl99().b[1][3]++, typeof object.stream === 'function') && (cov_20h2bmyl99().b[1][4]++, typeof object.constructor === 'function') && (cov_20h2bmyl99().b[1][5]++, /^(Blob|File)$/.test(object[NAME]));
}
/**
 * Check if `obj` is an instance of AbortSignal.
 *
 * @param  {*} obj
 * @return {boolean}
 */


function isAbortSignal(object) {
  cov_20h2bmyl99().f[2]++;
  cov_20h2bmyl99().s[3]++;
  return (cov_20h2bmyl99().b[2][0]++, typeof object === 'object') && (cov_20h2bmyl99().b[2][1]++, object[NAME] === 'AbortSignal');
}
/**
 * Check if `obj` is an instance of ArrayBuffer.
 *
 * @param  {*} obj
 * @return {boolean}
 */


function isArrayBuffer(object) {
  cov_20h2bmyl99().f[3]++;
  cov_20h2bmyl99().s[4]++;
  return object[NAME] === 'ArrayBuffer';
}
/**
 * Check if `obj` is an instance of AbortError.
 *
 * @param  {*} obj
 * @return {boolean}
 */


function isAbortError(object) {
  cov_20h2bmyl99().f[4]++;
  cov_20h2bmyl99().s[5]++;
  return object[NAME] === 'AbortError';
}