// Generated by CoffeeScript 1.8.0
(function() {
  var LocalStorage, QUOTA_EXCEEDED_ERR, fs, path, _emptyDirectory, _rm,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  path = require('path');

  fs = require('fs');

  _emptyDirectory = function(target) {
    var p, _i, _len, _ref, _results;
    _ref = fs.readdirSync(target);
    _results = [];
    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
      p = _ref[_i];
      _results.push(_rm(path.join(target, p)));
    }
    return _results;
  };

  _rm = function(target) {
    if (fs.statSync(target).isDirectory()) {
      _emptyDirectory(target);
      return fs.rmdirSync(target);
    } else {
      return fs.unlinkSync(target);
    }
  };

  QUOTA_EXCEEDED_ERR = (function(_super) {
    __extends(QUOTA_EXCEEDED_ERR, _super);

    function QUOTA_EXCEEDED_ERR(message) {
      this.message = message != null ? message : 'Unknown error.';
      if (Error.captureStackTrace != null) {
        Error.captureStackTrace(this, this.constructor);
      }
      this.name = this.constructor.name;
    }

    QUOTA_EXCEEDED_ERR.prototype.toString = function() {
      return "" + this.name + ": " + this.message;
    };

    return QUOTA_EXCEEDED_ERR;

  })(Error);

  LocalStorage = (function() {
    function LocalStorage(location, quota) {
      this.location = location;
      this.quota = quota != null ? quota : 5 * 1024 * 1024;
      if (!(this instanceof LocalStorage)) {
        return new LocalStorage(this.location, this.quota);
      }
      this.length = 0;
      this.bytesInUse = 0;
      this.keys = [];
      this._init();
      this.QUOTA_EXCEEDED_ERR = QUOTA_EXCEEDED_ERR;
    }

    LocalStorage.prototype._init = function() {
      var k, value, _i, _len, _ref, _results;
      if (fs.existsSync(this.location)) {
        if (!fs.statSync(this.location).isDirectory()) {
          throw new Error("A file exists at the location '" + this.location + "' when trying to create/open localStorage");
        }
      }
      if (!fs.existsSync(this.location)) {
        fs.mkdirSync(this.location);
      }
      this.keys = fs.readdirSync(this.location).map(decodeURIComponent);
      this.length = this.keys.length;
      this.bytesInUse = 0;
      _ref = this.keys;
      _results = [];
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        k = _ref[_i];
        value = this.getItem(k);
        if ((value != null ? value.length : void 0) != null) {
          _results.push(this.bytesInUse += value.length);
        } else {
          _results.push(void 0);
        }
      }
      return _results;
    };

    LocalStorage.prototype.setItem = function(key, value) {
      var existsBeforeSet, filename, oldLength, valueString, valueStringLength;
      key = key.toString();
      filename = path.join(this.location, encodeURIComponent(key));
      existsBeforeSet = fs.existsSync(filename);
      valueString = value.toString();
      valueStringLength = valueString.length;
      if (existsBeforeSet) {
        oldLength = this.getItem(key).length;
      } else {
        oldLength = 0;
      }
      if (this.bytesInUse - oldLength + valueStringLength > this.quota) {
        throw new QUOTA_EXCEEDED_ERR();
      }
      fs.writeFileSync(filename, valueString, 'utf8');
      if (!existsBeforeSet) {
        this.keys.push(key);
        this.length = this.keys.length;
        return this.bytesInUse += valueStringLength;
      }
    };

    LocalStorage.prototype.getItem = function(key) {
      var filename;
      key = key.toString();
      filename = path.join(this.location, encodeURIComponent(key));
      if (fs.existsSync(filename)) {
        return fs.readFileSync(filename, 'utf8');
      } else {
        return null;
      }
    };

    LocalStorage.prototype.removeItem = function(key) {
      var filename;
      key = key.toString();
      filename = path.join(this.location, encodeURIComponent(key));
      if (fs.existsSync(filename)) {
        _rm(filename);
      }
      return this._init();
    };

    LocalStorage.prototype.key = function(n) {
      return this.keys[n];
    };

    LocalStorage.prototype.clear = function() {
      _emptyDirectory(this.location);
      this.keys = [];
      this.length = 0;
      return this.bytesInUse = 0;
    };

    LocalStorage.prototype.getBytesInUse = function() {
      return this.bytesInUse;
    };

    LocalStorage.prototype._deleteLocation = function() {
      _rm(this.location);
      this.keys = [];
      this.length = 0;
      return this.bytesInUse = 0;
    };

    return LocalStorage;

  })();

  exports.LocalStorage = LocalStorage;

  exports.QUOTA_EXCEEDED_ERR = QUOTA_EXCEEDED_ERR;

}).call(this);
