(function (global, factory) {
  if (typeof define === "function" && define.amd) {
    define(["exports", "./util", "./expr"], factory);
  } else if (typeof exports !== "undefined") {
    factory(exports, require("./util"), require("./expr"));
  } else {
    var mod = {
      exports: {}
    };
    factory(mod.exports, global.util, global.expr);
    global.indexDefinition = mod.exports;
  }
})(typeof globalThis !== "undefined" ? globalThis : typeof self !== "undefined" ? self : this, function (_exports, _util, _expr) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.indexDefinitionToSQL = indexDefinitionToSQL;
  _exports.indexOptionListToSQL = indexOptionListToSQL;
  _exports.indexOptionToSQL = indexOptionToSQL;
  _exports.indexTypeAndOptionToSQL = indexTypeAndOptionToSQL;
  _exports.indexTypeToSQL = indexTypeToSQL;
  function indexTypeToSQL(indexType) {
    if (!indexType) return [];
    const {
      keyword,
      type
    } = indexType;
    return [keyword.toUpperCase(), (0, _util.toUpper)(type)];
  }
  function indexOptionToSQL(indexOpt) {
    if (!indexOpt) return;
    const {
      type,
      expr,
      symbol
    } = indexOpt;
    const upperType = type.toUpperCase();
    const indexOptArray = [];
    indexOptArray.push(upperType);
    switch (upperType) {
      case 'KEY_BLOCK_SIZE':
        if (symbol) indexOptArray.push(symbol);
        indexOptArray.push((0, _util.literalToSQL)(expr));
        break;
      case 'BTREE':
      case 'HASH':
        indexOptArray.length = 0;
        indexOptArray.push(...indexTypeToSQL(indexOpt));
        break;
      case 'WITH PARSER':
        indexOptArray.push(expr);
        break;
      case 'VISIBLE':
      case 'INVISIBLE':
        break;
      case 'COMMENT':
        indexOptArray.shift();
        indexOptArray.push((0, _util.commentToSQL)(indexOpt));
        break;
      case 'DATA_COMPRESSION':
        indexOptArray.push(symbol, (0, _util.toUpper)(expr.value), (0, _util.onPartitionsToSQL)(expr.on));
        break;
      default:
        indexOptArray.push(symbol, (0, _util.literalToSQL)(expr));
        break;
    }
    return indexOptArray.filter(_util.hasVal).join(' ');
  }
  function indexOptionListToSQL(indexOptList) {
    if (!indexOptList) return [];
    return indexOptList.map(indexOptionToSQL);
  }
  function indexTypeAndOptionToSQL(indexDefinition) {
    const {
      constraint_type: constraintType,
      index_type: indexType,
      index_options: indexOptions = [],
      definition,
      on,
      with: withExpr
    } = indexDefinition;
    const dataType = [];
    dataType.push(...indexTypeToSQL(indexType));
    if (definition && definition.length) {
      const definitionSQL = (0, _util.toUpper)(constraintType) === 'CHECK' ? `(${(0, _expr.exprToSQL)(definition[0])})` : `(${definition.map(col => (0, _expr.exprToSQL)(col)).join(', ')})`;
      dataType.push(definitionSQL);
    }
    dataType.push(indexOptionListToSQL(indexOptions).join(' '));
    if (withExpr) dataType.push(`WITH (${indexOptionListToSQL(withExpr).join(', ')})`);
    if (on) dataType.push(`ON [${on}]`);
    return dataType;
  }
  function indexDefinitionToSQL(indexDefinition) {
    const indexSQL = [];
    const {
      keyword,
      index
    } = indexDefinition;
    indexSQL.push((0, _util.toUpper)(keyword));
    indexSQL.push(index);
    indexSQL.push(...indexTypeAndOptionToSQL(indexDefinition));
    return indexSQL.filter(_util.hasVal).join(' ');
  }
});