(function (global, factory) {
  if (typeof define === "function" && define.amd) {
    define(["exports", "./expr", "./limit", "./tables", "./util"], factory);
  } else if (typeof exports !== "undefined") {
    factory(exports, require("./expr"), require("./limit"), require("./tables"), require("./util"));
  } else {
    var mod = {
      exports: {}
    };
    factory(mod.exports, global.expr, global.limit, global.tables, global.util);
    global.show = mod.exports;
  }
})(typeof globalThis !== "undefined" ? globalThis : typeof self !== "undefined" ? self : this, function (_exports, _expr, _limit, _tables, _util) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.showToSQL = showToSQL;
  function showEventToSQL(showEventExpr) {
    const {
      in: inClause,
      from,
      limit
    } = showEventExpr;
    return [(0, _util.commonOptionConnector)('IN', _util.literalToSQL, inClause && inClause.right), (0, _util.commonOptionConnector)('FROM', _tables.tablesToSQL, from), (0, _limit.limitToSQL)(limit)].filter(_util.hasVal).join(' ');
  }
  function showLikeAndWhereToSQL(showCharacterSetExpr) {
    const {
      expr
    } = showCharacterSetExpr;
    if (!expr) return;
    const {
      op
    } = expr;
    if ((0, _util.toUpper)(op) === 'LIKE') return (0, _util.commonOptionConnector)('LIKE', _util.literalToSQL, expr.right);
    return (0, _util.commonOptionConnector)('WHERE', _expr.exprToSQL, expr);
  }
  function showGrantsForUser(showGrantsForExpr) {
    const {
      for: forExpr
    } = showGrantsForExpr;
    if (!forExpr) return;
    const {
      user,
      host,
      role_list
    } = forExpr;
    let userAndHost = `'${user}'`;
    if (host) userAndHost += `@'${host}'`;
    return ['FOR', userAndHost, role_list && 'USING', role_list && role_list.map(role => `'${role}'`).join(', ')].filter(_util.hasVal).join(' ');
  }
  function showToSQL(showExpr) {
    let {
      keyword
    } = showExpr;
    const {
      suffix
    } = showExpr;
    let str = '';
    switch ((0, _util.toUpper)(keyword)) {
      case 'BINLOG':
        str = showEventToSQL(showExpr);
        break;
      case 'CHARACTER':
      case 'COLLATION':
        str = showLikeAndWhereToSQL(showExpr);
        break;
      case 'COLUMNS':
      case 'INDEXES':
      case 'INDEX':
        str = (0, _util.commonOptionConnector)('FROM', _tables.tablesToSQL, showExpr.from);
        break;
      case 'GRANTS':
        str = showGrantsForUser(showExpr);
        break;
      case 'CREATE':
        str = (0, _util.commonOptionConnector)('', _tables.tableToSQL, showExpr[suffix]);
        break;
      case 'VAR':
        str = (0, _expr.varToSQL)(showExpr.var);
        keyword = '';
        break;
      default:
        break;
    }
    return ['SHOW', (0, _util.toUpper)(keyword), (0, _util.toUpper)(suffix), str].filter(_util.hasVal).join(' ');
  }
});