'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.normalizeConfig = exports.readdir = exports.stat = undefined;

var normalizeConfig = exports.normalizeConfig = function () {
  var _ref = _asyncToGenerator(function* (givenConfig) {
    var config = Object.assign({}, givenConfig);
    if (config.username && typeof config.username !== 'string') {
      throw new Error('config.username must be a valid string');
    }
    if (typeof config.host !== 'string' || !config.host) {
      throw new Error('config.host must be a valid string');
    }
    if (config.privateKey) {
      var privateKey = config.privateKey;
      if (typeof privateKey !== 'string') {
        throw new Error('config.privateKey must be a string');
      }
      if (!(privateKey.includes('BEGIN') && privateKey.includes('KEY'))) {
        try {
          config.privateKey = yield readFile(privateKey, 'utf8');
        } catch (error) {
          if (error.code === 'ENOENT') {
            throw new Error('config.privateKey does not exist at ' + privateKey);
          }
          throw error;
        }
      }
    } else if (config.password) {
      var password = config.password;
      if (typeof password !== 'string') {
        throw new Error('config.password must be a string');
      }
      config.password = password;
    }
    return config;
  });

  return function normalizeConfig(_x) {
    return _ref.apply(this, arguments);
  };
}();

exports.normalizePutDirectoryConfig = normalizePutDirectoryConfig;
exports.exists = exists;
exports.generateCallback = generateCallback;

var _fs = require('fs');

var _fs2 = _interopRequireDefault(_fs);

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _sbPromisify = require('sb-promisify');

var _sbPromisify2 = _interopRequireDefault(_sbPromisify);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { return step("next", value); }, function (err) { return step("throw", err); }); } } return step("next"); }); }; }

var stat = exports.stat = (0, _sbPromisify2.default)(_fs2.default.stat);
var readFile = (0, _sbPromisify2.default)(_fs2.default.readFile);
var readdir = exports.readdir = (0, _sbPromisify2.default)(_fs2.default.readdir);

function normalizePutDirectoryConfig(givenConfig) {
  var config = Object.assign({}, givenConfig);
  if (config.tick) {
    if (typeof config.tick !== 'function') {
      throw new Error('config.tick must be a function');
    }
  } else {
    config.tick = function () {};
  }
  if (config.validate) {
    if (typeof config.validate !== 'function') {
      throw new Error('config.validate must be a function');
    }
  } else {
    config.validate = function (path) {
      return _path2.default.basename(path).substr(0, 1) !== '.';
    };
  }
  config.recursive = {}.hasOwnProperty.call(config, 'recursive') ? !!config.recursive : true;
  return config;
}

function exists(filePath) {
  return new Promise(function (resolve) {
    _fs2.default.access(filePath, _fs2.default.R_OK, function (error) {
      resolve(!error);
    });
  });
}

function generateCallback(resolve, reject) {
  return function (error, result) {
    if (error) {
      reject(error);
    } else {
      resolve(result);
    }
  };
}