'use strict';

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol ? "symbol" : typeof obj; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _ssh = require('ssh2');

var _ssh2 = _interopRequireDefault(_ssh);

var _assert = require('assert');

var _assert2 = _interopRequireDefault(_assert);

var _sbScandir = require('sb-scandir');

var _sbScandir2 = _interopRequireDefault(_sbScandir);

var _shellEscape = require('shell-escape');

var _shellEscape2 = _interopRequireDefault(_shellEscape);

var _helpers = require('./helpers');

var Helpers = _interopRequireWildcard(_helpers);

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { return step("next", value); }, function (err) { return step("throw", err); }); } } return step("next"); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var SSH = function () {
  function SSH() {
    _classCallCheck(this, SSH);

    this.connection = null;
  }

  _createClass(SSH, [{
    key: 'connect',
    value: function connect(givenConfig) {
      var _this = this;

      var connection = this.connection = new _ssh2.default();
      return new Promise(function (resolve) {
        resolve(Helpers.normalizeConfig(givenConfig));
      }).then(function (config) {
        return new Promise(function (resolve, reject) {
          connection.on('error', reject);
          connection.on('ready', function () {
            connection.removeListener('error', reject);
            resolve(_this);
          });
          connection.on('end', function () {
            if (_this.connection === connection) {
              _this.connection = null;
            }
          });
          connection.connect(config);
        });
      });
    }
  }, {
    key: 'requestShell',
    value: function () {
      var _ref = _asyncToGenerator(function* () {
        var connection = this.connection;
        (0, _assert2.default)(connection, 'Not connected to server');
        return yield new Promise(function (resolve, reject) {
          connection.shell(Helpers.generateCallback(resolve, reject));
        });
      });

      function requestShell() {
        return _ref.apply(this, arguments);
      }

      return requestShell;
    }()
  }, {
    key: 'requestSFTP',
    value: function () {
      var _ref2 = _asyncToGenerator(function* () {
        var connection = this.connection;
        (0, _assert2.default)(connection, 'Not connected to server');
        return yield new Promise(function (resolve, reject) {
          connection.sftp(Helpers.generateCallback(resolve, reject));
        });
      });

      function requestSFTP() {
        return _ref2.apply(this, arguments);
      }

      return requestSFTP;
    }()
  }, {
    key: 'mkdir',
    value: function () {
      var _ref3 = _asyncToGenerator(function* (path) {
        (0, _assert2.default)(this.connection, 'Not connected to server');
        var output = yield this.exec('mkdir', ['-p', path]);
        if (output.stdout) {
          throw new Error(output.stdout);
        }
      });

      function mkdir(_x) {
        return _ref3.apply(this, arguments);
      }

      return mkdir;
    }()
  }, {
    key: 'exec',
    value: function () {
      var _ref4 = _asyncToGenerator(function* (command) {
        var parameters = arguments.length <= 1 || arguments[1] === undefined ? [] : arguments[1];
        var options = arguments.length <= 2 || arguments[2] === undefined ? {} : arguments[2];

        (0, _assert2.default)(this.connection, 'Not connected to server');
        (0, _assert2.default)((typeof options === 'undefined' ? 'undefined' : _typeof(options)) === 'object' && options, 'options must be an Object');
        (0, _assert2.default)(!options.cwd || typeof options.cwd === 'string', 'options.cwd must be a string');
        (0, _assert2.default)(!options.stdin || typeof options.stdin === 'string', 'options.stdin must be a string');
        (0, _assert2.default)(!options.stream || ['stdout', 'stderr', 'both'].indexOf(options.stream) !== -1, 'options.stream must be among "stdout", "stderr" and "both"');
        var output = yield this.execCommand([command].concat((0, _shellEscape2.default)(parameters)).join(' '), options);
        if (!options.stream || options.stream === 'stdout') {
          if (output.stderr) {
            throw new Error(output.stderr);
          }
          return output.stdout;
        }
        if (options.stream === 'stderr') {
          return output.stderr;
        }
        return output;
      });

      function exec(_x2, _x3, _x4) {
        return _ref4.apply(this, arguments);
      }

      return exec;
    }()
  }, {
    key: 'execCommand',
    value: function () {
      var _ref5 = _asyncToGenerator(function* (givenCommand) {
        var options = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];

        var command = givenCommand;
        var connection = this.connection;
        (0, _assert2.default)(connection, 'Not connected to server');
        (0, _assert2.default)((typeof options === 'undefined' ? 'undefined' : _typeof(options)) === 'object' && options, 'options must be an Object');
        (0, _assert2.default)(!options.cwd || typeof options.cwd === 'string', 'options.cwd must be a string');
        (0, _assert2.default)(!options.stdin || typeof options.stdin === 'string', 'options.stdin must be a string');

        if (options.cwd) {
          // NOTE: Output piping cd command to hide directory non-existent errors
          command = 'cd ' + (0, _shellEscape2.default)([options.cwd]) + ' 1> /dev/null 2> /dev/null; ' + command;
        }
        var output = { stdout: [], stderr: [] };
        return yield new Promise(function (resolve, reject) {
          connection.exec(command, Helpers.generateCallback(function (stream) {
            stream.on('data', function (chunk) {
              output.stdout.push(chunk);
            });
            stream.stderr.on('data', function (chunk) {
              output.stderr.push(chunk);
            });
            if (options.stdin) {
              stream.write(options.stdin);
              stream.end();
            }
            stream.on('close', function (code, signal) {
              resolve({ code: code, signal: signal, stdout: output.stdout.join('').trim(), stderr: output.stderr.join('').trim() });
            });
          }, reject));
        });
      });

      function execCommand(_x7, _x8) {
        return _ref5.apply(this, arguments);
      }

      return execCommand;
    }()
  }, {
    key: 'getFile',
    value: function () {
      var _ref6 = _asyncToGenerator(function* (localFile, remoteFile) {
        var givenSftp = arguments.length <= 2 || arguments[2] === undefined ? null : arguments[2];

        (0, _assert2.default)(this.connection, 'Not connected to server');
        (0, _assert2.default)(typeof localFile === 'string' && localFile, 'localFile must be a string');
        (0, _assert2.default)(typeof remoteFile === 'string' && remoteFile, 'remoteFile must be a string');
        (0, _assert2.default)(!givenSftp || (typeof givenSftp === 'undefined' ? 'undefined' : _typeof(givenSftp)) === 'object', 'sftp must be an object');

        var sftp = givenSftp || (yield this.requestSFTP());
        try {
          yield new Promise(function (resolve, reject) {
            sftp.fastGet(localFile, remoteFile, Helpers.generateCallback(resolve, reject));
          });
        } finally {
          if (!givenSftp) {
            sftp.end();
          }
        }
      });

      function getFile(_x10, _x11, _x12) {
        return _ref6.apply(this, arguments);
      }

      return getFile;
    }()
  }, {
    key: 'putFile',
    value: function () {
      var _ref7 = _asyncToGenerator(function* (localFile, remoteFile) {
        var givenSftp = arguments.length <= 2 || arguments[2] === undefined ? null : arguments[2];

        (0, _assert2.default)(this.connection, 'Not connected to server');
        (0, _assert2.default)(typeof localFile === 'string' && localFile, 'localFile must be a string');
        (0, _assert2.default)(typeof remoteFile === 'string' && remoteFile, 'remoteFile must be a string');
        (0, _assert2.default)(!givenSftp || (typeof givenSftp === 'undefined' ? 'undefined' : _typeof(givenSftp)) === 'object', 'sftp must be an object');
        (0, _assert2.default)((yield Helpers.exists(localFile)), 'localFile does not exist at ' + localFile);

        var that = this;
        var sftp = givenSftp || (yield this.requestSFTP());

        function putFile(retry) {
          return new Promise(function (resolve, reject) {
            sftp.fastPut(localFile, remoteFile, Helpers.generateCallback(resolve, function (error) {
              if (error.message === 'No such file' && retry) {
                resolve(that.mkdir(_path2.default.dirname(remoteFile)).then(function () {
                  return putFile(false);
                }));
              } else {
                reject(error);
              }
            }));
          });
        }

        try {
          yield putFile(true);
        } finally {
          if (!givenSftp) {
            sftp.end();
          }
        }
      });

      function putFile(_x14, _x15, _x16) {
        return _ref7.apply(this, arguments);
      }

      return putFile;
    }()
  }, {
    key: 'putFiles',
    value: function () {
      var _ref8 = _asyncToGenerator(function* (files) {
        var _this2 = this;

        var givenSftp = arguments.length <= 1 || arguments[1] === undefined ? null : arguments[1];

        (0, _assert2.default)(this.connection, 'Not connected to server');
        (0, _assert2.default)(!givenSftp || (typeof givenSftp === 'undefined' ? 'undefined' : _typeof(givenSftp)) === 'object', 'sftp must be an object');
        (0, _assert2.default)(Array.isArray(files), 'files must be an array');

        for (var i = 0, length = files.length; i < length; ++i) {
          var file = files[i];
          (0, _assert2.default)(file, 'files items must be valid objects');
          (0, _assert2.default)(file.local && typeof file.local === 'string', 'files[' + i + '].local must be a string');
          (0, _assert2.default)(file.remote && typeof file.remote === 'string', 'files[' + i + '].remote must be a string');
        }

        var sftp = givenSftp || (yield this.requestSFTP());
        var promises = files.map(function (file) {
          return _this2.putFile(file.local, file.remote, sftp);
        });
        try {
          yield Promise.all(promises);
        } finally {
          if (!sftp) {
            sftp.end();
          }
        }
      });

      function putFiles(_x18, _x19) {
        return _ref8.apply(this, arguments);
      }

      return putFiles;
    }()
  }, {
    key: 'putDirectory',
    value: function () {
      var _ref9 = _asyncToGenerator(function* (localDirectory, remoteDirectory) {
        var _this3 = this;

        var givenConfig = arguments.length <= 2 || arguments[2] === undefined ? {} : arguments[2];
        var givenSftp = arguments.length <= 3 || arguments[3] === undefined ? null : arguments[3];

        (0, _assert2.default)(this.connection, 'Not connected to server');
        (0, _assert2.default)(typeof localDirectory === 'string' && localDirectory, 'localDirectory must be a string');
        (0, _assert2.default)(typeof remoteDirectory === 'string' && remoteDirectory, 'localDirectory must be a string');
        (0, _assert2.default)((yield Helpers.exists(localDirectory)), 'localDirectory does not exist at ' + localDirectory);
        (0, _assert2.default)((yield Helpers.stat(localDirectory)).isDirectory(), 'localDirectory is not a directory at ' + localDirectory);
        (0, _assert2.default)((typeof givenConfig === 'undefined' ? 'undefined' : _typeof(givenConfig)) === 'object' && givenConfig, 'config must be an object');

        var sftp = givenSftp || (yield this.requestSFTP());
        var config = Helpers.normalizePutDirectoryConfig(givenConfig);
        var files = (yield (0, _sbScandir2.default)(localDirectory, config.recursive, config.validate)).map(function (item) {
          return _path2.default.relative(localDirectory, item);
        });
        var directoriesCreated = new Set();

        var promises = files.map(function () {
          var _ref10 = _asyncToGenerator(function* (file) {
            var localFile = _path2.default.join(localDirectory, file);
            var remoteFile = _path2.default.join(remoteDirectory, file).split(_path2.default.sep).join('/');
            var remoteFileDirectory = _path2.default.dirname(remoteFile);
            if (!directoriesCreated.has(remoteFileDirectory)) {
              yield _this3.mkdir(remoteFileDirectory);
              directoriesCreated.add(remoteFileDirectory);
            }
            try {
              yield _this3.putFile(localFile, remoteFile, sftp);
              config.tick(localFile, remoteFile, null);
              return true;
            } catch (_) {
              config.tick(localFile, remoteFile, _);
              return false;
            }
          });

          return function (_x27) {
            return _ref10.apply(this, arguments);
          };
        }());

        var results = void 0;
        try {
          results = yield Promise.all(promises);
        } finally {
          if (!givenSftp) {
            sftp.end();
          }
        }

        return results.every(function (i) {
          return i;
        });
      });

      function putDirectory(_x21, _x22, _x23, _x24) {
        return _ref9.apply(this, arguments);
      }

      return putDirectory;
    }()
  }, {
    key: 'dispose',
    value: function dispose() {
      if (this.connection) {
        this.connection.end();
      }
    }
  }]);

  return SSH;
}();

module.exports = SSH;