var ColorCut, ColorCutQuantizer, Quantizer, Swatch,
  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

Swatch = require('../swatch');

Quantizer = require('./index');

ColorCut = require('./impl/color-cut');

module.exports = ColorCutQuantizer = (function(superClass) {
  extend(ColorCutQuantizer, superClass);

  function ColorCutQuantizer() {
    return ColorCutQuantizer.__super__.constructor.apply(this, arguments);
  }

  ColorCutQuantizer.prototype.initialize = function(pixels, opts) {
    var buf, buf8, data;
    this.opts = opts;
    buf = new ArrayBuffer(pixels.length);
    buf8 = new Uint8ClampedArray(buf);
    data = new Uint32Array(buf);
    buf8.set(pixels);
    return this.quantizer = new ColorCut(data, this.opts);
  };

  ColorCutQuantizer.prototype.getQuantizedColors = function() {
    return this.quantizer.getQuantizedColors();
  };

  return ColorCutQuantizer;

})(Quantizer);
