import { calendar } from '../../calendar/index.js';
import { mockCalendarData } from './mocks/calendar.js';
test.each([
    [`void`, void 0],
    [`null`, null],
])(`calendar (%s)`, (_, a) => {
    try {
        calendar(a);
    }
    catch (e) {
        expect(e.name).toStrictEqual(TypeError.name);
        expect(e.message).toMatch('getUTCFullYear');
    }
});
test.each(mockCalendarData)(`calendar(%s)`, (_, a, expected) => {
    const d = calendar(a);
    expect({
        ...d,
        calendar: [
            d.calendar[0],
            d.calendar[4],
            d.calendar[5],
        ],
    }).toEqual(expected);
});
//# sourceMappingURL=calendar.spec.js.map