import { getFormatter } from '../../../calendar/index.js';
test.each([
    [`void`, void 0],
    [`null`, null],
])(`formatter (%s)`, (_, a) => {
    expect(getFormatter(a)).toThrowError(TypeError);
});
test.each([
    [`Intl.DateTimeFormat`, Intl.DateTimeFormat('ja-JP', { day: 'numeric' }), new Date('2020-02-02'), '2日'],
])(`formatter (%s)`, (_, a, b, expected) => {
    const d = getFormatter(a)(b);
    expect(d).toStrictEqual(expected);
});
//# sourceMappingURL=get-formatter.spec.js.map