import { getWeekNumber } from '../../../calendar/index.js';
test.each([
    [`void, void`, [void 0, void 0]],
    [`void, null`, [void 0, null]],
    [`null, void`, [null, void 0]],
    [`null, null`, [null, null]],
])(`week number (%s)`, (_, a) => {
    try {
        getWeekNumber(...a);
    }
    catch (e) {
        expect(e.name).toStrictEqual(TypeError.name);
        expect(e.message).toMatch('Cannot read property');
    }
});
test.each([
    ['2010-01-01', [52, 1, 52, 1]],
    ['2011-01-01', [52, 1, 52, 1]],
    ['2012-01-01', [1, 1, 1, 1]],
    ['2013-01-01', [53, 1, 1, 1]],
    ['2014-01-01', [52, 1, 1, 1]],
    ['2015-01-01', [52, 1, 53, 1]],
    ['2016-01-01', [52, 1, 52, 1]],
    ['2017-01-01', [1, 1, 1, 1]],
    ['2018-01-01', [53, 1, 1, 1]],
    ['2019-01-01', [52, 1, 1, 1]],
    ['2020-01-01', [52, 1, 1, 1]],
    ['2010-12-31', [52, 1, 52, 53]],
    ['2011-12-31', [52, 53, 52, 53]],
    ['2012-12-31', [53, 1, 1, 53]],
    ['2013-12-31', [52, 1, 1, 53]],
    ['2014-12-31', [52, 1, 53, 53]],
    ['2015-12-31', [52, 1, 52, 53]],
    ['2016-12-31', [52, 53, 52, 53]],
    ['2017-12-31', [53, 1, 1, 53]],
    ['2018-12-31', [52, 1, 1, 53]],
    ['2019-12-31', [52, 1, 1, 53]],
    ['2020-12-31', [52, 1, 53, 53]],
])(`week number (%s, ...)`, (a, expected) => {
    const d = [
        'first-full-week',
        'first-day-of-year',
        'first-4-day-week',
        null,
    ].map(n => getWeekNumber(n, new Date(a)));
    expect(d).toEqual(expected);
});
//# sourceMappingURL=get-week-number.spec.js.map