import { getWeekdays } from '../../../calendar/index.js';
import { mockGetWeekdaysData } from '../mocks/get-weekdays.js';
test.each([
    [`void`, void 0],
    [`null`, null],
])(`weekdays (%s)`, (_, a) => {
    try {
        getWeekdays(a);
    }
    catch (e) {
        expect(e.name).toStrictEqual(TypeError.name);
        expect(e.message).toMatch('longWeekdayFormat');
    }
});
test.each(mockGetWeekdaysData)(`weekdays (%s)`, (_, a, expected) => {
    const d = getWeekdays(a);
    expect(d).toStrictEqual(expected);
});
//# sourceMappingURL=get-weekdays.spec.js.map