import { toUTCDate } from '../../../calendar/index.js';
test.each([
    [`void, void, void`, [void 0, void 0, void 0], new Date(undefined)],
    [`null, null, null`, [null, null, null], new Date('1899-12-31')],
    [`2020, 1, 2`, [2020, 1, 2], new Date('2020-02-02')],
    [`'2020', '1', '2'`, ['2020', '1', '2'], new Date('2020-02-02')],
])(`utc date (%s)`, (_, a, expected) => {
    const d = toUTCDate(...a);
    if (Number.isNaN(+expected)) {
        expect(d instanceof Date && Number.isNaN(+d)).toStrictEqual(true);
    }
    else {
        expect(d).toStrictEqual(expected);
    }
});
//# sourceMappingURL=to-utc-date.spec.js.map