import { getFormatter } from '../../../calendar/index.js';
export const mockCalendarData = [
    [
        `{ date: new Date('2020-02-02'), locale: 'ja-JP' }`,
        {
            dayFormat: getFormatter(Intl.DateTimeFormat('ja-JP', { day: 'numeric' })),
            fullDateFormat: getFormatter(Intl.DateTimeFormat('ja-JP', { year: 'numeric', month: 'short', day: 'numeric' })),
            locale: 'ja-JP',
            date: new Date('2020-02-02'),
        },
        {
            calendar: [
                [
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: new Date('2020-02-01T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月1日',
                        value: '1日',
                    },
                ],
                [
                    {
                        fullDate: new Date('2020-02-23T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月23日',
                        value: '23日',
                    },
                    {
                        fullDate: new Date('2020-02-24T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月24日',
                        value: '24日',
                    },
                    {
                        fullDate: new Date('2020-02-25T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月25日',
                        value: '25日',
                    },
                    {
                        fullDate: new Date('2020-02-26T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月26日',
                        value: '26日',
                    },
                    {
                        fullDate: new Date('2020-02-27T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月27日',
                        value: '27日',
                    },
                    {
                        fullDate: new Date('2020-02-28T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月28日',
                        value: '28日',
                    },
                    {
                        fullDate: new Date('2020-02-29T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月29日',
                        value: '29日',
                    },
                ],
                [
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                ],
            ],
            disabledDatesSet: new Set(),
            disabledDaysSet: new Set(),
            key: expect.stringContaining('ja-JP'),
        },
    ],
    [
        `{ ...default, firstDayOfWeek: -1 }`,
        {
            dayFormat: getFormatter(Intl.DateTimeFormat('ja-JP', { day: 'numeric' })),
            fullDateFormat: getFormatter(Intl.DateTimeFormat('ja-JP', { year: 'numeric', month: 'short', day: 'numeric' })),
            locale: 'ja-JP',
            date: new Date('2020-02-02'),
            firstDayOfWeek: -1,
        },
        {
            calendar: [
                [
                    {
                        fullDate: new Date('2020-02-01T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月1日',
                        value: '1日',
                    },
                    {
                        fullDate: new Date('2020-02-02T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月2日',
                        value: '2日',
                    },
                    {
                        fullDate: new Date('2020-02-03T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月3日',
                        value: '3日',
                    },
                    {
                        fullDate: new Date('2020-02-04T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月4日',
                        value: '4日',
                    },
                    {
                        fullDate: new Date('2020-02-05T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月5日',
                        value: '5日',
                    },
                    {
                        fullDate: new Date('2020-02-06T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月6日',
                        value: '6日',
                    },
                    {
                        fullDate: new Date('2020-02-07T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月7日',
                        value: '7日',
                    },
                ],
                [
                    {
                        fullDate: new Date('2020-02-29T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月29日',
                        value: '29日',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                ],
                [
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                ],
            ],
            disabledDatesSet: new Set(),
            disabledDaysSet: new Set(),
            key: expect.stringContaining('ja-JP'),
        },
    ],
    [
        `{ ...default, firstDayOfWeek: 8 }`,
        {
            dayFormat: getFormatter(Intl.DateTimeFormat('ja-JP', { day: 'numeric' })),
            fullDateFormat: getFormatter(Intl.DateTimeFormat('ja-JP', { year: 'numeric', month: 'short', day: 'numeric' })),
            locale: 'ja-JP',
            date: new Date('2020-02-02'),
            firstDayOfWeek: 8,
        },
        {
            calendar: [
                [
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: new Date('2020-02-01T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月1日',
                        value: '1日',
                    },
                    {
                        fullDate: new Date('2020-02-02T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月2日',
                        value: '2日',
                    },
                ],
                [
                    {
                        fullDate: new Date('2020-02-24T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月24日',
                        value: '24日',
                    },
                    {
                        fullDate: new Date('2020-02-25T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月25日',
                        value: '25日',
                    },
                    {
                        fullDate: new Date('2020-02-26T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月26日',
                        value: '26日',
                    },
                    {
                        fullDate: new Date('2020-02-27T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月27日',
                        value: '27日',
                    },
                    {
                        fullDate: new Date('2020-02-28T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月28日',
                        value: '28日',
                    },
                    {
                        fullDate: new Date('2020-02-29T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月29日',
                        value: '29日',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                ],
                [
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                ],
            ],
            disabledDatesSet: new Set(),
            disabledDaysSet: new Set(),
            key: expect.stringContaining('ja-JP'),
        },
    ],
    [
        `{ ...default, showWeekNumber: true }`,
        {
            dayFormat: getFormatter(Intl.DateTimeFormat('ja-JP', { day: 'numeric' })),
            fullDateFormat: getFormatter(Intl.DateTimeFormat('ja-JP', { year: 'numeric', month: 'short', day: 'numeric' })),
            locale: 'ja-JP',
            date: new Date('2020-02-02'),
            showWeekNumber: true,
        },
        {
            calendar: [
                [
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: 'Week 5',
                        value: '5',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: new Date('2020-02-01T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月1日',
                        value: '1日',
                    },
                ],
                [
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: 'Week 9',
                        value: '9',
                    },
                    {
                        fullDate: new Date('2020-02-23T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月23日',
                        value: '23日',
                    },
                    {
                        fullDate: new Date('2020-02-24T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月24日',
                        value: '24日',
                    },
                    {
                        fullDate: new Date('2020-02-25T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月25日',
                        value: '25日',
                    },
                    {
                        fullDate: new Date('2020-02-26T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月26日',
                        value: '26日',
                    },
                    {
                        fullDate: new Date('2020-02-27T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月27日',
                        value: '27日',
                    },
                    {
                        fullDate: new Date('2020-02-28T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月28日',
                        value: '28日',
                    },
                    {
                        fullDate: new Date('2020-02-29T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月29日',
                        value: '29日',
                    },
                ],
                [
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                ],
            ],
            disabledDatesSet: new Set(),
            disabledDaysSet: new Set(),
            key: expect.stringContaining('ja-JP'),
        },
    ],
    [
        `{ ...default, showWeekNumber: true, weekNumberType: 'first-full-week' }`,
        {
            dayFormat: getFormatter(Intl.DateTimeFormat('ja-JP', { day: 'numeric' })),
            fullDateFormat: getFormatter(Intl.DateTimeFormat('ja-JP', { year: 'numeric', month: 'short', day: 'numeric' })),
            locale: 'ja-JP',
            date: new Date('2020-02-02'),
            showWeekNumber: true,
            weekNumberType: 'first-full-week',
        },
        {
            calendar: [
                [
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: 'Week 4',
                        value: '4',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: new Date('2020-02-01T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月1日',
                        value: '1日',
                    },
                ],
                [
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: 'Week 8',
                        value: '8',
                    },
                    {
                        fullDate: new Date('2020-02-23T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月23日',
                        value: '23日',
                    },
                    {
                        fullDate: new Date('2020-02-24T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月24日',
                        value: '24日',
                    },
                    {
                        fullDate: new Date('2020-02-25T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月25日',
                        value: '25日',
                    },
                    {
                        fullDate: new Date('2020-02-26T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月26日',
                        value: '26日',
                    },
                    {
                        fullDate: new Date('2020-02-27T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月27日',
                        value: '27日',
                    },
                    {
                        fullDate: new Date('2020-02-28T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月28日',
                        value: '28日',
                    },
                    {
                        fullDate: new Date('2020-02-29T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月29日',
                        value: '29日',
                    },
                ],
                [
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                ],
            ],
            disabledDatesSet: new Set(),
            disabledDaysSet: new Set(),
            key: expect.stringContaining('ja-JP'),
        },
    ],
    [
        `{ ...default, min: new Date('2020-02-05') }`,
        {
            dayFormat: getFormatter(Intl.DateTimeFormat('ja-JP', { day: 'numeric' })),
            fullDateFormat: getFormatter(Intl.DateTimeFormat('ja-JP', { year: 'numeric', month: 'short', day: 'numeric' })),
            locale: 'ja-JP',
            date: new Date('2020-02-02'),
            min: new Date('2020-02-05'),
        },
        {
            calendar: [
                [
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: new Date('2020-02-01T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '2020年2月1日',
                        value: '1日',
                    },
                ],
                [
                    {
                        fullDate: new Date('2020-02-23T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月23日',
                        value: '23日',
                    },
                    {
                        fullDate: new Date('2020-02-24T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月24日',
                        value: '24日',
                    },
                    {
                        fullDate: new Date('2020-02-25T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月25日',
                        value: '25日',
                    },
                    {
                        fullDate: new Date('2020-02-26T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月26日',
                        value: '26日',
                    },
                    {
                        fullDate: new Date('2020-02-27T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月27日',
                        value: '27日',
                    },
                    {
                        fullDate: new Date('2020-02-28T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月28日',
                        value: '28日',
                    },
                    {
                        fullDate: new Date('2020-02-29T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月29日',
                        value: '29日',
                    },
                ],
                [
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                ],
            ],
            disabledDatesSet: new Set([
                1580515200000,
                1580601600000,
                1580688000000,
                1580774400000,
            ]),
            disabledDaysSet: new Set(),
            key: expect.stringContaining('ja-JP'),
        },
    ],
    [
        `{ ...default, showWeekNumber: true, weekNumberType: 'first-full-week', max: new Date('2020-02-25') }`,
        {
            dayFormat: getFormatter(Intl.DateTimeFormat('ja-JP', { day: 'numeric' })),
            fullDateFormat: getFormatter(Intl.DateTimeFormat('ja-JP', { year: 'numeric', month: 'short', day: 'numeric' })),
            locale: 'ja-JP',
            date: new Date('2020-02-02'),
            showWeekNumber: true,
            weekNumberType: 'first-full-week',
            max: new Date('2020-02-25'),
        },
        {
            calendar: [
                [
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: 'Week 4',
                        value: '4',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: new Date('2020-02-01T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月1日',
                        value: '1日',
                    },
                ],
                [
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: 'Week 8',
                        value: '8',
                    },
                    {
                        fullDate: new Date('2020-02-23T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月23日',
                        value: '23日',
                    },
                    {
                        fullDate: new Date('2020-02-24T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月24日',
                        value: '24日',
                    },
                    {
                        fullDate: new Date('2020-02-25T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月25日',
                        value: '25日',
                    },
                    {
                        fullDate: new Date('2020-02-26T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '2020年2月26日',
                        value: '26日',
                    },
                    {
                        fullDate: new Date('2020-02-27T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '2020年2月27日',
                        value: '27日',
                    },
                    {
                        fullDate: new Date('2020-02-28T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '2020年2月28日',
                        value: '28日',
                    },
                    {
                        fullDate: new Date('2020-02-29T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '2020年2月29日',
                        value: '29日',
                    },
                ],
                [
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                ],
            ],
            disabledDatesSet: new Set([
                1582675200000,
                1582761600000,
                1582848000000,
                1582934400000,
            ]),
            disabledDaysSet: new Set(),
            key: expect.stringContaining('ja-JP'),
        },
    ],
    [
        `{ ...default, showWeekNumber: true, weekNumberType: 'first-full-week', min: new Date('2020-02-05'), max: new Date('2020-02-25') }`,
        {
            dayFormat: getFormatter(Intl.DateTimeFormat('ja-JP', { day: 'numeric' })),
            fullDateFormat: getFormatter(Intl.DateTimeFormat('ja-JP', { year: 'numeric', month: 'short', day: 'numeric' })),
            locale: 'ja-JP',
            date: new Date('2020-02-02'),
            showWeekNumber: true,
            weekNumberType: 'first-full-week',
            min: new Date('2020-02-05'),
            max: new Date('2020-02-25'),
        },
        {
            calendar: [
                [
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: 'Week 4',
                        value: '4',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: new Date('2020-02-01T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '2020年2月1日',
                        value: '1日',
                    },
                ],
                [
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: 'Week 8',
                        value: '8',
                    },
                    {
                        fullDate: new Date('2020-02-23T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月23日',
                        value: '23日',
                    },
                    {
                        fullDate: new Date('2020-02-24T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月24日',
                        value: '24日',
                    },
                    {
                        fullDate: new Date('2020-02-25T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月25日',
                        value: '25日',
                    },
                    {
                        fullDate: new Date('2020-02-26T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '2020年2月26日',
                        value: '26日',
                    },
                    {
                        fullDate: new Date('2020-02-27T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '2020年2月27日',
                        value: '27日',
                    },
                    {
                        fullDate: new Date('2020-02-28T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '2020年2月28日',
                        value: '28日',
                    },
                    {
                        fullDate: new Date('2020-02-29T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '2020年2月29日',
                        value: '29日',
                    },
                ],
                [
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                ],
            ],
            disabledDatesSet: new Set([
                1580515200000,
                1580601600000,
                1580688000000,
                1580774400000,
                1582675200000,
                1582761600000,
                1582848000000,
                1582934400000,
            ]),
            disabledDaysSet: new Set(),
            key: expect.stringContaining('ja-JP'),
        },
    ],
    [
        `{ ...default, showWeekNumber: true, weekNumberType: 'first-full-week', disabledDates: [new Date('2020-02-01'), new Date('2020-02-02')] }`,
        {
            dayFormat: getFormatter(Intl.DateTimeFormat('ja-JP', { day: 'numeric' })),
            fullDateFormat: getFormatter(Intl.DateTimeFormat('ja-JP', { year: 'numeric', month: 'short', day: 'numeric' })),
            locale: 'ja-JP',
            date: new Date('2020-02-02'),
            showWeekNumber: true,
            weekNumberType: 'first-full-week',
            disabledDates: [
                new Date('2020-02-01'),
                new Date('2020-02-02'),
            ],
        },
        {
            calendar: [
                [
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: 'Week 4',
                        value: '4',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: new Date('2020-02-01T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '2020年2月1日',
                        value: '1日',
                    },
                ],
                [
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: 'Week 8',
                        value: '8',
                    },
                    {
                        fullDate: new Date('2020-02-23T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月23日',
                        value: '23日',
                    },
                    {
                        fullDate: new Date('2020-02-24T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月24日',
                        value: '24日',
                    },
                    {
                        fullDate: new Date('2020-02-25T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月25日',
                        value: '25日',
                    },
                    {
                        fullDate: new Date('2020-02-26T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月26日',
                        value: '26日',
                    },
                    {
                        fullDate: new Date('2020-02-27T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月27日',
                        value: '27日',
                    },
                    {
                        fullDate: new Date('2020-02-28T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月28日',
                        value: '28日',
                    },
                    {
                        fullDate: new Date('2020-02-29T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月29日',
                        value: '29日',
                    },
                ],
                [
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                ],
            ],
            disabledDatesSet: new Set([
                1580515200000,
                1580601600000,
            ]),
            disabledDaysSet: new Set(),
            key: expect.stringContaining('ja-JP'),
        },
    ],
    [
        `{ ...default, showWeekNumber: true, weekNumberType: 'first-full-week', disabledDays: [1] }`,
        {
            dayFormat: getFormatter(Intl.DateTimeFormat('ja-JP', { day: 'numeric' })),
            fullDateFormat: getFormatter(Intl.DateTimeFormat('ja-JP', { year: 'numeric', month: 'short', day: 'numeric' })),
            locale: 'ja-JP',
            date: new Date('2020-02-02'),
            showWeekNumber: true,
            weekNumberType: 'first-full-week',
            disabledDays: [1],
        },
        {
            calendar: [
                [
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: 'Week 4',
                        value: '4',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: new Date('2020-02-01T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月1日',
                        value: '1日',
                    },
                ],
                [
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: 'Week 8',
                        value: '8',
                    },
                    {
                        fullDate: new Date('2020-02-23T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月23日',
                        value: '23日',
                    },
                    {
                        fullDate: new Date('2020-02-24T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '2020年2月24日',
                        value: '24日',
                    },
                    {
                        fullDate: new Date('2020-02-25T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月25日',
                        value: '25日',
                    },
                    {
                        fullDate: new Date('2020-02-26T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月26日',
                        value: '26日',
                    },
                    {
                        fullDate: new Date('2020-02-27T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月27日',
                        value: '27日',
                    },
                    {
                        fullDate: new Date('2020-02-28T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月28日',
                        value: '28日',
                    },
                    {
                        fullDate: new Date('2020-02-29T00:00:00.000Z'),
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                        label: '2020年2月29日',
                        value: '29日',
                    },
                ],
                [
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                ],
            ],
            disabledDatesSet: new Set([
                1580688000000,
                1581292800000,
                1581897600000,
                1582502400000,
            ]),
            disabledDaysSet: new Set([
                1,
            ]),
            key: expect.stringContaining('ja-JP'),
        },
    ],
    [
        `{ ...default, weekNumberType: 'first-full-week', firstDayOfWeek: 2, disabledDays: '1,5' }`,
        {
            dayFormat: getFormatter(Intl.DateTimeFormat('ja-JP', { day: 'numeric' })),
            fullDateFormat: getFormatter(Intl.DateTimeFormat('ja-JP', { year: 'numeric', month: 'short', day: 'numeric' })),
            locale: 'ja-JP',
            date: new Date('2020-02-02'),
            weekNumberType: 'first-full-week',
            firstDayOfWeek: 2,
            disabledDays: [1, 5],
        },
        {
            calendar: [
                [
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                    {
                        fullDate: new Date('2020-02-01T00:00:00.000Z'),
                        label: '2020年2月1日',
                        value: '1日',
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                    },
                    {
                        fullDate: new Date('2020-02-02T00:00:00.000Z'),
                        label: '2020年2月2日',
                        value: '2日',
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                    },
                    {
                        fullDate: new Date('2020-02-03T00:00:00.000Z'),
                        label: '2020年2月3日',
                        value: '3日',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                ],
                [
                    {
                        fullDate: new Date('2020-02-25T00:00:00.000Z'),
                        label: '2020年2月25日',
                        value: '25日',
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                    },
                    {
                        fullDate: new Date('2020-02-26T00:00:00.000Z'),
                        label: '2020年2月26日',
                        value: '26日',
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                    },
                    {
                        fullDate: new Date('2020-02-27T00:00:00.000Z'),
                        label: '2020年2月27日',
                        value: '27日',
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                    },
                    {
                        fullDate: new Date('2020-02-28T00:00:00.000Z'),
                        label: '2020年2月28日',
                        value: '28日',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                    {
                        fullDate: new Date('2020-02-29T00:00:00.000Z'),
                        label: '2020年2月29日',
                        value: '29日',
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                ],
                [
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                ],
            ],
            disabledDaysSet: new Set([1, 5]),
            disabledDatesSet: new Set([
                1580688000000,
                1581033600000,
                1581292800000,
                1581638400000,
                1581897600000,
                1582243200000,
                1582502400000,
                1582848000000,
            ]),
            key: expect.stringContaining('ja-JP'),
        },
    ],
    [
        `{ ...default, showWeekNumber: true, weekNumberType: 'first-full-week', firstDayOfWeek: 2, disabledDays: '1,5' }`,
        {
            dayFormat: getFormatter(Intl.DateTimeFormat('ja-JP', { day: 'numeric' })),
            fullDateFormat: getFormatter(Intl.DateTimeFormat('ja-JP', { year: 'numeric', month: 'short', day: 'numeric' })),
            locale: 'ja-JP',
            date: new Date('2020-02-02'),
            showWeekNumber: true,
            weekNumberType: 'first-full-week',
            firstDayOfWeek: 2,
            disabledDays: [1, 5],
        },
        {
            calendar: [
                [
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: 'Week 4',
                        value: '4',
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                    {
                        fullDate: new Date('2020-02-01T00:00:00.000Z'),
                        label: '2020年2月1日',
                        value: '1日',
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                    },
                    {
                        fullDate: new Date('2020-02-02T00:00:00.000Z'),
                        label: '2020年2月2日',
                        value: '2日',
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                    },
                    {
                        fullDate: new Date('2020-02-03T00:00:00.000Z'),
                        label: '2020年2月3日',
                        value: '3日',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                ],
                [
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: 'Week 8',
                        value: '8',
                    },
                    {
                        fullDate: new Date('2020-02-25T00:00:00.000Z'),
                        label: '2020年2月25日',
                        value: '25日',
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                    },
                    {
                        fullDate: new Date('2020-02-26T00:00:00.000Z'),
                        label: '2020年2月26日',
                        value: '26日',
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                    },
                    {
                        fullDate: new Date('2020-02-27T00:00:00.000Z'),
                        label: '2020年2月27日',
                        value: '27日',
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                    },
                    {
                        fullDate: new Date('2020-02-28T00:00:00.000Z'),
                        label: '2020年2月28日',
                        value: '28日',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                    {
                        fullDate: new Date('2020-02-29T00:00:00.000Z'),
                        label: '2020年2月29日',
                        value: '29日',
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                ],
                [
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                ],
            ],
            disabledDaysSet: new Set([1, 5]),
            disabledDatesSet: new Set([
                1580688000000,
                1581033600000,
                1581292800000,
                1581638400000,
                1581897600000,
                1582243200000,
                1582502400000,
                1582848000000,
            ]),
            key: expect.stringContaining('ja-JP'),
        },
    ],
    [
        `{ ...default, showWeekNumber: true, weekNumberType: 'first-full-week', firstDayOfWeek: 9, disabledDays: '1,5' }`,
        {
            dayFormat: getFormatter(Intl.DateTimeFormat('ja-JP', { day: 'numeric' })),
            fullDateFormat: getFormatter(Intl.DateTimeFormat('ja-JP', { year: 'numeric', month: 'short', day: 'numeric' })),
            locale: 'ja-JP',
            date: new Date('2020-02-02'),
            showWeekNumber: true,
            weekNumberType: 'first-full-week',
            firstDayOfWeek: 2,
            disabledDays: [1, 5],
        },
        {
            calendar: [
                [
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: 'Week 4',
                        value: '4',
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                    {
                        fullDate: new Date('2020-02-01T00:00:00.000Z'),
                        label: '2020年2月1日',
                        value: '1日',
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                    },
                    {
                        fullDate: new Date('2020-02-02T00:00:00.000Z'),
                        label: '2020年2月2日',
                        value: '2日',
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                    },
                    {
                        fullDate: new Date('2020-02-03T00:00:00.000Z'),
                        label: '2020年2月3日',
                        value: '3日',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                ],
                [
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: 'Week 8',
                        value: '8',
                    },
                    {
                        fullDate: new Date('2020-02-25T00:00:00.000Z'),
                        label: '2020年2月25日',
                        value: '25日',
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                    },
                    {
                        fullDate: new Date('2020-02-26T00:00:00.000Z'),
                        label: '2020年2月26日',
                        value: '26日',
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                    },
                    {
                        fullDate: new Date('2020-02-27T00:00:00.000Z'),
                        label: '2020年2月27日',
                        value: '27日',
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                    },
                    {
                        fullDate: new Date('2020-02-28T00:00:00.000Z'),
                        label: '2020年2月28日',
                        value: '28日',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                    {
                        fullDate: new Date('2020-02-29T00:00:00.000Z'),
                        label: '2020年2月29日',
                        value: '29日',
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                ],
                [
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                ],
            ],
            disabledDaysSet: new Set([1, 5]),
            disabledDatesSet: new Set([
                1580688000000,
                1581033600000,
                1581292800000,
                1581638400000,
                1581897600000,
                1582243200000,
                1582502400000,
                1582848000000,
            ]),
            key: expect.stringContaining('ja-JP'),
        },
    ],
    [
        `{ ...default, showWeekNumber: true, weekNumberType: 'first-full-week', firstDayOfWeek: 2, disabledDays: '1,5' }`,
        {
            dayFormat: getFormatter(Intl.DateTimeFormat('ja-JP', { day: 'numeric' })),
            fullDateFormat: getFormatter(Intl.DateTimeFormat('ja-JP', { year: 'numeric', month: 'short', day: 'numeric' })),
            locale: 'ja-JP',
            date: new Date('2020-02-02'),
            showWeekNumber: true,
            weekNumberType: 'first-full-week',
            firstDayOfWeek: 2,
            disabledDays: [1, 5],
        },
        {
            calendar: [
                [
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: 'Week 4',
                        value: '4',
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                    {
                        fullDate: new Date('2020-02-01T00:00:00.000Z'),
                        label: '2020年2月1日',
                        value: '1日',
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                    },
                    {
                        fullDate: new Date('2020-02-02T00:00:00.000Z'),
                        label: '2020年2月2日',
                        value: '2日',
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                    },
                    {
                        fullDate: new Date('2020-02-03T00:00:00.000Z'),
                        label: '2020年2月3日',
                        value: '3日',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                ],
                [
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: 'Week 8',
                        value: '8',
                    },
                    {
                        fullDate: new Date('2020-02-25T00:00:00.000Z'),
                        label: '2020年2月25日',
                        value: '25日',
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                    },
                    {
                        fullDate: new Date('2020-02-26T00:00:00.000Z'),
                        label: '2020年2月26日',
                        value: '26日',
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                    },
                    {
                        fullDate: new Date('2020-02-27T00:00:00.000Z'),
                        label: '2020年2月27日',
                        value: '27日',
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                    },
                    {
                        fullDate: new Date('2020-02-28T00:00:00.000Z'),
                        label: '2020年2月28日',
                        value: '28日',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                    {
                        fullDate: new Date('2020-02-29T00:00:00.000Z'),
                        label: '2020年2月29日',
                        value: '29日',
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                ],
                [
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                ],
            ],
            disabledDaysSet: new Set([1, 5]),
            disabledDatesSet: new Set([
                1580688000000,
                1581033600000,
                1581292800000,
                1581638400000,
                1581897600000,
                1582243200000,
                1582502400000,
                1582848000000,
            ]),
            key: expect.stringContaining('ja-JP'),
        },
    ],
    [
        `{ ...default, showWeekNumber: true, weekNumberType: 'first-full-week', firstDayOfWeek: -5, disabledDays: '1,5' }`,
        {
            dayFormat: getFormatter(Intl.DateTimeFormat('ja-JP', { day: 'numeric' })),
            fullDateFormat: getFormatter(Intl.DateTimeFormat('ja-JP', { year: 'numeric', month: 'short', day: 'numeric' })),
            locale: 'ja-JP',
            date: new Date('2020-02-02'),
            showWeekNumber: true,
            weekNumberType: 'first-full-week',
            firstDayOfWeek: 2,
            disabledDays: [1, 5],
        },
        {
            calendar: [
                [
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: 'Week 4',
                        value: '4',
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                    {
                        fullDate: new Date('2020-02-01T00:00:00.000Z'),
                        label: '2020年2月1日',
                        value: '1日',
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                    },
                    {
                        fullDate: new Date('2020-02-02T00:00:00.000Z'),
                        label: '2020年2月2日',
                        value: '2日',
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                    },
                    {
                        fullDate: new Date('2020-02-03T00:00:00.000Z'),
                        label: '2020年2月3日',
                        value: '3日',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                ],
                [
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: 'Week 8',
                        value: '8',
                    },
                    {
                        fullDate: new Date('2020-02-25T00:00:00.000Z'),
                        label: '2020年2月25日',
                        value: '25日',
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                    },
                    {
                        fullDate: new Date('2020-02-26T00:00:00.000Z'),
                        label: '2020年2月26日',
                        value: '26日',
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                    },
                    {
                        fullDate: new Date('2020-02-27T00:00:00.000Z'),
                        label: '2020年2月27日',
                        value: '27日',
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                    },
                    {
                        fullDate: new Date('2020-02-28T00:00:00.000Z'),
                        label: '2020年2月28日',
                        value: '28日',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                    {
                        fullDate: new Date('2020-02-29T00:00:00.000Z'),
                        label: '2020年2月29日',
                        value: '29日',
                        key: expect.stringContaining('ja-JP'),
                        disabled: false,
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                ],
                [
                    {
                        fullDate: null,
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                        label: '',
                        value: '',
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                    {
                        fullDate: null,
                        label: '',
                        value: '',
                        key: expect.stringContaining('ja-JP'),
                        disabled: true,
                    },
                ],
            ],
            disabledDaysSet: new Set([1, 5]),
            disabledDatesSet: new Set([
                1580688000000,
                1581033600000,
                1581292800000,
                1581638400000,
                1581897600000,
                1582243200000,
                1582502400000,
                1582848000000,
            ]),
            key: expect.stringContaining('ja-JP'),
        },
    ],
];
//# sourceMappingURL=calendar.js.map