import './setup.js';
import { PollingObserver } from '../../polling-observer/index.js';
it(`throws when 'conditionCallback' is undefined`, () => {
    expect(() => new PollingObserver(undefined))
        .toThrowError(new TypeError(`'conditionCallback' is not defined`));
});
it(`stops polling when error occurs`, (done) => {
    const obs = new PollingObserver(() => false);
    obs.observe(async () => {
        throw new Error('polling error');
    }, { interval: 1e3 });
    obs.onfinish = (d) => {
        const { status, reason } = d;
        expect(status).toStrictEqual('error');
        expect(reason).toStrictEqual(new Error('polling error'));
        done();
    };
}, 10e3);
//# sourceMappingURL=error.spec.js.map