import './setup.js';
afterEach(() => {
    Object.assign(global, { window: undefined });
});
it(`uses 'perf_hooks' on Node.js`, async () => {
    const { globalPerformance } = await import('../../polling-observer/global-performance.js');
    const perf = await globalPerformance();
    const timerify = perf.timerify;
    expect(typeof (timerify)).toStrictEqual('function');
});
it(`uses 'window.Performance' on browser`, async () => {
    Object.assign(global, { window: {} });
    const { globalPerformance } = await import('../../polling-observer/global-performance.js');
    const perf = await globalPerformance();
    expect(perf).toBe(undefined);
});
//# sourceMappingURL=global-performance.spec.js.map