import { sign } from '../../signatur/index.js';
import { data, secret } from './CONSTANTS.js';
it('returns', async () => {
    const d = await sign(data, secret);
    expect(d).toStrictEqual('eyJkYXRhIjp7InNlY3JldEluc2lkZSI6IjEyMyIsInNlY3JldEtleSI6NDU2fX0.WlF_-gDYzfBBPksdvhVvaP_MQ9PWoRiwADbI3MapRg4');
});
it(`returns with defined 'options[separator]'`, async () => {
    const d = await sign(data, secret, {
        separator: ':',
    });
    expect(d).toStrictEqual('eyJkYXRhIjp7InNlY3JldEluc2lkZSI6IjEyMyIsInNlY3JldEtleSI6NDU2fX0:WlF_-gDYzfBBPksdvhVvaP_MQ9PWoRiwADbI3MapRg4');
});
//# sourceMappingURL=sign.spec.js.map