import { getWeekNumber } from './helpers/get-week-number.js';
import { normalizeWeekday } from './helpers/normalize-weekday.js';
import { toUTCDate } from './helpers/to-utc-date.js';
import { toValidWeekday } from './helpers/to-valid-weekday.js';
export function calendar(init) {
    const { date, dayFormat, disabledDates = [], disabledDays = [], firstDayOfWeek = 0, fullDateFormat, locale = 'en-US', max, min, showWeekNumber = false, weekLabel = 'Week', weekNumberType = 'first-4-day-week', } = init || {};
    const firstDayOfWeek2 = toValidWeekday(firstDayOfWeek);
    const dateYear = date.getUTCFullYear();
    const dateMonth = date.getUTCMonth();
    const firstDateOfMonth = toUTCDate(dateYear, dateMonth, 1);
    const disabledDaysSet = new Set(disabledDays.map(n => normalizeWeekday(n, firstDayOfWeek2, showWeekNumber)));
    const disabledDatesSet = new Set(disabledDates.map(n => +n));
    const calendarKey = [
        firstDateOfMonth.toJSON(),
        firstDayOfWeek2,
        locale,
        null == max ? '' : max.toJSON(),
        null == min ? '' : min.toJSON(),
        Array.from(disabledDaysSet).join(','),
        Array.from(disabledDatesSet).join(','),
        weekNumberType,
    ].filter(Boolean).join(':');
    const firstDayOfWeekOffset = normalizeWeekday(firstDateOfMonth.getUTCDay(), firstDayOfWeek2, showWeekNumber);
    const minTime = null == min ? +new Date('2000-01-01') : +min;
    const maxTime = null == max ? +new Date('2100-12-31') : +max;
    const colNum = showWeekNumber ? 8 : 7;
    const totalDays = toUTCDate(dateYear, 1 + dateMonth, 0).getUTCDate();
    const rows = [];
    let cols = [];
    let calendarComplete = false;
    let curDay = 1;
    for (const row of [0, 1, 2, 3, 4, 5]) {
        for (const col of ([0, 1, 2, 3, 4, 5, 6].concat(colNum === 7 ? [] : [7]))) {
            const idx = col + (row * colNum);
            if (!calendarComplete && showWeekNumber && col === 0) {
                const weekNumberOffset = row < 1 ? firstDayOfWeek2 : 0;
                const weekNumber = getWeekNumber(weekNumberType, toUTCDate(dateYear, dateMonth, curDay - weekNumberOffset));
                const wkLabel = `${weekLabel} ${weekNumber}`;
                cols.push({
                    fullDate: null,
                    label: wkLabel,
                    value: `${weekNumber}`,
                    key: `${calendarKey}:${wkLabel}`,
                    disabled: true,
                });
                continue;
            }
            if (calendarComplete || idx < firstDayOfWeekOffset) {
                cols.push({
                    fullDate: null,
                    label: '',
                    value: '',
                    key: `${calendarKey}:${idx}`,
                    disabled: true,
                });
                continue;
            }
            const curDate = toUTCDate(dateYear, dateMonth, curDay);
            const curTime = +curDate;
            const isDisabledDay = disabledDaysSet.has(col) ||
                disabledDatesSet.has(curTime) ||
                (curTime < minTime || curTime > maxTime);
            if (isDisabledDay)
                disabledDatesSet.add(curTime);
            cols.push({
                fullDate: curDate,
                label: fullDateFormat(curDate),
                value: dayFormat(curDate),
                key: `${calendarKey}:${curDate.toJSON()}`,
                disabled: isDisabledDay,
            });
            curDay += 1;
            if (curDay > totalDays)
                calendarComplete = true;
        }
        rows.push(cols);
        cols = [];
    }
    return {
        disabledDatesSet,
        calendar: rows,
        disabledDaysSet: new Set(disabledDays.map(n => toValidWeekday(n))),
        key: calendarKey,
    };
}
//# sourceMappingURL=calendar.js.map