import { toUTCDate } from './to-utc-date.js';
function getNormalizedDate(weekNumberType, date) {
    const fy = date.getUTCFullYear();
    const m = date.getUTCMonth();
    const d = date.getUTCDate();
    const wd = date.getUTCDay();
    let offset = wd;
    if (weekNumberType === 'first-4-day-week')
        offset = 3;
    if (weekNumberType === 'first-day-of-year')
        offset = 6;
    if (weekNumberType === 'first-full-week')
        offset = 0;
    return toUTCDate(fy, m, d - wd + offset);
}
export function getWeekNumber(weekNumberType, date) {
    const normalizedDate = getNormalizedDate(weekNumberType, date);
    const firstDayOfYear = toUTCDate(normalizedDate.getUTCFullYear(), 0, 1);
    const numDays = 1 + ((+normalizedDate - +firstDayOfYear) / 864e5);
    return Math.ceil(numDays / 7);
}
//# sourceMappingURL=get-week-number.js.map