import { toUTCDate } from './to-utc-date.js';
export function getWeekdays(init) {
    const { firstDayOfWeek = 0, showWeekNumber = false, weekLabel, longWeekdayFormat, narrowWeekdayFormat, } = init || {};
    const fixedFirstDayOfWeek = 1 + ((firstDayOfWeek + (firstDayOfWeek < 0 ? 7 : 0)) % 7);
    const weekLabel2 = weekLabel || 'Wk';
    const initialValue = showWeekNumber ?
        [{
                label: weekLabel2 === 'Wk' ? 'Week' : weekLabel2,
                value: weekLabel2,
            }] :
        [];
    const weekdays = Array.from(Array(7)).reduce((p, _, i) => {
        const d = toUTCDate(2017, 0, fixedFirstDayOfWeek + i);
        p.push({
            label: longWeekdayFormat(d),
            value: narrowWeekdayFormat(d),
        });
        return p;
    }, initialValue);
    return weekdays;
}
//# sourceMappingURL=get-weekdays.js.map