import { cloneDeep } from '../lib/clone-deep.js';
export function deepCloneSync(target, options) {
    if (target == null)
        throw new TypeError(`'target' is not defined`);
    return options && options.absolute
        ? cloneDeep(target)
        : JSON.parse(JSON.stringify(target));
}
export async function deepClone(target, options) {
    return deepCloneSync(target, options);
}
//# sourceMappingURL=index.js.map