export interface ExtendedFetchResponse extends Response {
    size: number;
    timeout: number;
}
export declare type FetchType = Exclude<keyof Body, 'body' | 'bodyUsed'>;
export declare type UnknownRecord = Record<string, unknown>;
export interface FetchAsInfo extends Pick<ExtendedFetchResponse, 'size' | 'timeout' | 'type'> {
    headers: UnknownRecord;
}
export interface FetchAsReturnType<T = Record<string, unknown>, U = Error> {
    status: number;
    info: FetchAsInfo;
    data?: T;
    error?: U;
}
//# sourceMappingURL=custom_typings.d.ts.map