function getResponseHeaders(headers) {
    const d = {};
    for (const [k, v] of headers) {
        d[k] = v;
    }
    return d;
}
function fetchAs(fetchType) {
    return async (url, options) => {
        let status = -1;
        let headers = {};
        let size = -1;
        let timeout = -1;
        let type = 'basic';
        try {
            const r = await fetch(url, options);
            const d = await r[fetchType]();
            status = r.status;
            headers = getResponseHeaders(r.headers);
            size = r.size || -1;
            timeout = r.timeout || -1;
            type = r.type;
            return {
                status,
                info: { headers, size, timeout, type },
                [status > 399 ? 'error' : 'data']: d,
            };
        }
        catch (e) {
            return {
                status,
                info: { headers, size, timeout, type },
                error: e,
            };
        }
    };
}
export async function fetchAsArrayBuffer(url, options) {
    return fetchAs('arrayBuffer')(url, options);
}
export async function fetchAsBlob(url, options) {
    return fetchAs('blob')(url, options);
}
export async function fetchAsJson(url, options) {
    return fetchAs('json')(url, options);
}
export async function fetchAsText(url, options) {
    return fetchAs('text')(url, options);
}
export default {
    arrayBuffer: fetchAsArrayBuffer,
    blob: fetchAsBlob,
    json: fetchAsJson,
    text: fetchAsText,
};
//# sourceMappingURL=index.js.map