import { PollingMeasure } from './polling-measure.js';
export interface PollingObserverOptions {
    timeout?: number;
    interval?: number;
}
declare type PollingCallback<T> = () => T | Promise<T>;
declare type ConditionCallback<T> = (data: T | null | undefined, records: PollingObserver<T>['_records'], object: PollingObserver<T>) => boolean | Promise<boolean>;
export interface OnfinishFulfilled<T> {
    status: 'finish' | 'timeout';
    value: T | null | undefined;
}
export interface OnfinishRejected {
    status: 'error';
    reason: Error;
}
export declare type OnfinishValue<T> = OnfinishFulfilled<T> | OnfinishRejected;
declare type OnfinishCallback<T> = (value: OnfinishValue<T>, records: PollingObserver<T>['_records'], object: PollingObserver<T>) => unknown;
export declare class PollingObserver<T> {
    conditionCallback: ConditionCallback<T>;
    onfinish?: OnfinishCallback<T>;
    private _forceStop;
    private _records;
    private _isPolling;
    constructor(conditionCallback: ConditionCallback<T>);
    disconnect(): void;
    observe(callback: PollingCallback<T>, options?: PollingObserverOptions): Promise<void>;
    takeRecords(): PollingMeasure[];
}
export {};
//# sourceMappingURL=polling-observer.d.ts.map