import type { SignaturOptions, SignaturReturnError, UnknownRecord } from './custom_typings.js';
export declare class SignaturError extends Error {
    type: string;
    constructor(type: string, message: string);
    toJSON(): SignaturReturnError;
}
export declare function signSync<T = UnknownRecord>(data: T, secret: string, options?: SignaturOptions): string;
export declare function unsignSync<T = UnknownRecord>(signature: string, secret: string, options?: SignaturOptions): T;
export declare function sign<T = UnknownRecord>(data: T, secret: string, options?: SignaturOptions): Promise<string>;
export declare function unsign<T = UnknownRecord>(signature: string, secret: string, options?: SignaturOptions): Promise<T>;
//# sourceMappingURL=index.d.ts.map