/**
 * @callback ResultCallback
 * @param {Error | null} err
 * @param {any} [output]
 * @returns {void}
 */
/**
 * @callback NetworkAsCallback
 * @param {any} input
 * @param {ResultCallback} callback
 * @returns void
 */
/**
 * @callback NetworkAsPromise
 * @param {any} input
 * @returns {Promise<any>}
 */
/**
 * @callback NetworkCallback
 * @param {Network} network
 * @returns void
 */
/**
 * @param {Graph | string} component - Graph or component to load
 * @param {Object} options
 * @param {string} [options.name] - Name for the wrapped network
 * @param {ComponentLoader} [options.loader] - Component loader instance to use, if any
 * @param {string} [options.baseDir] - Project base directory for component loading
 * @param {Object} [options.flowtrace] - Flowtrace instance to use for tracing this network run
 * @param {NetworkCallback} [options.networkCallback] - Access to Network instance
 * @param {boolean} [options.raw] - Whether the callback should operate on raw noflo.IP objects
 * @returns {NetworkAsPromise}
 */
export function asPromise(component: Graph | string, options: {
    name: string;
    loader: ComponentLoader;
    baseDir: string;
    flowtrace: any;
    networkCallback: NetworkCallback;
    raw: boolean;
}): NetworkAsPromise;
/**
 * @param {AsCallbackComponent} component - Graph or component to load
 * @param {AsCallbackOptions} options
 * @returns {NetworkAsCallback}
 */
export function asCallback(component: AsCallbackComponent, options: AsCallbackOptions): NetworkAsCallback;
export type AsCallbackComponent = string | Graph;
export type AsCallbackOptions = {
    /**
     * - Name for the wrapped network
     */
    name?: string;
    /**
     * - Component loader instance to use, if any
     */
    loader?: ComponentLoader;
    /**
     * - Project base directory for component loading
     */
    baseDir?: string;
    /**
     * - Flowtrace instance to use for tracing this network run
     */
    flowtrace?: any;
    /**
     * - Access to Network instance
     */
    networkCallback?: NetworkCallback;
    /**
     * - Whether the callback should operate on raw noflo.IP objects
     */
    raw?: boolean;
};
export type ResultCallback = (err: Error | null, output?: any) => void;
export type NetworkAsCallback = (input: any, callback: ResultCallback) => any;
export type NetworkAsPromise = (input: any) => Promise<any>;
export type NetworkCallback = (network: Network) => any;
import { Graph } from "fbp-graph";
import { ComponentLoader } from "./ComponentLoader";
import { Network } from "./Network";
