/**
 * @typedef FuncParam
 * @property {string} param
 * @property {any} [default]
 */
/**
 * @typedef {Object} PortOptions - Options for configuring all types of ports
 * @property {string} [description='']
 * @property {string} [datatype='all']
 * @property {string} [schema=null]
 * @property {string} [type=null]
 * @property {boolean} [required=false]
 * @property {boolean} [scoped=true]
 * @property {any} [default]
 */
/**
 * @param {Function} func
 * @param {Object} options
 * @returns {Component}
 */
export function asComponent(func: Function, options: any): Component;
export type FuncParam = {
    param: string;
    default?: any;
};
/**
 * - Options for configuring all types of ports
 */
export type PortOptions = {
    description?: string;
    datatype?: string;
    schema?: string;
    type?: string;
    required?: boolean;
    scoped?: boolean;
    default?: any;
};
import { Component } from "./Component";
