export default class BasePort extends EventEmitter {
    constructor(options: any);
    options: any;
    /** @type {Array<import("./InternalSocket").InternalSocket>} */
    sockets: Array<import("./InternalSocket").InternalSocket>;
    /** @type {string|null} */
    node: string | null;
    /** @type {import("./Component").Component|null} */
    nodeInstance: import("./Component").Component | null;
    /** @type {string|null} */
    name: string | null;
    getId(): string;
    getDataType(): any;
    getSchema(): any;
    getDescription(): any;
    attach(socket: any, index?: any): void;
    attachSocket(socket: any, index?: any): void;
    detach(socket: any): void;
    isAddressable(): boolean;
    isBuffered(): boolean;
    isRequired(): boolean;
    isAttached(socketId?: any): boolean;
    listAttached(): number[];
    isConnected(socketId?: any): boolean;
    canAttach(): boolean;
}
/**
 * - Options for configuring all types of ports
 */
export type BaseOptions = {
    description?: string;
    datatype?: string;
    schema?: string;
    type?: string;
    required?: boolean;
    scoped?: boolean;
};
import { EventEmitter } from "events";
