/**
 * @typedef InPortOptions
 * @property {boolean} [control]
 * @property {boolean} [triggering]
 */
/**
 * @typedef {import("./BasePort").BaseOptions & InPortOptions} PortOptions
 */
export default class InPort extends BasePort {
    /**
     * @param {PortOptions} [options]
     */
    constructor(options?: PortOptions);
    handleIP(packet: any, index: any): void;
    handleSocketEvent(event: any, payload: any, id: any): boolean;
    hasDefault(): boolean;
    prepareBuffer(): void;
    /** @type {Object<string,Object<number,Array<import("./IP").default>>>} */
    indexedScopedBuffer: {
        [x: string]: {
            [x: number]: Array<import("./IP").default>;
        };
    };
    /** @type {Object<number,Array<import("./IP").default>>} */
    indexedIipBuffer: {
        [x: number]: Array<import("./IP").default>;
    };
    /** @type {Object<number,Array<import("./IP").default>>} */
    indexedBuffer: {
        [x: number]: Array<import("./IP").default>;
    };
    /** @type {Object<string,Array<import("./IP").default>>} */
    scopedBuffer: {
        [x: string]: Array<import("./IP").default>;
    };
    /** @type {Array<import("./IP").default>} */
    iipBuffer: Array<import("./IP").default>;
    /** @type {Array<import("./IP").default>} */
    buffer: Array<import("./IP").default>;
    /**
     * @param {import("./IP").default} ip
     * @returns {Array<import("./IP").default>}
     */
    prepareBufferForIP(ip: import("./IP").default): Array<import("./IP").default>;
    validateData(data: any): void;
    /**
     * @param {string|null} scope
     * @param {number|null} index
     * @param {boolean} [initial]
     * @returns {Array<import("./IP").default>}
     */
    getBuffer(scope: string | null, index: number | null, initial?: boolean): Array<import("./IP").default>;
    /**
     * @param {string|null} scope
     * @param {number|null} index
     * @param {boolean} [initial]
     * @returns {import("./IP").default|void}
     */
    getFromBuffer(scope: string | null, index: number | null, initial?: boolean): import("./IP").default | void;
    get(scope: any, index: any): void | import("./IP").default;
    hasIPinBuffer(scope: any, index: any, validate: any, initial?: boolean): boolean;
    hasIIP(index: any, validate: any): boolean;
    has(scope: any, index: any, validate: any): boolean;
    length(scope: any, index: any): number;
    ready(scope: any): boolean;
    clear(): void;
}
export type InPortOptions = {
    control?: boolean;
    triggering?: boolean;
};
export type PortOptions = import("./BasePort").BaseOptions & InPortOptions;
import BasePort from "./BasePort";
