/**
 * @callback NetworkCallback
 * @param {Error | null} err
 * @param {Network|LegacyNetwork} [network]
 */
/**
 * @typedef CreateNetworkOptions
 * @property {boolean} [subscribeGraph] - Whether the Network should monitor the graph
 * @property {boolean} [delay] - Whether the Network should be started later
 */
/**
 * @typedef { CreateNetworkOptions & import("./BaseNetwork").NetworkOptions} NetworkOptions
 */
/**
 * @param {import("fbp-graph").Graph} graphInstance - Graph definition to build a Network for
 * @param {NetworkOptions} options - Network options
 * @param {NetworkCallback} [callback] - Legacy callback for the created Network
 * @returns {Promise<Network|LegacyNetwork>}
 */
export function createNetwork(graphInstance: import("fbp-graph").Graph, options: NetworkOptions, callback?: NetworkCallback): Promise<Network | LegacyNetwork>;
/**
 * @param {string} file
 * @param {NetworkOptions} options - Network options
 * @param {any} [callback] - Legacy callback
 * @returning {Promise<Network>}
 */
export function loadFile(file: string, options: NetworkOptions, callback?: any): Promise<Network | LegacyNetwork>;
/**
 * @param {graph.Graph} graphInstance
 * @param {string} file
 * @param {any} [callback] - Legacy callback
 * @returning {Promise<string>}
 */
export function saveFile(graphInstance: graph.Graph, file: string, callback?: any): void;
export { isBrowser } from "./Platform";
export { ComponentLoader } from "./ComponentLoader";
export { Component } from "./Component";
export { default as InPort } from "./InPort";
export { default as OutPort } from "./OutPort";
export { internalSocket };
export { default as IP } from "./IP";
export { asComponent } from "./AsComponent";
export type NetworkCallback = (err: Error | null, network?: Network | LegacyNetwork) => any;
export type CreateNetworkOptions = {
    /**
     * - Whether the Network should monitor the graph
     */
    subscribeGraph?: boolean;
    /**
     * - Whether the Network should be started later
     */
    delay?: boolean;
};
export type NetworkOptions = CreateNetworkOptions & import("./BaseNetwork").NetworkOwnOptions & import("./ComponentLoader").ComponentLoaderOptions;
import { Network } from "./Network";
import { LegacyNetwork } from "./LegacyNetwork";
import { graph } from "fbp-graph";
import * as internalSocket from "./InternalSocket";
export { graph, Graph, journal, Journal } from "fbp-graph";
export { InPorts, OutPorts } from "./Ports";
export { asCallback, asPromise } from "./AsCallback";
