/**
 * @typedef OutPortOptions
 * @property {boolean} [caching]
 */
/**
 * @typedef {import("./BasePort").BaseOptions & OutPortOptions} PortOptions
 */
export default class OutPort extends BasePort {
    /**
     * @param {PortOptions} options - Options for the outport
     */
    constructor(options?: PortOptions);
    cache: {};
    connect(index?: any): void;
    beginGroup(group: any, index?: any): void;
    send(data: any, index?: any): void;
    endGroup(index?: any): void;
    disconnect(index?: any): void;
    sendIP(type: any, data: any, options: any, index: any, autoConnect?: boolean): OutPort;
    openBracket(data?: any, options?: {}, index?: any): OutPort;
    data(data: any, options?: {}, index?: any): OutPort;
    closeBracket(data?: any, options?: {}, index?: any): OutPort;
    checkRequired(sockets: any): void;
    getSockets(index: any): import("./InternalSocket").InternalSocket[];
    isCaching(): boolean;
}
export type OutPortOptions = {
    caching?: boolean;
};
export type PortOptions = import("./BasePort").BaseOptions & OutPortOptions;
import BasePort from "./BasePort";
