/**
 * @param {string} name
 * @returns {{ name: string, index?: string }}
 */
export function normalizePortName(name: string): {
    name: string;
    index?: string;
};
/**
 * @typedef {{ [key: string]: InPort|import("./InPort").PortOptions }} InPortsOptions
 */
export class InPorts extends Ports {
    /**
     * @param {InPortsOptions} [ports]
     */
    constructor(ports?: InPortsOptions);
}
/**
 * @typedef {{ [key: string]: OutPort|import("./OutPort").PortOptions }} OutPortsOptions
 */
export class OutPorts extends Ports {
    /**
     * @param {OutPortsOptions} [ports]
     */
    constructor(ports?: OutPortsOptions);
    connect(name: any, socketId: any): void;
    beginGroup(name: any, group: any, socketId: any): void;
    send(name: any, data: any, socketId: any): void;
    endGroup(name: any, socketId: any): void;
    disconnect(name: any, socketId: any): void;
}
export type PortOptions = {
    description?: string;
    datatype?: string;
    schema?: string;
    type?: string;
    required?: boolean;
    scoped?: boolean;
};
export type InPortsOptions = {
    [key: string]: import("./InPort").PortOptions | InPort;
};
export type OutPortsOptions = {
    [key: string]: import("./OutPort").PortOptions | OutPort;
};
/**
 * @typedef {import("./BasePort").BaseOptions} PortOptions
 */
declare class Ports extends EventEmitter {
    /**
     * @param {Object<string, import("./BasePort").default|PortOptions>} ports
     * @param {typeof import("./BasePort").default} model
     */
    constructor(ports: {
        [x: string]: import("./BasePort").default | PortOptions;
    }, model: typeof import("./BasePort").default);
    model: typeof import("./BasePort").default;
    /** @type {Object<string, import("./BasePort").default>} */
    ports: {
        [x: string]: import("./BasePort").default;
    };
    /**
     * @param {string} name
     * @param {Object|import("./BasePort").default|PortOptions} [options]
     */
    add(name: string, options?: any | import("./BasePort").default | PortOptions): Ports;
    /**
     * @param {string} name
     */
    remove(name: string): Ports;
}
import InPort from "./InPort";
import OutPort from "./OutPort";
import { EventEmitter } from "events";
export {};
