export default class ProcessContext {
    /**
     * @param {import("./IP").default} ip - IP for this processing context
     * @param {import("./Component").Component} nodeInstance - Component being run
     * @param {import("./InPort").default} port - InPort that triggered this context
     * @param {Object<string, any>} result
     */
    constructor(ip: import("./IP").default, nodeInstance: import("./Component").Component, port: import("./InPort").default, result: {
        [x: string]: any;
    });
    ip: import("./IP").default;
    nodeInstance: import("./Component").Component;
    port: import("./InPort").default;
    result: {
        [x: string]: any;
    };
    scope: string;
    activated: boolean;
    deactivated: boolean;
    activate(): void;
    deactivate(): void;
}
