export default class ProcessInput {
    /**
     * @param {import("./Ports").InPorts} ports - Component inports
     * @param {import("./ProcessContext").default} context - Processing context
     */
    constructor(ports: import("./Ports").InPorts, context: import("./ProcessContext").default);
    ports: import("./Ports").InPorts;
    context: import("./ProcessContext").default;
    nodeInstance: import("./Component").Component;
    ip: IP;
    port: import("./InPort").default;
    result: {
        [x: string]: any;
    };
    scope: string;
    activate(): void;
    /**
     * @param {...string} params - Port names to check for attachment
     * @returns {Array<number> | Array<Array<number>>}
     */
    attached(...params: string[]): Array<number> | Array<Array<number>>;
    /**
     * @callback HasValidationCallback
     * @param {IP} ip
     * @returns {boolean}
     */
    /**
     * @typedef {string|Array<string|number>} GetArgument
     */
    /**
     * @typedef {GetArgument|HasValidationCallback} HasArgument
     */
    /**
     * @param {...HasArgument} params
     */
    has(...params: (string | (string | number)[] | ((ip: IP) => boolean))[]): boolean;
    /**
     * @param {...string} params - Port names to check for data packets
     * @returns {boolean}
     */
    hasData(...params: string[]): boolean;
    /**
     * @param {...HasArgument} params - Port names to check for streams
     * @returns {boolean}
     */
    hasStream(...params: (string | (string | number)[] | ((ip: IP) => boolean))[]): boolean;
    /**
     * @param {...GetArgument} params
     * @returns {void|IP|Array<IP|void>}
     */
    get(...params: (string | (string | number)[])[]): void | IP | Array<IP | void>;
    /**
     * @private
     * @param {string} port
     * @param {number} [idx]
     * @returns {IP|void}
     */
    private __getForForwarding;
    /**
     * @param {...GetArgument} params
     * @returns {any|Array<any>}
     */
    getData(...params: (string | (string | number)[])[]): any | Array<any>;
    /**
     * @param {...GetArgument} params
     * @returns {void|Array<IP>|Array<void|Array<IP>>}
     */
    getStream(...params: (string | (string | number)[])[]): void | Array<IP> | Array<void | Array<IP>>;
}
import IP from "./IP";
