export default class ProcessOutput {
    /**
     * @param {import("./Ports").OutPorts} ports - Component outports
     * @param {import("./ProcessContext").default} context - Processing context
     */
    constructor(ports: import("./Ports").OutPorts, context: import("./ProcessContext").default);
    ports: import("./Ports").OutPorts;
    context: import("./ProcessContext").default;
    nodeInstance: import("./Component").Component;
    ip: IP;
    result: {
        [x: string]: any;
    };
    scope: string;
    /**
     * @param {Error|Error[]} err
     * @returns {void}
     */
    error(err: Error | Error[]): void;
    /**
     * @param {string} port - Port to send to
     * @param {IP|any} packet - IP or data to send
     * @returns {void}
     */
    sendIP(port: string, packet: IP | any): void;
    /**
     * @param {Error|Array<Error>|Object<string, any>} outputMap
     */
    send(outputMap: Error | Array<Error> | {
        [x: string]: any;
    }): void;
    /**
     * @param {Error|Array<Error>|Object<string, any>} outputMap
     */
    sendDone(outputMap: Error | Array<Error> | {
        [x: string]: any;
    }): void;
    /**
     * @param {any} data
     * @param {Object<string, any>} [options]
     */
    pass(data: any, options?: {
        [x: string]: any;
    }): void;
    /**
     * @param {Error|Array<Error>} [error]
     */
    done(error?: Error | Array<Error>): void;
}
import IP from "./IP";
