/**
 * @param {import("../ComponentLoader").ComponentLoader} loader
 * @param {string} packageId
 * @param {string} name
 * @param {string} source
 * @param {string} language
 * @param {TranspileCallback} callback
 * @returns {void}
 */
export function setSource(loader: import("../ComponentLoader").ComponentLoader, packageId: string, name: string, source: string, language: string, callback: TranspileCallback): void;
/**
 * @callback SourceCallback
 * @param {Error|null} error
 * @param {Object} [source]
 * @param {string} [source.name]
 * @param {string} [source.library]
 * @param {string} [source.code]
 * @param {string} [source.language]
 * @param {string} [source.tests]
 * @returns {void}
 */
/**
 * @param {import("../ComponentLoader").ComponentLoader} loader
 * @param {string} name
 * @param {SourceCallback} callback
 * @returns {void}
 */
export function getSource(loader: import("../ComponentLoader").ComponentLoader, name: string, callback: SourceCallback): void;
/**
 * @returns {Array<string>}
 */
export function getLanguages(): Array<string>;
/**
 * @callback RegistrationCallback
 * @param {Error|null} error
 * @param {Object<string, string>} [modules]
 */
/**
 * @param {import("../ComponentLoader").ComponentLoader} loader
 * @param {RegistrationCallback} callback
 */
export function register(loader: import("../ComponentLoader").ComponentLoader, callback: RegistrationCallback): void;
/**
 * @callback ModuleLoadingCallback
 * @param {Error|null} error
 * @param {import("../Component").Component} [instance]
 * @returns {void}
 */
/**
 * @param {string} name
 * @param {string} cPath
 * @param {Object} metadata
 * @param {ModuleLoadingCallback} callback
 */
export function dynamicLoad(name: string, cPath: string, metadata: any, callback: ModuleLoadingCallback): void;
export type ErrorableCallback = (error: Error | null) => any;
export type TranspileCallback = (error: Error | null, source?: string) => void;
export type EvaluationCallback = (error: Error | null, module?: any | Function) => void;
export type SourceCallback = (error: Error | null, source?: any, name?: string, library?: string, code?: string, language?: string, tests?: string) => void;
export type RegistrationCallback = (error: Error | null, modules?: {
    [x: string]: string;
}) => any;
export type ModuleLoadingCallback = (error: Error | null, instance?: import("../Component").Component) => void;
