# noncharacters [![NPM version](https://badge.fury.io/js/noncharacters.svg)](http://badge.fury.io/js/noncharacters)

> 34 non-character code points (labeled <not a character>), that are set aside and guaranteed to never be used for a character. Perfect to use for placeholders or temporary replacements during string transformations.

See the wikipedia [article on non-characters][wiki]. Also, I used [regenerate](https://github.com/mathiasbynens/regenerate) from [mathiasbynens](https://github.com/mathiasbynens) to generate the range of characters. 

## Install with [npm](npmjs.org)

```bash
npm i noncharacters --save
```

## Usage

```js
var noncharacters = require('noncharacters');
//=> ['\uFFFF', '\uFFFE', ...]
```

**Example**

Let's say you need to transform a string but you need to temporarily replace some characters that might cause issues. 

Create your own placeholders:

```js
// arbitrary characters we want to replace, 
// mapped to placeholder non-characters
var placeholders = {
  '{': noncharacters[0],
  '}': noncharacters[1]
};

// the string with characters to replace
var str = 'This is a template: {name}';

// actually replace the characters
Object.keys(placeholders).forEach(function(ch) {
  str = str.replace(ch, placeholders[ch]);
});
//=> This is a template: \uFFFFname\uFFFE
```
Now you can do whatever you want to `str`. Then, to change back:

```js
Object.keys(placeholders).forEach(function(ch) {
  str = str.replace(placeholders[ch], ch);
});
//=> This is a template: {name}
```


## Run tests

Install dev dependencies:

```bash
npm i -d && npm test
```

## Contributing
Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](https://github.com/jonschlinkert/noncharacters/issues)

## Author

**Jon Schlinkert**
 
+ [github/jonschlinkert](https://github.com/jonschlinkert)
+ [twitter/jonschlinkert](http://twitter.com/jonschlinkert) 

## License
Copyright (c) 2015 Jon Schlinkert  
Released under the MIT license

***

_This file was generated by [verb-cli](https://github.com/assemble/verb-cli) on February 27, 2015._


[wiki]: http://en.wikipedia.org/wiki/Universal_Character_Set_characters#Noncharacters
