var getBounds = require('bound-points')
var unlerp = require('unlerp')

module.exports = normalizePathScale
function normalizePathScale (positions, bounds) {
  if (!Array.isArray(positions)) {
    throw new TypeError('must specify positions as first argument')
  }
  if (!Array.isArray(bounds)) {
    bounds = getBounds(positions)
  }

  var min = bounds[0]
  var max = bounds[1]

  var width = max[0] - min[0]
  var height = max[1] - min[1]

  var aspectX = width > height ? 1 : (height / width)
  var aspectY = width > height ? (width / height) : 1

  if (max[0] - min[0] === 0 || max[1] - min[1] === 0) {
    return positions // div by zero; leave positions unchanged
  }

  for (var i = 0; i < positions.length; i++) {
    var pos = positions[i]
    pos[0] = (unlerp(min[0], max[0], pos[0]) * 2 - 1) / aspectX
    pos[1] = (unlerp(min[1], max[1], pos[1]) * 2 - 1) / aspectY
  }
  return positions
}