(function(){ var curSystem = typeof System != 'undefined' ? System : undefined;
(function(global) {
  'use strict';
  if (global.$traceurRuntime) {
    return;
  }
  function setupGlobals(global) {
    global.Reflect = global.Reflect || {};
    global.Reflect.global = global.Reflect.global || global;
  }
  setupGlobals(global);
  var typeOf = function(x) {
    return typeof x;
  };
  global.$traceurRuntime = {
    options: {},
    setupGlobals: setupGlobals,
    typeof: typeOf
  };
})(typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : this);
(function() {
  function buildFromEncodedParts(opt_scheme, opt_userInfo, opt_domain, opt_port, opt_path, opt_queryData, opt_fragment) {
    var out = [];
    if (opt_scheme) {
      out.push(opt_scheme, ':');
    }
    if (opt_domain) {
      out.push('//');
      if (opt_userInfo) {
        out.push(opt_userInfo, '@');
      }
      out.push(opt_domain);
      if (opt_port) {
        out.push(':', opt_port);
      }
    }
    if (opt_path) {
      out.push(opt_path);
    }
    if (opt_queryData) {
      out.push('?', opt_queryData);
    }
    if (opt_fragment) {
      out.push('#', opt_fragment);
    }
    return out.join('');
  }
  var splitRe = new RegExp('^' + '(?:' + '([^:/?#.]+)' + ':)?' + '(?://' + '(?:([^/?#]*)@)?' + '([\\w\\d\\-\\u0100-\\uffff.%]*)' + '(?::([0-9]+))?' + ')?' + '([^?#]+)?' + '(?:\\?([^#]*))?' + '(?:#(.*))?' + '$');
  var ComponentIndex = {
    SCHEME: 1,
    USER_INFO: 2,
    DOMAIN: 3,
    PORT: 4,
    PATH: 5,
    QUERY_DATA: 6,
    FRAGMENT: 7
  };
  function split(uri) {
    return (uri.match(splitRe));
  }
  function removeDotSegments(path) {
    if (path === '/')
      return '/';
    var leadingSlash = path[0] === '/' ? '/' : '';
    var trailingSlash = path.slice(-1) === '/' ? '/' : '';
    var segments = path.split('/');
    var out = [];
    var up = 0;
    for (var pos = 0; pos < segments.length; pos++) {
      var segment = segments[pos];
      switch (segment) {
        case '':
        case '.':
          break;
        case '..':
          if (out.length)
            out.pop();
          else
            up++;
          break;
        default:
          out.push(segment);
      }
    }
    if (!leadingSlash) {
      while (up-- > 0) {
        out.unshift('..');
      }
      if (out.length === 0)
        out.push('.');
    }
    return leadingSlash + out.join('/') + trailingSlash;
  }
  function joinAndCanonicalizePath(parts) {
    var path = parts[ComponentIndex.PATH] || '';
    path = removeDotSegments(path);
    parts[ComponentIndex.PATH] = path;
    return buildFromEncodedParts(parts[ComponentIndex.SCHEME], parts[ComponentIndex.USER_INFO], parts[ComponentIndex.DOMAIN], parts[ComponentIndex.PORT], parts[ComponentIndex.PATH], parts[ComponentIndex.QUERY_DATA], parts[ComponentIndex.FRAGMENT]);
  }
  function canonicalizeUrl(url) {
    var parts = split(url);
    return joinAndCanonicalizePath(parts);
  }
  function resolveUrl(base, url) {
    var parts = split(url);
    var baseParts = split(base);
    if (parts[ComponentIndex.SCHEME]) {
      return joinAndCanonicalizePath(parts);
    } else {
      parts[ComponentIndex.SCHEME] = baseParts[ComponentIndex.SCHEME];
    }
    for (var i = ComponentIndex.SCHEME; i <= ComponentIndex.PORT; i++) {
      if (!parts[i]) {
        parts[i] = baseParts[i];
      }
    }
    if (parts[ComponentIndex.PATH][0] == '/') {
      return joinAndCanonicalizePath(parts);
    }
    var path = baseParts[ComponentIndex.PATH];
    var index = path.lastIndexOf('/');
    path = path.slice(0, index + 1) + parts[ComponentIndex.PATH];
    parts[ComponentIndex.PATH] = path;
    return joinAndCanonicalizePath(parts);
  }
  function isAbsolute(name) {
    if (!name)
      return false;
    if (name[0] === '/')
      return true;
    var parts = split(name);
    if (parts[ComponentIndex.SCHEME])
      return true;
    return false;
  }
  $traceurRuntime.canonicalizeUrl = canonicalizeUrl;
  $traceurRuntime.isAbsolute = isAbsolute;
  $traceurRuntime.removeDotSegments = removeDotSegments;
  $traceurRuntime.resolveUrl = resolveUrl;
})();
(function(global) {
  'use strict';
  var $__3 = $traceurRuntime,
      canonicalizeUrl = $__3.canonicalizeUrl,
      resolveUrl = $__3.resolveUrl,
      isAbsolute = $__3.isAbsolute;
  var moduleInstantiators = Object.create(null);
  var baseURL;
  if (global.location && global.location.href)
    baseURL = resolveUrl(global.location.href, './');
  else
    baseURL = '';
  function UncoatedModuleEntry(url, uncoatedModule) {
    this.url = url;
    this.value_ = uncoatedModule;
  }
  function ModuleEvaluationError(erroneousModuleName, cause) {
    this.message = this.constructor.name + ': ' + this.stripCause(cause) + ' in ' + erroneousModuleName;
    if (!(cause instanceof ModuleEvaluationError) && cause.stack)
      this.stack = this.stripStack(cause.stack);
    else
      this.stack = '';
  }
  ModuleEvaluationError.prototype = Object.create(Error.prototype);
  ModuleEvaluationError.prototype.constructor = ModuleEvaluationError;
  ModuleEvaluationError.prototype.stripError = function(message) {
    return message.replace(/.*Error:/, this.constructor.name + ':');
  };
  ModuleEvaluationError.prototype.stripCause = function(cause) {
    if (!cause)
      return '';
    if (!cause.message)
      return cause + '';
    return this.stripError(cause.message);
  };
  ModuleEvaluationError.prototype.loadedBy = function(moduleName) {
    this.stack += '\n loaded by ' + moduleName;
  };
  ModuleEvaluationError.prototype.stripStack = function(causeStack) {
    var stack = [];
    causeStack.split('\n').some(function(frame) {
      if (/UncoatedModuleInstantiator/.test(frame))
        return true;
      stack.push(frame);
    });
    stack[0] = this.stripError(stack[0]);
    return stack.join('\n');
  };
  function beforeLines(lines, number) {
    var result = [];
    var first = number - 3;
    if (first < 0)
      first = 0;
    for (var i = first; i < number; i++) {
      result.push(lines[i]);
    }
    return result;
  }
  function afterLines(lines, number) {
    var last = number + 1;
    if (last > lines.length - 1)
      last = lines.length - 1;
    var result = [];
    for (var i = number; i <= last; i++) {
      result.push(lines[i]);
    }
    return result;
  }
  function columnSpacing(columns) {
    var result = '';
    for (var i = 0; i < columns - 1; i++) {
      result += '-';
    }
    return result;
  }
  function UncoatedModuleInstantiator(url, func) {
    UncoatedModuleEntry.call(this, url, null);
    this.func = func;
  }
  UncoatedModuleInstantiator.prototype = Object.create(UncoatedModuleEntry.prototype);
  UncoatedModuleInstantiator.prototype.getUncoatedModule = function() {
    var $__2 = this;
    if (this.value_)
      return this.value_;
    try {
      var relativeRequire;
      if (typeof $traceurRuntime !== undefined && $traceurRuntime.require) {
        relativeRequire = $traceurRuntime.require.bind(null, this.url);
      }
      return this.value_ = this.func.call(global, relativeRequire);
    } catch (ex) {
      if (ex instanceof ModuleEvaluationError) {
        ex.loadedBy(this.url);
        throw ex;
      }
      if (ex.stack) {
        var lines = this.func.toString().split('\n');
        var evaled = [];
        ex.stack.split('\n').some(function(frame, index) {
          if (frame.indexOf('UncoatedModuleInstantiator.getUncoatedModule') > 0)
            return true;
          var m = /(at\s[^\s]*\s).*>:(\d*):(\d*)\)/.exec(frame);
          if (m) {
            var line = parseInt(m[2], 10);
            evaled = evaled.concat(beforeLines(lines, line));
            if (index === 1) {
              evaled.push(columnSpacing(m[3]) + '^ ' + $__2.url);
            } else {
              evaled.push(columnSpacing(m[3]) + '^');
            }
            evaled = evaled.concat(afterLines(lines, line));
            evaled.push('= = = = = = = = =');
          } else {
            evaled.push(frame);
          }
        });
        ex.stack = evaled.join('\n');
      }
      throw new ModuleEvaluationError(this.url, ex);
    }
  };
  function getUncoatedModuleInstantiator(name) {
    if (!name)
      return;
    var url = ModuleStore.normalize(name);
    return moduleInstantiators[url];
  }
  ;
  var moduleInstances = Object.create(null);
  var liveModuleSentinel = {};
  function Module(uncoatedModule) {
    var isLive = arguments[1];
    var coatedModule = Object.create(null);
    Object.getOwnPropertyNames(uncoatedModule).forEach(function(name) {
      var getter,
          value;
      if (isLive === liveModuleSentinel) {
        var descr = Object.getOwnPropertyDescriptor(uncoatedModule, name);
        if (descr.get)
          getter = descr.get;
      }
      if (!getter) {
        value = uncoatedModule[name];
        getter = function() {
          return value;
        };
      }
      Object.defineProperty(coatedModule, name, {
        get: getter,
        enumerable: true
      });
    });
    Object.preventExtensions(coatedModule);
    return coatedModule;
  }
  var ModuleStore = {
    normalize: function(name, refererName, refererAddress) {
      if (typeof name !== 'string')
        throw new TypeError('module name must be a string, not ' + typeof name);
      if (isAbsolute(name))
        return canonicalizeUrl(name);
      if (/[^\.]\/\.\.\//.test(name)) {
        throw new Error('module name embeds /../: ' + name);
      }
      if (name[0] === '.' && refererName)
        return resolveUrl(refererName, name);
      return canonicalizeUrl(name);
    },
    get: function(normalizedName) {
      var m = getUncoatedModuleInstantiator(normalizedName);
      if (!m)
        return undefined;
      var moduleInstance = moduleInstances[m.url];
      if (moduleInstance)
        return moduleInstance;
      moduleInstance = Module(m.getUncoatedModule(), liveModuleSentinel);
      return moduleInstances[m.url] = moduleInstance;
    },
    set: function(normalizedName, module) {
      normalizedName = String(normalizedName);
      moduleInstantiators[normalizedName] = new UncoatedModuleInstantiator(normalizedName, function() {
        return module;
      });
      moduleInstances[normalizedName] = module;
    },
    get baseURL() {
      return baseURL;
    },
    set baseURL(v) {
      baseURL = String(v);
    },
    registerModule: function(name, deps, func) {
      var normalizedName = ModuleStore.normalize(name);
      if (moduleInstantiators[normalizedName])
        throw new Error('duplicate module named ' + normalizedName);
      moduleInstantiators[normalizedName] = new UncoatedModuleInstantiator(normalizedName, func);
    },
    bundleStore: Object.create(null),
    register: function(name, deps, func) {
      if (!deps || !deps.length && !func.length) {
        this.registerModule(name, deps, func);
      } else {
        this.bundleStore[name] = {
          deps: deps,
          execute: function() {
            var $__2 = arguments;
            var depMap = {};
            deps.forEach(function(dep, index) {
              return depMap[dep] = $__2[index];
            });
            var registryEntry = func.call(this, depMap);
            registryEntry.execute.call(this);
            return registryEntry.exports;
          }
        };
      }
    },
    getAnonymousModule: function(func) {
      return new Module(func.call(global), liveModuleSentinel);
    }
  };
  var moduleStoreModule = new Module({ModuleStore: ModuleStore});
  ModuleStore.set('@traceur/src/runtime/ModuleStore.js', moduleStoreModule);
  var setupGlobals = $traceurRuntime.setupGlobals;
  $traceurRuntime.setupGlobals = function(global) {
    setupGlobals(global);
  };
  $traceurRuntime.ModuleStore = ModuleStore;
  $traceurRuntime.registerModule = ModuleStore.registerModule.bind(ModuleStore);
  $traceurRuntime.getModule = ModuleStore.get;
  $traceurRuntime.setModule = ModuleStore.set;
  $traceurRuntime.normalizeModuleName = ModuleStore.normalize;
})(typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : this);
$traceurRuntime.registerModule("traceur-runtime@0.0.102/src/runtime/new-unique-string.js", [], function() {
  "use strict";
  var __moduleName = "traceur-runtime@0.0.102/src/runtime/new-unique-string.js";
  var random = Math.random;
  var counter = Date.now() % 1e9;
  function newUniqueString() {
    return '__$' + (random() * 1e9 >>> 1) + '$' + ++counter + '$__';
  }
  var $__default = newUniqueString;
  return {get default() {
      return $__default;
    }};
});
$traceurRuntime.registerModule("traceur-runtime@0.0.102/src/runtime/has-native-symbols.js", [], function() {
  "use strict";
  var __moduleName = "traceur-runtime@0.0.102/src/runtime/has-native-symbols.js";
  var v = !!Object.getOwnPropertySymbols && typeof Symbol === 'function';
  function hasNativeSymbol() {
    return v;
  }
  var $__default = hasNativeSymbol;
  return {get default() {
      return $__default;
    }};
});
$traceurRuntime.registerModule("traceur-runtime@0.0.102/src/runtime/symbols.js", [], function() {
  "use strict";
  var __moduleName = "traceur-runtime@0.0.102/src/runtime/symbols.js";
  var newUniqueString = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./new-unique-string.js", "traceur-runtime@0.0.102/src/runtime/symbols.js")).default;
  var hasNativeSymbol = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./has-native-symbols.js", "traceur-runtime@0.0.102/src/runtime/symbols.js")).default;
  var $create = Object.create;
  var $defineProperty = Object.defineProperty;
  var $freeze = Object.freeze;
  var $getOwnPropertyNames = Object.getOwnPropertyNames;
  var $keys = Object.keys;
  var $TypeError = TypeError;
  function nonEnum(value) {
    return {
      configurable: true,
      enumerable: false,
      value: value,
      writable: true
    };
  }
  var symbolInternalProperty = newUniqueString();
  var symbolDescriptionProperty = newUniqueString();
  var symbolDataProperty = newUniqueString();
  var symbolValues = $create(null);
  var SymbolImpl = function Symbol(description) {
    var value = new SymbolValue(description);
    if (!(this instanceof SymbolImpl))
      return value;
    throw new $TypeError('Symbol cannot be new\'ed');
  };
  $defineProperty(SymbolImpl.prototype, 'constructor', nonEnum(SymbolImpl));
  $defineProperty(SymbolImpl.prototype, 'toString', nonEnum(function() {
    var symbolValue = this[symbolDataProperty];
    return symbolValue[symbolInternalProperty];
  }));
  $defineProperty(SymbolImpl.prototype, 'valueOf', nonEnum(function() {
    var symbolValue = this[symbolDataProperty];
    if (!symbolValue)
      throw $TypeError('Conversion from symbol to string');
    return symbolValue[symbolInternalProperty];
  }));
  function SymbolValue(description) {
    var key = newUniqueString();
    $defineProperty(this, symbolDataProperty, {value: this});
    $defineProperty(this, symbolInternalProperty, {value: key});
    $defineProperty(this, symbolDescriptionProperty, {value: description});
    $freeze(this);
    symbolValues[key] = this;
  }
  $defineProperty(SymbolValue.prototype, 'constructor', nonEnum(SymbolImpl));
  $defineProperty(SymbolValue.prototype, 'toString', {
    value: SymbolImpl.prototype.toString,
    enumerable: false
  });
  $defineProperty(SymbolValue.prototype, 'valueOf', {
    value: SymbolImpl.prototype.valueOf,
    enumerable: false
  });
  $freeze(SymbolValue.prototype);
  function isSymbolString(s) {
    return symbolValues[s];
  }
  function removeSymbolKeys(array) {
    var rv = [];
    for (var i = 0; i < array.length; i++) {
      if (!isSymbolString(array[i])) {
        rv.push(array[i]);
      }
    }
    return rv;
  }
  function getOwnPropertyNames(object) {
    return removeSymbolKeys($getOwnPropertyNames(object));
  }
  function keys(object) {
    return removeSymbolKeys($keys(object));
  }
  function getOwnPropertySymbols(object) {
    var rv = [];
    var names = $getOwnPropertyNames(object);
    for (var i = 0; i < names.length; i++) {
      var symbol = symbolValues[names[i]];
      if (symbol) {
        rv.push(symbol);
      }
    }
    return rv;
  }
  function polyfillSymbol(global) {
    var Object = global.Object;
    if (!hasNativeSymbol()) {
      global.Symbol = SymbolImpl;
      Object.getOwnPropertyNames = getOwnPropertyNames;
      Object.keys = keys;
      $defineProperty(Object, 'getOwnPropertySymbols', nonEnum(getOwnPropertySymbols));
    }
    if (!global.Symbol.iterator) {
      global.Symbol.iterator = global.Symbol('Symbol.iterator');
    }
    if (!global.Symbol.observer) {
      global.Symbol.observer = global.Symbol('Symbol.observer');
    }
  }
  var g = typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : this;
  polyfillSymbol(g);
  var typeOf = hasNativeSymbol() ? function(x) {
    return typeof x;
  } : function(x) {
    return x instanceof SymbolValue ? 'symbol' : typeof x;
  };
  $traceurRuntime.typeof = typeOf;
  return {};
});
$traceurRuntime.registerModule("traceur-runtime@0.0.102/src/runtime/classes.js", [], function() {
  "use strict";
  var __moduleName = "traceur-runtime@0.0.102/src/runtime/classes.js";
  var $Object = Object;
  var $TypeError = TypeError;
  var $__1 = Object,
      create = $__1.create,
      defineProperties = $__1.defineProperties,
      defineProperty = $__1.defineProperty,
      getOwnPropertyDescriptor = $__1.getOwnPropertyDescriptor,
      getOwnPropertyNames = $__1.getOwnPropertyNames,
      getOwnPropertySymbols = $__1.getOwnPropertySymbols,
      getPrototypeOf = $__1.getPrototypeOf;
  function superDescriptor(homeObject, name) {
    var proto = getPrototypeOf(homeObject);
    do {
      var result = getOwnPropertyDescriptor(proto, name);
      if (result)
        return result;
      proto = getPrototypeOf(proto);
    } while (proto);
    return undefined;
  }
  function superConstructor(ctor) {
    return ctor.__proto__;
  }
  function superGet(self, homeObject, name) {
    var descriptor = superDescriptor(homeObject, name);
    if (descriptor) {
      var value = descriptor.value;
      if (value)
        return value;
      if (!descriptor.get)
        return value;
      return descriptor.get.call(self);
    }
    return undefined;
  }
  function superSet(self, homeObject, name, value) {
    var descriptor = superDescriptor(homeObject, name);
    if (descriptor && descriptor.set) {
      descriptor.set.call(self, value);
      return value;
    }
    throw $TypeError(("super has no setter '" + name + "'."));
  }
  function forEachPropertyKey(object, f) {
    getOwnPropertyNames(object).forEach(f);
    if (getOwnPropertySymbols) {
      getOwnPropertySymbols(object).forEach(f);
    }
  }
  function getDescriptors(object) {
    var descriptors = {};
    forEachPropertyKey(object, function(key) {
      descriptors[key] = getOwnPropertyDescriptor(object, key);
      descriptors[key].enumerable = false;
    });
    return descriptors;
  }
  var nonEnum = {enumerable: false};
  function makePropertiesNonEnumerable(object) {
    forEachPropertyKey(object, function(key) {
      defineProperty(object, key, nonEnum);
    });
  }
  function createClass(ctor, object, staticObject, superClass) {
    defineProperty(object, 'constructor', {
      value: ctor,
      configurable: true,
      enumerable: false,
      writable: true
    });
    if (arguments.length > 3) {
      if (typeof superClass === 'function')
        ctor.__proto__ = superClass;
      ctor.prototype = create(getProtoParent(superClass), getDescriptors(object));
    } else {
      makePropertiesNonEnumerable(object);
      ctor.prototype = object;
    }
    defineProperty(ctor, 'prototype', {
      configurable: false,
      writable: false
    });
    return defineProperties(ctor, getDescriptors(staticObject));
  }
  function getProtoParent(superClass) {
    if (typeof superClass === 'function') {
      var prototype = superClass.prototype;
      if ($Object(prototype) === prototype || prototype === null)
        return superClass.prototype;
      throw new $TypeError('super prototype must be an Object or null');
    }
    if (superClass === null)
      return null;
    throw new $TypeError(("Super expression must either be null or a function, not " + typeof superClass + "."));
  }
  $traceurRuntime.createClass = createClass;
  $traceurRuntime.superConstructor = superConstructor;
  $traceurRuntime.superGet = superGet;
  $traceurRuntime.superSet = superSet;
  return {};
});
$traceurRuntime.registerModule("traceur-runtime@0.0.102/src/runtime/exportStar.js", [], function() {
  "use strict";
  var __moduleName = "traceur-runtime@0.0.102/src/runtime/exportStar.js";
  var $__1 = Object,
      defineProperty = $__1.defineProperty,
      getOwnPropertyNames = $__1.getOwnPropertyNames;
  function exportStar(object) {
    var $__2 = arguments,
        $__3 = function(i) {
          var mod = $__2[i];
          var names = getOwnPropertyNames(mod);
          var $__5 = function(j) {
            var name = names[j];
            if (name === '__esModule' || name === 'default') {
              return 0;
            }
            defineProperty(object, name, {
              get: function() {
                return mod[name];
              },
              enumerable: true
            });
          },
              $__6;
          $__4: for (var j = 0; j < names.length; j++) {
            $__6 = $__5(j);
            switch ($__6) {
              case 0:
                continue $__4;
            }
          }
        };
    for (var i = 1; i < arguments.length; i++) {
      $__3(i);
    }
    return object;
  }
  $traceurRuntime.exportStar = exportStar;
  return {};
});
$traceurRuntime.registerModule("traceur-runtime@0.0.102/src/runtime/private-symbol.js", [], function() {
  "use strict";
  var __moduleName = "traceur-runtime@0.0.102/src/runtime/private-symbol.js";
  var newUniqueString = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./new-unique-string.js", "traceur-runtime@0.0.102/src/runtime/private-symbol.js")).default;
  var $Symbol = typeof Symbol === 'function' ? Symbol : undefined;
  var $getOwnPropertySymbols = Object.getOwnPropertySymbols;
  var $create = Object.create;
  var privateNames = $create(null);
  function isPrivateSymbol(s) {
    return privateNames[s];
  }
  ;
  function createPrivateSymbol() {
    var s = ($Symbol || newUniqueString)();
    privateNames[s] = true;
    return s;
  }
  ;
  function hasPrivate(obj, sym) {
    return hasOwnProperty.call(obj, sym);
  }
  ;
  function deletePrivate(obj, sym) {
    if (!hasPrivate(obj, sym)) {
      return false;
    }
    delete obj[sym];
    return true;
  }
  ;
  function setPrivate(obj, sym, val) {
    obj[sym] = val;
  }
  ;
  function getPrivate(obj, sym) {
    var val = obj[sym];
    if (val === undefined)
      return undefined;
    return hasOwnProperty.call(obj, sym) ? val : undefined;
  }
  ;
  function init() {
    if ($getOwnPropertySymbols) {
      Object.getOwnPropertySymbols = function getOwnPropertySymbols(object) {
        var rv = [];
        var symbols = $getOwnPropertySymbols(object);
        for (var i = 0; i < symbols.length; i++) {
          var symbol = symbols[i];
          if (!isPrivateSymbol(symbol)) {
            rv.push(symbol);
          }
        }
        return rv;
      };
    }
  }
  return {
    get isPrivateSymbol() {
      return isPrivateSymbol;
    },
    get createPrivateSymbol() {
      return createPrivateSymbol;
    },
    get hasPrivate() {
      return hasPrivate;
    },
    get deletePrivate() {
      return deletePrivate;
    },
    get setPrivate() {
      return setPrivate;
    },
    get getPrivate() {
      return getPrivate;
    },
    get init() {
      return init;
    }
  };
});
$traceurRuntime.registerModule("traceur-runtime@0.0.102/src/runtime/private-weak-map.js", [], function() {
  "use strict";
  var __moduleName = "traceur-runtime@0.0.102/src/runtime/private-weak-map.js";
  var $WeakMap = typeof WeakMap === 'function' ? WeakMap : undefined;
  function isPrivateSymbol(s) {
    return false;
  }
  function createPrivateSymbol() {
    return new $WeakMap();
  }
  function hasPrivate(obj, sym) {
    return sym.has(obj);
  }
  function deletePrivate(obj, sym) {
    return sym.delete(obj);
  }
  function setPrivate(obj, sym, val) {
    sym.set(obj, val);
  }
  function getPrivate(obj, sym) {
    return sym.get(obj);
  }
  function init() {}
  return {
    get isPrivateSymbol() {
      return isPrivateSymbol;
    },
    get createPrivateSymbol() {
      return createPrivateSymbol;
    },
    get hasPrivate() {
      return hasPrivate;
    },
    get deletePrivate() {
      return deletePrivate;
    },
    get setPrivate() {
      return setPrivate;
    },
    get getPrivate() {
      return getPrivate;
    },
    get init() {
      return init;
    }
  };
});
$traceurRuntime.registerModule("traceur-runtime@0.0.102/src/runtime/private.js", [], function() {
  "use strict";
  var __moduleName = "traceur-runtime@0.0.102/src/runtime/private.js";
  var sym = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./private-symbol.js", "traceur-runtime@0.0.102/src/runtime/private.js"));
  var weak = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./private-weak-map.js", "traceur-runtime@0.0.102/src/runtime/private.js"));
  var hasWeakMap = typeof WeakMap === 'function';
  var m = hasWeakMap ? weak : sym;
  var isPrivateSymbol = m.isPrivateSymbol;
  var createPrivateSymbol = m.createPrivateSymbol;
  var hasPrivate = m.hasPrivate;
  var deletePrivate = m.deletePrivate;
  var setPrivate = m.setPrivate;
  var getPrivate = m.getPrivate;
  m.init();
  return {
    get isPrivateSymbol() {
      return isPrivateSymbol;
    },
    get createPrivateSymbol() {
      return createPrivateSymbol;
    },
    get hasPrivate() {
      return hasPrivate;
    },
    get deletePrivate() {
      return deletePrivate;
    },
    get setPrivate() {
      return setPrivate;
    },
    get getPrivate() {
      return getPrivate;
    }
  };
});
$traceurRuntime.registerModule("traceur-runtime@0.0.102/src/runtime/properTailCalls.js", [], function() {
  "use strict";
  var __moduleName = "traceur-runtime@0.0.102/src/runtime/properTailCalls.js";
  var $__0 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./private.js", "traceur-runtime@0.0.102/src/runtime/properTailCalls.js")),
      getPrivate = $__0.getPrivate,
      setPrivate = $__0.setPrivate,
      createPrivateSymbol = $__0.createPrivateSymbol;
  var $apply = Function.prototype.call.bind(Function.prototype.apply);
  var CONTINUATION_TYPE = Object.create(null);
  var isTailRecursiveName = null;
  function createContinuation(operand, thisArg, argsArray) {
    return [CONTINUATION_TYPE, operand, thisArg, argsArray];
  }
  function isContinuation(object) {
    return object && object[0] === CONTINUATION_TYPE;
  }
  function $bind(operand, thisArg, args) {
    var argArray = [thisArg];
    for (var i = 0; i < args.length; i++) {
      argArray[i + 1] = args[i];
    }
    var func = $apply(Function.prototype.bind, operand, argArray);
    return func;
  }
  function $construct(func, argArray) {
    var object = new ($bind(func, null, argArray));
    return object;
  }
  function isTailRecursive(func) {
    return !!getPrivate(func, isTailRecursiveName);
  }
  function tailCall(func, thisArg, argArray) {
    var continuation = argArray[0];
    if (isContinuation(continuation)) {
      continuation = $apply(func, thisArg, continuation[3]);
      return continuation;
    }
    continuation = createContinuation(func, thisArg, argArray);
    while (true) {
      if (isTailRecursive(func)) {
        continuation = $apply(func, continuation[2], [continuation]);
      } else {
        continuation = $apply(func, continuation[2], continuation[3]);
      }
      if (!isContinuation(continuation)) {
        return continuation;
      }
      func = continuation[1];
    }
  }
  function construct() {
    var object;
    if (isTailRecursive(this)) {
      object = $construct(this, [createContinuation(null, null, arguments)]);
    } else {
      object = $construct(this, arguments);
    }
    return object;
  }
  function setupProperTailCalls() {
    isTailRecursiveName = createPrivateSymbol();
    Function.prototype.call = initTailRecursiveFunction(function call(thisArg) {
      var result = tailCall(function(thisArg) {
        var argArray = [];
        for (var i = 1; i < arguments.length; ++i) {
          argArray[i - 1] = arguments[i];
        }
        var continuation = createContinuation(this, thisArg, argArray);
        return continuation;
      }, this, arguments);
      return result;
    });
    Function.prototype.apply = initTailRecursiveFunction(function apply(thisArg, argArray) {
      var result = tailCall(function(thisArg, argArray) {
        var continuation = createContinuation(this, thisArg, argArray);
        return continuation;
      }, this, arguments);
      return result;
    });
  }
  function initTailRecursiveFunction(func) {
    if (isTailRecursiveName === null) {
      setupProperTailCalls();
    }
    setPrivate(func, isTailRecursiveName, true);
    return func;
  }
  $traceurRuntime.initTailRecursiveFunction = initTailRecursiveFunction;
  $traceurRuntime.call = tailCall;
  $traceurRuntime.continuation = createContinuation;
  $traceurRuntime.construct = construct;
  return {};
});
$traceurRuntime.registerModule("traceur-runtime@0.0.102/src/runtime/relativeRequire.js", [], function() {
  "use strict";
  var __moduleName = "traceur-runtime@0.0.102/src/runtime/relativeRequire.js";
  var path;
  function relativeRequire(callerPath, requiredPath) {
    path = path || typeof require !== 'undefined' && require('path');
    function isDirectory(path) {
      return path.slice(-1) === '/';
    }
    function isAbsolute(path) {
      return path[0] === '/';
    }
    function isRelative(path) {
      return path[0] === '.';
    }
    if (isDirectory(requiredPath) || isAbsolute(requiredPath))
      return;
    return isRelative(requiredPath) ? require(path.resolve(path.dirname(callerPath), requiredPath)) : require(requiredPath);
  }
  $traceurRuntime.require = relativeRequire;
  return {};
});
$traceurRuntime.registerModule("traceur-runtime@0.0.102/src/runtime/checkObjectCoercible.js", [], function() {
  "use strict";
  var __moduleName = "traceur-runtime@0.0.102/src/runtime/checkObjectCoercible.js";
  var $TypeError = TypeError;
  function checkObjectCoercible(v) {
    if (v === null || v === undefined) {
      throw new $TypeError('Value cannot be converted to an Object');
    }
    return v;
  }
  var $__default = checkObjectCoercible;
  return {get default() {
      return $__default;
    }};
});
$traceurRuntime.registerModule("traceur-runtime@0.0.102/src/runtime/spread.js", [], function() {
  "use strict";
  var __moduleName = "traceur-runtime@0.0.102/src/runtime/spread.js";
  var checkObjectCoercible = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./checkObjectCoercible.js", "traceur-runtime@0.0.102/src/runtime/spread.js")).default;
  function spread() {
    var rv = [],
        j = 0,
        iterResult;
    for (var i = 0; i < arguments.length; i++) {
      var valueToSpread = checkObjectCoercible(arguments[i]);
      if (typeof valueToSpread[Symbol.iterator] !== 'function') {
        throw new TypeError('Cannot spread non-iterable object.');
      }
      var iter = valueToSpread[Symbol.iterator]();
      while (!(iterResult = iter.next()).done) {
        rv[j++] = iterResult.value;
      }
    }
    return rv;
  }
  $traceurRuntime.spread = spread;
  return {};
});
$traceurRuntime.registerModule("traceur-runtime@0.0.102/src/runtime/destructuring.js", [], function() {
  "use strict";
  var __moduleName = "traceur-runtime@0.0.102/src/runtime/destructuring.js";
  function iteratorToArray(iter) {
    var rv = [];
    var i = 0;
    var tmp;
    while (!(tmp = iter.next()).done) {
      rv[i++] = tmp.value;
    }
    return rv;
  }
  $traceurRuntime.iteratorToArray = iteratorToArray;
  return {};
});
$traceurRuntime.registerModule("traceur-runtime@0.0.102/src/runtime/async.js", [], function() {
  "use strict";
  var __moduleName = "traceur-runtime@0.0.102/src/runtime/async.js";
  var $__0 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./private.js", "traceur-runtime@0.0.102/src/runtime/async.js")),
      createPrivateSymbol = $__0.createPrivateSymbol,
      getPrivate = $__0.getPrivate,
      setPrivate = $__0.setPrivate;
  var $__12 = Object,
      create = $__12.create,
      defineProperty = $__12.defineProperty;
  var observeName = createPrivateSymbol();
  function AsyncGeneratorFunction() {}
  function AsyncGeneratorFunctionPrototype() {}
  AsyncGeneratorFunction.prototype = AsyncGeneratorFunctionPrototype;
  AsyncGeneratorFunctionPrototype.constructor = AsyncGeneratorFunction;
  defineProperty(AsyncGeneratorFunctionPrototype, 'constructor', {enumerable: false});
  var AsyncGeneratorContext = function() {
    function AsyncGeneratorContext(observer) {
      var $__3 = this;
      this.decoratedObserver = $traceurRuntime.createDecoratedGenerator(observer, function() {
        $__3.done = true;
      });
      this.done = false;
      this.inReturn = false;
    }
    return ($traceurRuntime.createClass)(AsyncGeneratorContext, {
      throw: function(error) {
        if (!this.inReturn) {
          throw error;
        }
      },
      yield: function(value) {
        if (this.done) {
          this.inReturn = true;
          throw undefined;
        }
        var result;
        try {
          result = this.decoratedObserver.next(value);
        } catch (e) {
          this.done = true;
          throw e;
        }
        if (result === undefined) {
          return;
        }
        if (result.done) {
          this.done = true;
          this.inReturn = true;
          throw undefined;
        }
        return result.value;
      },
      yieldFor: function(observable) {
        var ctx = this;
        return $traceurRuntime.observeForEach(observable[Symbol.observer].bind(observable), function(value) {
          if (ctx.done) {
            this.return();
            return;
          }
          var result;
          try {
            result = ctx.decoratedObserver.next(value);
          } catch (e) {
            ctx.done = true;
            throw e;
          }
          if (result === undefined) {
            return;
          }
          if (result.done) {
            ctx.done = true;
          }
          return result;
        });
      }
    }, {});
  }();
  AsyncGeneratorFunctionPrototype.prototype[Symbol.observer] = function(observer) {
    var observe = getPrivate(this, observeName);
    var ctx = new AsyncGeneratorContext(observer);
    $traceurRuntime.schedule(function() {
      return observe(ctx);
    }).then(function(value) {
      if (!ctx.done) {
        ctx.decoratedObserver.return(value);
      }
    }).catch(function(error) {
      if (!ctx.done) {
        ctx.decoratedObserver.throw(error);
      }
    });
    return ctx.decoratedObserver;
  };
  defineProperty(AsyncGeneratorFunctionPrototype.prototype, Symbol.observer, {enumerable: false});
  function initAsyncGeneratorFunction(functionObject) {
    functionObject.prototype = create(AsyncGeneratorFunctionPrototype.prototype);
    functionObject.__proto__ = AsyncGeneratorFunctionPrototype;
    return functionObject;
  }
  function createAsyncGeneratorInstance(observe, functionObject) {
    for (var args = [],
        $__11 = 2; $__11 < arguments.length; $__11++)
      args[$__11 - 2] = arguments[$__11];
    var object = create(functionObject.prototype);
    setPrivate(object, observeName, observe);
    return object;
  }
  function observeForEach(observe, next) {
    return new Promise(function(resolve, reject) {
      var generator = observe({
        next: function(value) {
          return next.call(generator, value);
        },
        throw: function(error) {
          reject(error);
        },
        return: function(value) {
          resolve(value);
        }
      });
    });
  }
  function schedule(asyncF) {
    return Promise.resolve().then(asyncF);
  }
  var generator = Symbol();
  var onDone = Symbol();
  var DecoratedGenerator = function() {
    function DecoratedGenerator(_generator, _onDone) {
      this[generator] = _generator;
      this[onDone] = _onDone;
    }
    return ($traceurRuntime.createClass)(DecoratedGenerator, {
      next: function(value) {
        var result = this[generator].next(value);
        if (result !== undefined && result.done) {
          this[onDone].call(this);
        }
        return result;
      },
      throw: function(error) {
        this[onDone].call(this);
        return this[generator].throw(error);
      },
      return: function(value) {
        this[onDone].call(this);
        return this[generator].return(value);
      }
    }, {});
  }();
  function createDecoratedGenerator(generator, onDone) {
    return new DecoratedGenerator(generator, onDone);
  }
  Array.prototype[Symbol.observer] = function(observer) {
    var done = false;
    var decoratedObserver = createDecoratedGenerator(observer, function() {
      return done = true;
    });
    var $__7 = true;
    var $__8 = false;
    var $__9 = undefined;
    try {
      for (var $__5 = void 0,
          $__4 = (this)[Symbol.iterator](); !($__7 = ($__5 = $__4.next()).done); $__7 = true) {
        var value = $__5.value;
        {
          decoratedObserver.next(value);
          if (done) {
            return;
          }
        }
      }
    } catch ($__10) {
      $__8 = true;
      $__9 = $__10;
    } finally {
      try {
        if (!$__7 && $__4.return != null) {
          $__4.return();
        }
      } finally {
        if ($__8) {
          throw $__9;
        }
      }
    }
    decoratedObserver.return();
    return decoratedObserver;
  };
  defineProperty(Array.prototype, Symbol.observer, {enumerable: false});
  $traceurRuntime.initAsyncGeneratorFunction = initAsyncGeneratorFunction;
  $traceurRuntime.createAsyncGeneratorInstance = createAsyncGeneratorInstance;
  $traceurRuntime.observeForEach = observeForEach;
  $traceurRuntime.schedule = schedule;
  $traceurRuntime.createDecoratedGenerator = createDecoratedGenerator;
  return {};
});
$traceurRuntime.registerModule("traceur-runtime@0.0.102/src/runtime/generators.js", [], function() {
  "use strict";
  var __moduleName = "traceur-runtime@0.0.102/src/runtime/generators.js";
  var $__0 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./private.js", "traceur-runtime@0.0.102/src/runtime/generators.js")),
      createPrivateSymbol = $__0.createPrivateSymbol,
      getPrivate = $__0.getPrivate,
      setPrivate = $__0.setPrivate;
  var $TypeError = TypeError;
  var $__2 = Object,
      create = $__2.create,
      defineProperties = $__2.defineProperties,
      defineProperty = $__2.defineProperty;
  function nonEnum(value) {
    return {
      configurable: true,
      enumerable: false,
      value: value,
      writable: true
    };
  }
  var ST_NEWBORN = 0;
  var ST_EXECUTING = 1;
  var ST_SUSPENDED = 2;
  var ST_CLOSED = 3;
  var END_STATE = -2;
  var RETHROW_STATE = -3;
  function getInternalError(state) {
    return new Error('Traceur compiler bug: invalid state in state machine: ' + state);
  }
  var RETURN_SENTINEL = {};
  function GeneratorContext() {
    this.state = 0;
    this.GState = ST_NEWBORN;
    this.storedException = undefined;
    this.finallyFallThrough = undefined;
    this.sent_ = undefined;
    this.returnValue = undefined;
    this.oldReturnValue = undefined;
    this.tryStack_ = [];
  }
  GeneratorContext.prototype = {
    pushTry: function(catchState, finallyState) {
      if (finallyState !== null) {
        var finallyFallThrough = null;
        for (var i = this.tryStack_.length - 1; i >= 0; i--) {
          if (this.tryStack_[i].catch !== undefined) {
            finallyFallThrough = this.tryStack_[i].catch;
            break;
          }
        }
        if (finallyFallThrough === null)
          finallyFallThrough = RETHROW_STATE;
        this.tryStack_.push({
          finally: finallyState,
          finallyFallThrough: finallyFallThrough
        });
      }
      if (catchState !== null) {
        this.tryStack_.push({catch: catchState});
      }
    },
    popTry: function() {
      this.tryStack_.pop();
    },
    maybeUncatchable: function() {
      if (this.storedException === RETURN_SENTINEL) {
        throw RETURN_SENTINEL;
      }
    },
    get sent() {
      this.maybeThrow();
      return this.sent_;
    },
    set sent(v) {
      this.sent_ = v;
    },
    get sentIgnoreThrow() {
      return this.sent_;
    },
    maybeThrow: function() {
      if (this.action === 'throw') {
        this.action = 'next';
        throw this.sent_;
      }
    },
    end: function() {
      switch (this.state) {
        case END_STATE:
          return this;
        case RETHROW_STATE:
          throw this.storedException;
        default:
          throw getInternalError(this.state);
      }
    },
    handleException: function(ex) {
      this.GState = ST_CLOSED;
      this.state = END_STATE;
      throw ex;
    },
    wrapYieldStar: function(iterator) {
      var ctx = this;
      return {
        next: function(v) {
          return iterator.next(v);
        },
        throw: function(e) {
          var result;
          if (e === RETURN_SENTINEL) {
            if (iterator.return) {
              result = iterator.return(ctx.returnValue);
              if (!result.done) {
                ctx.returnValue = ctx.oldReturnValue;
                return result;
              }
              ctx.returnValue = result.value;
            }
            throw e;
          }
          if (iterator.throw) {
            return iterator.throw(e);
          }
          iterator.return && iterator.return();
          throw $TypeError('Inner iterator does not have a throw method');
        }
      };
    }
  };
  function nextOrThrow(ctx, moveNext, action, x) {
    switch (ctx.GState) {
      case ST_EXECUTING:
        throw new Error(("\"" + action + "\" on executing generator"));
      case ST_CLOSED:
        if (action == 'next') {
          return {
            value: undefined,
            done: true
          };
        }
        if (x === RETURN_SENTINEL) {
          return {
            value: ctx.returnValue,
            done: true
          };
        }
        throw x;
      case ST_NEWBORN:
        if (action === 'throw') {
          ctx.GState = ST_CLOSED;
          if (x === RETURN_SENTINEL) {
            return {
              value: ctx.returnValue,
              done: true
            };
          }
          throw x;
        }
        if (x !== undefined)
          throw $TypeError('Sent value to newborn generator');
      case ST_SUSPENDED:
        ctx.GState = ST_EXECUTING;
        ctx.action = action;
        ctx.sent = x;
        var value;
        try {
          value = moveNext(ctx);
        } catch (ex) {
          if (ex === RETURN_SENTINEL) {
            value = ctx;
          } else {
            throw ex;
          }
        }
        var done = value === ctx;
        if (done)
          value = ctx.returnValue;
        ctx.GState = done ? ST_CLOSED : ST_SUSPENDED;
        return {
          value: value,
          done: done
        };
    }
  }
  var ctxName = createPrivateSymbol();
  var moveNextName = createPrivateSymbol();
  function GeneratorFunction() {}
  function GeneratorFunctionPrototype() {}
  GeneratorFunction.prototype = GeneratorFunctionPrototype;
  defineProperty(GeneratorFunctionPrototype, 'constructor', nonEnum(GeneratorFunction));
  GeneratorFunctionPrototype.prototype = {
    constructor: GeneratorFunctionPrototype,
    next: function(v) {
      return nextOrThrow(getPrivate(this, ctxName), getPrivate(this, moveNextName), 'next', v);
    },
    throw: function(v) {
      return nextOrThrow(getPrivate(this, ctxName), getPrivate(this, moveNextName), 'throw', v);
    },
    return: function(v) {
      var ctx = getPrivate(this, ctxName);
      ctx.oldReturnValue = ctx.returnValue;
      ctx.returnValue = v;
      return nextOrThrow(ctx, getPrivate(this, moveNextName), 'throw', RETURN_SENTINEL);
    }
  };
  defineProperties(GeneratorFunctionPrototype.prototype, {
    constructor: {enumerable: false},
    next: {enumerable: false},
    throw: {enumerable: false},
    return: {enumerable: false}
  });
  Object.defineProperty(GeneratorFunctionPrototype.prototype, Symbol.iterator, nonEnum(function() {
    return this;
  }));
  function createGeneratorInstance(innerFunction, functionObject, self) {
    var moveNext = getMoveNext(innerFunction, self);
    var ctx = new GeneratorContext();
    var object = create(functionObject.prototype);
    setPrivate(object, ctxName, ctx);
    setPrivate(object, moveNextName, moveNext);
    return object;
  }
  function initGeneratorFunction(functionObject) {
    functionObject.prototype = create(GeneratorFunctionPrototype.prototype);
    functionObject.__proto__ = GeneratorFunctionPrototype;
    return functionObject;
  }
  function AsyncFunctionContext() {
    GeneratorContext.call(this);
    this.err = undefined;
    var ctx = this;
    ctx.result = new Promise(function(resolve, reject) {
      ctx.resolve = resolve;
      ctx.reject = reject;
    });
  }
  AsyncFunctionContext.prototype = create(GeneratorContext.prototype);
  AsyncFunctionContext.prototype.end = function() {
    switch (this.state) {
      case END_STATE:
        this.resolve(this.returnValue);
        break;
      case RETHROW_STATE:
        this.reject(this.storedException);
        break;
      default:
        this.reject(getInternalError(this.state));
    }
  };
  AsyncFunctionContext.prototype.handleException = function() {
    this.state = RETHROW_STATE;
  };
  function asyncWrap(innerFunction, self) {
    var moveNext = getMoveNext(innerFunction, self);
    var ctx = new AsyncFunctionContext();
    ctx.createCallback = function(newState) {
      return function(value) {
        ctx.state = newState;
        ctx.value = value;
        moveNext(ctx);
      };
    };
    ctx.errback = function(err) {
      handleCatch(ctx, err);
      moveNext(ctx);
    };
    moveNext(ctx);
    return ctx.result;
  }
  function getMoveNext(innerFunction, self) {
    return function(ctx) {
      while (true) {
        try {
          return innerFunction.call(self, ctx);
        } catch (ex) {
          handleCatch(ctx, ex);
        }
      }
    };
  }
  function handleCatch(ctx, ex) {
    ctx.storedException = ex;
    var last = ctx.tryStack_[ctx.tryStack_.length - 1];
    if (!last) {
      ctx.handleException(ex);
      return;
    }
    ctx.state = last.catch !== undefined ? last.catch : last.finally;
    if (last.finallyFallThrough !== undefined)
      ctx.finallyFallThrough = last.finallyFallThrough;
  }
  $traceurRuntime.asyncWrap = asyncWrap;
  $traceurRuntime.initGeneratorFunction = initGeneratorFunction;
  $traceurRuntime.createGeneratorInstance = createGeneratorInstance;
  return {};
});
$traceurRuntime.registerModule("traceur-runtime@0.0.102/src/runtime/template.js", [], function() {
  "use strict";
  var __moduleName = "traceur-runtime@0.0.102/src/runtime/template.js";
  var $__1 = Object,
      defineProperty = $__1.defineProperty,
      freeze = $__1.freeze;
  var slice = Array.prototype.slice;
  var map = Object.create(null);
  function getTemplateObject(raw) {
    var cooked = arguments[1];
    var key = raw.join('${}');
    var templateObject = map[key];
    if (templateObject)
      return templateObject;
    if (!cooked) {
      cooked = slice.call(raw);
    }
    return map[key] = freeze(defineProperty(cooked, 'raw', {value: freeze(raw)}));
  }
  $traceurRuntime.getTemplateObject = getTemplateObject;
  return {};
});
$traceurRuntime.registerModule("traceur-runtime@0.0.102/src/runtime/runtime-modules.js", [], function() {
  "use strict";
  var __moduleName = "traceur-runtime@0.0.102/src/runtime/runtime-modules.js";
  $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./symbols.js", "traceur-runtime@0.0.102/src/runtime/runtime-modules.js"));
  $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./classes.js", "traceur-runtime@0.0.102/src/runtime/runtime-modules.js"));
  $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./exportStar.js", "traceur-runtime@0.0.102/src/runtime/runtime-modules.js"));
  $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./properTailCalls.js", "traceur-runtime@0.0.102/src/runtime/runtime-modules.js"));
  $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./relativeRequire.js", "traceur-runtime@0.0.102/src/runtime/runtime-modules.js"));
  $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./spread.js", "traceur-runtime@0.0.102/src/runtime/runtime-modules.js"));
  $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./destructuring.js", "traceur-runtime@0.0.102/src/runtime/runtime-modules.js"));
  $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./async.js", "traceur-runtime@0.0.102/src/runtime/runtime-modules.js"));
  $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./generators.js", "traceur-runtime@0.0.102/src/runtime/runtime-modules.js"));
  $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./template.js", "traceur-runtime@0.0.102/src/runtime/runtime-modules.js"));
  return {};
});
$traceurRuntime.getModule("traceur-runtime@0.0.102/src/runtime/runtime-modules.js" + '');
$traceurRuntime.registerModule("traceur-runtime@0.0.102/src/runtime/frozen-data.js", [], function() {
  "use strict";
  var __moduleName = "traceur-runtime@0.0.102/src/runtime/frozen-data.js";
  function findIndex(arr, key) {
    for (var i = 0; i < arr.length; i += 2) {
      if (arr[i] === key) {
        return i;
      }
    }
    return -1;
  }
  function setFrozen(arr, key, val) {
    var i = findIndex(arr, key);
    if (i === -1) {
      arr.push(key, val);
    }
  }
  function getFrozen(arr, key) {
    var i = findIndex(arr, key);
    if (i !== -1) {
      return arr[i + 1];
    }
    return undefined;
  }
  function hasFrozen(arr, key) {
    return findIndex(arr, key) !== -1;
  }
  function deleteFrozen(arr, key) {
    var i = findIndex(arr, key);
    if (i !== -1) {
      arr.splice(i, 2);
      return true;
    }
    return false;
  }
  return {
    get setFrozen() {
      return setFrozen;
    },
    get getFrozen() {
      return getFrozen;
    },
    get hasFrozen() {
      return hasFrozen;
    },
    get deleteFrozen() {
      return deleteFrozen;
    }
  };
});
$traceurRuntime.registerModule("traceur-runtime@0.0.102/src/runtime/polyfills/utils.js", [], function() {
  "use strict";
  var __moduleName = "traceur-runtime@0.0.102/src/runtime/polyfills/utils.js";
  var $ceil = Math.ceil;
  var $floor = Math.floor;
  var $isFinite = isFinite;
  var $isNaN = isNaN;
  var $pow = Math.pow;
  var $min = Math.min;
  var $TypeError = TypeError;
  var $Object = Object;
  function toObject(x) {
    if (x == null) {
      throw $TypeError();
    }
    return $Object(x);
  }
  function toUint32(x) {
    return x >>> 0;
  }
  function isObject(x) {
    return x && (typeof x === 'object' || typeof x === 'function');
  }
  function isCallable(x) {
    return typeof x === 'function';
  }
  function isNumber(x) {
    return typeof x === 'number';
  }
  function toInteger(x) {
    x = +x;
    if ($isNaN(x))
      return 0;
    if (x === 0 || !$isFinite(x))
      return x;
    return x > 0 ? $floor(x) : $ceil(x);
  }
  var MAX_SAFE_LENGTH = $pow(2, 53) - 1;
  function toLength(x) {
    var len = toInteger(x);
    return len < 0 ? 0 : $min(len, MAX_SAFE_LENGTH);
  }
  function checkIterable(x) {
    return !isObject(x) ? undefined : x[Symbol.iterator];
  }
  function isConstructor(x) {
    return isCallable(x);
  }
  function createIteratorResultObject(value, done) {
    return {
      value: value,
      done: done
    };
  }
  function maybeDefine(object, name, descr) {
    if (!(name in object)) {
      Object.defineProperty(object, name, descr);
    }
  }
  function maybeDefineMethod(object, name, value) {
    maybeDefine(object, name, {
      value: value,
      configurable: true,
      enumerable: false,
      writable: true
    });
  }
  function maybeDefineConst(object, name, value) {
    maybeDefine(object, name, {
      value: value,
      configurable: false,
      enumerable: false,
      writable: false
    });
  }
  function maybeAddFunctions(object, functions) {
    for (var i = 0; i < functions.length; i += 2) {
      var name = functions[i];
      var value = functions[i + 1];
      maybeDefineMethod(object, name, value);
    }
  }
  function maybeAddConsts(object, consts) {
    for (var i = 0; i < consts.length; i += 2) {
      var name = consts[i];
      var value = consts[i + 1];
      maybeDefineConst(object, name, value);
    }
  }
  function maybeAddIterator(object, func, Symbol) {
    if (!Symbol || !Symbol.iterator || object[Symbol.iterator])
      return;
    if (object['@@iterator'])
      func = object['@@iterator'];
    Object.defineProperty(object, Symbol.iterator, {
      value: func,
      configurable: true,
      enumerable: false,
      writable: true
    });
  }
  var polyfills = [];
  function registerPolyfill(func) {
    polyfills.push(func);
  }
  function polyfillAll(global) {
    polyfills.forEach(function(f) {
      return f(global);
    });
  }
  return {
    get toObject() {
      return toObject;
    },
    get toUint32() {
      return toUint32;
    },
    get isObject() {
      return isObject;
    },
    get isCallable() {
      return isCallable;
    },
    get isNumber() {
      return isNumber;
    },
    get toInteger() {
      return toInteger;
    },
    get toLength() {
      return toLength;
    },
    get checkIterable() {
      return checkIterable;
    },
    get isConstructor() {
      return isConstructor;
    },
    get createIteratorResultObject() {
      return createIteratorResultObject;
    },
    get maybeDefine() {
      return maybeDefine;
    },
    get maybeDefineMethod() {
      return maybeDefineMethod;
    },
    get maybeDefineConst() {
      return maybeDefineConst;
    },
    get maybeAddFunctions() {
      return maybeAddFunctions;
    },
    get maybeAddConsts() {
      return maybeAddConsts;
    },
    get maybeAddIterator() {
      return maybeAddIterator;
    },
    get registerPolyfill() {
      return registerPolyfill;
    },
    get polyfillAll() {
      return polyfillAll;
    }
  };
});
$traceurRuntime.registerModule("traceur-runtime@0.0.102/src/runtime/polyfills/Map.js", [], function() {
  "use strict";
  var __moduleName = "traceur-runtime@0.0.102/src/runtime/polyfills/Map.js";
  var $__0 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../private.js", "traceur-runtime@0.0.102/src/runtime/polyfills/Map.js")),
      createPrivateSymbol = $__0.createPrivateSymbol,
      getPrivate = $__0.getPrivate,
      setPrivate = $__0.setPrivate;
  var $__1 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../frozen-data.js", "traceur-runtime@0.0.102/src/runtime/polyfills/Map.js")),
      deleteFrozen = $__1.deleteFrozen,
      getFrozen = $__1.getFrozen,
      setFrozen = $__1.setFrozen;
  var $__2 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./utils.js", "traceur-runtime@0.0.102/src/runtime/polyfills/Map.js")),
      isObject = $__2.isObject,
      registerPolyfill = $__2.registerPolyfill;
  var hasNativeSymbol = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../has-native-symbols.js", "traceur-runtime@0.0.102/src/runtime/polyfills/Map.js")).default;
  var $__13 = Object,
      defineProperty = $__13.defineProperty,
      getOwnPropertyDescriptor = $__13.getOwnPropertyDescriptor,
      hasOwnProperty = $__13.hasOwnProperty,
      isExtensible = $__13.isExtensible;
  var deletedSentinel = {};
  var counter = 1;
  var hashCodeName = createPrivateSymbol();
  function getHashCodeForObject(obj) {
    return getPrivate(obj, hashCodeName);
  }
  function getOrSetHashCodeForObject(obj) {
    var hash = getHashCodeForObject(obj);
    if (!hash) {
      hash = counter++;
      setPrivate(obj, hashCodeName, hash);
    }
    return hash;
  }
  function lookupIndex(map, key) {
    if (typeof key === 'string') {
      return map.stringIndex_[key];
    }
    if (isObject(key)) {
      if (!isExtensible(key)) {
        return getFrozen(map.frozenData_, key);
      }
      var hc = getHashCodeForObject(key);
      if (hc === undefined) {
        return undefined;
      }
      return map.objectIndex_[hc];
    }
    return map.primitiveIndex_[key];
  }
  function initMap(map) {
    map.entries_ = [];
    map.objectIndex_ = Object.create(null);
    map.stringIndex_ = Object.create(null);
    map.primitiveIndex_ = Object.create(null);
    map.frozenData_ = [];
    map.deletedCount_ = 0;
  }
  var Map = function() {
    function Map() {
      var $__15,
          $__16;
      var iterable = arguments[0];
      if (!isObject(this))
        throw new TypeError('Map called on incompatible type');
      if (hasOwnProperty.call(this, 'entries_')) {
        throw new TypeError('Map can not be reentrantly initialised');
      }
      initMap(this);
      if (iterable !== null && iterable !== undefined) {
        var $__9 = true;
        var $__10 = false;
        var $__11 = undefined;
        try {
          for (var $__7 = void 0,
              $__6 = (iterable)[Symbol.iterator](); !($__9 = ($__7 = $__6.next()).done); $__9 = true) {
            var $__14 = $__7.value,
                key = ($__15 = $__14[Symbol.iterator](), ($__16 = $__15.next()).done ? void 0 : $__16.value),
                value = ($__16 = $__15.next()).done ? void 0 : $__16.value;
            {
              this.set(key, value);
            }
          }
        } catch ($__12) {
          $__10 = true;
          $__11 = $__12;
        } finally {
          try {
            if (!$__9 && $__6.return != null) {
              $__6.return();
            }
          } finally {
            if ($__10) {
              throw $__11;
            }
          }
        }
      }
    }
    return ($traceurRuntime.createClass)(Map, {
      get size() {
        return this.entries_.length / 2 - this.deletedCount_;
      },
      get: function(key) {
        var index = lookupIndex(this, key);
        if (index !== undefined) {
          return this.entries_[index + 1];
        }
      },
      set: function(key, value) {
        var index = lookupIndex(this, key);
        if (index !== undefined) {
          this.entries_[index + 1] = value;
        } else {
          index = this.entries_.length;
          this.entries_[index] = key;
          this.entries_[index + 1] = value;
          if (isObject(key)) {
            if (!isExtensible(key)) {
              setFrozen(this.frozenData_, key, index);
            } else {
              var hash = getOrSetHashCodeForObject(key);
              this.objectIndex_[hash] = index;
            }
          } else if (typeof key === 'string') {
            this.stringIndex_[key] = index;
          } else {
            this.primitiveIndex_[key] = index;
          }
        }
        return this;
      },
      has: function(key) {
        return lookupIndex(this, key) !== undefined;
      },
      delete: function(key) {
        var index = lookupIndex(this, key);
        if (index === undefined) {
          return false;
        }
        this.entries_[index] = deletedSentinel;
        this.entries_[index + 1] = undefined;
        this.deletedCount_++;
        if (isObject(key)) {
          if (!isExtensible(key)) {
            deleteFrozen(this.frozenData_, key);
          } else {
            var hash = getHashCodeForObject(key);
            delete this.objectIndex_[hash];
          }
        } else if (typeof key === 'string') {
          delete this.stringIndex_[key];
        } else {
          delete this.primitiveIndex_[key];
        }
        return true;
      },
      clear: function() {
        initMap(this);
      },
      forEach: function(callbackFn) {
        var thisArg = arguments[1];
        for (var i = 0; i < this.entries_.length; i += 2) {
          var key = this.entries_[i];
          var value = this.entries_[i + 1];
          if (key === deletedSentinel)
            continue;
          callbackFn.call(thisArg, value, key, this);
        }
      },
      entries: $traceurRuntime.initGeneratorFunction(function $__17() {
        var i,
            key,
            value;
        return $traceurRuntime.createGeneratorInstance(function($ctx) {
          while (true)
            switch ($ctx.state) {
              case 0:
                i = 0;
                $ctx.state = 12;
                break;
              case 12:
                $ctx.state = (i < this.entries_.length) ? 8 : -2;
                break;
              case 4:
                i += 2;
                $ctx.state = 12;
                break;
              case 8:
                key = this.entries_[i];
                value = this.entries_[i + 1];
                $ctx.state = 9;
                break;
              case 9:
                $ctx.state = (key === deletedSentinel) ? 4 : 6;
                break;
              case 6:
                $ctx.state = 2;
                return [key, value];
              case 2:
                $ctx.maybeThrow();
                $ctx.state = 4;
                break;
              default:
                return $ctx.end();
            }
        }, $__17, this);
      }),
      keys: $traceurRuntime.initGeneratorFunction(function $__18() {
        var i,
            key,
            value;
        return $traceurRuntime.createGeneratorInstance(function($ctx) {
          while (true)
            switch ($ctx.state) {
              case 0:
                i = 0;
                $ctx.state = 12;
                break;
              case 12:
                $ctx.state = (i < this.entries_.length) ? 8 : -2;
                break;
              case 4:
                i += 2;
                $ctx.state = 12;
                break;
              case 8:
                key = this.entries_[i];
                value = this.entries_[i + 1];
                $ctx.state = 9;
                break;
              case 9:
                $ctx.state = (key === deletedSentinel) ? 4 : 6;
                break;
              case 6:
                $ctx.state = 2;
                return key;
              case 2:
                $ctx.maybeThrow();
                $ctx.state = 4;
                break;
              default:
                return $ctx.end();
            }
        }, $__18, this);
      }),
      values: $traceurRuntime.initGeneratorFunction(function $__19() {
        var i,
            key,
            value;
        return $traceurRuntime.createGeneratorInstance(function($ctx) {
          while (true)
            switch ($ctx.state) {
              case 0:
                i = 0;
                $ctx.state = 12;
                break;
              case 12:
                $ctx.state = (i < this.entries_.length) ? 8 : -2;
                break;
              case 4:
                i += 2;
                $ctx.state = 12;
                break;
              case 8:
                key = this.entries_[i];
                value = this.entries_[i + 1];
                $ctx.state = 9;
                break;
              case 9:
                $ctx.state = (key === deletedSentinel) ? 4 : 6;
                break;
              case 6:
                $ctx.state = 2;
                return value;
              case 2:
                $ctx.maybeThrow();
                $ctx.state = 4;
                break;
              default:
                return $ctx.end();
            }
        }, $__19, this);
      })
    }, {});
  }();
  defineProperty(Map.prototype, Symbol.iterator, {
    configurable: true,
    writable: true,
    value: Map.prototype.entries
  });
  function needsPolyfill(global) {
    var $__14 = global,
        Map = $__14.Map,
        Symbol = $__14.Symbol;
    if (!Map || !hasNativeSymbol() || !Map.prototype[Symbol.iterator] || !Map.prototype.entries) {
      return true;
    }
    try {
      return new Map([[]]).size !== 1;
    } catch (e) {
      return false;
    }
  }
  function polyfillMap(global) {
    if (needsPolyfill(global)) {
      global.Map = Map;
    }
  }
  registerPolyfill(polyfillMap);
  return {
    get Map() {
      return Map;
    },
    get polyfillMap() {
      return polyfillMap;
    }
  };
});
$traceurRuntime.getModule("traceur-runtime@0.0.102/src/runtime/polyfills/Map.js" + '');
$traceurRuntime.registerModule("traceur-runtime@0.0.102/src/runtime/polyfills/Set.js", [], function() {
  "use strict";
  var __moduleName = "traceur-runtime@0.0.102/src/runtime/polyfills/Set.js";
  var $__0 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./utils.js", "traceur-runtime@0.0.102/src/runtime/polyfills/Set.js")),
      isObject = $__0.isObject,
      registerPolyfill = $__0.registerPolyfill;
  var Map = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./Map.js", "traceur-runtime@0.0.102/src/runtime/polyfills/Set.js")).Map;
  var hasNativeSymbol = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../has-native-symbols.js", "traceur-runtime@0.0.102/src/runtime/polyfills/Set.js")).default;
  var hasOwnProperty = Object.prototype.hasOwnProperty;
  var Set = function() {
    function Set() {
      var iterable = arguments[0];
      if (!isObject(this))
        throw new TypeError('Set called on incompatible type');
      if (hasOwnProperty.call(this, 'map_')) {
        throw new TypeError('Set can not be reentrantly initialised');
      }
      this.map_ = new Map();
      if (iterable !== null && iterable !== undefined) {
        var $__9 = true;
        var $__10 = false;
        var $__11 = undefined;
        try {
          for (var $__7 = void 0,
              $__6 = (iterable)[Symbol.iterator](); !($__9 = ($__7 = $__6.next()).done); $__9 = true) {
            var item = $__7.value;
            {
              this.add(item);
            }
          }
        } catch ($__12) {
          $__10 = true;
          $__11 = $__12;
        } finally {
          try {
            if (!$__9 && $__6.return != null) {
              $__6.return();
            }
          } finally {
            if ($__10) {
              throw $__11;
            }
          }
        }
      }
    }
    return ($traceurRuntime.createClass)(Set, {
      get size() {
        return this.map_.size;
      },
      has: function(key) {
        return this.map_.has(key);
      },
      add: function(key) {
        this.map_.set(key, key);
        return this;
      },
      delete: function(key) {
        return this.map_.delete(key);
      },
      clear: function() {
        return this.map_.clear();
      },
      forEach: function(callbackFn) {
        var thisArg = arguments[1];
        var $__5 = this;
        return this.map_.forEach(function(value, key) {
          callbackFn.call(thisArg, key, key, $__5);
        });
      },
      values: $traceurRuntime.initGeneratorFunction(function $__15() {
        var $__16,
            $__17;
        return $traceurRuntime.createGeneratorInstance(function($ctx) {
          while (true)
            switch ($ctx.state) {
              case 0:
                $__16 = $ctx.wrapYieldStar(this.map_.keys()[Symbol.iterator]());
                $ctx.sent = void 0;
                $ctx.action = 'next';
                $ctx.state = 12;
                break;
              case 12:
                $__17 = $__16[$ctx.action]($ctx.sentIgnoreThrow);
                $ctx.state = 9;
                break;
              case 9:
                $ctx.state = ($__17.done) ? 3 : 2;
                break;
              case 3:
                $ctx.sent = $__17.value;
                $ctx.state = -2;
                break;
              case 2:
                $ctx.state = 12;
                return $__17.value;
              default:
                return $ctx.end();
            }
        }, $__15, this);
      }),
      entries: $traceurRuntime.initGeneratorFunction(function $__18() {
        var $__19,
            $__20;
        return $traceurRuntime.createGeneratorInstance(function($ctx) {
          while (true)
            switch ($ctx.state) {
              case 0:
                $__19 = $ctx.wrapYieldStar(this.map_.entries()[Symbol.iterator]());
                $ctx.sent = void 0;
                $ctx.action = 'next';
                $ctx.state = 12;
                break;
              case 12:
                $__20 = $__19[$ctx.action]($ctx.sentIgnoreThrow);
                $ctx.state = 9;
                break;
              case 9:
                $ctx.state = ($__20.done) ? 3 : 2;
                break;
              case 3:
                $ctx.sent = $__20.value;
                $ctx.state = -2;
                break;
              case 2:
                $ctx.state = 12;
                return $__20.value;
              default:
                return $ctx.end();
            }
        }, $__18, this);
      })
    }, {});
  }();
  Object.defineProperty(Set.prototype, Symbol.iterator, {
    configurable: true,
    writable: true,
    value: Set.prototype.values
  });
  Object.defineProperty(Set.prototype, 'keys', {
    configurable: true,
    writable: true,
    value: Set.prototype.values
  });
  function needsPolyfill(global) {
    var $__14 = global,
        Set = $__14.Set,
        Symbol = $__14.Symbol;
    if (!Set || !hasNativeSymbol() || !Set.prototype[Symbol.iterator] || !Set.prototype.values) {
      return true;
    }
    try {
      return new Set([1]).size !== 1;
    } catch (e) {
      return false;
    }
  }
  function polyfillSet(global) {
    if (needsPolyfill(global)) {
      global.Set = Set;
    }
  }
  registerPolyfill(polyfillSet);
  return {
    get Set() {
      return Set;
    },
    get polyfillSet() {
      return polyfillSet;
    }
  };
});
$traceurRuntime.getModule("traceur-runtime@0.0.102/src/runtime/polyfills/Set.js" + '');
$traceurRuntime.registerModule("traceur-runtime@0.0.102/node_modules/rsvp/lib/rsvp/asap.js", [], function() {
  "use strict";
  var __moduleName = "traceur-runtime@0.0.102/node_modules/rsvp/lib/rsvp/asap.js";
  var len = 0;
  var toString = {}.toString;
  var vertxNext;
  function asap(callback, arg) {
    queue[len] = callback;
    queue[len + 1] = arg;
    len += 2;
    if (len === 2) {
      scheduleFlush();
    }
  }
  var $__default = asap;
  var browserWindow = (typeof window !== 'undefined') ? window : undefined;
  var browserGlobal = browserWindow || {};
  var BrowserMutationObserver = browserGlobal.MutationObserver || browserGlobal.WebKitMutationObserver;
  var isNode = typeof self === 'undefined' && typeof process !== 'undefined' && {}.toString.call(process) === '[object process]';
  var isWorker = typeof Uint8ClampedArray !== 'undefined' && typeof importScripts !== 'undefined' && typeof MessageChannel !== 'undefined';
  function useNextTick() {
    var nextTick = process.nextTick;
    var version = process.versions.node.match(/^(?:(\d+)\.)?(?:(\d+)\.)?(\*|\d+)$/);
    if (Array.isArray(version) && version[1] === '0' && version[2] === '10') {
      nextTick = setImmediate;
    }
    return function() {
      nextTick(flush);
    };
  }
  function useVertxTimer() {
    return function() {
      vertxNext(flush);
    };
  }
  function useMutationObserver() {
    var iterations = 0;
    var observer = new BrowserMutationObserver(flush);
    var node = document.createTextNode('');
    observer.observe(node, {characterData: true});
    return function() {
      node.data = (iterations = ++iterations % 2);
    };
  }
  function useMessageChannel() {
    var channel = new MessageChannel();
    channel.port1.onmessage = flush;
    return function() {
      channel.port2.postMessage(0);
    };
  }
  function useSetTimeout() {
    return function() {
      setTimeout(flush, 1);
    };
  }
  var queue = new Array(1000);
  function flush() {
    for (var i = 0; i < len; i += 2) {
      var callback = queue[i];
      var arg = queue[i + 1];
      callback(arg);
      queue[i] = undefined;
      queue[i + 1] = undefined;
    }
    len = 0;
  }
  function attemptVertex() {
    try {
      var r = require;
      var vertx = r('vertx');
      vertxNext = vertx.runOnLoop || vertx.runOnContext;
      return useVertxTimer();
    } catch (e) {
      return useSetTimeout();
    }
  }
  var scheduleFlush;
  if (isNode) {
    scheduleFlush = useNextTick();
  } else if (BrowserMutationObserver) {
    scheduleFlush = useMutationObserver();
  } else if (isWorker) {
    scheduleFlush = useMessageChannel();
  } else if (browserWindow === undefined && typeof require === 'function') {
    scheduleFlush = attemptVertex();
  } else {
    scheduleFlush = useSetTimeout();
  }
  return {get default() {
      return $__default;
    }};
});
$traceurRuntime.registerModule("traceur-runtime@0.0.102/src/runtime/polyfills/Promise.js", [], function() {
  "use strict";
  var __moduleName = "traceur-runtime@0.0.102/src/runtime/polyfills/Promise.js";
  var async = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../../../node_modules/rsvp/lib/rsvp/asap.js", "traceur-runtime@0.0.102/src/runtime/polyfills/Promise.js")).default;
  var $__1 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./utils.js", "traceur-runtime@0.0.102/src/runtime/polyfills/Promise.js")),
      isObject = $__1.isObject,
      registerPolyfill = $__1.registerPolyfill;
  var $__2 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../private.js", "traceur-runtime@0.0.102/src/runtime/polyfills/Promise.js")),
      createPrivateSymbol = $__2.createPrivateSymbol,
      getPrivate = $__2.getPrivate,
      setPrivate = $__2.setPrivate;
  var promiseRaw = {};
  function isPromise(x) {
    return x && typeof x === 'object' && x.status_ !== undefined;
  }
  function idResolveHandler(x) {
    return x;
  }
  function idRejectHandler(x) {
    throw x;
  }
  function chain(promise) {
    var onResolve = arguments[1] !== (void 0) ? arguments[1] : idResolveHandler;
    var onReject = arguments[2] !== (void 0) ? arguments[2] : idRejectHandler;
    var deferred = getDeferred(promise.constructor);
    switch (promise.status_) {
      case undefined:
        throw TypeError;
      case 0:
        promise.onResolve_.push(onResolve, deferred);
        promise.onReject_.push(onReject, deferred);
        break;
      case +1:
        promiseEnqueue(promise.value_, [onResolve, deferred]);
        break;
      case -1:
        promiseEnqueue(promise.value_, [onReject, deferred]);
        break;
    }
    return deferred.promise;
  }
  function getDeferred(C) {
    if (this === $Promise) {
      var promise = promiseInit(new $Promise(promiseRaw));
      return {
        promise: promise,
        resolve: function(x) {
          promiseResolve(promise, x);
        },
        reject: function(r) {
          promiseReject(promise, r);
        }
      };
    } else {
      var result = {};
      result.promise = new C(function(resolve, reject) {
        result.resolve = resolve;
        result.reject = reject;
      });
      return result;
    }
  }
  function promiseSet(promise, status, value, onResolve, onReject) {
    promise.status_ = status;
    promise.value_ = value;
    promise.onResolve_ = onResolve;
    promise.onReject_ = onReject;
    return promise;
  }
  function promiseInit(promise) {
    return promiseSet(promise, 0, undefined, [], []);
  }
  var Promise = function() {
    function Promise(resolver) {
      if (resolver === promiseRaw)
        return;
      if (typeof resolver !== 'function')
        throw new TypeError;
      var promise = promiseInit(this);
      try {
        resolver(function(x) {
          promiseResolve(promise, x);
        }, function(r) {
          promiseReject(promise, r);
        });
      } catch (e) {
        promiseReject(promise, e);
      }
    }
    return ($traceurRuntime.createClass)(Promise, {
      catch: function(onReject) {
        return this.then(undefined, onReject);
      },
      then: function(onResolve, onReject) {
        if (typeof onResolve !== 'function')
          onResolve = idResolveHandler;
        if (typeof onReject !== 'function')
          onReject = idRejectHandler;
        var that = this;
        var constructor = this.constructor;
        return chain(this, function(x) {
          x = promiseCoerce(constructor, x);
          return x === that ? onReject(new TypeError) : isPromise(x) ? x.then(onResolve, onReject) : onResolve(x);
        }, onReject);
      }
    }, {
      resolve: function(x) {
        if (this === $Promise) {
          if (isPromise(x)) {
            return x;
          }
          return promiseSet(new $Promise(promiseRaw), +1, x);
        } else {
          return new this(function(resolve, reject) {
            resolve(x);
          });
        }
      },
      reject: function(r) {
        if (this === $Promise) {
          return promiseSet(new $Promise(promiseRaw), -1, r);
        } else {
          return new this(function(resolve, reject) {
            reject(r);
          });
        }
      },
      all: function(values) {
        var deferred = getDeferred(this);
        var resolutions = [];
        try {
          var makeCountdownFunction = function(i) {
            return function(x) {
              resolutions[i] = x;
              if (--count === 0)
                deferred.resolve(resolutions);
            };
          };
          var count = 0;
          var i = 0;
          var $__7 = true;
          var $__8 = false;
          var $__9 = undefined;
          try {
            for (var $__5 = void 0,
                $__4 = (values)[Symbol.iterator](); !($__7 = ($__5 = $__4.next()).done); $__7 = true) {
              var value = $__5.value;
              {
                var countdownFunction = makeCountdownFunction(i);
                this.resolve(value).then(countdownFunction, function(r) {
                  deferred.reject(r);
                });
                ++i;
                ++count;
              }
            }
          } catch ($__10) {
            $__8 = true;
            $__9 = $__10;
          } finally {
            try {
              if (!$__7 && $__4.return != null) {
                $__4.return();
              }
            } finally {
              if ($__8) {
                throw $__9;
              }
            }
          }
          if (count === 0) {
            deferred.resolve(resolutions);
          }
        } catch (e) {
          deferred.reject(e);
        }
        return deferred.promise;
      },
      race: function(values) {
        var deferred = getDeferred(this);
        try {
          for (var i = 0; i < values.length; i++) {
            this.resolve(values[i]).then(function(x) {
              deferred.resolve(x);
            }, function(r) {
              deferred.reject(r);
            });
          }
        } catch (e) {
          deferred.reject(e);
        }
        return deferred.promise;
      }
    });
  }();
  var $Promise = Promise;
  var $PromiseReject = $Promise.reject;
  function promiseResolve(promise, x) {
    promiseDone(promise, +1, x, promise.onResolve_);
  }
  function promiseReject(promise, r) {
    promiseDone(promise, -1, r, promise.onReject_);
  }
  function promiseDone(promise, status, value, reactions) {
    if (promise.status_ !== 0)
      return;
    promiseEnqueue(value, reactions);
    promiseSet(promise, status, value);
  }
  function promiseEnqueue(value, tasks) {
    async(function() {
      for (var i = 0; i < tasks.length; i += 2) {
        promiseHandle(value, tasks[i], tasks[i + 1]);
      }
    });
  }
  function promiseHandle(value, handler, deferred) {
    try {
      var result = handler(value);
      if (result === deferred.promise)
        throw new TypeError;
      else if (isPromise(result))
        chain(result, deferred.resolve, deferred.reject);
      else
        deferred.resolve(result);
    } catch (e) {
      try {
        deferred.reject(e);
      } catch (e) {}
    }
  }
  var thenableSymbol = createPrivateSymbol();
  function promiseCoerce(constructor, x) {
    if (!isPromise(x) && isObject(x)) {
      var then;
      try {
        then = x.then;
      } catch (r) {
        var promise = $PromiseReject.call(constructor, r);
        setPrivate(x, thenableSymbol, promise);
        return promise;
      }
      if (typeof then === 'function') {
        var p = getPrivate(x, thenableSymbol);
        if (p) {
          return p;
        } else {
          var deferred = getDeferred(constructor);
          setPrivate(x, thenableSymbol, deferred.promise);
          try {
            then.call(x, deferred.resolve, deferred.reject);
          } catch (r) {
            deferred.reject(r);
          }
          return deferred.promise;
        }
      }
    }
    return x;
  }
  function polyfillPromise(global) {
    if (!global.Promise)
      global.Promise = Promise;
  }
  registerPolyfill(polyfillPromise);
  return {
    get Promise() {
      return Promise;
    },
    get polyfillPromise() {
      return polyfillPromise;
    }
  };
});
$traceurRuntime.getModule("traceur-runtime@0.0.102/src/runtime/polyfills/Promise.js" + '');
$traceurRuntime.registerModule("traceur-runtime@0.0.102/src/runtime/polyfills/StringIterator.js", [], function() {
  "use strict";
  var __moduleName = "traceur-runtime@0.0.102/src/runtime/polyfills/StringIterator.js";
  var $__0 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./utils.js", "traceur-runtime@0.0.102/src/runtime/polyfills/StringIterator.js")),
      createIteratorResultObject = $__0.createIteratorResultObject,
      isObject = $__0.isObject;
  var hasOwnProperty = Object.prototype.hasOwnProperty;
  var iteratedString = Symbol('iteratedString');
  var stringIteratorNextIndex = Symbol('stringIteratorNextIndex');
  var StringIterator = function() {
    var $__3;
    function StringIterator() {}
    return ($traceurRuntime.createClass)(StringIterator, ($__3 = {}, Object.defineProperty($__3, "next", {
      value: function() {
        var o = this;
        if (!isObject(o) || !hasOwnProperty.call(o, iteratedString)) {
          throw new TypeError('this must be a StringIterator object');
        }
        var s = o[iteratedString];
        if (s === undefined) {
          return createIteratorResultObject(undefined, true);
        }
        var position = o[stringIteratorNextIndex];
        var len = s.length;
        if (position >= len) {
          o[iteratedString] = undefined;
          return createIteratorResultObject(undefined, true);
        }
        var first = s.charCodeAt(position);
        var resultString;
        if (first < 0xD800 || first > 0xDBFF || position + 1 === len) {
          resultString = String.fromCharCode(first);
        } else {
          var second = s.charCodeAt(position + 1);
          if (second < 0xDC00 || second > 0xDFFF) {
            resultString = String.fromCharCode(first);
          } else {
            resultString = String.fromCharCode(first) + String.fromCharCode(second);
          }
        }
        o[stringIteratorNextIndex] = position + resultString.length;
        return createIteratorResultObject(resultString, false);
      },
      configurable: true,
      enumerable: true,
      writable: true
    }), Object.defineProperty($__3, Symbol.iterator, {
      value: function() {
        return this;
      },
      configurable: true,
      enumerable: true,
      writable: true
    }), $__3), {});
  }();
  function createStringIterator(string) {
    var s = String(string);
    var iterator = Object.create(StringIterator.prototype);
    iterator[iteratedString] = s;
    iterator[stringIteratorNextIndex] = 0;
    return iterator;
  }
  return {get createStringIterator() {
      return createStringIterator;
    }};
});
$traceurRuntime.registerModule("traceur-runtime@0.0.102/src/runtime/polyfills/String.js", [], function() {
  "use strict";
  var __moduleName = "traceur-runtime@0.0.102/src/runtime/polyfills/String.js";
  var checkObjectCoercible = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../checkObjectCoercible.js", "traceur-runtime@0.0.102/src/runtime/polyfills/String.js")).default;
  var createStringIterator = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./StringIterator.js", "traceur-runtime@0.0.102/src/runtime/polyfills/String.js")).createStringIterator;
  var $__2 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./utils.js", "traceur-runtime@0.0.102/src/runtime/polyfills/String.js")),
      maybeAddFunctions = $__2.maybeAddFunctions,
      maybeAddIterator = $__2.maybeAddIterator,
      registerPolyfill = $__2.registerPolyfill;
  var $toString = Object.prototype.toString;
  var $indexOf = String.prototype.indexOf;
  var $lastIndexOf = String.prototype.lastIndexOf;
  function startsWith(search) {
    var string = String(this);
    if (this == null || $toString.call(search) == '[object RegExp]') {
      throw TypeError();
    }
    var stringLength = string.length;
    var searchString = String(search);
    var searchLength = searchString.length;
    var position = arguments.length > 1 ? arguments[1] : undefined;
    var pos = position ? Number(position) : 0;
    if (isNaN(pos)) {
      pos = 0;
    }
    var start = Math.min(Math.max(pos, 0), stringLength);
    return $indexOf.call(string, searchString, pos) == start;
  }
  function endsWith(search) {
    var string = String(this);
    if (this == null || $toString.call(search) == '[object RegExp]') {
      throw TypeError();
    }
    var stringLength = string.length;
    var searchString = String(search);
    var searchLength = searchString.length;
    var pos = stringLength;
    if (arguments.length > 1) {
      var position = arguments[1];
      if (position !== undefined) {
        pos = position ? Number(position) : 0;
        if (isNaN(pos)) {
          pos = 0;
        }
      }
    }
    var end = Math.min(Math.max(pos, 0), stringLength);
    var start = end - searchLength;
    if (start < 0) {
      return false;
    }
    return $lastIndexOf.call(string, searchString, start) == start;
  }
  function includes(search) {
    if (this == null) {
      throw TypeError();
    }
    var string = String(this);
    if (search && $toString.call(search) == '[object RegExp]') {
      throw TypeError();
    }
    var stringLength = string.length;
    var searchString = String(search);
    var searchLength = searchString.length;
    var position = arguments.length > 1 ? arguments[1] : undefined;
    var pos = position ? Number(position) : 0;
    if (pos != pos) {
      pos = 0;
    }
    var start = Math.min(Math.max(pos, 0), stringLength);
    if (searchLength + start > stringLength) {
      return false;
    }
    return $indexOf.call(string, searchString, pos) != -1;
  }
  function repeat(count) {
    if (this == null) {
      throw TypeError();
    }
    var string = String(this);
    var n = count ? Number(count) : 0;
    if (isNaN(n)) {
      n = 0;
    }
    if (n < 0 || n == Infinity) {
      throw RangeError();
    }
    if (n == 0) {
      return '';
    }
    var result = '';
    while (n--) {
      result += string;
    }
    return result;
  }
  function codePointAt(position) {
    if (this == null) {
      throw TypeError();
    }
    var string = String(this);
    var size = string.length;
    var index = position ? Number(position) : 0;
    if (isNaN(index)) {
      index = 0;
    }
    if (index < 0 || index >= size) {
      return undefined;
    }
    var first = string.charCodeAt(index);
    var second;
    if (first >= 0xD800 && first <= 0xDBFF && size > index + 1) {
      second = string.charCodeAt(index + 1);
      if (second >= 0xDC00 && second <= 0xDFFF) {
        return (first - 0xD800) * 0x400 + second - 0xDC00 + 0x10000;
      }
    }
    return first;
  }
  function raw(callsite) {
    var raw = callsite.raw;
    var len = raw.length >>> 0;
    if (len === 0)
      return '';
    var s = '';
    var i = 0;
    while (true) {
      s += raw[i];
      if (i + 1 === len)
        return s;
      s += arguments[++i];
    }
  }
  function fromCodePoint(_) {
    var codeUnits = [];
    var floor = Math.floor;
    var highSurrogate;
    var lowSurrogate;
    var index = -1;
    var length = arguments.length;
    if (!length) {
      return '';
    }
    while (++index < length) {
      var codePoint = Number(arguments[index]);
      if (!isFinite(codePoint) || codePoint < 0 || codePoint > 0x10FFFF || floor(codePoint) != codePoint) {
        throw RangeError('Invalid code point: ' + codePoint);
      }
      if (codePoint <= 0xFFFF) {
        codeUnits.push(codePoint);
      } else {
        codePoint -= 0x10000;
        highSurrogate = (codePoint >> 10) + 0xD800;
        lowSurrogate = (codePoint % 0x400) + 0xDC00;
        codeUnits.push(highSurrogate, lowSurrogate);
      }
    }
    return String.fromCharCode.apply(null, codeUnits);
  }
  function stringPrototypeIterator() {
    var o = checkObjectCoercible(this);
    var s = String(o);
    return createStringIterator(s);
  }
  function polyfillString(global) {
    var String = global.String;
    maybeAddFunctions(String.prototype, ['codePointAt', codePointAt, 'endsWith', endsWith, 'includes', includes, 'repeat', repeat, 'startsWith', startsWith]);
    maybeAddFunctions(String, ['fromCodePoint', fromCodePoint, 'raw', raw]);
    maybeAddIterator(String.prototype, stringPrototypeIterator, Symbol);
  }
  registerPolyfill(polyfillString);
  return {
    get startsWith() {
      return startsWith;
    },
    get endsWith() {
      return endsWith;
    },
    get includes() {
      return includes;
    },
    get repeat() {
      return repeat;
    },
    get codePointAt() {
      return codePointAt;
    },
    get raw() {
      return raw;
    },
    get fromCodePoint() {
      return fromCodePoint;
    },
    get stringPrototypeIterator() {
      return stringPrototypeIterator;
    },
    get polyfillString() {
      return polyfillString;
    }
  };
});
$traceurRuntime.getModule("traceur-runtime@0.0.102/src/runtime/polyfills/String.js" + '');
$traceurRuntime.registerModule("traceur-runtime@0.0.102/src/runtime/polyfills/ArrayIterator.js", [], function() {
  "use strict";
  var __moduleName = "traceur-runtime@0.0.102/src/runtime/polyfills/ArrayIterator.js";
  var $__0 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./utils.js", "traceur-runtime@0.0.102/src/runtime/polyfills/ArrayIterator.js")),
      toObject = $__0.toObject,
      toUint32 = $__0.toUint32,
      createIteratorResultObject = $__0.createIteratorResultObject;
  var ARRAY_ITERATOR_KIND_KEYS = 1;
  var ARRAY_ITERATOR_KIND_VALUES = 2;
  var ARRAY_ITERATOR_KIND_ENTRIES = 3;
  var ArrayIterator = function() {
    var $__3;
    function ArrayIterator() {}
    return ($traceurRuntime.createClass)(ArrayIterator, ($__3 = {}, Object.defineProperty($__3, "next", {
      value: function() {
        var iterator = toObject(this);
        var array = iterator.iteratorObject_;
        if (!array) {
          throw new TypeError('Object is not an ArrayIterator');
        }
        var index = iterator.arrayIteratorNextIndex_;
        var itemKind = iterator.arrayIterationKind_;
        var length = toUint32(array.length);
        if (index >= length) {
          iterator.arrayIteratorNextIndex_ = Infinity;
          return createIteratorResultObject(undefined, true);
        }
        iterator.arrayIteratorNextIndex_ = index + 1;
        if (itemKind == ARRAY_ITERATOR_KIND_VALUES)
          return createIteratorResultObject(array[index], false);
        if (itemKind == ARRAY_ITERATOR_KIND_ENTRIES)
          return createIteratorResultObject([index, array[index]], false);
        return createIteratorResultObject(index, false);
      },
      configurable: true,
      enumerable: true,
      writable: true
    }), Object.defineProperty($__3, Symbol.iterator, {
      value: function() {
        return this;
      },
      configurable: true,
      enumerable: true,
      writable: true
    }), $__3), {});
  }();
  function createArrayIterator(array, kind) {
    var object = toObject(array);
    var iterator = new ArrayIterator;
    iterator.iteratorObject_ = object;
    iterator.arrayIteratorNextIndex_ = 0;
    iterator.arrayIterationKind_ = kind;
    return iterator;
  }
  function entries() {
    return createArrayIterator(this, ARRAY_ITERATOR_KIND_ENTRIES);
  }
  function keys() {
    return createArrayIterator(this, ARRAY_ITERATOR_KIND_KEYS);
  }
  function values() {
    return createArrayIterator(this, ARRAY_ITERATOR_KIND_VALUES);
  }
  return {
    get entries() {
      return entries;
    },
    get keys() {
      return keys;
    },
    get values() {
      return values;
    }
  };
});
$traceurRuntime.registerModule("traceur-runtime@0.0.102/src/runtime/polyfills/Array.js", [], function() {
  "use strict";
  var __moduleName = "traceur-runtime@0.0.102/src/runtime/polyfills/Array.js";
  var $__0 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ArrayIterator.js", "traceur-runtime@0.0.102/src/runtime/polyfills/Array.js")),
      entries = $__0.entries,
      keys = $__0.keys,
      jsValues = $__0.values;
  var $__1 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./utils.js", "traceur-runtime@0.0.102/src/runtime/polyfills/Array.js")),
      checkIterable = $__1.checkIterable,
      isCallable = $__1.isCallable,
      isConstructor = $__1.isConstructor,
      maybeAddFunctions = $__1.maybeAddFunctions,
      maybeAddIterator = $__1.maybeAddIterator,
      registerPolyfill = $__1.registerPolyfill,
      toInteger = $__1.toInteger,
      toLength = $__1.toLength,
      toObject = $__1.toObject;
  function from(arrLike) {
    var mapFn = arguments[1];
    var thisArg = arguments[2];
    var C = this;
    var items = toObject(arrLike);
    var mapping = mapFn !== undefined;
    var k = 0;
    var arr,
        len;
    if (mapping && !isCallable(mapFn)) {
      throw TypeError();
    }
    if (checkIterable(items)) {
      arr = isConstructor(C) ? new C() : [];
      var $__6 = true;
      var $__7 = false;
      var $__8 = undefined;
      try {
        for (var $__4 = void 0,
            $__3 = (items)[Symbol.iterator](); !($__6 = ($__4 = $__3.next()).done); $__6 = true) {
          var item = $__4.value;
          {
            if (mapping) {
              arr[k] = mapFn.call(thisArg, item, k);
            } else {
              arr[k] = item;
            }
            k++;
          }
        }
      } catch ($__9) {
        $__7 = true;
        $__8 = $__9;
      } finally {
        try {
          if (!$__6 && $__3.return != null) {
            $__3.return();
          }
        } finally {
          if ($__7) {
            throw $__8;
          }
        }
      }
      arr.length = k;
      return arr;
    }
    len = toLength(items.length);
    arr = isConstructor(C) ? new C(len) : new Array(len);
    for (; k < len; k++) {
      if (mapping) {
        arr[k] = typeof thisArg === 'undefined' ? mapFn(items[k], k) : mapFn.call(thisArg, items[k], k);
      } else {
        arr[k] = items[k];
      }
    }
    arr.length = len;
    return arr;
  }
  function of() {
    for (var items = [],
        $__10 = 0; $__10 < arguments.length; $__10++)
      items[$__10] = arguments[$__10];
    var C = this;
    var len = items.length;
    var arr = isConstructor(C) ? new C(len) : new Array(len);
    for (var k = 0; k < len; k++) {
      arr[k] = items[k];
    }
    arr.length = len;
    return arr;
  }
  function fill(value) {
    var start = arguments[1] !== (void 0) ? arguments[1] : 0;
    var end = arguments[2];
    var object = toObject(this);
    var len = toLength(object.length);
    var fillStart = toInteger(start);
    var fillEnd = end !== undefined ? toInteger(end) : len;
    fillStart = fillStart < 0 ? Math.max(len + fillStart, 0) : Math.min(fillStart, len);
    fillEnd = fillEnd < 0 ? Math.max(len + fillEnd, 0) : Math.min(fillEnd, len);
    while (fillStart < fillEnd) {
      object[fillStart] = value;
      fillStart++;
    }
    return object;
  }
  function find(predicate) {
    var thisArg = arguments[1];
    return findHelper(this, predicate, thisArg);
  }
  function findIndex(predicate) {
    var thisArg = arguments[1];
    return findHelper(this, predicate, thisArg, true);
  }
  function findHelper(self, predicate) {
    var thisArg = arguments[2];
    var returnIndex = arguments[3] !== (void 0) ? arguments[3] : false;
    var object = toObject(self);
    var len = toLength(object.length);
    if (!isCallable(predicate)) {
      throw TypeError();
    }
    for (var i = 0; i < len; i++) {
      var value = object[i];
      if (predicate.call(thisArg, value, i, object)) {
        return returnIndex ? i : value;
      }
    }
    return returnIndex ? -1 : undefined;
  }
  function polyfillArray(global) {
    var $__11 = global,
        Array = $__11.Array,
        Object = $__11.Object,
        Symbol = $__11.Symbol;
    var values = jsValues;
    if (Symbol && Symbol.iterator && Array.prototype[Symbol.iterator]) {
      values = Array.prototype[Symbol.iterator];
    }
    maybeAddFunctions(Array.prototype, ['entries', entries, 'keys', keys, 'values', values, 'fill', fill, 'find', find, 'findIndex', findIndex]);
    maybeAddFunctions(Array, ['from', from, 'of', of]);
    maybeAddIterator(Array.prototype, values, Symbol);
    maybeAddIterator(Object.getPrototypeOf([].values()), function() {
      return this;
    }, Symbol);
  }
  registerPolyfill(polyfillArray);
  return {
    get from() {
      return from;
    },
    get of() {
      return of;
    },
    get fill() {
      return fill;
    },
    get find() {
      return find;
    },
    get findIndex() {
      return findIndex;
    },
    get polyfillArray() {
      return polyfillArray;
    }
  };
});
$traceurRuntime.getModule("traceur-runtime@0.0.102/src/runtime/polyfills/Array.js" + '');
$traceurRuntime.registerModule("traceur-runtime@0.0.102/src/runtime/polyfills/Object.js", [], function() {
  "use strict";
  var __moduleName = "traceur-runtime@0.0.102/src/runtime/polyfills/Object.js";
  var $__0 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./utils.js", "traceur-runtime@0.0.102/src/runtime/polyfills/Object.js")),
      maybeAddFunctions = $__0.maybeAddFunctions,
      registerPolyfill = $__0.registerPolyfill;
  var $__2 = Object,
      defineProperty = $__2.defineProperty,
      getOwnPropertyDescriptor = $__2.getOwnPropertyDescriptor,
      getOwnPropertyNames = $__2.getOwnPropertyNames,
      keys = $__2.keys;
  function is(left, right) {
    if (left === right)
      return left !== 0 || 1 / left === 1 / right;
    return left !== left && right !== right;
  }
  function assign(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];
      var props = source == null ? [] : keys(source);
      var p = void 0,
          length = props.length;
      for (p = 0; p < length; p++) {
        var name = props[p];
        target[name] = source[name];
      }
    }
    return target;
  }
  function mixin(target, source) {
    var props = getOwnPropertyNames(source);
    var p,
        descriptor,
        length = props.length;
    for (p = 0; p < length; p++) {
      var name = props[p];
      descriptor = getOwnPropertyDescriptor(source, props[p]);
      defineProperty(target, props[p], descriptor);
    }
    return target;
  }
  function polyfillObject(global) {
    var Object = global.Object;
    maybeAddFunctions(Object, ['assign', assign, 'is', is, 'mixin', mixin]);
  }
  registerPolyfill(polyfillObject);
  return {
    get is() {
      return is;
    },
    get assign() {
      return assign;
    },
    get mixin() {
      return mixin;
    },
    get polyfillObject() {
      return polyfillObject;
    }
  };
});
$traceurRuntime.getModule("traceur-runtime@0.0.102/src/runtime/polyfills/Object.js" + '');
$traceurRuntime.registerModule("traceur-runtime@0.0.102/src/runtime/polyfills/Number.js", [], function() {
  "use strict";
  var __moduleName = "traceur-runtime@0.0.102/src/runtime/polyfills/Number.js";
  var $__0 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./utils.js", "traceur-runtime@0.0.102/src/runtime/polyfills/Number.js")),
      isNumber = $__0.isNumber,
      maybeAddConsts = $__0.maybeAddConsts,
      maybeAddFunctions = $__0.maybeAddFunctions,
      registerPolyfill = $__0.registerPolyfill,
      toInteger = $__0.toInteger;
  var $abs = Math.abs;
  var $isFinite = isFinite;
  var $isNaN = isNaN;
  var MAX_SAFE_INTEGER = Math.pow(2, 53) - 1;
  var MIN_SAFE_INTEGER = -Math.pow(2, 53) + 1;
  var EPSILON = Math.pow(2, -52);
  function NumberIsFinite(number) {
    return isNumber(number) && $isFinite(number);
  }
  function isInteger(number) {
    return NumberIsFinite(number) && toInteger(number) === number;
  }
  function NumberIsNaN(number) {
    return isNumber(number) && $isNaN(number);
  }
  function isSafeInteger(number) {
    if (NumberIsFinite(number)) {
      var integral = toInteger(number);
      if (integral === number)
        return $abs(integral) <= MAX_SAFE_INTEGER;
    }
    return false;
  }
  function polyfillNumber(global) {
    var Number = global.Number;
    maybeAddConsts(Number, ['MAX_SAFE_INTEGER', MAX_SAFE_INTEGER, 'MIN_SAFE_INTEGER', MIN_SAFE_INTEGER, 'EPSILON', EPSILON]);
    maybeAddFunctions(Number, ['isFinite', NumberIsFinite, 'isInteger', isInteger, 'isNaN', NumberIsNaN, 'isSafeInteger', isSafeInteger]);
  }
  registerPolyfill(polyfillNumber);
  return {
    get MAX_SAFE_INTEGER() {
      return MAX_SAFE_INTEGER;
    },
    get MIN_SAFE_INTEGER() {
      return MIN_SAFE_INTEGER;
    },
    get EPSILON() {
      return EPSILON;
    },
    get isFinite() {
      return NumberIsFinite;
    },
    get isInteger() {
      return isInteger;
    },
    get isNaN() {
      return NumberIsNaN;
    },
    get isSafeInteger() {
      return isSafeInteger;
    },
    get polyfillNumber() {
      return polyfillNumber;
    }
  };
});
$traceurRuntime.getModule("traceur-runtime@0.0.102/src/runtime/polyfills/Number.js" + '');
$traceurRuntime.registerModule("traceur-runtime@0.0.102/src/runtime/polyfills/fround.js", [], function() {
  "use strict";
  var __moduleName = "traceur-runtime@0.0.102/src/runtime/polyfills/fround.js";
  var $isFinite = isFinite;
  var $isNaN = isNaN;
  var $__1 = Math,
      LN2 = $__1.LN2,
      abs = $__1.abs,
      floor = $__1.floor,
      log = $__1.log,
      min = $__1.min,
      pow = $__1.pow;
  function packIEEE754(v, ebits, fbits) {
    var bias = (1 << (ebits - 1)) - 1,
        s,
        e,
        f,
        ln,
        i,
        bits,
        str,
        bytes;
    function roundToEven(n) {
      var w = floor(n),
          f = n - w;
      if (f < 0.5)
        return w;
      if (f > 0.5)
        return w + 1;
      return w % 2 ? w + 1 : w;
    }
    if (v !== v) {
      e = (1 << ebits) - 1;
      f = pow(2, fbits - 1);
      s = 0;
    } else if (v === Infinity || v === -Infinity) {
      e = (1 << ebits) - 1;
      f = 0;
      s = (v < 0) ? 1 : 0;
    } else if (v === 0) {
      e = 0;
      f = 0;
      s = (1 / v === -Infinity) ? 1 : 0;
    } else {
      s = v < 0;
      v = abs(v);
      if (v >= pow(2, 1 - bias)) {
        e = min(floor(log(v) / LN2), 1023);
        f = roundToEven(v / pow(2, e) * pow(2, fbits));
        if (f / pow(2, fbits) >= 2) {
          e = e + 1;
          f = 1;
        }
        if (e > bias) {
          e = (1 << ebits) - 1;
          f = 0;
        } else {
          e = e + bias;
          f = f - pow(2, fbits);
        }
      } else {
        e = 0;
        f = roundToEven(v / pow(2, 1 - bias - fbits));
      }
    }
    bits = [];
    for (i = fbits; i; i -= 1) {
      bits.push(f % 2 ? 1 : 0);
      f = floor(f / 2);
    }
    for (i = ebits; i; i -= 1) {
      bits.push(e % 2 ? 1 : 0);
      e = floor(e / 2);
    }
    bits.push(s ? 1 : 0);
    bits.reverse();
    str = bits.join('');
    bytes = [];
    while (str.length) {
      bytes.push(parseInt(str.substring(0, 8), 2));
      str = str.substring(8);
    }
    return bytes;
  }
  function unpackIEEE754(bytes, ebits, fbits) {
    var bits = [],
        i,
        j,
        b,
        str,
        bias,
        s,
        e,
        f;
    for (i = bytes.length; i; i -= 1) {
      b = bytes[i - 1];
      for (j = 8; j; j -= 1) {
        bits.push(b % 2 ? 1 : 0);
        b = b >> 1;
      }
    }
    bits.reverse();
    str = bits.join('');
    bias = (1 << (ebits - 1)) - 1;
    s = parseInt(str.substring(0, 1), 2) ? -1 : 1;
    e = parseInt(str.substring(1, 1 + ebits), 2);
    f = parseInt(str.substring(1 + ebits), 2);
    if (e === (1 << ebits) - 1) {
      return f !== 0 ? NaN : s * Infinity;
    } else if (e > 0) {
      return s * pow(2, e - bias) * (1 + f / pow(2, fbits));
    } else if (f !== 0) {
      return s * pow(2, -(bias - 1)) * (f / pow(2, fbits));
    } else {
      return s < 0 ? -0 : 0;
    }
  }
  function unpackF32(b) {
    return unpackIEEE754(b, 8, 23);
  }
  function packF32(v) {
    return packIEEE754(v, 8, 23);
  }
  function fround(x) {
    if (x === 0 || !$isFinite(x) || $isNaN(x)) {
      return x;
    }
    return unpackF32(packF32(Number(x)));
  }
  return {get fround() {
      return fround;
    }};
});
$traceurRuntime.registerModule("traceur-runtime@0.0.102/src/runtime/polyfills/Math.js", [], function() {
  "use strict";
  var __moduleName = "traceur-runtime@0.0.102/src/runtime/polyfills/Math.js";
  var jsFround = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./fround.js", "traceur-runtime@0.0.102/src/runtime/polyfills/Math.js")).fround;
  var $__1 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./utils.js", "traceur-runtime@0.0.102/src/runtime/polyfills/Math.js")),
      maybeAddFunctions = $__1.maybeAddFunctions,
      registerPolyfill = $__1.registerPolyfill,
      toUint32 = $__1.toUint32;
  var $isFinite = isFinite;
  var $isNaN = isNaN;
  var $__3 = Math,
      abs = $__3.abs,
      ceil = $__3.ceil,
      exp = $__3.exp,
      floor = $__3.floor,
      log = $__3.log,
      pow = $__3.pow,
      sqrt = $__3.sqrt;
  function clz32(x) {
    x = toUint32(+x);
    if (x == 0)
      return 32;
    var result = 0;
    if ((x & 0xFFFF0000) === 0) {
      x <<= 16;
      result += 16;
    }
    ;
    if ((x & 0xFF000000) === 0) {
      x <<= 8;
      result += 8;
    }
    ;
    if ((x & 0xF0000000) === 0) {
      x <<= 4;
      result += 4;
    }
    ;
    if ((x & 0xC0000000) === 0) {
      x <<= 2;
      result += 2;
    }
    ;
    if ((x & 0x80000000) === 0) {
      x <<= 1;
      result += 1;
    }
    ;
    return result;
  }
  function imul(x, y) {
    x = toUint32(+x);
    y = toUint32(+y);
    var xh = (x >>> 16) & 0xffff;
    var xl = x & 0xffff;
    var yh = (y >>> 16) & 0xffff;
    var yl = y & 0xffff;
    return xl * yl + (((xh * yl + xl * yh) << 16) >>> 0) | 0;
  }
  function sign(x) {
    x = +x;
    if (x > 0)
      return 1;
    if (x < 0)
      return -1;
    return x;
  }
  function log10(x) {
    return log(x) * 0.434294481903251828;
  }
  function log2(x) {
    return log(x) * 1.442695040888963407;
  }
  function log1p(x) {
    x = +x;
    if (x < -1 || $isNaN(x)) {
      return NaN;
    }
    if (x === 0 || x === Infinity) {
      return x;
    }
    if (x === -1) {
      return -Infinity;
    }
    var result = 0;
    var n = 50;
    if (x < 0 || x > 1) {
      return log(1 + x);
    }
    for (var i = 1; i < n; i++) {
      if ((i % 2) === 0) {
        result -= pow(x, i) / i;
      } else {
        result += pow(x, i) / i;
      }
    }
    return result;
  }
  function expm1(x) {
    x = +x;
    if (x === -Infinity) {
      return -1;
    }
    if (!$isFinite(x) || x === 0) {
      return x;
    }
    return exp(x) - 1;
  }
  function cosh(x) {
    x = +x;
    if (x === 0) {
      return 1;
    }
    if ($isNaN(x)) {
      return NaN;
    }
    if (!$isFinite(x)) {
      return Infinity;
    }
    if (x < 0) {
      x = -x;
    }
    if (x > 21) {
      return exp(x) / 2;
    }
    return (exp(x) + exp(-x)) / 2;
  }
  function sinh(x) {
    x = +x;
    if (!$isFinite(x) || x === 0) {
      return x;
    }
    return (exp(x) - exp(-x)) / 2;
  }
  function tanh(x) {
    x = +x;
    if (x === 0)
      return x;
    if (!$isFinite(x))
      return sign(x);
    var exp1 = exp(x);
    var exp2 = exp(-x);
    return (exp1 - exp2) / (exp1 + exp2);
  }
  function acosh(x) {
    x = +x;
    if (x < 1)
      return NaN;
    if (!$isFinite(x))
      return x;
    return log(x + sqrt(x + 1) * sqrt(x - 1));
  }
  function asinh(x) {
    x = +x;
    if (x === 0 || !$isFinite(x))
      return x;
    if (x > 0)
      return log(x + sqrt(x * x + 1));
    return -log(-x + sqrt(x * x + 1));
  }
  function atanh(x) {
    x = +x;
    if (x === -1) {
      return -Infinity;
    }
    if (x === 1) {
      return Infinity;
    }
    if (x === 0) {
      return x;
    }
    if ($isNaN(x) || x < -1 || x > 1) {
      return NaN;
    }
    return 0.5 * log((1 + x) / (1 - x));
  }
  function hypot(x, y) {
    var length = arguments.length;
    var args = new Array(length);
    var max = 0;
    for (var i = 0; i < length; i++) {
      var n = arguments[i];
      n = +n;
      if (n === Infinity || n === -Infinity)
        return Infinity;
      n = abs(n);
      if (n > max)
        max = n;
      args[i] = n;
    }
    if (max === 0)
      max = 1;
    var sum = 0;
    var compensation = 0;
    for (var i = 0; i < length; i++) {
      var n = args[i] / max;
      var summand = n * n - compensation;
      var preliminary = sum + summand;
      compensation = (preliminary - sum) - summand;
      sum = preliminary;
    }
    return sqrt(sum) * max;
  }
  function trunc(x) {
    x = +x;
    if (x > 0)
      return floor(x);
    if (x < 0)
      return ceil(x);
    return x;
  }
  var fround,
      f32;
  if (typeof Float32Array === 'function') {
    f32 = new Float32Array(1);
    fround = function(x) {
      f32[0] = Number(x);
      return f32[0];
    };
  } else {
    fround = jsFround;
  }
  function cbrt(x) {
    x = +x;
    if (x === 0)
      return x;
    var negate = x < 0;
    if (negate)
      x = -x;
    var result = pow(x, 1 / 3);
    return negate ? -result : result;
  }
  function polyfillMath(global) {
    var Math = global.Math;
    maybeAddFunctions(Math, ['acosh', acosh, 'asinh', asinh, 'atanh', atanh, 'cbrt', cbrt, 'clz32', clz32, 'cosh', cosh, 'expm1', expm1, 'fround', fround, 'hypot', hypot, 'imul', imul, 'log10', log10, 'log1p', log1p, 'log2', log2, 'sign', sign, 'sinh', sinh, 'tanh', tanh, 'trunc', trunc]);
  }
  registerPolyfill(polyfillMath);
  return {
    get clz32() {
      return clz32;
    },
    get imul() {
      return imul;
    },
    get sign() {
      return sign;
    },
    get log10() {
      return log10;
    },
    get log2() {
      return log2;
    },
    get log1p() {
      return log1p;
    },
    get expm1() {
      return expm1;
    },
    get cosh() {
      return cosh;
    },
    get sinh() {
      return sinh;
    },
    get tanh() {
      return tanh;
    },
    get acosh() {
      return acosh;
    },
    get asinh() {
      return asinh;
    },
    get atanh() {
      return atanh;
    },
    get hypot() {
      return hypot;
    },
    get trunc() {
      return trunc;
    },
    get fround() {
      return fround;
    },
    get cbrt() {
      return cbrt;
    },
    get polyfillMath() {
      return polyfillMath;
    }
  };
});
$traceurRuntime.getModule("traceur-runtime@0.0.102/src/runtime/polyfills/Math.js" + '');
$traceurRuntime.registerModule("traceur-runtime@0.0.102/src/runtime/polyfills/WeakMap.js", [], function() {
  "use strict";
  var __moduleName = "traceur-runtime@0.0.102/src/runtime/polyfills/WeakMap.js";
  var $__0 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../private.js", "traceur-runtime@0.0.102/src/runtime/polyfills/WeakMap.js")),
      createPrivateSymbol = $__0.createPrivateSymbol,
      deletePrivate = $__0.deletePrivate,
      getPrivate = $__0.getPrivate,
      hasPrivate = $__0.hasPrivate,
      setPrivate = $__0.setPrivate;
  var $__1 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../frozen-data.js", "traceur-runtime@0.0.102/src/runtime/polyfills/WeakMap.js")),
      deleteFrozen = $__1.deleteFrozen,
      getFrozen = $__1.getFrozen,
      hasFrozen = $__1.hasFrozen,
      setFrozen = $__1.setFrozen;
  var $__2 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./utils.js", "traceur-runtime@0.0.102/src/runtime/polyfills/WeakMap.js")),
      isObject = $__2.isObject,
      registerPolyfill = $__2.registerPolyfill;
  var hasNativeSymbol = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../has-native-symbols.js", "traceur-runtime@0.0.102/src/runtime/polyfills/WeakMap.js")).default;
  var $__6 = Object,
      defineProperty = $__6.defineProperty,
      getOwnPropertyDescriptor = $__6.getOwnPropertyDescriptor,
      isExtensible = $__6.isExtensible;
  var $TypeError = TypeError;
  var hasOwnProperty = Object.prototype.hasOwnProperty;
  var sentinel = {};
  var WeakMap = function() {
    function WeakMap() {
      this.name_ = createPrivateSymbol();
      this.frozenData_ = [];
    }
    return ($traceurRuntime.createClass)(WeakMap, {
      set: function(key, value) {
        if (!isObject(key))
          throw new $TypeError('key must be an object');
        if (!isExtensible(key)) {
          setFrozen(this.frozenData_, key, value);
        } else {
          setPrivate(key, this.name_, value);
        }
        return this;
      },
      get: function(key) {
        if (!isObject(key))
          return undefined;
        if (!isExtensible(key)) {
          return getFrozen(this.frozenData_, key);
        }
        return getPrivate(key, this.name_);
      },
      delete: function(key) {
        if (!isObject(key))
          return false;
        if (!isExtensible(key)) {
          return deleteFrozen(this.frozenData_, key);
        }
        return deletePrivate(key, this.name_);
      },
      has: function(key) {
        if (!isObject(key))
          return false;
        if (!isExtensible(key)) {
          return hasFrozen(this.frozenData_, key);
        }
        return hasPrivate(key, this.name_);
      }
    }, {});
  }();
  function needsPolyfill(global) {
    var $__8 = global,
        WeakMap = $__8.WeakMap,
        Symbol = $__8.Symbol;
    if (!WeakMap || !hasNativeSymbol()) {
      return true;
    }
    try {
      var o = {};
      var wm = new WeakMap([[o, false]]);
      return wm.get(o);
    } catch (e) {
      return false;
    }
  }
  function polyfillWeakMap(global) {
    if (needsPolyfill(global)) {
      global.WeakMap = WeakMap;
    }
  }
  registerPolyfill(polyfillWeakMap);
  return {
    get WeakMap() {
      return WeakMap;
    },
    get polyfillWeakMap() {
      return polyfillWeakMap;
    }
  };
});
$traceurRuntime.getModule("traceur-runtime@0.0.102/src/runtime/polyfills/WeakMap.js" + '');
$traceurRuntime.registerModule("traceur-runtime@0.0.102/src/runtime/polyfills/WeakSet.js", [], function() {
  "use strict";
  var __moduleName = "traceur-runtime@0.0.102/src/runtime/polyfills/WeakSet.js";
  var $__0 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../private.js", "traceur-runtime@0.0.102/src/runtime/polyfills/WeakSet.js")),
      createPrivateSymbol = $__0.createPrivateSymbol,
      deletePrivate = $__0.deletePrivate,
      getPrivate = $__0.getPrivate,
      hasPrivate = $__0.hasPrivate,
      setPrivate = $__0.setPrivate;
  var $__1 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../frozen-data.js", "traceur-runtime@0.0.102/src/runtime/polyfills/WeakSet.js")),
      deleteFrozen = $__1.deleteFrozen,
      getFrozen = $__1.getFrozen,
      setFrozen = $__1.setFrozen;
  var $__2 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./utils.js", "traceur-runtime@0.0.102/src/runtime/polyfills/WeakSet.js")),
      isObject = $__2.isObject,
      registerPolyfill = $__2.registerPolyfill;
  var hasNativeSymbol = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../has-native-symbols.js", "traceur-runtime@0.0.102/src/runtime/polyfills/WeakSet.js")).default;
  var $__6 = Object,
      defineProperty = $__6.defineProperty,
      isExtensible = $__6.isExtensible;
  var $TypeError = TypeError;
  var hasOwnProperty = Object.prototype.hasOwnProperty;
  var WeakSet = function() {
    function WeakSet() {
      this.name_ = createPrivateSymbol();
      this.frozenData_ = [];
    }
    return ($traceurRuntime.createClass)(WeakSet, {
      add: function(value) {
        if (!isObject(value))
          throw new $TypeError('value must be an object');
        if (!isExtensible(value)) {
          setFrozen(this.frozenData_, value, value);
        } else {
          setPrivate(value, this.name_, true);
        }
        return this;
      },
      delete: function(value) {
        if (!isObject(value))
          return false;
        if (!isExtensible(value)) {
          return deleteFrozen(this.frozenData_, value);
        }
        return deletePrivate(value, this.name_);
      },
      has: function(value) {
        if (!isObject(value))
          return false;
        if (!isExtensible(value)) {
          return getFrozen(this.frozenData_, value) === value;
        }
        return hasPrivate(value, this.name_);
      }
    }, {});
  }();
  function needsPolyfill(global) {
    var $__8 = global,
        WeakSet = $__8.WeakSet,
        Symbol = $__8.Symbol;
    if (!WeakSet || !hasNativeSymbol()) {
      return true;
    }
    try {
      var o = {};
      var wm = new WeakSet([[o]]);
      return !wm.has(o);
    } catch (e) {
      return false;
    }
  }
  function polyfillWeakSet(global) {
    if (needsPolyfill(global)) {
      global.WeakSet = WeakSet;
    }
  }
  registerPolyfill(polyfillWeakSet);
  return {
    get WeakSet() {
      return WeakSet;
    },
    get polyfillWeakSet() {
      return polyfillWeakSet;
    }
  };
});
$traceurRuntime.getModule("traceur-runtime@0.0.102/src/runtime/polyfills/WeakSet.js" + '');
$traceurRuntime.registerModule("traceur-runtime@0.0.102/src/runtime/polyfills/polyfills.js", [], function() {
  "use strict";
  var __moduleName = "traceur-runtime@0.0.102/src/runtime/polyfills/polyfills.js";
  var polyfillAll = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./utils.js", "traceur-runtime@0.0.102/src/runtime/polyfills/polyfills.js")).polyfillAll;
  polyfillAll(Reflect.global);
  var setupGlobals = $traceurRuntime.setupGlobals;
  $traceurRuntime.setupGlobals = function(global) {
    setupGlobals(global);
    polyfillAll(global);
  };
  return {};
});
$traceurRuntime.getModule("traceur-runtime@0.0.102/src/runtime/polyfills/polyfills.js" + '');

System = curSystem; })();
!function(e){function r(e,r,o){return 4===arguments.length?t.apply(this,arguments):void n(e,{declarative:!0,deps:r,declare:o})}function t(e,r,t,o){n(e,{declarative:!1,deps:r,executingRequire:t,execute:o})}function n(e,r){r.name=e,e in p||(p[e]=r),r.normalizedDeps=r.deps}function o(e,r){if(r[e.groupIndex]=r[e.groupIndex]||[],-1==v.call(r[e.groupIndex],e)){r[e.groupIndex].push(e);for(var t=0,n=e.normalizedDeps.length;n>t;t++){var a=e.normalizedDeps[t],u=p[a];if(u&&!u.evaluated){var d=e.groupIndex+(u.declarative!=e.declarative);if(void 0===u.groupIndex||u.groupIndex<d){if(void 0!==u.groupIndex&&(r[u.groupIndex].splice(v.call(r[u.groupIndex],u),1),0==r[u.groupIndex].length))throw new TypeError("Mixed dependency cycle detected");u.groupIndex=d}o(u,r)}}}}function a(e){var r=p[e];r.groupIndex=0;var t=[];o(r,t);for(var n=!!r.declarative==t.length%2,a=t.length-1;a>=0;a--){for(var u=t[a],i=0;i<u.length;i++){var s=u[i];n?d(s):l(s)}n=!n}}function u(e){return x[e]||(x[e]={name:e,dependencies:[],exports:{},importers:[]})}function d(r){if(!r.module){var t=r.module=u(r.name),n=r.module.exports,o=r.declare.call(e,function(e,r){if(t.locked=!0,"object"==typeof e)for(var o in e)n[o]=e[o];else n[e]=r;for(var a=0,u=t.importers.length;u>a;a++){var d=t.importers[a];if(!d.locked)for(var i=0;i<d.dependencies.length;++i)d.dependencies[i]===t&&d.setters[i](n)}return t.locked=!1,r},r.name);t.setters=o.setters,t.execute=o.execute;for(var a=0,i=r.normalizedDeps.length;i>a;a++){var l,s=r.normalizedDeps[a],c=p[s],v=x[s];v?l=v.exports:c&&!c.declarative?l=c.esModule:c?(d(c),v=c.module,l=v.exports):l=f(s),v&&v.importers?(v.importers.push(t),t.dependencies.push(v)):t.dependencies.push(null),t.setters[a]&&t.setters[a](l)}}}function i(e){var r,t=p[e];if(t)t.declarative?c(e,[]):t.evaluated||l(t),r=t.module.exports;else if(r=f(e),!r)throw new Error("Unable to load dependency "+e+".");return(!t||t.declarative)&&r&&r.__useDefault?r["default"]:r}function l(r){if(!r.module){var t={},n=r.module={exports:t,id:r.name};if(!r.executingRequire)for(var o=0,a=r.normalizedDeps.length;a>o;o++){var u=r.normalizedDeps[o],d=p[u];d&&l(d)}r.evaluated=!0;var c=r.execute.call(e,function(e){for(var t=0,n=r.deps.length;n>t;t++)if(r.deps[t]==e)return i(r.normalizedDeps[t]);throw new TypeError("Module "+e+" not declared as a dependency.")},t,n);c&&(n.exports=c),t=n.exports,t&&t.__esModule?r.esModule=t:r.esModule=s(t)}}function s(r){if(r===e)return r;var t={};if("object"==typeof r||"function"==typeof r)if(g){var n;for(var o in r)(n=Object.getOwnPropertyDescriptor(r,o))&&h(t,o,n)}else{var a=r&&r.hasOwnProperty;for(var o in r)(!a||r.hasOwnProperty(o))&&(t[o]=r[o])}return t["default"]=r,h(t,"__useDefault",{value:!0}),t}function c(r,t){var n=p[r];if(n&&!n.evaluated&&n.declarative){t.push(r);for(var o=0,a=n.normalizedDeps.length;a>o;o++){var u=n.normalizedDeps[o];-1==v.call(t,u)&&(p[u]?c(u,t):f(u))}n.evaluated||(n.evaluated=!0,n.module.execute.call(e))}}function f(e){if(D[e])return D[e];if("@node/"==e.substr(0,6))return y(e.substr(6));var r=p[e];if(!r)throw"Module "+e+" not present.";return a(e),c(e,[]),p[e]=void 0,r.declarative&&h(r.module.exports,"__esModule",{value:!0}),D[e]=r.declarative?r.module.exports:r.esModule}var p={},v=Array.prototype.indexOf||function(e){for(var r=0,t=this.length;t>r;r++)if(this[r]===e)return r;return-1},g=!0;try{Object.getOwnPropertyDescriptor({a:0},"a")}catch(m){g=!1}var h;!function(){try{Object.defineProperty({},"a",{})&&(h=Object.defineProperty)}catch(e){h=function(e,r,t){try{e[r]=t.value||t.get.call(e)}catch(n){}}}}();var x={},y="undefined"!=typeof System&&System._nodeRequire||"undefined"!=typeof require&&require.resolve&&"undefined"!=typeof process&&require,D={"@empty":{}};return function(e,n,o){return function(a){a(function(a){for(var u={_nodeRequire:y,register:r,registerDynamic:t,get:f,set:function(e,r){D[e]=r},newModule:function(e){return e}},d=0;d<n.length;d++)(function(e,r){r&&r.__esModule?D[e]=r:D[e]=s(r)})(n[d],arguments[d]);o(u);var i=f(e[0]);if(e.length>1)for(var d=1;d<e.length;d++)f(e[d]);return i.__useDefault?i["default"]:i})}}}("undefined"!=typeof self?self:global)

(["1"], [], function($__System, require) {

!function(e){function n(e,n){e=e.replace(l,"");var r=e.match(u),t=(r[1].split(",")[n]||"require").replace(s,""),i=p[t]||(p[t]=new RegExp(a+t+f,"g"));i.lastIndex=0;for(var o,c=[];o=i.exec(e);)c.push(o[2]||o[3]);return c}function r(e,n,t,o){if("object"==typeof e&&!(e instanceof Array))return r.apply(null,Array.prototype.splice.call(arguments,1,arguments.length-1));if("string"==typeof e&&"function"==typeof n&&(e=[e]),!(e instanceof Array)){if("string"==typeof e){var l=i.get(e);return l.__useDefault?l["default"]:l}throw new TypeError("Invalid require")}for(var a=[],f=0;f<e.length;f++)a.push(i["import"](e[f],o));Promise.all(a).then(function(e){n&&n.apply(null,e)},t)}function t(t,l,a){"string"!=typeof t&&(a=l,l=t,t=null),l instanceof Array||(a=l,l=["require","exports","module"].splice(0,a.length)),"function"!=typeof a&&(a=function(e){return function(){return e}}(a)),void 0===l[l.length-1]&&l.pop();var f,u,s;-1!=(f=o.call(l,"require"))&&(l.splice(f,1),t||(l=l.concat(n(a.toString(),f)))),-1!=(u=o.call(l,"exports"))&&l.splice(u,1),-1!=(s=o.call(l,"module"))&&l.splice(s,1);var p={name:t,deps:l,execute:function(n,t,o){for(var p=[],c=0;c<l.length;c++)p.push(n(l[c]));o.uri=o.id,o.config=function(){},-1!=s&&p.splice(s,0,o),-1!=u&&p.splice(u,0,t),-1!=f&&p.splice(f,0,function(e,t,l){return"string"==typeof e&&"function"!=typeof t?n(e):r.call(i,e,t,l,o.id)});var d=a.apply(-1==u?e:t,p);return"undefined"==typeof d&&o&&(d=o.exports),"undefined"!=typeof d?d:void 0}};if(t)c.anonDefine||c.isBundle?c.anonDefine&&c.anonDefine.name&&(c.anonDefine=null):c.anonDefine=p,c.isBundle=!0,i.registerDynamic(p.name,p.deps,!1,p.execute);else{if(c.anonDefine&&!c.anonDefine.name)throw new Error("Multiple anonymous defines in module "+t);c.anonDefine=p}}var i=$__System,o=Array.prototype.indexOf||function(e){for(var n=0,r=this.length;r>n;n++)if(this[n]===e)return n;return-1},l=/(\/\*([\s\S]*?)\*\/|([^:]|^)\/\/(.*)$)/gm,a="(?:^|[^$_a-zA-Z\\xA0-\\uFFFF.])",f="\\s*\\(\\s*(\"([^\"]+)\"|'([^']+)')\\s*\\)",u=/\(([^\)]*)\)/,s=/^\s+|\s+$/g,p={};t.amd={};var c={isBundle:!1,anonDefine:null};i.amdDefine=t,i.amdRequire=r}("undefined"!=typeof self?self:global);
$__System.registerDynamic("2", ["4", "5", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireWildcard = $__require('4')["default"];
  exports.__esModule = true;
  var _babelTypes = $__require('5');
  var t = _interopRequireWildcard(_babelTypes);
  exports["default"] = function(ast, comments, tokens) {
    if (ast) {
      if (ast.type === "Program") {
        return t.file(ast, comments || [], tokens || []);
      } else if (ast.type === "File") {
        return ast;
      }
    }
    throw new Error("Not a valid ast?");
  };
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("6", ["9", "a", "2", "7", "8", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _classCallCheck = $__require('9')["default"];
  var _interopRequireDefault = $__require('a')["default"];
  exports.__esModule = true;
  var _helpersNormalizeAst = $__require('2');
  var _helpersNormalizeAst2 = _interopRequireDefault(_helpersNormalizeAst);
  var _plugin = $__require('7');
  var _plugin2 = _interopRequireDefault(_plugin);
  var _file = $__require('8');
  var _file2 = _interopRequireDefault(_file);
  var Pipeline = (function() {
    function Pipeline() {
      _classCallCheck(this, Pipeline);
    }
    Pipeline.prototype.lint = function lint(code) {
      var opts = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];
      opts.code = false;
      opts.mode = "lint";
      return this.transform(code, opts);
    };
    Pipeline.prototype.pretransform = function pretransform(code, opts) {
      var file = new _file2["default"](opts, this);
      return file.wrap(code, function() {
        file.addCode(code);
        file.parseCode(code);
        return file;
      });
    };
    Pipeline.prototype.transform = function transform(code, opts) {
      var file = new _file2["default"](opts, this);
      return file.wrap(code, function() {
        file.addCode(code);
        file.parseCode(code);
        return file.transform();
      });
    };
    Pipeline.prototype.analyse = function analyse(code, opts, visitor) {
      if (opts === undefined)
        opts = {};
      opts.code = false;
      if (visitor) {
        opts.plugins = opts.plugins || [];
        opts.plugins.push(new _plugin2["default"]({visitor: visitor}));
      }
      return this.transform(code, opts).metadata;
    };
    Pipeline.prototype.transformFromAst = function transformFromAst(ast, code, opts) {
      ast = _helpersNormalizeAst2["default"](ast);
      var file = new _file2["default"](opts, this);
      return file.wrap(code, function() {
        file.addCode(code);
        file.addAst(ast);
        return file.transform();
      });
    };
    return Pipeline;
  })();
  exports["default"] = Pipeline;
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("b", ["4", "5", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireWildcard = $__require('4')["default"];
  exports.__esModule = true;
  exports.ExportDeclaration = ExportDeclaration;
  exports.Scope = Scope;
  var _babelTypes = $__require('5');
  var t = _interopRequireWildcard(_babelTypes);
  var ModuleDeclaration = {enter: function enter(path, file) {
      var node = path.node;
      if (node.source) {
        node.source.value = file.resolveModuleSource(node.source.value);
      }
    }};
  exports.ModuleDeclaration = ModuleDeclaration;
  var ImportDeclaration = {exit: function exit(path, file) {
      var node = path.node;
      var specifiers = [];
      var imported = [];
      file.metadata.modules.imports.push({
        source: node.source.value,
        imported: imported,
        specifiers: specifiers
      });
      var _arr = path.get("specifiers");
      for (var _i = 0; _i < _arr.length; _i++) {
        var specifier = _arr[_i];
        var local = specifier.node.local.name;
        if (specifier.isImportDefaultSpecifier()) {
          imported.push("default");
          specifiers.push({
            kind: "named",
            imported: "default",
            local: local
          });
        }
        if (specifier.isImportSpecifier()) {
          var importedName = specifier.node.imported.name;
          imported.push(importedName);
          specifiers.push({
            kind: "named",
            imported: importedName,
            local: local
          });
        }
        if (specifier.isImportNamespaceSpecifier()) {
          imported.push("*");
          specifiers.push({
            kind: "namespace",
            local: local
          });
        }
      }
    }};
  exports.ImportDeclaration = ImportDeclaration;
  function ExportDeclaration(path, file) {
    var node = path.node;
    var source = node.source ? node.source.value : null;
    var exports = file.metadata.modules.exports;
    var declar = path.get("declaration");
    if (declar.isStatement()) {
      var bindings = declar.getBindingIdentifiers();
      for (var _name in bindings) {
        exports.exported.push(_name);
        exports.specifiers.push({
          kind: "local",
          local: _name,
          exported: path.isExportDefaultDeclaration() ? "default" : _name
        });
      }
    }
    if (path.isExportNamedDeclaration() && node.specifiers) {
      var _arr2 = node.specifiers;
      for (var _i2 = 0; _i2 < _arr2.length; _i2++) {
        var specifier = _arr2[_i2];
        var exported = specifier.exported.name;
        exports.exported.push(exported);
        if (t.isExportDefaultSpecifier(specifier)) {
          exports.specifiers.push({
            kind: "external",
            local: exported,
            exported: exported,
            source: source
          });
        }
        if (t.isExportNamespaceSpecifier(specifier)) {
          exports.specifiers.push({
            kind: "external-namespace",
            exported: exported,
            source: source
          });
        }
        var local = specifier.local;
        if (!local)
          continue;
        if (source) {
          exports.specifiers.push({
            kind: "external",
            local: local.name,
            exported: exported,
            source: source
          });
        }
        if (!source) {
          exports.specifiers.push({
            kind: "local",
            local: local.name,
            exported: exported
          });
        }
      }
    }
    if (path.isExportAllDeclaration()) {
      exports.specifiers.push({
        kind: "external-all",
        source: source
      });
    }
  }
  function Scope(path) {
    path.skip();
  }
  return module.exports;
});

$__System.registerDynamic("c", ["@node/fs", "@node/path", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var fs = $__require('@node/fs');
  var path = $__require('@node/path');
  var commentRx = /^\s*\/(?:\/|\*)[@#]\s+sourceMappingURL=data:(?:application|text)\/json;(?:charset[:=]\S+;)?base64,(.*)$/mg;
  var mapFileCommentRx = /(?:\/\/[@#][ \t]+sourceMappingURL=([^\s'"]+?)[ \t]*$)|(?:\/\*[@#][ \t]+sourceMappingURL=([^\*]+?)[ \t]*(?:\*\/){1}[ \t]*$)/mg;
  function decodeBase64(base64) {
    return new Buffer(base64, 'base64').toString();
  }
  function stripComment(sm) {
    return sm.split(',').pop();
  }
  function readFromFileMap(sm, dir) {
    var r = mapFileCommentRx.exec(sm);
    mapFileCommentRx.lastIndex = 0;
    var filename = r[1] || r[2];
    var filepath = path.join(dir, filename);
    try {
      return fs.readFileSync(filepath, 'utf8');
    } catch (e) {
      throw new Error('An error occurred while trying to read the map file at ' + filepath + '\n' + e);
    }
  }
  function Converter(sm, opts) {
    opts = opts || {};
    if (opts.isFileComment)
      sm = readFromFileMap(sm, opts.commentFileDir);
    if (opts.hasComment)
      sm = stripComment(sm);
    if (opts.isEncoded)
      sm = decodeBase64(sm);
    if (opts.isJSON || opts.isEncoded)
      sm = JSON.parse(sm);
    this.sourcemap = sm;
  }
  function convertFromLargeSource(content) {
    var lines = content.split('\n');
    var line;
    for (var i = lines.length - 1; i > 0; i--) {
      line = lines[i];
      if (~line.indexOf('sourceMappingURL=data:'))
        return exports.fromComment(line);
    }
  }
  Converter.prototype.toJSON = function(space) {
    return JSON.stringify(this.sourcemap, null, space);
  };
  Converter.prototype.toBase64 = function() {
    var json = this.toJSON();
    return new Buffer(json).toString('base64');
  };
  Converter.prototype.toComment = function(options) {
    var base64 = this.toBase64();
    var data = 'sourceMappingURL=data:application/json;base64,' + base64;
    return options && options.multiline ? '/*# ' + data + ' */' : '//# ' + data;
  };
  Converter.prototype.toObject = function() {
    return JSON.parse(this.toJSON());
  };
  Converter.prototype.addProperty = function(key, value) {
    if (this.sourcemap.hasOwnProperty(key))
      throw new Error('property %s already exists on the sourcemap, use set property instead');
    return this.setProperty(key, value);
  };
  Converter.prototype.setProperty = function(key, value) {
    this.sourcemap[key] = value;
    return this;
  };
  Converter.prototype.getProperty = function(key) {
    return this.sourcemap[key];
  };
  exports.fromObject = function(obj) {
    return new Converter(obj);
  };
  exports.fromJSON = function(json) {
    return new Converter(json, {isJSON: true});
  };
  exports.fromBase64 = function(base64) {
    return new Converter(base64, {isEncoded: true});
  };
  exports.fromComment = function(comment) {
    comment = comment.replace(/^\/\*/g, '//').replace(/\*\/$/g, '');
    return new Converter(comment, {
      isEncoded: true,
      hasComment: true
    });
  };
  exports.fromMapFileComment = function(comment, dir) {
    return new Converter(comment, {
      commentFileDir: dir,
      isFileComment: true,
      isJSON: true
    });
  };
  exports.fromSource = function(content, largeSource) {
    if (largeSource) {
      var res = convertFromLargeSource(content);
      return res ? res : null;
    }
    var m = content.match(commentRx);
    commentRx.lastIndex = 0;
    return m ? exports.fromComment(m.pop()) : null;
  };
  exports.fromMapFileSource = function(content, dir) {
    var m = content.match(mapFileCommentRx);
    mapFileCommentRx.lastIndex = 0;
    return m ? exports.fromMapFileComment(m.pop(), dir) : null;
  };
  exports.removeComments = function(src) {
    commentRx.lastIndex = 0;
    return src.replace(commentRx, '');
  };
  exports.removeMapFileComments = function(src) {
    mapFileCommentRx.lastIndex = 0;
    return src.replace(mapFileCommentRx, '');
  };
  exports.generateMapFileComment = function(file, options) {
    var data = 'sourceMappingURL=' + file;
    return options && options.multiline ? '/*# ' + data + ' */' : '//# ' + data;
  };
  Object.defineProperty(exports, 'commentRegex', {get: function getCommentRegex() {
      commentRx.lastIndex = 0;
      return commentRx;
    }});
  Object.defineProperty(exports, 'mapFileCommentRegex', {get: function getMapFileCommentRegex() {
      mapFileCommentRx.lastIndex = 0;
      return mapFileCommentRx;
    }});
  return module.exports;
});

$__System.registerDynamic("d", ["f", "9", "a", "e", "10", "8", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _inherits = $__require('f')["default"];
  var _classCallCheck = $__require('9')["default"];
  var _interopRequireDefault = $__require('a')["default"];
  exports.__esModule = true;
  var _store = $__require('e');
  var _store2 = _interopRequireDefault(_store);
  var _babelTraverse = $__require('10');
  var _babelTraverse2 = _interopRequireDefault(_babelTraverse);
  var _file5 = $__require('8');
  var _file6 = _interopRequireDefault(_file5);
  var PluginPass = (function(_Store) {
    _inherits(PluginPass, _Store);
    function PluginPass(file, plugin) {
      var options = arguments.length <= 2 || arguments[2] === undefined ? {} : arguments[2];
      _classCallCheck(this, PluginPass);
      _Store.call(this);
      this.plugin = plugin;
      this.file = file;
      this.opts = options;
    }
    PluginPass.prototype.transform = function transform() {
      var file = this.file;
      file.log.debug("Start transformer " + this.key);
      _babelTraverse2["default"](file.ast, this.plugin.visitor, file.scope, file);
      file.log.debug("Finish transformer " + this.key);
    };
    PluginPass.prototype.addHelper = function addHelper() {
      var _file;
      return (_file = this.file).addHelper.apply(_file, arguments);
    };
    PluginPass.prototype.addImport = function addImport() {
      var _file2;
      return (_file2 = this.file).addImport.apply(_file2, arguments);
    };
    PluginPass.prototype.getModuleName = function getModuleName() {
      var _file3;
      return (_file3 = this.file).getModuleName.apply(_file3, arguments);
    };
    PluginPass.prototype.buildCodeFrameError = function buildCodeFrameError() {
      var _file4;
      return (_file4 = this.file).buildCodeFrameError.apply(_file4, arguments);
    };
    return PluginPass;
  })(_store2["default"]);
  exports["default"] = PluginPass;
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("11", ["3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  module.exports = /^#!.*/;
  return module.exports;
});

$__System.registerDynamic("12", ["9", "a", "13", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _classCallCheck = $__require('9')["default"];
  var _interopRequireDefault = $__require('a')["default"];
  exports.__esModule = true;
  var _debugNode = $__require('13');
  var _debugNode2 = _interopRequireDefault(_debugNode);
  var verboseDebug = _debugNode2["default"]("babel:verbose");
  var generalDebug = _debugNode2["default"]("babel");
  var seenDeprecatedMessages = [];
  var Logger = (function() {
    function Logger(file, filename) {
      _classCallCheck(this, Logger);
      this.filename = filename;
      this.file = file;
    }
    Logger.prototype._buildMessage = function _buildMessage(msg) {
      var parts = "[BABEL] " + this.filename;
      if (msg)
        parts += ": " + msg;
      return parts;
    };
    Logger.prototype.warn = function warn(msg) {
      console.warn(this._buildMessage(msg));
    };
    Logger.prototype.error = function error(msg) {
      var Constructor = arguments.length <= 1 || arguments[1] === undefined ? Error : arguments[1];
      throw new Constructor(this._buildMessage(msg));
    };
    Logger.prototype.deprecate = function deprecate(msg) {
      if (this.file.opts && this.file.opts.suppressDeprecationMessages)
        return;
      msg = this._buildMessage(msg);
      if (seenDeprecatedMessages.indexOf(msg) >= 0)
        return;
      seenDeprecatedMessages.push(msg);
      console.error(msg);
    };
    Logger.prototype.verbose = function verbose(msg) {
      if (verboseDebug.enabled)
        verboseDebug(this._buildMessage(msg));
    };
    Logger.prototype.debug = function debug(msg) {
      if (generalDebug.enabled)
        generalDebug(this._buildMessage(msg));
    };
    Logger.prototype.deopt = function deopt(node, msg) {
      this.debug(msg);
    };
    return Logger;
  })();
  exports["default"] = Logger;
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("14", ["3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  function baseSortBy(array, comparer) {
    var length = array.length;
    array.sort(comparer);
    while (length--) {
      array[length] = array[length].value;
    }
    return array;
  }
  module.exports = baseSortBy;
  return module.exports;
});

$__System.registerDynamic("15", ["3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  function baseCompareAscending(value, other) {
    if (value !== other) {
      var valIsNull = value === null,
          valIsUndef = value === undefined,
          valIsReflexive = value === value;
      var othIsNull = other === null,
          othIsUndef = other === undefined,
          othIsReflexive = other === other;
      if ((value > other && !othIsNull) || !valIsReflexive || (valIsNull && !othIsUndef && othIsReflexive) || (valIsUndef && othIsReflexive)) {
        return 1;
      }
      if ((value < other && !valIsNull) || !othIsReflexive || (othIsNull && !valIsUndef && valIsReflexive) || (othIsUndef && valIsReflexive)) {
        return -1;
      }
    }
    return 0;
  }
  module.exports = baseCompareAscending;
  return module.exports;
});

$__System.registerDynamic("16", ["15", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var baseCompareAscending = $__require('15');
  function compareAscending(object, other) {
    return baseCompareAscending(object.criteria, other.criteria) || (object.index - other.index);
  }
  module.exports = compareAscending;
  return module.exports;
});

$__System.registerDynamic("17", ["18", "19", "14", "16", "1a", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var baseCallback = $__require('18'),
      baseMap = $__require('19'),
      baseSortBy = $__require('14'),
      compareAscending = $__require('16'),
      isIterateeCall = $__require('1a');
  function sortBy(collection, iteratee, thisArg) {
    if (collection == null) {
      return [];
    }
    if (thisArg && isIterateeCall(collection, iteratee, thisArg)) {
      iteratee = undefined;
    }
    var index = -1;
    iteratee = baseCallback(iteratee, thisArg, 3);
    var result = baseMap(collection, function(value, key, collection) {
      return {
        'criteria': iteratee(value, key, collection),
        'index': ++index,
        'value': value
      };
    });
    return baseSortBy(result, compareAscending);
  }
  module.exports = sortBy;
  return module.exports;
});

$__System.registerDynamic("1b", ["a", "7", "17", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireDefault = $__require('a')["default"];
  exports.__esModule = true;
  var _plugin = $__require('7');
  var _plugin2 = _interopRequireDefault(_plugin);
  var _lodashCollectionSortBy = $__require('17');
  var _lodashCollectionSortBy2 = _interopRequireDefault(_lodashCollectionSortBy);
  exports["default"] = new _plugin2["default"]({visitor: {Block: {exit: function exit(_ref) {
          var node = _ref.node;
          var hasChange = false;
          for (var i = 0; i < node.body.length; i++) {
            var bodyNode = node.body[i];
            if (bodyNode && bodyNode._blockHoist != null) {
              hasChange = true;
              break;
            }
          }
          if (!hasChange)
            return;
          node.body = _lodashCollectionSortBy2["default"](node.body, function(bodyNode) {
            var priority = bodyNode && bodyNode._blockHoist;
            if (priority == null)
              priority = 1;
            if (priority === true)
              priority = 2;
            return -1 * priority;
          });
        }}}});
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("1c", ["3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var regexpEscapes = {
    '0': 'x30',
    '1': 'x31',
    '2': 'x32',
    '3': 'x33',
    '4': 'x34',
    '5': 'x35',
    '6': 'x36',
    '7': 'x37',
    '8': 'x38',
    '9': 'x39',
    'A': 'x41',
    'B': 'x42',
    'C': 'x43',
    'D': 'x44',
    'E': 'x45',
    'F': 'x46',
    'a': 'x61',
    'b': 'x62',
    'c': 'x63',
    'd': 'x64',
    'e': 'x65',
    'f': 'x66',
    'n': 'x6e',
    'r': 'x72',
    't': 'x74',
    'u': 'x75',
    'v': 'x76',
    'x': 'x78'
  };
  var stringEscapes = {
    '\\': '\\',
    "'": "'",
    '\n': 'n',
    '\r': 'r',
    '\u2028': 'u2028',
    '\u2029': 'u2029'
  };
  function escapeRegExpChar(chr, leadingChar, whitespaceChar) {
    if (leadingChar) {
      chr = regexpEscapes[chr];
    } else if (whitespaceChar) {
      chr = stringEscapes[chr];
    }
    return '\\' + chr;
  }
  module.exports = escapeRegExpChar;
  return module.exports;
});

$__System.registerDynamic("1d", ["1e", "1c", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var baseToString = $__require('1e'),
      escapeRegExpChar = $__require('1c');
  var reRegExpChars = /^[:!,]|[\\^$.*+?()[\]{}|\/]|(^[0-9a-fA-Fnrtuvx])|([\n\r\u2028\u2029])/g,
      reHasRegExpChars = RegExp(reRegExpChars.source);
  function escapeRegExp(string) {
    string = baseToString(string);
    return (string && reHasRegExpChars.test(string)) ? string.replace(reRegExpChars, escapeRegExpChar) : (string || '(?:)');
  }
  module.exports = escapeRegExp;
  return module.exports;
});

$__System.registerDynamic("1f", ["1e", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var baseToString = $__require('1e');
  var nativeMin = Math.min;
  function startsWith(string, target, position) {
    string = baseToString(string);
    position = position == null ? 0 : nativeMin(position < 0 ? 0 : (+position || 0), string.length);
    return string.lastIndexOf(target, position) == position;
  }
  module.exports = startsWith;
  return module.exports;
});

$__System.registerDynamic("20", ["3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  module.exports = function(xs, fn) {
    var res = [];
    for (var i = 0; i < xs.length; i++) {
      var x = fn(xs[i], i);
      if (isArray(x))
        res.push.apply(res, x);
      else
        res.push(x);
    }
    return res;
  };
  var isArray = Array.isArray || function(xs) {
    return Object.prototype.toString.call(xs) === '[object Array]';
  };
  return module.exports;
});

$__System.registerDynamic("21", ["3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  module.exports = balanced;
  function balanced(a, b, str) {
    var r = range(a, b, str);
    return r && {
      start: r[0],
      end: r[1],
      pre: str.slice(0, r[0]),
      body: str.slice(r[0] + a.length, r[1]),
      post: str.slice(r[1] + b.length)
    };
  }
  balanced.range = range;
  function range(a, b, str) {
    var begs,
        beg,
        left,
        right,
        result;
    var ai = str.indexOf(a);
    var bi = str.indexOf(b, ai + 1);
    var i = ai;
    if (ai >= 0 && bi > 0) {
      begs = [];
      left = str.length;
      while (i < str.length && i >= 0 && !result) {
        if (i == ai) {
          begs.push(i);
          ai = str.indexOf(a, i + 1);
        } else if (begs.length == 1) {
          result = [begs.pop(), bi];
        } else {
          beg = begs.pop();
          if (beg < left) {
            left = beg;
            right = bi;
          }
          bi = str.indexOf(b, i + 1);
        }
        i = ai < bi && ai >= 0 ? ai : bi;
      }
      if (begs.length) {
        result = [left, right];
      }
    }
    return result;
  }
  return module.exports;
});

$__System.registerDynamic("22", ["20", "21", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var concatMap = $__require('20');
  var balanced = $__require('21');
  module.exports = expandTop;
  var escSlash = '\0SLASH' + Math.random() + '\0';
  var escOpen = '\0OPEN' + Math.random() + '\0';
  var escClose = '\0CLOSE' + Math.random() + '\0';
  var escComma = '\0COMMA' + Math.random() + '\0';
  var escPeriod = '\0PERIOD' + Math.random() + '\0';
  function numeric(str) {
    return parseInt(str, 10) == str ? parseInt(str, 10) : str.charCodeAt(0);
  }
  function escapeBraces(str) {
    return str.split('\\\\').join(escSlash).split('\\{').join(escOpen).split('\\}').join(escClose).split('\\,').join(escComma).split('\\.').join(escPeriod);
  }
  function unescapeBraces(str) {
    return str.split(escSlash).join('\\').split(escOpen).join('{').split(escClose).join('}').split(escComma).join(',').split(escPeriod).join('.');
  }
  function parseCommaParts(str) {
    if (!str)
      return [''];
    var parts = [];
    var m = balanced('{', '}', str);
    if (!m)
      return str.split(',');
    var pre = m.pre;
    var body = m.body;
    var post = m.post;
    var p = pre.split(',');
    p[p.length - 1] += '{' + body + '}';
    var postParts = parseCommaParts(post);
    if (post.length) {
      p[p.length - 1] += postParts.shift();
      p.push.apply(p, postParts);
    }
    parts.push.apply(parts, p);
    return parts;
  }
  function expandTop(str) {
    if (!str)
      return [];
    return expand(escapeBraces(str), true).map(unescapeBraces);
  }
  function identity(e) {
    return e;
  }
  function embrace(str) {
    return '{' + str + '}';
  }
  function isPadded(el) {
    return /^-?0\d/.test(el);
  }
  function lte(i, y) {
    return i <= y;
  }
  function gte(i, y) {
    return i >= y;
  }
  function expand(str, isTop) {
    var expansions = [];
    var m = balanced('{', '}', str);
    if (!m || /\$$/.test(m.pre))
      return [str];
    var isNumericSequence = /^-?\d+\.\.-?\d+(?:\.\.-?\d+)?$/.test(m.body);
    var isAlphaSequence = /^[a-zA-Z]\.\.[a-zA-Z](?:\.\.-?\d+)?$/.test(m.body);
    var isSequence = isNumericSequence || isAlphaSequence;
    var isOptions = /^(.*,)+(.+)?$/.test(m.body);
    if (!isSequence && !isOptions) {
      if (m.post.match(/,.*\}/)) {
        str = m.pre + '{' + m.body + escClose + m.post;
        return expand(str);
      }
      return [str];
    }
    var n;
    if (isSequence) {
      n = m.body.split(/\.\./);
    } else {
      n = parseCommaParts(m.body);
      if (n.length === 1) {
        n = expand(n[0], false).map(embrace);
        if (n.length === 1) {
          var post = m.post.length ? expand(m.post, false) : [''];
          return post.map(function(p) {
            return m.pre + n[0] + p;
          });
        }
      }
    }
    var pre = m.pre;
    var post = m.post.length ? expand(m.post, false) : [''];
    var N;
    if (isSequence) {
      var x = numeric(n[0]);
      var y = numeric(n[1]);
      var width = Math.max(n[0].length, n[1].length);
      var incr = n.length == 3 ? Math.abs(numeric(n[2])) : 1;
      var test = lte;
      var reverse = y < x;
      if (reverse) {
        incr *= -1;
        test = gte;
      }
      var pad = n.some(isPadded);
      N = [];
      for (var i = x; test(i, y); i += incr) {
        var c;
        if (isAlphaSequence) {
          c = String.fromCharCode(i);
          if (c === '\\')
            c = '';
        } else {
          c = String(i);
          if (pad) {
            var need = width - c.length;
            if (need > 0) {
              var z = new Array(need + 1).join('0');
              if (i < 0)
                c = '-' + z + c.slice(1);
              else
                c = z + c;
            }
          }
        }
        N.push(c);
      }
    } else {
      N = concatMap(n, function(el) {
        return expand(el, false);
      });
    }
    for (var j = 0; j < N.length; j++) {
      for (var k = 0; k < post.length; k++) {
        var expansion = pre + N[j] + post[k];
        if (!isTop || isSequence || expansion)
          expansions.push(expansion);
      }
    }
    return expansions;
  }
  return module.exports;
});

$__System.registerDynamic("23", ["@node/path", "22", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  module.exports = minimatch;
  minimatch.Minimatch = Minimatch;
  var path = {sep: '/'};
  try {
    path = $__require('@node/path');
  } catch (er) {}
  var GLOBSTAR = minimatch.GLOBSTAR = Minimatch.GLOBSTAR = {};
  var expand = $__require('22');
  var qmark = '[^/]';
  var star = qmark + '*?';
  var twoStarDot = '(?:(?!(?:\\\/|^)(?:\\.{1,2})($|\\\/)).)*?';
  var twoStarNoDot = '(?:(?!(?:\\\/|^)\\.).)*?';
  var reSpecials = charSet('().*{}+?[]^$\\!');
  function charSet(s) {
    return s.split('').reduce(function(set, c) {
      set[c] = true;
      return set;
    }, {});
  }
  var slashSplit = /\/+/;
  minimatch.filter = filter;
  function filter(pattern, options) {
    options = options || {};
    return function(p, i, list) {
      return minimatch(p, pattern, options);
    };
  }
  function ext(a, b) {
    a = a || {};
    b = b || {};
    var t = {};
    Object.keys(b).forEach(function(k) {
      t[k] = b[k];
    });
    Object.keys(a).forEach(function(k) {
      t[k] = a[k];
    });
    return t;
  }
  minimatch.defaults = function(def) {
    if (!def || !Object.keys(def).length)
      return minimatch;
    var orig = minimatch;
    var m = function minimatch(p, pattern, options) {
      return orig.minimatch(p, pattern, ext(def, options));
    };
    m.Minimatch = function Minimatch(pattern, options) {
      return new orig.Minimatch(pattern, ext(def, options));
    };
    return m;
  };
  Minimatch.defaults = function(def) {
    if (!def || !Object.keys(def).length)
      return Minimatch;
    return minimatch.defaults(def).Minimatch;
  };
  function minimatch(p, pattern, options) {
    if (typeof pattern !== 'string') {
      throw new TypeError('glob pattern string required');
    }
    if (!options)
      options = {};
    if (!options.nocomment && pattern.charAt(0) === '#') {
      return false;
    }
    if (pattern.trim() === '')
      return p === '';
    return new Minimatch(pattern, options).match(p);
  }
  function Minimatch(pattern, options) {
    if (!(this instanceof Minimatch)) {
      return new Minimatch(pattern, options);
    }
    if (typeof pattern !== 'string') {
      throw new TypeError('glob pattern string required');
    }
    if (!options)
      options = {};
    pattern = pattern.trim();
    if (path.sep !== '/') {
      pattern = pattern.split(path.sep).join('/');
    }
    this.options = options;
    this.set = [];
    this.pattern = pattern;
    this.regexp = null;
    this.negate = false;
    this.comment = false;
    this.empty = false;
    this.make();
  }
  Minimatch.prototype.debug = function() {};
  Minimatch.prototype.make = make;
  function make() {
    if (this._made)
      return;
    var pattern = this.pattern;
    var options = this.options;
    if (!options.nocomment && pattern.charAt(0) === '#') {
      this.comment = true;
      return;
    }
    if (!pattern) {
      this.empty = true;
      return;
    }
    this.parseNegate();
    var set = this.globSet = this.braceExpand();
    if (options.debug)
      this.debug = console.error;
    this.debug(this.pattern, set);
    set = this.globParts = set.map(function(s) {
      return s.split(slashSplit);
    });
    this.debug(this.pattern, set);
    set = set.map(function(s, si, set) {
      return s.map(this.parse, this);
    }, this);
    this.debug(this.pattern, set);
    set = set.filter(function(s) {
      return s.indexOf(false) === -1;
    });
    this.debug(this.pattern, set);
    this.set = set;
  }
  Minimatch.prototype.parseNegate = parseNegate;
  function parseNegate() {
    var pattern = this.pattern;
    var negate = false;
    var options = this.options;
    var negateOffset = 0;
    if (options.nonegate)
      return;
    for (var i = 0,
        l = pattern.length; i < l && pattern.charAt(i) === '!'; i++) {
      negate = !negate;
      negateOffset++;
    }
    if (negateOffset)
      this.pattern = pattern.substr(negateOffset);
    this.negate = negate;
  }
  minimatch.braceExpand = function(pattern, options) {
    return braceExpand(pattern, options);
  };
  Minimatch.prototype.braceExpand = braceExpand;
  function braceExpand(pattern, options) {
    if (!options) {
      if (this instanceof Minimatch) {
        options = this.options;
      } else {
        options = {};
      }
    }
    pattern = typeof pattern === 'undefined' ? this.pattern : pattern;
    if (typeof pattern === 'undefined') {
      throw new Error('undefined pattern');
    }
    if (options.nobrace || !pattern.match(/\{.*\}/)) {
      return [pattern];
    }
    return expand(pattern);
  }
  Minimatch.prototype.parse = parse;
  var SUBPARSE = {};
  function parse(pattern, isSub) {
    var options = this.options;
    if (!options.noglobstar && pattern === '**')
      return GLOBSTAR;
    if (pattern === '')
      return '';
    var re = '';
    var hasMagic = !!options.nocase;
    var escaping = false;
    var patternListStack = [];
    var negativeLists = [];
    var plType;
    var stateChar;
    var inClass = false;
    var reClassStart = -1;
    var classStart = -1;
    var patternStart = pattern.charAt(0) === '.' ? '' : options.dot ? '(?!(?:^|\\\/)\\.{1,2}(?:$|\\\/))' : '(?!\\.)';
    var self = this;
    function clearStateChar() {
      if (stateChar) {
        switch (stateChar) {
          case '*':
            re += star;
            hasMagic = true;
            break;
          case '?':
            re += qmark;
            hasMagic = true;
            break;
          default:
            re += '\\' + stateChar;
            break;
        }
        self.debug('clearStateChar %j %j', stateChar, re);
        stateChar = false;
      }
    }
    for (var i = 0,
        len = pattern.length,
        c; (i < len) && (c = pattern.charAt(i)); i++) {
      this.debug('%s\t%s %s %j', pattern, i, re, c);
      if (escaping && reSpecials[c]) {
        re += '\\' + c;
        escaping = false;
        continue;
      }
      switch (c) {
        case '/':
          return false;
        case '\\':
          clearStateChar();
          escaping = true;
          continue;
        case '?':
        case '*':
        case '+':
        case '@':
        case '!':
          this.debug('%s\t%s %s %j <-- stateChar', pattern, i, re, c);
          if (inClass) {
            this.debug('  in class');
            if (c === '!' && i === classStart + 1)
              c = '^';
            re += c;
            continue;
          }
          self.debug('call clearStateChar %j', stateChar);
          clearStateChar();
          stateChar = c;
          if (options.noext)
            clearStateChar();
          continue;
        case '(':
          if (inClass) {
            re += '(';
            continue;
          }
          if (!stateChar) {
            re += '\\(';
            continue;
          }
          plType = stateChar;
          patternListStack.push({
            type: plType,
            start: i - 1,
            reStart: re.length
          });
          re += stateChar === '!' ? '(?:(?!(?:' : '(?:';
          this.debug('plType %j %j', stateChar, re);
          stateChar = false;
          continue;
        case ')':
          if (inClass || !patternListStack.length) {
            re += '\\)';
            continue;
          }
          clearStateChar();
          hasMagic = true;
          re += ')';
          var pl = patternListStack.pop();
          plType = pl.type;
          switch (plType) {
            case '!':
              negativeLists.push(pl);
              re += ')[^/]*?)';
              pl.reEnd = re.length;
              break;
            case '?':
            case '+':
            case '*':
              re += plType;
              break;
            case '@':
              break;
          }
          continue;
        case '|':
          if (inClass || !patternListStack.length || escaping) {
            re += '\\|';
            escaping = false;
            continue;
          }
          clearStateChar();
          re += '|';
          continue;
        case '[':
          clearStateChar();
          if (inClass) {
            re += '\\' + c;
            continue;
          }
          inClass = true;
          classStart = i;
          reClassStart = re.length;
          re += c;
          continue;
        case ']':
          if (i === classStart + 1 || !inClass) {
            re += '\\' + c;
            escaping = false;
            continue;
          }
          if (inClass) {
            var cs = pattern.substring(classStart + 1, i);
            try {
              RegExp('[' + cs + ']');
            } catch (er) {
              var sp = this.parse(cs, SUBPARSE);
              re = re.substr(0, reClassStart) + '\\[' + sp[0] + '\\]';
              hasMagic = hasMagic || sp[1];
              inClass = false;
              continue;
            }
          }
          hasMagic = true;
          inClass = false;
          re += c;
          continue;
        default:
          clearStateChar();
          if (escaping) {
            escaping = false;
          } else if (reSpecials[c] && !(c === '^' && inClass)) {
            re += '\\';
          }
          re += c;
      }
    }
    if (inClass) {
      cs = pattern.substr(classStart + 1);
      sp = this.parse(cs, SUBPARSE);
      re = re.substr(0, reClassStart) + '\\[' + sp[0];
      hasMagic = hasMagic || sp[1];
    }
    for (pl = patternListStack.pop(); pl; pl = patternListStack.pop()) {
      var tail = re.slice(pl.reStart + 3);
      tail = tail.replace(/((?:\\{2})*)(\\?)\|/g, function(_, $1, $2) {
        if (!$2) {
          $2 = '\\';
        }
        return $1 + $1 + $2 + '|';
      });
      this.debug('tail=%j\n   %s', tail, tail);
      var t = pl.type === '*' ? star : pl.type === '?' ? qmark : '\\' + pl.type;
      hasMagic = true;
      re = re.slice(0, pl.reStart) + t + '\\(' + tail;
    }
    clearStateChar();
    if (escaping) {
      re += '\\\\';
    }
    var addPatternStart = false;
    switch (re.charAt(0)) {
      case '.':
      case '[':
      case '(':
        addPatternStart = true;
    }
    for (var n = negativeLists.length - 1; n > -1; n--) {
      var nl = negativeLists[n];
      var nlBefore = re.slice(0, nl.reStart);
      var nlFirst = re.slice(nl.reStart, nl.reEnd - 8);
      var nlLast = re.slice(nl.reEnd - 8, nl.reEnd);
      var nlAfter = re.slice(nl.reEnd);
      nlLast += nlAfter;
      var openParensBefore = nlBefore.split('(').length - 1;
      var cleanAfter = nlAfter;
      for (i = 0; i < openParensBefore; i++) {
        cleanAfter = cleanAfter.replace(/\)[+*?]?/, '');
      }
      nlAfter = cleanAfter;
      var dollar = '';
      if (nlAfter === '' && isSub !== SUBPARSE) {
        dollar = '$';
      }
      var newRe = nlBefore + nlFirst + nlAfter + dollar + nlLast;
      re = newRe;
    }
    if (re !== '' && hasMagic) {
      re = '(?=.)' + re;
    }
    if (addPatternStart) {
      re = patternStart + re;
    }
    if (isSub === SUBPARSE) {
      return [re, hasMagic];
    }
    if (!hasMagic) {
      return globUnescape(pattern);
    }
    var flags = options.nocase ? 'i' : '';
    var regExp = new RegExp('^' + re + '$', flags);
    regExp._glob = pattern;
    regExp._src = re;
    return regExp;
  }
  minimatch.makeRe = function(pattern, options) {
    return new Minimatch(pattern, options || {}).makeRe();
  };
  Minimatch.prototype.makeRe = makeRe;
  function makeRe() {
    if (this.regexp || this.regexp === false)
      return this.regexp;
    var set = this.set;
    if (!set.length) {
      this.regexp = false;
      return this.regexp;
    }
    var options = this.options;
    var twoStar = options.noglobstar ? star : options.dot ? twoStarDot : twoStarNoDot;
    var flags = options.nocase ? 'i' : '';
    var re = set.map(function(pattern) {
      return pattern.map(function(p) {
        return (p === GLOBSTAR) ? twoStar : (typeof p === 'string') ? regExpEscape(p) : p._src;
      }).join('\\\/');
    }).join('|');
    re = '^(?:' + re + ')$';
    if (this.negate)
      re = '^(?!' + re + ').*$';
    try {
      this.regexp = new RegExp(re, flags);
    } catch (ex) {
      this.regexp = false;
    }
    return this.regexp;
  }
  minimatch.match = function(list, pattern, options) {
    options = options || {};
    var mm = new Minimatch(pattern, options);
    list = list.filter(function(f) {
      return mm.match(f);
    });
    if (mm.options.nonull && !list.length) {
      list.push(pattern);
    }
    return list;
  };
  Minimatch.prototype.match = match;
  function match(f, partial) {
    this.debug('match', f, this.pattern);
    if (this.comment)
      return false;
    if (this.empty)
      return f === '';
    if (f === '/' && partial)
      return true;
    var options = this.options;
    if (path.sep !== '/') {
      f = f.split(path.sep).join('/');
    }
    f = f.split(slashSplit);
    this.debug(this.pattern, 'split', f);
    var set = this.set;
    this.debug(this.pattern, 'set', set);
    var filename;
    var i;
    for (i = f.length - 1; i >= 0; i--) {
      filename = f[i];
      if (filename)
        break;
    }
    for (i = 0; i < set.length; i++) {
      var pattern = set[i];
      var file = f;
      if (options.matchBase && pattern.length === 1) {
        file = [filename];
      }
      var hit = this.matchOne(file, pattern, partial);
      if (hit) {
        if (options.flipNegate)
          return true;
        return !this.negate;
      }
    }
    if (options.flipNegate)
      return false;
    return this.negate;
  }
  Minimatch.prototype.matchOne = function(file, pattern, partial) {
    var options = this.options;
    this.debug('matchOne', {
      'this': this,
      file: file,
      pattern: pattern
    });
    this.debug('matchOne', file.length, pattern.length);
    for (var fi = 0,
        pi = 0,
        fl = file.length,
        pl = pattern.length; (fi < fl) && (pi < pl); fi++, pi++) {
      this.debug('matchOne loop');
      var p = pattern[pi];
      var f = file[fi];
      this.debug(pattern, p, f);
      if (p === false)
        return false;
      if (p === GLOBSTAR) {
        this.debug('GLOBSTAR', [pattern, p, f]);
        var fr = fi;
        var pr = pi + 1;
        if (pr === pl) {
          this.debug('** at the end');
          for (; fi < fl; fi++) {
            if (file[fi] === '.' || file[fi] === '..' || (!options.dot && file[fi].charAt(0) === '.'))
              return false;
          }
          return true;
        }
        while (fr < fl) {
          var swallowee = file[fr];
          this.debug('\nglobstar while', file, fr, pattern, pr, swallowee);
          if (this.matchOne(file.slice(fr), pattern.slice(pr), partial)) {
            this.debug('globstar found match!', fr, fl, swallowee);
            return true;
          } else {
            if (swallowee === '.' || swallowee === '..' || (!options.dot && swallowee.charAt(0) === '.')) {
              this.debug('dot detected!', file, fr, pattern, pr);
              break;
            }
            this.debug('globstar swallow a segment, and continue');
            fr++;
          }
        }
        if (partial) {
          this.debug('\n>>> no match, partial?', file, fr, pattern, pr);
          if (fr === fl)
            return true;
        }
        return false;
      }
      var hit;
      if (typeof p === 'string') {
        if (options.nocase) {
          hit = f.toLowerCase() === p.toLowerCase();
        } else {
          hit = f === p;
        }
        this.debug('string match', p, f, hit);
      } else {
        hit = f.match(p);
        this.debug('pattern match', p, f, hit);
      }
      if (!hit)
        return false;
    }
    if (fi === fl && pi === pl) {
      return true;
    } else if (fi === fl) {
      return partial;
    } else if (pi === pl) {
      var emptyFileEnd = (fi === fl - 1) && (file[fi] === '');
      return emptyFileEnd;
    }
    throw new Error('wtf?');
  };
  function globUnescape(s) {
    return s.replace(/\\(.)/g, '$1');
  }
  function regExpEscape(s) {
    return s.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, '\\$&');
  }
  return module.exports;
});

$__System.registerDynamic("24", ["25", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  module.exports = $__require('25');
  return module.exports;
});

$__System.registerDynamic("26", ["3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  module.exports = function(str) {
    var isExtendedLengthPath = /^\\\\\?\\/.test(str);
    var hasNonAscii = /[^\x00-\x80]+/.test(str);
    if (isExtendedLengthPath || hasNonAscii) {
      return str;
    }
    return str.replace(/\\/g, '/');
  };
  return module.exports;
});

$__System.registerDynamic("27", ["a", "1d", "1f", "28", "23", "24", "29", "2a", "@node/path", "26", "@node/util", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireDefault = $__require('a')["default"];
  exports.__esModule = true;
  exports.canCompile = canCompile;
  exports.list = list;
  exports.regexify = regexify;
  exports.arrayify = arrayify;
  exports.booleanify = booleanify;
  exports.shouldIgnore = shouldIgnore;
  var _lodashStringEscapeRegExp = $__require('1d');
  var _lodashStringEscapeRegExp2 = _interopRequireDefault(_lodashStringEscapeRegExp);
  var _lodashStringStartsWith = $__require('1f');
  var _lodashStringStartsWith2 = _interopRequireDefault(_lodashStringStartsWith);
  var _lodashLangIsBoolean = $__require('28');
  var _lodashLangIsBoolean2 = _interopRequireDefault(_lodashLangIsBoolean);
  var _minimatch = $__require('23');
  var _minimatch2 = _interopRequireDefault(_minimatch);
  var _lodashCollectionContains = $__require('24');
  var _lodashCollectionContains2 = _interopRequireDefault(_lodashCollectionContains);
  var _lodashLangIsString = $__require('29');
  var _lodashLangIsString2 = _interopRequireDefault(_lodashLangIsString);
  var _lodashLangIsRegExp = $__require('2a');
  var _lodashLangIsRegExp2 = _interopRequireDefault(_lodashLangIsRegExp);
  var _path = $__require('@node/path');
  var _path2 = _interopRequireDefault(_path);
  var _slash = $__require('26');
  var _slash2 = _interopRequireDefault(_slash);
  var _util = $__require('@node/util');
  exports.inherits = _util.inherits;
  exports.inspect = _util.inspect;
  function canCompile(filename, altExts) {
    var exts = altExts || canCompile.EXTENSIONS;
    var ext = _path2["default"].extname(filename);
    return _lodashCollectionContains2["default"](exts, ext);
  }
  canCompile.EXTENSIONS = [".js", ".jsx", ".es6", ".es"];
  function list(val) {
    if (!val) {
      return [];
    } else if (Array.isArray(val)) {
      return val;
    } else if (typeof val === "string") {
      return val.split(",");
    } else {
      return [val];
    }
  }
  function regexify(val) {
    if (!val) {
      return new RegExp(/.^/);
    }
    if (Array.isArray(val)) {
      val = new RegExp(val.map(_lodashStringEscapeRegExp2["default"]).join("|"), "i");
    }
    if (typeof val === "string") {
      val = _slash2["default"](val);
      if (_lodashStringStartsWith2["default"](val, "./") || _lodashStringStartsWith2["default"](val, "*/"))
        val = val.slice(2);
      if (_lodashStringStartsWith2["default"](val, "**/"))
        val = val.slice(3);
      var regex = _minimatch2["default"].makeRe(val, {nocase: true});
      return new RegExp(regex.source.slice(1, -1), "i");
    }
    if (_lodashLangIsRegExp2["default"](val)) {
      return val;
    }
    throw new TypeError("illegal type for regexify");
  }
  function arrayify(val, mapFn) {
    if (!val)
      return [];
    if (_lodashLangIsBoolean2["default"](val))
      return arrayify([val], mapFn);
    if (_lodashLangIsString2["default"](val))
      return arrayify(list(val), mapFn);
    if (Array.isArray(val)) {
      if (mapFn)
        val = val.map(mapFn);
      return val;
    }
    return [val];
  }
  function booleanify(val) {
    if (val === "true" || val == 1) {
      return true;
    }
    if (val === "false" || val == 0 || !val) {
      return false;
    }
    return val;
  }
  function shouldIgnore(filename, ignore, only) {
    if (ignore === undefined)
      ignore = [];
    filename = _slash2["default"](filename);
    if (only) {
      for (var _i = 0; _i < only.length; _i++) {
        var pattern = only[_i];
        if (_shouldIgnore(pattern, filename))
          return false;
      }
      return true;
    } else if (ignore.length) {
      for (var _i2 = 0; _i2 < ignore.length; _i2++) {
        var pattern = ignore[_i2];
        if (_shouldIgnore(pattern, filename))
          return true;
      }
    }
    return false;
  }
  function _shouldIgnore(pattern, filename) {
    if (typeof pattern === "function") {
      return pattern(filename);
    } else {
      return pattern.test(filename);
    }
  }
  return module.exports;
});

$__System.registerDynamic("2b", ["a", "4", "26", "27", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireDefault = $__require('a')["default"];
  var _interopRequireWildcard = $__require('4')["default"];
  exports.__esModule = true;
  exports.boolean = boolean;
  exports.booleanString = booleanString;
  exports.list = list;
  var _slash = $__require('26');
  var _slash2 = _interopRequireDefault(_slash);
  var _util = $__require('27');
  var util = _interopRequireWildcard(_util);
  var filename = _slash2["default"];
  exports.filename = filename;
  function boolean(val) {
    return !!val;
  }
  function booleanString(val) {
    return util.booleanify(val);
  }
  function list(val) {
    return util.list(val);
  }
  return module.exports;
});

$__System.registerDynamic("2c", ["4", "a", "2b", "2d", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireWildcard = $__require('4')["default"];
  var _interopRequireDefault = $__require('a')["default"];
  exports.__esModule = true;
  exports.normaliseOptions = normaliseOptions;
  var _parsers = $__require('2b');
  var parsers = _interopRequireWildcard(_parsers);
  var _config = $__require('2d');
  var _config2 = _interopRequireDefault(_config);
  exports.config = _config2["default"];
  function normaliseOptions() {
    var options = arguments.length <= 0 || arguments[0] === undefined ? {} : arguments[0];
    for (var key in options) {
      var val = options[key];
      if (val == null)
        continue;
      var opt = _config2["default"][key];
      if (opt && opt.alias)
        opt = _config2["default"][opt.alias];
      if (!opt)
        continue;
      var parser = parsers[opt.type];
      if (parser)
        val = parser(val);
      options[key] = val;
    }
    return options;
  }
  return module.exports;
});

$__System.registerDynamic("2e", [], true, function($__require, exports, module) {
  ;
  var define,
      global = this,
      GLOBAL = this;
  module.exports = $__System._nodeRequire && $__System._nodeRequire('module');
  return module.exports;
});

$__System.registerDynamic("2f", ["a", "2e", "@node/path", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireDefault = $__require('a')["default"];
  exports.__esModule = true;
  var _module2 = $__require('2e');
  var _module3 = _interopRequireDefault(_module2);
  var _path = $__require('@node/path');
  var _path2 = _interopRequireDefault(_path);
  var relativeModules = {};
  exports["default"] = function(loc) {
    var relative = arguments.length <= 1 || arguments[1] === undefined ? process.cwd() : arguments[1];
    if (typeof _module3["default"] === "object")
      return null;
    var relativeMod = relativeModules[relative];
    if (!relativeMod) {
      relativeMod = new _module3["default"]();
      var filename = _path2["default"].join(relative, ".babelrc");
      relativeMod.id = filename;
      relativeMod.filename = filename;
      relativeMod.paths = _module3["default"]._nodeModulePaths(relative);
      relativeModules[relative] = relativeMod;
    }
    try {
      return _module3["default"]._resolveFilename(loc, relativeMod);
    } catch (err) {
      return null;
    }
  };
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("30", ["3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var JSON5 = (typeof exports === 'object' ? exports : {});
  JSON5.parse = (function() {
    "use strict";
    var at,
        ch,
        escapee = {
          "'": "'",
          '"': '"',
          '\\': '\\',
          '/': '/',
          '\n': '',
          b: '\b',
          f: '\f',
          n: '\n',
          r: '\r',
          t: '\t'
        },
        ws = [' ', '\t', '\r', '\n', '\v', '\f', '\xA0', '\uFEFF'],
        text,
        error = function(m) {
          var error = new SyntaxError();
          error.message = m;
          error.at = at;
          error.text = text;
          throw error;
        },
        next = function(c) {
          if (c && c !== ch) {
            error("Expected '" + c + "' instead of '" + ch + "'");
          }
          ch = text.charAt(at);
          at += 1;
          return ch;
        },
        peek = function() {
          return text.charAt(at);
        },
        identifier = function() {
          var key = ch;
          if ((ch !== '_' && ch !== '$') && (ch < 'a' || ch > 'z') && (ch < 'A' || ch > 'Z')) {
            error("Bad identifier");
          }
          while (next() && (ch === '_' || ch === '$' || (ch >= 'a' && ch <= 'z') || (ch >= 'A' && ch <= 'Z') || (ch >= '0' && ch <= '9'))) {
            key += ch;
          }
          return key;
        },
        number = function() {
          var number,
              sign = '',
              string = '',
              base = 10;
          if (ch === '-' || ch === '+') {
            sign = ch;
            next(ch);
          }
          if (ch === 'I') {
            number = word();
            if (typeof number !== 'number' || isNaN(number)) {
              error('Unexpected word for number');
            }
            return (sign === '-') ? -number : number;
          }
          if (ch === 'N') {
            number = word();
            if (!isNaN(number)) {
              error('expected word to be NaN');
            }
            return number;
          }
          if (ch === '0') {
            string += ch;
            next();
            if (ch === 'x' || ch === 'X') {
              string += ch;
              next();
              base = 16;
            } else if (ch >= '0' && ch <= '9') {
              error('Octal literal');
            }
          }
          switch (base) {
            case 10:
              while (ch >= '0' && ch <= '9') {
                string += ch;
                next();
              }
              if (ch === '.') {
                string += '.';
                while (next() && ch >= '0' && ch <= '9') {
                  string += ch;
                }
              }
              if (ch === 'e' || ch === 'E') {
                string += ch;
                next();
                if (ch === '-' || ch === '+') {
                  string += ch;
                  next();
                }
                while (ch >= '0' && ch <= '9') {
                  string += ch;
                  next();
                }
              }
              break;
            case 16:
              while (ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'F' || ch >= 'a' && ch <= 'f') {
                string += ch;
                next();
              }
              break;
          }
          if (sign === '-') {
            number = -string;
          } else {
            number = +string;
          }
          if (!isFinite(number)) {
            error("Bad number");
          } else {
            return number;
          }
        },
        string = function() {
          var hex,
              i,
              string = '',
              delim,
              uffff;
          if (ch === '"' || ch === "'") {
            delim = ch;
            while (next()) {
              if (ch === delim) {
                next();
                return string;
              } else if (ch === '\\') {
                next();
                if (ch === 'u') {
                  uffff = 0;
                  for (i = 0; i < 4; i += 1) {
                    hex = parseInt(next(), 16);
                    if (!isFinite(hex)) {
                      break;
                    }
                    uffff = uffff * 16 + hex;
                  }
                  string += String.fromCharCode(uffff);
                } else if (ch === '\r') {
                  if (peek() === '\n') {
                    next();
                  }
                } else if (typeof escapee[ch] === 'string') {
                  string += escapee[ch];
                } else {
                  break;
                }
              } else if (ch === '\n') {
                break;
              } else {
                string += ch;
              }
            }
          }
          error("Bad string");
        },
        inlineComment = function() {
          if (ch !== '/') {
            error("Not an inline comment");
          }
          do {
            next();
            if (ch === '\n' || ch === '\r') {
              next();
              return;
            }
          } while (ch);
        },
        blockComment = function() {
          if (ch !== '*') {
            error("Not a block comment");
          }
          do {
            next();
            while (ch === '*') {
              next('*');
              if (ch === '/') {
                next('/');
                return;
              }
            }
          } while (ch);
          error("Unterminated block comment");
        },
        comment = function() {
          if (ch !== '/') {
            error("Not a comment");
          }
          next('/');
          if (ch === '/') {
            inlineComment();
          } else if (ch === '*') {
            blockComment();
          } else {
            error("Unrecognized comment");
          }
        },
        white = function() {
          while (ch) {
            if (ch === '/') {
              comment();
            } else if (ws.indexOf(ch) >= 0) {
              next();
            } else {
              return;
            }
          }
        },
        word = function() {
          switch (ch) {
            case 't':
              next('t');
              next('r');
              next('u');
              next('e');
              return true;
            case 'f':
              next('f');
              next('a');
              next('l');
              next('s');
              next('e');
              return false;
            case 'n':
              next('n');
              next('u');
              next('l');
              next('l');
              return null;
            case 'I':
              next('I');
              next('n');
              next('f');
              next('i');
              next('n');
              next('i');
              next('t');
              next('y');
              return Infinity;
            case 'N':
              next('N');
              next('a');
              next('N');
              return NaN;
          }
          error("Unexpected '" + ch + "'");
        },
        value,
        array = function() {
          var array = [];
          if (ch === '[') {
            next('[');
            white();
            while (ch) {
              if (ch === ']') {
                next(']');
                return array;
              }
              if (ch === ',') {
                error("Missing array element");
              } else {
                array.push(value());
              }
              white();
              if (ch !== ',') {
                next(']');
                return array;
              }
              next(',');
              white();
            }
          }
          error("Bad array");
        },
        object = function() {
          var key,
              object = {};
          if (ch === '{') {
            next('{');
            white();
            while (ch) {
              if (ch === '}') {
                next('}');
                return object;
              }
              if (ch === '"' || ch === "'") {
                key = string();
              } else {
                key = identifier();
              }
              white();
              next(':');
              object[key] = value();
              white();
              if (ch !== ',') {
                next('}');
                return object;
              }
              next(',');
              white();
            }
          }
          error("Bad object");
        };
    value = function() {
      white();
      switch (ch) {
        case '{':
          return object();
        case '[':
          return array();
        case '"':
        case "'":
          return string();
        case '-':
        case '+':
        case '.':
          return number();
        default:
          return ch >= '0' && ch <= '9' ? number() : word();
      }
    };
    return function(source, reviver) {
      var result;
      text = String(source);
      at = 0;
      ch = ' ';
      result = value();
      white();
      if (ch) {
        error("Syntax error");
      }
      return typeof reviver === 'function' ? (function walk(holder, key) {
        var k,
            v,
            value = holder[key];
        if (value && typeof value === 'object') {
          for (k in value) {
            if (Object.prototype.hasOwnProperty.call(value, k)) {
              v = walk(value, k);
              if (v !== undefined) {
                value[k] = v;
              } else {
                delete value[k];
              }
            }
          }
        }
        return reviver.call(holder, key, value);
      }({'': result}, '')) : result;
    };
  }());
  JSON5.stringify = function(obj, replacer, space) {
    if (replacer && (typeof(replacer) !== "function" && !isArray(replacer))) {
      throw new Error('Replacer must be a function or an array');
    }
    var getReplacedValueOrUndefined = function(holder, key, isTopLevel) {
      var value = holder[key];
      if (value && value.toJSON && typeof value.toJSON === "function") {
        value = value.toJSON();
      }
      if (typeof(replacer) === "function") {
        return replacer.call(holder, key, value);
      } else if (replacer) {
        if (isTopLevel || isArray(holder) || replacer.indexOf(key) >= 0) {
          return value;
        } else {
          return undefined;
        }
      } else {
        return value;
      }
    };
    function isWordChar(char) {
      return (char >= 'a' && char <= 'z') || (char >= 'A' && char <= 'Z') || (char >= '0' && char <= '9') || char === '_' || char === '$';
    }
    function isWordStart(char) {
      return (char >= 'a' && char <= 'z') || (char >= 'A' && char <= 'Z') || char === '_' || char === '$';
    }
    function isWord(key) {
      if (typeof key !== 'string') {
        return false;
      }
      if (!isWordStart(key[0])) {
        return false;
      }
      var i = 1,
          length = key.length;
      while (i < length) {
        if (!isWordChar(key[i])) {
          return false;
        }
        i++;
      }
      return true;
    }
    JSON5.isWord = isWord;
    function isArray(obj) {
      if (Array.isArray) {
        return Array.isArray(obj);
      } else {
        return Object.prototype.toString.call(obj) === '[object Array]';
      }
    }
    function isDate(obj) {
      return Object.prototype.toString.call(obj) === '[object Date]';
    }
    isNaN = isNaN || function(val) {
      return typeof val === 'number' && val !== val;
    };
    var objStack = [];
    function checkForCircular(obj) {
      for (var i = 0; i < objStack.length; i++) {
        if (objStack[i] === obj) {
          throw new TypeError("Converting circular structure to JSON");
        }
      }
    }
    function makeIndent(str, num, noNewLine) {
      if (!str) {
        return "";
      }
      if (str.length > 10) {
        str = str.substring(0, 10);
      }
      var indent = noNewLine ? "" : "\n";
      for (var i = 0; i < num; i++) {
        indent += str;
      }
      return indent;
    }
    var indentStr;
    if (space) {
      if (typeof space === "string") {
        indentStr = space;
      } else if (typeof space === "number" && space >= 0) {
        indentStr = makeIndent(" ", space, true);
      } else {}
    }
    var cx = /[\u0000\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,
        escapable = /[\\\"\x00-\x1f\x7f-\x9f\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,
        meta = {
          '\b': '\\b',
          '\t': '\\t',
          '\n': '\\n',
          '\f': '\\f',
          '\r': '\\r',
          '"': '\\"',
          '\\': '\\\\'
        };
    function escapeString(string) {
      escapable.lastIndex = 0;
      return escapable.test(string) ? '"' + string.replace(escapable, function(a) {
        var c = meta[a];
        return typeof c === 'string' ? c : '\\u' + ('0000' + a.charCodeAt(0).toString(16)).slice(-4);
      }) + '"' : '"' + string + '"';
    }
    function internalStringify(holder, key, isTopLevel) {
      var buffer,
          res;
      var obj_part = getReplacedValueOrUndefined(holder, key, isTopLevel);
      if (obj_part && !isDate(obj_part)) {
        obj_part = obj_part.valueOf();
      }
      switch (typeof obj_part) {
        case "boolean":
          return obj_part.toString();
        case "number":
          if (isNaN(obj_part) || !isFinite(obj_part)) {
            return "null";
          }
          return obj_part.toString();
        case "string":
          return escapeString(obj_part.toString());
        case "object":
          if (obj_part === null) {
            return "null";
          } else if (isArray(obj_part)) {
            checkForCircular(obj_part);
            buffer = "[";
            objStack.push(obj_part);
            for (var i = 0; i < obj_part.length; i++) {
              res = internalStringify(obj_part, i, false);
              buffer += makeIndent(indentStr, objStack.length);
              if (res === null || typeof res === "undefined") {
                buffer += "null";
              } else {
                buffer += res;
              }
              if (i < obj_part.length - 1) {
                buffer += ",";
              } else if (indentStr) {
                buffer += "\n";
              }
            }
            objStack.pop();
            buffer += makeIndent(indentStr, objStack.length, true) + "]";
          } else {
            checkForCircular(obj_part);
            buffer = "{";
            var nonEmpty = false;
            objStack.push(obj_part);
            for (var prop in obj_part) {
              if (obj_part.hasOwnProperty(prop)) {
                var value = internalStringify(obj_part, prop, false);
                isTopLevel = false;
                if (typeof value !== "undefined" && value !== null) {
                  buffer += makeIndent(indentStr, objStack.length);
                  nonEmpty = true;
                  var key = isWord(prop) ? prop : escapeString(prop);
                  buffer += key + ":" + (indentStr ? ' ' : '') + value + ",";
                }
              }
            }
            objStack.pop();
            if (nonEmpty) {
              buffer = buffer.substring(0, buffer.length - 1) + makeIndent(indentStr, objStack.length) + "}";
            } else {
              buffer = '{}';
            }
          }
          return buffer;
        default:
          return undefined;
      }
    }
    var topLevelHolder = {"": obj};
    if (obj === undefined) {
      return getReplacedValueOrUndefined(topLevelHolder, '', true);
    }
    return internalStringify(topLevelHolder, '', true);
  };
  return module.exports;
});

$__System.registerDynamic("31", ["3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  function posix(path) {
    return path.charAt(0) === '/';
  }
  ;
  function win32(path) {
    var splitDeviceRe = /^([a-zA-Z]:|[\\\/]{2}[^\\\/]+[\\\/]+[^\\\/]+)?([\\\/])?([\s\S]*?)$/;
    var result = splitDeviceRe.exec(path);
    var device = result[1] || '';
    var isUnc = !!device && device.charAt(1) !== ':';
    return !!result[2] || isUnc;
  }
  ;
  module.exports = process.platform === 'win32' ? win32 : posix;
  module.exports.posix = posix;
  module.exports.win32 = win32;
  return module.exports;
});

$__System.registerDynamic("32", ["@node/fs", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var fs = $__require('@node/fs');
  module.exports = function(pth, cb) {
    var fn = typeof fs.access === 'function' ? fs.access : fs.stat;
    fn(pth, function(err) {
      cb(null, !err);
    });
  };
  module.exports.sync = function(pth) {
    var fn = typeof fs.accessSync === 'function' ? fs.accessSync : fs.statSync;
    try {
      fn(pth);
      return true;
    } catch (err) {
      return false;
    }
  };
  return module.exports;
});

$__System.registerDynamic("33", ["34", "35", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var baseCopy = $__require('34'),
      keysIn = $__require('35');
  function toPlainObject(value) {
    return baseCopy(value, keysIn(value));
  }
  module.exports = toPlainObject;
  return module.exports;
});

$__System.registerDynamic("36", ["37", "38", "39", "3a", "3b", "3c", "33", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var arrayCopy = $__require('37'),
      isArguments = $__require('38'),
      isArray = $__require('39'),
      isArrayLike = $__require('3a'),
      isPlainObject = $__require('3b'),
      isTypedArray = $__require('3c'),
      toPlainObject = $__require('33');
  function baseMergeDeep(object, source, key, mergeFunc, customizer, stackA, stackB) {
    var length = stackA.length,
        srcValue = source[key];
    while (length--) {
      if (stackA[length] == srcValue) {
        object[key] = stackB[length];
        return;
      }
    }
    var value = object[key],
        result = customizer ? customizer(value, srcValue, key, object, source) : undefined,
        isCommon = result === undefined;
    if (isCommon) {
      result = srcValue;
      if (isArrayLike(srcValue) && (isArray(srcValue) || isTypedArray(srcValue))) {
        result = isArray(value) ? value : (isArrayLike(value) ? arrayCopy(value) : []);
      } else if (isPlainObject(srcValue) || isArguments(srcValue)) {
        result = isArguments(value) ? toPlainObject(value) : (isPlainObject(value) ? value : {});
      } else {
        isCommon = false;
      }
    }
    stackA.push(srcValue);
    stackB.push(result);
    if (isCommon) {
      object[key] = mergeFunc(result, srcValue, customizer, stackA, stackB);
    } else if (result === result ? (result !== value) : (value === value)) {
      object[key] = result;
    }
  }
  module.exports = baseMergeDeep;
  return module.exports;
});

$__System.registerDynamic("3d", ["3e", "36", "39", "3a", "3f", "40", "3c", "41", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var arrayEach = $__require('3e'),
      baseMergeDeep = $__require('36'),
      isArray = $__require('39'),
      isArrayLike = $__require('3a'),
      isObject = $__require('3f'),
      isObjectLike = $__require('40'),
      isTypedArray = $__require('3c'),
      keys = $__require('41');
  function baseMerge(object, source, customizer, stackA, stackB) {
    if (!isObject(object)) {
      return object;
    }
    var isSrcArr = isArrayLike(source) && (isArray(source) || isTypedArray(source)),
        props = isSrcArr ? undefined : keys(source);
    arrayEach(props || source, function(srcValue, key) {
      if (props) {
        key = srcValue;
        srcValue = source[key];
      }
      if (isObjectLike(srcValue)) {
        stackA || (stackA = []);
        stackB || (stackB = []);
        baseMergeDeep(object, source, key, baseMerge, customizer, stackA, stackB);
      } else {
        var value = object[key],
            result = customizer ? customizer(value, srcValue, key, object, source) : undefined,
            isCommon = result === undefined;
        if (isCommon) {
          result = srcValue;
        }
        if ((result !== undefined || (isSrcArr && !(key in object))) && (isCommon || (result === result ? (result !== value) : (value === value)))) {
          object[key] = result;
        }
      }
    });
    return object;
  }
  module.exports = baseMerge;
  return module.exports;
});

$__System.registerDynamic("42", ["3d", "43", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var baseMerge = $__require('3d'),
      createAssigner = $__require('43');
  var merge = createAssigner(baseMerge);
  module.exports = merge;
  return module.exports;
});

$__System.registerDynamic("44", ["45", "a", "42", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _getIterator = $__require('45')["default"];
  var _interopRequireDefault = $__require('a')["default"];
  exports.__esModule = true;
  var _lodashObjectMerge = $__require('42');
  var _lodashObjectMerge2 = _interopRequireDefault(_lodashObjectMerge);
  exports["default"] = function(dest, src) {
    if (!dest || !src)
      return;
    return _lodashObjectMerge2["default"](dest, src, function(a, b) {
      if (b && Array.isArray(a)) {
        var newArray = b.slice(0);
        for (var _iterator = a,
            _isArray = Array.isArray(_iterator),
            _i = 0,
            _iterator = _isArray ? _iterator : _getIterator(_iterator); ; ) {
          var _ref;
          if (_isArray) {
            if (_i >= _iterator.length)
              break;
            _ref = _iterator[_i++];
          } else {
            _i = _iterator.next();
            if (_i.done)
              break;
            _ref = _i.value;
          }
          var item = _ref;
          if (newArray.indexOf(item) < 0) {
            newArray.push(item);
          }
        }
        return newArray;
      }
    });
  };
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("46", ["3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  module.exports = {
    "auxiliaryComment": {"message": "Use `auxiliaryCommentBefore` or `auxiliaryCommentAfter`"},
    "blacklist": {"message": "Put the specific transforms you want in the `plugins` option"},
    "breakConfig": {"message": "This is not a necessary option in Babel 6"},
    "experimental": {"message": "Put the specific transforms you want in the `plugins` option"},
    "externalHelpers": {"message": "Use the `external-helpers` plugin instead. Check out http://babeljs.io/docs/plugins/external-helpers/"},
    "extra": {"message": ""},
    "jsxPragma": {"message": "use the `pragma` option in the `react-jsx` plugin . Check out http://babeljs.io/docs/plugins/transform-react-jsx/"},
    "loose": {"message": "Specify the `loose` option for the relevant plugin you are using or use a preset that sets the option."},
    "metadataUsedHelpers": {"message": "Not required anymore as this is enabled by default"},
    "modules": {"message": "Use the corresponding module transform plugin in the `plugins` option. Check out http://babeljs.io/docs/plugins/#modules"},
    "nonStandard": {"message": "Use the `react-jsx` and `flow-strip-types` plugins to support JSX and Flow. Also check out the react preset http://babeljs.io/docs/plugins/preset-react/"},
    "optional": {"message": "Put the specific transforms you want in the `plugins` option"},
    "sourceMapName": {"message": "Use the `sourceMapTarget` option"},
    "stage": {"message": "Check out the corresponding stage-x presets http://babeljs.io/docs/plugins/#presets"},
    "whitelist": {"message": "Put the specific transforms you want in the `plugins` option"}
  };
  return module.exports;
});

$__System.registerDynamic("47", ["9", "49", "4", "a", "48", "7", "4a", "2c", "2f", "30", "31", "32", "4b", "4c", "44", "2d", "46", "@node/path", "@node/fs", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _classCallCheck = $__require('9')["default"];
  var _Object$assign = $__require('49')["default"];
  var _interopRequireWildcard = $__require('4')["default"];
  var _interopRequireDefault = $__require('a')["default"];
  exports.__esModule = true;
  var _apiNode = $__require('48');
  var context = _interopRequireWildcard(_apiNode);
  var _plugin2 = $__require('7');
  var _plugin3 = _interopRequireDefault(_plugin2);
  var _babelMessages = $__require('4a');
  var messages = _interopRequireWildcard(_babelMessages);
  var _index = $__require('2c');
  var _helpersResolve = $__require('2f');
  var _helpersResolve2 = _interopRequireDefault(_helpersResolve);
  var _json5 = $__require('30');
  var _json52 = _interopRequireDefault(_json5);
  var _pathIsAbsolute = $__require('31');
  var _pathIsAbsolute2 = _interopRequireDefault(_pathIsAbsolute);
  var _pathExists = $__require('32');
  var _pathExists2 = _interopRequireDefault(_pathExists);
  var _lodashLangCloneDeep = $__require('4b');
  var _lodashLangCloneDeep2 = _interopRequireDefault(_lodashLangCloneDeep);
  var _lodashLangClone = $__require('4c');
  var _lodashLangClone2 = _interopRequireDefault(_lodashLangClone);
  var _helpersMerge = $__require('44');
  var _helpersMerge2 = _interopRequireDefault(_helpersMerge);
  var _config = $__require('2d');
  var _config2 = _interopRequireDefault(_config);
  var _removed = $__require('46');
  var _removed2 = _interopRequireDefault(_removed);
  var _path = $__require('@node/path');
  var _path2 = _interopRequireDefault(_path);
  var _fs = $__require('@node/fs');
  var _fs2 = _interopRequireDefault(_fs);
  var existsCache = {};
  var jsonCache = {};
  var BABELIGNORE_FILENAME = ".babelignore";
  var BABELRC_FILENAME = ".babelrc";
  var PACKAGE_FILENAME = "package.json";
  function exists(filename) {
    var cached = existsCache[filename];
    if (cached == null) {
      return existsCache[filename] = _pathExists2["default"].sync(filename);
    } else {
      return cached;
    }
  }
  var OptionManager = (function() {
    function OptionManager(log) {
      _classCallCheck(this, OptionManager);
      this.resolvedConfigs = [];
      this.options = OptionManager.createBareOptions();
      this.log = log;
    }
    OptionManager.memoisePluginContainer = function memoisePluginContainer(fn, loc, i, alias) {
      var _arr = OptionManager.memoisedPlugins;
      for (var _i = 0; _i < _arr.length; _i++) {
        var cache = _arr[_i];
        if (cache.container === fn)
          return cache.plugin;
      }
      var obj = undefined;
      if (typeof fn === "function") {
        obj = fn(context);
      } else {
        obj = fn;
      }
      if (typeof obj === "object") {
        var _plugin = new _plugin3["default"](obj, alias);
        OptionManager.memoisedPlugins.push({
          container: fn,
          plugin: _plugin
        });
        return _plugin;
      } else {
        throw new TypeError(messages.get("pluginNotObject", loc, i, typeof obj) + loc + i);
      }
    };
    OptionManager.createBareOptions = function createBareOptions() {
      var opts = {};
      for (var _key in _config2["default"]) {
        var opt = _config2["default"][_key];
        opts[_key] = _lodashLangClone2["default"](opt["default"]);
      }
      return opts;
    };
    OptionManager.normalisePlugin = function normalisePlugin(plugin, loc, i, alias) {
      plugin = plugin.__esModule ? plugin["default"] : plugin;
      if (!(plugin instanceof _plugin3["default"])) {
        if (typeof plugin === "function" || typeof plugin === "object") {
          plugin = OptionManager.memoisePluginContainer(plugin, loc, i, alias);
        } else {
          throw new TypeError(messages.get("pluginNotFunction", loc, i, typeof plugin));
        }
      }
      plugin.init(loc, i);
      return plugin;
    };
    OptionManager.normalisePlugins = function normalisePlugins(loc, dirname, plugins) {
      return plugins.map(function(val, i) {
        var plugin = undefined,
            options = undefined;
        if (!val) {
          throw new TypeError("Falsy value found in plugins");
        }
        if (Array.isArray(val)) {
          plugin = val[0];
          options = val[1];
        } else {
          plugin = val;
        }
        var alias = typeof plugin === "string" ? plugin : loc + "$" + i;
        if (typeof plugin === "string") {
          var pluginLoc = _helpersResolve2["default"]("babel-plugin-" + plugin, dirname) || _helpersResolve2["default"](plugin, dirname);
          if (pluginLoc) {
            plugin = $__require(pluginLoc);
          } else {
            throw new ReferenceError(messages.get("pluginUnknown", plugin, loc, i, dirname));
          }
        }
        plugin = OptionManager.normalisePlugin(plugin, loc, i, alias);
        return [plugin, options];
      });
    };
    OptionManager.prototype.addConfig = function addConfig(loc, key) {
      var json = arguments.length <= 2 || arguments[2] === undefined ? _json52["default"] : arguments[2];
      if (this.resolvedConfigs.indexOf(loc) >= 0) {
        return false;
      }
      var content = _fs2["default"].readFileSync(loc, "utf8");
      var opts = undefined;
      try {
        opts = jsonCache[content] = jsonCache[content] || json.parse(content);
        if (key)
          opts = opts[key];
      } catch (err) {
        err.message = loc + ": Error while parsing JSON - " + err.message;
        throw err;
      }
      this.mergeOptions({
        options: opts,
        alias: loc,
        dirname: _path2["default"].dirname(loc)
      });
      this.resolvedConfigs.push(loc);
      return !!opts;
    };
    OptionManager.prototype.mergeOptions = function mergeOptions(_ref) {
      var _this = this;
      var rawOpts = _ref.options;
      var extendingOpts = _ref.extending;
      var alias = _ref.alias;
      var loc = _ref.loc;
      var dirname = _ref.dirname;
      alias = alias || "foreign";
      if (!rawOpts)
        return;
      if (typeof rawOpts !== "object" || Array.isArray(rawOpts)) {
        this.log.error("Invalid options type for " + alias, TypeError);
      }
      var opts = _lodashLangCloneDeep2["default"](rawOpts, function(val) {
        if (val instanceof _plugin3["default"]) {
          return val;
        }
      });
      dirname = dirname || process.cwd();
      loc = loc || alias;
      for (var _key2 in opts) {
        var option = _config2["default"][_key2];
        if (!option && this.log) {
          var pluginOptsInfo = "Check out http://babeljs.io/docs/usage/options/ for more info";
          if (_removed2["default"][_key2]) {
            this.log.error("Using removed Babel 5 option: " + alias + "." + _key2 + " - " + _removed2["default"][_key2].message, ReferenceError);
          } else {
            this.log.error("Unknown option: " + alias + "." + _key2 + ". " + pluginOptsInfo, ReferenceError);
          }
        }
      }
      _index.normaliseOptions(opts);
      if (opts.plugins) {
        opts.plugins = OptionManager.normalisePlugins(loc, dirname, opts.plugins);
      }
      if (opts["extends"]) {
        var extendsLoc = _helpersResolve2["default"](opts["extends"], dirname);
        if (extendsLoc) {
          this.addConfig(extendsLoc);
        } else {
          if (this.log)
            this.log.error("Couldn't resolve extends clause of " + opts["extends"] + " in " + alias);
        }
        delete opts["extends"];
      }
      if (opts.presets) {
        if (opts.passPerPreset) {
          opts.presets = this.resolvePresets(opts.presets, dirname, function(preset, presetLoc) {
            _this.mergeOptions({
              options: preset,
              extending: preset,
              alias: presetLoc,
              loc: presetLoc,
              dirname: dirname
            });
          });
        } else {
          this.mergePresets(opts.presets, dirname);
          delete opts.presets;
        }
      }
      var envOpts = undefined;
      var envKey = process.env.BABEL_ENV || "production" || "development";
      if (opts.env) {
        envOpts = opts.env[envKey];
        delete opts.env;
      }
      if (rawOpts === extendingOpts) {
        _Object$assign(extendingOpts, opts);
      } else {
        _helpersMerge2["default"](extendingOpts || this.options, opts);
      }
      this.mergeOptions({
        options: envOpts,
        extending: extendingOpts,
        alias: alias + ".env." + envKey,
        dirname: dirname
      });
    };
    OptionManager.prototype.mergePresets = function mergePresets(presets, dirname) {
      var _this2 = this;
      this.resolvePresets(presets, dirname, function(presetOpts, presetLoc) {
        _this2.mergeOptions({
          options: presetOpts,
          alias: presetLoc,
          loc: presetLoc,
          dirname: _path2["default"].dirname(presetLoc)
        });
      });
    };
    OptionManager.prototype.resolvePresets = function resolvePresets(presets, dirname, onResolve) {
      return presets.map(function(val) {
        if (typeof val === "string") {
          var presetLoc = _helpersResolve2["default"]("babel-preset-" + val, dirname) || _helpersResolve2["default"](val, dirname);
          if (presetLoc) {
            var _val = $__require(presetLoc);
            onResolve && onResolve(_val, presetLoc);
            return _val;
          } else {
            throw new Error("Couldn't find preset " + JSON.stringify(val) + " relative to directory " + JSON.stringify(dirname));
          }
        } else if (typeof val === "object") {
          onResolve && onResolve(val);
          return val;
        } else {
          throw new Error("Unsupported preset format: " + val + ".");
        }
      });
    };
    OptionManager.prototype.addIgnoreConfig = function addIgnoreConfig(loc) {
      var file = _fs2["default"].readFileSync(loc, "utf8");
      var lines = file.split("\n");
      lines = lines.map(function(line) {
        return line.replace(/#(.*?)$/, "").trim();
      }).filter(function(line) {
        return !!line;
      });
      this.mergeOptions({
        options: {ignore: lines},
        loc: loc
      });
    };
    OptionManager.prototype.findConfigs = function findConfigs(loc) {
      if (!loc)
        return;
      if (!_pathIsAbsolute2["default"](loc)) {
        loc = _path2["default"].join(process.cwd(), loc);
      }
      var foundConfig = false;
      var foundIgnore = false;
      while (loc !== (loc = _path2["default"].dirname(loc))) {
        if (!foundConfig) {
          var configLoc = _path2["default"].join(loc, BABELRC_FILENAME);
          if (exists(configLoc)) {
            this.addConfig(configLoc);
            foundConfig = true;
          }
          var pkgLoc = _path2["default"].join(loc, PACKAGE_FILENAME);
          if (!foundConfig && exists(pkgLoc)) {
            foundConfig = this.addConfig(pkgLoc, "babel", JSON);
          }
        }
        if (!foundIgnore) {
          var ignoreLoc = _path2["default"].join(loc, BABELIGNORE_FILENAME);
          if (exists(ignoreLoc)) {
            this.addIgnoreConfig(ignoreLoc);
            foundIgnore = true;
          }
        }
        if (foundIgnore && foundConfig)
          return;
      }
    };
    OptionManager.prototype.normaliseOptions = function normaliseOptions() {
      var opts = this.options;
      for (var _key3 in _config2["default"]) {
        var option = _config2["default"][_key3];
        var val = opts[_key3];
        if (!val && option.optional)
          continue;
        if (option.alias) {
          opts[option.alias] = opts[option.alias] || val;
        } else {
          opts[_key3] = val;
        }
      }
    };
    OptionManager.prototype.init = function init() {
      var opts = arguments.length <= 0 || arguments[0] === undefined ? {} : arguments[0];
      var filename = opts.filename;
      if (opts.babelrc !== false) {
        this.findConfigs(filename);
      }
      this.mergeOptions({
        options: opts,
        alias: "base",
        dirname: filename && _path2["default"].dirname(filename)
      });
      this.normaliseOptions(opts);
      return this.options;
    };
    return OptionManager;
  })();
  exports["default"] = OptionManager;
  OptionManager.memoisedPlugins = [];
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("4d", ["4e", "4f", "50", "51", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var core = $__require('4e'),
      $ = $__require('4f'),
      DESCRIPTORS = $__require('50'),
      SPECIES = $__require('51')('species');
  module.exports = function(KEY) {
    var C = core[KEY];
    if (DESCRIPTORS && C && !C[SPECIES])
      $.setDesc(C, SPECIES, {
        configurable: true,
        get: function() {
          return this;
        }
      });
  };
  return module.exports;
});

$__System.registerDynamic("52", ["4f", "53", "54", "55", "56", "57", "58", "59", "5a", "5b", "5c", "5d", "4d", "50", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var $ = $__require('4f'),
      hide = $__require('53'),
      redefineAll = $__require('54'),
      ctx = $__require('55'),
      strictNew = $__require('56'),
      defined = $__require('57'),
      forOf = $__require('58'),
      $iterDefine = $__require('59'),
      step = $__require('5a'),
      ID = $__require('5b')('id'),
      $has = $__require('5c'),
      isObject = $__require('5d'),
      setSpecies = $__require('4d'),
      DESCRIPTORS = $__require('50'),
      isExtensible = Object.isExtensible || isObject,
      SIZE = DESCRIPTORS ? '_s' : 'size',
      id = 0;
  var fastKey = function(it, create) {
    if (!isObject(it))
      return typeof it == 'symbol' ? it : (typeof it == 'string' ? 'S' : 'P') + it;
    if (!$has(it, ID)) {
      if (!isExtensible(it))
        return 'F';
      if (!create)
        return 'E';
      hide(it, ID, ++id);
    }
    return 'O' + it[ID];
  };
  var getEntry = function(that, key) {
    var index = fastKey(key),
        entry;
    if (index !== 'F')
      return that._i[index];
    for (entry = that._f; entry; entry = entry.n) {
      if (entry.k == key)
        return entry;
    }
  };
  module.exports = {
    getConstructor: function(wrapper, NAME, IS_MAP, ADDER) {
      var C = wrapper(function(that, iterable) {
        strictNew(that, C, NAME);
        that._i = $.create(null);
        that._f = undefined;
        that._l = undefined;
        that[SIZE] = 0;
        if (iterable != undefined)
          forOf(iterable, IS_MAP, that[ADDER], that);
      });
      redefineAll(C.prototype, {
        clear: function clear() {
          for (var that = this,
              data = that._i,
              entry = that._f; entry; entry = entry.n) {
            entry.r = true;
            if (entry.p)
              entry.p = entry.p.n = undefined;
            delete data[entry.i];
          }
          that._f = that._l = undefined;
          that[SIZE] = 0;
        },
        'delete': function(key) {
          var that = this,
              entry = getEntry(that, key);
          if (entry) {
            var next = entry.n,
                prev = entry.p;
            delete that._i[entry.i];
            entry.r = true;
            if (prev)
              prev.n = next;
            if (next)
              next.p = prev;
            if (that._f == entry)
              that._f = next;
            if (that._l == entry)
              that._l = prev;
            that[SIZE]--;
          }
          return !!entry;
        },
        forEach: function forEach(callbackfn) {
          var f = ctx(callbackfn, arguments.length > 1 ? arguments[1] : undefined, 3),
              entry;
          while (entry = entry ? entry.n : this._f) {
            f(entry.v, entry.k, this);
            while (entry && entry.r)
              entry = entry.p;
          }
        },
        has: function has(key) {
          return !!getEntry(this, key);
        }
      });
      if (DESCRIPTORS)
        $.setDesc(C.prototype, 'size', {get: function() {
            return defined(this[SIZE]);
          }});
      return C;
    },
    def: function(that, key, value) {
      var entry = getEntry(that, key),
          prev,
          index;
      if (entry) {
        entry.v = value;
      } else {
        that._l = entry = {
          i: index = fastKey(key, true),
          k: key,
          v: value,
          p: prev = that._l,
          n: undefined,
          r: false
        };
        if (!that._f)
          that._f = entry;
        if (prev)
          prev.n = entry;
        that[SIZE]++;
        if (index !== 'F')
          that._i[index] = entry;
      }
      return that;
    },
    getEntry: getEntry,
    setStrong: function(C, NAME, IS_MAP) {
      $iterDefine(C, NAME, function(iterated, kind) {
        this._t = iterated;
        this._k = kind;
        this._l = undefined;
      }, function() {
        var that = this,
            kind = that._k,
            entry = that._l;
        while (entry && entry.r)
          entry = entry.p;
        if (!that._t || !(that._l = entry = entry ? entry.n : that._t._f)) {
          that._t = undefined;
          return step(1);
        }
        if (kind == 'keys')
          return step(0, entry.k);
        if (kind == 'values')
          return step(0, entry.v);
        return step(0, [entry.k, entry.v]);
      }, IS_MAP ? 'entries' : 'values', !IS_MAP, true);
      setSpecies(NAME);
    }
  };
  return module.exports;
});

$__System.registerDynamic("5e", ["52", "5f", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var strong = $__require('52');
  $__require('5f')('Map', function(get) {
    return function Map() {
      return get(this, arguments.length > 0 ? arguments[0] : undefined);
    };
  }, {
    get: function get(key) {
      var entry = strong.getEntry(this, key);
      return entry && entry.v;
    },
    set: function set(key, value) {
      return strong.def(this, key === 0 ? 0 : key, value);
    }
  }, strong, true);
  return module.exports;
});

$__System.registerDynamic("60", ["58", "61", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var forOf = $__require('58'),
      classof = $__require('61');
  module.exports = function(NAME) {
    return function toJSON() {
      if (classof(this) != NAME)
        throw TypeError(NAME + "#toJSON isn't generic");
      var arr = [];
      forOf(this, false, arr.push, arr);
      return arr;
    };
  };
  return module.exports;
});

$__System.registerDynamic("62", ["63", "60", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var $export = $__require('63');
  $export($export.P, 'Map', {toJSON: $__require('60')('Map')});
  return module.exports;
});

$__System.registerDynamic("64", ["65", "66", "67", "5e", "62", "4e", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  $__require('65');
  $__require('66');
  $__require('67');
  $__require('5e');
  $__require('62');
  module.exports = $__require('4e').Map;
  return module.exports;
});

$__System.registerDynamic("68", ["64", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  module.exports = {
    "default": $__require('64'),
    __esModule: true
  };
  return module.exports;
});

$__System.registerDynamic("e", ["f", "9", "68", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _inherits = $__require('f')["default"];
  var _classCallCheck = $__require('9')["default"];
  var _Map2 = $__require('68')["default"];
  exports.__esModule = true;
  var Store = (function(_Map) {
    _inherits(Store, _Map);
    function Store() {
      _classCallCheck(this, Store);
      _Map.call(this);
      this.dynamicData = {};
    }
    Store.prototype.setDynamic = function setDynamic(key, fn) {
      this.dynamicData[key] = fn;
    };
    Store.prototype.get = function get(key) {
      if (this.has(key)) {
        return _Map.prototype.get.call(this, key);
      } else {
        if (Object.prototype.hasOwnProperty.call(this.dynamicData, key)) {
          var val = this.dynamicData[key]();
          this.set(key, val);
          return val;
        }
      }
    };
    return Store;
  })(_Map2);
  exports["default"] = Store;
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("7", ["f", "9", "45", "a", "4", "47", "4a", "e", "10", "69", "4c", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _inherits = $__require('f')["default"];
  var _classCallCheck = $__require('9')["default"];
  var _getIterator = $__require('45')["default"];
  var _interopRequireDefault = $__require('a')["default"];
  var _interopRequireWildcard = $__require('4')["default"];
  exports.__esModule = true;
  var _fileOptionsOptionManager = $__require('47');
  var _fileOptionsOptionManager2 = _interopRequireDefault(_fileOptionsOptionManager);
  var _babelMessages = $__require('4a');
  var messages = _interopRequireWildcard(_babelMessages);
  var _store = $__require('e');
  var _store2 = _interopRequireDefault(_store);
  var _babelTraverse = $__require('10');
  var _babelTraverse2 = _interopRequireDefault(_babelTraverse);
  var _lodashObjectAssign = $__require('69');
  var _lodashObjectAssign2 = _interopRequireDefault(_lodashObjectAssign);
  var _lodashLangClone = $__require('4c');
  var _lodashLangClone2 = _interopRequireDefault(_lodashLangClone);
  var GLOBAL_VISITOR_PROPS = ["enter", "exit"];
  var Plugin = (function(_Store) {
    _inherits(Plugin, _Store);
    function Plugin(plugin, key) {
      _classCallCheck(this, Plugin);
      _Store.call(this);
      this.initialized = false;
      this.raw = _lodashObjectAssign2["default"]({}, plugin);
      this.key = key;
      this.manipulateOptions = this.take("manipulateOptions");
      this.post = this.take("post");
      this.pre = this.take("pre");
      this.visitor = this.normaliseVisitor(_lodashLangClone2["default"](this.take("visitor")) || {});
    }
    Plugin.prototype.take = function take(key) {
      var val = this.raw[key];
      delete this.raw[key];
      return val;
    };
    Plugin.prototype.chain = function chain(target, key) {
      if (!target[key])
        return this[key];
      if (!this[key])
        return target[key];
      var fns = [target[key], this[key]];
      return function() {
        var val = undefined;
        for (var _len = arguments.length,
            args = Array(_len),
            _key = 0; _key < _len; _key++) {
          args[_key] = arguments[_key];
        }
        for (var _i = 0; _i < fns.length; _i++) {
          var fn = fns[_i];
          if (fn) {
            var ret = fn.apply(this, args);
            if (ret != null)
              val = ret;
          }
        }
        return val;
      };
    };
    Plugin.prototype.maybeInherit = function maybeInherit(loc) {
      var inherits = this.take("inherits");
      if (!inherits)
        return;
      inherits = _fileOptionsOptionManager2["default"].normalisePlugin(inherits, loc, "inherits");
      this.manipulateOptions = this.chain(inherits, "manipulateOptions");
      this.post = this.chain(inherits, "post");
      this.pre = this.chain(inherits, "pre");
      this.visitor = _babelTraverse2["default"].visitors.merge([inherits.visitor, this.visitor]);
    };
    Plugin.prototype.init = function init(loc, i) {
      if (this.initialized)
        return;
      this.initialized = true;
      this.maybeInherit(loc);
      for (var key in this.raw) {
        throw new Error(messages.get("pluginInvalidProperty", loc, i, key));
      }
    };
    Plugin.prototype.normaliseVisitor = function normaliseVisitor(visitor) {
      for (var _iterator = GLOBAL_VISITOR_PROPS,
          _isArray = Array.isArray(_iterator),
          _i2 = 0,
          _iterator = _isArray ? _iterator : _getIterator(_iterator); ; ) {
        var _ref;
        if (_isArray) {
          if (_i2 >= _iterator.length)
            break;
          _ref = _iterator[_i2++];
        } else {
          _i2 = _iterator.next();
          if (_i2.done)
            break;
          _ref = _i2.value;
        }
        var key = _ref;
        if (visitor[key]) {
          throw new Error("Plugins aren't allowed to specify catch-all enter/exit handlers. Please target individual nodes.");
        }
      }
      _babelTraverse2["default"].explode(visitor);
      return visitor;
    };
    return Plugin;
  })(_store2["default"]);
  exports["default"] = Plugin;
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("6a", ["a", "4", "7", "5", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireDefault = $__require('a')["default"];
  var _interopRequireWildcard = $__require('4')["default"];
  exports.__esModule = true;
  var _plugin = $__require('7');
  var _plugin2 = _interopRequireDefault(_plugin);
  var _babelTypes = $__require('5');
  var t = _interopRequireWildcard(_babelTypes);
  exports["default"] = new _plugin2["default"]({visitor: {
      ThisExpression: function ThisExpression(path) {
        remap(path, "this", function() {
          return t.thisExpression();
        });
      },
      ReferencedIdentifier: function ReferencedIdentifier(path) {
        if (path.node.name === "arguments") {
          remap(path, "arguments", function() {
            return t.identifier("arguments");
          });
        }
      }
    }});
  function shouldShadow(path, shadowPath) {
    if (path.is("_forceShadow")) {
      return true;
    } else {
      return shadowPath;
    }
  }
  function remap(path, key, create) {
    var shadowPath = path.inShadow(key);
    if (!shouldShadow(path, shadowPath))
      return;
    var shadowFunction = path.node._shadowedFunctionLiteral;
    var currentFunction = undefined;
    var passedShadowFunction = false;
    var fnPath = path.findParent(function(path) {
      if (path.isProgram() || path.isFunction()) {
        currentFunction = currentFunction || path;
      }
      if (path.isProgram()) {
        passedShadowFunction = true;
        return true;
      } else if (path.isFunction() && !path.isArrowFunctionExpression()) {
        if (shadowFunction) {
          if (path === shadowFunction || path.node === shadowFunction.node)
            return true;
        } else {
          if (!path.is("shadow"))
            return true;
        }
        passedShadowFunction = true;
        return false;
      }
      return false;
    });
    if (shadowFunction && fnPath.isProgram() && !shadowFunction.isProgram()) {
      fnPath = path.findParent(function(p) {
        return p.isProgram() || p.isFunction();
      });
    }
    if (fnPath === currentFunction)
      return;
    if (!passedShadowFunction)
      return;
    var cached = fnPath.getData(key);
    if (cached)
      return path.replaceWith(cached);
    var init = create();
    var id = path.scope.generateUidIdentifier(key);
    fnPath.setData(key, id);
    fnPath.scope.push({
      id: id,
      init: init
    });
    return path.replaceWith(id);
  }
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("8", ["f", "9", "49", "6b", "a", "4", "6c", "b", "c", "47", "d", "11", "10", "6d", "6e", "6f", "70", "12", "e", "71", "27", "@node/path", "5", "1b", "6a", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _inherits = $__require('f')["default"];
  var _classCallCheck = $__require('9')["default"];
  var _Object$assign = $__require('49')["default"];
  var _Object$create = $__require('6b')["default"];
  var _interopRequireDefault = $__require('a')["default"];
  var _interopRequireWildcard = $__require('4')["default"];
  exports.__esModule = true;
  var _babelHelpers = $__require('6c');
  var _babelHelpers2 = _interopRequireDefault(_babelHelpers);
  var _metadata = $__require('b');
  var metadataVisitor = _interopRequireWildcard(_metadata);
  var _convertSourceMap = $__require('c');
  var _convertSourceMap2 = _interopRequireDefault(_convertSourceMap);
  var _optionsOptionManager = $__require('47');
  var _optionsOptionManager2 = _interopRequireDefault(_optionsOptionManager);
  var _pluginPass = $__require('d');
  var _pluginPass2 = _interopRequireDefault(_pluginPass);
  var _shebangRegex = $__require('11');
  var _shebangRegex2 = _interopRequireDefault(_shebangRegex);
  var _babelTraverse = $__require('10');
  var _sourceMap = $__require('6d');
  var _sourceMap2 = _interopRequireDefault(_sourceMap);
  var _babelGenerator = $__require('6e');
  var _babelGenerator2 = _interopRequireDefault(_babelGenerator);
  var _babelCodeFrame = $__require('6f');
  var _babelCodeFrame2 = _interopRequireDefault(_babelCodeFrame);
  var _lodashObjectDefaults = $__require('70');
  var _lodashObjectDefaults2 = _interopRequireDefault(_lodashObjectDefaults);
  var _babelTraverse2 = _interopRequireDefault(_babelTraverse);
  var _logger = $__require('12');
  var _logger2 = _interopRequireDefault(_logger);
  var _store = $__require('e');
  var _store2 = _interopRequireDefault(_store);
  var _babylon = $__require('71');
  var _util = $__require('27');
  var util = _interopRequireWildcard(_util);
  var _path = $__require('@node/path');
  var _path2 = _interopRequireDefault(_path);
  var _babelTypes = $__require('5');
  var t = _interopRequireWildcard(_babelTypes);
  var _internalPluginsBlockHoist = $__require('1b');
  var _internalPluginsBlockHoist2 = _interopRequireDefault(_internalPluginsBlockHoist);
  var _internalPluginsShadowFunctions = $__require('6a');
  var _internalPluginsShadowFunctions2 = _interopRequireDefault(_internalPluginsShadowFunctions);
  var INTERNAL_PLUGINS = [[_internalPluginsBlockHoist2["default"]], [_internalPluginsShadowFunctions2["default"]]];
  var errorVisitor = {enter: function enter(path, state) {
      var loc = path.node.loc;
      if (loc) {
        state.loc = loc;
        path.stop();
      }
    }};
  var File = (function(_Store) {
    _inherits(File, _Store);
    function File(opts, pipeline) {
      var _this = this;
      if (opts === undefined)
        opts = {};
      _classCallCheck(this, File);
      _Store.call(this);
      this.pipeline = pipeline;
      this.log = new _logger2["default"](this, opts.filename || "unknown");
      this.opts = this.initOptions(opts);
      this.parserOpts = {
        highlightCode: this.opts.highlightCode,
        nonStandard: this.opts.nonStandard,
        sourceType: this.opts.sourceType,
        filename: this.opts.filename,
        plugins: []
      };
      this.pluginVisitors = [];
      this.pluginPasses = [];
      this.buildPluginsForOptions(this.opts);
      if (this.opts.passPerPreset) {
        this.perPresetOpts = [];
        this.opts.presets.forEach(function(presetOpts) {
          var perPresetOpts = _Object$assign(_Object$create(_this.opts), presetOpts);
          _this.perPresetOpts.push(perPresetOpts);
          _this.buildPluginsForOptions(perPresetOpts);
        });
      }
      this.metadata = {
        usedHelpers: [],
        marked: [],
        modules: {
          imports: [],
          exports: {
            exported: [],
            specifiers: []
          }
        }
      };
      this.dynamicImportTypes = {};
      this.dynamicImportIds = {};
      this.dynamicImports = [];
      this.declarations = {};
      this.usedHelpers = {};
      this.path = null;
      this.ast = {};
      this.code = "";
      this.shebang = "";
      this.hub = new _babelTraverse.Hub(this);
    }
    File.prototype.getMetadata = function getMetadata() {
      var has = false;
      var _arr = this.ast.program.body;
      for (var _i = 0; _i < _arr.length; _i++) {
        var node = _arr[_i];
        if (t.isModuleDeclaration(node)) {
          has = true;
          break;
        }
      }
      if (has) {
        this.path.traverse(metadataVisitor, this);
      }
    };
    File.prototype.initOptions = function initOptions(opts) {
      opts = new _optionsOptionManager2["default"](this.log, this.pipeline).init(opts);
      if (opts.inputSourceMap) {
        opts.sourceMaps = true;
      }
      if (opts.moduleId) {
        opts.moduleIds = true;
      }
      opts.basename = _path2["default"].basename(opts.filename, _path2["default"].extname(opts.filename));
      opts.ignore = util.arrayify(opts.ignore, util.regexify);
      if (opts.only)
        opts.only = util.arrayify(opts.only, util.regexify);
      _lodashObjectDefaults2["default"](opts, {moduleRoot: opts.sourceRoot});
      _lodashObjectDefaults2["default"](opts, {sourceRoot: opts.moduleRoot});
      _lodashObjectDefaults2["default"](opts, {filenameRelative: opts.filename});
      var basenameRelative = _path2["default"].basename(opts.filenameRelative);
      _lodashObjectDefaults2["default"](opts, {
        sourceFileName: basenameRelative,
        sourceMapTarget: basenameRelative
      });
      return opts;
    };
    File.prototype.buildPluginsForOptions = function buildPluginsForOptions(opts) {
      if (!Array.isArray(opts.plugins)) {
        return;
      }
      var plugins = opts.plugins.concat(INTERNAL_PLUGINS);
      var currentPluginVisitors = [];
      var currentPluginPasses = [];
      for (var _i2 = 0; _i2 < plugins.length; _i2++) {
        var ref = plugins[_i2];
        var plugin = ref[0];
        var pluginOpts = ref[1];
        currentPluginVisitors.push(plugin.visitor);
        currentPluginPasses.push(new _pluginPass2["default"](this, plugin, pluginOpts));
        if (plugin.manipulateOptions) {
          plugin.manipulateOptions(opts, this.parserOpts, this);
        }
      }
      this.pluginVisitors.push(currentPluginVisitors);
      this.pluginPasses.push(currentPluginPasses);
    };
    File.prototype.getModuleName = function getModuleName() {
      var opts = this.opts;
      if (!opts.moduleIds) {
        return null;
      }
      if (opts.moduleId != null && !opts.getModuleId) {
        return opts.moduleId;
      }
      var filenameRelative = opts.filenameRelative;
      var moduleName = "";
      if (opts.moduleRoot != null) {
        moduleName = opts.moduleRoot + "/";
      }
      if (!opts.filenameRelative) {
        return moduleName + opts.filename.replace(/^\//, "");
      }
      if (opts.sourceRoot != null) {
        var sourceRootRegEx = new RegExp("^" + opts.sourceRoot + "\/?");
        filenameRelative = filenameRelative.replace(sourceRootRegEx, "");
      }
      filenameRelative = filenameRelative.replace(/\.(\w*?)$/, "");
      moduleName += filenameRelative;
      moduleName = moduleName.replace(/\\/g, "/");
      if (opts.getModuleId) {
        return opts.getModuleId(moduleName) || moduleName;
      } else {
        return moduleName;
      }
    };
    File.prototype.resolveModuleSource = function resolveModuleSource(source) {
      var resolveModuleSource = this.opts.resolveModuleSource;
      if (resolveModuleSource)
        source = resolveModuleSource(source, this.opts.filename);
      return source;
    };
    File.prototype.addImport = function addImport(source, imported) {
      var name = arguments.length <= 2 || arguments[2] === undefined ? imported : arguments[2];
      return (function() {
        var alias = source + ":" + imported;
        var id = this.dynamicImportIds[alias];
        if (!id) {
          source = this.resolveModuleSource(source);
          id = this.dynamicImportIds[alias] = this.scope.generateUidIdentifier(name);
          var specifiers = [];
          if (imported === "*") {
            specifiers.push(t.importNamespaceSpecifier(id));
          } else if (imported === "default") {
            specifiers.push(t.importDefaultSpecifier(id));
          } else {
            specifiers.push(t.importSpecifier(id, t.identifier(imported)));
          }
          var declar = t.importDeclaration(specifiers, t.stringLiteral(source));
          declar._blockHoist = 3;
          this.path.unshiftContainer("body", declar);
        }
        return id;
      }).apply(this, arguments);
    };
    File.prototype.addHelper = function addHelper(name) {
      var declar = this.declarations[name];
      if (declar)
        return declar;
      if (!this.usedHelpers[name]) {
        this.metadata.usedHelpers.push(name);
        this.usedHelpers[name] = true;
      }
      var generator = this.get("helperGenerator");
      var runtime = this.get("helpersNamespace");
      if (generator) {
        var res = generator(name);
        if (res)
          return res;
      } else if (runtime) {
        return t.memberExpression(runtime, t.identifier(name));
      }
      var ref = _babelHelpers2["default"](name);
      var uid = this.declarations[name] = this.scope.generateUidIdentifier(name);
      if (t.isFunctionExpression(ref) && !ref.id) {
        ref.body._compact = true;
        ref._generated = true;
        ref.id = uid;
        ref.type = "FunctionDeclaration";
        this.path.unshiftContainer("body", ref);
      } else {
        ref._compact = true;
        this.scope.push({
          id: uid,
          init: ref,
          unique: true
        });
      }
      return uid;
    };
    File.prototype.addTemplateObject = function addTemplateObject(helperName, strings, raw) {
      var stringIds = raw.elements.map(function(string) {
        return string.value;
      });
      var name = helperName + "_" + raw.elements.length + "_" + stringIds.join(",");
      var declar = this.declarations[name];
      if (declar)
        return declar;
      var uid = this.declarations[name] = this.scope.generateUidIdentifier("templateObject");
      var helperId = this.addHelper(helperName);
      var init = t.callExpression(helperId, [strings, raw]);
      init._compact = true;
      this.scope.push({
        id: uid,
        init: init,
        _blockHoist: 1.9
      });
      return uid;
    };
    File.prototype.buildCodeFrameError = function buildCodeFrameError(node, msg) {
      var Error = arguments.length <= 2 || arguments[2] === undefined ? SyntaxError : arguments[2];
      var loc = node && (node.loc || node._loc);
      var err = new Error(msg);
      if (loc) {
        err.loc = loc.start;
      } else {
        _babelTraverse2["default"](node, errorVisitor, this.scope, err);
        err.message += " (This is an error on an internal node. Probably an internal error";
        if (err.loc) {
          err.message += ". Location has been estimated.";
        }
        err.message += ")";
      }
      return err;
    };
    File.prototype.mergeSourceMap = function mergeSourceMap(map) {
      var inputMap = this.opts.inputSourceMap;
      if (inputMap) {
        var _ret = (function() {
          var inputMapConsumer = new _sourceMap2["default"].SourceMapConsumer(inputMap);
          var outputMapConsumer = new _sourceMap2["default"].SourceMapConsumer(map);
          var mergedGenerator = new _sourceMap2["default"].SourceMapGenerator({
            file: inputMapConsumer.file,
            sourceRoot: inputMapConsumer.sourceRoot
          });
          var source = outputMapConsumer.sources[0];
          inputMapConsumer.eachMapping(function(mapping) {
            var generatedPosition = outputMapConsumer.generatedPositionFor({
              line: mapping.generatedLine,
              column: mapping.generatedColumn,
              source: source
            });
            if (generatedPosition.column != null) {
              mergedGenerator.addMapping({
                source: mapping.source,
                original: {
                  line: mapping.originalLine,
                  column: mapping.originalColumn
                },
                generated: generatedPosition
              });
            }
          });
          var mergedMap = mergedGenerator.toJSON();
          inputMap.mappings = mergedMap.mappings;
          return {v: inputMap};
        })();
        if (typeof _ret === "object")
          return _ret.v;
      } else {
        return map;
      }
    };
    File.prototype.parse = function parse(code) {
      this.log.debug("Parse start");
      var ast = _babylon.parse(code, this.parserOpts);
      this.log.debug("Parse stop");
      return ast;
    };
    File.prototype._addAst = function _addAst(ast) {
      this.path = _babelTraverse.NodePath.get({
        hub: this.hub,
        parentPath: null,
        parent: ast,
        container: ast,
        key: "program"
      }).setContext();
      this.scope = this.path.scope;
      this.ast = ast;
      this.getMetadata();
    };
    File.prototype.addAst = function addAst(ast) {
      this.log.debug("Start set AST");
      this._addAst(ast);
      this.log.debug("End set AST");
    };
    File.prototype.transform = function transform() {
      var _this2 = this;
      this.pluginPasses.forEach(function(pluginPasses, index) {
        _this2.call("pre", pluginPasses);
        _this2.log.debug("Start transform traverse");
        _babelTraverse2["default"](_this2.ast, _babelTraverse2["default"].visitors.merge(_this2.pluginVisitors[index], pluginPasses), _this2.scope);
        _this2.log.debug("End transform traverse");
        _this2.call("post", pluginPasses);
      });
      return this.generate();
    };
    File.prototype.wrap = function wrap(code, callback) {
      code = code + "";
      try {
        if (this.shouldIgnore()) {
          return this.makeResult({
            code: code,
            ignored: true
          });
        } else {
          return callback();
        }
      } catch (err) {
        if (err._babel) {
          throw err;
        } else {
          err._babel = true;
        }
        var message = err.message = this.opts.filename + ": " + err.message;
        var loc = err.loc;
        if (loc) {
          err.codeFrame = _babelCodeFrame2["default"](code, loc.line, loc.column + 1, this.opts);
          message += "\n" + err.codeFrame;
        }
        if (process.browser) {
          err.message = message;
        }
        if (err.stack) {
          var newStack = err.stack.replace(err.message, message);
          err.stack = newStack;
        }
        throw err;
      }
    };
    File.prototype.addCode = function addCode(code) {
      code = (code || "") + "";
      code = this.parseInputSourceMap(code);
      this.code = code;
    };
    File.prototype.parseCode = function parseCode() {
      this.parseShebang();
      var ast = this.parse(this.code);
      this.addAst(ast);
    };
    File.prototype.shouldIgnore = function shouldIgnore() {
      var opts = this.opts;
      return util.shouldIgnore(opts.filename, opts.ignore, opts.only);
    };
    File.prototype.call = function call(key, pluginPasses) {
      for (var _i3 = 0; _i3 < pluginPasses.length; _i3++) {
        var pass = pluginPasses[_i3];
        var plugin = pass.plugin;
        var fn = plugin[key];
        if (fn)
          fn.call(pass, this);
      }
    };
    File.prototype.parseInputSourceMap = function parseInputSourceMap(code) {
      var opts = this.opts;
      if (opts.inputSourceMap !== false) {
        var inputMap = _convertSourceMap2["default"].fromSource(code);
        if (inputMap) {
          opts.inputSourceMap = inputMap.toObject();
          code = _convertSourceMap2["default"].removeComments(code);
        }
      }
      return code;
    };
    File.prototype.parseShebang = function parseShebang() {
      var shebangMatch = _shebangRegex2["default"].exec(this.code);
      if (shebangMatch) {
        this.shebang = shebangMatch[0];
        this.code = this.code.replace(_shebangRegex2["default"], "");
      }
    };
    File.prototype.makeResult = function makeResult(_ref) {
      var code = _ref.code;
      var map = _ref.map;
      var ast = _ref.ast;
      var ignored = _ref.ignored;
      var result = {
        metadata: null,
        options: this.opts,
        ignored: !!ignored,
        code: null,
        ast: null,
        map: map || null
      };
      if (this.opts.code) {
        result.code = code;
      }
      if (this.opts.ast) {
        result.ast = ast;
      }
      if (this.opts.metadata) {
        result.metadata = this.metadata;
      }
      return result;
    };
    File.prototype.generate = function generate() {
      var opts = this.opts;
      var ast = this.ast;
      var result = {ast: ast};
      if (!opts.code)
        return this.makeResult(result);
      this.log.debug("Generation start");
      var _result = _babelGenerator2["default"](ast, opts, this.code);
      result.code = _result.code;
      result.map = _result.map;
      this.log.debug("Generation end");
      if (this.shebang) {
        result.code = this.shebang + "\n" + result.code;
      }
      if (result.map) {
        result.map = this.mergeSourceMap(result.map);
      }
      if (opts.sourceMaps === "inline" || opts.sourceMaps === "both") {
        result.code += "\n" + _convertSourceMap2["default"].fromObject(result.map).toComment();
      }
      if (opts.sourceMaps === "inline") {
        result.map = null;
      }
      return this.makeResult(result);
    };
    return File;
  })(_store2["default"]);
  exports["default"] = File;
  exports.File = File;
  return module.exports;
});

$__System.registerDynamic("2d", ["3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  module.exports = {
    filename: {
      type: "filename",
      description: "filename to use when reading from stdin - this will be used in source-maps, errors etc",
      "default": "unknown",
      shorthand: "f"
    },
    filenameRelative: {
      hidden: true,
      type: "string"
    },
    inputSourceMap: {hidden: true},
    env: {
      hidden: true,
      "default": {}
    },
    mode: {
      description: "",
      hidden: true
    },
    retainLines: {
      type: "boolean",
      "default": false,
      description: "retain line numbers - will result in really ugly code"
    },
    highlightCode: {
      description: "enable/disable ANSI syntax highlighting of code frames (on by default)",
      type: "boolean",
      "default": true
    },
    suppressDeprecationMessages: {
      type: "boolean",
      "default": false,
      hidden: true
    },
    presets: {
      type: "list",
      description: "",
      "default": []
    },
    plugins: {
      type: "list",
      "default": [],
      description: ""
    },
    ignore: {
      type: "list",
      description: "list of glob paths to **not** compile",
      "default": []
    },
    only: {
      type: "list",
      description: "list of glob paths to **only** compile"
    },
    code: {
      hidden: true,
      "default": true,
      type: "boolean"
    },
    metadata: {
      hidden: true,
      "default": true,
      type: "boolean"
    },
    ast: {
      hidden: true,
      "default": true,
      type: "boolean"
    },
    "extends": {
      type: "string",
      hidden: true
    },
    comments: {
      type: "boolean",
      "default": true,
      description: "write comments to generated output (true by default)"
    },
    shouldPrintComment: {
      hidden: true,
      description: "optional callback to control whether a comment should be inserted, when this is used the comments option is ignored"
    },
    compact: {
      type: "booleanString",
      "default": "auto",
      description: "do not include superfluous whitespace characters and line terminators [true|false|auto]"
    },
    minified: {
      type: "boolean",
      "default": false,
      description: "save as much bytes when printing [true|false]"
    },
    sourceMap: {
      alias: "sourceMaps",
      hidden: true
    },
    sourceMaps: {
      type: "booleanString",
      description: "[true|false|inline]",
      "default": false,
      shorthand: "s"
    },
    sourceMapTarget: {
      type: "string",
      description: "set `file` on returned source map"
    },
    sourceFileName: {
      type: "string",
      description: "set `sources[0]` on returned source map"
    },
    sourceRoot: {
      type: "filename",
      description: "the root from which all sources are relative"
    },
    babelrc: {
      description: "Whether or not to look up .babelrc and .babelignore files",
      type: "boolean",
      "default": true
    },
    sourceType: {
      description: "",
      "default": "module"
    },
    auxiliaryCommentBefore: {
      type: "string",
      description: "print a comment before any injected non-user code"
    },
    auxiliaryCommentAfter: {
      type: "string",
      description: "print a comment after any injected non-user code"
    },
    resolveModuleSource: {hidden: true},
    getModuleId: {hidden: true},
    moduleRoot: {
      type: "filename",
      description: "optional prefix for the AMD module formatter that will be prepend to the filename on module definitions"
    },
    moduleIds: {
      type: "boolean",
      "default": false,
      shorthand: "M",
      description: "insert an explicit id for modules"
    },
    moduleId: {
      description: "specify a custom name for module ids",
      type: "string"
    },
    passPerPreset: {
      description: "Whether to spawn a traversal pass per a preset. By default all presets are merged.",
      type: "boolean",
      "default": false,
      hidden: true
    }
  };
  return module.exports;
});

$__System.registerDynamic("72", ["a", "73"], true, function($__require, exports, module) {
  "use strict";
  ;
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireDefault = $__require('a')["default"];
  exports.__esModule = true;
  var _babelTemplate = $__require('73');
  var _babelTemplate2 = _interopRequireDefault(_babelTemplate);
  var helpers = {};
  exports["default"] = helpers;
  helpers["typeof"] = _babelTemplate2["default"]("\n  (typeof Symbol === \"function\" && typeof Symbol.iterator === \"symbol\")\n    ? function (obj) { return typeof obj; }\n    : function (obj) { return obj && typeof Symbol === \"function\" && obj.constructor === Symbol ? \"symbol\" : typeof obj; };\n");
  helpers.jsx = _babelTemplate2["default"]("\n  (function () {\n    var REACT_ELEMENT_TYPE = (typeof Symbol === \"function\" && Symbol.for && Symbol.for(\"react.element\")) || 0xeac7;\n\n    return function createRawReactElement (type, props, key, children) {\n      var defaultProps = type && type.defaultProps;\n      var childrenLength = arguments.length - 3;\n\n      if (!props && childrenLength !== 0) {\n        // If we're going to assign props.children, we create a new object now\n        // to avoid mutating defaultProps.\n        props = {};\n      }\n      if (props && defaultProps) {\n        for (var propName in defaultProps) {\n          if (props[propName] === void 0) {\n            props[propName] = defaultProps[propName];\n          }\n        }\n      } else if (!props) {\n        props = defaultProps || {};\n      }\n\n      if (childrenLength === 1) {\n        props.children = children;\n      } else if (childrenLength > 1) {\n        var childArray = Array(childrenLength);\n        for (var i = 0; i < childrenLength; i++) {\n          childArray[i] = arguments[i + 3];\n        }\n        props.children = childArray;\n      }\n\n      return {\n        $$typeof: REACT_ELEMENT_TYPE,\n        type: type,\n        key: key === undefined ? null : '' + key,\n        ref: null,\n        props: props,\n        _owner: null,\n      };\n    };\n\n  })()\n");
  helpers.asyncToGenerator = _babelTemplate2["default"]("\n  (function (fn) {\n    return function () {\n      var gen = fn.apply(this, arguments);\n      return new Promise(function (resolve, reject) {\n        function step(key, arg) {\n          try {\n            var info = gen[key](arg);\n            var value = info.value;\n          } catch (error) {\n            reject(error);\n            return;\n          }\n\n          if (info.done) {\n            resolve(value);\n          } else {\n            return Promise.resolve(value).then(function (value) {\n              return step(\"next\", value);\n            }, function (err) {\n              return step(\"throw\", err);\n            });\n          }\n        }\n\n        return step(\"next\");\n      });\n    };\n  })\n");
  helpers.classCallCheck = _babelTemplate2["default"]("\n  (function (instance, Constructor) {\n    if (!(instance instanceof Constructor)) {\n      throw new TypeError(\"Cannot call a class as a function\");\n    }\n  });\n");
  helpers.createClass = _babelTemplate2["default"]("\n  (function() {\n    function defineProperties(target, props) {\n      for (var i = 0; i < props.length; i ++) {\n        var descriptor = props[i];\n        descriptor.enumerable = descriptor.enumerable || false;\n        descriptor.configurable = true;\n        if (\"value\" in descriptor) descriptor.writable = true;\n        Object.defineProperty(target, descriptor.key, descriptor);\n      }\n    }\n\n    return function (Constructor, protoProps, staticProps) {\n      if (protoProps) defineProperties(Constructor.prototype, protoProps);\n      if (staticProps) defineProperties(Constructor, staticProps);\n      return Constructor;\n    };\n  })()\n");
  helpers.defineEnumerableProperties = _babelTemplate2["default"]("\n  (function (obj, descs) {\n    for (var key in descs) {\n      var desc = descs[key];\n      desc.configurable = desc.enumerable = true;\n      if (\"value\" in desc) desc.writable = true;\n      Object.defineProperty(obj, key, desc);\n    }\n    return obj;\n  })\n");
  helpers.defaults = _babelTemplate2["default"]("\n  (function (obj, defaults) {\n    var keys = Object.getOwnPropertyNames(defaults);\n    for (var i = 0; i < keys.length; i++) {\n      var key = keys[i];\n      var value = Object.getOwnPropertyDescriptor(defaults, key);\n      if (value && value.configurable && obj[key] === undefined) {\n        Object.defineProperty(obj, key, value);\n      }\n    }\n    return obj;\n  })\n");
  helpers.defineProperty = _babelTemplate2["default"]("\n  (function (obj, key, value) {\n    // Shortcircuit the slow defineProperty path when possible.\n    // We are trying to avoid issues where setters defined on the\n    // prototype cause side effects under the fast path of simple\n    // assignment. By checking for existence of the property with\n    // the in operator, we can optimize most of this overhead away.\n    if (key in obj) {\n      Object.defineProperty(obj, key, {\n        value: value,\n        enumerable: true,\n        configurable: true,\n        writable: true\n      });\n    } else {\n      obj[key] = value;\n    }\n    return obj;\n  });\n");
  helpers["extends"] = _babelTemplate2["default"]("\n  Object.assign || (function (target) {\n    for (var i = 1; i < arguments.length; i++) {\n      var source = arguments[i];\n      for (var key in source) {\n        if (Object.prototype.hasOwnProperty.call(source, key)) {\n          target[key] = source[key];\n        }\n      }\n    }\n    return target;\n  })\n");
  helpers.get = _babelTemplate2["default"]("\n  (function get(object, property, receiver) {\n    if (object === null) object = Function.prototype;\n\n    var desc = Object.getOwnPropertyDescriptor(object, property);\n\n    if (desc === undefined) {\n      var parent = Object.getPrototypeOf(object);\n\n      if (parent === null) {\n        return undefined;\n      } else {\n        return get(parent, property, receiver);\n      }\n    } else if (\"value\" in desc) {\n      return desc.value;\n    } else {\n      var getter = desc.get;\n\n      if (getter === undefined) {\n        return undefined;\n      }\n\n      return getter.call(receiver);\n    }\n  });\n");
  helpers.inherits = _babelTemplate2["default"]("\n  (function (subClass, superClass) {\n    if (typeof superClass !== \"function\" && superClass !== null) {\n      throw new TypeError(\"Super expression must either be null or a function, not \" + typeof superClass);\n    }\n    subClass.prototype = Object.create(superClass && superClass.prototype, {\n      constructor: {\n        value: subClass,\n        enumerable: false,\n        writable: true,\n        configurable: true\n      }\n    });\n    if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;\n  })\n");
  helpers["instanceof"] = _babelTemplate2["default"]("\n  (function (left, right) {\n    if (right != null && typeof Symbol !== \"undefined\" && right[Symbol.hasInstance]) {\n      return right[Symbol.hasInstance](left);\n    } else {\n      return left instanceof right;\n    }\n  });\n");
  helpers.interopRequireDefault = _babelTemplate2["default"]("\n  (function (obj) {\n    return obj && obj.__esModule ? obj : { default: obj };\n  })\n");
  helpers.interopRequireWildcard = _babelTemplate2["default"]("\n  (function (obj) {\n    if (obj && obj.__esModule) {\n      return obj;\n    } else {\n      var newObj = {};\n      if (obj != null) {\n        for (var key in obj) {\n          if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];\n        }\n      }\n      newObj.default = obj;\n      return newObj;\n    }\n  })\n");
  helpers.newArrowCheck = _babelTemplate2["default"]("\n  (function (innerThis, boundThis) {\n    if (innerThis !== boundThis) {\n      throw new TypeError(\"Cannot instantiate an arrow function\");\n    }\n  });\n");
  helpers.objectDestructuringEmpty = _babelTemplate2["default"]("\n  (function (obj) {\n    if (obj == null) throw new TypeError(\"Cannot destructure undefined\");\n  });\n");
  helpers.objectWithoutProperties = _babelTemplate2["default"]("\n  (function (obj, keys) {\n    var target = {};\n    for (var i in obj) {\n      if (keys.indexOf(i) >= 0) continue;\n      if (!Object.prototype.hasOwnProperty.call(obj, i)) continue;\n      target[i] = obj[i];\n    }\n    return target;\n  })\n");
  helpers.possibleConstructorReturn = _babelTemplate2["default"]("\n  (function (self, call) {\n    if (!self) {\n      throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\");\n    }\n    return call && (typeof call === \"object\" || typeof call === \"function\") ? call : self;\n  });\n");
  helpers.selfGlobal = _babelTemplate2["default"]("\n  typeof global === \"undefined\" ? self : global\n");
  helpers.set = _babelTemplate2["default"]("\n  (function set(object, property, value, receiver) {\n    var desc = Object.getOwnPropertyDescriptor(object, property);\n\n    if (desc === undefined) {\n      var parent = Object.getPrototypeOf(object);\n\n      if (parent !== null) {\n        set(parent, property, value, receiver);\n      }\n    } else if (\"value\" in desc && desc.writable) {\n      desc.value = value;\n    } else {\n      var setter = desc.set;\n\n      if (setter !== undefined) {\n        setter.call(receiver, value);\n      }\n    }\n\n    return value;\n  });\n");
  helpers.slicedToArray = _babelTemplate2["default"]("\n  (function () {\n    // Broken out into a separate function to avoid deoptimizations due to the try/catch for the\n    // array iterator case.\n    function sliceIterator(arr, i) {\n      // this is an expanded form of `for...of` that properly supports abrupt completions of\n      // iterators etc. variable names have been minimised to reduce the size of this massive\n      // helper. sometimes spec compliancy is annoying :(\n      //\n      // _n = _iteratorNormalCompletion\n      // _d = _didIteratorError\n      // _e = _iteratorError\n      // _i = _iterator\n      // _s = _step\n\n      var _arr = [];\n      var _n = true;\n      var _d = false;\n      var _e = undefined;\n      try {\n        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {\n          _arr.push(_s.value);\n          if (i && _arr.length === i) break;\n        }\n      } catch (err) {\n        _d = true;\n        _e = err;\n      } finally {\n        try {\n          if (!_n && _i[\"return\"]) _i[\"return\"]();\n        } finally {\n          if (_d) throw _e;\n        }\n      }\n      return _arr;\n    }\n\n    return function (arr, i) {\n      if (Array.isArray(arr)) {\n        return arr;\n      } else if (Symbol.iterator in Object(arr)) {\n        return sliceIterator(arr, i);\n      } else {\n        throw new TypeError(\"Invalid attempt to destructure non-iterable instance\");\n      }\n    };\n  })();\n");
  helpers.slicedToArrayLoose = _babelTemplate2["default"]("\n  (function (arr, i) {\n    if (Array.isArray(arr)) {\n      return arr;\n    } else if (Symbol.iterator in Object(arr)) {\n      var _arr = [];\n      for (var _iterator = arr[Symbol.iterator](), _step; !(_step = _iterator.next()).done;) {\n        _arr.push(_step.value);\n        if (i && _arr.length === i) break;\n      }\n      return _arr;\n    } else {\n      throw new TypeError(\"Invalid attempt to destructure non-iterable instance\");\n    }\n  });\n");
  helpers.taggedTemplateLiteral = _babelTemplate2["default"]("\n  (function (strings, raw) {\n    return Object.freeze(Object.defineProperties(strings, {\n        raw: { value: Object.freeze(raw) }\n    }));\n  });\n");
  helpers.taggedTemplateLiteralLoose = _babelTemplate2["default"]("\n  (function (strings, raw) {\n    strings.raw = raw;\n    return strings;\n  });\n");
  helpers.temporalRef = _babelTemplate2["default"]("\n  (function (val, name, undef) {\n    if (val === undef) {\n      throw new ReferenceError(name + \" is not defined - temporal dead zone\");\n    } else {\n      return val;\n    }\n  })\n");
  helpers.temporalUndefined = _babelTemplate2["default"]("\n  ({})\n");
  helpers.toArray = _babelTemplate2["default"]("\n  (function (arr) {\n    return Array.isArray(arr) ? arr : Array.from(arr);\n  });\n");
  helpers.toConsumableArray = _babelTemplate2["default"]("\n  (function (arr) {\n    if (Array.isArray(arr)) {\n      for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) arr2[i] = arr[i];\n      return arr2;\n    } else {\n      return Array.from(arr);\n    }\n  });\n");
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("6c", ["74", "a", "72"], true, function($__require, exports, module) {
  "use strict";
  ;
  var define,
      global = this,
      GLOBAL = this;
  var _Object$keys = $__require('74')["default"];
  var _interopRequireDefault = $__require('a')["default"];
  exports.__esModule = true;
  exports.get = get;
  var _helpers = $__require('72');
  var _helpers2 = _interopRequireDefault(_helpers);
  function get(name) {
    var fn = _helpers2["default"][name];
    if (!fn)
      throw new ReferenceError("Unknown helper " + name);
    return fn().expression;
  }
  var list = _Object$keys(_helpers2["default"]).map(function(name) {
    return name[0] === "_" ? name.slice(1) : name;
  }).filter(function(name) {
    return name !== "__esModule";
  });
  exports.list = list;
  exports["default"] = get;
  return module.exports;
});

$__System.registerDynamic("75", ["76", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var repeating = $__require('76');
  var INDENT_RE = /^(?:( )+|\t+)/;
  function getMostUsed(indents) {
    var result = 0;
    var maxUsed = 0;
    var maxWeight = 0;
    for (var n in indents) {
      var indent = indents[n];
      var u = indent[0];
      var w = indent[1];
      if (u > maxUsed || u === maxUsed && w > maxWeight) {
        maxUsed = u;
        maxWeight = w;
        result = +n;
      }
    }
    return result;
  }
  module.exports = function(str) {
    if (typeof str !== 'string') {
      throw new TypeError('Expected a string');
    }
    var tabs = 0;
    var spaces = 0;
    var prev = 0;
    var indents = {};
    var current;
    var isIndent;
    str.split(/\n/g).forEach(function(line) {
      if (!line) {
        return;
      }
      var indent;
      var matches = line.match(INDENT_RE);
      if (!matches) {
        indent = 0;
      } else {
        indent = matches[0].length;
        if (matches[1]) {
          spaces++;
        } else {
          tabs++;
        }
      }
      var diff = indent - prev;
      prev = indent;
      if (diff) {
        isIndent = diff > 0;
        current = indents[isIndent ? diff : -diff];
        if (current) {
          current[0]++;
        } else {
          current = indents[diff] = [1, 0];
        }
      } else if (current) {
        current[1] += +isIndent;
      }
    });
    var amount = getMostUsed(indents);
    var type;
    var actual;
    if (!amount) {
      type = null;
      actual = '';
    } else if (spaces >= tabs) {
      type = 'space';
      actual = repeating(' ', amount);
    } else {
      type = 'tab';
      actual = repeating('\t', amount);
    }
    return {
      amount: amount,
      type: type,
      indent: actual
    };
  };
  return module.exports;
});

$__System.registerDynamic("77", ["9", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _classCallCheck = $__require('9')["default"];
  exports.__esModule = true;
  var Whitespace = (function() {
    function Whitespace(tokens) {
      _classCallCheck(this, Whitespace);
      this.tokens = tokens;
      this.used = {};
    }
    Whitespace.prototype.getNewlinesBefore = function getNewlinesBefore(node) {
      var startToken = undefined;
      var endToken = undefined;
      var tokens = this.tokens;
      var index = this._findToken(function(token) {
        return token.start - node.start;
      }, 0, tokens.length);
      if (index >= 0) {
        while (index && node.start === tokens[index - 1].start)
          --index;
        startToken = tokens[index - 1];
        endToken = tokens[index];
      }
      return this.getNewlinesBetween(startToken, endToken);
    };
    Whitespace.prototype.getNewlinesAfter = function getNewlinesAfter(node) {
      var startToken = undefined;
      var endToken = undefined;
      var tokens = this.tokens;
      var index = this._findToken(function(token) {
        return token.end - node.end;
      }, 0, tokens.length);
      if (index >= 0) {
        while (index && node.end === tokens[index - 1].end)
          --index;
        startToken = tokens[index];
        endToken = tokens[index + 1];
        if (endToken.type.label === ",")
          endToken = tokens[index + 2];
      }
      if (endToken && endToken.type.label === "eof") {
        return 1;
      } else {
        var lines = this.getNewlinesBetween(startToken, endToken);
        if (node.type === "CommentLine" && !lines) {
          return 1;
        } else {
          return lines;
        }
      }
    };
    Whitespace.prototype.getNewlinesBetween = function getNewlinesBetween(startToken, endToken) {
      if (!endToken || !endToken.loc)
        return 0;
      var start = startToken ? startToken.loc.end.line : 1;
      var end = endToken.loc.start.line;
      var lines = 0;
      for (var line = start; line < end; line++) {
        if (typeof this.used[line] === "undefined") {
          this.used[line] = true;
          lines++;
        }
      }
      return lines;
    };
    Whitespace.prototype._findToken = function _findToken(test, start, end) {
      if (start >= end)
        return -1;
      var middle = start + end >>> 1;
      var match = test(this.tokens[middle]);
      if (match < 0) {
        return this._findToken(test, middle + 1, end);
      } else if (match > 0) {
        return this._findToken(test, start, middle);
      } else if (match === 0) {
        return middle;
      }
      return -1;
    };
    return Whitespace;
  })();
  exports["default"] = Whitespace;
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("78", ["3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  {
    exports.GREATEST_LOWER_BOUND = 1;
    exports.LEAST_UPPER_BOUND = 2;
    function recursiveSearch(aLow, aHigh, aNeedle, aHaystack, aCompare, aBias) {
      var mid = Math.floor((aHigh - aLow) / 2) + aLow;
      var cmp = aCompare(aNeedle, aHaystack[mid], true);
      if (cmp === 0) {
        return mid;
      } else if (cmp > 0) {
        if (aHigh - mid > 1) {
          return recursiveSearch(mid, aHigh, aNeedle, aHaystack, aCompare, aBias);
        }
        if (aBias == exports.LEAST_UPPER_BOUND) {
          return aHigh < aHaystack.length ? aHigh : -1;
        } else {
          return mid;
        }
      } else {
        if (mid - aLow > 1) {
          return recursiveSearch(aLow, mid, aNeedle, aHaystack, aCompare, aBias);
        }
        if (aBias == exports.LEAST_UPPER_BOUND) {
          return mid;
        } else {
          return aLow < 0 ? -1 : aLow;
        }
      }
    }
    exports.search = function search(aNeedle, aHaystack, aCompare, aBias) {
      if (aHaystack.length === 0) {
        return -1;
      }
      var index = recursiveSearch(-1, aHaystack.length, aNeedle, aHaystack, aCompare, aBias || exports.GREATEST_LOWER_BOUND);
      if (index < 0) {
        return -1;
      }
      while (index - 1 >= 0) {
        if (aCompare(aHaystack[index], aHaystack[index - 1], true) !== 0) {
          break;
        }
        --index;
      }
      return index;
    };
  }
  return module.exports;
});

$__System.registerDynamic("79", ["3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  {
    function swap(ary, x, y) {
      var temp = ary[x];
      ary[x] = ary[y];
      ary[y] = temp;
    }
    function randomIntInRange(low, high) {
      return Math.round(low + (Math.random() * (high - low)));
    }
    function doQuickSort(ary, comparator, p, r) {
      if (p < r) {
        var pivotIndex = randomIntInRange(p, r);
        var i = p - 1;
        swap(ary, pivotIndex, r);
        var pivot = ary[r];
        for (var j = p; j < r; j++) {
          if (comparator(ary[j], pivot) <= 0) {
            i += 1;
            swap(ary, i, j);
          }
        }
        swap(ary, i + 1, j);
        var q = i + 1;
        doQuickSort(ary, comparator, p, q - 1);
        doQuickSort(ary, comparator, q + 1, r);
      }
    }
    exports.quickSort = function(ary, comparator) {
      doQuickSort(ary, comparator, 0, ary.length - 1);
    };
  }
  return module.exports;
});

$__System.registerDynamic("7a", ["7b", "78", "7c", "7d", "79", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  {
    var util = $__require('7b');
    var binarySearch = $__require('78');
    var ArraySet = $__require('7c').ArraySet;
    var base64VLQ = $__require('7d');
    var quickSort = $__require('79').quickSort;
    function SourceMapConsumer(aSourceMap) {
      var sourceMap = aSourceMap;
      if (typeof aSourceMap === 'string') {
        sourceMap = JSON.parse(aSourceMap.replace(/^\)\]\}'/, ''));
      }
      return sourceMap.sections != null ? new IndexedSourceMapConsumer(sourceMap) : new BasicSourceMapConsumer(sourceMap);
    }
    SourceMapConsumer.fromSourceMap = function(aSourceMap) {
      return BasicSourceMapConsumer.fromSourceMap(aSourceMap);
    };
    SourceMapConsumer.prototype._version = 3;
    SourceMapConsumer.prototype.__generatedMappings = null;
    Object.defineProperty(SourceMapConsumer.prototype, '_generatedMappings', {get: function() {
        if (!this.__generatedMappings) {
          this._parseMappings(this._mappings, this.sourceRoot);
        }
        return this.__generatedMappings;
      }});
    SourceMapConsumer.prototype.__originalMappings = null;
    Object.defineProperty(SourceMapConsumer.prototype, '_originalMappings', {get: function() {
        if (!this.__originalMappings) {
          this._parseMappings(this._mappings, this.sourceRoot);
        }
        return this.__originalMappings;
      }});
    SourceMapConsumer.prototype._charIsMappingSeparator = function SourceMapConsumer_charIsMappingSeparator(aStr, index) {
      var c = aStr.charAt(index);
      return c === ";" || c === ",";
    };
    SourceMapConsumer.prototype._parseMappings = function SourceMapConsumer_parseMappings(aStr, aSourceRoot) {
      throw new Error("Subclasses must implement _parseMappings");
    };
    SourceMapConsumer.GENERATED_ORDER = 1;
    SourceMapConsumer.ORIGINAL_ORDER = 2;
    SourceMapConsumer.GREATEST_LOWER_BOUND = 1;
    SourceMapConsumer.LEAST_UPPER_BOUND = 2;
    SourceMapConsumer.prototype.eachMapping = function SourceMapConsumer_eachMapping(aCallback, aContext, aOrder) {
      var context = aContext || null;
      var order = aOrder || SourceMapConsumer.GENERATED_ORDER;
      var mappings;
      switch (order) {
        case SourceMapConsumer.GENERATED_ORDER:
          mappings = this._generatedMappings;
          break;
        case SourceMapConsumer.ORIGINAL_ORDER:
          mappings = this._originalMappings;
          break;
        default:
          throw new Error("Unknown order of iteration.");
      }
      var sourceRoot = this.sourceRoot;
      mappings.map(function(mapping) {
        var source = mapping.source === null ? null : this._sources.at(mapping.source);
        if (source != null && sourceRoot != null) {
          source = util.join(sourceRoot, source);
        }
        return {
          source: source,
          generatedLine: mapping.generatedLine,
          generatedColumn: mapping.generatedColumn,
          originalLine: mapping.originalLine,
          originalColumn: mapping.originalColumn,
          name: mapping.name === null ? null : this._names.at(mapping.name)
        };
      }, this).forEach(aCallback, context);
    };
    SourceMapConsumer.prototype.allGeneratedPositionsFor = function SourceMapConsumer_allGeneratedPositionsFor(aArgs) {
      var line = util.getArg(aArgs, 'line');
      var needle = {
        source: util.getArg(aArgs, 'source'),
        originalLine: line,
        originalColumn: util.getArg(aArgs, 'column', 0)
      };
      if (this.sourceRoot != null) {
        needle.source = util.relative(this.sourceRoot, needle.source);
      }
      if (!this._sources.has(needle.source)) {
        return [];
      }
      needle.source = this._sources.indexOf(needle.source);
      var mappings = [];
      var index = this._findMapping(needle, this._originalMappings, "originalLine", "originalColumn", util.compareByOriginalPositions, binarySearch.LEAST_UPPER_BOUND);
      if (index >= 0) {
        var mapping = this._originalMappings[index];
        if (aArgs.column === undefined) {
          var originalLine = mapping.originalLine;
          while (mapping && mapping.originalLine === originalLine) {
            mappings.push({
              line: util.getArg(mapping, 'generatedLine', null),
              column: util.getArg(mapping, 'generatedColumn', null),
              lastColumn: util.getArg(mapping, 'lastGeneratedColumn', null)
            });
            mapping = this._originalMappings[++index];
          }
        } else {
          var originalColumn = mapping.originalColumn;
          while (mapping && mapping.originalLine === line && mapping.originalColumn == originalColumn) {
            mappings.push({
              line: util.getArg(mapping, 'generatedLine', null),
              column: util.getArg(mapping, 'generatedColumn', null),
              lastColumn: util.getArg(mapping, 'lastGeneratedColumn', null)
            });
            mapping = this._originalMappings[++index];
          }
        }
      }
      return mappings;
    };
    exports.SourceMapConsumer = SourceMapConsumer;
    function BasicSourceMapConsumer(aSourceMap) {
      var sourceMap = aSourceMap;
      if (typeof aSourceMap === 'string') {
        sourceMap = JSON.parse(aSourceMap.replace(/^\)\]\}'/, ''));
      }
      var version = util.getArg(sourceMap, 'version');
      var sources = util.getArg(sourceMap, 'sources');
      var names = util.getArg(sourceMap, 'names', []);
      var sourceRoot = util.getArg(sourceMap, 'sourceRoot', null);
      var sourcesContent = util.getArg(sourceMap, 'sourcesContent', null);
      var mappings = util.getArg(sourceMap, 'mappings');
      var file = util.getArg(sourceMap, 'file', null);
      if (version != this._version) {
        throw new Error('Unsupported version: ' + version);
      }
      sources = sources.map(util.normalize).map(function(source) {
        return sourceRoot && util.isAbsolute(sourceRoot) && util.isAbsolute(source) ? util.relative(sourceRoot, source) : source;
      });
      this._names = ArraySet.fromArray(names, true);
      this._sources = ArraySet.fromArray(sources, true);
      this.sourceRoot = sourceRoot;
      this.sourcesContent = sourcesContent;
      this._mappings = mappings;
      this.file = file;
    }
    BasicSourceMapConsumer.prototype = Object.create(SourceMapConsumer.prototype);
    BasicSourceMapConsumer.prototype.consumer = SourceMapConsumer;
    BasicSourceMapConsumer.fromSourceMap = function SourceMapConsumer_fromSourceMap(aSourceMap) {
      var smc = Object.create(BasicSourceMapConsumer.prototype);
      var names = smc._names = ArraySet.fromArray(aSourceMap._names.toArray(), true);
      var sources = smc._sources = ArraySet.fromArray(aSourceMap._sources.toArray(), true);
      smc.sourceRoot = aSourceMap._sourceRoot;
      smc.sourcesContent = aSourceMap._generateSourcesContent(smc._sources.toArray(), smc.sourceRoot);
      smc.file = aSourceMap._file;
      var generatedMappings = aSourceMap._mappings.toArray().slice();
      var destGeneratedMappings = smc.__generatedMappings = [];
      var destOriginalMappings = smc.__originalMappings = [];
      for (var i = 0,
          length = generatedMappings.length; i < length; i++) {
        var srcMapping = generatedMappings[i];
        var destMapping = new Mapping;
        destMapping.generatedLine = srcMapping.generatedLine;
        destMapping.generatedColumn = srcMapping.generatedColumn;
        if (srcMapping.source) {
          destMapping.source = sources.indexOf(srcMapping.source);
          destMapping.originalLine = srcMapping.originalLine;
          destMapping.originalColumn = srcMapping.originalColumn;
          if (srcMapping.name) {
            destMapping.name = names.indexOf(srcMapping.name);
          }
          destOriginalMappings.push(destMapping);
        }
        destGeneratedMappings.push(destMapping);
      }
      quickSort(smc.__originalMappings, util.compareByOriginalPositions);
      return smc;
    };
    BasicSourceMapConsumer.prototype._version = 3;
    Object.defineProperty(BasicSourceMapConsumer.prototype, 'sources', {get: function() {
        return this._sources.toArray().map(function(s) {
          return this.sourceRoot != null ? util.join(this.sourceRoot, s) : s;
        }, this);
      }});
    function Mapping() {
      this.generatedLine = 0;
      this.generatedColumn = 0;
      this.source = null;
      this.originalLine = null;
      this.originalColumn = null;
      this.name = null;
    }
    BasicSourceMapConsumer.prototype._parseMappings = function SourceMapConsumer_parseMappings(aStr, aSourceRoot) {
      var generatedLine = 1;
      var previousGeneratedColumn = 0;
      var previousOriginalLine = 0;
      var previousOriginalColumn = 0;
      var previousSource = 0;
      var previousName = 0;
      var length = aStr.length;
      var index = 0;
      var cachedSegments = {};
      var temp = {};
      var originalMappings = [];
      var generatedMappings = [];
      var mapping,
          str,
          segment,
          end,
          value;
      while (index < length) {
        if (aStr.charAt(index) === ';') {
          generatedLine++;
          index++;
          previousGeneratedColumn = 0;
        } else if (aStr.charAt(index) === ',') {
          index++;
        } else {
          mapping = new Mapping();
          mapping.generatedLine = generatedLine;
          for (end = index; end < length; end++) {
            if (this._charIsMappingSeparator(aStr, end)) {
              break;
            }
          }
          str = aStr.slice(index, end);
          segment = cachedSegments[str];
          if (segment) {
            index += str.length;
          } else {
            segment = [];
            while (index < end) {
              base64VLQ.decode(aStr, index, temp);
              value = temp.value;
              index = temp.rest;
              segment.push(value);
            }
            if (segment.length === 2) {
              throw new Error('Found a source, but no line and column');
            }
            if (segment.length === 3) {
              throw new Error('Found a source and line, but no column');
            }
            cachedSegments[str] = segment;
          }
          mapping.generatedColumn = previousGeneratedColumn + segment[0];
          previousGeneratedColumn = mapping.generatedColumn;
          if (segment.length > 1) {
            mapping.source = previousSource + segment[1];
            previousSource += segment[1];
            mapping.originalLine = previousOriginalLine + segment[2];
            previousOriginalLine = mapping.originalLine;
            mapping.originalLine += 1;
            mapping.originalColumn = previousOriginalColumn + segment[3];
            previousOriginalColumn = mapping.originalColumn;
            if (segment.length > 4) {
              mapping.name = previousName + segment[4];
              previousName += segment[4];
            }
          }
          generatedMappings.push(mapping);
          if (typeof mapping.originalLine === 'number') {
            originalMappings.push(mapping);
          }
        }
      }
      quickSort(generatedMappings, util.compareByGeneratedPositionsDeflated);
      this.__generatedMappings = generatedMappings;
      quickSort(originalMappings, util.compareByOriginalPositions);
      this.__originalMappings = originalMappings;
    };
    BasicSourceMapConsumer.prototype._findMapping = function SourceMapConsumer_findMapping(aNeedle, aMappings, aLineName, aColumnName, aComparator, aBias) {
      if (aNeedle[aLineName] <= 0) {
        throw new TypeError('Line must be greater than or equal to 1, got ' + aNeedle[aLineName]);
      }
      if (aNeedle[aColumnName] < 0) {
        throw new TypeError('Column must be greater than or equal to 0, got ' + aNeedle[aColumnName]);
      }
      return binarySearch.search(aNeedle, aMappings, aComparator, aBias);
    };
    BasicSourceMapConsumer.prototype.computeColumnSpans = function SourceMapConsumer_computeColumnSpans() {
      for (var index = 0; index < this._generatedMappings.length; ++index) {
        var mapping = this._generatedMappings[index];
        if (index + 1 < this._generatedMappings.length) {
          var nextMapping = this._generatedMappings[index + 1];
          if (mapping.generatedLine === nextMapping.generatedLine) {
            mapping.lastGeneratedColumn = nextMapping.generatedColumn - 1;
            continue;
          }
        }
        mapping.lastGeneratedColumn = Infinity;
      }
    };
    BasicSourceMapConsumer.prototype.originalPositionFor = function SourceMapConsumer_originalPositionFor(aArgs) {
      var needle = {
        generatedLine: util.getArg(aArgs, 'line'),
        generatedColumn: util.getArg(aArgs, 'column')
      };
      var index = this._findMapping(needle, this._generatedMappings, "generatedLine", "generatedColumn", util.compareByGeneratedPositionsDeflated, util.getArg(aArgs, 'bias', SourceMapConsumer.GREATEST_LOWER_BOUND));
      if (index >= 0) {
        var mapping = this._generatedMappings[index];
        if (mapping.generatedLine === needle.generatedLine) {
          var source = util.getArg(mapping, 'source', null);
          if (source !== null) {
            source = this._sources.at(source);
            if (this.sourceRoot != null) {
              source = util.join(this.sourceRoot, source);
            }
          }
          var name = util.getArg(mapping, 'name', null);
          if (name !== null) {
            name = this._names.at(name);
          }
          return {
            source: source,
            line: util.getArg(mapping, 'originalLine', null),
            column: util.getArg(mapping, 'originalColumn', null),
            name: name
          };
        }
      }
      return {
        source: null,
        line: null,
        column: null,
        name: null
      };
    };
    BasicSourceMapConsumer.prototype.hasContentsOfAllSources = function BasicSourceMapConsumer_hasContentsOfAllSources() {
      if (!this.sourcesContent) {
        return false;
      }
      return this.sourcesContent.length >= this._sources.size() && !this.sourcesContent.some(function(sc) {
        return sc == null;
      });
    };
    BasicSourceMapConsumer.prototype.sourceContentFor = function SourceMapConsumer_sourceContentFor(aSource, nullOnMissing) {
      if (!this.sourcesContent) {
        return null;
      }
      if (this.sourceRoot != null) {
        aSource = util.relative(this.sourceRoot, aSource);
      }
      if (this._sources.has(aSource)) {
        return this.sourcesContent[this._sources.indexOf(aSource)];
      }
      var url;
      if (this.sourceRoot != null && (url = util.urlParse(this.sourceRoot))) {
        var fileUriAbsPath = aSource.replace(/^file:\/\//, "");
        if (url.scheme == "file" && this._sources.has(fileUriAbsPath)) {
          return this.sourcesContent[this._sources.indexOf(fileUriAbsPath)];
        }
        if ((!url.path || url.path == "/") && this._sources.has("/" + aSource)) {
          return this.sourcesContent[this._sources.indexOf("/" + aSource)];
        }
      }
      if (nullOnMissing) {
        return null;
      } else {
        throw new Error('"' + aSource + '" is not in the SourceMap.');
      }
    };
    BasicSourceMapConsumer.prototype.generatedPositionFor = function SourceMapConsumer_generatedPositionFor(aArgs) {
      var source = util.getArg(aArgs, 'source');
      if (this.sourceRoot != null) {
        source = util.relative(this.sourceRoot, source);
      }
      if (!this._sources.has(source)) {
        return {
          line: null,
          column: null,
          lastColumn: null
        };
      }
      source = this._sources.indexOf(source);
      var needle = {
        source: source,
        originalLine: util.getArg(aArgs, 'line'),
        originalColumn: util.getArg(aArgs, 'column')
      };
      var index = this._findMapping(needle, this._originalMappings, "originalLine", "originalColumn", util.compareByOriginalPositions, util.getArg(aArgs, 'bias', SourceMapConsumer.GREATEST_LOWER_BOUND));
      if (index >= 0) {
        var mapping = this._originalMappings[index];
        if (mapping.source === needle.source) {
          return {
            line: util.getArg(mapping, 'generatedLine', null),
            column: util.getArg(mapping, 'generatedColumn', null),
            lastColumn: util.getArg(mapping, 'lastGeneratedColumn', null)
          };
        }
      }
      return {
        line: null,
        column: null,
        lastColumn: null
      };
    };
    exports.BasicSourceMapConsumer = BasicSourceMapConsumer;
    function IndexedSourceMapConsumer(aSourceMap) {
      var sourceMap = aSourceMap;
      if (typeof aSourceMap === 'string') {
        sourceMap = JSON.parse(aSourceMap.replace(/^\)\]\}'/, ''));
      }
      var version = util.getArg(sourceMap, 'version');
      var sections = util.getArg(sourceMap, 'sections');
      if (version != this._version) {
        throw new Error('Unsupported version: ' + version);
      }
      this._sources = new ArraySet();
      this._names = new ArraySet();
      var lastOffset = {
        line: -1,
        column: 0
      };
      this._sections = sections.map(function(s) {
        if (s.url) {
          throw new Error('Support for url field in sections not implemented.');
        }
        var offset = util.getArg(s, 'offset');
        var offsetLine = util.getArg(offset, 'line');
        var offsetColumn = util.getArg(offset, 'column');
        if (offsetLine < lastOffset.line || (offsetLine === lastOffset.line && offsetColumn < lastOffset.column)) {
          throw new Error('Section offsets must be ordered and non-overlapping.');
        }
        lastOffset = offset;
        return {
          generatedOffset: {
            generatedLine: offsetLine + 1,
            generatedColumn: offsetColumn + 1
          },
          consumer: new SourceMapConsumer(util.getArg(s, 'map'))
        };
      });
    }
    IndexedSourceMapConsumer.prototype = Object.create(SourceMapConsumer.prototype);
    IndexedSourceMapConsumer.prototype.constructor = SourceMapConsumer;
    IndexedSourceMapConsumer.prototype._version = 3;
    Object.defineProperty(IndexedSourceMapConsumer.prototype, 'sources', {get: function() {
        var sources = [];
        for (var i = 0; i < this._sections.length; i++) {
          for (var j = 0; j < this._sections[i].consumer.sources.length; j++) {
            sources.push(this._sections[i].consumer.sources[j]);
          }
        }
        return sources;
      }});
    IndexedSourceMapConsumer.prototype.originalPositionFor = function IndexedSourceMapConsumer_originalPositionFor(aArgs) {
      var needle = {
        generatedLine: util.getArg(aArgs, 'line'),
        generatedColumn: util.getArg(aArgs, 'column')
      };
      var sectionIndex = binarySearch.search(needle, this._sections, function(needle, section) {
        var cmp = needle.generatedLine - section.generatedOffset.generatedLine;
        if (cmp) {
          return cmp;
        }
        return (needle.generatedColumn - section.generatedOffset.generatedColumn);
      });
      var section = this._sections[sectionIndex];
      if (!section) {
        return {
          source: null,
          line: null,
          column: null,
          name: null
        };
      }
      return section.consumer.originalPositionFor({
        line: needle.generatedLine - (section.generatedOffset.generatedLine - 1),
        column: needle.generatedColumn - (section.generatedOffset.generatedLine === needle.generatedLine ? section.generatedOffset.generatedColumn - 1 : 0),
        bias: aArgs.bias
      });
    };
    IndexedSourceMapConsumer.prototype.hasContentsOfAllSources = function IndexedSourceMapConsumer_hasContentsOfAllSources() {
      return this._sections.every(function(s) {
        return s.consumer.hasContentsOfAllSources();
      });
    };
    IndexedSourceMapConsumer.prototype.sourceContentFor = function IndexedSourceMapConsumer_sourceContentFor(aSource, nullOnMissing) {
      for (var i = 0; i < this._sections.length; i++) {
        var section = this._sections[i];
        var content = section.consumer.sourceContentFor(aSource, true);
        if (content) {
          return content;
        }
      }
      if (nullOnMissing) {
        return null;
      } else {
        throw new Error('"' + aSource + '" is not in the SourceMap.');
      }
    };
    IndexedSourceMapConsumer.prototype.generatedPositionFor = function IndexedSourceMapConsumer_generatedPositionFor(aArgs) {
      for (var i = 0; i < this._sections.length; i++) {
        var section = this._sections[i];
        if (section.consumer.sources.indexOf(util.getArg(aArgs, 'source')) === -1) {
          continue;
        }
        var generatedPosition = section.consumer.generatedPositionFor(aArgs);
        if (generatedPosition) {
          var ret = {
            line: generatedPosition.line + (section.generatedOffset.generatedLine - 1),
            column: generatedPosition.column + (section.generatedOffset.generatedLine === generatedPosition.line ? section.generatedOffset.generatedColumn - 1 : 0)
          };
          return ret;
        }
      }
      return {
        line: null,
        column: null
      };
    };
    IndexedSourceMapConsumer.prototype._parseMappings = function IndexedSourceMapConsumer_parseMappings(aStr, aSourceRoot) {
      this.__generatedMappings = [];
      this.__originalMappings = [];
      for (var i = 0; i < this._sections.length; i++) {
        var section = this._sections[i];
        var sectionMappings = section.consumer._generatedMappings;
        for (var j = 0; j < sectionMappings.length; j++) {
          var mapping = sectionMappings[j];
          var source = section.consumer._sources.at(mapping.source);
          if (section.consumer.sourceRoot !== null) {
            source = util.join(section.consumer.sourceRoot, source);
          }
          this._sources.add(source);
          source = this._sources.indexOf(source);
          var name = section.consumer._names.at(mapping.name);
          this._names.add(name);
          name = this._names.indexOf(name);
          var adjustedMapping = {
            source: source,
            generatedLine: mapping.generatedLine + (section.generatedOffset.generatedLine - 1),
            generatedColumn: mapping.generatedColumn + (section.generatedOffset.generatedLine === mapping.generatedLine ? section.generatedOffset.generatedColumn - 1 : 0),
            originalLine: mapping.originalLine,
            originalColumn: mapping.originalColumn,
            name: name
          };
          this.__generatedMappings.push(adjustedMapping);
          if (typeof adjustedMapping.originalLine === 'number') {
            this.__originalMappings.push(adjustedMapping);
          }
        }
      }
      quickSort(this.__generatedMappings, util.compareByGeneratedPositionsDeflated);
      quickSort(this.__originalMappings, util.compareByOriginalPositions);
    };
    exports.IndexedSourceMapConsumer = IndexedSourceMapConsumer;
  }
  return module.exports;
});

$__System.registerDynamic("7e", ["3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  {
    var intToCharMap = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/'.split('');
    exports.encode = function(number) {
      if (0 <= number && number < intToCharMap.length) {
        return intToCharMap[number];
      }
      throw new TypeError("Must be between 0 and 63: " + number);
    };
    exports.decode = function(charCode) {
      var bigA = 65;
      var bigZ = 90;
      var littleA = 97;
      var littleZ = 122;
      var zero = 48;
      var nine = 57;
      var plus = 43;
      var slash = 47;
      var littleOffset = 26;
      var numberOffset = 52;
      if (bigA <= charCode && charCode <= bigZ) {
        return (charCode - bigA);
      }
      if (littleA <= charCode && charCode <= littleZ) {
        return (charCode - littleA + littleOffset);
      }
      if (zero <= charCode && charCode <= nine) {
        return (charCode - zero + numberOffset);
      }
      if (charCode == plus) {
        return 62;
      }
      if (charCode == slash) {
        return 63;
      }
      return -1;
    };
  }
  return module.exports;
});

$__System.registerDynamic("7d", ["7e", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  {
    var base64 = $__require('7e');
    var VLQ_BASE_SHIFT = 5;
    var VLQ_BASE = 1 << VLQ_BASE_SHIFT;
    var VLQ_BASE_MASK = VLQ_BASE - 1;
    var VLQ_CONTINUATION_BIT = VLQ_BASE;
    function toVLQSigned(aValue) {
      return aValue < 0 ? ((-aValue) << 1) + 1 : (aValue << 1) + 0;
    }
    function fromVLQSigned(aValue) {
      var isNegative = (aValue & 1) === 1;
      var shifted = aValue >> 1;
      return isNegative ? -shifted : shifted;
    }
    exports.encode = function base64VLQ_encode(aValue) {
      var encoded = "";
      var digit;
      var vlq = toVLQSigned(aValue);
      do {
        digit = vlq & VLQ_BASE_MASK;
        vlq >>>= VLQ_BASE_SHIFT;
        if (vlq > 0) {
          digit |= VLQ_CONTINUATION_BIT;
        }
        encoded += base64.encode(digit);
      } while (vlq > 0);
      return encoded;
    };
    exports.decode = function base64VLQ_decode(aStr, aIndex, aOutParam) {
      var strLen = aStr.length;
      var result = 0;
      var shift = 0;
      var continuation,
          digit;
      do {
        if (aIndex >= strLen) {
          throw new Error("Expected more digits in base 64 VLQ value.");
        }
        digit = base64.decode(aStr.charCodeAt(aIndex++));
        if (digit === -1) {
          throw new Error("Invalid base64 digit: " + aStr.charAt(aIndex - 1));
        }
        continuation = !!(digit & VLQ_CONTINUATION_BIT);
        digit &= VLQ_BASE_MASK;
        result = result + (digit << shift);
        shift += VLQ_BASE_SHIFT;
      } while (continuation);
      aOutParam.value = fromVLQSigned(result);
      aOutParam.rest = aIndex;
    };
  }
  return module.exports;
});

$__System.registerDynamic("7c", ["7b", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  {
    var util = $__require('7b');
    function ArraySet() {
      this._array = [];
      this._set = {};
    }
    ArraySet.fromArray = function ArraySet_fromArray(aArray, aAllowDuplicates) {
      var set = new ArraySet();
      for (var i = 0,
          len = aArray.length; i < len; i++) {
        set.add(aArray[i], aAllowDuplicates);
      }
      return set;
    };
    ArraySet.prototype.size = function ArraySet_size() {
      return Object.getOwnPropertyNames(this._set).length;
    };
    ArraySet.prototype.add = function ArraySet_add(aStr, aAllowDuplicates) {
      var sStr = util.toSetString(aStr);
      var isDuplicate = this._set.hasOwnProperty(sStr);
      var idx = this._array.length;
      if (!isDuplicate || aAllowDuplicates) {
        this._array.push(aStr);
      }
      if (!isDuplicate) {
        this._set[sStr] = idx;
      }
    };
    ArraySet.prototype.has = function ArraySet_has(aStr) {
      var sStr = util.toSetString(aStr);
      return this._set.hasOwnProperty(sStr);
    };
    ArraySet.prototype.indexOf = function ArraySet_indexOf(aStr) {
      var sStr = util.toSetString(aStr);
      if (this._set.hasOwnProperty(sStr)) {
        return this._set[sStr];
      }
      throw new Error('"' + aStr + '" is not in the set.');
    };
    ArraySet.prototype.at = function ArraySet_at(aIdx) {
      if (aIdx >= 0 && aIdx < this._array.length) {
        return this._array[aIdx];
      }
      throw new Error('No element indexed by ' + aIdx);
    };
    ArraySet.prototype.toArray = function ArraySet_toArray() {
      return this._array.slice();
    };
    exports.ArraySet = ArraySet;
  }
  return module.exports;
});

$__System.registerDynamic("7f", ["7b", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  {
    var util = $__require('7b');
    function generatedPositionAfter(mappingA, mappingB) {
      var lineA = mappingA.generatedLine;
      var lineB = mappingB.generatedLine;
      var columnA = mappingA.generatedColumn;
      var columnB = mappingB.generatedColumn;
      return lineB > lineA || lineB == lineA && columnB >= columnA || util.compareByGeneratedPositionsInflated(mappingA, mappingB) <= 0;
    }
    function MappingList() {
      this._array = [];
      this._sorted = true;
      this._last = {
        generatedLine: -1,
        generatedColumn: 0
      };
    }
    MappingList.prototype.unsortedForEach = function MappingList_forEach(aCallback, aThisArg) {
      this._array.forEach(aCallback, aThisArg);
    };
    MappingList.prototype.add = function MappingList_add(aMapping) {
      if (generatedPositionAfter(this._last, aMapping)) {
        this._last = aMapping;
        this._array.push(aMapping);
      } else {
        this._sorted = false;
        this._array.push(aMapping);
      }
    };
    MappingList.prototype.toArray = function MappingList_toArray() {
      if (!this._sorted) {
        this._array.sort(util.compareByGeneratedPositionsInflated);
        this._sorted = true;
      }
      return this._array;
    };
    exports.MappingList = MappingList;
  }
  return module.exports;
});

$__System.registerDynamic("80", ["7d", "7b", "7c", "7f", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  {
    var base64VLQ = $__require('7d');
    var util = $__require('7b');
    var ArraySet = $__require('7c').ArraySet;
    var MappingList = $__require('7f').MappingList;
    function SourceMapGenerator(aArgs) {
      if (!aArgs) {
        aArgs = {};
      }
      this._file = util.getArg(aArgs, 'file', null);
      this._sourceRoot = util.getArg(aArgs, 'sourceRoot', null);
      this._skipValidation = util.getArg(aArgs, 'skipValidation', false);
      this._sources = new ArraySet();
      this._names = new ArraySet();
      this._mappings = new MappingList();
      this._sourcesContents = null;
    }
    SourceMapGenerator.prototype._version = 3;
    SourceMapGenerator.fromSourceMap = function SourceMapGenerator_fromSourceMap(aSourceMapConsumer) {
      var sourceRoot = aSourceMapConsumer.sourceRoot;
      var generator = new SourceMapGenerator({
        file: aSourceMapConsumer.file,
        sourceRoot: sourceRoot
      });
      aSourceMapConsumer.eachMapping(function(mapping) {
        var newMapping = {generated: {
            line: mapping.generatedLine,
            column: mapping.generatedColumn
          }};
        if (mapping.source != null) {
          newMapping.source = mapping.source;
          if (sourceRoot != null) {
            newMapping.source = util.relative(sourceRoot, newMapping.source);
          }
          newMapping.original = {
            line: mapping.originalLine,
            column: mapping.originalColumn
          };
          if (mapping.name != null) {
            newMapping.name = mapping.name;
          }
        }
        generator.addMapping(newMapping);
      });
      aSourceMapConsumer.sources.forEach(function(sourceFile) {
        var content = aSourceMapConsumer.sourceContentFor(sourceFile);
        if (content != null) {
          generator.setSourceContent(sourceFile, content);
        }
      });
      return generator;
    };
    SourceMapGenerator.prototype.addMapping = function SourceMapGenerator_addMapping(aArgs) {
      var generated = util.getArg(aArgs, 'generated');
      var original = util.getArg(aArgs, 'original', null);
      var source = util.getArg(aArgs, 'source', null);
      var name = util.getArg(aArgs, 'name', null);
      if (!this._skipValidation) {
        this._validateMapping(generated, original, source, name);
      }
      if (source != null && !this._sources.has(source)) {
        this._sources.add(source);
      }
      if (name != null && !this._names.has(name)) {
        this._names.add(name);
      }
      this._mappings.add({
        generatedLine: generated.line,
        generatedColumn: generated.column,
        originalLine: original != null && original.line,
        originalColumn: original != null && original.column,
        source: source,
        name: name
      });
    };
    SourceMapGenerator.prototype.setSourceContent = function SourceMapGenerator_setSourceContent(aSourceFile, aSourceContent) {
      var source = aSourceFile;
      if (this._sourceRoot != null) {
        source = util.relative(this._sourceRoot, source);
      }
      if (aSourceContent != null) {
        if (!this._sourcesContents) {
          this._sourcesContents = {};
        }
        this._sourcesContents[util.toSetString(source)] = aSourceContent;
      } else if (this._sourcesContents) {
        delete this._sourcesContents[util.toSetString(source)];
        if (Object.keys(this._sourcesContents).length === 0) {
          this._sourcesContents = null;
        }
      }
    };
    SourceMapGenerator.prototype.applySourceMap = function SourceMapGenerator_applySourceMap(aSourceMapConsumer, aSourceFile, aSourceMapPath) {
      var sourceFile = aSourceFile;
      if (aSourceFile == null) {
        if (aSourceMapConsumer.file == null) {
          throw new Error('SourceMapGenerator.prototype.applySourceMap requires either an explicit source file, ' + 'or the source map\'s "file" property. Both were omitted.');
        }
        sourceFile = aSourceMapConsumer.file;
      }
      var sourceRoot = this._sourceRoot;
      if (sourceRoot != null) {
        sourceFile = util.relative(sourceRoot, sourceFile);
      }
      var newSources = new ArraySet();
      var newNames = new ArraySet();
      this._mappings.unsortedForEach(function(mapping) {
        if (mapping.source === sourceFile && mapping.originalLine != null) {
          var original = aSourceMapConsumer.originalPositionFor({
            line: mapping.originalLine,
            column: mapping.originalColumn
          });
          if (original.source != null) {
            mapping.source = original.source;
            if (aSourceMapPath != null) {
              mapping.source = util.join(aSourceMapPath, mapping.source);
            }
            if (sourceRoot != null) {
              mapping.source = util.relative(sourceRoot, mapping.source);
            }
            mapping.originalLine = original.line;
            mapping.originalColumn = original.column;
            if (original.name != null) {
              mapping.name = original.name;
            }
          }
        }
        var source = mapping.source;
        if (source != null && !newSources.has(source)) {
          newSources.add(source);
        }
        var name = mapping.name;
        if (name != null && !newNames.has(name)) {
          newNames.add(name);
        }
      }, this);
      this._sources = newSources;
      this._names = newNames;
      aSourceMapConsumer.sources.forEach(function(sourceFile) {
        var content = aSourceMapConsumer.sourceContentFor(sourceFile);
        if (content != null) {
          if (aSourceMapPath != null) {
            sourceFile = util.join(aSourceMapPath, sourceFile);
          }
          if (sourceRoot != null) {
            sourceFile = util.relative(sourceRoot, sourceFile);
          }
          this.setSourceContent(sourceFile, content);
        }
      }, this);
    };
    SourceMapGenerator.prototype._validateMapping = function SourceMapGenerator_validateMapping(aGenerated, aOriginal, aSource, aName) {
      if (aGenerated && 'line' in aGenerated && 'column' in aGenerated && aGenerated.line > 0 && aGenerated.column >= 0 && !aOriginal && !aSource && !aName) {
        return;
      } else if (aGenerated && 'line' in aGenerated && 'column' in aGenerated && aOriginal && 'line' in aOriginal && 'column' in aOriginal && aGenerated.line > 0 && aGenerated.column >= 0 && aOriginal.line > 0 && aOriginal.column >= 0 && aSource) {
        return;
      } else {
        throw new Error('Invalid mapping: ' + JSON.stringify({
          generated: aGenerated,
          source: aSource,
          original: aOriginal,
          name: aName
        }));
      }
    };
    SourceMapGenerator.prototype._serializeMappings = function SourceMapGenerator_serializeMappings() {
      var previousGeneratedColumn = 0;
      var previousGeneratedLine = 1;
      var previousOriginalColumn = 0;
      var previousOriginalLine = 0;
      var previousName = 0;
      var previousSource = 0;
      var result = '';
      var mapping;
      var nameIdx;
      var sourceIdx;
      var mappings = this._mappings.toArray();
      for (var i = 0,
          len = mappings.length; i < len; i++) {
        mapping = mappings[i];
        if (mapping.generatedLine !== previousGeneratedLine) {
          previousGeneratedColumn = 0;
          while (mapping.generatedLine !== previousGeneratedLine) {
            result += ';';
            previousGeneratedLine++;
          }
        } else {
          if (i > 0) {
            if (!util.compareByGeneratedPositionsInflated(mapping, mappings[i - 1])) {
              continue;
            }
            result += ',';
          }
        }
        result += base64VLQ.encode(mapping.generatedColumn - previousGeneratedColumn);
        previousGeneratedColumn = mapping.generatedColumn;
        if (mapping.source != null) {
          sourceIdx = this._sources.indexOf(mapping.source);
          result += base64VLQ.encode(sourceIdx - previousSource);
          previousSource = sourceIdx;
          result += base64VLQ.encode(mapping.originalLine - 1 - previousOriginalLine);
          previousOriginalLine = mapping.originalLine - 1;
          result += base64VLQ.encode(mapping.originalColumn - previousOriginalColumn);
          previousOriginalColumn = mapping.originalColumn;
          if (mapping.name != null) {
            nameIdx = this._names.indexOf(mapping.name);
            result += base64VLQ.encode(nameIdx - previousName);
            previousName = nameIdx;
          }
        }
      }
      return result;
    };
    SourceMapGenerator.prototype._generateSourcesContent = function SourceMapGenerator_generateSourcesContent(aSources, aSourceRoot) {
      return aSources.map(function(source) {
        if (!this._sourcesContents) {
          return null;
        }
        if (aSourceRoot != null) {
          source = util.relative(aSourceRoot, source);
        }
        var key = util.toSetString(source);
        return Object.prototype.hasOwnProperty.call(this._sourcesContents, key) ? this._sourcesContents[key] : null;
      }, this);
    };
    SourceMapGenerator.prototype.toJSON = function SourceMapGenerator_toJSON() {
      var map = {
        version: this._version,
        sources: this._sources.toArray(),
        names: this._names.toArray(),
        mappings: this._serializeMappings()
      };
      if (this._file != null) {
        map.file = this._file;
      }
      if (this._sourceRoot != null) {
        map.sourceRoot = this._sourceRoot;
      }
      if (this._sourcesContents) {
        map.sourcesContent = this._generateSourcesContent(map.sources, map.sourceRoot);
      }
      return map;
    };
    SourceMapGenerator.prototype.toString = function SourceMapGenerator_toString() {
      return JSON.stringify(this.toJSON());
    };
    exports.SourceMapGenerator = SourceMapGenerator;
  }
  return module.exports;
});

$__System.registerDynamic("7b", ["3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  {
    function getArg(aArgs, aName, aDefaultValue) {
      if (aName in aArgs) {
        return aArgs[aName];
      } else if (arguments.length === 3) {
        return aDefaultValue;
      } else {
        throw new Error('"' + aName + '" is a required argument.');
      }
    }
    exports.getArg = getArg;
    var urlRegexp = /^(?:([\w+\-.]+):)?\/\/(?:(\w+:\w+)@)?([\w.]*)(?::(\d+))?(\S*)$/;
    var dataUrlRegexp = /^data:.+\,.+$/;
    function urlParse(aUrl) {
      var match = aUrl.match(urlRegexp);
      if (!match) {
        return null;
      }
      return {
        scheme: match[1],
        auth: match[2],
        host: match[3],
        port: match[4],
        path: match[5]
      };
    }
    exports.urlParse = urlParse;
    function urlGenerate(aParsedUrl) {
      var url = '';
      if (aParsedUrl.scheme) {
        url += aParsedUrl.scheme + ':';
      }
      url += '//';
      if (aParsedUrl.auth) {
        url += aParsedUrl.auth + '@';
      }
      if (aParsedUrl.host) {
        url += aParsedUrl.host;
      }
      if (aParsedUrl.port) {
        url += ":" + aParsedUrl.port;
      }
      if (aParsedUrl.path) {
        url += aParsedUrl.path;
      }
      return url;
    }
    exports.urlGenerate = urlGenerate;
    function normalize(aPath) {
      var path = aPath;
      var url = urlParse(aPath);
      if (url) {
        if (!url.path) {
          return aPath;
        }
        path = url.path;
      }
      var isAbsolute = exports.isAbsolute(path);
      var parts = path.split(/\/+/);
      for (var part,
          up = 0,
          i = parts.length - 1; i >= 0; i--) {
        part = parts[i];
        if (part === '.') {
          parts.splice(i, 1);
        } else if (part === '..') {
          up++;
        } else if (up > 0) {
          if (part === '') {
            parts.splice(i + 1, up);
            up = 0;
          } else {
            parts.splice(i, 2);
            up--;
          }
        }
      }
      path = parts.join('/');
      if (path === '') {
        path = isAbsolute ? '/' : '.';
      }
      if (url) {
        url.path = path;
        return urlGenerate(url);
      }
      return path;
    }
    exports.normalize = normalize;
    function join(aRoot, aPath) {
      if (aRoot === "") {
        aRoot = ".";
      }
      if (aPath === "") {
        aPath = ".";
      }
      var aPathUrl = urlParse(aPath);
      var aRootUrl = urlParse(aRoot);
      if (aRootUrl) {
        aRoot = aRootUrl.path || '/';
      }
      if (aPathUrl && !aPathUrl.scheme) {
        if (aRootUrl) {
          aPathUrl.scheme = aRootUrl.scheme;
        }
        return urlGenerate(aPathUrl);
      }
      if (aPathUrl || aPath.match(dataUrlRegexp)) {
        return aPath;
      }
      if (aRootUrl && !aRootUrl.host && !aRootUrl.path) {
        aRootUrl.host = aPath;
        return urlGenerate(aRootUrl);
      }
      var joined = aPath.charAt(0) === '/' ? aPath : normalize(aRoot.replace(/\/+$/, '') + '/' + aPath);
      if (aRootUrl) {
        aRootUrl.path = joined;
        return urlGenerate(aRootUrl);
      }
      return joined;
    }
    exports.join = join;
    exports.isAbsolute = function(aPath) {
      return aPath.charAt(0) === '/' || !!aPath.match(urlRegexp);
    };
    function relative(aRoot, aPath) {
      if (aRoot === "") {
        aRoot = ".";
      }
      aRoot = aRoot.replace(/\/$/, '');
      var level = 0;
      while (aPath.indexOf(aRoot + '/') !== 0) {
        var index = aRoot.lastIndexOf("/");
        if (index < 0) {
          return aPath;
        }
        aRoot = aRoot.slice(0, index);
        if (aRoot.match(/^([^\/]+:\/)?\/*$/)) {
          return aPath;
        }
        ++level;
      }
      return Array(level + 1).join("../") + aPath.substr(aRoot.length + 1);
    }
    exports.relative = relative;
    function toSetString(aStr) {
      return '$' + aStr;
    }
    exports.toSetString = toSetString;
    function fromSetString(aStr) {
      return aStr.substr(1);
    }
    exports.fromSetString = fromSetString;
    function compareByOriginalPositions(mappingA, mappingB, onlyCompareOriginal) {
      var cmp = mappingA.source - mappingB.source;
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.originalLine - mappingB.originalLine;
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.originalColumn - mappingB.originalColumn;
      if (cmp !== 0 || onlyCompareOriginal) {
        return cmp;
      }
      cmp = mappingA.generatedColumn - mappingB.generatedColumn;
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.generatedLine - mappingB.generatedLine;
      if (cmp !== 0) {
        return cmp;
      }
      return mappingA.name - mappingB.name;
    }
    exports.compareByOriginalPositions = compareByOriginalPositions;
    function compareByGeneratedPositionsDeflated(mappingA, mappingB, onlyCompareGenerated) {
      var cmp = mappingA.generatedLine - mappingB.generatedLine;
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.generatedColumn - mappingB.generatedColumn;
      if (cmp !== 0 || onlyCompareGenerated) {
        return cmp;
      }
      cmp = mappingA.source - mappingB.source;
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.originalLine - mappingB.originalLine;
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.originalColumn - mappingB.originalColumn;
      if (cmp !== 0) {
        return cmp;
      }
      return mappingA.name - mappingB.name;
    }
    exports.compareByGeneratedPositionsDeflated = compareByGeneratedPositionsDeflated;
    function strcmp(aStr1, aStr2) {
      if (aStr1 === aStr2) {
        return 0;
      }
      if (aStr1 > aStr2) {
        return 1;
      }
      return -1;
    }
    function compareByGeneratedPositionsInflated(mappingA, mappingB) {
      var cmp = mappingA.generatedLine - mappingB.generatedLine;
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.generatedColumn - mappingB.generatedColumn;
      if (cmp !== 0) {
        return cmp;
      }
      cmp = strcmp(mappingA.source, mappingB.source);
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.originalLine - mappingB.originalLine;
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.originalColumn - mappingB.originalColumn;
      if (cmp !== 0) {
        return cmp;
      }
      return strcmp(mappingA.name, mappingB.name);
    }
    exports.compareByGeneratedPositionsInflated = compareByGeneratedPositionsInflated;
  }
  return module.exports;
});

$__System.registerDynamic("81", ["80", "7b", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  {
    var SourceMapGenerator = $__require('80').SourceMapGenerator;
    var util = $__require('7b');
    var REGEX_NEWLINE = /(\r?\n)/;
    var NEWLINE_CODE = 10;
    var isSourceNode = "$$$isSourceNode$$$";
    function SourceNode(aLine, aColumn, aSource, aChunks, aName) {
      this.children = [];
      this.sourceContents = {};
      this.line = aLine == null ? null : aLine;
      this.column = aColumn == null ? null : aColumn;
      this.source = aSource == null ? null : aSource;
      this.name = aName == null ? null : aName;
      this[isSourceNode] = true;
      if (aChunks != null)
        this.add(aChunks);
    }
    SourceNode.fromStringWithSourceMap = function SourceNode_fromStringWithSourceMap(aGeneratedCode, aSourceMapConsumer, aRelativePath) {
      var node = new SourceNode();
      var remainingLines = aGeneratedCode.split(REGEX_NEWLINE);
      var shiftNextLine = function() {
        var lineContents = remainingLines.shift();
        var newLine = remainingLines.shift() || "";
        return lineContents + newLine;
      };
      var lastGeneratedLine = 1,
          lastGeneratedColumn = 0;
      var lastMapping = null;
      aSourceMapConsumer.eachMapping(function(mapping) {
        if (lastMapping !== null) {
          if (lastGeneratedLine < mapping.generatedLine) {
            addMappingWithCode(lastMapping, shiftNextLine());
            lastGeneratedLine++;
            lastGeneratedColumn = 0;
          } else {
            var nextLine = remainingLines[0];
            var code = nextLine.substr(0, mapping.generatedColumn - lastGeneratedColumn);
            remainingLines[0] = nextLine.substr(mapping.generatedColumn - lastGeneratedColumn);
            lastGeneratedColumn = mapping.generatedColumn;
            addMappingWithCode(lastMapping, code);
            lastMapping = mapping;
            return;
          }
        }
        while (lastGeneratedLine < mapping.generatedLine) {
          node.add(shiftNextLine());
          lastGeneratedLine++;
        }
        if (lastGeneratedColumn < mapping.generatedColumn) {
          var nextLine = remainingLines[0];
          node.add(nextLine.substr(0, mapping.generatedColumn));
          remainingLines[0] = nextLine.substr(mapping.generatedColumn);
          lastGeneratedColumn = mapping.generatedColumn;
        }
        lastMapping = mapping;
      }, this);
      if (remainingLines.length > 0) {
        if (lastMapping) {
          addMappingWithCode(lastMapping, shiftNextLine());
        }
        node.add(remainingLines.join(""));
      }
      aSourceMapConsumer.sources.forEach(function(sourceFile) {
        var content = aSourceMapConsumer.sourceContentFor(sourceFile);
        if (content != null) {
          if (aRelativePath != null) {
            sourceFile = util.join(aRelativePath, sourceFile);
          }
          node.setSourceContent(sourceFile, content);
        }
      });
      return node;
      function addMappingWithCode(mapping, code) {
        if (mapping === null || mapping.source === undefined) {
          node.add(code);
        } else {
          var source = aRelativePath ? util.join(aRelativePath, mapping.source) : mapping.source;
          node.add(new SourceNode(mapping.originalLine, mapping.originalColumn, source, code, mapping.name));
        }
      }
    };
    SourceNode.prototype.add = function SourceNode_add(aChunk) {
      if (Array.isArray(aChunk)) {
        aChunk.forEach(function(chunk) {
          this.add(chunk);
        }, this);
      } else if (aChunk[isSourceNode] || typeof aChunk === "string") {
        if (aChunk) {
          this.children.push(aChunk);
        }
      } else {
        throw new TypeError("Expected a SourceNode, string, or an array of SourceNodes and strings. Got " + aChunk);
      }
      return this;
    };
    SourceNode.prototype.prepend = function SourceNode_prepend(aChunk) {
      if (Array.isArray(aChunk)) {
        for (var i = aChunk.length - 1; i >= 0; i--) {
          this.prepend(aChunk[i]);
        }
      } else if (aChunk[isSourceNode] || typeof aChunk === "string") {
        this.children.unshift(aChunk);
      } else {
        throw new TypeError("Expected a SourceNode, string, or an array of SourceNodes and strings. Got " + aChunk);
      }
      return this;
    };
    SourceNode.prototype.walk = function SourceNode_walk(aFn) {
      var chunk;
      for (var i = 0,
          len = this.children.length; i < len; i++) {
        chunk = this.children[i];
        if (chunk[isSourceNode]) {
          chunk.walk(aFn);
        } else {
          if (chunk !== '') {
            aFn(chunk, {
              source: this.source,
              line: this.line,
              column: this.column,
              name: this.name
            });
          }
        }
      }
    };
    SourceNode.prototype.join = function SourceNode_join(aSep) {
      var newChildren;
      var i;
      var len = this.children.length;
      if (len > 0) {
        newChildren = [];
        for (i = 0; i < len - 1; i++) {
          newChildren.push(this.children[i]);
          newChildren.push(aSep);
        }
        newChildren.push(this.children[i]);
        this.children = newChildren;
      }
      return this;
    };
    SourceNode.prototype.replaceRight = function SourceNode_replaceRight(aPattern, aReplacement) {
      var lastChild = this.children[this.children.length - 1];
      if (lastChild[isSourceNode]) {
        lastChild.replaceRight(aPattern, aReplacement);
      } else if (typeof lastChild === 'string') {
        this.children[this.children.length - 1] = lastChild.replace(aPattern, aReplacement);
      } else {
        this.children.push(''.replace(aPattern, aReplacement));
      }
      return this;
    };
    SourceNode.prototype.setSourceContent = function SourceNode_setSourceContent(aSourceFile, aSourceContent) {
      this.sourceContents[util.toSetString(aSourceFile)] = aSourceContent;
    };
    SourceNode.prototype.walkSourceContents = function SourceNode_walkSourceContents(aFn) {
      for (var i = 0,
          len = this.children.length; i < len; i++) {
        if (this.children[i][isSourceNode]) {
          this.children[i].walkSourceContents(aFn);
        }
      }
      var sources = Object.keys(this.sourceContents);
      for (var i = 0,
          len = sources.length; i < len; i++) {
        aFn(util.fromSetString(sources[i]), this.sourceContents[sources[i]]);
      }
    };
    SourceNode.prototype.toString = function SourceNode_toString() {
      var str = "";
      this.walk(function(chunk) {
        str += chunk;
      });
      return str;
    };
    SourceNode.prototype.toStringWithSourceMap = function SourceNode_toStringWithSourceMap(aArgs) {
      var generated = {
        code: "",
        line: 1,
        column: 0
      };
      var map = new SourceMapGenerator(aArgs);
      var sourceMappingActive = false;
      var lastOriginalSource = null;
      var lastOriginalLine = null;
      var lastOriginalColumn = null;
      var lastOriginalName = null;
      this.walk(function(chunk, original) {
        generated.code += chunk;
        if (original.source !== null && original.line !== null && original.column !== null) {
          if (lastOriginalSource !== original.source || lastOriginalLine !== original.line || lastOriginalColumn !== original.column || lastOriginalName !== original.name) {
            map.addMapping({
              source: original.source,
              original: {
                line: original.line,
                column: original.column
              },
              generated: {
                line: generated.line,
                column: generated.column
              },
              name: original.name
            });
          }
          lastOriginalSource = original.source;
          lastOriginalLine = original.line;
          lastOriginalColumn = original.column;
          lastOriginalName = original.name;
          sourceMappingActive = true;
        } else if (sourceMappingActive) {
          map.addMapping({generated: {
              line: generated.line,
              column: generated.column
            }});
          lastOriginalSource = null;
          sourceMappingActive = false;
        }
        for (var idx = 0,
            length = chunk.length; idx < length; idx++) {
          if (chunk.charCodeAt(idx) === NEWLINE_CODE) {
            generated.line++;
            generated.column = 0;
            if (idx + 1 === length) {
              lastOriginalSource = null;
              sourceMappingActive = false;
            } else if (sourceMappingActive) {
              map.addMapping({
                source: original.source,
                original: {
                  line: original.line,
                  column: original.column
                },
                generated: {
                  line: generated.line,
                  column: generated.column
                },
                name: original.name
              });
            }
          } else {
            generated.column++;
          }
        }
      });
      this.walkSourceContents(function(sourceFile, sourceContent) {
        map.setSourceContent(sourceFile, sourceContent);
      });
      return {
        code: generated.code,
        map: map
      };
    };
    exports.SourceNode = SourceNode;
  }
  return module.exports;
});

$__System.registerDynamic("6d", ["80", "7a", "81", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  exports.SourceMapGenerator = $__require('80').SourceMapGenerator;
  exports.SourceMapConsumer = $__require('7a').SourceMapConsumer;
  exports.SourceNode = $__require('81').SourceNode;
  return module.exports;
});

$__System.registerDynamic("82", ["9", "74", "a", "4", "6d", "5", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _classCallCheck = $__require('9')["default"];
  var _Object$keys = $__require('74')["default"];
  var _interopRequireDefault = $__require('a')["default"];
  var _interopRequireWildcard = $__require('4')["default"];
  exports.__esModule = true;
  var _sourceMap = $__require('6d');
  var _sourceMap2 = _interopRequireDefault(_sourceMap);
  var _babelTypes = $__require('5');
  var t = _interopRequireWildcard(_babelTypes);
  var SourceMap = (function() {
    function SourceMap(position, opts, code) {
      var _this = this;
      _classCallCheck(this, SourceMap);
      this.position = position;
      this.opts = opts;
      this.last = {
        generated: {},
        original: {}
      };
      if (opts.sourceMaps) {
        this.map = new _sourceMap2["default"].SourceMapGenerator({
          file: opts.sourceMapTarget,
          sourceRoot: opts.sourceRoot
        });
        if (typeof code === "string") {
          this.map.setSourceContent(opts.sourceFileName, code);
        } else if (typeof code === "object") {
          _Object$keys(code).forEach(function(sourceFileName) {
            _this.map.setSourceContent(sourceFileName, code[sourceFileName]);
          });
        }
      } else {
        this.map = null;
      }
    }
    SourceMap.prototype.get = function get() {
      var map = this.map;
      if (map) {
        return map.toJSON();
      } else {
        return map;
      }
    };
    SourceMap.prototype.mark = function mark(node) {
      var loc = node.loc;
      if (!loc)
        return;
      var map = this.map;
      if (!map)
        return;
      if (t.isProgram(node) || t.isFile(node))
        return;
      var position = this.position;
      var generated = {
        line: position.line,
        column: position.column
      };
      var original = loc.start;
      if (comparePosition(original, this.last.original) || comparePosition(generated, this.last.generated)) {
        return;
      }
      this.last = {
        source: loc.filename || this.opts.sourceFileName,
        generated: generated,
        original: original
      };
      map.addMapping(this.last);
    };
    return SourceMap;
  })();
  exports["default"] = SourceMap;
  function comparePosition(a, b) {
    return a.line === b.line && a.column === b.column;
  }
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("83", ["9", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _classCallCheck = $__require('9')["default"];
  exports.__esModule = true;
  var Position = (function() {
    function Position() {
      _classCallCheck(this, Position);
      this.line = 1;
      this.column = 0;
    }
    Position.prototype.push = function push(str) {
      for (var i = 0; i < str.length; i++) {
        if (str[i] === "\n") {
          this.line++;
          this.column = 0;
        } else {
          this.column++;
        }
      }
    };
    Position.prototype.unshift = function unshift(str) {
      for (var i = 0; i < str.length; i++) {
        if (str[i] === "\n") {
          this.line--;
        } else {
          this.column--;
        }
      }
    };
    return Position;
  })();
  exports["default"] = Position;
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("84", ["4f", "85", "86", "87", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var $ = $__require('4f'),
      toObject = $__require('85'),
      IObject = $__require('86');
  module.exports = $__require('87')(function() {
    var a = Object.assign,
        A = {},
        B = {},
        S = Symbol(),
        K = 'abcdefghijklmnopqrst';
    A[S] = 7;
    K.split('').forEach(function(k) {
      B[k] = k;
    });
    return a({}, A)[S] != 7 || Object.keys(a({}, B)).join('') != K;
  }) ? function assign(target, source) {
    var T = toObject(target),
        $$ = arguments,
        $$len = $$.length,
        index = 1,
        getKeys = $.getKeys,
        getSymbols = $.getSymbols,
        isEnum = $.isEnum;
    while ($$len > index) {
      var S = IObject($$[index++]),
          keys = getSymbols ? getKeys(S).concat(getSymbols(S)) : getKeys(S),
          length = keys.length,
          j = 0,
          key;
      while (length > j)
        if (isEnum.call(S, key = keys[j++]))
          T[key] = S[key];
    }
    return T;
  } : Object.assign;
  return module.exports;
});

$__System.registerDynamic("88", ["63", "84", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var $export = $__require('63');
  $export($export.S + $export.F, 'Object', {assign: $__require('84')});
  return module.exports;
});

$__System.registerDynamic("89", ["88", "4e", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  $__require('88');
  module.exports = $__require('4e').Object.assign;
  return module.exports;
});

$__System.registerDynamic("49", ["89", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  module.exports = {
    "default": $__require('89'),
    __esModule: true
  };
  return module.exports;
});

$__System.registerDynamic("8a", ["3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  module.exports = function(str) {
    var tail = str.length;
    while (/[\s\uFEFF\u00A0]/.test(str[tail - 1])) {
      tail--;
    }
    return str.slice(0, tail);
  };
  return module.exports;
});

$__System.registerDynamic("8b", ["@node/buffer"], true, function($__require, exports, module) {
  ;
  var define,
      global = this,
      GLOBAL = this;
  module.exports = $__require('@node/buffer').Buffer;
  return module.exports;
});

$__System.registerDynamic("8c", ["9", "a", "76", "8a", "3", "8b"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3"),
      Buffer = $__require("8b");
  var define,
      global = this,
      GLOBAL = this;
  var _classCallCheck = $__require('9')["default"];
  var _interopRequireDefault = $__require('a')["default"];
  exports.__esModule = true;
  var _repeating = $__require('76');
  var _repeating2 = _interopRequireDefault(_repeating);
  var _trimRight = $__require('8a');
  var _trimRight2 = _interopRequireDefault(_trimRight);
  var Buffer = (function() {
    function Buffer(position, format) {
      _classCallCheck(this, Buffer);
      this.printedCommentStarts = {};
      this.parenPushNewlineState = null;
      this.position = position;
      this._indent = format.indent.base;
      this.format = format;
      this.buf = "";
      this.last = "";
    }
    Buffer.prototype.catchUp = function catchUp(node) {
      if (node.loc && this.format.retainLines && this.buf) {
        while (this.position.line < node.loc.start.line) {
          this._push("\n");
        }
      }
    };
    Buffer.prototype.get = function get() {
      return _trimRight2["default"](this.buf);
    };
    Buffer.prototype.getIndent = function getIndent() {
      if (this.format.compact || this.format.concise) {
        return "";
      } else {
        return _repeating2["default"](this.format.indent.style, this._indent);
      }
    };
    Buffer.prototype.indentSize = function indentSize() {
      return this.getIndent().length;
    };
    Buffer.prototype.indent = function indent() {
      this._indent++;
    };
    Buffer.prototype.dedent = function dedent() {
      this._indent--;
    };
    Buffer.prototype.semicolon = function semicolon() {
      this.push(";");
    };
    Buffer.prototype.ensureSemicolon = function ensureSemicolon() {
      if (!this.isLast(";"))
        this.semicolon();
    };
    Buffer.prototype.rightBrace = function rightBrace() {
      this.newline(true);
      if (this.format.minified && !this._lastPrintedIsEmptyStatement) {
        this._removeLast(";");
      }
      this.push("}");
    };
    Buffer.prototype.keyword = function keyword(name) {
      this.push(name);
      this.space();
    };
    Buffer.prototype.space = function space(force) {
      if (!force && this.format.compact)
        return;
      if (force || this.buf && !this.isLast(" ") && !this.isLast("\n")) {
        this.push(" ");
      }
    };
    Buffer.prototype.removeLast = function removeLast(cha) {
      if (this.format.compact)
        return;
      return this._removeLast(cha);
    };
    Buffer.prototype._removeLast = function _removeLast(cha) {
      if (!this._isLast(cha))
        return;
      this.buf = this.buf.slice(0, -1);
      this.last = this.buf[this.buf.length - 1];
      this.position.unshift(cha);
    };
    Buffer.prototype.startTerminatorless = function startTerminatorless() {
      return this.parenPushNewlineState = {printed: false};
    };
    Buffer.prototype.endTerminatorless = function endTerminatorless(state) {
      if (state.printed) {
        this.dedent();
        this.newline();
        this.push(")");
      }
    };
    Buffer.prototype.newline = function newline(i, removeLast) {
      if (this.format.retainLines || this.format.compact)
        return;
      if (this.format.concise) {
        this.space();
        return;
      }
      if (this.endsWith("\n\n"))
        return;
      if (typeof i === "boolean")
        removeLast = i;
      if (typeof i !== "number")
        i = 1;
      i = Math.min(2, i);
      if (this.endsWith("{\n") || this.endsWith(":\n"))
        i--;
      if (i <= 0)
        return;
      if (removeLast) {
        this.removeLast("\n");
      }
      this.removeLast(" ");
      this._removeSpacesAfterLastNewline();
      this._push(_repeating2["default"]("\n", i));
    };
    Buffer.prototype._removeSpacesAfterLastNewline = function _removeSpacesAfterLastNewline() {
      var lastNewlineIndex = this.buf.lastIndexOf("\n");
      if (lastNewlineIndex >= 0 && this.get().length <= lastNewlineIndex) {
        this.buf = this.buf.substring(0, lastNewlineIndex + 1);
        this.last = "\n";
      }
    };
    Buffer.prototype.push = function push(str, noIndent) {
      if (!this.format.compact && this._indent && !noIndent && str !== "\n") {
        var indent = this.getIndent();
        str = str.replace(/\n/g, "\n" + indent);
        if (this.isLast("\n"))
          this._push(indent);
      }
      this._push(str);
    };
    Buffer.prototype._push = function _push(str) {
      var parenPushNewlineState = this.parenPushNewlineState;
      if (parenPushNewlineState) {
        for (var i = 0; i < str.length; i++) {
          var cha = str[i];
          if (cha === " ")
            continue;
          this.parenPushNewlineState = null;
          if (cha === "\n" || cha === "/") {
            this._push("(");
            this.indent();
            parenPushNewlineState.printed = true;
          }
          break;
        }
      }
      this.position.push(str);
      this.buf += str;
      this.last = str[str.length - 1];
    };
    Buffer.prototype.endsWith = function endsWith(str) {
      if (str.length === 1) {
        return this.last === str;
      } else {
        return this.buf.slice(-str.length) === str;
      }
    };
    Buffer.prototype.isLast = function isLast(cha) {
      if (this.format.compact)
        return false;
      return this._isLast(cha);
    };
    Buffer.prototype._isLast = function _isLast(cha) {
      var last = this.last;
      if (Array.isArray(cha)) {
        return cha.indexOf(last) >= 0;
      } else {
        return cha === last;
      }
    };
    return Buffer;
  })();
  exports["default"] = Buffer;
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("8d", ["3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  exports.__esModule = true;
  exports.TaggedTemplateExpression = TaggedTemplateExpression;
  exports.TemplateElement = TemplateElement;
  exports.TemplateLiteral = TemplateLiteral;
  function TaggedTemplateExpression(node) {
    this.print(node.tag, node);
    this.print(node.quasi, node);
  }
  function TemplateElement(node) {
    this._push(node.value.raw);
  }
  function TemplateLiteral(node) {
    this.push("`");
    var quasis = node.quasis;
    for (var i = 0; i < quasis.length; i++) {
      this.print(quasis[i], node);
      if (i + 1 < quasis.length) {
        this._push("${ ");
        this.print(node.expressions[i], node);
        this.push(" }");
      }
    }
    this._push("`");
  }
  return module.exports;
});

$__System.registerDynamic("8e", ["8f", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var isFinite = $__require('8f');
  module.exports = Number.isInteger || function(val) {
    return typeof val === "number" && isFinite(val) && Math.floor(val) === val;
  };
  return module.exports;
});

$__System.registerDynamic("28", ["40", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var isObjectLike = $__require('40');
  var boolTag = '[object Boolean]';
  var objectProto = Object.prototype;
  var objToString = objectProto.toString;
  function isBoolean(value) {
    return value === true || value === false || (isObjectLike(value) && objToString.call(value) == boolTag);
  }
  module.exports = isBoolean;
  return module.exports;
});

$__System.registerDynamic("90", ["3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  function arrayMap(array, iteratee) {
    var index = -1,
        length = array.length,
        result = Array(length);
    while (++index < length) {
      result[index] = iteratee(array[index], index, array);
    }
    return result;
  }
  module.exports = arrayMap;
  return module.exports;
});

$__System.registerDynamic("19", ["91", "3a", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var baseEach = $__require('91'),
      isArrayLike = $__require('3a');
  function baseMap(collection, iteratee) {
    var index = -1,
        result = isArrayLike(collection) ? Array(collection.length) : [];
    baseEach(collection, function(value, key, collection) {
      result[++index] = iteratee(value, key, collection);
    });
    return result;
  }
  module.exports = baseMap;
  return module.exports;
});

$__System.registerDynamic("92", ["90", "18", "19", "39", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var arrayMap = $__require('90'),
      baseCallback = $__require('18'),
      baseMap = $__require('19'),
      isArray = $__require('39');
  function map(collection, iteratee, thisArg) {
    var func = isArray(collection) ? arrayMap : baseMap;
    iteratee = baseCallback(iteratee, thisArg, 3);
    return func(collection, iteratee);
  }
  module.exports = map;
  return module.exports;
});

$__System.registerDynamic("93", ["a", "4", "28", "94", "92", "5", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireDefault = $__require('a')["default"];
  var _interopRequireWildcard = $__require('4')["default"];
  var _lodashLangIsBoolean = $__require('28');
  var _lodashLangIsBoolean2 = _interopRequireDefault(_lodashLangIsBoolean);
  var _lodashCollectionEach = $__require('94');
  var _lodashCollectionEach2 = _interopRequireDefault(_lodashCollectionEach);
  var _lodashCollectionMap = $__require('92');
  var _lodashCollectionMap2 = _interopRequireDefault(_lodashCollectionMap);
  var _babelTypes = $__require('5');
  var t = _interopRequireWildcard(_babelTypes);
  function crawl(node) {
    var state = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];
    if (t.isMemberExpression(node)) {
      crawl(node.object, state);
      if (node.computed)
        crawl(node.property, state);
    } else if (t.isBinary(node) || t.isAssignmentExpression(node)) {
      crawl(node.left, state);
      crawl(node.right, state);
    } else if (t.isCallExpression(node)) {
      state.hasCall = true;
      crawl(node.callee, state);
    } else if (t.isFunction(node)) {
      state.hasFunction = true;
    } else if (t.isIdentifier(node)) {
      state.hasHelper = state.hasHelper || isHelper(node.callee);
    }
    return state;
  }
  function isHelper(node) {
    if (t.isMemberExpression(node)) {
      return isHelper(node.object) || isHelper(node.property);
    } else if (t.isIdentifier(node)) {
      return node.name === "require" || node.name[0] === "_";
    } else if (t.isCallExpression(node)) {
      return isHelper(node.callee);
    } else if (t.isBinary(node) || t.isAssignmentExpression(node)) {
      return t.isIdentifier(node.left) && isHelper(node.left) || isHelper(node.right);
    } else {
      return false;
    }
  }
  function isType(node) {
    return t.isLiteral(node) || t.isObjectExpression(node) || t.isArrayExpression(node) || t.isIdentifier(node) || t.isMemberExpression(node);
  }
  exports.nodes = {
    AssignmentExpression: function AssignmentExpression(node) {
      var state = crawl(node.right);
      if (state.hasCall && state.hasHelper || state.hasFunction) {
        return {
          before: state.hasFunction,
          after: true
        };
      }
    },
    SwitchCase: function SwitchCase(node, parent) {
      return {before: node.consequent.length || parent.cases[0] === node};
    },
    LogicalExpression: function LogicalExpression(node) {
      if (t.isFunction(node.left) || t.isFunction(node.right)) {
        return {after: true};
      }
    },
    Literal: function Literal(node) {
      if (node.value === "use strict") {
        return {after: true};
      }
    },
    CallExpression: function CallExpression(node) {
      if (t.isFunction(node.callee) || isHelper(node)) {
        return {
          before: true,
          after: true
        };
      }
    },
    VariableDeclaration: function VariableDeclaration(node) {
      for (var i = 0; i < node.declarations.length; i++) {
        var declar = node.declarations[i];
        var enabled = isHelper(declar.id) && !isType(declar.init);
        if (!enabled) {
          var state = crawl(declar.init);
          enabled = isHelper(declar.init) && state.hasCall || state.hasFunction;
        }
        if (enabled) {
          return {
            before: true,
            after: true
          };
        }
      }
    },
    IfStatement: function IfStatement(node) {
      if (t.isBlockStatement(node.consequent)) {
        return {
          before: true,
          after: true
        };
      }
    }
  };
  exports.nodes.ObjectProperty = exports.nodes.ObjectMethod = exports.nodes.SpreadProperty = function(node, parent) {
    if (parent.properties[0] === node) {
      return {before: true};
    }
  };
  exports.list = {
    VariableDeclaration: function VariableDeclaration(node) {
      return _lodashCollectionMap2["default"](node.declarations, "init");
    },
    ArrayExpression: function ArrayExpression(node) {
      return node.elements;
    },
    ObjectExpression: function ObjectExpression(node) {
      return node.properties;
    }
  };
  _lodashCollectionEach2["default"]({
    Function: true,
    Class: true,
    Loop: true,
    LabeledStatement: true,
    SwitchStatement: true,
    TryStatement: true
  }, function(amounts, type) {
    if (_lodashLangIsBoolean2["default"](amounts)) {
      amounts = {
        after: amounts,
        before: amounts
      };
    }
    _lodashCollectionEach2["default"]([type].concat(t.FLIPPED_ALIAS_KEYS[type] || []), function(type) {
      exports.nodes[type] = function() {
        return amounts;
      };
    });
  });
  return module.exports;
});

$__System.registerDynamic("95", ["4", "5", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireWildcard = $__require('4')["default"];
  exports.__esModule = true;
  exports.NullableTypeAnnotation = NullableTypeAnnotation;
  exports.UpdateExpression = UpdateExpression;
  exports.ObjectExpression = ObjectExpression;
  exports.Binary = Binary;
  exports.BinaryExpression = BinaryExpression;
  exports.SequenceExpression = SequenceExpression;
  exports.YieldExpression = YieldExpression;
  exports.ClassExpression = ClassExpression;
  exports.UnaryLike = UnaryLike;
  exports.FunctionExpression = FunctionExpression;
  exports.ArrowFunctionExpression = ArrowFunctionExpression;
  exports.ConditionalExpression = ConditionalExpression;
  exports.AssignmentExpression = AssignmentExpression;
  var _babelTypes = $__require('5');
  var t = _interopRequireWildcard(_babelTypes);
  var PRECEDENCE = {
    "||": 0,
    "&&": 1,
    "|": 2,
    "^": 3,
    "&": 4,
    "==": 5,
    "===": 5,
    "!=": 5,
    "!==": 5,
    "<": 6,
    ">": 6,
    "<=": 6,
    ">=": 6,
    "in": 6,
    "instanceof": 6,
    ">>": 7,
    "<<": 7,
    ">>>": 7,
    "+": 8,
    "-": 8,
    "*": 9,
    "/": 9,
    "%": 9,
    "**": 10
  };
  function NullableTypeAnnotation(node, parent) {
    return t.isArrayTypeAnnotation(parent);
  }
  exports.FunctionTypeAnnotation = NullableTypeAnnotation;
  function UpdateExpression(node, parent) {
    if (t.isMemberExpression(parent) && parent.object === node) {
      return true;
    }
    return false;
  }
  function ObjectExpression(node, parent, printStack) {
    if (t.isExpressionStatement(parent)) {
      return true;
    }
    return isFirstInStatement(printStack, true);
  }
  function Binary(node, parent) {
    if ((t.isCallExpression(parent) || t.isNewExpression(parent)) && parent.callee === node) {
      return true;
    }
    if (t.isUnaryLike(parent)) {
      return true;
    }
    if (t.isMemberExpression(parent) && parent.object === node) {
      return true;
    }
    if (t.isBinary(parent)) {
      var parentOp = parent.operator;
      var parentPos = PRECEDENCE[parentOp];
      var nodeOp = node.operator;
      var nodePos = PRECEDENCE[nodeOp];
      if (parentPos > nodePos) {
        return true;
      }
      if (parentPos === nodePos && parent.right === node && !t.isLogicalExpression(parent)) {
        return true;
      }
    }
    return false;
  }
  function BinaryExpression(node, parent) {
    if (node.operator === "in") {
      if (t.isVariableDeclarator(parent)) {
        return true;
      }
      if (t.isFor(parent)) {
        return true;
      }
    }
    return false;
  }
  function SequenceExpression(node, parent) {
    if (t.isForStatement(parent)) {
      return false;
    }
    if (t.isExpressionStatement(parent) && parent.expression === node) {
      return false;
    }
    if (t.isReturnStatement(parent)) {
      return false;
    }
    if (t.isThrowStatement(parent)) {
      return false;
    }
    if (t.isSwitchStatement(parent) && parent.discriminant === node) {
      return false;
    }
    if (t.isWhileStatement(parent) && parent.test === node) {
      return false;
    }
    if (t.isIfStatement(parent) && parent.test === node) {
      return false;
    }
    if (t.isForInStatement(parent) && parent.right === node) {
      return false;
    }
    return true;
  }
  function YieldExpression(node, parent) {
    return t.isBinary(parent) || t.isUnaryLike(parent) || t.isCallExpression(parent) || t.isMemberExpression(parent) || t.isNewExpression(parent);
  }
  exports.AwaitExpression = YieldExpression;
  function ClassExpression(node, parent) {
    if (t.isExpressionStatement(parent)) {
      return true;
    }
    if (t.isExportDeclaration(parent)) {
      return true;
    }
    return false;
  }
  function UnaryLike(node, parent) {
    if (t.isMemberExpression(parent, {object: node})) {
      return true;
    }
    if (t.isCallExpression(parent, {callee: node}) || t.isNewExpression(parent, {callee: node})) {
      return true;
    }
    return false;
  }
  function FunctionExpression(node, parent, printStack) {
    if (t.isExpressionStatement(parent)) {
      return true;
    }
    if (t.isExportDeclaration(parent)) {
      return true;
    }
    return isFirstInStatement(printStack);
  }
  function ArrowFunctionExpression(node, parent) {
    if (t.isExportDeclaration(parent)) {
      return true;
    }
    if (t.isBinaryExpression(parent) || t.isLogicalExpression(parent)) {
      return true;
    }
    if (t.isUnaryExpression(parent)) {
      return true;
    }
    return UnaryLike(node, parent);
  }
  function ConditionalExpression(node, parent) {
    if (t.isUnaryLike(parent)) {
      return true;
    }
    if (t.isBinary(parent)) {
      return true;
    }
    if (t.isConditionalExpression(parent, {test: node})) {
      return true;
    }
    return UnaryLike(node, parent);
  }
  function AssignmentExpression(node) {
    if (t.isObjectPattern(node.left)) {
      return true;
    } else {
      return ConditionalExpression.apply(undefined, arguments);
    }
  }
  function isFirstInStatement(printStack) {
    var considerArrow = arguments.length <= 1 || arguments[1] === undefined ? false : arguments[1];
    var i = printStack.length - 1;
    var node = printStack[i];
    i--;
    var parent = printStack[i];
    while (i > 0) {
      if (t.isExpressionStatement(parent, {expression: node})) {
        return true;
      }
      if (considerArrow && t.isArrowFunctionExpression(parent, {body: node})) {
        return true;
      }
      if (t.isCallExpression(parent, {callee: node}) || t.isSequenceExpression(parent) && parent.expressions[0] === node || t.isMemberExpression(parent, {object: node}) || t.isConditional(parent, {test: node}) || t.isBinary(parent, {left: node}) || t.isAssignmentExpression(parent, {left: node})) {
        node = parent;
        i--;
        parent = printStack[i];
      } else {
        return false;
      }
    }
    return false;
  }
  return module.exports;
});

$__System.registerDynamic("96", ["74", "a", "4", "93", "95", "5", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _Object$keys = $__require('74')["default"];
  var _interopRequireDefault = $__require('a')["default"];
  var _interopRequireWildcard = $__require('4')["default"];
  exports.__esModule = true;
  exports.isUserWhitespacable = isUserWhitespacable;
  exports.needsWhitespace = needsWhitespace;
  exports.needsWhitespaceBefore = needsWhitespaceBefore;
  exports.needsWhitespaceAfter = needsWhitespaceAfter;
  exports.needsParens = needsParens;
  var _whitespace = $__require('93');
  var _whitespace2 = _interopRequireDefault(_whitespace);
  var _parentheses = $__require('95');
  var parens = _interopRequireWildcard(_parentheses);
  var _babelTypes = $__require('5');
  var t = _interopRequireWildcard(_babelTypes);
  function find(obj, node, parent, printStack) {
    if (!obj)
      return;
    var result = undefined;
    var types = _Object$keys(obj);
    for (var i = 0; i < types.length; i++) {
      var type = types[i];
      if (t.is(type, node)) {
        var fn = obj[type];
        result = fn(node, parent, printStack);
        if (result != null)
          break;
      }
    }
    return result;
  }
  function isOrHasCallExpression(node) {
    if (t.isCallExpression(node)) {
      return true;
    }
    if (t.isMemberExpression(node)) {
      return isOrHasCallExpression(node.object) || !node.computed && isOrHasCallExpression(node.property);
    } else {
      return false;
    }
  }
  function isUserWhitespacable(node) {
    return t.isUserWhitespacable(node);
  }
  function needsWhitespace(node, parent, type) {
    if (!node)
      return 0;
    if (t.isExpressionStatement(node)) {
      node = node.expression;
    }
    var linesInfo = find(_whitespace2["default"].nodes, node, parent);
    if (!linesInfo) {
      var items = find(_whitespace2["default"].list, node, parent);
      if (items) {
        for (var i = 0; i < items.length; i++) {
          linesInfo = needsWhitespace(items[i], node, type);
          if (linesInfo)
            break;
        }
      }
    }
    return linesInfo && linesInfo[type] || 0;
  }
  function needsWhitespaceBefore(node, parent) {
    return needsWhitespace(node, parent, "before");
  }
  function needsWhitespaceAfter(node, parent) {
    return needsWhitespace(node, parent, "after");
  }
  function needsParens(node, parent, printStack) {
    if (!parent)
      return false;
    if (t.isNewExpression(parent) && parent.callee === node) {
      if (isOrHasCallExpression(node))
        return true;
    }
    return find(parens, node, parent, printStack);
  }
  return module.exports;
});

$__System.registerDynamic("97", ["a", "4", "8e", "98", "5", "96", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireDefault = $__require('a')["default"];
  var _interopRequireWildcard = $__require('4')["default"];
  exports.__esModule = true;
  exports.UnaryExpression = UnaryExpression;
  exports.DoExpression = DoExpression;
  exports.ParenthesizedExpression = ParenthesizedExpression;
  exports.UpdateExpression = UpdateExpression;
  exports.ConditionalExpression = ConditionalExpression;
  exports.NewExpression = NewExpression;
  exports.SequenceExpression = SequenceExpression;
  exports.ThisExpression = ThisExpression;
  exports.Super = Super;
  exports.Decorator = Decorator;
  exports.CallExpression = CallExpression;
  exports.EmptyStatement = EmptyStatement;
  exports.ExpressionStatement = ExpressionStatement;
  exports.AssignmentPattern = AssignmentPattern;
  exports.AssignmentExpression = AssignmentExpression;
  exports.BindExpression = BindExpression;
  exports.MemberExpression = MemberExpression;
  exports.MetaProperty = MetaProperty;
  var _isInteger = $__require('8e');
  var _isInteger2 = _interopRequireDefault(_isInteger);
  var _lodashLangIsNumber = $__require('98');
  var _lodashLangIsNumber2 = _interopRequireDefault(_lodashLangIsNumber);
  var _babelTypes = $__require('5');
  var t = _interopRequireWildcard(_babelTypes);
  var _node = $__require('96');
  var n = _interopRequireWildcard(_node);
  var SCIENTIFIC_NOTATION = /e/i;
  var ZERO_DECIMAL_INTEGER = /\.0+$/;
  var NON_DECIMAL_LITERAL = /^0[box]/;
  function UnaryExpression(node) {
    var needsSpace = /[a-z]$/.test(node.operator);
    var arg = node.argument;
    if (t.isUpdateExpression(arg) || t.isUnaryExpression(arg)) {
      needsSpace = true;
    }
    if (t.isUnaryExpression(arg) && arg.operator === "!") {
      needsSpace = false;
    }
    this.push(node.operator);
    if (needsSpace)
      this.push(" ");
    this.print(node.argument, node);
  }
  function DoExpression(node) {
    this.push("do");
    this.space();
    this.print(node.body, node);
  }
  function ParenthesizedExpression(node) {
    this.push("(");
    this.print(node.expression, node);
    this.push(")");
  }
  function UpdateExpression(node) {
    if (node.prefix) {
      this.push(node.operator);
      this.print(node.argument, node);
    } else {
      this.print(node.argument, node);
      this.push(node.operator);
    }
  }
  function ConditionalExpression(node) {
    this.print(node.test, node);
    this.space();
    this.push("?");
    this.space();
    this.print(node.consequent, node);
    this.space();
    this.push(":");
    this.space();
    this.print(node.alternate, node);
  }
  function NewExpression(node, parent) {
    this.push("new ");
    this.print(node.callee, node);
    if (node.arguments.length === 0 && this.format.minified && !t.isCallExpression(parent, {callee: node}) && !t.isMemberExpression(parent) && !t.isNewExpression(parent))
      return;
    this.push("(");
    this.printList(node.arguments, node);
    this.push(")");
  }
  function SequenceExpression(node) {
    this.printList(node.expressions, node);
  }
  function ThisExpression() {
    this.push("this");
  }
  function Super() {
    this.push("super");
  }
  function Decorator(node) {
    this.push("@");
    this.print(node.expression, node);
    this.newline();
  }
  function CallExpression(node) {
    this.print(node.callee, node);
    if (node.loc)
      this.printAuxAfterComment();
    this.push("(");
    var isPrettyCall = node._prettyCall && !this.format.retainLines && !this.format.compact;
    var separator = undefined;
    if (isPrettyCall) {
      separator = ",\n";
      this.newline();
      this.indent();
    }
    this.printList(node.arguments, node, {separator: separator});
    if (isPrettyCall) {
      this.newline();
      this.dedent();
    }
    this.push(")");
  }
  function buildYieldAwait(keyword) {
    return function(node) {
      this.push(keyword);
      if (node.delegate) {
        this.push("*");
      }
      if (node.argument) {
        this.push(" ");
        var terminatorState = this.startTerminatorless();
        this.print(node.argument, node);
        this.endTerminatorless(terminatorState);
      }
    };
  }
  var YieldExpression = buildYieldAwait("yield");
  exports.YieldExpression = YieldExpression;
  var AwaitExpression = buildYieldAwait("await");
  exports.AwaitExpression = AwaitExpression;
  function EmptyStatement() {
    this._lastPrintedIsEmptyStatement = true;
    this.semicolon();
  }
  function ExpressionStatement(node) {
    this.print(node.expression, node);
    this.semicolon();
  }
  function AssignmentPattern(node) {
    this.print(node.left, node);
    this.space();
    this.push("=");
    this.space();
    this.print(node.right, node);
  }
  function AssignmentExpression(node, parent) {
    var parens = this._inForStatementInitCounter && node.operator === "in" && !n.needsParens(node, parent);
    if (parens) {
      this.push("(");
    }
    this.print(node.left, node);
    var spaces = !this.format.compact || node.operator === "in" || node.operator === "instanceof";
    if (spaces)
      this.push(" ");
    this.push(node.operator);
    if (!spaces) {
      spaces = node.operator === "<" && t.isUnaryExpression(node.right, {
        prefix: true,
        operator: "!"
      }) && t.isUnaryExpression(node.right.argument, {
        prefix: true,
        operator: "--"
      });
      if (!spaces) {
        var right = getLeftMost(node.right);
        spaces = t.isUnaryExpression(right, {
          prefix: true,
          operator: node.operator
        }) || t.isUpdateExpression(right, {
          prefix: true,
          operator: node.operator + node.operator
        });
      }
    }
    if (spaces)
      this.push(" ");
    this.print(node.right, node);
    if (parens) {
      this.push(")");
    }
  }
  function BindExpression(node) {
    this.print(node.object, node);
    this.push("::");
    this.print(node.callee, node);
  }
  exports.BinaryExpression = AssignmentExpression;
  exports.LogicalExpression = AssignmentExpression;
  function MemberExpression(node) {
    this.print(node.object, node);
    if (!node.computed && t.isMemberExpression(node.property)) {
      throw new TypeError("Got a MemberExpression for MemberExpression property");
    }
    var computed = node.computed;
    if (t.isLiteral(node.property) && _lodashLangIsNumber2["default"](node.property.value)) {
      computed = true;
    }
    if (computed) {
      this.push("[");
      this.print(node.property, node);
      this.push("]");
    } else {
      if (t.isNumericLiteral(node.object)) {
        var val = this.getPossibleRaw(node.object) || node.object.value;
        if (_isInteger2["default"](+val) && !NON_DECIMAL_LITERAL.test(val) && !SCIENTIFIC_NOTATION.test(val) && !ZERO_DECIMAL_INTEGER.test(val) && !this.endsWith(".")) {
          this.push(".");
        }
      }
      this.push(".");
      this.print(node.property, node);
    }
  }
  function MetaProperty(node) {
    this.print(node.meta, node);
    this.push(".");
    this.print(node.property, node);
  }
  function getLeftMost(binaryExpr) {
    if (!t.isBinaryExpression(binaryExpr)) {
      return binaryExpr;
    }
    return getLeftMost(binaryExpr.left);
  }
  return module.exports;
});

$__System.registerDynamic("99", ["a", "4", "76", "5", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireDefault = $__require('a')["default"];
  var _interopRequireWildcard = $__require('4')["default"];
  exports.__esModule = true;
  exports.WithStatement = WithStatement;
  exports.IfStatement = IfStatement;
  exports.ForStatement = ForStatement;
  exports.WhileStatement = WhileStatement;
  exports.DoWhileStatement = DoWhileStatement;
  exports.LabeledStatement = LabeledStatement;
  exports.TryStatement = TryStatement;
  exports.CatchClause = CatchClause;
  exports.SwitchStatement = SwitchStatement;
  exports.SwitchCase = SwitchCase;
  exports.DebuggerStatement = DebuggerStatement;
  exports.VariableDeclaration = VariableDeclaration;
  exports.VariableDeclarator = VariableDeclarator;
  var _repeating = $__require('76');
  var _repeating2 = _interopRequireDefault(_repeating);
  var _babelTypes = $__require('5');
  var t = _interopRequireWildcard(_babelTypes);
  var NON_ALPHABETIC_UNARY_OPERATORS = t.UPDATE_OPERATORS.concat(t.NUMBER_UNARY_OPERATORS).concat(["!"]);
  function WithStatement(node) {
    this.keyword("with");
    this.push("(");
    this.print(node.object, node);
    this.push(")");
    this.printBlock(node);
  }
  function IfStatement(node) {
    this.keyword("if");
    this.push("(");
    this.print(node.test, node);
    this.push(")");
    this.space();
    var needsBlock = node.alternate && t.isIfStatement(getLastStatement(node.consequent));
    if (needsBlock) {
      this.push("{");
      this.newline();
      this.indent();
    }
    this.printAndIndentOnComments(node.consequent, node);
    if (needsBlock) {
      this.dedent();
      this.newline();
      this.push("}");
    }
    if (node.alternate) {
      if (this.isLast("}"))
        this.space();
      this.push("else ");
      this.printAndIndentOnComments(node.alternate, node);
    }
  }
  function getLastStatement(statement) {
    if (!t.isStatement(statement.body))
      return statement;
    return getLastStatement(statement.body);
  }
  function ForStatement(node) {
    this.keyword("for");
    this.push("(");
    this._inForStatementInitCounter++;
    this.print(node.init, node);
    this._inForStatementInitCounter--;
    this.push(";");
    if (node.test) {
      this.space();
      this.print(node.test, node);
    }
    this.push(";");
    if (node.update) {
      this.space();
      this.print(node.update, node);
    }
    this.push(")");
    this.printBlock(node);
  }
  function WhileStatement(node) {
    this.keyword("while");
    this.push("(");
    this.print(node.test, node);
    this.push(")");
    this.printBlock(node);
  }
  var buildForXStatement = function buildForXStatement(op) {
    return function(node) {
      this.keyword("for");
      this.push("(");
      this.print(node.left, node);
      this.push(" " + op + " ");
      this.print(node.right, node);
      this.push(")");
      this.printBlock(node);
    };
  };
  var ForInStatement = buildForXStatement("in");
  exports.ForInStatement = ForInStatement;
  var ForOfStatement = buildForXStatement("of");
  exports.ForOfStatement = ForOfStatement;
  function DoWhileStatement(node) {
    this.push("do ");
    this.print(node.body, node);
    this.space();
    this.keyword("while");
    this.push("(");
    this.print(node.test, node);
    this.push(");");
  }
  function buildLabelStatement(prefix) {
    var key = arguments.length <= 1 || arguments[1] === undefined ? "label" : arguments[1];
    return function(node) {
      this.push(prefix);
      var label = node[key];
      if (label) {
        if (!(this.format.minified && (t.isUnaryExpression(label, {prefix: true}) || t.isUpdateExpression(label, {prefix: true})) && NON_ALPHABETIC_UNARY_OPERATORS.indexOf(label.operator) > -1)) {
          this.push(" ");
        }
        var terminatorState = this.startTerminatorless();
        this.print(label, node);
        this.endTerminatorless(terminatorState);
      }
      this.semicolon();
    };
  }
  var ContinueStatement = buildLabelStatement("continue");
  exports.ContinueStatement = ContinueStatement;
  var ReturnStatement = buildLabelStatement("return", "argument");
  exports.ReturnStatement = ReturnStatement;
  var BreakStatement = buildLabelStatement("break");
  exports.BreakStatement = BreakStatement;
  var ThrowStatement = buildLabelStatement("throw", "argument");
  exports.ThrowStatement = ThrowStatement;
  function LabeledStatement(node) {
    this.print(node.label, node);
    this.push(": ");
    this.print(node.body, node);
  }
  function TryStatement(node) {
    this.keyword("try");
    this.print(node.block, node);
    this.space();
    if (node.handlers) {
      this.print(node.handlers[0], node);
    } else {
      this.print(node.handler, node);
    }
    if (node.finalizer) {
      this.space();
      this.push("finally ");
      this.print(node.finalizer, node);
    }
  }
  function CatchClause(node) {
    this.keyword("catch");
    this.push("(");
    this.print(node.param, node);
    this.push(")");
    this.space();
    this.print(node.body, node);
  }
  function SwitchStatement(node) {
    this.keyword("switch");
    this.push("(");
    this.print(node.discriminant, node);
    this.push(")");
    this.space();
    this.push("{");
    this.printSequence(node.cases, node, {
      indent: true,
      addNewlines: function addNewlines(leading, cas) {
        if (!leading && node.cases[node.cases.length - 1] === cas)
          return -1;
      }
    });
    this.push("}");
  }
  function SwitchCase(node) {
    if (node.test) {
      this.push("case ");
      this.print(node.test, node);
      this.push(":");
    } else {
      this.push("default:");
    }
    if (node.consequent.length) {
      this.newline();
      this.printSequence(node.consequent, node, {indent: true});
    }
  }
  function DebuggerStatement() {
    this.push("debugger;");
  }
  function VariableDeclaration(node, parent) {
    this.push(node.kind + " ");
    var hasInits = false;
    if (!t.isFor(parent)) {
      var _arr = node.declarations;
      for (var _i = 0; _i < _arr.length; _i++) {
        var declar = _arr[_i];
        if (declar.init) {
          hasInits = true;
        }
      }
    }
    var sep = undefined;
    if (!this.format.compact && !this.format.concise && hasInits && !this.format.retainLines) {
      sep = ",\n" + _repeating2["default"](" ", node.kind.length + 1);
    }
    this.printList(node.declarations, node, {separator: sep});
    if (t.isFor(parent)) {
      if (parent.left === node || parent.init === node)
        return;
    }
    this.semicolon();
  }
  function VariableDeclarator(node) {
    this.print(node.id, node);
    this.print(node.id.typeAnnotation, node);
    if (node.init) {
      this.space();
      this.push("=");
      this.space();
      this.print(node.init, node);
    }
  }
  return module.exports;
});

$__System.registerDynamic("9a", ["3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  exports.__esModule = true;
  exports.ClassDeclaration = ClassDeclaration;
  exports.ClassBody = ClassBody;
  exports.ClassProperty = ClassProperty;
  exports.ClassMethod = ClassMethod;
  function ClassDeclaration(node) {
    this.printJoin(node.decorators, node, {separator: ""});
    this.push("class");
    if (node.id) {
      this.push(" ");
      this.print(node.id, node);
    }
    this.print(node.typeParameters, node);
    if (node.superClass) {
      this.push(" extends ");
      this.print(node.superClass, node);
      this.print(node.superTypeParameters, node);
    }
    if (node["implements"]) {
      this.push(" implements ");
      this.printJoin(node["implements"], node, {separator: ", "});
    }
    this.space();
    this.print(node.body, node);
  }
  exports.ClassExpression = ClassDeclaration;
  function ClassBody(node) {
    this.push("{");
    this.printInnerComments(node);
    if (node.body.length === 0) {
      this.push("}");
    } else {
      this.newline();
      this.indent();
      this.printSequence(node.body, node);
      this.dedent();
      this.rightBrace();
    }
  }
  function ClassProperty(node) {
    this.printJoin(node.decorators, node, {separator: ""});
    if (node["static"])
      this.push("static ");
    this.print(node.key, node);
    this.print(node.typeAnnotation, node);
    if (node.value) {
      this.space();
      this.push("=");
      this.space();
      this.print(node.value, node);
    }
    this.semicolon();
  }
  function ClassMethod(node) {
    this.printJoin(node.decorators, node, {separator: ""});
    if (node["static"]) {
      this.push("static ");
    }
    if (node.kind === "constructorCall") {
      this.push("call ");
    }
    this._method(node);
  }
  return module.exports;
});

$__System.registerDynamic("9b", ["4", "5", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireWildcard = $__require('4')["default"];
  exports.__esModule = true;
  exports._params = _params;
  exports._method = _method;
  exports.FunctionExpression = FunctionExpression;
  exports.ArrowFunctionExpression = ArrowFunctionExpression;
  var _babelTypes = $__require('5');
  var t = _interopRequireWildcard(_babelTypes);
  function _params(node) {
    var _this = this;
    this.print(node.typeParameters, node);
    this.push("(");
    this.printList(node.params, node, {iterator: function iterator(node) {
        if (node.optional)
          _this.push("?");
        _this.print(node.typeAnnotation, node);
      }});
    this.push(")");
    if (node.returnType) {
      this.print(node.returnType, node);
    }
  }
  function _method(node) {
    var kind = node.kind;
    var key = node.key;
    if (kind === "method" || kind === "init") {
      if (node.generator) {
        this.push("*");
      }
    }
    if (kind === "get" || kind === "set") {
      this.push(kind + " ");
    }
    if (node.async)
      this.push("async ");
    if (node.computed) {
      this.push("[");
      this.print(key, node);
      this.push("]");
    } else {
      this.print(key, node);
    }
    this._params(node);
    this.space();
    this.print(node.body, node);
  }
  function FunctionExpression(node) {
    if (node.async)
      this.push("async ");
    this.push("function");
    if (node.generator)
      this.push("*");
    if (node.id) {
      this.push(" ");
      this.print(node.id, node);
    } else {
      this.space();
    }
    this._params(node);
    this.space();
    this.print(node.body, node);
  }
  exports.FunctionDeclaration = FunctionExpression;
  function ArrowFunctionExpression(node) {
    if (node.async)
      this.push("async ");
    if (node.params.length === 1 && t.isIdentifier(node.params[0])) {
      this.print(node.params[0], node);
    } else {
      this._params(node);
    }
    this.push(" => ");
    this.print(node.body, node);
  }
  return module.exports;
});

$__System.registerDynamic("9c", ["4", "5", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireWildcard = $__require('4')["default"];
  exports.__esModule = true;
  exports.ImportSpecifier = ImportSpecifier;
  exports.ImportDefaultSpecifier = ImportDefaultSpecifier;
  exports.ExportDefaultSpecifier = ExportDefaultSpecifier;
  exports.ExportSpecifier = ExportSpecifier;
  exports.ExportNamespaceSpecifier = ExportNamespaceSpecifier;
  exports.ExportAllDeclaration = ExportAllDeclaration;
  exports.ExportNamedDeclaration = ExportNamedDeclaration;
  exports.ExportDefaultDeclaration = ExportDefaultDeclaration;
  exports.ImportDeclaration = ImportDeclaration;
  exports.ImportNamespaceSpecifier = ImportNamespaceSpecifier;
  var _babelTypes = $__require('5');
  var t = _interopRequireWildcard(_babelTypes);
  function ImportSpecifier(node) {
    this.print(node.imported, node);
    if (node.local && node.local.name !== node.imported.name) {
      this.push(" as ");
      this.print(node.local, node);
    }
  }
  function ImportDefaultSpecifier(node) {
    this.print(node.local, node);
  }
  function ExportDefaultSpecifier(node) {
    this.print(node.exported, node);
  }
  function ExportSpecifier(node) {
    this.print(node.local, node);
    if (node.exported && node.local.name !== node.exported.name) {
      this.push(" as ");
      this.print(node.exported, node);
    }
  }
  function ExportNamespaceSpecifier(node) {
    this.push("* as ");
    this.print(node.exported, node);
  }
  function ExportAllDeclaration(node) {
    this.push("export *");
    if (node.exported) {
      this.push(" as ");
      this.print(node.exported, node);
    }
    this.push(" from ");
    this.print(node.source, node);
    this.semicolon();
  }
  function ExportNamedDeclaration() {
    this.push("export ");
    ExportDeclaration.apply(this, arguments);
  }
  function ExportDefaultDeclaration() {
    this.push("export default ");
    ExportDeclaration.apply(this, arguments);
  }
  function ExportDeclaration(node) {
    if (node.declaration) {
      var declar = node.declaration;
      this.print(declar, node);
      if (t.isStatement(declar) || t.isFunction(declar) || t.isClass(declar))
        return;
    } else {
      if (node.exportKind === "type") {
        this.push("type ");
      }
      var specifiers = node.specifiers.slice(0);
      var hasSpecial = false;
      while (true) {
        var first = specifiers[0];
        if (t.isExportDefaultSpecifier(first) || t.isExportNamespaceSpecifier(first)) {
          hasSpecial = true;
          this.print(specifiers.shift(), node);
          if (specifiers.length) {
            this.push(", ");
          }
        } else {
          break;
        }
      }
      if (specifiers.length || !specifiers.length && !hasSpecial) {
        this.push("{");
        if (specifiers.length) {
          this.space();
          this.printJoin(specifiers, node, {separator: ", "});
          this.space();
        }
        this.push("}");
      }
      if (node.source) {
        this.push(" from ");
        this.print(node.source, node);
      }
    }
    this.ensureSemicolon();
  }
  function ImportDeclaration(node) {
    this.push("import ");
    if (node.importKind === "type" || node.importKind === "typeof") {
      this.push(node.importKind + " ");
    }
    var specifiers = node.specifiers.slice(0);
    if (specifiers && specifiers.length) {
      while (true) {
        var first = specifiers[0];
        if (t.isImportDefaultSpecifier(first) || t.isImportNamespaceSpecifier(first)) {
          this.print(specifiers.shift(), node);
          if (specifiers.length) {
            this.push(", ");
          }
        } else {
          break;
        }
      }
      if (specifiers.length) {
        this.push("{");
        this.space();
        this.printJoin(specifiers, node, {separator: ", "});
        this.space();
        this.push("}");
      }
      this.push(" from ");
    }
    this.print(node.source, node);
    this.semicolon();
  }
  function ImportNamespaceSpecifier(node) {
    this.push("* as ");
    this.print(node.local, node);
  }
  return module.exports;
});

$__System.registerDynamic("9d", ["4", "5", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireWildcard = $__require('4')["default"];
  exports.__esModule = true;
  exports.Identifier = Identifier;
  exports.RestElement = RestElement;
  exports.ObjectExpression = ObjectExpression;
  exports.ObjectMethod = ObjectMethod;
  exports.ObjectProperty = ObjectProperty;
  exports.ArrayExpression = ArrayExpression;
  exports.RegExpLiteral = RegExpLiteral;
  exports.BooleanLiteral = BooleanLiteral;
  exports.NullLiteral = NullLiteral;
  exports.NumericLiteral = NumericLiteral;
  exports.StringLiteral = StringLiteral;
  exports._stringLiteral = _stringLiteral;
  var _babelTypes = $__require('5');
  var t = _interopRequireWildcard(_babelTypes);
  function Identifier(node) {
    if (node.variance === "plus") {
      this.push("+");
    } else if (node.variance === "minus") {
      this.push("-");
    }
    this.push(node.name);
  }
  function RestElement(node) {
    this.push("...");
    this.print(node.argument, node);
  }
  exports.SpreadElement = RestElement;
  exports.SpreadProperty = RestElement;
  exports.RestProperty = RestElement;
  function ObjectExpression(node) {
    var props = node.properties;
    this.push("{");
    this.printInnerComments(node);
    if (props.length) {
      this.space();
      this.printList(props, node, {indent: true});
      this.space();
    }
    this.push("}");
  }
  exports.ObjectPattern = ObjectExpression;
  function ObjectMethod(node) {
    this.printJoin(node.decorators, node, {separator: ""});
    this._method(node);
  }
  function ObjectProperty(node) {
    this.printJoin(node.decorators, node, {separator: ""});
    if (node.computed) {
      this.push("[");
      this.print(node.key, node);
      this.push("]");
    } else {
      if (t.isAssignmentPattern(node.value) && t.isIdentifier(node.key) && node.key.name === node.value.left.name) {
        this.print(node.value, node);
        return;
      }
      this.print(node.key, node);
      if (node.shorthand && t.isIdentifier(node.key) && t.isIdentifier(node.value) && node.key.name === node.value.name) {
        return;
      }
    }
    this.push(":");
    this.space();
    this.print(node.value, node);
  }
  function ArrayExpression(node) {
    var elems = node.elements;
    var len = elems.length;
    this.push("[");
    this.printInnerComments(node);
    for (var i = 0; i < elems.length; i++) {
      var elem = elems[i];
      if (elem) {
        if (i > 0)
          this.space();
        this.print(elem, node);
        if (i < len - 1)
          this.push(",");
      } else {
        this.push(",");
      }
    }
    this.push("]");
  }
  exports.ArrayPattern = ArrayExpression;
  function RegExpLiteral(node) {
    this.push("/" + node.pattern + "/" + node.flags);
  }
  function BooleanLiteral(node) {
    this.push(node.value ? "true" : "false");
  }
  function NullLiteral() {
    this.push("null");
  }
  function NumericLiteral(node) {
    this.push(node.value + "");
  }
  function StringLiteral(node, parent) {
    this.push(this._stringLiteral(node.value, parent));
  }
  function _stringLiteral(val, parent) {
    val = JSON.stringify(val);
    val = val.replace(/[\u000A\u000D\u2028\u2029]/g, function(c) {
      return "\\u" + ("0000" + c.charCodeAt(0).toString(16)).slice(-4);
    });
    if (this.format.quotes === "single" && !t.isJSX(parent)) {
      val = val.slice(1, -1);
      val = val.replace(/\\"/g, '"');
      val = val.replace(/'/g, "\\'");
      val = "'" + val + "'";
    }
    return val;
  }
  return module.exports;
});

$__System.registerDynamic("9e", ["4", "5", "9d", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireWildcard = $__require('4')["default"];
  exports.__esModule = true;
  exports.AnyTypeAnnotation = AnyTypeAnnotation;
  exports.ArrayTypeAnnotation = ArrayTypeAnnotation;
  exports.BooleanTypeAnnotation = BooleanTypeAnnotation;
  exports.BooleanLiteralTypeAnnotation = BooleanLiteralTypeAnnotation;
  exports.NullLiteralTypeAnnotation = NullLiteralTypeAnnotation;
  exports.DeclareClass = DeclareClass;
  exports.DeclareFunction = DeclareFunction;
  exports.DeclareInterface = DeclareInterface;
  exports.DeclareModule = DeclareModule;
  exports.DeclareTypeAlias = DeclareTypeAlias;
  exports.DeclareVariable = DeclareVariable;
  exports.ExistentialTypeParam = ExistentialTypeParam;
  exports.FunctionTypeAnnotation = FunctionTypeAnnotation;
  exports.FunctionTypeParam = FunctionTypeParam;
  exports.InterfaceExtends = InterfaceExtends;
  exports._interfaceish = _interfaceish;
  exports.InterfaceDeclaration = InterfaceDeclaration;
  exports.IntersectionTypeAnnotation = IntersectionTypeAnnotation;
  exports.MixedTypeAnnotation = MixedTypeAnnotation;
  exports.NullableTypeAnnotation = NullableTypeAnnotation;
  exports.NumberTypeAnnotation = NumberTypeAnnotation;
  exports.StringLiteralTypeAnnotation = StringLiteralTypeAnnotation;
  exports.StringTypeAnnotation = StringTypeAnnotation;
  exports.ThisTypeAnnotation = ThisTypeAnnotation;
  exports.TupleTypeAnnotation = TupleTypeAnnotation;
  exports.TypeofTypeAnnotation = TypeofTypeAnnotation;
  exports.TypeAlias = TypeAlias;
  exports.TypeAnnotation = TypeAnnotation;
  exports.TypeParameterInstantiation = TypeParameterInstantiation;
  exports.ObjectTypeAnnotation = ObjectTypeAnnotation;
  exports.ObjectTypeCallProperty = ObjectTypeCallProperty;
  exports.ObjectTypeIndexer = ObjectTypeIndexer;
  exports.ObjectTypeProperty = ObjectTypeProperty;
  exports.QualifiedTypeIdentifier = QualifiedTypeIdentifier;
  exports.UnionTypeAnnotation = UnionTypeAnnotation;
  exports.TypeCastExpression = TypeCastExpression;
  exports.VoidTypeAnnotation = VoidTypeAnnotation;
  var _babelTypes = $__require('5');
  var t = _interopRequireWildcard(_babelTypes);
  function AnyTypeAnnotation() {
    this.push("any");
  }
  function ArrayTypeAnnotation(node) {
    this.print(node.elementType, node);
    this.push("[");
    this.push("]");
  }
  function BooleanTypeAnnotation() {
    this.push("bool");
  }
  function BooleanLiteralTypeAnnotation(node) {
    this.push(node.value ? "true" : "false");
  }
  function NullLiteralTypeAnnotation() {
    this.push("null");
  }
  function DeclareClass(node) {
    this.push("declare class ");
    this._interfaceish(node);
  }
  function DeclareFunction(node) {
    this.push("declare function ");
    this.print(node.id, node);
    this.print(node.id.typeAnnotation.typeAnnotation, node);
    this.semicolon();
  }
  function DeclareInterface(node) {
    this.push("declare ");
    this.InterfaceDeclaration(node);
  }
  function DeclareModule(node) {
    this.push("declare module ");
    this.print(node.id, node);
    this.space();
    this.print(node.body, node);
  }
  function DeclareTypeAlias(node) {
    this.push("declare ");
    this.TypeAlias(node);
  }
  function DeclareVariable(node) {
    this.push("declare var ");
    this.print(node.id, node);
    this.print(node.id.typeAnnotation, node);
    this.semicolon();
  }
  function ExistentialTypeParam() {
    this.push("*");
  }
  function FunctionTypeAnnotation(node, parent) {
    this.print(node.typeParameters, node);
    this.push("(");
    this.printList(node.params, node);
    if (node.rest) {
      if (node.params.length) {
        this.push(",");
        this.space();
      }
      this.push("...");
      this.print(node.rest, node);
    }
    this.push(")");
    if (parent.type === "ObjectTypeProperty" || parent.type === "ObjectTypeCallProperty" || parent.type === "DeclareFunction") {
      this.push(":");
    } else {
      this.space();
      this.push("=>");
    }
    this.space();
    this.print(node.returnType, node);
  }
  function FunctionTypeParam(node) {
    this.print(node.name, node);
    if (node.optional)
      this.push("?");
    this.push(":");
    this.space();
    this.print(node.typeAnnotation, node);
  }
  function InterfaceExtends(node) {
    this.print(node.id, node);
    this.print(node.typeParameters, node);
  }
  exports.ClassImplements = InterfaceExtends;
  exports.GenericTypeAnnotation = InterfaceExtends;
  function _interfaceish(node) {
    this.print(node.id, node);
    this.print(node.typeParameters, node);
    if (node["extends"].length) {
      this.push(" extends ");
      this.printJoin(node["extends"], node, {separator: ", "});
    }
    if (node.mixins && node.mixins.length) {
      this.push(" mixins ");
      this.printJoin(node.mixins, node, {separator: ", "});
    }
    this.space();
    this.print(node.body, node);
  }
  function InterfaceDeclaration(node) {
    this.push("interface ");
    this._interfaceish(node);
  }
  function IntersectionTypeAnnotation(node) {
    this.printJoin(node.types, node, {separator: " & "});
  }
  function MixedTypeAnnotation() {
    this.push("mixed");
  }
  function NullableTypeAnnotation(node) {
    this.push("?");
    this.print(node.typeAnnotation, node);
  }
  var _types = $__require('9d');
  exports.NumericLiteralTypeAnnotation = _types.NumericLiteral;
  function NumberTypeAnnotation() {
    this.push("number");
  }
  function StringLiteralTypeAnnotation(node) {
    this.push(this._stringLiteral(node.value));
  }
  function StringTypeAnnotation() {
    this.push("string");
  }
  function ThisTypeAnnotation() {
    this.push("this");
  }
  function TupleTypeAnnotation(node) {
    this.push("[");
    this.printJoin(node.types, node, {separator: ", "});
    this.push("]");
  }
  function TypeofTypeAnnotation(node) {
    this.push("typeof ");
    this.print(node.argument, node);
  }
  function TypeAlias(node) {
    this.push("type ");
    this.print(node.id, node);
    this.print(node.typeParameters, node);
    this.space();
    this.push("=");
    this.space();
    this.print(node.right, node);
    this.semicolon();
  }
  function TypeAnnotation(node) {
    this.push(":");
    this.space();
    if (node.optional)
      this.push("?");
    this.print(node.typeAnnotation, node);
  }
  function TypeParameterInstantiation(node) {
    var _this = this;
    this.push("<");
    this.printJoin(node.params, node, {
      separator: ", ",
      iterator: function iterator(node) {
        _this.print(node.typeAnnotation, node);
      }
    });
    this.push(">");
  }
  exports.TypeParameterDeclaration = TypeParameterInstantiation;
  function ObjectTypeAnnotation(node) {
    var _this2 = this;
    this.push("{");
    var props = node.properties.concat(node.callProperties, node.indexers);
    if (props.length) {
      this.space();
      this.printJoin(props, node, {
        separator: false,
        indent: true,
        iterator: function iterator() {
          if (props.length !== 1) {
            _this2.semicolon();
            _this2.space();
          }
        }
      });
      this.space();
    }
    this.push("}");
  }
  function ObjectTypeCallProperty(node) {
    if (node["static"])
      this.push("static ");
    this.print(node.value, node);
  }
  function ObjectTypeIndexer(node) {
    if (node["static"])
      this.push("static ");
    this.push("[");
    this.print(node.id, node);
    this.push(":");
    this.space();
    this.print(node.key, node);
    this.push("]");
    this.push(":");
    this.space();
    this.print(node.value, node);
  }
  function ObjectTypeProperty(node) {
    if (node["static"])
      this.push("static ");
    this.print(node.key, node);
    if (node.optional)
      this.push("?");
    if (!t.isFunctionTypeAnnotation(node.value)) {
      this.push(":");
      this.space();
    }
    this.print(node.value, node);
  }
  function QualifiedTypeIdentifier(node) {
    this.print(node.qualification, node);
    this.push(".");
    this.print(node.id, node);
  }
  function UnionTypeAnnotation(node) {
    this.printJoin(node.types, node, {separator: " | "});
  }
  function TypeCastExpression(node) {
    this.push("(");
    this.print(node.expression, node);
    this.print(node.typeAnnotation, node);
    this.push(")");
  }
  function VoidTypeAnnotation() {
    this.push("void");
  }
  return module.exports;
});

$__System.registerDynamic("9f", ["3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  exports.__esModule = true;
  exports.File = File;
  exports.Program = Program;
  exports.BlockStatement = BlockStatement;
  exports.Noop = Noop;
  exports.Directive = Directive;
  exports.DirectiveLiteral = DirectiveLiteral;
  function File(node) {
    this.print(node.program, node);
  }
  function Program(node) {
    this.printInnerComments(node, false);
    this.printSequence(node.directives, node);
    if (node.directives && node.directives.length)
      this.newline();
    this.printSequence(node.body, node);
  }
  function BlockStatement(node) {
    this.push("{");
    this.printInnerComments(node);
    if (node.body.length) {
      this.newline();
      this.printSequence(node.directives, node, {indent: true});
      if (node.directives && node.directives.length)
        this.newline();
      this.printSequence(node.body, node, {indent: true});
      if (!this.format.retainLines && !this.format.concise)
        this.removeLast("\n");
      this.rightBrace();
    } else {
      this.push("}");
    }
  }
  function Noop() {}
  function Directive(node) {
    this.print(node.value, node);
    this.semicolon();
  }
  function DirectiveLiteral(node) {
    this.push(this._stringLiteral(node.value));
  }
  return module.exports;
});

$__System.registerDynamic("a0", ["3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  exports.__esModule = true;
  exports.JSXAttribute = JSXAttribute;
  exports.JSXIdentifier = JSXIdentifier;
  exports.JSXNamespacedName = JSXNamespacedName;
  exports.JSXMemberExpression = JSXMemberExpression;
  exports.JSXSpreadAttribute = JSXSpreadAttribute;
  exports.JSXExpressionContainer = JSXExpressionContainer;
  exports.JSXText = JSXText;
  exports.JSXElement = JSXElement;
  exports.JSXOpeningElement = JSXOpeningElement;
  exports.JSXClosingElement = JSXClosingElement;
  exports.JSXEmptyExpression = JSXEmptyExpression;
  function JSXAttribute(node) {
    this.print(node.name, node);
    if (node.value) {
      this.push("=");
      this.print(node.value, node);
    }
  }
  function JSXIdentifier(node) {
    this.push(node.name);
  }
  function JSXNamespacedName(node) {
    this.print(node.namespace, node);
    this.push(":");
    this.print(node.name, node);
  }
  function JSXMemberExpression(node) {
    this.print(node.object, node);
    this.push(".");
    this.print(node.property, node);
  }
  function JSXSpreadAttribute(node) {
    this.push("{...");
    this.print(node.argument, node);
    this.push("}");
  }
  function JSXExpressionContainer(node) {
    this.push("{");
    this.print(node.expression, node);
    this.push("}");
  }
  function JSXText(node) {
    this.push(node.value, true);
  }
  function JSXElement(node) {
    var open = node.openingElement;
    this.print(open, node);
    if (open.selfClosing)
      return;
    this.indent();
    var _arr = node.children;
    for (var _i = 0; _i < _arr.length; _i++) {
      var child = _arr[_i];
      this.print(child, node);
    }
    this.dedent();
    this.print(node.closingElement, node);
  }
  function JSXOpeningElement(node) {
    this.push("<");
    this.print(node.name, node);
    if (node.attributes.length > 0) {
      this.push(" ");
      this.printJoin(node.attributes, node, {separator: " "});
    }
    this.push(node.selfClosing ? " />" : ">");
  }
  function JSXClosingElement(node) {
    this.push("</");
    this.print(node.name, node);
    this.push(">");
  }
  function JSXEmptyExpression() {}
  return module.exports;
});

$__System.registerDynamic("a1", ["f", "9", "49", "a", "4", "76", "8c", "96", "5", "8d", "97", "99", "9a", "9b", "9c", "9d", "9e", "9f", "a0", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _inherits = $__require('f')["default"];
  var _classCallCheck = $__require('9')["default"];
  var _Object$assign = $__require('49')["default"];
  var _interopRequireDefault = $__require('a')["default"];
  var _interopRequireWildcard = $__require('4')["default"];
  exports.__esModule = true;
  var _repeating = $__require('76');
  var _repeating2 = _interopRequireDefault(_repeating);
  var _buffer = $__require('8c');
  var _buffer2 = _interopRequireDefault(_buffer);
  var _node = $__require('96');
  var n = _interopRequireWildcard(_node);
  var _babelTypes = $__require('5');
  var t = _interopRequireWildcard(_babelTypes);
  var Printer = (function(_Buffer) {
    _inherits(Printer, _Buffer);
    function Printer() {
      _classCallCheck(this, Printer);
      for (var _len = arguments.length,
          args = Array(_len),
          _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }
      _Buffer.call.apply(_Buffer, [this].concat(args));
      this.insideAux = false;
      this.printAuxAfterOnNextUserNode = false;
      this._printStack = [];
    }
    Printer.prototype.print = function print(node, parent) {
      var opts = arguments.length <= 2 || arguments[2] === undefined ? {} : arguments[2];
      if (!node)
        return;
      this._lastPrintedIsEmptyStatement = false;
      if (parent && parent._compact) {
        node._compact = true;
      }
      var oldInAux = this.insideAux;
      this.insideAux = !node.loc;
      var oldConcise = this.format.concise;
      if (node._compact) {
        this.format.concise = true;
      }
      var printMethod = this[node.type];
      if (!printMethod) {
        throw new ReferenceError("unknown node of type " + JSON.stringify(node.type) + " with constructor " + JSON.stringify(node && node.constructor.name));
      }
      this._printStack.push(node);
      if (node.loc)
        this.printAuxAfterComment();
      this.printAuxBeforeComment(oldInAux);
      var needsParens = n.needsParens(node, parent, this._printStack);
      if (needsParens)
        this.push("(");
      this.printLeadingComments(node, parent);
      this.catchUp(node);
      this._printNewline(true, node, parent, opts);
      if (opts.before)
        opts.before();
      this.map.mark(node);
      this._print(node, parent);
      if (node.loc)
        this.printAuxAfterComment();
      this.printTrailingComments(node, parent);
      if (needsParens)
        this.push(")");
      this._printStack.pop();
      if (parent)
        this.map.mark(parent);
      if (opts.after)
        opts.after();
      this.format.concise = oldConcise;
      this.insideAux = oldInAux;
      this._printNewline(false, node, parent, opts);
    };
    Printer.prototype.printAuxBeforeComment = function printAuxBeforeComment(wasInAux) {
      var comment = this.format.auxiliaryCommentBefore;
      if (!wasInAux && this.insideAux && !this.printAuxAfterOnNextUserNode) {
        this.printAuxAfterOnNextUserNode = true;
        if (comment)
          this.printComment({
            type: "CommentBlock",
            value: comment
          });
      }
    };
    Printer.prototype.printAuxAfterComment = function printAuxAfterComment() {
      if (this.printAuxAfterOnNextUserNode) {
        this.printAuxAfterOnNextUserNode = false;
        var comment = this.format.auxiliaryCommentAfter;
        if (comment)
          this.printComment({
            type: "CommentBlock",
            value: comment
          });
      }
    };
    Printer.prototype.getPossibleRaw = function getPossibleRaw(node) {
      var extra = node.extra;
      if (extra && extra.raw != null && extra.rawValue != null && node.value === extra.rawValue) {
        return extra.raw;
      }
    };
    Printer.prototype._print = function _print(node, parent) {
      if (!this.format.minified) {
        var extra = this.getPossibleRaw(node);
        if (extra) {
          this.push("");
          this._push(extra);
          return;
        }
      }
      var printMethod = this[node.type];
      printMethod.call(this, node, parent);
    };
    Printer.prototype.printJoin = function printJoin(nodes, parent) {
      var _this = this;
      var opts = arguments.length <= 2 || arguments[2] === undefined ? {} : arguments[2];
      if (!nodes || !nodes.length)
        return;
      var len = nodes.length;
      var node = undefined,
          i = undefined;
      if (opts.indent)
        this.indent();
      var printOpts = {
        statement: opts.statement,
        addNewlines: opts.addNewlines,
        after: function after() {
          if (opts.iterator) {
            opts.iterator(node, i);
          }
          if (opts.separator && parent.loc) {
            _this.printAuxAfterComment();
          }
          if (opts.separator && i < len - 1) {
            _this.push(opts.separator);
          }
        }
      };
      for (i = 0; i < nodes.length; i++) {
        node = nodes[i];
        this.print(node, parent, printOpts);
      }
      if (opts.indent)
        this.dedent();
    };
    Printer.prototype.printAndIndentOnComments = function printAndIndentOnComments(node, parent) {
      var indent = !!node.leadingComments;
      if (indent)
        this.indent();
      this.print(node, parent);
      if (indent)
        this.dedent();
    };
    Printer.prototype.printBlock = function printBlock(parent) {
      var node = parent.body;
      if (!t.isEmptyStatement(node)) {
        this.space();
      }
      this.print(node, parent);
    };
    Printer.prototype.generateComment = function generateComment(comment) {
      var val = comment.value;
      if (comment.type === "CommentLine") {
        val = "//" + val;
      } else {
        val = "/*" + val + "*/";
      }
      return val;
    };
    Printer.prototype.printTrailingComments = function printTrailingComments(node, parent) {
      this.printComments(this.getComments("trailingComments", node, parent));
    };
    Printer.prototype.printLeadingComments = function printLeadingComments(node, parent) {
      this.printComments(this.getComments("leadingComments", node, parent));
    };
    Printer.prototype.printInnerComments = function printInnerComments(node) {
      var indent = arguments.length <= 1 || arguments[1] === undefined ? true : arguments[1];
      if (!node.innerComments)
        return;
      if (indent)
        this.indent();
      this.printComments(node.innerComments);
      if (indent)
        this.dedent();
    };
    Printer.prototype.printSequence = function printSequence(nodes, parent) {
      var opts = arguments.length <= 2 || arguments[2] === undefined ? {} : arguments[2];
      opts.statement = true;
      return this.printJoin(nodes, parent, opts);
    };
    Printer.prototype.printList = function printList(items, parent) {
      var opts = arguments.length <= 2 || arguments[2] === undefined ? {} : arguments[2];
      if (opts.separator == null) {
        opts.separator = ",";
        if (!this.format.compact)
          opts.separator += " ";
      }
      return this.printJoin(items, parent, opts);
    };
    Printer.prototype._printNewline = function _printNewline(leading, node, parent, opts) {
      if (!opts.statement && !n.isUserWhitespacable(node, parent)) {
        return;
      }
      var lines = 0;
      if (node.start != null && !node._ignoreUserWhitespace && this.tokens.length) {
        if (leading) {
          lines = this.whitespace.getNewlinesBefore(node);
        } else {
          lines = this.whitespace.getNewlinesAfter(node);
        }
      } else {
        if (!leading)
          lines++;
        if (opts.addNewlines)
          lines += opts.addNewlines(leading, node) || 0;
        var needs = n.needsWhitespaceAfter;
        if (leading)
          needs = n.needsWhitespaceBefore;
        if (needs(node, parent))
          lines++;
        if (!this.buf)
          lines = 0;
      }
      this.newline(lines);
    };
    Printer.prototype.getComments = function getComments(key, node) {
      return node && node[key] || [];
    };
    Printer.prototype.shouldPrintComment = function shouldPrintComment(comment) {
      if (this.format.shouldPrintComment) {
        return this.format.shouldPrintComment(comment.value);
      } else {
        if (!this.format.minified && (comment.value.indexOf("@license") >= 0 || comment.value.indexOf("@preserve") >= 0)) {
          return true;
        } else {
          return this.format.comments;
        }
      }
    };
    Printer.prototype.printComment = function printComment(comment) {
      if (!this.shouldPrintComment(comment))
        return;
      if (comment.ignore)
        return;
      comment.ignore = true;
      if (comment.start != null) {
        if (this.printedCommentStarts[comment.start])
          return;
        this.printedCommentStarts[comment.start] = true;
      }
      this.catchUp(comment);
      this.newline(this.whitespace.getNewlinesBefore(comment));
      var column = this.position.column;
      var val = this.generateComment(comment);
      if (column && !this.isLast(["\n", " ", "[", "{"])) {
        this._push(" ");
        column++;
      }
      if (comment.type === "CommentBlock" && this.format.indent.adjustMultilineComment) {
        var offset = comment.loc && comment.loc.start.column;
        if (offset) {
          var newlineRegex = new RegExp("\\n\\s{1," + offset + "}", "g");
          val = val.replace(newlineRegex, "\n");
        }
        var indent = Math.max(this.indentSize(), column);
        val = val.replace(/\n/g, "\n" + _repeating2["default"](" ", indent));
      }
      if (column === 0) {
        val = this.getIndent() + val;
      }
      if ((this.format.compact || this.format.concise || this.format.retainLines) && comment.type === "CommentLine") {
        val += "\n";
      }
      this._push(val);
      this.newline(this.whitespace.getNewlinesAfter(comment));
    };
    Printer.prototype.printComments = function printComments(comments) {
      if (!comments || !comments.length)
        return;
      for (var _i = 0; _i < comments.length; _i++) {
        var comment = comments[_i];
        this.printComment(comment);
      }
    };
    return Printer;
  })(_buffer2["default"]);
  exports["default"] = Printer;
  var _arr = [$__require('8d'), $__require('97'), $__require('99'), $__require('9a'), $__require('9b'), $__require('9c'), $__require('9d'), $__require('9e'), $__require('9f'), $__require('a0')];
  for (var _i2 = 0; _i2 < _arr.length; _i2++) {
    var generator = _arr[_i2];
    _Object$assign(Printer.prototype, generator);
  }
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("6e", ["f", "9", "a", "4", "75", "77", "82", "83", "4a", "a1", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _inherits = $__require('f')["default"];
  var _classCallCheck = $__require('9')["default"];
  var _interopRequireDefault = $__require('a')["default"];
  var _interopRequireWildcard = $__require('4')["default"];
  exports.__esModule = true;
  var _detectIndent = $__require('75');
  var _detectIndent2 = _interopRequireDefault(_detectIndent);
  var _whitespace = $__require('77');
  var _whitespace2 = _interopRequireDefault(_whitespace);
  var _sourceMap = $__require('82');
  var _sourceMap2 = _interopRequireDefault(_sourceMap);
  var _position = $__require('83');
  var _position2 = _interopRequireDefault(_position);
  var _babelMessages = $__require('4a');
  var messages = _interopRequireWildcard(_babelMessages);
  var _printer = $__require('a1');
  var _printer2 = _interopRequireDefault(_printer);
  var CodeGenerator = (function(_Printer) {
    _inherits(CodeGenerator, _Printer);
    function CodeGenerator(ast, opts, code) {
      _classCallCheck(this, CodeGenerator);
      opts = opts || {};
      var comments = ast.comments || [];
      var tokens = ast.tokens || [];
      var format = CodeGenerator.normalizeOptions(code, opts, tokens);
      var position = new _position2["default"]();
      _Printer.call(this, position, format);
      this.comments = comments;
      this.position = position;
      this.tokens = tokens;
      this.format = format;
      this.opts = opts;
      this.ast = ast;
      this._inForStatementInitCounter = 0;
      this.whitespace = new _whitespace2["default"](tokens);
      this.map = new _sourceMap2["default"](position, opts, code);
    }
    CodeGenerator.normalizeOptions = function normalizeOptions(code, opts, tokens) {
      var style = "  ";
      if (code && typeof code === "string") {
        var _indent = _detectIndent2["default"](code).indent;
        if (_indent && _indent !== " ")
          style = _indent;
      }
      var format = {
        auxiliaryCommentBefore: opts.auxiliaryCommentBefore,
        auxiliaryCommentAfter: opts.auxiliaryCommentAfter,
        shouldPrintComment: opts.shouldPrintComment,
        retainLines: opts.retainLines,
        comments: opts.comments == null || opts.comments,
        compact: opts.compact,
        minified: opts.minified,
        concise: opts.concise,
        quotes: opts.quotes || CodeGenerator.findCommonStringDelimiter(code, tokens),
        indent: {
          adjustMultilineComment: true,
          style: style,
          base: 0
        }
      };
      if (format.minified) {
        format.compact = true;
      }
      if (format.compact === "auto") {
        format.compact = code.length > 100000;
        if (format.compact) {
          console.error("[BABEL] " + messages.get("codeGeneratorDeopt", opts.filename, "100KB"));
        }
      }
      if (format.compact) {
        format.indent.adjustMultilineComment = false;
      }
      return format;
    };
    CodeGenerator.findCommonStringDelimiter = function findCommonStringDelimiter(code, tokens) {
      var occurences = {
        single: 0,
        double: 0
      };
      var checked = 0;
      for (var i = 0; i < tokens.length; i++) {
        var token = tokens[i];
        if (token.type.label !== "string")
          continue;
        var raw = code.slice(token.start, token.end);
        if (raw[0] === "'") {
          occurences.single++;
        } else {
          occurences.double++;
        }
        checked++;
        if (checked >= 3)
          break;
      }
      if (occurences.single > occurences.double) {
        return "single";
      } else {
        return "double";
      }
    };
    CodeGenerator.prototype.generate = function generate() {
      this.print(this.ast);
      this.printAuxAfterComment();
      return {
        map: this.map.get(),
        code: this.get()
      };
    };
    return CodeGenerator;
  })(_printer2["default"]);
  exports.CodeGenerator = CodeGenerator;
  exports["default"] = function(ast, opts, code) {
    var gen = new CodeGenerator(ast, opts, code);
    return gen.generate();
  };
  return module.exports;
});

$__System.registerDynamic("a2", ["4", "a", "6c", "6e", "4a", "73", "94", "5", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireWildcard = $__require('4')["default"];
  var _interopRequireDefault = $__require('a')["default"];
  exports.__esModule = true;
  var _babelHelpers = $__require('6c');
  var helpers = _interopRequireWildcard(_babelHelpers);
  var _babelGenerator = $__require('6e');
  var _babelGenerator2 = _interopRequireDefault(_babelGenerator);
  var _babelMessages = $__require('4a');
  var messages = _interopRequireWildcard(_babelMessages);
  var _babelTemplate = $__require('73');
  var _babelTemplate2 = _interopRequireDefault(_babelTemplate);
  var _lodashCollectionEach = $__require('94');
  var _lodashCollectionEach2 = _interopRequireDefault(_lodashCollectionEach);
  var _babelTypes = $__require('5');
  var t = _interopRequireWildcard(_babelTypes);
  var buildUmdWrapper = _babelTemplate2["default"]("\n  (function (root, factory) {\n    if (typeof define === \"function\" && define.amd) {\n      define(AMD_ARGUMENTS, factory);\n    } else if (typeof exports === \"object\") {\n      factory(COMMON_ARGUMENTS);\n    } else {\n      factory(BROWSER_ARGUMENTS);\n    }\n  })(UMD_ROOT, function (FACTORY_PARAMETERS) {\n    FACTORY_BODY\n  });\n");
  function buildGlobal(namespace, builder) {
    var body = [];
    var container = t.functionExpression(null, [t.identifier("global")], t.blockStatement(body));
    var tree = t.program([t.expressionStatement(t.callExpression(container, [helpers.get("selfGlobal")]))]);
    body.push(t.variableDeclaration("var", [t.variableDeclarator(namespace, t.assignmentExpression("=", t.memberExpression(t.identifier("global"), namespace), t.objectExpression([])))]));
    builder(body);
    return tree;
  }
  function buildUmd(namespace, builder) {
    var body = [];
    body.push(t.variableDeclaration("var", [t.variableDeclarator(namespace, t.identifier("global"))]));
    builder(body);
    return t.program([buildUmdWrapper({
      FACTORY_PARAMETERS: t.identifier("global"),
      BROWSER_ARGUMENTS: t.assignmentExpression("=", t.memberExpression(t.identifier("root"), namespace), t.objectExpression([])),
      COMMON_ARGUMENTS: t.identifier("exports"),
      AMD_ARGUMENTS: t.arrayExpression([t.stringLiteral("exports")]),
      FACTORY_BODY: body,
      UMD_ROOT: t.identifier("this")
    })]);
  }
  function buildVar(namespace, builder) {
    var body = [];
    body.push(t.variableDeclaration("var", [t.variableDeclarator(namespace, t.objectExpression([]))]));
    builder(body);
    body.push(t.expressionStatement(namespace));
    return t.program(body);
  }
  function buildHelpers(body, namespace, whitelist) {
    _lodashCollectionEach2["default"](helpers.list, function(name) {
      if (whitelist && whitelist.indexOf(name) < 0)
        return;
      var key = t.identifier(name);
      body.push(t.expressionStatement(t.assignmentExpression("=", t.memberExpression(namespace, key), helpers.get(name))));
    });
  }
  exports["default"] = function(whitelist) {
    var outputType = arguments.length <= 1 || arguments[1] === undefined ? "global" : arguments[1];
    var namespace = t.identifier("babelHelpers");
    var builder = function builder(body) {
      return buildHelpers(body, namespace, whitelist);
    };
    var tree = undefined;
    var build = ({
      global: buildGlobal,
      umd: buildUmd,
      "var": buildVar
    })[outputType];
    if (build) {
      tree = build(namespace, builder);
    } else {
      throw new Error(messages.get("unsupportedOutputType", outputType));
    }
    return _babelGenerator2["default"](tree).code;
  };
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("a3", [], false, function() {
  return {
    "name": "babel-core",
    "version": "6.7.4",
    "description": "Babel compiler core.",
    "author": "Sebastian McKenzie <sebmck@gmail.com>",
    "homepage": "https://babeljs.io/",
    "license": "MIT",
    "repository": "https://github.com/babel/babel/tree/master/packages/babel-core",
    "keywords": [
      "6to5",
      "babel",
      "classes",
      "const",
      "es6",
      "harmony",
      "let",
      "modules",
      "transpile",
      "transpiler",
      "var"
    ],
    "scripts": {
      "bench": "make bench",
      "test": "make test"
    },
    "dependencies": {
      "babel-code-frame": "^6.7.4",
      "babel-generator": "^6.7.2",
      "babel-helpers": "^6.6.0",
      "babel-messages": "^6.7.2",
      "babel-template": "^6.7.0",
      "babel-runtime": "^5.0.0",
      "babel-register": "^6.7.2",
      "babel-traverse": "^6.7.4",
      "babel-types": "^6.7.2",
      "babylon": "^6.7.0",
      "convert-source-map": "^1.1.0",
      "debug": "^2.1.1",
      "json5": "^0.4.0",
      "lodash": "^3.10.0",
      "minimatch": "^2.0.3",
      "path-exists": "^1.0.0",
      "path-is-absolute": "^1.0.0",
      "private": "^0.1.6",
      "shebang-regex": "^1.0.0",
      "slash": "^1.0.0",
      "source-map": "^0.5.0"
    },
    "devDependencies": {
      "babel-helper-fixtures": "^6.6.5",
      "babel-helper-transform-fixture-test-runner": "^6.6.5",
      "babel-polyfill": "^6.7.4"
    }
  };
});

$__System.registerDynamic("48", ["a", "4", "a4", "a5", "@node/fs", "27", "4a", "5", "10", "47", "6", "8", "2d", "a2", "73", "a3", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireDefault = $__require('a')["default"];
  var _interopRequireWildcard = $__require('4')["default"];
  var _interopRequire = $__require('a4')["default"];
  exports.__esModule = true;
  exports.Plugin = Plugin;
  exports.transformFile = transformFile;
  exports.transformFileSync = transformFileSync;
  var _lodashLangIsFunction = $__require('a5');
  var _lodashLangIsFunction2 = _interopRequireDefault(_lodashLangIsFunction);
  var _fs = $__require('@node/fs');
  var _fs2 = _interopRequireDefault(_fs);
  var _util = $__require('27');
  var util = _interopRequireWildcard(_util);
  var _babelMessages = $__require('4a');
  var messages = _interopRequireWildcard(_babelMessages);
  var _babelTypes = $__require('5');
  var t = _interopRequireWildcard(_babelTypes);
  var _babelTraverse = $__require('10');
  var _babelTraverse2 = _interopRequireDefault(_babelTraverse);
  var _transformationFileOptionsOptionManager = $__require('47');
  var _transformationFileOptionsOptionManager2 = _interopRequireDefault(_transformationFileOptionsOptionManager);
  var _transformationPipeline = $__require('6');
  var _transformationPipeline2 = _interopRequireDefault(_transformationPipeline);
  var _transformationFile = $__require('8');
  exports.File = _interopRequire(_transformationFile);
  var _transformationFileOptionsConfig = $__require('2d');
  exports.options = _interopRequire(_transformationFileOptionsConfig);
  var _toolsBuildExternalHelpers = $__require('a2');
  exports.buildExternalHelpers = _interopRequire(_toolsBuildExternalHelpers);
  var _babelTemplate = $__require('73');
  exports.template = _interopRequire(_babelTemplate);
  var _package = $__require('a3');
  exports.version = _package.version;
  exports.util = util;
  exports.messages = messages;
  exports.types = t;
  exports.traverse = _babelTraverse2["default"];
  exports.OptionManager = _transformationFileOptionsOptionManager2["default"];
  function Plugin(alias) {
    throw new Error("The (" + alias + ") Babel 5 plugin is being run with Babel 6.");
  }
  exports.Pipeline = _transformationPipeline2["default"];
  var pipeline = new _transformationPipeline2["default"]();
  var analyse = pipeline.analyse.bind(pipeline);
  exports.analyse = analyse;
  var transform = pipeline.transform.bind(pipeline);
  exports.transform = transform;
  var transformFromAst = pipeline.transformFromAst.bind(pipeline);
  exports.transformFromAst = transformFromAst;
  function transformFile(filename, opts, callback) {
    if (_lodashLangIsFunction2["default"](opts)) {
      callback = opts;
      opts = {};
    }
    opts.filename = filename;
    _fs2["default"].readFile(filename, function(err, code) {
      var result = undefined;
      if (!err) {
        try {
          result = transform(code, opts);
        } catch (_err) {
          err = _err;
        }
      }
      if (err) {
        callback(err);
      } else {
        callback(null, result);
      }
    });
  }
  function transformFileSync(filename) {
    var opts = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];
    opts.filename = filename;
    return transform(_fs2["default"].readFileSync(filename, "utf8"), opts);
  }
  return module.exports;
});

$__System.registerDynamic("a6", ["48", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  module.exports = $__require('48');
  return module.exports;
});

$__System.registerDynamic("a7", ["4", "5", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireWildcard = $__require('4')["default"];
  exports.__esModule = true;
  var _babelTypes = $__require('5');
  var t = _interopRequireWildcard(_babelTypes);
  exports["default"] = function() {
    return {visitor: {Program: function Program(path, state) {
          if (state.opts.strict === false)
            return;
          var node = path.node;
          var _arr = node.directives;
          for (var _i = 0; _i < _arr.length; _i++) {
            var directive = _arr[_i];
            if (directive.value.value === "use strict")
              return;
          }
          path.unshiftContainer("directives", t.directive(t.directiveLiteral("use strict")));
        }}};
  };
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("a8", ["a9", "45", "6b", "a", "aa", "73", "a7", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _Symbol = $__require('a9')["default"];
  var _getIterator = $__require('45')["default"];
  var _Object$create = $__require('6b')["default"];
  var _interopRequireDefault = $__require('a')["default"];
  exports.__esModule = true;
  var _babelHelperHoistVariables = $__require('aa');
  var _babelHelperHoistVariables2 = _interopRequireDefault(_babelHelperHoistVariables);
  var _babelTemplate = $__require('73');
  var _babelTemplate2 = _interopRequireDefault(_babelTemplate);
  var buildTemplate = _babelTemplate2["default"]("\n  System.register(MODULE_NAME, [SOURCES], function (EXPORT_IDENTIFIER, CONTEXT_IDENTIFIER) {\n    BEFORE_BODY;\n    return {\n      setters: [SETTERS],\n      execute: function () {\n        BODY;\n      }\n    };\n  });\n");
  var buildExportAll = _babelTemplate2["default"]("\n  for (var KEY in TARGET) {\n    if (KEY !== \"default\") EXPORT_OBJ[KEY] = TARGET[KEY];\n  }\n");
  exports["default"] = function(_ref5) {
    var t = _ref5.types;
    var IGNORE_REASSIGNMENT_SYMBOL = _Symbol();
    var reassignmentVisitor = {"AssignmentExpression|UpdateExpression": function AssignmentExpressionUpdateExpression(path) {
        if (path.node[IGNORE_REASSIGNMENT_SYMBOL])
          return;
        path.node[IGNORE_REASSIGNMENT_SYMBOL] = true;
        var arg = path.get(path.isAssignmentExpression() ? "left" : "argument");
        if (!arg.isIdentifier())
          return;
        var name = arg.node.name;
        if (this.scope.getBinding(name) !== path.scope.getBinding(name))
          return;
        var exportedNames = this.exports[name];
        if (!exportedNames)
          return;
        var node = path.node;
        for (var _iterator = exportedNames,
            _isArray = Array.isArray(_iterator),
            _i = 0,
            _iterator = _isArray ? _iterator : _getIterator(_iterator); ; ) {
          var _ref;
          if (_isArray) {
            if (_i >= _iterator.length)
              break;
            _ref = _iterator[_i++];
          } else {
            _i = _iterator.next();
            if (_i.done)
              break;
            _ref = _i.value;
          }
          var exportedName = _ref;
          node = this.buildCall(exportedName, node).expression;
        }
        path.replaceWith(node);
      }};
    return {
      inherits: $__require('a7'),
      visitor: {
        ReferencedIdentifier: function ReferencedIdentifier(path, state) {
          if (path.node.name == "__moduleName" && !path.scope.hasBinding("__moduleName")) {
            path.replaceWith(t.memberExpression(state.contextIdent, t.identifier("id")));
          }
        },
        Program: {
          enter: function enter(path, state) {
            state.contextIdent = path.scope.generateUidIdentifier("context");
          },
          exit: function exit(path, state) {
            var exportIdent = path.scope.generateUidIdentifier("export");
            var contextIdent = state.contextIdent;
            var exportNames = _Object$create(null);
            var modules = _Object$create(null);
            var beforeBody = [];
            var setters = [];
            var sources = [];
            var variableIds = [];
            function addExportName(key, val) {
              exportNames[key] = exportNames[key] || [];
              exportNames[key].push(val);
            }
            function pushModule(source, key, specifiers) {
              var _modules = modules[source] = modules[source] || {
                imports: [],
                exports: []
              };
              _modules[key] = _modules[key].concat(specifiers);
            }
            function buildExportCall(name, val) {
              return t.expressionStatement(t.callExpression(exportIdent, [t.stringLiteral(name), val]));
            }
            var body = path.get("body");
            var canHoist = true;
            for (var _i2 = 0; _i2 < body.length; _i2++) {
              var _path = body[_i2];
              if (_path.isExportDeclaration())
                _path = _path.get("declaration");
              if (_path.isVariableDeclaration() && _path.node.kind !== "var") {
                canHoist = false;
                break;
              }
            }
            for (var _i3 = 0; _i3 < body.length; _i3++) {
              var _path2 = body[_i3];
              if (canHoist && _path2.isFunctionDeclaration()) {
                beforeBody.push(_path2.node);
                _path2.remove();
              } else if (_path2.isImportDeclaration()) {
                var source = _path2.node.source.value;
                pushModule(source, "imports", _path2.node.specifiers);
                for (var _name in _path2.getBindingIdentifiers()) {
                  _path2.scope.removeBinding(_name);
                  variableIds.push(t.identifier(_name));
                }
                _path2.remove();
              } else if (_path2.isExportAllDeclaration()) {
                pushModule(_path2.node.source.value, "exports", _path2.node);
                _path2.remove();
              } else if (_path2.isExportDefaultDeclaration()) {
                var declar = _path2.get("declaration");
                if (declar.isClassDeclaration() || declar.isFunctionDeclaration()) {
                  var id = declar.node.id;
                  var nodes = [];
                  if (id) {
                    nodes.push(declar.node);
                    nodes.push(buildExportCall("default", id));
                    addExportName(id.name, "default");
                  } else {
                    nodes.push(buildExportCall("default", t.toExpression(declar.node)));
                  }
                  if (!canHoist || declar.isClassDeclaration()) {
                    _path2.replaceWithMultiple(nodes);
                  } else {
                    beforeBody = beforeBody.concat(nodes);
                    _path2.remove();
                  }
                } else {
                  _path2.replaceWith(buildExportCall("default", declar.node));
                }
              } else if (_path2.isExportNamedDeclaration()) {
                var declar = _path2.get("declaration");
                if (declar.node) {
                  _path2.replaceWith(declar);
                  var nodes = [];
                  var bindingIdentifiers = undefined;
                  if (_path2.isFunction()) {
                    var _bindingIdentifiers;
                    bindingIdentifiers = (_bindingIdentifiers = {}, _bindingIdentifiers[declar.node.id.name] = declar.node.id, _bindingIdentifiers);
                  } else {
                    bindingIdentifiers = declar.getBindingIdentifiers();
                  }
                  for (var _name2 in bindingIdentifiers) {
                    addExportName(_name2, _name2);
                    nodes.push(buildExportCall(_name2, t.identifier(_name2)));
                  }
                  _path2.insertAfter(nodes);
                }
                var specifiers = _path2.node.specifiers;
                if (specifiers && specifiers.length) {
                  if (_path2.node.source) {
                    pushModule(_path2.node.source.value, "exports", specifiers);
                    _path2.remove();
                  } else {
                    var nodes = [];
                    for (var _iterator4 = specifiers,
                        _isArray4 = Array.isArray(_iterator4),
                        _i6 = 0,
                        _iterator4 = _isArray4 ? _iterator4 : _getIterator(_iterator4); ; ) {
                      var _ref4;
                      if (_isArray4) {
                        if (_i6 >= _iterator4.length)
                          break;
                        _ref4 = _iterator4[_i6++];
                      } else {
                        _i6 = _iterator4.next();
                        if (_i6.done)
                          break;
                        _ref4 = _i6.value;
                      }
                      var specifier = _ref4;
                      nodes.push(buildExportCall(specifier.exported.name, specifier.local));
                      addExportName(specifier.local.name, specifier.exported.name);
                    }
                    _path2.replaceWithMultiple(nodes);
                  }
                }
              }
            }
            for (var source in modules) {
              var specifiers = modules[source];
              var setterBody = [];
              var target = path.scope.generateUidIdentifier(source);
              for (var _iterator2 = specifiers.imports,
                  _isArray2 = Array.isArray(_iterator2),
                  _i4 = 0,
                  _iterator2 = _isArray2 ? _iterator2 : _getIterator(_iterator2); ; ) {
                var _ref2;
                if (_isArray2) {
                  if (_i4 >= _iterator2.length)
                    break;
                  _ref2 = _iterator2[_i4++];
                } else {
                  _i4 = _iterator2.next();
                  if (_i4.done)
                    break;
                  _ref2 = _i4.value;
                }
                var specifier = _ref2;
                if (t.isImportNamespaceSpecifier(specifier)) {
                  setterBody.push(t.expressionStatement(t.assignmentExpression("=", specifier.local, target)));
                } else if (t.isImportDefaultSpecifier(specifier)) {
                  specifier = t.importSpecifier(specifier.local, t.identifier("default"));
                }
                if (t.isImportSpecifier(specifier)) {
                  setterBody.push(t.expressionStatement(t.assignmentExpression("=", specifier.local, t.memberExpression(target, specifier.imported))));
                }
              }
              if (specifiers.exports.length) {
                var exportObjRef = path.scope.generateUidIdentifier("exportObj");
                setterBody.push(t.variableDeclaration("var", [t.variableDeclarator(exportObjRef, t.objectExpression([]))]));
                for (var _iterator3 = specifiers.exports,
                    _isArray3 = Array.isArray(_iterator3),
                    _i5 = 0,
                    _iterator3 = _isArray3 ? _iterator3 : _getIterator(_iterator3); ; ) {
                  var _ref3;
                  if (_isArray3) {
                    if (_i5 >= _iterator3.length)
                      break;
                    _ref3 = _iterator3[_i5++];
                  } else {
                    _i5 = _iterator3.next();
                    if (_i5.done)
                      break;
                    _ref3 = _i5.value;
                  }
                  var node = _ref3;
                  if (t.isExportAllDeclaration(node)) {
                    setterBody.push(buildExportAll({
                      KEY: path.scope.generateUidIdentifier("key"),
                      EXPORT_OBJ: exportObjRef,
                      TARGET: target
                    }));
                  } else if (t.isExportSpecifier(node)) {
                    setterBody.push(t.expressionStatement(t.assignmentExpression("=", t.memberExpression(exportObjRef, node.exported), t.memberExpression(target, node.local))));
                  } else {}
                }
                setterBody.push(t.expressionStatement(t.callExpression(exportIdent, [exportObjRef])));
              }
              sources.push(t.stringLiteral(source));
              setters.push(t.functionExpression(null, [target], t.blockStatement(setterBody)));
            }
            var moduleName = this.getModuleName();
            if (moduleName)
              moduleName = t.stringLiteral(moduleName);
            if (canHoist) {
              _babelHelperHoistVariables2["default"](path, function(id) {
                return variableIds.push(id);
              });
            }
            if (variableIds.length) {
              beforeBody.unshift(t.variableDeclaration("var", variableIds.map(function(id) {
                return t.variableDeclarator(id);
              })));
            }
            path.traverse(reassignmentVisitor, {
              exports: exportNames,
              buildCall: buildExportCall,
              scope: path.scope
            });
            path.node.body = [buildTemplate({
              BEFORE_BODY: beforeBody,
              MODULE_NAME: moduleName,
              SETTERS: setters,
              SOURCES: sources,
              BODY: path.node.body,
              EXPORT_IDENTIFIER: exportIdent,
              CONTEXT_IDENTIFIER: contextIdent
            })];
          }
        }
      }
    };
  };
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("ab", ["3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  exports.__esModule = true;
  exports["default"] = function(_ref) {
    var t = _ref.types;
    return {pre: function pre(file) {
        file.set("helpersNamespace", t.identifier("babelHelpers"));
      }};
  };
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("ac", ["3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  module.exports = {
    builtins: {
      Symbol: "symbol",
      Promise: "promise",
      Map: "map",
      WeakMap: "weak-map",
      Set: "set",
      WeakSet: "weak-set",
      setImmediate: "set-immediate",
      clearImmediate: "clear-immediate"
    },
    methods: {
      Array: {
        concat: "array/concat",
        copyWithin: "array/copy-within",
        entries: "array/entries",
        every: "array/every",
        fill: "array/fill",
        filter: "array/filter",
        findIndex: "array/find-index",
        find: "array/find",
        forEach: "array/for-each",
        from: "array/from",
        includes: "array/includes",
        indexOf: "array/index-of",
        join: "array/join",
        keys: "array/keys",
        lastIndexOf: "array/last-index-of",
        map: "array/map",
        of: "array/of",
        pop: "array/pop",
        push: "array/push",
        reduceRight: "array/reduce-right",
        reduce: "array/reduce",
        reverse: "array/reverse",
        shift: "array/shift",
        slice: "array/slice",
        some: "array/some",
        sort: "array/sort",
        splice: "array/splice",
        unshift: "array/unshift",
        values: "array/values"
      },
      JSON: {stringify: "json/stringify"},
      Object: {
        assign: "object/assign",
        create: "object/create",
        defineProperties: "object/define-properties",
        defineProperty: "object/define-property",
        entries: "object/entries",
        freeze: "object/freeze",
        getOwnPropertyDescriptor: "object/get-own-property-descriptor",
        getOwnPropertyDescriptors: "object/get-own-property-descriptors",
        getOwnPropertyNames: "object/get-own-property-names",
        getOwnPropertySymbols: "object/get-own-property-symbols",
        getPrototypeOf: "object/get-prototype-of",
        isExtensible: "object/is-extensible",
        isFrozen: "object/is-frozen",
        isSealed: "object/is-sealed",
        is: "object/is",
        keys: "object/keys",
        preventExtensions: "object/prevent-extensions",
        seal: "object/seal",
        setPrototypeOf: "object/set-prototype-of",
        values: "object/values"
      },
      RegExp: {escape: "regexp/escape"},
      Math: {
        acosh: "math/acosh",
        asinh: "math/asinh",
        atanh: "math/atanh",
        cbrt: "math/cbrt",
        clz32: "math/clz32",
        cosh: "math/cosh",
        expm1: "math/expm1",
        fround: "math/fround",
        hypot: "math/hypot",
        imul: "math/imul",
        log10: "math/log10",
        log1p: "math/log1p",
        log2: "math/log2",
        sign: "math/sign",
        sinh: "math/sinh",
        tanh: "math/tanh",
        trunc: "math/trunc",
        iaddh: "math/iaddh",
        isubh: "math/isubh",
        imulh: "math/imulh",
        umulh: "math/umulh"
      },
      Symbol: {
        "for": "symbol/for",
        hasInstance: "symbol/has-instance",
        isConcatSpreadable: "symbol/is-concat-spreadable",
        iterator: "symbol/iterator",
        keyFor: "symbol/key-for",
        match: "symbol/match",
        replace: "symbol/replace",
        search: "symbol/search",
        species: "symbol/species",
        split: "symbol/split",
        toPrimitive: "symbol/to-primitive",
        toStringTag: "symbol/to-string-tag",
        unscopables: "symbol/unscopables"
      },
      String: {
        at: "string/at",
        codePointAt: "string/code-point-at",
        endsWith: "string/ends-with",
        fromCodePoint: "string/from-code-point",
        includes: "string/includes",
        padLeft: "string/pad-left",
        padRight: "string/pad-right",
        padStart: "string/pad-start",
        padEnd: "string/pad-end",
        raw: "string/raw",
        repeat: "string/repeat",
        startsWith: "string/starts-with",
        trim: "string/trim",
        trimLeft: "string/trim-left",
        trimRight: "string/trim-right",
        trimStart: "string/trim-start",
        trimEnd: "string/trim-end"
      },
      Number: {
        EPSILON: "number/epsilon",
        isFinite: "number/is-finite",
        isInteger: "number/is-integer",
        isNaN: "number/is-nan",
        isSafeInteger: "number/is-safe-integer",
        MAX_SAFE_INTEGER: "number/max-safe-integer",
        MIN_SAFE_INTEGER: "number/min-safe-integer",
        parseFloat: "number/parse-float",
        parseInt: "number/parse-int"
      },
      Reflect: {
        apply: "reflect/apply",
        construct: "reflect/construct",
        defineProperty: "reflect/define-property",
        deleteProperty: "reflect/delete-property",
        enumerate: "reflect/enumerate",
        getOwnPropertyDescriptor: "reflect/get-own-property-descriptor",
        getPrototypeOf: "reflect/get-prototype-of",
        get: "reflect/get",
        has: "reflect/has",
        isExtensible: "reflect/is-extensible",
        ownKeys: "reflect/own-keys",
        preventExtensions: "reflect/prevent-extensions",
        setPrototypeOf: "reflect/set-prototype-of",
        set: "reflect/set",
        defineMetadata: "reflect/define-metadata",
        deleteMetadata: "reflect/delete-metadata",
        getMetadata: "reflect/get-metadata",
        getMetadataKeys: "reflect/get-metadata-keys",
        getOwnMetadata: "reflect/get-own-metadata",
        getOwnMetadataKeys: "reflect/get-own-metadata-keys",
        hasMetadata: "reflect/has-metadata",
        hasOwnMetadata: "reflect/has-own-metadata",
        metadata: "reflect/metadata"
      },
      System: {global: "system/global"},
      Error: {isError: "error/is-error"},
      Date: {},
      Function: {}
    }
  };
  return module.exports;
});

$__System.registerDynamic("ad", ["a", "ac", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireDefault = $__require('a')["default"];
  exports.__esModule = true;
  var _definitions = $__require('ac');
  var _definitions2 = _interopRequireDefault(_definitions);
  exports["default"] = function(_ref) {
    var t = _ref.types;
    var RUNTIME_MODULE_NAME = "babel-runtime";
    function has(obj, key) {
      return Object.prototype.hasOwnProperty.call(obj, key);
    }
    var HELPER_BLACKLIST = ["interopRequireWildcard", "interopRequireDefault"];
    return {
      pre: function pre(file) {
        file.set("helperGenerator", function(name) {
          if (HELPER_BLACKLIST.indexOf(name) < 0) {
            return file.addImport(RUNTIME_MODULE_NAME + "/helpers/" + name, "default", name);
          }
        });
        this.setDynamic("regeneratorIdentifier", function() {
          return file.addImport(RUNTIME_MODULE_NAME + "/regenerator", "default", "regeneratorRuntime");
        });
      },
      visitor: {
        ReferencedIdentifier: function ReferencedIdentifier(path, state) {
          var node = path.node;
          var parent = path.parent;
          var scope = path.scope;
          if (node.name === "regeneratorRuntime" && state.opts.regenerator !== false) {
            path.replaceWith(state.get("regeneratorIdentifier"));
            return;
          }
          if (state.opts.polyfill === false)
            return;
          if (t.isMemberExpression(parent))
            return;
          if (!has(_definitions2["default"].builtins, node.name))
            return;
          if (scope.getBindingIdentifier(node.name))
            return;
          path.replaceWith(state.addImport(RUNTIME_MODULE_NAME + "/core-js/" + _definitions2["default"].builtins[node.name], "default", node.name));
        },
        CallExpression: function CallExpression(path, state) {
          if (state.opts.polyfill === false)
            return;
          if (path.node.arguments.length)
            return;
          var callee = path.node.callee;
          if (!t.isMemberExpression(callee))
            return;
          if (!callee.computed)
            return;
          if (!path.get("callee.property").matchesPattern("Symbol.iterator"))
            return;
          path.replaceWith(t.callExpression(state.addImport(RUNTIME_MODULE_NAME + "/core-js/get-iterator", "default", "getIterator"), [callee.object]));
        },
        BinaryExpression: function BinaryExpression(path, state) {
          if (state.opts.polyfill === false)
            return;
          if (path.node.operator !== "in")
            return;
          if (!path.get("left").matchesPattern("Symbol.iterator"))
            return;
          path.replaceWith(t.callExpression(state.addImport(RUNTIME_MODULE_NAME + "/core-js/is-iterable", "default", "isIterable"), [path.node.right]));
        },
        MemberExpression: {
          enter: function enter(path, state) {
            if (state.opts.polyfill === false)
              return;
            if (!path.isReferenced())
              return;
            var node = path.node;
            var obj = node.object;
            var prop = node.property;
            if (!t.isReferenced(obj, node))
              return;
            if (node.computed)
              return;
            if (!has(_definitions2["default"].methods, obj.name))
              return;
            var methods = _definitions2["default"].methods[obj.name];
            if (!has(methods, prop.name))
              return;
            if (path.scope.getBindingIdentifier(obj.name))
              return;
            if (obj.name === "Object" && prop.name === "defineProperty" && path.parentPath.isCallExpression()) {
              var call = path.parentPath.node;
              if (call.arguments.length === 3 && t.isLiteral(call.arguments[1]))
                return;
            }
            path.replaceWith(state.addImport(RUNTIME_MODULE_NAME + "/core-js/" + methods[prop.name], "default", obj.name + "$" + prop.name));
          },
          exit: function exit(path, state) {
            if (state.opts.polyfill === false)
              return;
            if (!path.isReferenced())
              return;
            var node = path.node;
            var obj = node.object;
            if (!has(_definitions2["default"].builtins, obj.name))
              return;
            if (path.scope.getBindingIdentifier(obj.name))
              return;
            path.replaceWith(t.memberExpression(state.addImport(RUNTIME_MODULE_NAME + "/core-js/" + _definitions2["default"].builtins[obj.name], "default", obj.name), node.property, node.computed));
          }
        }
      }
    };
  };
  exports.definitions = _definitions2["default"];
  return module.exports;
});

$__System.registerDynamic("ae", [], true, function($__require, exports, module) {
  "use strict";
  ;
  var define,
      global = this,
      GLOBAL = this;
  exports.__esModule = true;
  exports["default"] = function() {
    return {manipulateOptions: function manipulateOptions(opts, parserOpts) {
        parserOpts.plugins.push("classConstructorCall");
      }};
  };
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("af", ["a9", "a", "73", "ae"], true, function($__require, exports, module) {
  "use strict";
  ;
  var define,
      global = this,
      GLOBAL = this;
  var _Symbol = $__require('a9')["default"];
  var _interopRequireDefault = $__require('a')["default"];
  exports.__esModule = true;
  var _babelTemplate = $__require('73');
  var _babelTemplate2 = _interopRequireDefault(_babelTemplate);
  var buildWrapper = _babelTemplate2["default"]("\n  let CLASS_REF = CLASS;\n  var CALL_REF = CALL;\n  var WRAPPER_REF = function (...args) {\n    if (this instanceof WRAPPER_REF) {\n      return Reflect.construct(CLASS_REF, args);\n    } else {\n      return CALL_REF.apply(this, args);\n    }\n  };\n  WRAPPER_REF.__proto__ = CLASS_REF;\n  WRAPPER_REF;\n");
  exports["default"] = function(_ref) {
    var t = _ref.types;
    var ALREADY_VISITED = _Symbol();
    function findConstructorCall(path) {
      var methods = path.get("body.body");
      for (var _i = 0; _i < methods.length; _i++) {
        var method = methods[_i];
        if (method.node.kind === "constructorCall") {
          return method;
        }
      }
      return null;
    }
    function handleClassWithCall(constructorCall, classPath) {
      var _classPath = classPath;
      var node = _classPath.node;
      var ref = node.id || classPath.scope.generateUidIdentifier("class");
      if (classPath.parentPath.isExportDefaultDeclaration()) {
        classPath = classPath.parentPath;
        classPath.insertAfter(t.exportDefaultDeclaration(ref));
      }
      classPath.replaceWithMultiple(buildWrapper({
        CLASS_REF: classPath.scope.generateUidIdentifier(ref.name),
        CALL_REF: classPath.scope.generateUidIdentifier(ref.name + "Call"),
        CALL: t.functionExpression(null, constructorCall.node.params, constructorCall.node.body),
        CLASS: t.toExpression(node),
        WRAPPER_REF: ref
      }));
      constructorCall.remove();
    }
    return {
      inherits: $__require('ae'),
      visitor: {Class: function Class(path) {
          if (path.node[ALREADY_VISITED])
            return;
          path.node[ALREADY_VISITED] = true;
          var constructorCall = findConstructorCall(path);
          if (constructorCall) {
            handleClassWithCall(constructorCall, path);
          } else {
            return;
          }
        }}
    };
  };
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("b0", ["3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  exports.__esModule = true;
  exports["default"] = function() {
    return {manipulateOptions: function manipulateOptions(opts, parserOpts) {
        parserOpts.plugins.push("classProperties");
      }};
  };
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("b1", ["45", "b0", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _getIterator = $__require('45')["default"];
  exports.__esModule = true;
  exports["default"] = function(_ref2) {
    var t = _ref2.types;
    var findBareSupers = {Super: function Super(path) {
        if (path.parentPath.isCallExpression({callee: path.node})) {
          this.push(path.parentPath);
        }
      }};
    var referenceVisitor = {ReferencedIdentifier: function ReferencedIdentifier(path) {
        if (this.scope.hasOwnBinding(path.node.name)) {
          this.collision = true;
          path.skip();
        }
      }};
    return {
      inherits: $__require('b0'),
      visitor: {Class: function Class(path) {
          var isDerived = !!path.node.superClass;
          var constructor = undefined;
          var props = [];
          var body = path.get("body");
          for (var _iterator = body.get("body"),
              _isArray = Array.isArray(_iterator),
              _i = 0,
              _iterator = _isArray ? _iterator : _getIterator(_iterator); ; ) {
            var _ref;
            if (_isArray) {
              if (_i >= _iterator.length)
                break;
              _ref = _iterator[_i++];
            } else {
              _i = _iterator.next();
              if (_i.done)
                break;
              _ref = _i.value;
            }
            var _path = _ref;
            if (_path.isClassProperty()) {
              props.push(_path);
            } else if (_path.isClassMethod({kind: "constructor"})) {
              constructor = _path;
            }
          }
          if (!props.length)
            return;
          var nodes = [];
          var ref = undefined;
          if (path.isClassExpression() || !path.node.id) {
            ref = path.scope.generateUidIdentifier("class");
          } else {
            ref = path.node.id;
          }
          var instanceBody = [];
          for (var _i2 = 0; _i2 < props.length; _i2++) {
            var prop = props[_i2];
            var propNode = prop.node;
            if (propNode.decorators && propNode.decorators.length > 0)
              continue;
            if (!propNode.value)
              continue;
            var isStatic = propNode["static"];
            if (isStatic) {
              nodes.push(t.expressionStatement(t.assignmentExpression("=", t.memberExpression(ref, propNode.key), propNode.value)));
            } else {
              instanceBody.push(t.expressionStatement(t.assignmentExpression("=", t.memberExpression(t.thisExpression(), propNode.key), propNode.value)));
            }
          }
          if (instanceBody.length) {
            if (!constructor) {
              var newConstructor = t.classMethod("constructor", t.identifier("constructor"), [], t.blockStatement([]));
              if (isDerived) {
                newConstructor.params = [t.restElement(t.identifier("args"))];
                newConstructor.body.body.push(t.returnStatement(t.callExpression(t["super"](), [t.spreadElement(t.identifier("args"))])));
              }
              var _body$unshiftContainer = body.unshiftContainer("body", newConstructor);
              constructor = _body$unshiftContainer[0];
            }
            var collisionState = {
              collision: false,
              scope: constructor.scope
            };
            for (var _i3 = 0; _i3 < props.length; _i3++) {
              var prop = props[_i3];
              prop.traverse(referenceVisitor, collisionState);
              if (collisionState.collision)
                break;
            }
            if (collisionState.collision) {
              var initialisePropsRef = path.scope.generateUidIdentifier("initialiseProps");
              nodes.push(t.variableDeclaration("var", [t.variableDeclarator(initialisePropsRef, t.functionExpression(null, [], t.blockStatement(instanceBody)))]));
              instanceBody = [t.expressionStatement(t.callExpression(t.memberExpression(initialisePropsRef, t.identifier("call")), [t.thisExpression()]))];
            }
            if (isDerived) {
              var bareSupers = [];
              constructor.traverse(findBareSupers, bareSupers);
              for (var _i4 = 0; _i4 < bareSupers.length; _i4++) {
                var bareSuper = bareSupers[_i4];
                bareSuper.insertAfter(instanceBody);
              }
            } else {
              constructor.get("body").unshiftContainer("body", instanceBody);
            }
          }
          for (var _i5 = 0; _i5 < props.length; _i5++) {
            var prop = props[_i5];
            prop.remove();
          }
          if (!nodes.length)
            return;
          if (path.isClassExpression()) {
            path.scope.push({id: ref});
            path.replaceWith(t.assignmentExpression("=", ref, path.node));
          } else {
            if (!path.node.id) {
              path.node.id = ref;
            }
            if (path.parentPath.isExportDeclaration()) {
              path = path.parentPath;
            }
          }
          path.insertAfter(nodes);
        }}
    };
  };
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("b2", ["4", "5"], true, function($__require, exports, module) {
  "use strict";
  ;
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireWildcard = $__require('4')["default"];
  exports.__esModule = true;
  exports["default"] = bindifyDecorators;
  var _babelTypes = $__require('5');
  var t = _interopRequireWildcard(_babelTypes);
  function bindifyDecorators(decorators) {
    for (var _i = 0; _i < decorators.length; _i++) {
      var decoratorPath = decorators[_i];
      var decorator = decoratorPath.node;
      var expression = decorator.expression;
      if (!t.isMemberExpression(expression))
        continue;
      var temp = decoratorPath.scope.maybeGenerateMemoised(expression.object);
      var ref = undefined;
      var nodes = [];
      if (temp) {
        ref = temp;
        nodes.push(t.assignmentExpression("=", temp, expression.object));
      } else {
        ref = expression.object;
      }
      nodes.push(t.callExpression(t.memberExpression(t.memberExpression(ref, expression.property, expression.computed), t.identifier("bind")), [ref]));
      if (nodes.length === 1) {
        decorator.expression = nodes[0];
      } else {
        decorator.expression = t.sequenceExpression(nodes);
      }
    }
  }
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("b3", ["a", "4", "b2", "5"], true, function($__require, exports, module) {
  "use strict";
  ;
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireDefault = $__require('a')["default"];
  var _interopRequireWildcard = $__require('4')["default"];
  exports.__esModule = true;
  var _babelHelperBindifyDecorators = $__require('b2');
  var _babelHelperBindifyDecorators2 = _interopRequireDefault(_babelHelperBindifyDecorators);
  var _babelTypes = $__require('5');
  var t = _interopRequireWildcard(_babelTypes);
  exports["default"] = function(classPath) {
    classPath.assertClass();
    var memoisedExpressions = [];
    function maybeMemoise(path) {
      if (!path.node || path.isPure())
        return;
      var uid = classPath.scope.generateDeclaredUidIdentifier();
      memoisedExpressions.push(t.assignmentExpression("=", uid, path.node));
      path.replaceWith(uid);
    }
    function memoiseDecorators(paths) {
      if (!Array.isArray(paths) || !paths.length)
        return;
      paths = paths.reverse();
      _babelHelperBindifyDecorators2["default"](paths);
      for (var _i = 0; _i < paths.length; _i++) {
        var path = paths[_i];
        maybeMemoise(path);
      }
    }
    maybeMemoise(classPath.get("superClass"));
    memoiseDecorators(classPath.get("decorators"), true);
    var methods = classPath.get("body.body");
    for (var _i2 = 0; _i2 < methods.length; _i2++) {
      var methodPath = methods[_i2];
      if (methodPath.is("computed")) {
        maybeMemoise(methodPath.get("key"));
      }
      if (methodPath.has("decorators")) {
        memoiseDecorators(classPath.get("decorators"));
      }
    }
    if (memoisedExpressions) {
      classPath.insertBefore(memoisedExpressions.map(function(expr) {
        return t.expressionStatement(expr);
      }));
    }
  };
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("b4", ["3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  exports.__esModule = true;
  exports["default"] = function() {
    return {manipulateOptions: function manipulateOptions(opts, parserOpts) {
        parserOpts.plugins.push("decorators");
      }};
  };
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("b5", ["45", "6b", "a", "73", "b3", "b4"], true, function($__require, exports, module) {
  "use strict";
  ;
  var define,
      global = this,
      GLOBAL = this;
  var _getIterator = $__require('45')["default"];
  var _Object$create = $__require('6b')["default"];
  var _interopRequireDefault = $__require('a')["default"];
  exports.__esModule = true;
  var _babelTemplate = $__require('73');
  var _babelTemplate2 = _interopRequireDefault(_babelTemplate);
  var _babelHelperExplodeClass = $__require('b3');
  var _babelHelperExplodeClass2 = _interopRequireDefault(_babelHelperExplodeClass);
  var buildClassDecorator = _babelTemplate2["default"]("\n  CLASS_REF = DECORATOR(CLASS_REF) || CLASS_REF;\n");
  exports["default"] = function(_ref3) {
    var t = _ref3.types;
    function cleanDecorators(decorators) {
      return decorators.reverse().map(function(dec) {
        return dec.expression;
      });
    }
    function transformClass(path, ref, state) {
      var nodes = [];
      state;
      var classDecorators = path.node.decorators;
      if (classDecorators) {
        path.node.decorators = null;
        classDecorators = cleanDecorators(classDecorators);
        for (var _iterator = classDecorators,
            _isArray = Array.isArray(_iterator),
            _i = 0,
            _iterator = _isArray ? _iterator : _getIterator(_iterator); ; ) {
          var _ref;
          if (_isArray) {
            if (_i >= _iterator.length)
              break;
            _ref = _iterator[_i++];
          } else {
            _i = _iterator.next();
            if (_i.done)
              break;
            _ref = _i.value;
          }
          var decorator = _ref;
          nodes.push(buildClassDecorator({
            CLASS_REF: ref,
            DECORATOR: decorator
          }));
        }
      }
      var map = _Object$create(null);
      for (var _iterator2 = path.get("body.body"),
          _isArray2 = Array.isArray(_iterator2),
          _i2 = 0,
          _iterator2 = _isArray2 ? _iterator2 : _getIterator(_iterator2); ; ) {
        var _ref2;
        if (_isArray2) {
          if (_i2 >= _iterator2.length)
            break;
          _ref2 = _iterator2[_i2++];
        } else {
          _i2 = _iterator2.next();
          if (_i2.done)
            break;
          _ref2 = _i2.value;
        }
        var method = _ref2;
        var decorators = method.node.decorators;
        if (!decorators)
          continue;
        var alias = t.toKeyAlias(method.node);
        map[alias] = map[alias] || [];
        map[alias].push(method.node);
        method.remove();
      }
      for (var alias in map) {
        var items = map[alias];
        items;
      }
      return nodes;
    }
    function hasDecorators(path) {
      if (path.isClass()) {
        if (path.node.decorators)
          return true;
        var _arr = path.node.body.body;
        for (var _i3 = 0; _i3 < _arr.length; _i3++) {
          var method = _arr[_i3];
          if (method.decorators) {
            return true;
          }
        }
      } else if (path.isObjectExpression()) {
        var _arr2 = path.node.properties;
        for (var _i4 = 0; _i4 < _arr2.length; _i4++) {
          var prop = _arr2[_i4];
          if (prop.decorators) {
            return true;
          }
        }
      }
      return false;
    }
    function doError(path) {
      throw path.buildCodeFrameError("Decorators are not supported yet in 6.x pending proposal update.");
    }
    return {
      inherits: $__require('b4'),
      visitor: {
        ClassExpression: function ClassExpression(path) {
          if (!hasDecorators(path))
            return;
          doError(path);
          _babelHelperExplodeClass2["default"](path);
          var ref = path.scope.generateDeclaredUidIdentifier("ref");
          var nodes = [];
          nodes.push(t.assignmentExpression("=", ref, path.node));
          nodes = nodes.concat(transformClass(path, ref, this));
          nodes.push(ref);
          path.replaceWith(t.sequenceExpression(nodes));
        },
        ClassDeclaration: function ClassDeclaration(path) {
          if (!hasDecorators(path))
            return;
          doError(path);
          _babelHelperExplodeClass2["default"](path);
          var ref = path.node.id;
          var nodes = [];
          nodes = nodes.concat(transformClass(path, ref, this).map(function(expr) {
            return t.expressionStatement(expr);
          }));
          nodes.push(t.expressionStatement(ref));
          path.insertAfter(nodes);
        },
        ObjectExpression: function ObjectExpression(path) {
          if (!hasDecorators(path))
            return;
          doError(path);
        }
      }
    };
  };
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("b6", [], true, function($__require, exports, module) {
  "use strict";
  ;
  var define,
      global = this,
      GLOBAL = this;
  exports.__esModule = true;
  exports["default"] = function() {
    return {manipulateOptions: function manipulateOptions(opts, parserOpts) {
        parserOpts.plugins.push("exportExtensions");
      }};
  };
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("b7", ["b6"], true, function($__require, exports, module) {
  "use strict";
  ;
  var define,
      global = this,
      GLOBAL = this;
  exports.__esModule = true;
  exports["default"] = function(_ref) {
    var t = _ref.types;
    function build(node, nodes, scope) {
      var first = node.specifiers[0];
      if (!t.isExportNamespaceSpecifier(first) && !t.isExportDefaultSpecifier(first))
        return;
      var specifier = node.specifiers.shift();
      var uid = scope.generateUidIdentifier(specifier.exported.name);
      var newSpecifier = undefined;
      if (t.isExportNamespaceSpecifier(specifier)) {
        newSpecifier = t.importNamespaceSpecifier(uid);
      } else {
        newSpecifier = t.importDefaultSpecifier(uid);
      }
      nodes.push(t.importDeclaration([newSpecifier], node.source));
      nodes.push(t.exportNamedDeclaration(null, [t.exportSpecifier(uid, specifier.exported)]));
      build(node, nodes, scope);
    }
    return {
      inherits: $__require('b6'),
      visitor: {ExportNamedDeclaration: function ExportNamedDeclaration(path) {
          var node = path.node;
          var scope = path.scope;
          var nodes = [];
          build(node, nodes, scope);
          if (!nodes.length)
            return;
          if (node.specifiers.length >= 1) {
            nodes.push(node);
          }
          path.replaceWithMultiple(nodes);
        }}
    };
  };
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("b8", ["b9", "af", "b1", "b5", "b7"], true, function($__require, exports, module) {
  ;
  var define,
      global = this,
      GLOBAL = this;
  module.exports = {
    presets: [$__require('b9')],
    plugins: [$__require('af'), $__require('b1'), $__require('b5'), $__require('b7')]
  };
  return module.exports;
});

$__System.registerDynamic("ba", ["3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  exports.__esModule = true;
  exports["default"] = function() {
    return {manipulateOptions: function manipulateOptions(opts, parserOpts) {
        parserOpts.plugins.push("trailingFunctionCommas");
      }};
  };
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("bb", ["3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  exports.__esModule = true;
  exports["default"] = function() {
    return {manipulateOptions: function manipulateOptions(opts, parserOpts) {
        parserOpts.plugins.push("objectRestSpread");
      }};
  };
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("bc", ["bb", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  exports.__esModule = true;
  exports["default"] = function(_ref) {
    var t = _ref.types;
    function hasSpread(node) {
      var _arr = node.properties;
      for (var _i = 0; _i < _arr.length; _i++) {
        var prop = _arr[_i];
        if (t.isSpreadProperty(prop)) {
          return true;
        }
      }
      return false;
    }
    return {
      inherits: $__require('bb'),
      visitor: {ObjectExpression: function ObjectExpression(path, file) {
          if (!hasSpread(path.node))
            return;
          var args = [];
          var props = [];
          function push() {
            if (!props.length)
              return;
            args.push(t.objectExpression(props));
            props = [];
          }
          var _arr2 = path.node.properties;
          for (var _i2 = 0; _i2 < _arr2.length; _i2++) {
            var prop = _arr2[_i2];
            if (t.isSpreadProperty(prop)) {
              push();
              args.push(prop.argument);
            } else {
              props.push(prop);
            }
          }
          push();
          if (!t.isObjectExpression(args[0])) {
            args.unshift(t.objectExpression([]));
          }
          path.replaceWith(t.callExpression(file.addHelper("extends"), args));
        }}
    };
  };
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("b9", ["bd", "ba", "bc", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  module.exports = {
    presets: [$__require('bd')],
    plugins: [$__require('ba'), $__require('bc')]
  };
  return module.exports;
});

$__System.registerDynamic("be", ["a", "4", "bf", "73", "5", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireDefault = $__require('a')["default"];
  var _interopRequireWildcard = $__require('4')["default"];
  exports.__esModule = true;
  var _babelHelperFunctionName = $__require('bf');
  var _babelHelperFunctionName2 = _interopRequireDefault(_babelHelperFunctionName);
  var _babelTemplate = $__require('73');
  var _babelTemplate2 = _interopRequireDefault(_babelTemplate);
  var _babelTypes = $__require('5');
  var t = _interopRequireWildcard(_babelTypes);
  var buildWrapper = _babelTemplate2["default"]("\n  (() => {\n    var ref = FUNCTION;\n    return function NAME(PARAMS) {\n      return ref.apply(this, arguments);\n    };\n  })\n");
  var namedBuildWrapper = _babelTemplate2["default"]("\n  (() => {\n    var ref = FUNCTION;\n    function NAME(PARAMS) {\n      return ref.apply(this, arguments);\n    }\n    return NAME;\n  })\n");
  var awaitVisitor = {
    ArrowFunctionExpression: function ArrowFunctionExpression(path) {
      if (!path.node.async) {
        path.arrowFunctionToShadowed();
      }
    },
    AwaitExpression: function AwaitExpression(_ref) {
      var node = _ref.node;
      node.type = "YieldExpression";
    }
  };
  function classOrObjectMethod(path, callId) {
    var node = path.node;
    var body = node.body;
    node.async = false;
    var container = t.functionExpression(null, [], t.blockStatement(body.body), true);
    container.shadow = true;
    body.body = [t.returnStatement(t.callExpression(t.callExpression(callId, [container]), []))];
  }
  function plainFunction(path, callId) {
    var node = path.node;
    var isDeclaration = path.isFunctionDeclaration();
    var asyncFnId = node.id;
    var wrapper = buildWrapper;
    if (path.isArrowFunctionExpression()) {
      path.arrowFunctionToShadowed();
    } else if (!isDeclaration && asyncFnId) {
      wrapper = namedBuildWrapper;
    }
    node.async = false;
    node.generator = true;
    node.id = null;
    if (isDeclaration) {
      node.type = "FunctionExpression";
    }
    var built = t.callExpression(callId, [node]);
    var container = wrapper({
      NAME: asyncFnId,
      FUNCTION: built,
      PARAMS: node.params.map(function() {
        return path.scope.generateUidIdentifier("x");
      })
    }).expression;
    if (isDeclaration) {
      var declar = t.variableDeclaration("let", [t.variableDeclarator(t.identifier(asyncFnId.name), t.callExpression(container, []))]);
      declar._blockHoist = true;
      path.replaceWith(declar);
    } else {
      var retFunction = container.body.body[1].argument;
      if (!asyncFnId) {
        _babelHelperFunctionName2["default"]({
          node: retFunction,
          parent: path.parent,
          scope: path.scope
        });
      }
      if (!retFunction || retFunction.id || node.params.length) {
        path.replaceWith(t.callExpression(container, []));
      } else {
        path.replaceWith(built);
      }
    }
  }
  exports["default"] = function(path, callId) {
    var node = path.node;
    if (node.generator)
      return;
    path.traverse(awaitVisitor);
    if (path.isClassMethod() || path.isObjectMethod()) {
      return classOrObjectMethod(path, callId);
    } else {
      return plainFunction(path, callId);
    }
  };
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("c0", ["3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  exports.__esModule = true;
  exports["default"] = function() {
    return {manipulateOptions: function manipulateOptions(opts, parserOpts) {
        parserOpts.plugins.push("asyncFunctions");
      }};
  };
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("c1", ["a", "be", "c0"], true, function($__require, exports, module) {
  "use strict";
  ;
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireDefault = $__require('a')["default"];
  exports.__esModule = true;
  var _babelHelperRemapAsyncToGenerator = $__require('be');
  var _babelHelperRemapAsyncToGenerator2 = _interopRequireDefault(_babelHelperRemapAsyncToGenerator);
  exports["default"] = function() {
    return {
      inherits: $__require('c0'),
      visitor: {Function: function Function(path, state) {
          if (!path.node.async || path.node.generator)
            return;
          _babelHelperRemapAsyncToGenerator2["default"](path, state.addHelper("asyncToGenerator"));
        }}
    };
  };
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("c2", ["4", "5", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireWildcard = $__require('4')["default"];
  exports.__esModule = true;
  var _babelTypes = $__require('5');
  var t = _interopRequireWildcard(_babelTypes);
  function getObjRef(node, nodes, file, scope) {
    var ref = undefined;
    if (t.isIdentifier(node)) {
      if (scope.hasBinding(node.name)) {
        return node;
      } else {
        ref = node;
      }
    } else if (t.isMemberExpression(node)) {
      ref = node.object;
      if (t.isIdentifier(ref) && scope.hasBinding(ref.name)) {
        return ref;
      }
    } else {
      throw new Error("We can't explode this node type " + node.type);
    }
    var temp = scope.generateUidIdentifierBasedOnNode(ref);
    nodes.push(t.variableDeclaration("var", [t.variableDeclarator(temp, ref)]));
    return temp;
  }
  function getPropRef(node, nodes, file, scope) {
    var prop = node.property;
    var key = t.toComputedKey(node, prop);
    if (t.isLiteral(key))
      return key;
    var temp = scope.generateUidIdentifierBasedOnNode(prop);
    nodes.push(t.variableDeclaration("var", [t.variableDeclarator(temp, prop)]));
    return temp;
  }
  exports["default"] = function(node, nodes, file, scope, allowedSingleIdent) {
    var obj = undefined;
    if (t.isIdentifier(node) && allowedSingleIdent) {
      obj = node;
    } else {
      obj = getObjRef(node, nodes, file, scope);
    }
    var ref = undefined,
        uid = undefined;
    if (t.isIdentifier(node)) {
      ref = node;
      uid = obj;
    } else {
      var prop = getPropRef(node, nodes, file, scope);
      var computed = node.computed || t.isLiteral(prop);
      uid = ref = t.memberExpression(obj, prop, computed);
    }
    return {
      uid: uid,
      ref: ref
    };
  };
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("c3", ["a", "4", "c2", "5", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireDefault = $__require('a')["default"];
  var _interopRequireWildcard = $__require('4')["default"];
  exports.__esModule = true;
  var _babelHelperExplodeAssignableExpression = $__require('c2');
  var _babelHelperExplodeAssignableExpression2 = _interopRequireDefault(_babelHelperExplodeAssignableExpression);
  var _babelTypes = $__require('5');
  var t = _interopRequireWildcard(_babelTypes);
  exports["default"] = function(opts) {
    var visitor = {};
    function isAssignment(node) {
      return node.operator === opts.operator + "=";
    }
    function buildAssignment(left, right) {
      return t.assignmentExpression("=", left, right);
    }
    visitor.ExpressionStatement = function(path, file) {
      if (path.isCompletionRecord())
        return;
      var expr = path.node.expression;
      if (!isAssignment(expr))
        return;
      var nodes = [];
      var exploded = _babelHelperExplodeAssignableExpression2["default"](expr.left, nodes, file, path.scope, true);
      nodes.push(t.expressionStatement(buildAssignment(exploded.ref, opts.build(exploded.uid, expr.right))));
      path.replaceWithMultiple(nodes);
    };
    visitor.AssignmentExpression = function(path, file) {
      var node = path.node;
      var scope = path.scope;
      if (!isAssignment(node))
        return;
      var nodes = [];
      var exploded = _babelHelperExplodeAssignableExpression2["default"](node.left, nodes, file, scope);
      nodes.push(buildAssignment(exploded.ref, opts.build(exploded.uid, node.right)));
      path.replaceWithMultiple(nodes);
    };
    visitor.BinaryExpression = function(path) {
      var node = path.node;
      if (node.operator === opts.operator) {
        path.replaceWith(opts.build(node.left, node.right));
      }
    };
    return visitor;
  };
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("c4", ["3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  exports.__esModule = true;
  exports["default"] = function() {
    return {manipulateOptions: function manipulateOptions(opts, parserOpts) {
        parserOpts.plugins.push("exponentiationOperator");
      }};
  };
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("c5", ["a", "c3", "c4", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireDefault = $__require('a')["default"];
  exports.__esModule = true;
  var _babelHelperBuilderBinaryAssignmentOperatorVisitor = $__require('c3');
  var _babelHelperBuilderBinaryAssignmentOperatorVisitor2 = _interopRequireDefault(_babelHelperBuilderBinaryAssignmentOperatorVisitor);
  exports["default"] = function(_ref) {
    var t = _ref.types;
    return {
      inherits: $__require('c4'),
      visitor: _babelHelperBuilderBinaryAssignmentOperatorVisitor2["default"]({
        operator: "**",
        build: function build(left, right) {
          return t.callExpression(t.memberExpression(t.identifier("Math"), t.identifier("pow")), [left, right]);
        }
      })
    };
  };
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("bd", ["c1", "c5"], true, function($__require, exports, module) {
  ;
  var define,
      global = this,
      GLOBAL = this;
  module.exports = {plugins: [$__require('c1'), $__require('c5')]};
  return module.exports;
});

$__System.registerDynamic("c6", ["3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  exports.__esModule = true;
  exports["default"] = function(_ref) {
    var t = _ref.types;
    function isString(node) {
      return t.isLiteral(node) && typeof node.value === "string";
    }
    function buildBinaryExpression(left, right) {
      return t.binaryExpression("+", left, right);
    }
    return {visitor: {
        TaggedTemplateExpression: function TaggedTemplateExpression(path, state) {
          var node = path.node;
          var quasi = node.quasi;
          var args = [];
          var strings = [];
          var raw = [];
          var _arr = quasi.quasis;
          for (var _i = 0; _i < _arr.length; _i++) {
            var elem = _arr[_i];
            strings.push(t.stringLiteral(elem.value.cooked));
            raw.push(t.stringLiteral(elem.value.raw));
          }
          strings = t.arrayExpression(strings);
          raw = t.arrayExpression(raw);
          var templateName = "taggedTemplateLiteral";
          if (state.opts.loose)
            templateName += "Loose";
          var templateObject = state.file.addTemplateObject(templateName, strings, raw);
          args.push(templateObject);
          args = args.concat(quasi.expressions);
          path.replaceWith(t.callExpression(node.tag, args));
        },
        TemplateLiteral: function TemplateLiteral(path, state) {
          var nodes = [];
          var expressions = path.get("expressions");
          var _arr2 = path.node.quasis;
          for (var _i2 = 0; _i2 < _arr2.length; _i2++) {
            var elem = _arr2[_i2];
            nodes.push(t.stringLiteral(elem.value.cooked));
            var expr = expressions.shift();
            if (expr) {
              if (state.opts.spec && !expr.isBaseType("string") && !expr.isBaseType("number")) {
                nodes.push(t.callExpression(t.identifier("String"), [expr.node]));
              } else {
                nodes.push(expr.node);
              }
            }
          }
          nodes = nodes.filter(function(n) {
            return !t.isLiteral(n, {value: ""});
          });
          if (!isString(nodes[0]) && !isString(nodes[1])) {
            nodes.unshift(t.stringLiteral(""));
          }
          if (nodes.length > 1) {
            var root = buildBinaryExpression(nodes.shift(), nodes.shift());
            for (var _i3 = 0; _i3 < nodes.length; _i3++) {
              var node = nodes[_i3];
              root = buildBinaryExpression(root, node);
            }
            path.replaceWith(root);
          } else {
            path.replaceWith(nodes[0]);
          }
        }
      }};
  };
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("c7", ["3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  exports.__esModule = true;
  exports["default"] = function() {
    return {visitor: {
        NumericLiteral: function NumericLiteral(_ref) {
          var node = _ref.node;
          if (node.extra && /^0[ob]/i.test(node.extra.raw)) {
            node.extra = undefined;
          }
        },
        StringLiteral: function StringLiteral(_ref2) {
          var node = _ref2.node;
          if (node.extra && /\\[u]/gi.test(node.extra.raw)) {
            node.extra = undefined;
          }
        }
      }};
  };
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("c8", ["a", "bf", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireDefault = $__require('a')["default"];
  exports.__esModule = true;
  var _babelHelperFunctionName = $__require('bf');
  var _babelHelperFunctionName2 = _interopRequireDefault(_babelHelperFunctionName);
  exports["default"] = function() {
    return {visitor: {
        "ArrowFunctionExpression|FunctionExpression": {exit: function exit(path) {
            if (path.key !== "value" && !path.parentPath.isObjectProperty()) {
              var replacement = _babelHelperFunctionName2["default"](path);
              if (replacement)
                path.replaceWith(replacement);
            }
          }},
        ObjectProperty: function ObjectProperty(path) {
          var value = path.get("value");
          if (value.isFunction()) {
            var newNode = _babelHelperFunctionName2["default"](value);
            if (newNode)
              value.replaceWith(newNode);
          }
        }
      }};
  };
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("c9", ["3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  exports.__esModule = true;
  exports["default"] = function(_ref) {
    var t = _ref.types;
    return {visitor: {ArrowFunctionExpression: function ArrowFunctionExpression(path, state) {
          if (state.opts.spec) {
            var node = path.node;
            if (node.shadow)
              return;
            node.shadow = {"this": false};
            node.type = "FunctionExpression";
            var boundThis = t.thisExpression();
            boundThis._forceShadow = path;
            path.ensureBlock();
            path.get("body").unshiftContainer("body", t.expressionStatement(t.callExpression(state.addHelper("newArrowCheck"), [t.thisExpression(), boundThis])));
            path.replaceWith(t.callExpression(t.memberExpression(node, t.identifier("bind")), [t.thisExpression()]));
          } else {
            path.arrowFunctionToShadowed();
          }
        }}};
  };
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("ca", ["3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  exports.__esModule = true;
  exports["default"] = function(_ref) {
    var t = _ref.types;
    function statementList(key, path) {
      var paths = path.get(key);
      for (var _i = 0; _i < paths.length; _i++) {
        var _path = paths[_i];
        var func = _path.node;
        if (!_path.isFunctionDeclaration())
          continue;
        var declar = t.variableDeclaration("let", [t.variableDeclarator(func.id, t.toExpression(func))]);
        declar._blockHoist = 2;
        func.id = null;
        _path.replaceWith(declar);
      }
    }
    return {visitor: {
        BlockStatement: function BlockStatement(path) {
          var node = path.node;
          var parent = path.parent;
          if (t.isFunction(parent, {body: node}) || t.isExportDeclaration(parent)) {
            return;
          }
          statementList("body", path);
        },
        SwitchCase: function SwitchCase(path) {
          statementList("consequent", path);
        }
      }};
  };
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("cb", ["4f", "5d", "cc", "55", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var getDesc = $__require('4f').getDesc,
      isObject = $__require('5d'),
      anObject = $__require('cc');
  var check = function(O, proto) {
    anObject(O);
    if (!isObject(proto) && proto !== null)
      throw TypeError(proto + ": can't set as prototype!");
  };
  module.exports = {
    set: Object.setPrototypeOf || ('__proto__' in {} ? function(test, buggy, set) {
      try {
        set = $__require('55')(Function.call, getDesc(Object.prototype, '__proto__').set, 2);
        set(test, []);
        buggy = !(test instanceof Array);
      } catch (e) {
        buggy = true;
      }
      return function setPrototypeOf(O, proto) {
        check(O, proto);
        if (buggy)
          O.__proto__ = proto;
        else
          set(O, proto);
        return O;
      };
    }({}, false) : undefined),
    check: check
  };
  return module.exports;
});

$__System.registerDynamic("cd", ["63", "cb", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var $export = $__require('63');
  $export($export.S, 'Object', {setPrototypeOf: $__require('cb').set});
  return module.exports;
});

$__System.registerDynamic("ce", ["cd", "4e", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  $__require('cd');
  module.exports = $__require('4e').Object.setPrototypeOf;
  return module.exports;
});

$__System.registerDynamic("cf", ["ce", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  module.exports = {
    "default": $__require('ce'),
    __esModule: true
  };
  return module.exports;
});

$__System.registerDynamic("f", ["6b", "cf", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _Object$create = $__require('6b')["default"];
  var _Object$setPrototypeOf = $__require('cf')["default"];
  exports["default"] = function(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
    }
    subClass.prototype = _Object$create(superClass && superClass.prototype, {constructor: {
        value: subClass,
        enumerable: false,
        writable: true,
        configurable: true
      }});
    if (superClass)
      _Object$setPrototypeOf ? _Object$setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
  };
  exports.__esModule = true;
  return module.exports;
});

$__System.registerDynamic("d0", ["f", "9", "a", "4", "bf", "d1", "5", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _inherits = $__require('f')["default"];
  var _classCallCheck = $__require('9')["default"];
  var _interopRequireDefault = $__require('a')["default"];
  var _interopRequireWildcard = $__require('4')["default"];
  exports.__esModule = true;
  var _babelHelperFunctionName = $__require('bf');
  var _babelHelperFunctionName2 = _interopRequireDefault(_babelHelperFunctionName);
  var _vanilla = $__require('d1');
  var _vanilla2 = _interopRequireDefault(_vanilla);
  var _babelTypes = $__require('5');
  var t = _interopRequireWildcard(_babelTypes);
  var LooseClassTransformer = (function(_VanillaTransformer) {
    _inherits(LooseClassTransformer, _VanillaTransformer);
    function LooseClassTransformer() {
      _classCallCheck(this, LooseClassTransformer);
      _VanillaTransformer.apply(this, arguments);
      this.isLoose = true;
    }
    LooseClassTransformer.prototype._processMethod = function _processMethod(node, scope) {
      if (!node.decorators) {
        var classRef = this.classRef;
        if (!node["static"])
          classRef = t.memberExpression(classRef, t.identifier("prototype"));
        var methodName = t.memberExpression(classRef, node.key, node.computed || t.isLiteral(node.key));
        var func = t.functionExpression(null, node.params, node.body, node.generator, node.async);
        var key = t.toComputedKey(node, node.key);
        if (t.isStringLiteral(key)) {
          func = _babelHelperFunctionName2["default"]({
            node: func,
            id: key,
            scope: scope
          });
        }
        var expr = t.expressionStatement(t.assignmentExpression("=", methodName, func));
        t.inheritsComments(expr, node);
        this.body.push(expr);
        return true;
      }
    };
    return LooseClassTransformer;
  })(_vanilla2["default"]);
  exports["default"] = LooseClassTransformer;
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("d2", ["a", "4", "bf", "94", "d3", "5", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireDefault = $__require('a')["default"];
  var _interopRequireWildcard = $__require('4')["default"];
  exports.__esModule = true;
  exports.push = push;
  exports.hasComputed = hasComputed;
  exports.toComputedObjectFromClass = toComputedObjectFromClass;
  exports.toClassObject = toClassObject;
  exports.toDefineObject = toDefineObject;
  var _babelHelperFunctionName = $__require('bf');
  var _babelHelperFunctionName2 = _interopRequireDefault(_babelHelperFunctionName);
  var _lodashCollectionEach = $__require('94');
  var _lodashCollectionEach2 = _interopRequireDefault(_lodashCollectionEach);
  var _lodashObjectHas = $__require('d3');
  var _lodashObjectHas2 = _interopRequireDefault(_lodashObjectHas);
  var _babelTypes = $__require('5');
  var t = _interopRequireWildcard(_babelTypes);
  function toKind(node) {
    if (t.isClassMethod(node) || t.isObjectMethod(node)) {
      if (node.kind === "get" || node.kind === "set") {
        return node.kind;
      }
    }
    return "value";
  }
  function push(mutatorMap, node, kind, file, scope) {
    var alias = t.toKeyAlias(node);
    var map = {};
    if (_lodashObjectHas2["default"](mutatorMap, alias))
      map = mutatorMap[alias];
    mutatorMap[alias] = map;
    map._inherits = map._inherits || [];
    map._inherits.push(node);
    map._key = node.key;
    if (node.computed) {
      map._computed = true;
    }
    if (node.decorators) {
      var decorators = map.decorators = map.decorators || t.arrayExpression([]);
      decorators.elements = decorators.elements.concat(node.decorators.map(function(dec) {
        return dec.expression;
      }).reverse());
    }
    if (map.value || map.initializer) {
      throw file.buildCodeFrameError(node, "Key conflict with sibling node");
    }
    var key = undefined,
        value = undefined;
    if (t.isObjectProperty(node) || t.isObjectMethod(node) || t.isClassMethod(node)) {
      key = t.toComputedKey(node, node.key);
    }
    if (t.isObjectProperty(node) || t.isClassProperty(node)) {
      value = node.value;
    } else if (t.isObjectMethod(node) || t.isClassMethod(node)) {
      value = t.functionExpression(null, node.params, node.body, node.generator, node.async);
    }
    var inheritedKind = toKind(node);
    if (!kind || inheritedKind !== "value") {
      kind = inheritedKind;
    }
    if (scope && t.isStringLiteral(key) && (kind === "value" || kind === "initializer") && t.isFunctionExpression(value)) {
      value = _babelHelperFunctionName2["default"]({
        id: key,
        node: value,
        scope: scope
      });
    }
    if (value) {
      t.inheritsComments(value, node);
      map[kind] = value;
    }
    return map;
  }
  function hasComputed(mutatorMap) {
    for (var key in mutatorMap) {
      if (mutatorMap[key]._computed) {
        return true;
      }
    }
    return false;
  }
  function toComputedObjectFromClass(obj) {
    var objExpr = t.arrayExpression([]);
    for (var i = 0; i < obj.properties.length; i++) {
      var prop = obj.properties[i];
      var val = prop.value;
      val.properties.unshift(t.objectProperty(t.identifier("key"), t.toComputedKey(prop)));
      objExpr.elements.push(val);
    }
    return objExpr;
  }
  function toClassObject(mutatorMap) {
    var objExpr = t.objectExpression([]);
    _lodashCollectionEach2["default"](mutatorMap, function(map) {
      var mapNode = t.objectExpression([]);
      var propNode = t.objectProperty(map._key, mapNode, map._computed);
      _lodashCollectionEach2["default"](map, function(node, key) {
        if (key[0] === "_")
          return;
        var inheritNode = node;
        if (t.isClassMethod(node) || t.isClassProperty(node))
          node = node.value;
        var prop = t.objectProperty(t.identifier(key), node);
        t.inheritsComments(prop, inheritNode);
        t.removeComments(inheritNode);
        mapNode.properties.push(prop);
      });
      objExpr.properties.push(propNode);
    });
    return objExpr;
  }
  function toDefineObject(mutatorMap) {
    _lodashCollectionEach2["default"](mutatorMap, function(map) {
      if (map.value)
        map.writable = t.booleanLiteral(true);
      map.configurable = t.booleanLiteral(true);
      map.enumerable = t.booleanLiteral(true);
    });
    return toClassObject(mutatorMap);
  }
  return module.exports;
});

$__System.registerDynamic("d1", ["9", "45", "a", "4", "10", "d4", "d5", "d2", "73", "5", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _classCallCheck = $__require('9')["default"];
  var _getIterator = $__require('45')["default"];
  var _interopRequireDefault = $__require('a')["default"];
  var _interopRequireWildcard = $__require('4')["default"];
  exports.__esModule = true;
  var _babelTraverse = $__require('10');
  var _babelHelperReplaceSupers = $__require('d4');
  var _babelHelperReplaceSupers2 = _interopRequireDefault(_babelHelperReplaceSupers);
  var _babelHelperOptimiseCallExpression = $__require('d5');
  var _babelHelperOptimiseCallExpression2 = _interopRequireDefault(_babelHelperOptimiseCallExpression);
  var _babelHelperDefineMap = $__require('d2');
  var defineMap = _interopRequireWildcard(_babelHelperDefineMap);
  var _babelTemplate = $__require('73');
  var _babelTemplate2 = _interopRequireDefault(_babelTemplate);
  var _babelTypes = $__require('5');
  var t = _interopRequireWildcard(_babelTypes);
  var buildDerivedConstructor = _babelTemplate2["default"]("\n  (function () {\n    super(...arguments);\n  })\n");
  var noMethodVisitor = {
    "FunctionExpression|FunctionDeclaration": function FunctionExpressionFunctionDeclaration(path) {
      if (!path.is("shadow")) {
        path.skip();
      }
    },
    Method: function Method(path) {
      path.skip();
    }
  };
  var verifyConstructorVisitor = _babelTraverse.visitors.merge([noMethodVisitor, {
    Super: function Super(path) {
      if (this.isDerived && !this.hasBareSuper && !path.parentPath.isCallExpression({callee: path.node})) {
        throw path.buildCodeFrameError("'super.*' is not allowed before super()");
      }
    },
    CallExpression: {exit: function exit(path) {
        if (path.get("callee").isSuper()) {
          this.hasBareSuper = true;
          if (!this.isDerived) {
            throw path.buildCodeFrameError("super() is only allowed in a derived constructor");
          }
        }
      }},
    ThisExpression: function ThisExpression(path) {
      if (this.isDerived && !this.hasBareSuper) {
        if (!path.inShadow("this")) {
          throw path.buildCodeFrameError("'this' is not allowed before super()");
        }
      }
    }
  }]);
  var findThisesVisitor = _babelTraverse.visitors.merge([noMethodVisitor, {ThisExpression: function ThisExpression(path) {
      this.superThises.push(path);
    }}]);
  var ClassTransformer = (function() {
    function ClassTransformer(path, file) {
      _classCallCheck(this, ClassTransformer);
      this.parent = path.parent;
      this.scope = path.scope;
      this.node = path.node;
      this.path = path;
      this.file = file;
      this.clearDescriptors();
      this.instancePropBody = [];
      this.instancePropRefs = {};
      this.staticPropBody = [];
      this.body = [];
      this.bareSuperAfter = [];
      this.bareSupers = [];
      this.pushedConstructor = false;
      this.pushedInherits = false;
      this.isLoose = false;
      this.superThises = [];
      this.classId = this.node.id;
      this.classRef = this.node.id || this.scope.generateUidIdentifier("class");
      this.superName = this.node.superClass || t.identifier("Function");
      this.isDerived = !!this.node.superClass;
    }
    ClassTransformer.prototype.run = function run() {
      var _this = this;
      var superName = this.superName;
      var file = this.file;
      var body = this.body;
      var constructorBody = this.constructorBody = t.blockStatement([]);
      this.constructor = this.buildConstructor();
      var closureParams = [];
      var closureArgs = [];
      if (this.isDerived) {
        closureArgs.push(superName);
        superName = this.scope.generateUidIdentifierBasedOnNode(superName);
        closureParams.push(superName);
        this.superName = superName;
      }
      this.buildBody();
      constructorBody.body.unshift(t.expressionStatement(t.callExpression(file.addHelper("classCallCheck"), [t.thisExpression(), this.classRef])));
      body = body.concat(this.staticPropBody.map(function(fn) {
        return fn(_this.classRef);
      }));
      if (this.classId) {
        if (body.length === 1)
          return t.toExpression(body[0]);
      }
      body.push(t.returnStatement(this.classRef));
      var container = t.functionExpression(null, closureParams, t.blockStatement(body));
      container.shadow = true;
      return t.callExpression(container, closureArgs);
    };
    ClassTransformer.prototype.buildConstructor = function buildConstructor() {
      var func = t.functionDeclaration(this.classRef, [], this.constructorBody);
      t.inherits(func, this.node);
      return func;
    };
    ClassTransformer.prototype.pushToMap = function pushToMap(node, enumerable, kind, scope) {
      if (kind === undefined)
        kind = "value";
      var mutatorMap = undefined;
      if (node["static"]) {
        this.hasStaticDescriptors = true;
        mutatorMap = this.staticMutatorMap;
      } else {
        this.hasInstanceDescriptors = true;
        mutatorMap = this.instanceMutatorMap;
      }
      var map = defineMap.push(mutatorMap, node, kind, this.file, scope);
      if (enumerable) {
        map.enumerable = t.booleanLiteral(true);
      }
      return map;
    };
    ClassTransformer.prototype.constructorMeMaybe = function constructorMeMaybe() {
      var hasConstructor = false;
      var paths = this.path.get("body.body");
      var _arr = paths;
      for (var _i = 0; _i < _arr.length; _i++) {
        var path = _arr[_i];
        hasConstructor = path.equals("kind", "constructor");
        if (hasConstructor)
          break;
      }
      if (hasConstructor)
        return;
      var params = undefined,
          body = undefined;
      if (this.isDerived) {
        var _constructor = buildDerivedConstructor().expression;
        params = _constructor.params;
        body = _constructor.body;
      } else {
        params = [];
        body = t.blockStatement([]);
      }
      this.path.get("body").unshiftContainer("body", t.classMethod("constructor", t.identifier("constructor"), params, body));
    };
    ClassTransformer.prototype.buildBody = function buildBody() {
      this.constructorMeMaybe();
      this.pushBody();
      this.verifyConstructor();
      if (this.userConstructor) {
        var constructorBody = this.constructorBody;
        constructorBody.body = constructorBody.body.concat(this.userConstructor.body.body);
        t.inherits(this.constructor, this.userConstructor);
        t.inherits(constructorBody, this.userConstructor.body);
      }
      this.pushDescriptors();
    };
    ClassTransformer.prototype.pushBody = function pushBody() {
      var classBodyPaths = this.path.get("body.body");
      for (var _i2 = 0; _i2 < classBodyPaths.length; _i2++) {
        var path = classBodyPaths[_i2];
        var node = path.node;
        if (path.isClassProperty()) {
          throw path.buildCodeFrameError("Missing class properties transform.");
        }
        if (node.decorators) {
          throw path.buildCodeFrameError("Method has decorators, put the decorator plugin before the classes one.");
        }
        if (t.isClassMethod(node)) {
          var isConstructor = node.kind === "constructor";
          if (isConstructor) {
            path.traverse(verifyConstructorVisitor, this);
            if (!this.hasBareSuper && this.isDerived) {
              throw path.buildCodeFrameError("missing super() call in constructor");
            }
          }
          var replaceSupers = new _babelHelperReplaceSupers2["default"]({
            forceSuperMemoisation: isConstructor,
            methodPath: path,
            methodNode: node,
            objectRef: this.classRef,
            superRef: this.superName,
            isStatic: node["static"],
            isLoose: this.isLoose,
            scope: this.scope,
            file: this.file
          }, true);
          replaceSupers.replace();
          if (isConstructor) {
            this.pushConstructor(replaceSupers, node, path);
          } else {
            this.pushMethod(node, path);
          }
        }
      }
    };
    ClassTransformer.prototype.clearDescriptors = function clearDescriptors() {
      this.hasInstanceDescriptors = false;
      this.hasStaticDescriptors = false;
      this.instanceMutatorMap = {};
      this.staticMutatorMap = {};
    };
    ClassTransformer.prototype.pushDescriptors = function pushDescriptors() {
      this.pushInherits();
      var body = this.body;
      var instanceProps = undefined;
      var staticProps = undefined;
      if (this.hasInstanceDescriptors) {
        instanceProps = defineMap.toClassObject(this.instanceMutatorMap);
      }
      if (this.hasStaticDescriptors) {
        staticProps = defineMap.toClassObject(this.staticMutatorMap);
      }
      if (instanceProps || staticProps) {
        if (instanceProps)
          instanceProps = defineMap.toComputedObjectFromClass(instanceProps);
        if (staticProps)
          staticProps = defineMap.toComputedObjectFromClass(staticProps);
        var nullNode = t.nullLiteral();
        var args = [this.classRef, nullNode, nullNode, nullNode, nullNode];
        if (instanceProps)
          args[1] = instanceProps;
        if (staticProps)
          args[2] = staticProps;
        if (this.instanceInitializersId) {
          args[3] = this.instanceInitializersId;
          body.unshift(this.buildObjectAssignment(this.instanceInitializersId));
        }
        if (this.staticInitializersId) {
          args[4] = this.staticInitializersId;
          body.unshift(this.buildObjectAssignment(this.staticInitializersId));
        }
        var lastNonNullIndex = 0;
        for (var i = 0; i < args.length; i++) {
          if (args[i] !== nullNode)
            lastNonNullIndex = i;
        }
        args = args.slice(0, lastNonNullIndex + 1);
        body.push(t.expressionStatement(t.callExpression(this.file.addHelper("createClass"), args)));
      }
      this.clearDescriptors();
    };
    ClassTransformer.prototype.buildObjectAssignment = function buildObjectAssignment(id) {
      return t.variableDeclaration("var", [t.variableDeclarator(id, t.objectExpression([]))]);
    };
    ClassTransformer.prototype.wrapSuperCall = function wrapSuperCall(bareSuper, superRef, thisRef, body) {
      var bareSuperNode = bareSuper.node;
      if (this.isLoose) {
        bareSuperNode.arguments.unshift(t.thisExpression());
        if (bareSuperNode.arguments.length === 2 && t.isSpreadElement(bareSuperNode.arguments[1]) && t.isIdentifier(bareSuperNode.arguments[1].argument, {name: "arguments"})) {
          bareSuperNode.arguments[1] = bareSuperNode.arguments[1].argument;
          bareSuperNode.callee = t.memberExpression(superRef, t.identifier("apply"));
        } else {
          bareSuperNode.callee = t.memberExpression(superRef, t.identifier("call"));
        }
      } else {
        bareSuperNode = _babelHelperOptimiseCallExpression2["default"](t.callExpression(t.memberExpression(t.identifier("Object"), t.identifier("getPrototypeOf")), [this.classRef]), t.thisExpression(), bareSuperNode.arguments);
      }
      var call = t.callExpression(this.file.addHelper("possibleConstructorReturn"), [t.thisExpression(), bareSuperNode]);
      var bareSuperAfter = this.bareSuperAfter.map(function(fn) {
        return fn(thisRef);
      });
      if (bareSuper.parentPath.isExpressionStatement() && bareSuper.parentPath.container === body.node.body && body.node.body.length - 1 === bareSuper.parentPath.key) {
        if (this.superThises.length || bareSuperAfter.length) {
          bareSuper.scope.push({id: thisRef});
          call = t.assignmentExpression("=", thisRef, call);
        }
        if (bareSuperAfter.length) {
          call = t.toSequenceExpression([call].concat(bareSuperAfter, [thisRef]));
        }
        bareSuper.parentPath.replaceWith(t.returnStatement(call));
      } else {
        bareSuper.replaceWithMultiple([t.variableDeclaration("var", [t.variableDeclarator(thisRef, call)])].concat(bareSuperAfter, [t.expressionStatement(thisRef)]));
      }
    };
    ClassTransformer.prototype.verifyConstructor = function verifyConstructor() {
      var _this2 = this;
      if (!this.isDerived)
        return;
      var path = this.userConstructorPath;
      var body = path.get("body");
      path.traverse(findThisesVisitor, this);
      var guaranteedSuperBeforeFinish = !!this.bareSupers.length;
      var superRef = this.superName || t.identifier("Function");
      var thisRef = path.scope.generateUidIdentifier("this");
      for (var _iterator = this.bareSupers,
          _isArray = Array.isArray(_iterator),
          _i3 = 0,
          _iterator = _isArray ? _iterator : _getIterator(_iterator); ; ) {
        var _ref;
        if (_isArray) {
          if (_i3 >= _iterator.length)
            break;
          _ref = _iterator[_i3++];
        } else {
          _i3 = _iterator.next();
          if (_i3.done)
            break;
          _ref = _i3.value;
        }
        var bareSuper = _ref;
        this.wrapSuperCall(bareSuper, superRef, thisRef, body);
        if (guaranteedSuperBeforeFinish) {
          bareSuper.find(function(parentPath) {
            if (parentPath === path) {
              return true;
            }
            if (parentPath.isLoop() || parentPath.isConditional()) {
              guaranteedSuperBeforeFinish = false;
              return true;
            }
          });
        }
      }
      for (var _iterator2 = this.superThises,
          _isArray2 = Array.isArray(_iterator2),
          _i4 = 0,
          _iterator2 = _isArray2 ? _iterator2 : _getIterator(_iterator2); ; ) {
        var _ref2;
        if (_isArray2) {
          if (_i4 >= _iterator2.length)
            break;
          _ref2 = _iterator2[_i4++];
        } else {
          _i4 = _iterator2.next();
          if (_i4.done)
            break;
          _ref2 = _i4.value;
        }
        var thisPath = _ref2;
        thisPath.replaceWith(thisRef);
      }
      var wrapReturn = function wrapReturn(returnArg) {
        return t.callExpression(_this2.file.addHelper("possibleConstructorReturn"), [thisRef].concat(returnArg || []));
      };
      var bodyPaths = body.get("body");
      if (bodyPaths.length && !bodyPaths.pop().isReturnStatement()) {
        body.pushContainer("body", t.returnStatement(guaranteedSuperBeforeFinish ? thisRef : wrapReturn()));
      }
      for (var _iterator3 = this.superReturns,
          _isArray3 = Array.isArray(_iterator3),
          _i5 = 0,
          _iterator3 = _isArray3 ? _iterator3 : _getIterator(_iterator3); ; ) {
        var _ref3;
        if (_isArray3) {
          if (_i5 >= _iterator3.length)
            break;
          _ref3 = _iterator3[_i5++];
        } else {
          _i5 = _iterator3.next();
          if (_i5.done)
            break;
          _ref3 = _i5.value;
        }
        var returnPath = _ref3;
        if (returnPath.node.argument) {
          var ref = returnPath.scope.generateDeclaredUidIdentifier("ret");
          returnPath.get("argument").replaceWithMultiple([t.assignmentExpression("=", ref, returnPath.node.argument), wrapReturn(ref)]);
        } else {
          returnPath.get("argument").replaceWith(wrapReturn());
        }
      }
    };
    ClassTransformer.prototype.pushMethod = function pushMethod(node, path) {
      var scope = path ? path.scope : this.scope;
      if (node.kind === "method") {
        if (this._processMethod(node, scope))
          return;
      }
      this.pushToMap(node, false, null, scope);
    };
    ClassTransformer.prototype._processMethod = function _processMethod() {
      return false;
    };
    ClassTransformer.prototype.pushConstructor = function pushConstructor(replaceSupers, method, path) {
      this.bareSupers = replaceSupers.bareSupers;
      this.superReturns = replaceSupers.returns;
      if (path.scope.hasOwnBinding(this.classRef.name)) {
        path.scope.rename(this.classRef.name);
      }
      var construct = this.constructor;
      this.userConstructorPath = path;
      this.userConstructor = method;
      this.hasConstructor = true;
      t.inheritsComments(construct, method);
      construct._ignoreUserWhitespace = true;
      construct.params = method.params;
      t.inherits(construct.body, method.body);
      construct.body.directives = method.body.directives;
      this._pushConstructor();
    };
    ClassTransformer.prototype._pushConstructor = function _pushConstructor() {
      if (this.pushedConstructor)
        return;
      this.pushedConstructor = true;
      if (this.hasInstanceDescriptors || this.hasStaticDescriptors) {
        this.pushDescriptors();
      }
      this.body.push(this.constructor);
      this.pushInherits();
    };
    ClassTransformer.prototype.pushInherits = function pushInherits() {
      if (!this.isDerived || this.pushedInherits)
        return;
      this.pushedInherits = true;
      this.body.unshift(t.expressionStatement(t.callExpression(this.file.addHelper("inherits"), [this.classRef, this.superName])));
    };
    return ClassTransformer;
  })();
  exports["default"] = ClassTransformer;
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("bf", ["a", "4", "d6", "73", "5", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireDefault = $__require('a')["default"];
  var _interopRequireWildcard = $__require('4')["default"];
  exports.__esModule = true;
  var _babelHelperGetFunctionArity = $__require('d6');
  var _babelHelperGetFunctionArity2 = _interopRequireDefault(_babelHelperGetFunctionArity);
  var _babelTemplate = $__require('73');
  var _babelTemplate2 = _interopRequireDefault(_babelTemplate);
  var _babelTypes = $__require('5');
  var t = _interopRequireWildcard(_babelTypes);
  var buildPropertyMethodAssignmentWrapper = _babelTemplate2["default"]("\n  (function (FUNCTION_KEY) {\n    function FUNCTION_ID() {\n      return FUNCTION_KEY.apply(this, arguments);\n    }\n\n    FUNCTION_ID.toString = function () {\n      return FUNCTION_KEY.toString();\n    }\n\n    return FUNCTION_ID;\n  })(FUNCTION)\n");
  var buildGeneratorPropertyMethodAssignmentWrapper = _babelTemplate2["default"]("\n  (function (FUNCTION_KEY) {\n    function* FUNCTION_ID() {\n      return yield* FUNCTION_KEY.apply(this, arguments);\n    }\n\n    FUNCTION_ID.toString = function () {\n      return FUNCTION_KEY.toString();\n    };\n\n    return FUNCTION_ID;\n  })(FUNCTION)\n");
  var visitor = {"ReferencedIdentifier|BindingIdentifier": function ReferencedIdentifierBindingIdentifier(path, state) {
      if (path.node.name !== state.name)
        return;
      var localDeclar = path.scope.getBindingIdentifier(state.name);
      if (localDeclar !== state.outerDeclar)
        return;
      state.selfReference = true;
      path.stop();
    }};
  function wrap(state, method, id, scope) {
    if (state.selfReference) {
      if (scope.hasBinding(id.name) && !scope.hasGlobal(id.name)) {
        scope.rename(id.name);
      } else {
        if (!t.isFunction(method))
          return;
        var build = buildPropertyMethodAssignmentWrapper;
        if (method.generator)
          build = buildGeneratorPropertyMethodAssignmentWrapper;
        var _template = build({
          FUNCTION: method,
          FUNCTION_ID: id,
          FUNCTION_KEY: scope.generateUidIdentifier(id.name)
        }).expression;
        _template.callee._skipModulesRemap = true;
        var params = _template.callee.body.body[0].params;
        for (var i = 0,
            len = _babelHelperGetFunctionArity2["default"](method); i < len; i++) {
          params.push(scope.generateUidIdentifier("x"));
        }
        return _template;
      }
    }
    method.id = id;
    scope.getProgramParent().references[id.name] = true;
  }
  function visit(node, name, scope) {
    var state = {
      selfAssignment: false,
      selfReference: false,
      outerDeclar: scope.getBindingIdentifier(name),
      references: [],
      name: name
    };
    var binding = scope.getOwnBinding(name);
    if (binding) {
      if (binding.kind === "param") {
        state.selfReference = true;
      } else {}
    } else if (state.outerDeclar || scope.hasGlobal(name)) {
      scope.traverse(node, visitor, state);
    }
    return state;
  }
  exports["default"] = function(_ref) {
    var node = _ref.node;
    var parent = _ref.parent;
    var scope = _ref.scope;
    var id = _ref.id;
    if (node.id)
      return;
    if ((t.isObjectProperty(parent) || t.isObjectMethod(parent, {kind: "method"})) && (!parent.computed || t.isLiteral(parent.key))) {
      id = parent.key;
    } else if (t.isVariableDeclarator(parent)) {
      id = parent.id;
      if (t.isIdentifier(id)) {
        var binding = scope.parent.getBinding(id.name);
        if (binding && binding.constant && scope.getBinding(id.name) === binding) {
          node.id = id;
          node.id[t.NOT_LOCAL_BINDING] = true;
          return;
        }
      }
    } else if (t.isAssignmentExpression(parent)) {
      id = parent.left;
    } else if (!id) {
      return;
    }
    var name = undefined;
    if (id && t.isLiteral(id)) {
      name = id.value;
    } else if (id && t.isIdentifier(id)) {
      name = id.name;
    } else {
      return;
    }
    name = t.toBindingIdentifierName(name);
    id = t.identifier(name);
    id[t.NOT_LOCAL_BINDING] = true;
    var state = visit(node, name, scope);
    return wrap(state, node, id, scope) || node;
  };
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("d7", ["a9", "a", "d0", "d1", "bf", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _Symbol = $__require('a9')["default"];
  var _interopRequireDefault = $__require('a')["default"];
  exports.__esModule = true;
  var _loose = $__require('d0');
  var _loose2 = _interopRequireDefault(_loose);
  var _vanilla = $__require('d1');
  var _vanilla2 = _interopRequireDefault(_vanilla);
  var _babelHelperFunctionName = $__require('bf');
  var _babelHelperFunctionName2 = _interopRequireDefault(_babelHelperFunctionName);
  exports["default"] = function(_ref) {
    var t = _ref.types;
    var VISITED = _Symbol();
    return {visitor: {
        ExportDefaultDeclaration: function ExportDefaultDeclaration(path) {
          if (!path.get("declaration").isClassDeclaration())
            return;
          var node = path.node;
          var ref = node.declaration.id || path.scope.generateUidIdentifier("class");
          node.declaration.id = ref;
          path.replaceWith(node.declaration);
          path.insertAfter(t.exportDefaultDeclaration(ref));
        },
        ClassDeclaration: function ClassDeclaration(path) {
          var node = path.node;
          var ref = node.id || path.scope.generateUidIdentifier("class");
          path.replaceWith(t.variableDeclaration("let", [t.variableDeclarator(ref, t.toExpression(node))]));
        },
        ClassExpression: function ClassExpression(path, state) {
          var node = path.node;
          if (node[VISITED])
            return;
          var inferred = _babelHelperFunctionName2["default"](path);
          if (inferred && inferred !== node)
            return path.replaceWith(inferred);
          node[VISITED] = true;
          var Constructor = _vanilla2["default"];
          if (state.opts.loose)
            Constructor = _loose2["default"];
          path.replaceWith(new Constructor(path, state.file).run());
        }
      }};
  };
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("d5", ["4", "5", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireWildcard = $__require('4')["default"];
  exports.__esModule = true;
  var _babelTypes = $__require('5');
  var t = _interopRequireWildcard(_babelTypes);
  exports["default"] = function(callee, thisNode, args) {
    if (args.length === 1 && t.isSpreadElement(args[0]) && t.isIdentifier(args[0].argument, {name: "arguments"})) {
      return t.callExpression(t.memberExpression(callee, t.identifier("apply")), [thisNode, args[0].argument]);
    } else {
      return t.callExpression(t.memberExpression(callee, t.identifier("call")), [thisNode].concat(args));
    }
  };
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("d4", ["9", "a9", "a", "4", "d5", "4a", "5", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _classCallCheck = $__require('9')["default"];
  var _Symbol = $__require('a9')["default"];
  var _interopRequireDefault = $__require('a')["default"];
  var _interopRequireWildcard = $__require('4')["default"];
  exports.__esModule = true;
  var _babelHelperOptimiseCallExpression = $__require('d5');
  var _babelHelperOptimiseCallExpression2 = _interopRequireDefault(_babelHelperOptimiseCallExpression);
  var _babelMessages = $__require('4a');
  var messages = _interopRequireWildcard(_babelMessages);
  var _babelTypes = $__require('5');
  var t = _interopRequireWildcard(_babelTypes);
  var HARDCORE_THIS_REF = _Symbol();
  function isIllegalBareSuper(node, parent) {
    if (!t.isSuper(node))
      return false;
    if (t.isMemberExpression(parent, {computed: false}))
      return false;
    if (t.isCallExpression(parent, {callee: node}))
      return false;
    return true;
  }
  function isMemberExpressionSuper(node) {
    return t.isMemberExpression(node) && t.isSuper(node.object);
  }
  var visitor = {
    Function: function Function(path) {
      if (!path.inShadow("this")) {
        path.skip();
      }
    },
    ReturnStatement: function ReturnStatement(path, state) {
      if (!path.inShadow("this")) {
        state.returns.push(path);
      }
    },
    ThisExpression: function ThisExpression(path, state) {
      if (!path.node[HARDCORE_THIS_REF]) {
        state.thises.push(path);
      }
    },
    enter: function enter(path, state) {
      var callback = state.specHandle;
      if (state.isLoose)
        callback = state.looseHandle;
      var isBareSuper = path.isCallExpression() && path.get("callee").isSuper();
      var result = callback.call(state, path);
      if (result) {
        state.hasSuper = true;
      }
      if (isBareSuper) {
        state.bareSupers.push(path);
      }
      if (result === true) {
        path.requeue();
      }
      if (result !== true && result) {
        if (Array.isArray(result)) {
          path.replaceWithMultiple(result);
        } else {
          path.replaceWith(result);
        }
      }
    }
  };
  var ReplaceSupers = (function() {
    function ReplaceSupers(opts) {
      var inClass = arguments.length <= 1 || arguments[1] === undefined ? false : arguments[1];
      _classCallCheck(this, ReplaceSupers);
      this.forceSuperMemoisation = opts.forceSuperMemoisation;
      this.methodPath = opts.methodPath;
      this.methodNode = opts.methodNode;
      this.superRef = opts.superRef;
      this.isStatic = opts.isStatic;
      this.hasSuper = false;
      this.inClass = inClass;
      this.isLoose = opts.isLoose;
      this.scope = this.methodPath.scope;
      this.file = opts.file;
      this.opts = opts;
      this.bareSupers = [];
      this.returns = [];
      this.thises = [];
    }
    ReplaceSupers.prototype.getObjectRef = function getObjectRef() {
      return this.opts.objectRef || this.opts.getObjectRef();
    };
    ReplaceSupers.prototype.setSuperProperty = function setSuperProperty(property, value, isComputed) {
      return t.callExpression(this.file.addHelper("set"), [t.callExpression(t.memberExpression(t.identifier("Object"), t.identifier("getPrototypeOf")), [this.isStatic ? this.getObjectRef() : t.memberExpression(this.getObjectRef(), t.identifier("prototype"))]), isComputed ? property : t.stringLiteral(property.name), value, t.thisExpression()]);
    };
    ReplaceSupers.prototype.getSuperProperty = function getSuperProperty(property, isComputed) {
      return t.callExpression(this.file.addHelper("get"), [t.callExpression(t.memberExpression(t.identifier("Object"), t.identifier("getPrototypeOf")), [this.isStatic ? this.getObjectRef() : t.memberExpression(this.getObjectRef(), t.identifier("prototype"))]), isComputed ? property : t.stringLiteral(property.name), t.thisExpression()]);
    };
    ReplaceSupers.prototype.replace = function replace() {
      this.methodPath.traverse(visitor, this);
    };
    ReplaceSupers.prototype.getLooseSuperProperty = function getLooseSuperProperty(id, parent) {
      var methodNode = this.methodNode;
      var superRef = this.superRef || t.identifier("Function");
      if (parent.property === id) {
        return;
      } else if (t.isCallExpression(parent, {callee: id})) {
        return;
      } else if (t.isMemberExpression(parent) && !methodNode["static"]) {
        return t.memberExpression(superRef, t.identifier("prototype"));
      } else {
        return superRef;
      }
    };
    ReplaceSupers.prototype.looseHandle = function looseHandle(path) {
      var node = path.node;
      if (path.isSuper()) {
        return this.getLooseSuperProperty(node, path.parent);
      } else if (path.isCallExpression()) {
        var callee = node.callee;
        if (!t.isMemberExpression(callee))
          return;
        if (!t.isSuper(callee.object))
          return;
        t.appendToMemberExpression(callee, t.identifier("call"));
        node.arguments.unshift(t.thisExpression());
        return true;
      }
    };
    ReplaceSupers.prototype.specHandleAssignmentExpression = function specHandleAssignmentExpression(ref, path, node) {
      if (node.operator === "=") {
        return this.setSuperProperty(node.left.property, node.right, node.left.computed);
      } else {
        ref = ref || path.scope.generateUidIdentifier("ref");
        return [t.variableDeclaration("var", [t.variableDeclarator(ref, node.left)]), t.expressionStatement(t.assignmentExpression("=", node.left, t.binaryExpression(node.operator[0], ref, node.right)))];
      }
    };
    ReplaceSupers.prototype.specHandle = function specHandle(path) {
      var property = undefined;
      var computed = undefined;
      var args = undefined;
      var thisReference = undefined;
      var parent = path.parent;
      var node = path.node;
      if (isIllegalBareSuper(node, parent)) {
        throw path.buildCodeFrameError(messages.get("classesIllegalBareSuper"));
      }
      if (t.isCallExpression(node)) {
        var callee = node.callee;
        if (t.isSuper(callee)) {
          return;
        } else if (isMemberExpressionSuper(callee)) {
          property = callee.property;
          computed = callee.computed;
          args = node.arguments;
        }
      } else if (t.isMemberExpression(node) && t.isSuper(node.object)) {
        property = node.property;
        computed = node.computed;
      } else if (t.isUpdateExpression(node) && isMemberExpressionSuper(node.argument)) {
        var binary = t.binaryExpression(node.operator[0], node.argument, t.numericLiteral(1));
        if (node.prefix) {
          return this.specHandleAssignmentExpression(null, path, binary);
        } else {
          var ref = path.scope.generateUidIdentifier("ref");
          return this.specHandleAssignmentExpression(ref, path, binary).concat(t.expressionStatement(ref));
        }
      } else if (t.isAssignmentExpression(node) && isMemberExpressionSuper(node.left)) {
        return this.specHandleAssignmentExpression(null, path, node);
      }
      if (!property)
        return;
      var superProperty = this.getSuperProperty(property, computed, thisReference);
      if (args) {
        return this.optimiseCall(superProperty, args);
      } else {
        return superProperty;
      }
    };
    ReplaceSupers.prototype.optimiseCall = function optimiseCall(callee, args) {
      var thisNode = t.thisExpression();
      thisNode[HARDCORE_THIS_REF] = true;
      return _babelHelperOptimiseCallExpression2["default"](callee, thisNode, args);
    };
    return ReplaceSupers;
  })();
  exports["default"] = ReplaceSupers;
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("d8", ["a9", "a", "d4", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _Symbol = $__require('a9')["default"];
  var _interopRequireDefault = $__require('a')["default"];
  exports.__esModule = true;
  var _babelHelperReplaceSupers = $__require('d4');
  var _babelHelperReplaceSupers2 = _interopRequireDefault(_babelHelperReplaceSupers);
  exports["default"] = function(_ref) {
    var t = _ref.types;
    function Property(path, node, scope, getObjectRef, file) {
      var replaceSupers = new _babelHelperReplaceSupers2["default"]({
        getObjectRef: getObjectRef,
        methodNode: node,
        methodPath: path,
        isStatic: true,
        scope: scope,
        file: file
      });
      replaceSupers.replace();
    }
    var CONTAINS_SUPER = _Symbol();
    return {visitor: {
        Super: function Super(path) {
          var parentObj = path.findParent(function(path) {
            return path.isObjectExpression();
          });
          if (parentObj)
            parentObj.node[CONTAINS_SUPER] = true;
        },
        ObjectExpression: {exit: function exit(path, file) {
            if (!path.node[CONTAINS_SUPER])
              return;
            var objectRef = undefined;
            var getObjectRef = function getObjectRef() {
              return objectRef = objectRef || path.scope.generateUidIdentifier("obj");
            };
            var propPaths = path.get("properties");
            for (var _i = 0; _i < propPaths.length; _i++) {
              var propPath = propPaths[_i];
              if (propPath.isObjectProperty())
                propPath = propPath.get("value");
              Property(propPath, propPath.node, path.scope, getObjectRef, file);
            }
            if (objectRef) {
              path.scope.push({id: objectRef});
              path.replaceWith(t.assignmentExpression("=", objectRef, path.node));
            }
          }}
      }};
  };
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("d9", ["4", "5", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireWildcard = $__require('4')["default"];
  exports.__esModule = true;
  var _babelTypes = $__require('5');
  var t = _interopRequireWildcard(_babelTypes);
  exports["default"] = function() {
    return {visitor: {
        ObjectMethod: function ObjectMethod(path) {
          var node = path.node;
          if (node.kind === "method") {
            path.replaceWith(t.objectProperty(node.key, t.functionExpression(null, node.params, node.body, node.generator, node.async), node.computed));
          }
        },
        ObjectProperty: function ObjectProperty(_ref) {
          var node = _ref.node;
          if (node.shorthand) {
            node.shorthand = false;
          }
        }
      }};
  };
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("da", ["45", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _getIterator = $__require('45')["default"];
  exports.__esModule = true;
  exports["default"] = function(_ref4) {
    var t = _ref4.types;
    var template = _ref4.template;
    var buildMutatorMapAssign = template("\n    MUTATOR_MAP_REF[KEY] = MUTATOR_MAP_REF[KEY] || {};\n    MUTATOR_MAP_REF[KEY].KIND = VALUE;\n  ");
    function getValue(prop) {
      if (t.isObjectProperty(prop)) {
        return prop.value;
      } else if (t.isObjectMethod(prop)) {
        return t.functionExpression(null, prop.params, prop.body, prop.generator, prop.async);
      }
    }
    function pushAssign(objId, prop, body) {
      if (prop.kind === "get" && prop.kind === "set") {
        pushMutatorDefine(objId, prop, body);
      } else {
        body.push(t.expressionStatement(t.assignmentExpression("=", t.memberExpression(objId, prop.key, prop.computed || t.isLiteral(prop.key)), getValue(prop))));
      }
    }
    function pushMutatorDefine(_ref5, prop) {
      var objId = _ref5.objId;
      var body = _ref5.body;
      var getMutatorId = _ref5.getMutatorId;
      var scope = _ref5.scope;
      var key = !prop.computed && t.isIdentifier(prop.key) ? t.stringLiteral(prop.key.name) : prop.key;
      var maybeMemoise = scope.maybeGenerateMemoised(key);
      if (maybeMemoise) {
        body.push(t.expressionStatement(t.assignmentExpression("=", maybeMemoise, key)));
        key = maybeMemoise;
      }
      body.push.apply(body, buildMutatorMapAssign({
        MUTATOR_MAP_REF: getMutatorId(),
        KEY: key,
        VALUE: getValue(prop),
        KIND: t.identifier(prop.kind)
      }));
    }
    function loose(info) {
      for (var _iterator = info.computedProps,
          _isArray = Array.isArray(_iterator),
          _i = 0,
          _iterator = _isArray ? _iterator : _getIterator(_iterator); ; ) {
        var _ref;
        if (_isArray) {
          if (_i >= _iterator.length)
            break;
          _ref = _iterator[_i++];
        } else {
          _i = _iterator.next();
          if (_i.done)
            break;
          _ref = _i.value;
        }
        var prop = _ref;
        if (prop.kind === "get" || prop.kind === "set") {
          pushMutatorDefine(info, prop);
        } else {
          pushAssign(info.objId, prop, info.body);
        }
      }
    }
    function spec(info) {
      var objId = info.objId;
      var body = info.body;
      var computedProps = info.computedProps;
      var state = info.state;
      for (var _iterator2 = computedProps,
          _isArray2 = Array.isArray(_iterator2),
          _i2 = 0,
          _iterator2 = _isArray2 ? _iterator2 : _getIterator(_iterator2); ; ) {
        var _ref2;
        if (_isArray2) {
          if (_i2 >= _iterator2.length)
            break;
          _ref2 = _iterator2[_i2++];
        } else {
          _i2 = _iterator2.next();
          if (_i2.done)
            break;
          _ref2 = _i2.value;
        }
        var prop = _ref2;
        var key = t.toComputedKey(prop);
        if (prop.kind === "get" || prop.kind === "set") {
          pushMutatorDefine(info, prop);
        } else if (t.isStringLiteral(key, {value: "__proto__"})) {
          pushAssign(objId, prop, body);
        } else {
          if (computedProps.length === 1) {
            return t.callExpression(state.addHelper("defineProperty"), [info.initPropExpression, key, getValue(prop)]);
          } else {
            body.push(t.expressionStatement(t.callExpression(state.addHelper("defineProperty"), [objId, key, getValue(prop)])));
          }
        }
      }
    }
    return {visitor: {ObjectExpression: {exit: function exit(path, state) {
            var node = path.node;
            var parent = path.parent;
            var scope = path.scope;
            var hasComputed = false;
            var _arr = node.properties;
            for (var _i3 = 0; _i3 < _arr.length; _i3++) {
              var prop = _arr[_i3];
              hasComputed = prop.computed === true;
              if (hasComputed)
                break;
            }
            if (!hasComputed)
              return;
            var initProps = [];
            var computedProps = [];
            var foundComputed = false;
            for (var _iterator3 = node.properties,
                _isArray3 = Array.isArray(_iterator3),
                _i4 = 0,
                _iterator3 = _isArray3 ? _iterator3 : _getIterator(_iterator3); ; ) {
              var _ref3;
              if (_isArray3) {
                if (_i4 >= _iterator3.length)
                  break;
                _ref3 = _iterator3[_i4++];
              } else {
                _i4 = _iterator3.next();
                if (_i4.done)
                  break;
                _ref3 = _i4.value;
              }
              var prop = _ref3;
              if (prop.computed) {
                foundComputed = true;
              }
              if (foundComputed) {
                computedProps.push(prop);
              } else {
                initProps.push(prop);
              }
            }
            var objId = scope.generateUidIdentifierBasedOnNode(parent);
            var initPropExpression = t.objectExpression(initProps);
            var body = [];
            body.push(t.variableDeclaration("var", [t.variableDeclarator(objId, initPropExpression)]));
            var callback = spec;
            if (state.opts.loose)
              callback = loose;
            var mutatorRef = undefined;
            var getMutatorId = function getMutatorId() {
              if (!mutatorRef) {
                mutatorRef = scope.generateUidIdentifier("mutatorMap");
                body.push(t.variableDeclaration("var", [t.variableDeclarator(mutatorRef, t.objectExpression([]))]));
              }
              return mutatorRef;
            };
            var single = callback({
              scope: scope,
              objId: objId,
              body: body,
              computedProps: computedProps,
              initPropExpression: initPropExpression,
              getMutatorId: getMutatorId,
              state: state
            });
            if (mutatorRef) {
              body.push(t.expressionStatement(t.callExpression(state.addHelper("defineEnumerableProperties"), [objId, mutatorRef])));
            }
            if (single) {
              path.replaceWith(single);
            } else {
              body.push(t.expressionStatement(objId));
              path.replaceWithMultiple(body);
            }
          }}}};
  };
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("db", [], true, function($__require, exports, module) {
  "use strict";
  ;
  var define,
      global = this,
      GLOBAL = this;
  exports.__esModule = true;
  exports["default"] = function(_ref) {
    var messages = _ref.messages;
    var template = _ref.template;
    var t = _ref.types;
    var buildForOfArray = template("\n    for (var KEY = 0; KEY < ARR.length; KEY++) BODY;\n  ");
    var buildForOfLoose = template("\n    for (var LOOP_OBJECT = OBJECT,\n             IS_ARRAY = Array.isArray(LOOP_OBJECT),\n             INDEX = 0,\n             LOOP_OBJECT = IS_ARRAY ? LOOP_OBJECT : LOOP_OBJECT[Symbol.iterator]();;) {\n      var ID;\n      if (IS_ARRAY) {\n        if (INDEX >= LOOP_OBJECT.length) break;\n        ID = LOOP_OBJECT[INDEX++];\n      } else {\n        INDEX = LOOP_OBJECT.next();\n        if (INDEX.done) break;\n        ID = INDEX.value;\n      }\n    }\n  ");
    var buildForOf = template("\n    var ITERATOR_COMPLETION = true;\n    var ITERATOR_HAD_ERROR_KEY = false;\n    var ITERATOR_ERROR_KEY = undefined;\n    try {\n      for (var ITERATOR_KEY = OBJECT[Symbol.iterator](), STEP_KEY; !(ITERATOR_COMPLETION = (STEP_KEY = ITERATOR_KEY.next()).done); ITERATOR_COMPLETION = true) {\n      }\n    } catch (err) {\n      ITERATOR_HAD_ERROR_KEY = true;\n      ITERATOR_ERROR_KEY = err;\n    } finally {\n      try {\n        if (!ITERATOR_COMPLETION && ITERATOR_KEY.return) {\n          ITERATOR_KEY.return();\n        }\n      } finally {\n        if (ITERATOR_HAD_ERROR_KEY) {\n          throw ITERATOR_ERROR_KEY;\n        }\n      }\n    }\n  ");
    function _ForOfStatementArray(path) {
      var node = path.node;
      var scope = path.scope;
      var nodes = [];
      var right = node.right;
      if (!t.isIdentifier(right) || !scope.hasBinding(right.name)) {
        var uid = scope.generateUidIdentifier("arr");
        nodes.push(t.variableDeclaration("var", [t.variableDeclarator(uid, right)]));
        right = uid;
      }
      var iterationKey = scope.generateUidIdentifier("i");
      var loop = buildForOfArray({
        BODY: node.body,
        KEY: iterationKey,
        ARR: right
      });
      t.inherits(loop, node);
      t.ensureBlock(loop);
      var iterationValue = t.memberExpression(right, iterationKey, true);
      var left = node.left;
      if (t.isVariableDeclaration(left)) {
        left.declarations[0].init = iterationValue;
        loop.body.body.unshift(left);
      } else {
        loop.body.body.unshift(t.expressionStatement(t.assignmentExpression("=", left, iterationValue)));
      }
      if (path.parentPath.isLabeledStatement()) {
        loop = t.labeledStatement(path.parentPath.node.label, loop);
      }
      nodes.push(loop);
      return nodes;
    }
    return {visitor: {ForOfStatement: function ForOfStatement(path, state) {
          if (path.get("right").isArrayExpression()) {
            return path.replaceWithMultiple(_ForOfStatementArray.call(this, path, state));
          }
          var callback = spec;
          if (state.opts.loose)
            callback = loose;
          var node = path.node;
          var build = callback(path, state);
          var declar = build.declar;
          var loop = build.loop;
          var block = loop.body;
          path.ensureBlock();
          if (declar) {
            block.body.push(declar);
          }
          block.body = block.body.concat(node.body.body);
          t.inherits(loop, node);
          t.inherits(loop.body, node.body);
          if (build.replaceParent) {
            path.parentPath.replaceWithMultiple(build.node);
            path.remove();
          } else {
            path.replaceWithMultiple(build.node);
          }
        }}};
    function loose(path, file) {
      var node = path.node;
      var scope = path.scope;
      var left = node.left;
      var declar = undefined,
          id = undefined;
      if (t.isIdentifier(left) || t.isPattern(left) || t.isMemberExpression(left)) {
        id = left;
      } else if (t.isVariableDeclaration(left)) {
        id = scope.generateUidIdentifier("ref");
        declar = t.variableDeclaration(left.kind, [t.variableDeclarator(left.declarations[0].id, id)]);
      } else {
        throw file.buildCodeFrameError(left, messages.get("unknownForHead", left.type));
      }
      var iteratorKey = scope.generateUidIdentifier("iterator");
      var isArrayKey = scope.generateUidIdentifier("isArray");
      var loop = buildForOfLoose({
        LOOP_OBJECT: iteratorKey,
        IS_ARRAY: isArrayKey,
        OBJECT: node.right,
        INDEX: scope.generateUidIdentifier("i"),
        ID: id
      });
      if (!declar) {
        loop.body.body.shift();
      }
      return {
        declar: declar,
        node: loop,
        loop: loop
      };
    }
    function spec(path, file) {
      var node = path.node;
      var scope = path.scope;
      var parent = path.parent;
      var left = node.left;
      var declar = undefined;
      var stepKey = scope.generateUidIdentifier("step");
      var stepValue = t.memberExpression(stepKey, t.identifier("value"));
      if (t.isIdentifier(left) || t.isPattern(left) || t.isMemberExpression(left)) {
        declar = t.expressionStatement(t.assignmentExpression("=", left, stepValue));
      } else if (t.isVariableDeclaration(left)) {
        declar = t.variableDeclaration(left.kind, [t.variableDeclarator(left.declarations[0].id, stepValue)]);
      } else {
        throw file.buildCodeFrameError(left, messages.get("unknownForHead", left.type));
      }
      var iteratorKey = scope.generateUidIdentifier("iterator");
      var template = buildForOf({
        ITERATOR_HAD_ERROR_KEY: scope.generateUidIdentifier("didIteratorError"),
        ITERATOR_COMPLETION: scope.generateUidIdentifier("iteratorNormalCompletion"),
        ITERATOR_ERROR_KEY: scope.generateUidIdentifier("iteratorError"),
        ITERATOR_KEY: iteratorKey,
        STEP_KEY: stepKey,
        OBJECT: node.right,
        BODY: null
      });
      var isLabeledParent = t.isLabeledStatement(parent);
      var tryBody = template[3].block.body;
      var loop = tryBody[0];
      if (isLabeledParent) {
        tryBody[0] = t.labeledStatement(parent.label, loop);
      }
      return {
        replaceParent: isLabeledParent,
        declar: declar,
        loop: loop,
        node: template
      };
    }
  };
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("dc", ["4", "dd", "5", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireWildcard = $__require('4')["default"];
  exports.__esModule = true;
  var _babelHelperRegex = $__require('dd');
  var regex = _interopRequireWildcard(_babelHelperRegex);
  var _babelTypes = $__require('5');
  var t = _interopRequireWildcard(_babelTypes);
  exports["default"] = function() {
    return {visitor: {RegExpLiteral: function RegExpLiteral(path) {
          var node = path.node;
          if (!regex.is(node, "y"))
            return;
          path.replaceWith(t.newExpression(t.identifier("RegExp"), [t.stringLiteral(node.pattern), t.stringLiteral(node.flags)]));
        }}};
  };
  module.exports = exports["default"];
  return module.exports;
});

(function() {
var define = $__System.amdDefine;
;
(function() {
  'use strict';
  var objectTypes = {
    'function': true,
    'object': true
  };
  var root = (objectTypes[typeof window] && window) || this;
  var oldRoot = root;
  var freeExports = objectTypes[typeof exports] && exports;
  var freeModule = objectTypes[typeof module] && module && !module.nodeType && module;
  var freeGlobal = freeExports && freeModule && typeof global == 'object' && global;
  if (freeGlobal && (freeGlobal.global === freeGlobal || freeGlobal.window === freeGlobal || freeGlobal.self === freeGlobal)) {
    root = freeGlobal;
  }
  var stringFromCharCode = String.fromCharCode;
  var floor = Math.floor;
  function fromCodePoint() {
    var MAX_SIZE = 0x4000;
    var codeUnits = [];
    var highSurrogate;
    var lowSurrogate;
    var index = -1;
    var length = arguments.length;
    if (!length) {
      return '';
    }
    var result = '';
    while (++index < length) {
      var codePoint = Number(arguments[index]);
      if (!isFinite(codePoint) || codePoint < 0 || codePoint > 0x10FFFF || floor(codePoint) != codePoint) {
        throw RangeError('Invalid code point: ' + codePoint);
      }
      if (codePoint <= 0xFFFF) {
        codeUnits.push(codePoint);
      } else {
        codePoint -= 0x10000;
        highSurrogate = (codePoint >> 10) + 0xD800;
        lowSurrogate = (codePoint % 0x400) + 0xDC00;
        codeUnits.push(highSurrogate, lowSurrogate);
      }
      if (index + 1 == length || codeUnits.length > MAX_SIZE) {
        result += stringFromCharCode.apply(null, codeUnits);
        codeUnits.length = 0;
      }
    }
    return result;
  }
  function assertType(type, expected) {
    if (expected.indexOf('|') == -1) {
      if (type == expected) {
        return;
      }
      throw Error('Invalid node type: ' + type);
    }
    expected = assertType.hasOwnProperty(expected) ? assertType[expected] : (assertType[expected] = RegExp('^(?:' + expected + ')$'));
    if (expected.test(type)) {
      return;
    }
    throw Error('Invalid node type: ' + type);
  }
  function generate(node) {
    var type = node.type;
    if (generate.hasOwnProperty(type) && typeof generate[type] == 'function') {
      return generate[type](node);
    }
    throw Error('Invalid node type: ' + type);
  }
  function generateAlternative(node) {
    assertType(node.type, 'alternative');
    var terms = node.body,
        length = terms ? terms.length : 0;
    if (length == 1) {
      return generateTerm(terms[0]);
    } else {
      var i = -1,
          result = '';
      while (++i < length) {
        result += generateTerm(terms[i]);
      }
      return result;
    }
  }
  function generateAnchor(node) {
    assertType(node.type, 'anchor');
    switch (node.kind) {
      case 'start':
        return '^';
      case 'end':
        return '$';
      case 'boundary':
        return '\\b';
      case 'not-boundary':
        return '\\B';
      default:
        throw Error('Invalid assertion');
    }
  }
  function generateAtom(node) {
    assertType(node.type, 'anchor|characterClass|characterClassEscape|dot|group|reference|value');
    return generate(node);
  }
  function generateCharacterClass(node) {
    assertType(node.type, 'characterClass');
    var classRanges = node.body,
        length = classRanges ? classRanges.length : 0;
    var i = -1,
        result = '[';
    if (node.negative) {
      result += '^';
    }
    while (++i < length) {
      result += generateClassAtom(classRanges[i]);
    }
    result += ']';
    return result;
  }
  function generateCharacterClassEscape(node) {
    assertType(node.type, 'characterClassEscape');
    return '\\' + node.value;
  }
  function generateCharacterClassRange(node) {
    assertType(node.type, 'characterClassRange');
    var min = node.min,
        max = node.max;
    if (min.type == 'characterClassRange' || max.type == 'characterClassRange') {
      throw Error('Invalid character class range');
    }
    return generateClassAtom(min) + '-' + generateClassAtom(max);
  }
  function generateClassAtom(node) {
    assertType(node.type, 'anchor|characterClassEscape|characterClassRange|dot|value');
    return generate(node);
  }
  function generateDisjunction(node) {
    assertType(node.type, 'disjunction');
    var body = node.body,
        length = body ? body.length : 0;
    if (length == 0) {
      throw Error('No body');
    } else if (length == 1) {
      return generate(body[0]);
    } else {
      var i = -1,
          result = '';
      while (++i < length) {
        if (i != 0) {
          result += '|';
        }
        result += generate(body[i]);
      }
      return result;
    }
  }
  function generateDot(node) {
    assertType(node.type, 'dot');
    return '.';
  }
  function generateGroup(node) {
    assertType(node.type, 'group');
    var result = '(';
    switch (node.behavior) {
      case 'normal':
        break;
      case 'ignore':
        result += '?:';
        break;
      case 'lookahead':
        result += '?=';
        break;
      case 'negativeLookahead':
        result += '?!';
        break;
      default:
        throw Error('Invalid behaviour: ' + node.behaviour);
    }
    var body = node.body,
        length = body ? body.length : 0;
    if (length == 1) {
      result += generate(body[0]);
    } else {
      var i = -1;
      while (++i < length) {
        result += generate(body[i]);
      }
    }
    result += ')';
    return result;
  }
  function generateQuantifier(node) {
    assertType(node.type, 'quantifier');
    var quantifier = '',
        min = node.min,
        max = node.max;
    switch (max) {
      case undefined:
      case null:
        switch (min) {
          case 0:
            quantifier = '*';
            break;
          case 1:
            quantifier = '+';
            break;
          default:
            quantifier = '{' + min + ',}';
            break;
        }
        break;
      default:
        if (min == max) {
          quantifier = '{' + min + '}';
        } else if (min == 0 && max == 1) {
          quantifier = '?';
        } else {
          quantifier = '{' + min + ',' + max + '}';
        }
        break;
    }
    if (!node.greedy) {
      quantifier += '?';
    }
    return generateAtom(node.body[0]) + quantifier;
  }
  function generateReference(node) {
    assertType(node.type, 'reference');
    return '\\' + node.matchIndex;
  }
  function generateTerm(node) {
    assertType(node.type, 'anchor|characterClass|characterClassEscape|empty|group|quantifier|reference|value');
    return generate(node);
  }
  function generateValue(node) {
    assertType(node.type, 'value');
    var kind = node.kind,
        codePoint = node.codePoint;
    switch (kind) {
      case 'controlLetter':
        return '\\c' + fromCodePoint(codePoint + 64);
      case 'hexadecimalEscape':
        return '\\x' + ('00' + codePoint.toString(16).toUpperCase()).slice(-2);
      case 'identifier':
        return '\\' + fromCodePoint(codePoint);
      case 'null':
        return '\\' + codePoint;
      case 'octal':
        return '\\' + codePoint.toString(8);
      case 'singleEscape':
        switch (codePoint) {
          case 0x0008:
            return '\\b';
          case 0x009:
            return '\\t';
          case 0x00A:
            return '\\n';
          case 0x00B:
            return '\\v';
          case 0x00C:
            return '\\f';
          case 0x00D:
            return '\\r';
          default:
            throw Error('Invalid codepoint: ' + codePoint);
        }
      case 'symbol':
        return fromCodePoint(codePoint);
      case 'unicodeEscape':
        return '\\u' + ('0000' + codePoint.toString(16).toUpperCase()).slice(-4);
      case 'unicodeCodePointEscape':
        return '\\u{' + codePoint.toString(16).toUpperCase() + '}';
      default:
        throw Error('Unsupported node kind: ' + kind);
    }
  }
  generate.alternative = generateAlternative;
  generate.anchor = generateAnchor;
  generate.characterClass = generateCharacterClass;
  generate.characterClassEscape = generateCharacterClassEscape;
  generate.characterClassRange = generateCharacterClassRange;
  generate.disjunction = generateDisjunction;
  generate.dot = generateDot;
  generate.group = generateGroup;
  generate.quantifier = generateQuantifier;
  generate.reference = generateReference;
  generate.value = generateValue;
  if (typeof define == 'function' && typeof define.amd == 'object' && define.amd) {
    define("de", [], function() {
      return {'generate': generate};
    });
  } else if (freeExports && freeModule) {
    freeExports.generate = generate;
  } else {
    root.regjsgen = {'generate': generate};
  }
}.call(this));

})();
$__System.registerDynamic("df", ["3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  (function() {
    function parse(str, flags) {
      function addRaw(node) {
        node.raw = str.substring(node.range[0], node.range[1]);
        return node;
      }
      function updateRawStart(node, start) {
        node.range[0] = start;
        return addRaw(node);
      }
      function createAnchor(kind, rawLength) {
        return addRaw({
          type: 'anchor',
          kind: kind,
          range: [pos - rawLength, pos]
        });
      }
      function createValue(kind, codePoint, from, to) {
        return addRaw({
          type: 'value',
          kind: kind,
          codePoint: codePoint,
          range: [from, to]
        });
      }
      function createEscaped(kind, codePoint, value, fromOffset) {
        fromOffset = fromOffset || 0;
        return createValue(kind, codePoint, pos - (value.length + fromOffset), pos);
      }
      function createCharacter(matches) {
        var _char = matches[0];
        var first = _char.charCodeAt(0);
        if (hasUnicodeFlag) {
          var second;
          if (_char.length === 1 && first >= 0xD800 && first <= 0xDBFF) {
            second = lookahead().charCodeAt(0);
            if (second >= 0xDC00 && second <= 0xDFFF) {
              pos++;
              return createValue('symbol', (first - 0xD800) * 0x400 + second - 0xDC00 + 0x10000, pos - 2, pos);
            }
          }
        }
        return createValue('symbol', first, pos - 1, pos);
      }
      function createDisjunction(alternatives, from, to) {
        return addRaw({
          type: 'disjunction',
          body: alternatives,
          range: [from, to]
        });
      }
      function createDot() {
        return addRaw({
          type: 'dot',
          range: [pos - 1, pos]
        });
      }
      function createCharacterClassEscape(value) {
        return addRaw({
          type: 'characterClassEscape',
          value: value,
          range: [pos - 2, pos]
        });
      }
      function createReference(matchIndex) {
        return addRaw({
          type: 'reference',
          matchIndex: parseInt(matchIndex, 10),
          range: [pos - 1 - matchIndex.length, pos]
        });
      }
      function createGroup(behavior, disjunction, from, to) {
        return addRaw({
          type: 'group',
          behavior: behavior,
          body: disjunction,
          range: [from, to]
        });
      }
      function createQuantifier(min, max, from, to) {
        if (to == null) {
          from = pos - 1;
          to = pos;
        }
        return addRaw({
          type: 'quantifier',
          min: min,
          max: max,
          greedy: true,
          body: null,
          range: [from, to]
        });
      }
      function createAlternative(terms, from, to) {
        return addRaw({
          type: 'alternative',
          body: terms,
          range: [from, to]
        });
      }
      function createCharacterClass(classRanges, negative, from, to) {
        return addRaw({
          type: 'characterClass',
          body: classRanges,
          negative: negative,
          range: [from, to]
        });
      }
      function createClassRange(min, max, from, to) {
        if (min.codePoint > max.codePoint) {
          bail('invalid range in character class', min.raw + '-' + max.raw, from, to);
        }
        return addRaw({
          type: 'characterClassRange',
          min: min,
          max: max,
          range: [from, to]
        });
      }
      function flattenBody(body) {
        if (body.type === 'alternative') {
          return body.body;
        } else {
          return [body];
        }
      }
      function isEmpty(obj) {
        return obj.type === 'empty';
      }
      function incr(amount) {
        amount = (amount || 1);
        var res = str.substring(pos, pos + amount);
        pos += (amount || 1);
        return res;
      }
      function skip(value) {
        if (!match(value)) {
          bail('character', value);
        }
      }
      function match(value) {
        if (str.indexOf(value, pos) === pos) {
          return incr(value.length);
        }
      }
      function lookahead() {
        return str[pos];
      }
      function current(value) {
        return str.indexOf(value, pos) === pos;
      }
      function next(value) {
        return str[pos + 1] === value;
      }
      function matchReg(regExp) {
        var subStr = str.substring(pos);
        var res = subStr.match(regExp);
        if (res) {
          res.range = [];
          res.range[0] = pos;
          incr(res[0].length);
          res.range[1] = pos;
        }
        return res;
      }
      function parseDisjunction() {
        var res = [],
            from = pos;
        res.push(parseAlternative());
        while (match('|')) {
          res.push(parseAlternative());
        }
        if (res.length === 1) {
          return res[0];
        }
        return createDisjunction(res, from, pos);
      }
      function parseAlternative() {
        var res = [],
            from = pos;
        var term;
        while (term = parseTerm()) {
          res.push(term);
        }
        if (res.length === 1) {
          return res[0];
        }
        return createAlternative(res, from, pos);
      }
      function parseTerm() {
        if (pos >= str.length || current('|') || current(')')) {
          return null;
        }
        var anchor = parseAnchor();
        if (anchor) {
          return anchor;
        }
        var atom = parseAtom();
        if (!atom) {
          bail('Expected atom');
        }
        var quantifier = parseQuantifier() || false;
        if (quantifier) {
          quantifier.body = flattenBody(atom);
          updateRawStart(quantifier, atom.range[0]);
          return quantifier;
        }
        return atom;
      }
      function parseGroup(matchA, typeA, matchB, typeB) {
        var type = null,
            from = pos;
        if (match(matchA)) {
          type = typeA;
        } else if (match(matchB)) {
          type = typeB;
        } else {
          return false;
        }
        var body = parseDisjunction();
        if (!body) {
          bail('Expected disjunction');
        }
        skip(')');
        var group = createGroup(type, flattenBody(body), from, pos);
        if (type == 'normal') {
          if (firstIteration) {
            closedCaptureCounter++;
          }
        }
        return group;
      }
      function parseAnchor() {
        var res,
            from = pos;
        if (match('^')) {
          return createAnchor('start', 1);
        } else if (match('$')) {
          return createAnchor('end', 1);
        } else if (match('\\b')) {
          return createAnchor('boundary', 2);
        } else if (match('\\B')) {
          return createAnchor('not-boundary', 2);
        } else {
          return parseGroup('(?=', 'lookahead', '(?!', 'negativeLookahead');
        }
      }
      function parseQuantifier() {
        var res,
            from = pos;
        var quantifier;
        var min,
            max;
        if (match('*')) {
          quantifier = createQuantifier(0);
        } else if (match('+')) {
          quantifier = createQuantifier(1);
        } else if (match('?')) {
          quantifier = createQuantifier(0, 1);
        } else if (res = matchReg(/^\{([0-9]+)\}/)) {
          min = parseInt(res[1], 10);
          quantifier = createQuantifier(min, min, res.range[0], res.range[1]);
        } else if (res = matchReg(/^\{([0-9]+),\}/)) {
          min = parseInt(res[1], 10);
          quantifier = createQuantifier(min, undefined, res.range[0], res.range[1]);
        } else if (res = matchReg(/^\{([0-9]+),([0-9]+)\}/)) {
          min = parseInt(res[1], 10);
          max = parseInt(res[2], 10);
          if (min > max) {
            bail('numbers out of order in {} quantifier', '', from, pos);
          }
          quantifier = createQuantifier(min, max, res.range[0], res.range[1]);
        }
        if (quantifier) {
          if (match('?')) {
            quantifier.greedy = false;
            quantifier.range[1] += 1;
          }
        }
        return quantifier;
      }
      function parseAtom() {
        var res;
        if (res = matchReg(/^[^^$\\.*+?(){[|]/)) {
          return createCharacter(res);
        } else if (match('.')) {
          return createDot();
        } else if (match('\\')) {
          res = parseAtomEscape();
          if (!res) {
            bail('atomEscape');
          }
          return res;
        } else if (res = parseCharacterClass()) {
          return res;
        } else {
          return parseGroup('(?:', 'ignore', '(', 'normal');
        }
      }
      function parseUnicodeSurrogatePairEscape(firstEscape) {
        if (hasUnicodeFlag) {
          var first,
              second;
          if (firstEscape.kind == 'unicodeEscape' && (first = firstEscape.codePoint) >= 0xD800 && first <= 0xDBFF && current('\\') && next('u')) {
            var prevPos = pos;
            pos++;
            var secondEscape = parseClassEscape();
            if (secondEscape.kind == 'unicodeEscape' && (second = secondEscape.codePoint) >= 0xDC00 && second <= 0xDFFF) {
              firstEscape.range[1] = secondEscape.range[1];
              firstEscape.codePoint = (first - 0xD800) * 0x400 + second - 0xDC00 + 0x10000;
              firstEscape.type = 'value';
              firstEscape.kind = 'unicodeCodePointEscape';
              addRaw(firstEscape);
            } else {
              pos = prevPos;
            }
          }
        }
        return firstEscape;
      }
      function parseClassEscape() {
        return parseAtomEscape(true);
      }
      function parseAtomEscape(insideCharacterClass) {
        var res,
            from = pos;
        res = parseDecimalEscape();
        if (res) {
          return res;
        }
        if (insideCharacterClass) {
          if (match('b')) {
            return createEscaped('singleEscape', 0x0008, '\\b');
          } else if (match('B')) {
            bail('\\B not possible inside of CharacterClass', '', from);
          }
        }
        res = parseCharacterEscape();
        return res;
      }
      function parseDecimalEscape() {
        var res,
            match;
        if (res = matchReg(/^(?!0)\d+/)) {
          match = res[0];
          var refIdx = parseInt(res[0], 10);
          if (refIdx <= closedCaptureCounter) {
            return createReference(res[0]);
          } else {
            backrefDenied.push(refIdx);
            incr(-res[0].length);
            if (res = matchReg(/^[0-7]{1,3}/)) {
              return createEscaped('octal', parseInt(res[0], 8), res[0], 1);
            } else {
              res = createCharacter(matchReg(/^[89]/));
              return updateRawStart(res, res.range[0] - 1);
            }
          }
        } else if (res = matchReg(/^[0-7]{1,3}/)) {
          match = res[0];
          if (/^0{1,3}$/.test(match)) {
            return createEscaped('null', 0x0000, '0', match.length + 1);
          } else {
            return createEscaped('octal', parseInt(match, 8), match, 1);
          }
        } else if (res = matchReg(/^[dDsSwW]/)) {
          return createCharacterClassEscape(res[0]);
        }
        return false;
      }
      function parseCharacterEscape() {
        var res;
        if (res = matchReg(/^[fnrtv]/)) {
          var codePoint = 0;
          switch (res[0]) {
            case 't':
              codePoint = 0x009;
              break;
            case 'n':
              codePoint = 0x00A;
              break;
            case 'v':
              codePoint = 0x00B;
              break;
            case 'f':
              codePoint = 0x00C;
              break;
            case 'r':
              codePoint = 0x00D;
              break;
          }
          return createEscaped('singleEscape', codePoint, '\\' + res[0]);
        } else if (res = matchReg(/^c([a-zA-Z])/)) {
          return createEscaped('controlLetter', res[1].charCodeAt(0) % 32, res[1], 2);
        } else if (res = matchReg(/^x([0-9a-fA-F]{2})/)) {
          return createEscaped('hexadecimalEscape', parseInt(res[1], 16), res[1], 2);
        } else if (res = matchReg(/^u([0-9a-fA-F]{4})/)) {
          return parseUnicodeSurrogatePairEscape(createEscaped('unicodeEscape', parseInt(res[1], 16), res[1], 2));
        } else if (hasUnicodeFlag && (res = matchReg(/^u\{([0-9a-fA-F]+)\}/))) {
          return createEscaped('unicodeCodePointEscape', parseInt(res[1], 16), res[1], 4);
        } else {
          return parseIdentityEscape();
        }
      }
      function isIdentifierPart(ch) {
        var NonAsciiIdentifierPart = new RegExp('[\xAA\xB5\xBA\xC0-\xD6\xD8-\xF6\xF8-\u02C1\u02C6-\u02D1\u02E0-\u02E4\u02EC\u02EE\u0300-\u0374\u0376\u0377\u037A-\u037D\u037F\u0386\u0388-\u038A\u038C\u038E-\u03A1\u03A3-\u03F5\u03F7-\u0481\u0483-\u0487\u048A-\u052F\u0531-\u0556\u0559\u0561-\u0587\u0591-\u05BD\u05BF\u05C1\u05C2\u05C4\u05C5\u05C7\u05D0-\u05EA\u05F0-\u05F2\u0610-\u061A\u0620-\u0669\u066E-\u06D3\u06D5-\u06DC\u06DF-\u06E8\u06EA-\u06FC\u06FF\u0710-\u074A\u074D-\u07B1\u07C0-\u07F5\u07FA\u0800-\u082D\u0840-\u085B\u08A0-\u08B2\u08E4-\u0963\u0966-\u096F\u0971-\u0983\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2\u09B6-\u09B9\u09BC-\u09C4\u09C7\u09C8\u09CB-\u09CE\u09D7\u09DC\u09DD\u09DF-\u09E3\u09E6-\u09F1\u0A01-\u0A03\u0A05-\u0A0A\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39\u0A3C\u0A3E-\u0A42\u0A47\u0A48\u0A4B-\u0A4D\u0A51\u0A59-\u0A5C\u0A5E\u0A66-\u0A75\u0A81-\u0A83\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABC-\u0AC5\u0AC7-\u0AC9\u0ACB-\u0ACD\u0AD0\u0AE0-\u0AE3\u0AE6-\u0AEF\u0B01-\u0B03\u0B05-\u0B0C\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3C-\u0B44\u0B47\u0B48\u0B4B-\u0B4D\u0B56\u0B57\u0B5C\u0B5D\u0B5F-\u0B63\u0B66-\u0B6F\u0B71\u0B82\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BBE-\u0BC2\u0BC6-\u0BC8\u0BCA-\u0BCD\u0BD0\u0BD7\u0BE6-\u0BEF\u0C00-\u0C03\u0C05-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C39\u0C3D-\u0C44\u0C46-\u0C48\u0C4A-\u0C4D\u0C55\u0C56\u0C58\u0C59\u0C60-\u0C63\u0C66-\u0C6F\u0C81-\u0C83\u0C85-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3\u0CB5-\u0CB9\u0CBC-\u0CC4\u0CC6-\u0CC8\u0CCA-\u0CCD\u0CD5\u0CD6\u0CDE\u0CE0-\u0CE3\u0CE6-\u0CEF\u0CF1\u0CF2\u0D01-\u0D03\u0D05-\u0D0C\u0D0E-\u0D10\u0D12-\u0D3A\u0D3D-\u0D44\u0D46-\u0D48\u0D4A-\u0D4E\u0D57\u0D60-\u0D63\u0D66-\u0D6F\u0D7A-\u0D7F\u0D82\u0D83\u0D85-\u0D96\u0D9A-\u0DB1\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0DCA\u0DCF-\u0DD4\u0DD6\u0DD8-\u0DDF\u0DE6-\u0DEF\u0DF2\u0DF3\u0E01-\u0E3A\u0E40-\u0E4E\u0E50-\u0E59\u0E81\u0E82\u0E84\u0E87\u0E88\u0E8A\u0E8D\u0E94-\u0E97\u0E99-\u0E9F\u0EA1-\u0EA3\u0EA5\u0EA7\u0EAA\u0EAB\u0EAD-\u0EB9\u0EBB-\u0EBD\u0EC0-\u0EC4\u0EC6\u0EC8-\u0ECD\u0ED0-\u0ED9\u0EDC-\u0EDF\u0F00\u0F18\u0F19\u0F20-\u0F29\u0F35\u0F37\u0F39\u0F3E-\u0F47\u0F49-\u0F6C\u0F71-\u0F84\u0F86-\u0F97\u0F99-\u0FBC\u0FC6\u1000-\u1049\u1050-\u109D\u10A0-\u10C5\u10C7\u10CD\u10D0-\u10FA\u10FC-\u1248\u124A-\u124D\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310\u1312-\u1315\u1318-\u135A\u135D-\u135F\u1380-\u138F\u13A0-\u13F4\u1401-\u166C\u166F-\u167F\u1681-\u169A\u16A0-\u16EA\u16EE-\u16F8\u1700-\u170C\u170E-\u1714\u1720-\u1734\u1740-\u1753\u1760-\u176C\u176E-\u1770\u1772\u1773\u1780-\u17D3\u17D7\u17DC\u17DD\u17E0-\u17E9\u180B-\u180D\u1810-\u1819\u1820-\u1877\u1880-\u18AA\u18B0-\u18F5\u1900-\u191E\u1920-\u192B\u1930-\u193B\u1946-\u196D\u1970-\u1974\u1980-\u19AB\u19B0-\u19C9\u19D0-\u19D9\u1A00-\u1A1B\u1A20-\u1A5E\u1A60-\u1A7C\u1A7F-\u1A89\u1A90-\u1A99\u1AA7\u1AB0-\u1ABD\u1B00-\u1B4B\u1B50-\u1B59\u1B6B-\u1B73\u1B80-\u1BF3\u1C00-\u1C37\u1C40-\u1C49\u1C4D-\u1C7D\u1CD0-\u1CD2\u1CD4-\u1CF6\u1CF8\u1CF9\u1D00-\u1DF5\u1DFC-\u1F15\u1F18-\u1F1D\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59\u1F5B\u1F5D\u1F5F-\u1F7D\u1F80-\u1FB4\u1FB6-\u1FBC\u1FBE\u1FC2-\u1FC4\u1FC6-\u1FCC\u1FD0-\u1FD3\u1FD6-\u1FDB\u1FE0-\u1FEC\u1FF2-\u1FF4\u1FF6-\u1FFC\u200C\u200D\u203F\u2040\u2054\u2071\u207F\u2090-\u209C\u20D0-\u20DC\u20E1\u20E5-\u20F0\u2102\u2107\u210A-\u2113\u2115\u2119-\u211D\u2124\u2126\u2128\u212A-\u212D\u212F-\u2139\u213C-\u213F\u2145-\u2149\u214E\u2160-\u2188\u2C00-\u2C2E\u2C30-\u2C5E\u2C60-\u2CE4\u2CEB-\u2CF3\u2D00-\u2D25\u2D27\u2D2D\u2D30-\u2D67\u2D6F\u2D7F-\u2D96\u2DA0-\u2DA6\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE\u2DD0-\u2DD6\u2DD8-\u2DDE\u2DE0-\u2DFF\u2E2F\u3005-\u3007\u3021-\u302F\u3031-\u3035\u3038-\u303C\u3041-\u3096\u3099\u309A\u309D-\u309F\u30A1-\u30FA\u30FC-\u30FF\u3105-\u312D\u3131-\u318E\u31A0-\u31BA\u31F0-\u31FF\u3400-\u4DB5\u4E00-\u9FCC\uA000-\uA48C\uA4D0-\uA4FD\uA500-\uA60C\uA610-\uA62B\uA640-\uA66F\uA674-\uA67D\uA67F-\uA69D\uA69F-\uA6F1\uA717-\uA71F\uA722-\uA788\uA78B-\uA78E\uA790-\uA7AD\uA7B0\uA7B1\uA7F7-\uA827\uA840-\uA873\uA880-\uA8C4\uA8D0-\uA8D9\uA8E0-\uA8F7\uA8FB\uA900-\uA92D\uA930-\uA953\uA960-\uA97C\uA980-\uA9C0\uA9CF-\uA9D9\uA9E0-\uA9FE\uAA00-\uAA36\uAA40-\uAA4D\uAA50-\uAA59\uAA60-\uAA76\uAA7A-\uAAC2\uAADB-\uAADD\uAAE0-\uAAEF\uAAF2-\uAAF6\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E\uAB30-\uAB5A\uAB5C-\uAB5F\uAB64\uAB65\uABC0-\uABEA\uABEC\uABED\uABF0-\uABF9\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D\uFA70-\uFAD9\uFB00-\uFB06\uFB13-\uFB17\uFB1D-\uFB28\uFB2A-\uFB36\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBB1\uFBD3-\uFD3D\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFB\uFE00-\uFE0F\uFE20-\uFE2D\uFE33\uFE34\uFE4D-\uFE4F\uFE70-\uFE74\uFE76-\uFEFC\uFF10-\uFF19\uFF21-\uFF3A\uFF3F\uFF41-\uFF5A\uFF66-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF\uFFD2-\uFFD7\uFFDA-\uFFDC]');
        return (ch === 36) || (ch === 95) || (ch >= 65 && ch <= 90) || (ch >= 97 && ch <= 122) || (ch >= 48 && ch <= 57) || (ch === 92) || ((ch >= 0x80) && NonAsciiIdentifierPart.test(String.fromCharCode(ch)));
      }
      function parseIdentityEscape() {
        var ZWJ = '\u200C';
        var ZWNJ = '\u200D';
        var tmp;
        if (!isIdentifierPart(lookahead())) {
          tmp = incr();
          return createEscaped('identifier', tmp.charCodeAt(0), tmp, 1);
        }
        if (match(ZWJ)) {
          return createEscaped('identifier', 0x200C, ZWJ);
        } else if (match(ZWNJ)) {
          return createEscaped('identifier', 0x200D, ZWNJ);
        }
        return null;
      }
      function parseCharacterClass() {
        var res,
            from = pos;
        if (res = matchReg(/^\[\^/)) {
          res = parseClassRanges();
          skip(']');
          return createCharacterClass(res, true, from, pos);
        } else if (match('[')) {
          res = parseClassRanges();
          skip(']');
          return createCharacterClass(res, false, from, pos);
        }
        return null;
      }
      function parseClassRanges() {
        var res;
        if (current(']')) {
          return [];
        } else {
          res = parseNonemptyClassRanges();
          if (!res) {
            bail('nonEmptyClassRanges');
          }
          return res;
        }
      }
      function parseHelperClassRanges(atom) {
        var from,
            to,
            res;
        if (current('-') && !next(']')) {
          skip('-');
          res = parseClassAtom();
          if (!res) {
            bail('classAtom');
          }
          to = pos;
          var classRanges = parseClassRanges();
          if (!classRanges) {
            bail('classRanges');
          }
          from = atom.range[0];
          if (classRanges.type === 'empty') {
            return [createClassRange(atom, res, from, to)];
          }
          return [createClassRange(atom, res, from, to)].concat(classRanges);
        }
        res = parseNonemptyClassRangesNoDash();
        if (!res) {
          bail('nonEmptyClassRangesNoDash');
        }
        return [atom].concat(res);
      }
      function parseNonemptyClassRanges() {
        var atom = parseClassAtom();
        if (!atom) {
          bail('classAtom');
        }
        if (current(']')) {
          return [atom];
        }
        return parseHelperClassRanges(atom);
      }
      function parseNonemptyClassRangesNoDash() {
        var res = parseClassAtom();
        if (!res) {
          bail('classAtom');
        }
        if (current(']')) {
          return res;
        }
        return parseHelperClassRanges(res);
      }
      function parseClassAtom() {
        if (match('-')) {
          return createCharacter('-');
        } else {
          return parseClassAtomNoDash();
        }
      }
      function parseClassAtomNoDash() {
        var res;
        if (res = matchReg(/^[^\\\]-]/)) {
          return createCharacter(res[0]);
        } else if (match('\\')) {
          res = parseClassEscape();
          if (!res) {
            bail('classEscape');
          }
          return parseUnicodeSurrogatePairEscape(res);
        }
      }
      function bail(message, details, from, to) {
        from = from == null ? pos : from;
        to = to == null ? from : to;
        var contextStart = Math.max(0, from - 10);
        var contextEnd = Math.min(to + 10, str.length);
        var context = '    ' + str.substring(contextStart, contextEnd);
        var pointer = '    ' + new Array(from - contextStart + 1).join(' ') + '^';
        throw SyntaxError(message + ' at position ' + from + (details ? ': ' + details : '') + '\n' + context + '\n' + pointer);
      }
      var backrefDenied = [];
      var closedCaptureCounter = 0;
      var firstIteration = true;
      var hasUnicodeFlag = (flags || "").indexOf("u") !== -1;
      var pos = 0;
      str = String(str);
      if (str === '') {
        str = '(?:)';
      }
      var result = parseDisjunction();
      if (result.range[1] !== str.length) {
        bail('Could not parse entire input - got stuck', '', result.range[1]);
      }
      for (var i = 0; i < backrefDenied.length; i++) {
        if (backrefDenied[i] <= closedCaptureCounter) {
          pos = 0;
          firstIteration = false;
          return parseDisjunction();
        }
      }
      return result;
    }
    var regjsparser = {parse: parse};
    if (typeof module !== 'undefined' && module.exports) {
      module.exports = regjsparser;
    } else {
      window.regjsparser = regjsparser;
    }
  }());
  return module.exports;
});

$__System.registerDynamic("e0", [], false, function() {
  return {
    "75": 8490,
    "83": 383,
    "107": 8490,
    "115": 383,
    "181": 924,
    "197": 8491,
    "383": 83,
    "452": 453,
    "453": 452,
    "455": 456,
    "456": 455,
    "458": 459,
    "459": 458,
    "497": 498,
    "498": 497,
    "837": 8126,
    "914": 976,
    "917": 1013,
    "920": 1012,
    "921": 8126,
    "922": 1008,
    "924": 181,
    "928": 982,
    "929": 1009,
    "931": 962,
    "934": 981,
    "937": 8486,
    "962": 931,
    "976": 914,
    "977": 1012,
    "981": 934,
    "982": 928,
    "1008": 922,
    "1009": 929,
    "1012": [
      920,
      977
    ],
    "1013": 917,
    "7776": 7835,
    "7835": 7776,
    "8126": [
      837,
      921
    ],
    "8486": 937,
    "8490": 75,
    "8491": 197,
    "66560": 66600,
    "66561": 66601,
    "66562": 66602,
    "66563": 66603,
    "66564": 66604,
    "66565": 66605,
    "66566": 66606,
    "66567": 66607,
    "66568": 66608,
    "66569": 66609,
    "66570": 66610,
    "66571": 66611,
    "66572": 66612,
    "66573": 66613,
    "66574": 66614,
    "66575": 66615,
    "66576": 66616,
    "66577": 66617,
    "66578": 66618,
    "66579": 66619,
    "66580": 66620,
    "66581": 66621,
    "66582": 66622,
    "66583": 66623,
    "66584": 66624,
    "66585": 66625,
    "66586": 66626,
    "66587": 66627,
    "66588": 66628,
    "66589": 66629,
    "66590": 66630,
    "66591": 66631,
    "66592": 66632,
    "66593": 66633,
    "66594": 66634,
    "66595": 66635,
    "66596": 66636,
    "66597": 66637,
    "66598": 66638,
    "66599": 66639,
    "66600": 66560,
    "66601": 66561,
    "66602": 66562,
    "66603": 66563,
    "66604": 66564,
    "66605": 66565,
    "66606": 66566,
    "66607": 66567,
    "66608": 66568,
    "66609": 66569,
    "66610": 66570,
    "66611": 66571,
    "66612": 66572,
    "66613": 66573,
    "66614": 66574,
    "66615": 66575,
    "66616": 66576,
    "66617": 66577,
    "66618": 66578,
    "66619": 66579,
    "66620": 66580,
    "66621": 66581,
    "66622": 66582,
    "66623": 66583,
    "66624": 66584,
    "66625": 66585,
    "66626": 66586,
    "66627": 66587,
    "66628": 66588,
    "66629": 66589,
    "66630": 66590,
    "66631": 66591,
    "66632": 66592,
    "66633": 66593,
    "66634": 66594,
    "66635": 66595,
    "66636": 66596,
    "66637": 66597,
    "66638": 66598,
    "66639": 66599,
    "68736": 68800,
    "68737": 68801,
    "68738": 68802,
    "68739": 68803,
    "68740": 68804,
    "68741": 68805,
    "68742": 68806,
    "68743": 68807,
    "68744": 68808,
    "68745": 68809,
    "68746": 68810,
    "68747": 68811,
    "68748": 68812,
    "68749": 68813,
    "68750": 68814,
    "68751": 68815,
    "68752": 68816,
    "68753": 68817,
    "68754": 68818,
    "68755": 68819,
    "68756": 68820,
    "68757": 68821,
    "68758": 68822,
    "68759": 68823,
    "68760": 68824,
    "68761": 68825,
    "68762": 68826,
    "68763": 68827,
    "68764": 68828,
    "68765": 68829,
    "68766": 68830,
    "68767": 68831,
    "68768": 68832,
    "68769": 68833,
    "68770": 68834,
    "68771": 68835,
    "68772": 68836,
    "68773": 68837,
    "68774": 68838,
    "68775": 68839,
    "68776": 68840,
    "68777": 68841,
    "68778": 68842,
    "68779": 68843,
    "68780": 68844,
    "68781": 68845,
    "68782": 68846,
    "68783": 68847,
    "68784": 68848,
    "68785": 68849,
    "68786": 68850,
    "68800": 68736,
    "68801": 68737,
    "68802": 68738,
    "68803": 68739,
    "68804": 68740,
    "68805": 68741,
    "68806": 68742,
    "68807": 68743,
    "68808": 68744,
    "68809": 68745,
    "68810": 68746,
    "68811": 68747,
    "68812": 68748,
    "68813": 68749,
    "68814": 68750,
    "68815": 68751,
    "68816": 68752,
    "68817": 68753,
    "68818": 68754,
    "68819": 68755,
    "68820": 68756,
    "68821": 68757,
    "68822": 68758,
    "68823": 68759,
    "68824": 68760,
    "68825": 68761,
    "68826": 68762,
    "68827": 68763,
    "68828": 68764,
    "68829": 68765,
    "68830": 68766,
    "68831": 68767,
    "68832": 68768,
    "68833": 68769,
    "68834": 68770,
    "68835": 68771,
    "68836": 68772,
    "68837": 68773,
    "68838": 68774,
    "68839": 68775,
    "68840": 68776,
    "68841": 68777,
    "68842": 68778,
    "68843": 68779,
    "68844": 68780,
    "68845": 68781,
    "68846": 68782,
    "68847": 68783,
    "68848": 68784,
    "68849": 68785,
    "68850": 68786,
    "71840": 71872,
    "71841": 71873,
    "71842": 71874,
    "71843": 71875,
    "71844": 71876,
    "71845": 71877,
    "71846": 71878,
    "71847": 71879,
    "71848": 71880,
    "71849": 71881,
    "71850": 71882,
    "71851": 71883,
    "71852": 71884,
    "71853": 71885,
    "71854": 71886,
    "71855": 71887,
    "71856": 71888,
    "71857": 71889,
    "71858": 71890,
    "71859": 71891,
    "71860": 71892,
    "71861": 71893,
    "71862": 71894,
    "71863": 71895,
    "71864": 71896,
    "71865": 71897,
    "71866": 71898,
    "71867": 71899,
    "71868": 71900,
    "71869": 71901,
    "71870": 71902,
    "71871": 71903,
    "71872": 71840,
    "71873": 71841,
    "71874": 71842,
    "71875": 71843,
    "71876": 71844,
    "71877": 71845,
    "71878": 71846,
    "71879": 71847,
    "71880": 71848,
    "71881": 71849,
    "71882": 71850,
    "71883": 71851,
    "71884": 71852,
    "71885": 71853,
    "71886": 71854,
    "71887": 71855,
    "71888": 71856,
    "71889": 71857,
    "71890": 71858,
    "71891": 71859,
    "71892": 71860,
    "71893": 71861,
    "71894": 71862,
    "71895": 71863,
    "71896": 71864,
    "71897": 71865,
    "71898": 71866,
    "71899": 71867,
    "71900": 71868,
    "71901": 71869,
    "71902": 71870,
    "71903": 71871
  };
});

$__System.registerDynamic("e1", ["3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  ;
  (function(root) {
    var freeExports = typeof exports == 'object' && exports;
    var freeModule = typeof module == 'object' && module && module.exports == freeExports && module;
    var freeGlobal = typeof global == 'object' && global;
    if (freeGlobal.global === freeGlobal || freeGlobal.window === freeGlobal) {
      root = freeGlobal;
    }
    var ERRORS = {
      'rangeOrder': 'A range\u2019s `stop` value must be greater than or equal ' + 'to the `start` value.',
      'codePointRange': 'Invalid code point value. Code points range from ' + 'U+000000 to U+10FFFF.'
    };
    var HIGH_SURROGATE_MIN = 0xD800;
    var HIGH_SURROGATE_MAX = 0xDBFF;
    var LOW_SURROGATE_MIN = 0xDC00;
    var LOW_SURROGATE_MAX = 0xDFFF;
    var regexNull = /\\x00([^0123456789]|$)/g;
    var object = {};
    var hasOwnProperty = object.hasOwnProperty;
    var extend = function(destination, source) {
      var key;
      for (key in source) {
        if (hasOwnProperty.call(source, key)) {
          destination[key] = source[key];
        }
      }
      return destination;
    };
    var forEach = function(array, callback) {
      var index = -1;
      var length = array.length;
      while (++index < length) {
        callback(array[index], index);
      }
    };
    var toString = object.toString;
    var isArray = function(value) {
      return toString.call(value) == '[object Array]';
    };
    var isNumber = function(value) {
      return typeof value == 'number' || toString.call(value) == '[object Number]';
    };
    var zeroes = '0000';
    var pad = function(number, totalCharacters) {
      var string = String(number);
      return string.length < totalCharacters ? (zeroes + string).slice(-totalCharacters) : string;
    };
    var hex = function(number) {
      return Number(number).toString(16).toUpperCase();
    };
    var slice = [].slice;
    var dataFromCodePoints = function(codePoints) {
      var index = -1;
      var length = codePoints.length;
      var max = length - 1;
      var result = [];
      var isStart = true;
      var tmp;
      var previous = 0;
      while (++index < length) {
        tmp = codePoints[index];
        if (isStart) {
          result.push(tmp);
          previous = tmp;
          isStart = false;
        } else {
          if (tmp == previous + 1) {
            if (index != max) {
              previous = tmp;
              continue;
            } else {
              isStart = true;
              result.push(tmp + 1);
            }
          } else {
            result.push(previous + 1, tmp);
            previous = tmp;
          }
        }
      }
      if (!isStart) {
        result.push(tmp + 1);
      }
      return result;
    };
    var dataRemove = function(data, codePoint) {
      var index = 0;
      var start;
      var end;
      var length = data.length;
      while (index < length) {
        start = data[index];
        end = data[index + 1];
        if (codePoint >= start && codePoint < end) {
          if (codePoint == start) {
            if (end == start + 1) {
              data.splice(index, 2);
              return data;
            } else {
              data[index] = codePoint + 1;
              return data;
            }
          } else if (codePoint == end - 1) {
            data[index + 1] = codePoint;
            return data;
          } else {
            data.splice(index, 2, start, codePoint, codePoint + 1, end);
            return data;
          }
        }
        index += 2;
      }
      return data;
    };
    var dataRemoveRange = function(data, rangeStart, rangeEnd) {
      if (rangeEnd < rangeStart) {
        throw Error(ERRORS.rangeOrder);
      }
      var index = 0;
      var start;
      var end;
      while (index < data.length) {
        start = data[index];
        end = data[index + 1] - 1;
        if (start > rangeEnd) {
          return data;
        }
        if (rangeStart <= start && rangeEnd >= end) {
          data.splice(index, 2);
          continue;
        }
        if (rangeStart >= start && rangeEnd < end) {
          if (rangeStart == start) {
            data[index] = rangeEnd + 1;
            data[index + 1] = end + 1;
            return data;
          }
          data.splice(index, 2, start, rangeStart, rangeEnd + 1, end + 1);
          return data;
        }
        if (rangeStart >= start && rangeStart <= end) {
          data[index + 1] = rangeStart;
        } else if (rangeEnd >= start && rangeEnd <= end) {
          data[index] = rangeEnd + 1;
          return data;
        }
        index += 2;
      }
      return data;
    };
    var dataAdd = function(data, codePoint) {
      var index = 0;
      var start;
      var end;
      var lastIndex = null;
      var length = data.length;
      if (codePoint < 0x0 || codePoint > 0x10FFFF) {
        throw RangeError(ERRORS.codePointRange);
      }
      while (index < length) {
        start = data[index];
        end = data[index + 1];
        if (codePoint >= start && codePoint < end) {
          return data;
        }
        if (codePoint == start - 1) {
          data[index] = codePoint;
          return data;
        }
        if (start > codePoint) {
          data.splice(lastIndex != null ? lastIndex + 2 : 0, 0, codePoint, codePoint + 1);
          return data;
        }
        if (codePoint == end) {
          if (codePoint + 1 == data[index + 2]) {
            data.splice(index, 4, start, data[index + 3]);
            return data;
          }
          data[index + 1] = codePoint + 1;
          return data;
        }
        lastIndex = index;
        index += 2;
      }
      data.push(codePoint, codePoint + 1);
      return data;
    };
    var dataAddData = function(dataA, dataB) {
      var index = 0;
      var start;
      var end;
      var data = dataA.slice();
      var length = dataB.length;
      while (index < length) {
        start = dataB[index];
        end = dataB[index + 1] - 1;
        if (start == end) {
          data = dataAdd(data, start);
        } else {
          data = dataAddRange(data, start, end);
        }
        index += 2;
      }
      return data;
    };
    var dataRemoveData = function(dataA, dataB) {
      var index = 0;
      var start;
      var end;
      var data = dataA.slice();
      var length = dataB.length;
      while (index < length) {
        start = dataB[index];
        end = dataB[index + 1] - 1;
        if (start == end) {
          data = dataRemove(data, start);
        } else {
          data = dataRemoveRange(data, start, end);
        }
        index += 2;
      }
      return data;
    };
    var dataAddRange = function(data, rangeStart, rangeEnd) {
      if (rangeEnd < rangeStart) {
        throw Error(ERRORS.rangeOrder);
      }
      if (rangeStart < 0x0 || rangeStart > 0x10FFFF || rangeEnd < 0x0 || rangeEnd > 0x10FFFF) {
        throw RangeError(ERRORS.codePointRange);
      }
      var index = 0;
      var start;
      var end;
      var added = false;
      var length = data.length;
      while (index < length) {
        start = data[index];
        end = data[index + 1];
        if (added) {
          if (start == rangeEnd + 1) {
            data.splice(index - 1, 2);
            return data;
          }
          if (start > rangeEnd) {
            return data;
          }
          if (start >= rangeStart && start <= rangeEnd) {
            if (end > rangeStart && end - 1 <= rangeEnd) {
              data.splice(index, 2);
              index -= 2;
            } else {
              data.splice(index - 1, 2);
              index -= 2;
            }
          }
        } else if (start == rangeEnd + 1) {
          data[index] = rangeStart;
          return data;
        } else if (start > rangeEnd) {
          data.splice(index, 0, rangeStart, rangeEnd + 1);
          return data;
        } else if (rangeStart >= start && rangeStart < end && rangeEnd + 1 <= end) {
          return data;
        } else if ((rangeStart >= start && rangeStart < end) || end == rangeStart) {
          data[index + 1] = rangeEnd + 1;
          added = true;
        } else if (rangeStart <= start && rangeEnd + 1 >= end) {
          data[index] = rangeStart;
          data[index + 1] = rangeEnd + 1;
          added = true;
        }
        index += 2;
      }
      if (!added) {
        data.push(rangeStart, rangeEnd + 1);
      }
      return data;
    };
    var dataContains = function(data, codePoint) {
      var index = 0;
      var length = data.length;
      var start = data[index];
      var end = data[length - 1];
      if (length >= 2) {
        if (codePoint < start || codePoint > end) {
          return false;
        }
      }
      while (index < length) {
        start = data[index];
        end = data[index + 1];
        if (codePoint >= start && codePoint < end) {
          return true;
        }
        index += 2;
      }
      return false;
    };
    var dataIntersection = function(data, codePoints) {
      var index = 0;
      var length = codePoints.length;
      var codePoint;
      var result = [];
      while (index < length) {
        codePoint = codePoints[index];
        if (dataContains(data, codePoint)) {
          result.push(codePoint);
        }
        ++index;
      }
      return dataFromCodePoints(result);
    };
    var dataIsEmpty = function(data) {
      return !data.length;
    };
    var dataIsSingleton = function(data) {
      return data.length == 2 && data[0] + 1 == data[1];
    };
    var dataToArray = function(data) {
      var index = 0;
      var start;
      var end;
      var result = [];
      var length = data.length;
      while (index < length) {
        start = data[index];
        end = data[index + 1];
        while (start < end) {
          result.push(start);
          ++start;
        }
        index += 2;
      }
      return result;
    };
    var floor = Math.floor;
    var highSurrogate = function(codePoint) {
      return parseInt(floor((codePoint - 0x10000) / 0x400) + HIGH_SURROGATE_MIN, 10);
    };
    var lowSurrogate = function(codePoint) {
      return parseInt((codePoint - 0x10000) % 0x400 + LOW_SURROGATE_MIN, 10);
    };
    var stringFromCharCode = String.fromCharCode;
    var codePointToString = function(codePoint) {
      var string;
      if (codePoint == 0x09) {
        string = '\\t';
      } else if (codePoint == 0x0A) {
        string = '\\n';
      } else if (codePoint == 0x0C) {
        string = '\\f';
      } else if (codePoint == 0x0D) {
        string = '\\r';
      } else if (codePoint == 0x5C) {
        string = '\\\\';
      } else if (codePoint == 0x24 || (codePoint >= 0x28 && codePoint <= 0x2B) || codePoint == 0x2D || codePoint == 0x2E || codePoint == 0x3F || (codePoint >= 0x5B && codePoint <= 0x5E) || (codePoint >= 0x7B && codePoint <= 0x7D)) {
        string = '\\' + stringFromCharCode(codePoint);
      } else if (codePoint >= 0x20 && codePoint <= 0x7E) {
        string = stringFromCharCode(codePoint);
      } else if (codePoint <= 0xFF) {
        string = '\\x' + pad(hex(codePoint), 2);
      } else {
        string = '\\u' + pad(hex(codePoint), 4);
      }
      return string;
    };
    var symbolToCodePoint = function(symbol) {
      var length = symbol.length;
      var first = symbol.charCodeAt(0);
      var second;
      if (first >= HIGH_SURROGATE_MIN && first <= HIGH_SURROGATE_MAX && length > 1) {
        second = symbol.charCodeAt(1);
        return (first - HIGH_SURROGATE_MIN) * 0x400 + second - LOW_SURROGATE_MIN + 0x10000;
      }
      return first;
    };
    var createBMPCharacterClasses = function(data) {
      var result = '';
      var index = 0;
      var start;
      var end;
      var length = data.length;
      if (dataIsSingleton(data)) {
        return codePointToString(data[0]);
      }
      while (index < length) {
        start = data[index];
        end = data[index + 1] - 1;
        if (start == end) {
          result += codePointToString(start);
        } else if (start + 1 == end) {
          result += codePointToString(start) + codePointToString(end);
        } else {
          result += codePointToString(start) + '-' + codePointToString(end);
        }
        index += 2;
      }
      return '[' + result + ']';
    };
    var splitAtBMP = function(data) {
      var loneHighSurrogates = [];
      var loneLowSurrogates = [];
      var bmp = [];
      var astral = [];
      var index = 0;
      var start;
      var end;
      var length = data.length;
      while (index < length) {
        start = data[index];
        end = data[index + 1] - 1;
        if (start < HIGH_SURROGATE_MIN) {
          if (end < HIGH_SURROGATE_MIN) {
            bmp.push(start, end + 1);
          }
          if (end >= HIGH_SURROGATE_MIN && end <= HIGH_SURROGATE_MAX) {
            bmp.push(start, HIGH_SURROGATE_MIN);
            loneHighSurrogates.push(HIGH_SURROGATE_MIN, end + 1);
          }
          if (end >= LOW_SURROGATE_MIN && end <= LOW_SURROGATE_MAX) {
            bmp.push(start, HIGH_SURROGATE_MIN);
            loneHighSurrogates.push(HIGH_SURROGATE_MIN, HIGH_SURROGATE_MAX + 1);
            loneLowSurrogates.push(LOW_SURROGATE_MIN, end + 1);
          }
          if (end > LOW_SURROGATE_MAX) {
            bmp.push(start, HIGH_SURROGATE_MIN);
            loneHighSurrogates.push(HIGH_SURROGATE_MIN, HIGH_SURROGATE_MAX + 1);
            loneLowSurrogates.push(LOW_SURROGATE_MIN, LOW_SURROGATE_MAX + 1);
            if (end <= 0xFFFF) {
              bmp.push(LOW_SURROGATE_MAX + 1, end + 1);
            } else {
              bmp.push(LOW_SURROGATE_MAX + 1, 0xFFFF + 1);
              astral.push(0xFFFF + 1, end + 1);
            }
          }
        } else if (start >= HIGH_SURROGATE_MIN && start <= HIGH_SURROGATE_MAX) {
          if (end >= HIGH_SURROGATE_MIN && end <= HIGH_SURROGATE_MAX) {
            loneHighSurrogates.push(start, end + 1);
          }
          if (end >= LOW_SURROGATE_MIN && end <= LOW_SURROGATE_MAX) {
            loneHighSurrogates.push(start, HIGH_SURROGATE_MAX + 1);
            loneLowSurrogates.push(LOW_SURROGATE_MIN, end + 1);
          }
          if (end > LOW_SURROGATE_MAX) {
            loneHighSurrogates.push(start, HIGH_SURROGATE_MAX + 1);
            loneLowSurrogates.push(LOW_SURROGATE_MIN, LOW_SURROGATE_MAX + 1);
            if (end <= 0xFFFF) {
              bmp.push(LOW_SURROGATE_MAX + 1, end + 1);
            } else {
              bmp.push(LOW_SURROGATE_MAX + 1, 0xFFFF + 1);
              astral.push(0xFFFF + 1, end + 1);
            }
          }
        } else if (start >= LOW_SURROGATE_MIN && start <= LOW_SURROGATE_MAX) {
          if (end >= LOW_SURROGATE_MIN && end <= LOW_SURROGATE_MAX) {
            loneLowSurrogates.push(start, end + 1);
          }
          if (end > LOW_SURROGATE_MAX) {
            loneLowSurrogates.push(start, LOW_SURROGATE_MAX + 1);
            if (end <= 0xFFFF) {
              bmp.push(LOW_SURROGATE_MAX + 1, end + 1);
            } else {
              bmp.push(LOW_SURROGATE_MAX + 1, 0xFFFF + 1);
              astral.push(0xFFFF + 1, end + 1);
            }
          }
        } else if (start > LOW_SURROGATE_MAX && start <= 0xFFFF) {
          if (end <= 0xFFFF) {
            bmp.push(start, end + 1);
          } else {
            bmp.push(start, 0xFFFF + 1);
            astral.push(0xFFFF + 1, end + 1);
          }
        } else {
          astral.push(start, end + 1);
        }
        index += 2;
      }
      return {
        'loneHighSurrogates': loneHighSurrogates,
        'loneLowSurrogates': loneLowSurrogates,
        'bmp': bmp,
        'astral': astral
      };
    };
    var optimizeSurrogateMappings = function(surrogateMappings) {
      var result = [];
      var tmpLow = [];
      var addLow = false;
      var mapping;
      var nextMapping;
      var highSurrogates;
      var lowSurrogates;
      var nextHighSurrogates;
      var nextLowSurrogates;
      var index = -1;
      var length = surrogateMappings.length;
      while (++index < length) {
        mapping = surrogateMappings[index];
        nextMapping = surrogateMappings[index + 1];
        if (!nextMapping) {
          result.push(mapping);
          continue;
        }
        highSurrogates = mapping[0];
        lowSurrogates = mapping[1];
        nextHighSurrogates = nextMapping[0];
        nextLowSurrogates = nextMapping[1];
        tmpLow = lowSurrogates;
        while (nextHighSurrogates && highSurrogates[0] == nextHighSurrogates[0] && highSurrogates[1] == nextHighSurrogates[1]) {
          if (dataIsSingleton(nextLowSurrogates)) {
            tmpLow = dataAdd(tmpLow, nextLowSurrogates[0]);
          } else {
            tmpLow = dataAddRange(tmpLow, nextLowSurrogates[0], nextLowSurrogates[1] - 1);
          }
          ++index;
          mapping = surrogateMappings[index];
          highSurrogates = mapping[0];
          lowSurrogates = mapping[1];
          nextMapping = surrogateMappings[index + 1];
          nextHighSurrogates = nextMapping && nextMapping[0];
          nextLowSurrogates = nextMapping && nextMapping[1];
          addLow = true;
        }
        result.push([highSurrogates, addLow ? tmpLow : lowSurrogates]);
        addLow = false;
      }
      return optimizeByLowSurrogates(result);
    };
    var optimizeByLowSurrogates = function(surrogateMappings) {
      if (surrogateMappings.length == 1) {
        return surrogateMappings;
      }
      var index = -1;
      var innerIndex = -1;
      while (++index < surrogateMappings.length) {
        var mapping = surrogateMappings[index];
        var lowSurrogates = mapping[1];
        var lowSurrogateStart = lowSurrogates[0];
        var lowSurrogateEnd = lowSurrogates[1];
        innerIndex = index;
        while (++innerIndex < surrogateMappings.length) {
          var otherMapping = surrogateMappings[innerIndex];
          var otherLowSurrogates = otherMapping[1];
          var otherLowSurrogateStart = otherLowSurrogates[0];
          var otherLowSurrogateEnd = otherLowSurrogates[1];
          if (lowSurrogateStart == otherLowSurrogateStart && lowSurrogateEnd == otherLowSurrogateEnd) {
            if (dataIsSingleton(otherMapping[0])) {
              mapping[0] = dataAdd(mapping[0], otherMapping[0][0]);
            } else {
              mapping[0] = dataAddRange(mapping[0], otherMapping[0][0], otherMapping[0][1] - 1);
            }
            surrogateMappings.splice(innerIndex, 1);
            --innerIndex;
          }
        }
      }
      return surrogateMappings;
    };
    var surrogateSet = function(data) {
      if (!data.length) {
        return [];
      }
      var index = 0;
      var start;
      var end;
      var startHigh;
      var startLow;
      var prevStartHigh = 0;
      var prevEndHigh = 0;
      var tmpLow = [];
      var endHigh;
      var endLow;
      var surrogateMappings = [];
      var length = data.length;
      var dataHigh = [];
      while (index < length) {
        start = data[index];
        end = data[index + 1] - 1;
        startHigh = highSurrogate(start);
        startLow = lowSurrogate(start);
        endHigh = highSurrogate(end);
        endLow = lowSurrogate(end);
        var startsWithLowestLowSurrogate = startLow == LOW_SURROGATE_MIN;
        var endsWithHighestLowSurrogate = endLow == LOW_SURROGATE_MAX;
        var complete = false;
        if (startHigh == endHigh || startsWithLowestLowSurrogate && endsWithHighestLowSurrogate) {
          surrogateMappings.push([[startHigh, endHigh + 1], [startLow, endLow + 1]]);
          complete = true;
        } else {
          surrogateMappings.push([[startHigh, startHigh + 1], [startLow, LOW_SURROGATE_MAX + 1]]);
        }
        if (!complete && startHigh + 1 < endHigh) {
          if (endsWithHighestLowSurrogate) {
            surrogateMappings.push([[startHigh + 1, endHigh + 1], [LOW_SURROGATE_MIN, endLow + 1]]);
            complete = true;
          } else {
            surrogateMappings.push([[startHigh + 1, endHigh], [LOW_SURROGATE_MIN, LOW_SURROGATE_MAX + 1]]);
          }
        }
        if (!complete) {
          surrogateMappings.push([[endHigh, endHigh + 1], [LOW_SURROGATE_MIN, endLow + 1]]);
        }
        prevStartHigh = startHigh;
        prevEndHigh = endHigh;
        index += 2;
      }
      return optimizeSurrogateMappings(surrogateMappings);
    };
    var createSurrogateCharacterClasses = function(surrogateMappings) {
      var result = [];
      forEach(surrogateMappings, function(surrogateMapping) {
        var highSurrogates = surrogateMapping[0];
        var lowSurrogates = surrogateMapping[1];
        result.push(createBMPCharacterClasses(highSurrogates) + createBMPCharacterClasses(lowSurrogates));
      });
      return result.join('|');
    };
    var createCharacterClassesFromData = function(data, bmpOnly) {
      var result = [];
      var parts = splitAtBMP(data);
      var loneHighSurrogates = parts.loneHighSurrogates;
      var loneLowSurrogates = parts.loneLowSurrogates;
      var bmp = parts.bmp;
      var astral = parts.astral;
      var hasAstral = !dataIsEmpty(parts.astral);
      var hasLoneHighSurrogates = !dataIsEmpty(loneHighSurrogates);
      var hasLoneLowSurrogates = !dataIsEmpty(loneLowSurrogates);
      var surrogateMappings = surrogateSet(astral);
      if (bmpOnly) {
        bmp = dataAddData(bmp, loneHighSurrogates);
        hasLoneHighSurrogates = false;
        bmp = dataAddData(bmp, loneLowSurrogates);
        hasLoneLowSurrogates = false;
      }
      if (!dataIsEmpty(bmp)) {
        result.push(createBMPCharacterClasses(bmp));
      }
      if (surrogateMappings.length) {
        result.push(createSurrogateCharacterClasses(surrogateMappings));
      }
      if (hasLoneHighSurrogates) {
        result.push(createBMPCharacterClasses(loneHighSurrogates) + '(?![\\uDC00-\\uDFFF])');
      }
      if (hasLoneLowSurrogates) {
        result.push('(?:[^\\uD800-\\uDBFF]|^)' + createBMPCharacterClasses(loneLowSurrogates));
      }
      return result.join('|');
    };
    var regenerate = function(value) {
      if (arguments.length > 1) {
        value = slice.call(arguments);
      }
      if (this instanceof regenerate) {
        this.data = [];
        return value ? this.add(value) : this;
      }
      return (new regenerate).add(value);
    };
    regenerate.version = '1.2.0';
    var proto = regenerate.prototype;
    extend(proto, {
      'add': function(value) {
        var $this = this;
        if (value == null) {
          return $this;
        }
        if (value instanceof regenerate) {
          $this.data = dataAddData($this.data, value.data);
          return $this;
        }
        if (arguments.length > 1) {
          value = slice.call(arguments);
        }
        if (isArray(value)) {
          forEach(value, function(item) {
            $this.add(item);
          });
          return $this;
        }
        $this.data = dataAdd($this.data, isNumber(value) ? value : symbolToCodePoint(value));
        return $this;
      },
      'remove': function(value) {
        var $this = this;
        if (value == null) {
          return $this;
        }
        if (value instanceof regenerate) {
          $this.data = dataRemoveData($this.data, value.data);
          return $this;
        }
        if (arguments.length > 1) {
          value = slice.call(arguments);
        }
        if (isArray(value)) {
          forEach(value, function(item) {
            $this.remove(item);
          });
          return $this;
        }
        $this.data = dataRemove($this.data, isNumber(value) ? value : symbolToCodePoint(value));
        return $this;
      },
      'addRange': function(start, end) {
        var $this = this;
        $this.data = dataAddRange($this.data, isNumber(start) ? start : symbolToCodePoint(start), isNumber(end) ? end : symbolToCodePoint(end));
        return $this;
      },
      'removeRange': function(start, end) {
        var $this = this;
        var startCodePoint = isNumber(start) ? start : symbolToCodePoint(start);
        var endCodePoint = isNumber(end) ? end : symbolToCodePoint(end);
        $this.data = dataRemoveRange($this.data, startCodePoint, endCodePoint);
        return $this;
      },
      'intersection': function(argument) {
        var $this = this;
        var array = argument instanceof regenerate ? dataToArray(argument.data) : argument;
        $this.data = dataIntersection($this.data, array);
        return $this;
      },
      'contains': function(codePoint) {
        return dataContains(this.data, isNumber(codePoint) ? codePoint : symbolToCodePoint(codePoint));
      },
      'clone': function() {
        var set = new regenerate;
        set.data = this.data.slice(0);
        return set;
      },
      'toString': function(options) {
        var result = createCharacterClassesFromData(this.data, options ? options.bmpOnly : false);
        return result.replace(regexNull, '\\0$1');
      },
      'toRegExp': function(flags) {
        return RegExp(this.toString(), flags || '');
      },
      'valueOf': function() {
        return dataToArray(this.data);
      }
    });
    proto.toArray = proto.valueOf;
    if (typeof define == 'function' && typeof define.amd == 'object' && define.amd) {
      define(function() {
        return regenerate;
      });
    } else if (freeExports && !freeExports.nodeType) {
      if (freeModule) {
        freeModule.exports = regenerate;
      } else {
        freeExports.regenerate = regenerate;
      }
    } else {
      root.regenerate = regenerate;
    }
  }(this));
  return module.exports;
});

$__System.registerDynamic("e2", ["e1", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var regenerate = $__require('e1');
  exports.REGULAR = {
    'd': regenerate().addRange(0x30, 0x39),
    'D': regenerate().addRange(0x0, 0x2F).addRange(0x3A, 0xFFFF),
    's': regenerate(0x20, 0xA0, 0x1680, 0x180E, 0x202F, 0x205F, 0x3000, 0xFEFF).addRange(0x9, 0xD).addRange(0x2000, 0x200A).addRange(0x2028, 0x2029),
    'S': regenerate().addRange(0x0, 0x8).addRange(0xE, 0x1F).addRange(0x21, 0x9F).addRange(0xA1, 0x167F).addRange(0x1681, 0x180D).addRange(0x180F, 0x1FFF).addRange(0x200B, 0x2027).addRange(0x202A, 0x202E).addRange(0x2030, 0x205E).addRange(0x2060, 0x2FFF).addRange(0x3001, 0xFEFE).addRange(0xFF00, 0xFFFF),
    'w': regenerate(0x5F).addRange(0x30, 0x39).addRange(0x41, 0x5A).addRange(0x61, 0x7A),
    'W': regenerate(0x60).addRange(0x0, 0x2F).addRange(0x3A, 0x40).addRange(0x5B, 0x5E).addRange(0x7B, 0xFFFF)
  };
  exports.UNICODE = {
    'd': regenerate().addRange(0x30, 0x39),
    'D': regenerate().addRange(0x0, 0x2F).addRange(0x3A, 0x10FFFF),
    's': regenerate(0x20, 0xA0, 0x1680, 0x180E, 0x202F, 0x205F, 0x3000, 0xFEFF).addRange(0x9, 0xD).addRange(0x2000, 0x200A).addRange(0x2028, 0x2029),
    'S': regenerate().addRange(0x0, 0x8).addRange(0xE, 0x1F).addRange(0x21, 0x9F).addRange(0xA1, 0x167F).addRange(0x1681, 0x180D).addRange(0x180F, 0x1FFF).addRange(0x200B, 0x2027).addRange(0x202A, 0x202E).addRange(0x2030, 0x205E).addRange(0x2060, 0x2FFF).addRange(0x3001, 0xFEFE).addRange(0xFF00, 0x10FFFF),
    'w': regenerate(0x5F).addRange(0x30, 0x39).addRange(0x41, 0x5A).addRange(0x61, 0x7A),
    'W': regenerate(0x60).addRange(0x0, 0x2F).addRange(0x3A, 0x40).addRange(0x5B, 0x5E).addRange(0x7B, 0x10FFFF)
  };
  exports.UNICODE_IGNORE_CASE = {
    'd': regenerate().addRange(0x30, 0x39),
    'D': regenerate().addRange(0x0, 0x2F).addRange(0x3A, 0x10FFFF),
    's': regenerate(0x20, 0xA0, 0x1680, 0x180E, 0x202F, 0x205F, 0x3000, 0xFEFF).addRange(0x9, 0xD).addRange(0x2000, 0x200A).addRange(0x2028, 0x2029),
    'S': regenerate().addRange(0x0, 0x8).addRange(0xE, 0x1F).addRange(0x21, 0x9F).addRange(0xA1, 0x167F).addRange(0x1681, 0x180D).addRange(0x180F, 0x1FFF).addRange(0x200B, 0x2027).addRange(0x202A, 0x202E).addRange(0x2030, 0x205E).addRange(0x2060, 0x2FFF).addRange(0x3001, 0xFEFE).addRange(0xFF00, 0x10FFFF),
    'w': regenerate(0x5F, 0x17F, 0x212A).addRange(0x30, 0x39).addRange(0x41, 0x5A).addRange(0x61, 0x7A),
    'W': regenerate(0x4B, 0x53, 0x60).addRange(0x0, 0x2F).addRange(0x3A, 0x40).addRange(0x5B, 0x5E).addRange(0x7B, 0x10FFFF)
  };
  return module.exports;
});

$__System.registerDynamic("e3", ["de", "df", "e1", "e0", "e2", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var generate = $__require('de').generate;
  var parse = $__require('df').parse;
  var regenerate = $__require('e1');
  var iuMappings = $__require('e0');
  var ESCAPE_SETS = $__require('e2');
  function getCharacterClassEscapeSet(character) {
    if (unicode) {
      if (ignoreCase) {
        return ESCAPE_SETS.UNICODE_IGNORE_CASE[character];
      }
      return ESCAPE_SETS.UNICODE[character];
    }
    return ESCAPE_SETS.REGULAR[character];
  }
  var object = {};
  var hasOwnProperty = object.hasOwnProperty;
  function has(object, property) {
    return hasOwnProperty.call(object, property);
  }
  var UNICODE_SET = regenerate().addRange(0x0, 0x10FFFF);
  var BMP_SET = regenerate().addRange(0x0, 0xFFFF);
  var DOT_SET_UNICODE = UNICODE_SET.clone().remove(0x000A, 0x000D, 0x2028, 0x2029);
  var DOT_SET = DOT_SET_UNICODE.clone().intersection(BMP_SET);
  regenerate.prototype.iuAddRange = function(min, max) {
    var $this = this;
    do {
      var folded = caseFold(min);
      if (folded) {
        $this.add(folded);
      }
    } while (++min <= max);
    return $this;
  };
  function assign(target, source) {
    for (var key in source) {
      target[key] = source[key];
    }
  }
  function update(item, pattern) {
    if (!pattern) {
      return;
    }
    var tree = parse(pattern, '');
    switch (tree.type) {
      case 'characterClass':
      case 'group':
      case 'value':
        break;
      default:
        tree = wrap(tree, pattern);
    }
    assign(item, tree);
  }
  function wrap(tree, pattern) {
    return {
      'type': 'group',
      'behavior': 'ignore',
      'body': [tree],
      'raw': '(?:' + pattern + ')'
    };
  }
  function caseFold(codePoint) {
    return has(iuMappings, codePoint) ? iuMappings[codePoint] : false;
  }
  var ignoreCase = false;
  var unicode = false;
  function processCharacterClass(characterClassItem) {
    var set = regenerate();
    var body = characterClassItem.body.forEach(function(item) {
      switch (item.type) {
        case 'value':
          set.add(item.codePoint);
          if (ignoreCase && unicode) {
            var folded = caseFold(item.codePoint);
            if (folded) {
              set.add(folded);
            }
          }
          break;
        case 'characterClassRange':
          var min = item.min.codePoint;
          var max = item.max.codePoint;
          set.addRange(min, max);
          if (ignoreCase && unicode) {
            set.iuAddRange(min, max);
          }
          break;
        case 'characterClassEscape':
          set.add(getCharacterClassEscapeSet(item.value));
          break;
        default:
          throw Error('Unknown term type: ' + item.type);
      }
    });
    if (characterClassItem.negative) {
      set = (unicode ? UNICODE_SET : BMP_SET).clone().remove(set);
    }
    update(characterClassItem, set.toString());
    return characterClassItem;
  }
  function processTerm(item) {
    switch (item.type) {
      case 'dot':
        update(item, (unicode ? DOT_SET_UNICODE : DOT_SET).toString());
        break;
      case 'characterClass':
        item = processCharacterClass(item);
        break;
      case 'characterClassEscape':
        update(item, getCharacterClassEscapeSet(item.value).toString());
        break;
      case 'alternative':
      case 'disjunction':
      case 'group':
      case 'quantifier':
        item.body = item.body.map(processTerm);
        break;
      case 'value':
        var codePoint = item.codePoint;
        var set = regenerate(codePoint);
        if (ignoreCase && unicode) {
          var folded = caseFold(codePoint);
          if (folded) {
            set.add(folded);
          }
        }
        update(item, set.toString());
        break;
      case 'anchor':
      case 'empty':
      case 'group':
      case 'reference':
        break;
      default:
        throw Error('Unknown term type: ' + item.type);
    }
    return item;
  }
  ;
  module.exports = function(pattern, flags) {
    var tree = parse(pattern, flags);
    ignoreCase = flags ? flags.indexOf('i') > -1 : false;
    unicode = flags ? flags.indexOf('u') > -1 : false;
    assign(tree, processTerm(tree));
    return generate(tree);
  };
  return module.exports;
});

$__System.registerDynamic("e4", ["e5", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var baseIndexOf = $__require('e5');
  var arrayProto = Array.prototype;
  var splice = arrayProto.splice;
  function pull() {
    var args = arguments,
        array = args[0];
    if (!(array && array.length)) {
      return array;
    }
    var index = 0,
        indexOf = baseIndexOf,
        length = args.length;
    while (++index < length) {
      var fromIndex = 0,
          value = args[index];
      while ((fromIndex = indexOf(array, value, fromIndex)) > -1) {
        splice.call(array, fromIndex, 1);
      }
    }
    return array;
  }
  module.exports = pull;
  return module.exports;
});

$__System.registerDynamic("dd", ["a", "4", "e4", "5", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireDefault = $__require('a')["default"];
  var _interopRequireWildcard = $__require('4')["default"];
  exports.__esModule = true;
  exports.is = is;
  exports.pullFlag = pullFlag;
  var _lodashArrayPull = $__require('e4');
  var _lodashArrayPull2 = _interopRequireDefault(_lodashArrayPull);
  var _babelTypes = $__require('5');
  var t = _interopRequireWildcard(_babelTypes);
  function is(node, flag) {
    return t.isRegExpLiteral(node) && node.flags.indexOf(flag) >= 0;
  }
  function pullFlag(node, flag) {
    var flags = node.flags.split("");
    if (node.flags.indexOf(flag) < 0)
      return;
    _lodashArrayPull2["default"](flags, flag);
    node.flags = flags.join("");
  }
  return module.exports;
});

$__System.registerDynamic("e6", ["a", "4", "e3", "dd", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireDefault = $__require('a')["default"];
  var _interopRequireWildcard = $__require('4')["default"];
  exports.__esModule = true;
  var _regexpuCore = $__require('e3');
  var _regexpuCore2 = _interopRequireDefault(_regexpuCore);
  var _babelHelperRegex = $__require('dd');
  var regex = _interopRequireWildcard(_babelHelperRegex);
  exports["default"] = function() {
    return {visitor: {RegExpLiteral: function RegExpLiteral(_ref) {
          var node = _ref.node;
          if (!regex.is(node, "u"))
            return;
          node.pattern = _regexpuCore2["default"](node.pattern, node.flags);
          regex.pullFlag(node, "u");
        }}};
  };
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("e7", [], true, function($__require, exports, module) {
  "use strict";
  ;
  var define,
      global = this,
      GLOBAL = this;
  exports.__esModule = true;
  exports["default"] = function(_ref) {
    var messages = _ref.messages;
    return {visitor: {Scope: function Scope(_ref2) {
          var scope = _ref2.scope;
          for (var _name in scope.bindings) {
            var binding = scope.bindings[_name];
            if (binding.kind !== "const" && binding.kind !== "module")
              continue;
            var _arr = binding.constantViolations;
            for (var _i = 0; _i < _arr.length; _i++) {
              var violation = _arr[_i];
              throw violation.buildCodeFrameError(messages.get("readOnly", _name));
            }
          }
        }}};
  };
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("e8", ["3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  exports.__esModule = true;
  exports["default"] = function(_ref) {
    var t = _ref.types;
    function getSpreadLiteral(spread, scope, state) {
      if (state.opts.loose && !t.isIdentifier(spread.argument, {name: "arguments"})) {
        return spread.argument;
      } else {
        return scope.toArray(spread.argument, true);
      }
    }
    function hasSpread(nodes) {
      for (var i = 0; i < nodes.length; i++) {
        if (t.isSpreadElement(nodes[i])) {
          return true;
        }
      }
      return false;
    }
    function build(props, scope, state) {
      var nodes = [];
      var _props = [];
      function push() {
        if (!_props.length)
          return;
        nodes.push(t.arrayExpression(_props));
        _props = [];
      }
      for (var _i = 0; _i < props.length; _i++) {
        var prop = props[_i];
        if (t.isSpreadElement(prop)) {
          push();
          nodes.push(getSpreadLiteral(prop, scope, state));
        } else {
          _props.push(prop);
        }
      }
      push();
      return nodes;
    }
    return {visitor: {
        ArrayExpression: function ArrayExpression(path, state) {
          var node = path.node;
          var scope = path.scope;
          var elements = node.elements;
          if (!hasSpread(elements))
            return;
          var nodes = build(elements, scope, state);
          var first = nodes.shift();
          if (!t.isArrayExpression(first)) {
            nodes.unshift(first);
            first = t.arrayExpression([]);
          }
          path.replaceWith(t.callExpression(t.memberExpression(first, t.identifier("concat")), nodes));
        },
        CallExpression: function CallExpression(path, state) {
          var node = path.node;
          var scope = path.scope;
          var args = node.arguments;
          if (!hasSpread(args))
            return;
          var calleePath = path.get("callee");
          if (calleePath.isSuper())
            return;
          var contextLiteral = t.identifier("undefined");
          node.arguments = [];
          var nodes = undefined;
          if (args.length === 1 && args[0].argument.name === "arguments") {
            nodes = [args[0].argument];
          } else {
            nodes = build(args, scope, state);
          }
          var first = nodes.shift();
          if (nodes.length) {
            node.arguments.push(t.callExpression(t.memberExpression(first, t.identifier("concat")), nodes));
          } else {
            node.arguments.push(first);
          }
          var callee = node.callee;
          if (calleePath.isMemberExpression()) {
            var temp = scope.maybeGenerateMemoised(callee.object);
            if (temp) {
              callee.object = t.assignmentExpression("=", temp, callee.object);
              contextLiteral = temp;
            } else {
              contextLiteral = callee.object;
            }
            t.appendToMemberExpression(callee, t.identifier("apply"));
          } else {
            node.callee = t.memberExpression(node.callee, t.identifier("apply"));
          }
          if (t.isSuper(contextLiteral)) {
            contextLiteral = t.thisExpression();
          }
          node.arguments.unshift(contextLiteral);
        },
        NewExpression: function NewExpression(path, state) {
          var node = path.node;
          var scope = path.scope;
          var args = node.arguments;
          if (!hasSpread(args))
            return;
          var nodes = build(args, scope, state);
          var context = t.arrayExpression([t.nullLiteral()]);
          args = t.callExpression(t.memberExpression(context, t.identifier("concat")), nodes);
          path.replaceWith(t.newExpression(t.callExpression(t.memberExpression(t.memberExpression(t.memberExpression(t.identifier("Function"), t.identifier("prototype")), t.identifier("bind")), t.identifier("apply")), [node.callee, args]), []));
        }
      }};
  };
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("e9", ["4", "5", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireWildcard = $__require('4')["default"];
  exports.__esModule = true;
  var _babelTypes = $__require('5');
  var t = _interopRequireWildcard(_babelTypes);
  var visitor = {Function: function Function(path) {
      var params = path.get("params");
      var hoistTweak = t.isRestElement(params[params.length - 1]) ? 1 : 0;
      var outputParamsLength = params.length - hoistTweak;
      for (var i = 0; i < outputParamsLength; i++) {
        var param = params[i];
        if (param.isArrayPattern() || param.isObjectPattern()) {
          var uid = path.scope.generateUidIdentifier("ref");
          var declar = t.variableDeclaration("let", [t.variableDeclarator(param.node, uid)]);
          declar._blockHoist = outputParamsLength - i;
          path.ensureBlock();
          path.get("body").unshiftContainer("body", declar);
          param.replaceWith(uid);
        }
      }
    }};
  exports.visitor = visitor;
  return module.exports;
});

$__System.registerDynamic("d6", ["4", "5", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireWildcard = $__require('4')["default"];
  exports.__esModule = true;
  var _babelTypes = $__require('5');
  var t = _interopRequireWildcard(_babelTypes);
  exports["default"] = function(node) {
    var params = node.params;
    for (var i = 0; i < params.length; i++) {
      var param = params[i];
      if (t.isAssignmentPattern(param) || t.isRestElement(param)) {
        return i;
      }
    }
    return params.length;
  };
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("aa", ["4", "5", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireWildcard = $__require('4')["default"];
  exports.__esModule = true;
  var _babelTypes = $__require('5');
  var t = _interopRequireWildcard(_babelTypes);
  var visitor = {
    Scope: function Scope(path, state) {
      if (state.kind === "let")
        path.skip();
    },
    Function: function Function(path) {
      path.skip();
    },
    VariableDeclaration: function VariableDeclaration(path, state) {
      if (state.kind && path.node.kind !== state.kind)
        return;
      var nodes = [];
      var declarations = path.get("declarations");
      var firstId = undefined;
      for (var _i = 0; _i < declarations.length; _i++) {
        var declar = declarations[_i];
        firstId = declar.node.id;
        if (declar.node.init) {
          nodes.push(t.expressionStatement(t.assignmentExpression("=", declar.node.id, declar.node.init)));
        }
        for (var _name in declar.getBindingIdentifiers()) {
          state.emit(t.identifier(_name), _name);
        }
      }
      if (path.parentPath.isFor({left: path.node})) {
        path.replaceWith(firstId);
      } else {
        path.replaceWithMultiple(nodes);
      }
    }
  };
  exports["default"] = function(path, emit) {
    var kind = arguments.length <= 2 || arguments[2] === undefined ? "var" : arguments[2];
    path.traverse(visitor, {
      kind: kind,
      emit: emit
    });
  };
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("ea", ["a", "4", "aa", "5", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireDefault = $__require('a')["default"];
  var _interopRequireWildcard = $__require('4')["default"];
  exports.__esModule = true;
  var _babelHelperHoistVariables = $__require('aa');
  var _babelHelperHoistVariables2 = _interopRequireDefault(_babelHelperHoistVariables);
  var _babelTypes = $__require('5');
  var t = _interopRequireWildcard(_babelTypes);
  var visitor = {
    enter: function enter(path, state) {
      if (path.isThisExpression()) {
        state.foundThis = true;
      }
      if (path.isReferencedIdentifier({name: "arguments"})) {
        state.foundArguments = true;
      }
    },
    Function: function Function(path) {
      path.skip();
    }
  };
  exports["default"] = function(path) {
    var scope = arguments.length <= 1 || arguments[1] === undefined ? path.scope : arguments[1];
    return (function() {
      var node = path.node;
      var container = t.functionExpression(null, [], node.body, node.generator, node.async);
      var callee = container;
      var args = [];
      _babelHelperHoistVariables2["default"](path, function(id) {
        return scope.push({id: id});
      });
      var state = {
        foundThis: false,
        foundArguments: false
      };
      path.traverse(visitor, state);
      if (state.foundArguments) {
        callee = t.memberExpression(container, t.identifier("apply"));
        args = [];
        if (state.foundThis) {
          args.push(t.thisExpression());
        }
        if (state.foundArguments) {
          if (!state.foundThis)
            args.push(t.nullLiteral());
          args.push(t.identifier("arguments"));
        }
      }
      var call = t.callExpression(callee, args);
      if (node.generator)
        call = t.yieldExpression(call, true);
      return t.returnStatement(call);
    })();
  };
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("eb", ["a", "4", "d6", "ea", "73", "5", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireDefault = $__require('a')["default"];
  var _interopRequireWildcard = $__require('4')["default"];
  exports.__esModule = true;
  var _babelHelperGetFunctionArity = $__require('d6');
  var _babelHelperGetFunctionArity2 = _interopRequireDefault(_babelHelperGetFunctionArity);
  var _babelHelperCallDelegate = $__require('ea');
  var _babelHelperCallDelegate2 = _interopRequireDefault(_babelHelperCallDelegate);
  var _babelTemplate = $__require('73');
  var _babelTemplate2 = _interopRequireDefault(_babelTemplate);
  var _babelTypes = $__require('5');
  var t = _interopRequireWildcard(_babelTypes);
  var buildDefaultParam = _babelTemplate2["default"]("\n  let VARIABLE_NAME =\n    ARGUMENTS.length <= ARGUMENT_KEY || ARGUMENTS[ARGUMENT_KEY] === undefined ?\n      DEFAULT_VALUE\n    :\n      ARGUMENTS[ARGUMENT_KEY];\n");
  var buildDefaultParamAssign = _babelTemplate2["default"]("\n  if (VARIABLE_NAME === undefined) VARIABLE_NAME = DEFAULT_VALUE;\n");
  var buildCutOff = _babelTemplate2["default"]("\n  let $0 = $1[$2];\n");
  function hasDefaults(node) {
    var _arr = node.params;
    for (var _i = 0; _i < _arr.length; _i++) {
      var param = _arr[_i];
      if (!t.isIdentifier(param))
        return true;
    }
    return false;
  }
  var iifeVisitor = {
    ReferencedIdentifier: function ReferencedIdentifier(path, state) {
      var name = path.node.name;
      if (name === "eval" || path.scope.hasOwnBinding(name) && path.scope.getOwnBinding(name).kind !== "param") {
        state.iife = true;
        path.stop();
      }
    },
    Scope: function Scope(path) {
      path.skip();
    }
  };
  var visitor = {Function: function Function(path) {
      var node = path.node;
      var scope = path.scope;
      if (!hasDefaults(node))
        return;
      path.ensureBlock();
      var state = {
        iife: false,
        scope: scope
      };
      var body = [];
      var argsIdentifier = t.identifier("arguments");
      argsIdentifier._shadowedFunctionLiteral = path;
      function pushDefNode(left, right, i) {
        var defNode = undefined;
        if (exceedsLastNonDefault(i) || t.isPattern(left)) {
          defNode = buildDefaultParam({
            VARIABLE_NAME: left,
            DEFAULT_VALUE: right,
            ARGUMENT_KEY: t.numericLiteral(i),
            ARGUMENTS: argsIdentifier
          });
        } else {
          defNode = buildDefaultParamAssign({
            VARIABLE_NAME: left,
            DEFAULT_VALUE: right
          });
        }
        defNode._blockHoist = node.params.length - i;
        body.push(defNode);
      }
      function exceedsLastNonDefault(i) {
        return i + 1 > lastNonDefaultParam;
      }
      var lastNonDefaultParam = _babelHelperGetFunctionArity2["default"](node);
      var params = path.get("params");
      for (var i = 0; i < params.length; i++) {
        var param = params[i];
        if (!param.isAssignmentPattern()) {
          if (!param.isIdentifier()) {
            param.traverse(iifeVisitor, state);
          }
          continue;
        }
        var left = param.get("left");
        var right = param.get("right");
        if (exceedsLastNonDefault(i) || left.isPattern()) {
          var placeholder = scope.generateUidIdentifier("x");
          placeholder._isDefaultPlaceholder = true;
          node.params[i] = placeholder;
        } else {
          node.params[i] = left.node;
        }
        if (!state.iife) {
          if (right.isIdentifier() && scope.hasOwnBinding(right.node.name) && scope.getOwnBinding(right.node.name).kind !== "param") {
            state.iife = true;
          } else {
            right.traverse(iifeVisitor, state);
          }
        }
        pushDefNode(left.node, right.node, i);
      }
      for (var i = lastNonDefaultParam + 1; i < node.params.length; i++) {
        var param = node.params[i];
        if (param._isDefaultPlaceholder)
          continue;
        var declar = buildCutOff(param, argsIdentifier, t.numericLiteral(i));
        declar._blockHoist = node.params.length - i;
        body.push(declar);
      }
      node.params = node.params.slice(0, lastNonDefaultParam);
      if (state.iife) {
        body.push(_babelHelperCallDelegate2["default"](path, scope));
        path.set("body", t.blockStatement(body));
      } else {
        path.get("body").unshiftContainer("body", body);
      }
    }};
  exports.visitor = visitor;
  return module.exports;
});

$__System.registerDynamic("ec", ["a", "4", "73", "5", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireDefault = $__require('a')["default"];
  var _interopRequireWildcard = $__require('4')["default"];
  exports.__esModule = true;
  var _babelTemplate = $__require('73');
  var _babelTemplate2 = _interopRequireDefault(_babelTemplate);
  var _babelTypes = $__require('5');
  var t = _interopRequireWildcard(_babelTypes);
  var buildRest = _babelTemplate2["default"]("\n  for (var LEN = ARGUMENTS.length,\n           ARRAY = Array(ARRAY_LEN),\n           KEY = START;\n       KEY < LEN;\n       KEY++) {\n    ARRAY[ARRAY_KEY] = ARGUMENTS[KEY];\n  }\n");
  var loadRest = _babelTemplate2["default"]("\n  ARGUMENTS.length <= INDEX ? undefined : ARGUMENTS[INDEX]\n");
  var memberExpressionOptimisationVisitor = {
    Scope: function Scope(path, state) {
      if (!path.scope.bindingIdentifierEquals(state.name, state.outerBinding)) {
        path.skip();
      }
    },
    Flow: function Flow(path) {
      path.skip();
    },
    Function: function Function(path, state) {
      var oldNoOptimise = state.noOptimise;
      state.noOptimise = true;
      path.traverse(memberExpressionOptimisationVisitor, state);
      state.noOptimise = oldNoOptimise;
      path.skip();
    },
    ReferencedIdentifier: function ReferencedIdentifier(path, state) {
      var node = path.node;
      if (node.name === "arguments") {
        state.deopted = true;
      }
      if (node.name !== state.name)
        return;
      if (state.noOptimise) {
        state.deopted = true;
      } else {
        var parentPath = path.parentPath;
        if (parentPath.isMemberExpression({object: node})) {
          var grandparentPath = parentPath.parentPath;
          var argsOptEligible = !state.deopted && !(grandparentPath.isAssignmentExpression() && parentPath.node === grandparentPath.node.left || grandparentPath.isLVal() || grandparentPath.isForXStatement() || grandparentPath.isUpdateExpression() || grandparentPath.isUnaryExpression({operator: "delete"}) || (grandparentPath.isCallExpression() || grandparentPath.isNewExpression()) && parentPath.node === grandparentPath.node.callee);
          if (argsOptEligible) {
            if (parentPath.node.computed) {
              if (parentPath.get("property").isBaseType("number")) {
                state.candidates.push({
                  cause: "indexGetter",
                  path: path
                });
                return;
              }
            } else if (parentPath.node.property.name === "length") {
              state.candidates.push({
                cause: "lengthGetter",
                path: path
              });
              return;
            }
          }
        }
        if (state.offset === 0 && parentPath.isSpreadElement()) {
          var call = parentPath.parentPath;
          if (call.isCallExpression() && call.node.arguments.length === 1) {
            state.candidates.push({
              cause: "argSpread",
              path: path
            });
            return;
          }
        }
        state.references.push(path);
      }
    },
    BindingIdentifier: function BindingIdentifier(_ref, state) {
      var node = _ref.node;
      if (node.name === state.name) {
        state.deopted = true;
      }
    }
  };
  function hasRest(node) {
    return t.isRestElement(node.params[node.params.length - 1]);
  }
  function optimiseIndexGetter(path, argsId, offset) {
    var index = undefined;
    if (t.isNumericLiteral(path.parent.property)) {
      index = t.numericLiteral(path.parent.property.value + offset);
    } else {
      index = t.binaryExpression("+", path.parent.property, t.numericLiteral(offset));
    }
    path.parentPath.replaceWith(loadRest({
      ARGUMENTS: argsId,
      INDEX: index
    }));
  }
  function optimiseLengthGetter(path, argsLengthExpression, argsId, offset) {
    if (offset) {
      path.parentPath.replaceWith(t.binaryExpression("-", argsLengthExpression, t.numericLiteral(offset)));
    } else {
      path.replaceWith(argsId);
    }
  }
  var visitor = {Function: function Function(path) {
      var node = path.node;
      var scope = path.scope;
      if (!hasRest(node))
        return;
      var rest = node.params.pop().argument;
      var argsId = t.identifier("arguments");
      var argsLengthExpression = t.memberExpression(argsId, t.identifier("length"));
      argsId._shadowedFunctionLiteral = path;
      var state = {
        references: [],
        offset: node.params.length,
        argumentsNode: argsId,
        outerBinding: scope.getBindingIdentifier(rest.name),
        candidates: [],
        name: rest.name,
        deopted: false
      };
      path.traverse(memberExpressionOptimisationVisitor, state);
      if (!state.deopted && !state.references.length) {
        var _arr = state.candidates;
        for (var _i = 0; _i < _arr.length; _i++) {
          var _arr$_i = _arr[_i];
          var _path = _arr$_i.path;
          var cause = _arr$_i.cause;
          switch (cause) {
            case "indexGetter":
              optimiseIndexGetter(_path, argsId, state.offset);
              break;
            case "lengthGetter":
              optimiseLengthGetter(_path, argsLengthExpression, argsId, state.offset);
              break;
            default:
              _path.replaceWith(argsId);
          }
        }
        return;
      }
      state.references = state.references.concat(state.candidates.map(function(_ref2) {
        var path = _ref2.path;
        return path;
      }));
      state.deopted = state.deopted || !!node.shadow;
      var start = t.numericLiteral(node.params.length);
      var key = scope.generateUidIdentifier("key");
      var len = scope.generateUidIdentifier("len");
      var arrKey = key;
      var arrLen = len;
      if (node.params.length) {
        arrKey = t.binaryExpression("-", key, start);
        arrLen = t.conditionalExpression(t.binaryExpression(">", len, start), t.binaryExpression("-", len, start), t.numericLiteral(0));
      }
      var loop = buildRest({
        ARGUMENTS: argsId,
        ARRAY_KEY: arrKey,
        ARRAY_LEN: arrLen,
        START: start,
        ARRAY: rest,
        KEY: key,
        LEN: len
      });
      if (state.deopted) {
        loop._blockHoist = node.params.length + 1;
        node.body.body.unshift(loop);
      } else {
        loop._blockHoist = 1;
        var target = path.getEarliestCommonAncestorFrom(state.references).getStatementParent();
        target.findParent(function(path) {
          if (path.isLoop()) {
            target = path;
          } else {
            return path.isFunction();
          }
        });
        target.insertBefore(loop);
      }
    }};
  exports.visitor = visitor;
  return module.exports;
});

$__System.registerDynamic("ed", ["4", "10", "e9", "eb", "ec", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireWildcard = $__require('4')["default"];
  exports.__esModule = true;
  var _babelTraverse = $__require('10');
  var _destructuring = $__require('e9');
  var destructuring = _interopRequireWildcard(_destructuring);
  var _default = $__require('eb');
  var def = _interopRequireWildcard(_default);
  var _rest = $__require('ec');
  var rest = _interopRequireWildcard(_rest);
  exports["default"] = function() {
    return {visitor: _babelTraverse.visitors.merge([{ArrowFunctionExpression: function ArrowFunctionExpression(path) {
          var params = path.get("params");
          for (var _i = 0; _i < params.length; _i++) {
            var param = params[_i];
            if (param.isRestElement() || param.isAssignmentPattern()) {
              path.arrowFunctionToShadowed();
              break;
            }
          }
        }}, destructuring.visitor, rest.visitor, def.visitor])};
  };
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("ee", ["9", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _classCallCheck = $__require('9')["default"];
  exports.__esModule = true;
  exports["default"] = function(_ref) {
    var t = _ref.types;
    function variableDeclarationHasPattern(node) {
      var _arr = node.declarations;
      for (var _i = 0; _i < _arr.length; _i++) {
        var declar = _arr[_i];
        if (t.isPattern(declar.id)) {
          return true;
        }
      }
      return false;
    }
    function hasRest(pattern) {
      var _arr2 = pattern.elements;
      for (var _i2 = 0; _i2 < _arr2.length; _i2++) {
        var elem = _arr2[_i2];
        if (t.isRestElement(elem)) {
          return true;
        }
      }
      return false;
    }
    var arrayUnpackVisitor = {ReferencedIdentifier: function ReferencedIdentifier(path, state) {
        if (state.bindings[path.node.name]) {
          state.deopt = true;
          path.stop();
        }
      }};
    var DestructuringTransformer = (function() {
      function DestructuringTransformer(opts) {
        _classCallCheck(this, DestructuringTransformer);
        this.blockHoist = opts.blockHoist;
        this.operator = opts.operator;
        this.arrays = {};
        this.nodes = opts.nodes || [];
        this.scope = opts.scope;
        this.file = opts.file;
        this.kind = opts.kind;
      }
      DestructuringTransformer.prototype.buildVariableAssignment = function buildVariableAssignment(id, init) {
        var op = this.operator;
        if (t.isMemberExpression(id))
          op = "=";
        var node = undefined;
        if (op) {
          node = t.expressionStatement(t.assignmentExpression(op, id, init));
        } else {
          node = t.variableDeclaration(this.kind, [t.variableDeclarator(id, init)]);
        }
        node._blockHoist = this.blockHoist;
        return node;
      };
      DestructuringTransformer.prototype.buildVariableDeclaration = function buildVariableDeclaration(id, init) {
        var declar = t.variableDeclaration("var", [t.variableDeclarator(id, init)]);
        declar._blockHoist = this.blockHoist;
        return declar;
      };
      DestructuringTransformer.prototype.push = function push(id, init) {
        if (t.isObjectPattern(id)) {
          this.pushObjectPattern(id, init);
        } else if (t.isArrayPattern(id)) {
          this.pushArrayPattern(id, init);
        } else if (t.isAssignmentPattern(id)) {
          this.pushAssignmentPattern(id, init);
        } else {
          this.nodes.push(this.buildVariableAssignment(id, init));
        }
      };
      DestructuringTransformer.prototype.toArray = function toArray(node, count) {
        if (this.file.opts.loose || t.isIdentifier(node) && this.arrays[node.name]) {
          return node;
        } else {
          return this.scope.toArray(node, count);
        }
      };
      DestructuringTransformer.prototype.pushAssignmentPattern = function pushAssignmentPattern(pattern, valueRef) {
        var tempValueRef = this.scope.generateUidIdentifierBasedOnNode(valueRef);
        var declar = t.variableDeclaration("var", [t.variableDeclarator(tempValueRef, valueRef)]);
        declar._blockHoist = this.blockHoist;
        this.nodes.push(declar);
        var tempConditional = t.conditionalExpression(t.binaryExpression("===", tempValueRef, t.identifier("undefined")), pattern.right, tempValueRef);
        var left = pattern.left;
        if (t.isPattern(left)) {
          var tempValueDefault = t.expressionStatement(t.assignmentExpression("=", tempValueRef, tempConditional));
          tempValueDefault._blockHoist = this.blockHoist;
          this.nodes.push(tempValueDefault);
          this.push(left, tempValueRef);
        } else {
          this.nodes.push(this.buildVariableAssignment(left, tempConditional));
        }
      };
      DestructuringTransformer.prototype.pushObjectRest = function pushObjectRest(pattern, objRef, spreadProp, spreadPropIndex) {
        var keys = [];
        for (var i = 0; i < pattern.properties.length; i++) {
          var prop = pattern.properties[i];
          if (i >= spreadPropIndex)
            break;
          if (t.isRestProperty(prop))
            continue;
          var key = prop.key;
          if (t.isIdentifier(key) && !prop.computed)
            key = t.stringLiteral(prop.key.name);
          keys.push(key);
        }
        keys = t.arrayExpression(keys);
        var value = t.callExpression(this.file.addHelper("objectWithoutProperties"), [objRef, keys]);
        this.nodes.push(this.buildVariableAssignment(spreadProp.argument, value));
      };
      DestructuringTransformer.prototype.pushObjectProperty = function pushObjectProperty(prop, propRef) {
        if (t.isLiteral(prop.key))
          prop.computed = true;
        var pattern = prop.value;
        var objRef = t.memberExpression(propRef, prop.key, prop.computed);
        if (t.isPattern(pattern)) {
          this.push(pattern, objRef);
        } else {
          this.nodes.push(this.buildVariableAssignment(pattern, objRef));
        }
      };
      DestructuringTransformer.prototype.pushObjectPattern = function pushObjectPattern(pattern, objRef) {
        if (!pattern.properties.length) {
          this.nodes.push(t.expressionStatement(t.callExpression(this.file.addHelper("objectDestructuringEmpty"), [objRef])));
        }
        if (pattern.properties.length > 1 && !this.scope.isStatic(objRef)) {
          var temp = this.scope.generateUidIdentifierBasedOnNode(objRef);
          this.nodes.push(this.buildVariableDeclaration(temp, objRef));
          objRef = temp;
        }
        for (var i = 0; i < pattern.properties.length; i++) {
          var prop = pattern.properties[i];
          if (t.isRestProperty(prop)) {
            this.pushObjectRest(pattern, objRef, prop, i);
          } else {
            this.pushObjectProperty(prop, objRef);
          }
        }
      };
      DestructuringTransformer.prototype.canUnpackArrayPattern = function canUnpackArrayPattern(pattern, arr) {
        if (!t.isArrayExpression(arr))
          return false;
        if (pattern.elements.length > arr.elements.length)
          return;
        if (pattern.elements.length < arr.elements.length && !hasRest(pattern))
          return false;
        var _arr3 = pattern.elements;
        for (var _i3 = 0; _i3 < _arr3.length; _i3++) {
          var elem = _arr3[_i3];
          if (!elem)
            return false;
          if (t.isMemberExpression(elem))
            return false;
        }
        var _arr4 = arr.elements;
        for (var _i4 = 0; _i4 < _arr4.length; _i4++) {
          var elem = _arr4[_i4];
          if (t.isSpreadElement(elem))
            return false;
        }
        var bindings = t.getBindingIdentifiers(pattern);
        var state = {
          deopt: false,
          bindings: bindings
        };
        this.scope.traverse(arr, arrayUnpackVisitor, state);
        return !state.deopt;
      };
      DestructuringTransformer.prototype.pushUnpackedArrayPattern = function pushUnpackedArrayPattern(pattern, arr) {
        for (var i = 0; i < pattern.elements.length; i++) {
          var elem = pattern.elements[i];
          if (t.isRestElement(elem)) {
            this.push(elem.argument, t.arrayExpression(arr.elements.slice(i)));
          } else {
            this.push(elem, arr.elements[i]);
          }
        }
      };
      DestructuringTransformer.prototype.pushArrayPattern = function pushArrayPattern(pattern, arrayRef) {
        if (!pattern.elements)
          return;
        if (this.canUnpackArrayPattern(pattern, arrayRef)) {
          return this.pushUnpackedArrayPattern(pattern, arrayRef);
        }
        var count = !hasRest(pattern) && pattern.elements.length;
        var toArray = this.toArray(arrayRef, count);
        if (t.isIdentifier(toArray)) {
          arrayRef = toArray;
        } else {
          arrayRef = this.scope.generateUidIdentifierBasedOnNode(arrayRef);
          this.arrays[arrayRef.name] = true;
          this.nodes.push(this.buildVariableDeclaration(arrayRef, toArray));
        }
        for (var i = 0; i < pattern.elements.length; i++) {
          var elem = pattern.elements[i];
          if (!elem)
            continue;
          var elemRef = undefined;
          if (t.isRestElement(elem)) {
            elemRef = this.toArray(arrayRef);
            if (i > 0) {
              elemRef = t.callExpression(t.memberExpression(elemRef, t.identifier("slice")), [t.numericLiteral(i)]);
            }
            elem = elem.argument;
          } else {
            elemRef = t.memberExpression(arrayRef, t.numericLiteral(i), true);
          }
          this.push(elem, elemRef);
        }
      };
      DestructuringTransformer.prototype.init = function init(pattern, ref) {
        if (!t.isArrayExpression(ref) && !t.isMemberExpression(ref)) {
          var memo = this.scope.maybeGenerateMemoised(ref, true);
          if (memo) {
            this.nodes.push(this.buildVariableDeclaration(memo, ref));
            ref = memo;
          }
        }
        this.push(pattern, ref);
        return this.nodes;
      };
      return DestructuringTransformer;
    })();
    return {visitor: {
        ExportNamedDeclaration: function ExportNamedDeclaration(path) {
          var declaration = path.get("declaration");
          if (!declaration.isVariableDeclaration())
            return;
          if (!variableDeclarationHasPattern(declaration.node))
            return;
          var specifiers = [];
          for (var _name in path.getOuterBindingIdentifiers(path)) {
            var id = t.identifier(_name);
            specifiers.push(t.exportSpecifier(id, id));
          }
          path.replaceWith(declaration.node);
          path.insertAfter(t.exportNamedDeclaration(null, specifiers));
        },
        ForXStatement: function ForXStatement(path, file) {
          var node = path.node;
          var scope = path.scope;
          var left = node.left;
          if (t.isPattern(left)) {
            var temp = scope.generateUidIdentifier("ref");
            node.left = t.variableDeclaration("var", [t.variableDeclarator(temp)]);
            path.ensureBlock();
            node.body.body.unshift(t.variableDeclaration("var", [t.variableDeclarator(left, temp)]));
            return;
          }
          if (!t.isVariableDeclaration(left))
            return;
          var pattern = left.declarations[0].id;
          if (!t.isPattern(pattern))
            return;
          var key = scope.generateUidIdentifier("ref");
          node.left = t.variableDeclaration(left.kind, [t.variableDeclarator(key, null)]);
          var nodes = [];
          var destructuring = new DestructuringTransformer({
            kind: left.kind,
            file: file,
            scope: scope,
            nodes: nodes
          });
          destructuring.init(pattern, key);
          path.ensureBlock();
          var block = node.body;
          block.body = nodes.concat(block.body);
        },
        CatchClause: function CatchClause(_ref2, file) {
          var node = _ref2.node;
          var scope = _ref2.scope;
          var pattern = node.param;
          if (!t.isPattern(pattern))
            return;
          var ref = scope.generateUidIdentifier("ref");
          node.param = ref;
          var nodes = [];
          var destructuring = new DestructuringTransformer({
            kind: "let",
            file: file,
            scope: scope,
            nodes: nodes
          });
          destructuring.init(pattern, ref);
          node.body.body = nodes.concat(node.body.body);
        },
        AssignmentExpression: function AssignmentExpression(path, file) {
          var node = path.node;
          var scope = path.scope;
          if (!t.isPattern(node.left))
            return;
          var nodes = [];
          var destructuring = new DestructuringTransformer({
            operator: node.operator,
            file: file,
            scope: scope,
            nodes: nodes
          });
          var ref = undefined;
          if (path.isCompletionRecord() || !path.parentPath.isExpressionStatement()) {
            ref = scope.generateUidIdentifierBasedOnNode(node.right, "ref");
            nodes.push(t.variableDeclaration("var", [t.variableDeclarator(ref, node.right)]));
            if (t.isArrayExpression(node.right)) {
              destructuring.arrays[ref.name] = true;
            }
          }
          destructuring.init(node.left, ref || node.right);
          if (ref) {
            nodes.push(t.expressionStatement(ref));
          }
          path.replaceWithMultiple(nodes);
        },
        VariableDeclaration: function VariableDeclaration(path, file) {
          var node = path.node;
          var scope = path.scope;
          var parent = path.parent;
          if (t.isForXStatement(parent))
            return;
          if (!parent || !path.container)
            return;
          if (!variableDeclarationHasPattern(node))
            return;
          var nodes = [];
          var declar = undefined;
          for (var i = 0; i < node.declarations.length; i++) {
            declar = node.declarations[i];
            var patternId = declar.init;
            var pattern = declar.id;
            var destructuring = new DestructuringTransformer({
              blockHoist: node._blockHoist,
              nodes: nodes,
              scope: scope,
              kind: node.kind,
              file: file
            });
            if (t.isPattern(pattern)) {
              destructuring.init(pattern, patternId);
              if (+i !== node.declarations.length - 1) {
                t.inherits(nodes[nodes.length - 1], declar);
              }
            } else {
              nodes.push(t.inherits(destructuring.buildVariableAssignment(declar.id, declar.init), declar));
            }
          }
          path.replaceWithMultiple(nodes);
        }
      }};
  };
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("ef", ["4", "5"], true, function($__require, exports, module) {
  "use strict";
  ;
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireWildcard = $__require('4')["default"];
  exports.__esModule = true;
  var _babelTypes = $__require('5');
  var t = _interopRequireWildcard(_babelTypes);
  function getTDZStatus(refPath, bindingPath) {
    var executionStatus = bindingPath._guessExecutionStatusRelativeTo(refPath);
    if (executionStatus === "before") {
      return "inside";
    } else if (executionStatus === "after") {
      return "outside";
    } else {
      return "maybe";
    }
  }
  function buildTDZAssert(node, file) {
    return t.callExpression(file.addHelper("temporalRef"), [node, t.stringLiteral(node.name), file.addHelper("temporalUndefined")]);
  }
  function isReference(node, scope, state) {
    var declared = state.letReferences[node.name];
    if (!declared)
      return false;
    return scope.getBindingIdentifier(node.name) === declared;
  }
  var visitor = {
    ReferencedIdentifier: function ReferencedIdentifier(path, state) {
      if (!this.file.opts.tdz)
        return;
      var node = path.node;
      var parent = path.parent;
      var scope = path.scope;
      if (path.parentPath.isFor({left: node}))
        return;
      if (!isReference(node, scope, state))
        return;
      var bindingPath = scope.getBinding(node.name).path;
      var status = getTDZStatus(path, bindingPath);
      if (status === "inside")
        return;
      if (status === "maybe") {
        var assert = buildTDZAssert(node, state.file);
        bindingPath.parent._tdzThis = true;
        path.skip();
        if (path.parentPath.isUpdateExpression()) {
          if (parent._ignoreBlockScopingTDZ)
            return;
          path.parentPath.replaceWith(t.sequenceExpression([assert, parent]));
        } else {
          path.replaceWith(assert);
        }
      } else if (status === "outside") {
        path.replaceWith(t.throwStatement(t.inherits(t.newExpression(t.identifier("ReferenceError"), [t.stringLiteral(node.name + " is not defined - temporal dead zone")]), node)));
      }
    },
    AssignmentExpression: {exit: function exit(path, state) {
        if (!this.file.opts.tdz)
          return;
        var node = path.node;
        if (node._ignoreBlockScopingTDZ)
          return;
        var nodes = [];
        var ids = path.getBindingIdentifiers();
        for (var _name in ids) {
          var id = ids[_name];
          if (isReference(id, path.scope, state)) {
            nodes.push(buildTDZAssert(id, state.file));
          }
        }
        if (nodes.length) {
          node._ignoreBlockScopingTDZ = true;
          nodes.push(node);
          path.replaceWithMultiple(nodes.map(t.expressionStatement));
        }
      }}
  };
  exports.visitor = visitor;
  return module.exports;
});

$__System.registerDynamic("f0", ["69", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  module.exports = $__require('69');
  return module.exports;
});

$__System.registerDynamic("4b", ["f1", "f2", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var baseClone = $__require('f1'),
      bindCallback = $__require('f2');
  function cloneDeep(value, customizer, thisArg) {
    return typeof customizer == 'function' ? baseClone(value, true, bindCallback(customizer, thisArg, 3)) : baseClone(value, true);
  }
  module.exports = cloneDeep;
  return module.exports;
});

$__System.registerDynamic("d3", ["f3", "f4", "38", "39", "f5", "f6", "f7", "f8", "f9", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var baseGet = $__require('f3'),
      baseSlice = $__require('f4'),
      isArguments = $__require('38'),
      isArray = $__require('39'),
      isIndex = $__require('f5'),
      isKey = $__require('f6'),
      isLength = $__require('f7'),
      last = $__require('f8'),
      toPath = $__require('f9');
  var objectProto = Object.prototype;
  var hasOwnProperty = objectProto.hasOwnProperty;
  function has(object, path) {
    if (object == null) {
      return false;
    }
    var result = hasOwnProperty.call(object, path);
    if (!result && !isKey(path)) {
      path = toPath(path);
      object = path.length == 1 ? object : baseGet(object, baseSlice(path, 0, -1));
      if (object == null) {
        return false;
      }
      path = last(path);
      result = hasOwnProperty.call(object, path);
    }
    return result || (isLength(object.length) && isIndex(path, object.length) && (isArray(object) || isArguments(object)));
  }
  module.exports = has;
  return module.exports;
});

$__System.registerDynamic("73", ["a9", "a", "4", "4b", "69", "d3", "10", "71", "5"], true, function($__require, exports, module) {
  "use strict";
  ;
  var define,
      global = this,
      GLOBAL = this;
  var _Symbol = $__require('a9')["default"];
  var _interopRequireDefault = $__require('a')["default"];
  var _interopRequireWildcard = $__require('4')["default"];
  exports.__esModule = true;
  var _lodashLangCloneDeep = $__require('4b');
  var _lodashLangCloneDeep2 = _interopRequireDefault(_lodashLangCloneDeep);
  var _lodashObjectAssign = $__require('69');
  var _lodashObjectAssign2 = _interopRequireDefault(_lodashObjectAssign);
  var _lodashObjectHas = $__require('d3');
  var _lodashObjectHas2 = _interopRequireDefault(_lodashObjectHas);
  var _babelTraverse = $__require('10');
  var _babelTraverse2 = _interopRequireDefault(_babelTraverse);
  var _babylon = $__require('71');
  var babylon = _interopRequireWildcard(_babylon);
  var _babelTypes = $__require('5');
  var t = _interopRequireWildcard(_babelTypes);
  var FROM_TEMPLATE = "_fromTemplate";
  var TEMPLATE_SKIP = _Symbol();
  exports["default"] = function(code, opts) {
    var stack = undefined;
    try {
      throw new Error();
    } catch (error) {
      if (error.stack) {
        stack = error.stack.split("\n").slice(1).join("\n");
      }
    }
    var _getAst = function getAst() {
      var ast = undefined;
      try {
        ast = babylon.parse(code, _lodashObjectAssign2["default"]({
          allowReturnOutsideFunction: true,
          allowSuperOutsideMethod: true
        }, opts));
        ast = _babelTraverse2["default"].removeProperties(ast);
        _babelTraverse2["default"].cheap(ast, function(node) {
          node[FROM_TEMPLATE] = true;
        });
      } catch (err) {
        err.stack = err.stack + "from\n" + stack;
        throw err;
      }
      _getAst = function() {
        return ast;
      };
      return ast;
    };
    return function() {
      for (var _len = arguments.length,
          args = Array(_len),
          _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }
      return useTemplate(_getAst(), args);
    };
  };
  function useTemplate(ast, nodes) {
    ast = _lodashLangCloneDeep2["default"](ast);
    var _ast = ast;
    var program = _ast.program;
    if (nodes.length) {
      _babelTraverse2["default"](ast, templateVisitor, null, nodes);
    }
    if (program.body.length > 1) {
      return program.body;
    } else {
      return program.body[0];
    }
  }
  var templateVisitor = {
    noScope: true,
    enter: function enter(path, args) {
      var node = path.node;
      if (node[TEMPLATE_SKIP])
        return path.skip();
      if (t.isExpressionStatement(node)) {
        node = node.expression;
      }
      var replacement = undefined;
      if (t.isIdentifier(node) && node[FROM_TEMPLATE]) {
        if (_lodashObjectHas2["default"](args[0], node.name)) {
          replacement = args[0][node.name];
        } else if (node.name[0] === "$") {
          var i = +node.name.slice(1);
          if (args[i])
            replacement = args[i];
        }
      }
      if (replacement === null) {
        path.remove();
      }
      if (replacement) {
        replacement[TEMPLATE_SKIP] = true;
        path.replaceInline(replacement);
      }
    },
    exit: function exit(_ref) {
      var node = _ref.node;
      if (!node.loc)
        _babelTraverse2["default"].clearNode(node);
    }
  };
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("fa", ["9", "6b", "a9", "a", "4", "10", "ef", "5", "fb", "f0", "73"], true, function($__require, exports, module) {
  "use strict";
  ;
  var define,
      global = this,
      GLOBAL = this;
  var _classCallCheck = $__require('9')["default"];
  var _Object$create = $__require('6b')["default"];
  var _Symbol = $__require('a9')["default"];
  var _interopRequireDefault = $__require('a')["default"];
  var _interopRequireWildcard = $__require('4')["default"];
  exports.__esModule = true;
  var _babelTraverse = $__require('10');
  var _babelTraverse2 = _interopRequireDefault(_babelTraverse);
  var _tdz = $__require('ef');
  var _babelTypes = $__require('5');
  var t = _interopRequireWildcard(_babelTypes);
  var _lodashObjectValues = $__require('fb');
  var _lodashObjectValues2 = _interopRequireDefault(_lodashObjectValues);
  var _lodashObjectExtend = $__require('f0');
  var _lodashObjectExtend2 = _interopRequireDefault(_lodashObjectExtend);
  var _babelTemplate = $__require('73');
  var _babelTemplate2 = _interopRequireDefault(_babelTemplate);
  exports["default"] = function() {
    return {visitor: {
        VariableDeclaration: function VariableDeclaration(path, file) {
          var node = path.node;
          var parent = path.parent;
          var scope = path.scope;
          if (!isBlockScoped(node))
            return;
          convertBlockScopedToVar(path, parent, scope, true);
          if (node._tdzThis) {
            var nodes = [node];
            for (var i = 0; i < node.declarations.length; i++) {
              var decl = node.declarations[i];
              if (decl.init) {
                var assign = t.assignmentExpression("=", decl.id, decl.init);
                assign._ignoreBlockScopingTDZ = true;
                nodes.push(t.expressionStatement(assign));
              }
              decl.init = file.addHelper("temporalUndefined");
            }
            node._blockHoist = 2;
            if (path.isCompletionRecord()) {
              nodes.push(t.expressionStatement(scope.buildUndefinedNode()));
            }
            path.replaceWithMultiple(nodes);
          }
        },
        Loop: function Loop(path, file) {
          var node = path.node;
          var parent = path.parent;
          var scope = path.scope;
          t.ensureBlock(node);
          var blockScoping = new BlockScoping(path, path.get("body"), parent, scope, file);
          var replace = blockScoping.run();
          if (replace)
            path.replaceWith(replace);
        },
        "BlockStatement|Program": function BlockStatementProgram(path, file) {
          if (!t.isLoop(path.parent)) {
            var blockScoping = new BlockScoping(null, path, path.parent, path.scope, file);
            blockScoping.run();
          }
        }
      }};
  };
  var buildRetCheck = _babelTemplate2["default"]("\n  if (typeof RETURN === \"object\") return RETURN.v;\n");
  function isBlockScoped(node) {
    if (!t.isVariableDeclaration(node))
      return false;
    if (node[t.BLOCK_SCOPED_SYMBOL])
      return true;
    if (node.kind !== "let" && node.kind !== "const")
      return false;
    return true;
  }
  function convertBlockScopedToVar(path, parent, scope) {
    var moveBindingsToParent = arguments.length <= 3 || arguments[3] === undefined ? false : arguments[3];
    var node = path.node;
    if (!t.isFor(parent)) {
      for (var i = 0; i < node.declarations.length; i++) {
        var declar = node.declarations[i];
        declar.init = declar.init || scope.buildUndefinedNode();
      }
    }
    node[t.BLOCK_SCOPED_SYMBOL] = true;
    node.kind = "var";
    if (moveBindingsToParent) {
      var parentScope = scope.getFunctionParent();
      var ids = path.getBindingIdentifiers();
      for (var _name in ids) {
        var binding = scope.getOwnBinding(_name);
        if (binding)
          binding.kind = "var";
        scope.moveBindingTo(_name, parentScope);
      }
    }
  }
  function isVar(node) {
    return t.isVariableDeclaration(node, {kind: "var"}) && !isBlockScoped(node);
  }
  function replace(path, node, scope, remaps) {
    var remap = remaps[node.name];
    if (!remap)
      return;
    var ownBinding = scope.getBindingIdentifier(node.name);
    if (ownBinding === remap.binding) {
      scope.rename(node.name, remap.uid);
    } else {
      if (path)
        path.skip();
    }
  }
  var replaceVisitor = {
    ReferencedIdentifier: function ReferencedIdentifier(path, remaps) {
      replace(path, path.node, path.scope, remaps);
    },
    AssignmentExpression: function AssignmentExpression(path, remaps) {
      var ids = path.getBindingIdentifiers();
      for (var _name2 in ids) {
        replace(null, ids[_name2], path.scope, remaps);
      }
    }
  };
  function traverseReplace(node, parent, scope, remaps) {
    if (t.isIdentifier(node)) {
      replace(node, parent, scope, remaps);
    }
    if (t.isAssignmentExpression(node)) {
      var ids = t.getBindingIdentifiers(node);
      for (var _name3 in ids) {
        replace(ids[_name3], parent, scope, remaps);
      }
    }
    scope.traverse(node, replaceVisitor, remaps);
  }
  var letReferenceBlockVisitor = _babelTraverse2["default"].visitors.merge([{Function: function Function(path, state) {
      path.traverse(letReferenceFunctionVisitor, state);
      return path.skip();
    }}, _tdz.visitor]);
  var letReferenceFunctionVisitor = _babelTraverse2["default"].visitors.merge([{ReferencedIdentifier: function ReferencedIdentifier(path, state) {
      var ref = state.letReferences[path.node.name];
      if (!ref)
        return;
      var localBinding = path.scope.getBindingIdentifier(path.node.name);
      if (localBinding && localBinding !== ref)
        return;
      state.closurify = true;
    }}, _tdz.visitor]);
  var hoistVarDeclarationsVisitor = {enter: function enter(path, self) {
      var node = path.node;
      var parent = path.parent;
      if (path.isForStatement()) {
        if (isVar(node.init, node)) {
          var nodes = self.pushDeclar(node.init);
          if (nodes.length === 1) {
            node.init = nodes[0];
          } else {
            node.init = t.sequenceExpression(nodes);
          }
        }
      } else if (path.isFor()) {
        if (isVar(node.left, node)) {
          self.pushDeclar(node.left);
          node.left = node.left.declarations[0].id;
        }
      } else if (isVar(node, parent)) {
        path.replaceWithMultiple(self.pushDeclar(node).map(function(expr) {
          return t.expressionStatement(expr);
        }));
      } else if (path.isFunction()) {
        return path.skip();
      }
    }};
  var loopLabelVisitor = {LabeledStatement: function LabeledStatement(_ref, state) {
      var node = _ref.node;
      state.innerLabels.push(node.label.name);
    }};
  var continuationVisitor = {enter: function enter(path, state) {
      if (path.isAssignmentExpression() || path.isUpdateExpression()) {
        var bindings = path.getBindingIdentifiers();
        for (var _name4 in bindings) {
          if (state.outsideReferences[_name4] !== path.scope.getBindingIdentifier(_name4))
            continue;
          state.reassignments[_name4] = true;
        }
      }
    }};
  function loopNodeTo(node) {
    if (t.isBreakStatement(node)) {
      return "break";
    } else if (t.isContinueStatement(node)) {
      return "continue";
    }
  }
  var loopVisitor = {
    Loop: function Loop(path, state) {
      var oldIgnoreLabeless = state.ignoreLabeless;
      state.ignoreLabeless = true;
      path.traverse(loopVisitor, state);
      state.ignoreLabeless = oldIgnoreLabeless;
      path.skip();
    },
    Function: function Function(path) {
      path.skip();
    },
    SwitchCase: function SwitchCase(path, state) {
      var oldInSwitchCase = state.inSwitchCase;
      state.inSwitchCase = true;
      path.traverse(loopVisitor, state);
      state.inSwitchCase = oldInSwitchCase;
      path.skip();
    },
    "BreakStatement|ContinueStatement|ReturnStatement": function BreakStatementContinueStatementReturnStatement(path, state) {
      var node = path.node;
      var parent = path.parent;
      var scope = path.scope;
      if (node[this.LOOP_IGNORE])
        return;
      var replace = undefined;
      var loopText = loopNodeTo(node);
      if (loopText) {
        if (node.label) {
          if (state.innerLabels.indexOf(node.label.name) >= 0) {
            return;
          }
          loopText = loopText + "|" + node.label.name;
        } else {
          if (state.ignoreLabeless)
            return;
          if (state.inSwitchCase)
            return;
          if (t.isBreakStatement(node) && t.isSwitchCase(parent))
            return;
        }
        state.hasBreakContinue = true;
        state.map[loopText] = node;
        replace = t.stringLiteral(loopText);
      }
      if (path.isReturnStatement()) {
        state.hasReturn = true;
        replace = t.objectExpression([t.objectProperty(t.identifier("v"), node.argument || scope.buildUndefinedNode())]);
      }
      if (replace) {
        replace = t.returnStatement(replace);
        replace[this.LOOP_IGNORE] = true;
        path.skip();
        path.replaceWith(t.inherits(replace, node));
      }
    }
  };
  var BlockScoping = (function() {
    function BlockScoping(loopPath, blockPath, parent, scope, file) {
      _classCallCheck(this, BlockScoping);
      this.parent = parent;
      this.scope = scope;
      this.file = file;
      this.blockPath = blockPath;
      this.block = blockPath.node;
      this.outsideLetReferences = _Object$create(null);
      this.hasLetReferences = false;
      this.letReferences = _Object$create(null);
      this.body = [];
      if (loopPath) {
        this.loopParent = loopPath.parent;
        this.loopLabel = t.isLabeledStatement(this.loopParent) && this.loopParent.label;
        this.loopPath = loopPath;
        this.loop = loopPath.node;
      }
    }
    BlockScoping.prototype.run = function run() {
      var block = this.block;
      if (block._letDone)
        return;
      block._letDone = true;
      var needsClosure = this.getLetReferences();
      if (t.isFunction(this.parent) || t.isProgram(this.block)) {
        this.updateScopeInfo();
        return;
      }
      if (!this.hasLetReferences)
        return;
      if (needsClosure) {
        this.wrapClosure();
      } else {
        this.remap();
      }
      this.updateScopeInfo();
      if (this.loopLabel && !t.isLabeledStatement(this.loopParent)) {
        return t.labeledStatement(this.loopLabel, this.loop);
      }
    };
    BlockScoping.prototype.updateScopeInfo = function updateScopeInfo() {
      var scope = this.scope;
      var parentScope = scope.getFunctionParent();
      var letRefs = this.letReferences;
      for (var key in letRefs) {
        var ref = letRefs[key];
        var binding = scope.getBinding(ref.name);
        if (!binding)
          continue;
        if (binding.kind === "let" || binding.kind === "const") {
          binding.kind = "var";
          scope.moveBindingTo(ref.name, parentScope);
        }
      }
    };
    BlockScoping.prototype.remap = function remap() {
      var hasRemaps = false;
      var letRefs = this.letReferences;
      var scope = this.scope;
      var remaps = _Object$create(null);
      for (var key in letRefs) {
        var ref = letRefs[key];
        if (scope.parentHasBinding(key) || scope.hasGlobal(key)) {
          var uid = scope.generateUidIdentifier(ref.name).name;
          ref.name = uid;
          hasRemaps = true;
          remaps[key] = remaps[uid] = {
            binding: ref,
            uid: uid
          };
        }
      }
      if (!hasRemaps)
        return;
      var loop = this.loop;
      if (loop) {
        traverseReplace(loop.right, loop, scope, remaps);
        traverseReplace(loop.test, loop, scope, remaps);
        traverseReplace(loop.update, loop, scope, remaps);
      }
      this.blockPath.traverse(replaceVisitor, remaps);
    };
    BlockScoping.prototype.wrapClosure = function wrapClosure() {
      var block = this.block;
      var outsideRefs = this.outsideLetReferences;
      if (this.loop) {
        for (var _name5 in outsideRefs) {
          var id = outsideRefs[_name5];
          if (this.scope.hasGlobal(id.name) || this.scope.parentHasBinding(id.name)) {
            delete outsideRefs[id.name];
            delete this.letReferences[id.name];
            this.scope.rename(id.name);
            this.letReferences[id.name] = id;
            outsideRefs[id.name] = id;
          }
        }
      }
      this.has = this.checkLoop();
      this.hoistVarDeclarations();
      var params = _lodashObjectValues2["default"](outsideRefs);
      var args = _lodashObjectValues2["default"](outsideRefs);
      var fn = t.functionExpression(null, params, t.blockStatement(block.body));
      fn.shadow = true;
      this.addContinuations(fn);
      block.body = this.body;
      var ref = fn;
      if (this.loop) {
        ref = this.scope.generateUidIdentifier("loop");
        this.loopPath.insertBefore(t.variableDeclaration("var", [t.variableDeclarator(ref, fn)]));
      }
      var call = t.callExpression(ref, args);
      var ret = this.scope.generateUidIdentifier("ret");
      var hasYield = _babelTraverse2["default"].hasType(fn.body, this.scope, "YieldExpression", t.FUNCTION_TYPES);
      if (hasYield) {
        fn.generator = true;
        call = t.yieldExpression(call, true);
      }
      var hasAsync = _babelTraverse2["default"].hasType(fn.body, this.scope, "AwaitExpression", t.FUNCTION_TYPES);
      if (hasAsync) {
        fn.async = true;
        call = t.awaitExpression(call);
      }
      this.buildClosure(ret, call);
    };
    BlockScoping.prototype.buildClosure = function buildClosure(ret, call) {
      var has = this.has;
      if (has.hasReturn || has.hasBreakContinue) {
        this.buildHas(ret, call);
      } else {
        this.body.push(t.expressionStatement(call));
      }
    };
    BlockScoping.prototype.addContinuations = function addContinuations(fn) {
      var state = {
        reassignments: {},
        outsideReferences: this.outsideLetReferences
      };
      this.scope.traverse(fn, continuationVisitor, state);
      for (var i = 0; i < fn.params.length; i++) {
        var param = fn.params[i];
        if (!state.reassignments[param.name])
          continue;
        var newParam = this.scope.generateUidIdentifier(param.name);
        fn.params[i] = newParam;
        this.scope.rename(param.name, newParam.name, fn);
        fn.body.body.push(t.expressionStatement(t.assignmentExpression("=", param, newParam)));
      }
    };
    BlockScoping.prototype.getLetReferences = function getLetReferences() {
      var block = this.block;
      var declarators = [];
      if (this.loop) {
        var init = this.loop.left || this.loop.init;
        if (isBlockScoped(init)) {
          declarators.push(init);
          _lodashObjectExtend2["default"](this.outsideLetReferences, t.getBindingIdentifiers(init));
        }
      }
      if (block.body) {
        for (var i = 0; i < block.body.length; i++) {
          var declar = block.body[i];
          if (t.isClassDeclaration(declar) || t.isFunctionDeclaration(declar) || isBlockScoped(declar)) {
            var declarPath = this.blockPath.get("body")[i];
            if (isBlockScoped(declar)) {
              convertBlockScopedToVar(declarPath, block, this.scope);
            }
            declarators = declarators.concat(declar.declarations || declar);
          }
        }
      }
      for (var i = 0; i < declarators.length; i++) {
        var declar = declarators[i];
        var keys = t.getBindingIdentifiers(declar);
        _lodashObjectExtend2["default"](this.letReferences, keys);
        this.hasLetReferences = true;
      }
      if (!this.hasLetReferences)
        return;
      var state = {
        letReferences: this.letReferences,
        closurify: false,
        file: this.file
      };
      this.blockPath.traverse(letReferenceBlockVisitor, state);
      return state.closurify;
    };
    BlockScoping.prototype.checkLoop = function checkLoop() {
      var state = {
        hasBreakContinue: false,
        ignoreLabeless: false,
        inSwitchCase: false,
        innerLabels: [],
        hasReturn: false,
        isLoop: !!this.loop,
        map: {},
        LOOP_IGNORE: _Symbol()
      };
      this.blockPath.traverse(loopLabelVisitor, state);
      this.blockPath.traverse(loopVisitor, state);
      return state;
    };
    BlockScoping.prototype.hoistVarDeclarations = function hoistVarDeclarations() {
      this.blockPath.traverse(hoistVarDeclarationsVisitor, this);
    };
    BlockScoping.prototype.pushDeclar = function pushDeclar(node) {
      var declars = [];
      var names = t.getBindingIdentifiers(node);
      for (var _name6 in names) {
        declars.push(t.variableDeclarator(names[_name6]));
      }
      this.body.push(t.variableDeclaration(node.kind, declars));
      var replace = [];
      for (var i = 0; i < node.declarations.length; i++) {
        var declar = node.declarations[i];
        if (!declar.init)
          continue;
        var expr = t.assignmentExpression("=", declar.id, declar.init);
        replace.push(t.inherits(expr, declar));
      }
      return replace;
    };
    BlockScoping.prototype.buildHas = function buildHas(ret, call) {
      var body = this.body;
      body.push(t.variableDeclaration("var", [t.variableDeclarator(ret, call)]));
      var retCheck = undefined;
      var has = this.has;
      var cases = [];
      if (has.hasReturn) {
        retCheck = buildRetCheck({RETURN: ret});
      }
      if (has.hasBreakContinue) {
        for (var key in has.map) {
          cases.push(t.switchCase(t.stringLiteral(key), [has.map[key]]));
        }
        if (has.hasReturn) {
          cases.push(t.switchCase(null, [retCheck]));
        }
        if (cases.length === 1) {
          var single = cases[0];
          body.push(t.ifStatement(t.binaryExpression("===", ret, single.test), single.consequent[0]));
        } else {
          for (var i = 0; i < cases.length; i++) {
            var caseConsequent = cases[i].consequent[0];
            if (t.isBreakStatement(caseConsequent) && !caseConsequent.label) {
              caseConsequent.label = this.loopLabel = this.loopLabel || this.scope.generateUidIdentifier("loop");
            }
          }
          body.push(t.switchStatement(ret, cases));
        }
      } else {
        if (has.hasReturn) {
          body.push(retCheck);
        }
      }
    };
    return BlockScoping;
  })();
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("fc", ["74", "4", "5", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _Object$keys = $__require('74')["default"];
  var _interopRequireWildcard = $__require('4')["default"];
  var _babelTypes = $__require('5');
  var t = _interopRequireWildcard(_babelTypes);
  var hasOwn = Object.prototype.hasOwnProperty;
  exports.hoist = function(funPath) {
    t.assertFunction(funPath.node);
    var vars = {};
    function varDeclToExpr(vdec, includeIdentifiers) {
      t.assertVariableDeclaration(vdec);
      var exprs = [];
      vdec.declarations.forEach(function(dec) {
        vars[dec.id.name] = dec.id;
        if (dec.init) {
          exprs.push(t.assignmentExpression("=", dec.id, dec.init));
        } else if (includeIdentifiers) {
          exprs.push(dec.id);
        }
      });
      if (exprs.length === 0)
        return null;
      if (exprs.length === 1)
        return exprs[0];
      return t.sequenceExpression(exprs);
    }
    funPath.get("body").traverse({
      VariableDeclaration: {exit: function exit(path) {
          var expr = varDeclToExpr(path.node, false);
          if (expr === null) {
            path.remove();
          } else {
            path.replaceWith(t.expressionStatement(expr));
          }
          path.skip();
        }},
      ForStatement: function ForStatement(path) {
        var init = path.node.init;
        if (t.isVariableDeclaration(init)) {
          path.get("init").replaceWith(varDeclToExpr(init, false));
        }
      },
      ForXStatement: function ForXStatement(path) {
        var left = path.get("left");
        if (left.isVariableDeclaration()) {
          left.replaceWith(varDeclToExpr(left.node, true));
        }
      },
      FunctionDeclaration: function FunctionDeclaration(path) {
        var node = path.node;
        vars[node.id.name] = node.id;
        var assignment = t.expressionStatement(t.assignmentExpression("=", node.id, t.functionExpression(node.id, node.params, node.body, node.generator, node.expression)));
        if (path.parentPath.isBlockStatement()) {
          path.parentPath.unshiftContainer("body", assignment);
          path.remove();
        } else {
          path.replaceWith(assignment);
        }
        path.skip();
      },
      FunctionExpression: function FunctionExpression(path) {
        path.skip();
      }
    });
    var paramNames = {};
    funPath.get("params").forEach(function(paramPath) {
      var param = paramPath.node;
      if (t.isIdentifier(param)) {
        paramNames[param.name] = param;
      } else {}
    });
    var declarations = [];
    _Object$keys(vars).forEach(function(name) {
      if (!hasOwn.call(paramNames, name)) {
        declarations.push(t.variableDeclarator(vars[name], null));
      }
    });
    if (declarations.length === 0) {
      return null;
    }
    return t.variableDeclaration("var", declarations);
  };
  return module.exports;
});

$__System.registerDynamic("fd", ["a", "4", "@node/assert", "5", "@node/util", "fe", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireDefault = $__require('a')["default"];
  var _interopRequireWildcard = $__require('4')["default"];
  var _assert = $__require('@node/assert');
  var _assert2 = _interopRequireDefault(_assert);
  var _babelTypes = $__require('5');
  var t = _interopRequireWildcard(_babelTypes);
  var _util = $__require('@node/util');
  function Entry() {
    _assert2["default"].ok(this instanceof Entry);
  }
  function FunctionEntry(returnLoc) {
    Entry.call(this);
    t.assertLiteral(returnLoc);
    this.returnLoc = returnLoc;
  }
  _util.inherits(FunctionEntry, Entry);
  exports.FunctionEntry = FunctionEntry;
  function LoopEntry(breakLoc, continueLoc, label) {
    Entry.call(this);
    t.assertLiteral(breakLoc);
    t.assertLiteral(continueLoc);
    if (label) {
      t.assertIdentifier(label);
    } else {
      label = null;
    }
    this.breakLoc = breakLoc;
    this.continueLoc = continueLoc;
    this.label = label;
  }
  _util.inherits(LoopEntry, Entry);
  exports.LoopEntry = LoopEntry;
  function SwitchEntry(breakLoc) {
    Entry.call(this);
    t.assertLiteral(breakLoc);
    this.breakLoc = breakLoc;
  }
  _util.inherits(SwitchEntry, Entry);
  exports.SwitchEntry = SwitchEntry;
  function TryEntry(firstLoc, catchEntry, finallyEntry) {
    Entry.call(this);
    t.assertLiteral(firstLoc);
    if (catchEntry) {
      _assert2["default"].ok(catchEntry instanceof CatchEntry);
    } else {
      catchEntry = null;
    }
    if (finallyEntry) {
      _assert2["default"].ok(finallyEntry instanceof FinallyEntry);
    } else {
      finallyEntry = null;
    }
    _assert2["default"].ok(catchEntry || finallyEntry);
    this.firstLoc = firstLoc;
    this.catchEntry = catchEntry;
    this.finallyEntry = finallyEntry;
  }
  _util.inherits(TryEntry, Entry);
  exports.TryEntry = TryEntry;
  function CatchEntry(firstLoc, paramId) {
    Entry.call(this);
    t.assertLiteral(firstLoc);
    t.assertIdentifier(paramId);
    this.firstLoc = firstLoc;
    this.paramId = paramId;
  }
  _util.inherits(CatchEntry, Entry);
  exports.CatchEntry = CatchEntry;
  function FinallyEntry(firstLoc, afterLoc) {
    Entry.call(this);
    t.assertLiteral(firstLoc);
    t.assertLiteral(afterLoc);
    this.firstLoc = firstLoc;
    this.afterLoc = afterLoc;
  }
  _util.inherits(FinallyEntry, Entry);
  exports.FinallyEntry = FinallyEntry;
  function LabeledEntry(breakLoc, label) {
    Entry.call(this);
    t.assertLiteral(breakLoc);
    t.assertIdentifier(label);
    this.breakLoc = breakLoc;
    this.label = label;
  }
  _util.inherits(LabeledEntry, Entry);
  exports.LabeledEntry = LabeledEntry;
  function LeapManager(emitter) {
    _assert2["default"].ok(this instanceof LeapManager);
    var Emitter = $__require('fe').Emitter;
    _assert2["default"].ok(emitter instanceof Emitter);
    this.emitter = emitter;
    this.entryStack = [new FunctionEntry(emitter.finalLoc)];
  }
  var LMp = LeapManager.prototype;
  exports.LeapManager = LeapManager;
  LMp.withEntry = function(entry, callback) {
    _assert2["default"].ok(entry instanceof Entry);
    this.entryStack.push(entry);
    try {
      callback.call(this.emitter);
    } finally {
      var popped = this.entryStack.pop();
      _assert2["default"].strictEqual(popped, entry);
    }
  };
  LMp._findLeapLocation = function(property, label) {
    for (var i = this.entryStack.length - 1; i >= 0; --i) {
      var entry = this.entryStack[i];
      var loc = entry[property];
      if (loc) {
        if (label) {
          if (entry.label && entry.label.name === label.name) {
            return loc;
          }
        } else if (entry instanceof LabeledEntry) {} else {
          return loc;
        }
      }
    }
    return null;
  };
  LMp.getBreakLoc = function(label) {
    return this._findLeapLocation("breakLoc", label);
  };
  LMp.getContinueLoc = function(label) {
    return this._findLeapLocation("continueLoc", label);
  };
  return module.exports;
});

$__System.registerDynamic("ff", ["a", "4", "@node/assert", "5", "100", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireDefault = $__require('a')["default"];
  var _interopRequireWildcard = $__require('4')["default"];
  var _assert = $__require('@node/assert');
  var _assert2 = _interopRequireDefault(_assert);
  var _babelTypes = $__require('5');
  var t = _interopRequireWildcard(_babelTypes);
  var m = $__require('100').makeAccessor();
  var hasOwn = Object.prototype.hasOwnProperty;
  function makePredicate(propertyName, knownTypes) {
    function onlyChildren(node) {
      t.assertNode(node);
      var result = false;
      function check(child) {
        if (result) {} else if (Array.isArray(child)) {
          child.some(check);
        } else if (t.isNode(child)) {
          _assert2["default"].strictEqual(result, false);
          result = predicate(child);
        }
        return result;
      }
      var keys = t.VISITOR_KEYS[node.type];
      if (keys) {
        for (var i = 0; i < keys.length; i++) {
          var key = keys[i];
          var child = node[key];
          check(child);
        }
      }
      return result;
    }
    function predicate(node) {
      t.assertNode(node);
      var meta = m(node);
      if (hasOwn.call(meta, propertyName))
        return meta[propertyName];
      if (hasOwn.call(opaqueTypes, node.type))
        return meta[propertyName] = false;
      if (hasOwn.call(knownTypes, node.type))
        return meta[propertyName] = true;
      return meta[propertyName] = onlyChildren(node);
    }
    predicate.onlyChildren = onlyChildren;
    return predicate;
  }
  var opaqueTypes = {FunctionExpression: true};
  var sideEffectTypes = {
    CallExpression: true,
    ForInStatement: true,
    UnaryExpression: true,
    BinaryExpression: true,
    AssignmentExpression: true,
    UpdateExpression: true,
    NewExpression: true
  };
  var leapTypes = {
    YieldExpression: true,
    BreakStatement: true,
    ContinueStatement: true,
    ReturnStatement: true,
    ThrowStatement: true
  };
  for (var type in leapTypes) {
    if (hasOwn.call(leapTypes, type)) {
      sideEffectTypes[type] = leapTypes[type];
    }
  }
  exports.hasSideEffects = makePredicate("hasSideEffects", sideEffectTypes);
  exports.containsLeap = makePredicate("containsLeap", leapTypes);
  return module.exports;
});

$__System.registerDynamic("fe", ["a", "4", "@node/assert", "5", "fd", "ff", "101", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireDefault = $__require('a')["default"];
  var _interopRequireWildcard = $__require('4')["default"];
  var _assert = $__require('@node/assert');
  var _assert2 = _interopRequireDefault(_assert);
  var _babelTypes = $__require('5');
  var t = _interopRequireWildcard(_babelTypes);
  var _leap = $__require('fd');
  var leap = _interopRequireWildcard(_leap);
  var _meta = $__require('ff');
  var meta = _interopRequireWildcard(_meta);
  var _util = $__require('101');
  var util = _interopRequireWildcard(_util);
  var hasOwn = Object.prototype.hasOwnProperty;
  function Emitter(contextId) {
    _assert2["default"].ok(this instanceof Emitter);
    t.assertIdentifier(contextId);
    this.nextTempId = 0;
    this.contextId = contextId;
    this.listing = [];
    this.marked = [true];
    this.finalLoc = loc();
    this.tryEntries = [];
    this.leapManager = new leap.LeapManager(this);
  }
  var Ep = Emitter.prototype;
  exports.Emitter = Emitter;
  function loc() {
    return t.numericLiteral(-1);
  }
  Ep.mark = function(loc) {
    t.assertLiteral(loc);
    var index = this.listing.length;
    if (loc.value === -1) {
      loc.value = index;
    } else {
      _assert2["default"].strictEqual(loc.value, index);
    }
    this.marked[index] = true;
    return loc;
  };
  Ep.emit = function(node) {
    if (t.isExpression(node)) {
      node = t.expressionStatement(node);
    }
    t.assertStatement(node);
    this.listing.push(node);
  };
  Ep.emitAssign = function(lhs, rhs) {
    this.emit(this.assign(lhs, rhs));
    return lhs;
  };
  Ep.assign = function(lhs, rhs) {
    return t.expressionStatement(t.assignmentExpression("=", lhs, rhs));
  };
  Ep.contextProperty = function(name, computed) {
    return t.memberExpression(this.contextId, computed ? t.stringLiteral(name) : t.identifier(name), !!computed);
  };
  Ep.stop = function(rval) {
    if (rval) {
      this.setReturnValue(rval);
    }
    this.jump(this.finalLoc);
  };
  Ep.setReturnValue = function(valuePath) {
    t.assertExpression(valuePath.value);
    this.emitAssign(this.contextProperty("rval"), this.explodeExpression(valuePath));
  };
  Ep.clearPendingException = function(tryLoc, assignee) {
    t.assertLiteral(tryLoc);
    var catchCall = t.callExpression(this.contextProperty("catch", true), [tryLoc]);
    if (assignee) {
      this.emitAssign(assignee, catchCall);
    } else {
      this.emit(catchCall);
    }
  };
  Ep.jump = function(toLoc) {
    this.emitAssign(this.contextProperty("next"), toLoc);
    this.emit(t.breakStatement());
  };
  Ep.jumpIf = function(test, toLoc) {
    t.assertExpression(test);
    t.assertLiteral(toLoc);
    this.emit(t.ifStatement(test, t.blockStatement([this.assign(this.contextProperty("next"), toLoc), t.breakStatement()])));
  };
  Ep.jumpIfNot = function(test, toLoc) {
    t.assertExpression(test);
    t.assertLiteral(toLoc);
    var negatedTest = undefined;
    if (t.isUnaryExpression(test) && test.operator === "!") {
      negatedTest = test.argument;
    } else {
      negatedTest = t.unaryExpression("!", test);
    }
    this.emit(t.ifStatement(negatedTest, t.blockStatement([this.assign(this.contextProperty("next"), toLoc), t.breakStatement()])));
  };
  Ep.makeTempVar = function() {
    return this.contextProperty("t" + this.nextTempId++);
  };
  Ep.getContextFunction = function(id) {
    return t.functionExpression(id || null, [this.contextId], t.blockStatement([this.getDispatchLoop()]), false, false);
  };
  Ep.getDispatchLoop = function() {
    var self = this;
    var cases = [];
    var current = undefined;
    var alreadyEnded = false;
    self.listing.forEach(function(stmt, i) {
      if (self.marked.hasOwnProperty(i)) {
        cases.push(t.switchCase(t.numericLiteral(i), current = []));
        alreadyEnded = false;
      }
      if (!alreadyEnded) {
        current.push(stmt);
        if (t.isCompletionStatement(stmt))
          alreadyEnded = true;
      }
    });
    this.finalLoc.value = this.listing.length;
    cases.push(t.switchCase(this.finalLoc, []), t.switchCase(t.stringLiteral("end"), [t.returnStatement(t.callExpression(this.contextProperty("stop"), []))]));
    return t.whileStatement(t.numericLiteral(1), t.switchStatement(t.assignmentExpression("=", this.contextProperty("prev"), this.contextProperty("next")), cases));
  };
  Ep.getTryLocsList = function() {
    if (this.tryEntries.length === 0) {
      return null;
    }
    var lastLocValue = 0;
    return t.arrayExpression(this.tryEntries.map(function(tryEntry) {
      var thisLocValue = tryEntry.firstLoc.value;
      _assert2["default"].ok(thisLocValue >= lastLocValue, "try entries out of order");
      lastLocValue = thisLocValue;
      var ce = tryEntry.catchEntry;
      var fe = tryEntry.finallyEntry;
      var locs = [tryEntry.firstLoc, ce ? ce.firstLoc : null];
      if (fe) {
        locs[2] = fe.firstLoc;
        locs[3] = fe.afterLoc;
      }
      return t.arrayExpression(locs);
    }));
  };
  Ep.explode = function(path, ignoreResult) {
    var node = path.node;
    var self = this;
    t.assertNode(node);
    if (t.isDeclaration(node))
      throw getDeclError(node);
    if (t.isStatement(node))
      return self.explodeStatement(path);
    if (t.isExpression(node))
      return self.explodeExpression(path, ignoreResult);
    switch (node.type) {
      case "Program":
        return path.get("body").map(self.explodeStatement, self);
      case "VariableDeclarator":
        throw getDeclError(node);
      case "Property":
      case "SwitchCase":
      case "CatchClause":
        throw new Error(node.type + " nodes should be handled by their parents");
      default:
        throw new Error("unknown Node of type " + JSON.stringify(node.type));
    }
  };
  function getDeclError(node) {
    return new Error("all declarations should have been transformed into " + "assignments before the Exploder began its work: " + JSON.stringify(node));
  }
  Ep.explodeStatement = function(path, labelId) {
    var stmt = path.node;
    var self = this;
    var before = undefined,
        after = undefined,
        head = undefined;
    t.assertStatement(stmt);
    if (labelId) {
      t.assertIdentifier(labelId);
    } else {
      labelId = null;
    }
    if (t.isBlockStatement(stmt)) {
      path.get("body").forEach(function(path) {
        self.explodeStatement(path);
      });
      return;
    }
    if (!meta.containsLeap(stmt)) {
      self.emit(stmt);
      return;
    }
    switch (stmt.type) {
      case "ExpressionStatement":
        self.explodeExpression(path.get("expression"), true);
        break;
      case "LabeledStatement":
        after = loc();
        self.leapManager.withEntry(new leap.LabeledEntry(after, stmt.label), function() {
          self.explodeStatement(path.get("body"), stmt.label);
        });
        self.mark(after);
        break;
      case "WhileStatement":
        before = loc();
        after = loc();
        self.mark(before);
        self.jumpIfNot(self.explodeExpression(path.get("test")), after);
        self.leapManager.withEntry(new leap.LoopEntry(after, before, labelId), function() {
          self.explodeStatement(path.get("body"));
        });
        self.jump(before);
        self.mark(after);
        break;
      case "DoWhileStatement":
        var first = loc();
        var test = loc();
        after = loc();
        self.mark(first);
        self.leapManager.withEntry(new leap.LoopEntry(after, test, labelId), function() {
          self.explode(path.get("body"));
        });
        self.mark(test);
        self.jumpIf(self.explodeExpression(path.get("test")), first);
        self.mark(after);
        break;
      case "ForStatement":
        head = loc();
        var update = loc();
        after = loc();
        if (stmt.init) {
          self.explode(path.get("init"), true);
        }
        self.mark(head);
        if (stmt.test) {
          self.jumpIfNot(self.explodeExpression(path.get("test")), after);
        } else {}
        self.leapManager.withEntry(new leap.LoopEntry(after, update, labelId), function() {
          self.explodeStatement(path.get("body"));
        });
        self.mark(update);
        if (stmt.update) {
          self.explode(path.get("update"), true);
        }
        self.jump(head);
        self.mark(after);
        break;
      case "TypeCastExpression":
        return self.explodeExpression(path.get("expression"));
      case "ForInStatement":
        head = loc();
        after = loc();
        var keyIterNextFn = self.makeTempVar();
        self.emitAssign(keyIterNextFn, t.callExpression(util.runtimeProperty("keys"), [self.explodeExpression(path.get("right"))]));
        self.mark(head);
        var keyInfoTmpVar = self.makeTempVar();
        self.jumpIf(t.memberExpression(t.assignmentExpression("=", keyInfoTmpVar, t.callExpression(keyIterNextFn, [])), t.identifier("done"), false), after);
        self.emitAssign(stmt.left, t.memberExpression(keyInfoTmpVar, t.identifier("value"), false));
        self.leapManager.withEntry(new leap.LoopEntry(after, head, labelId), function() {
          self.explodeStatement(path.get("body"));
        });
        self.jump(head);
        self.mark(after);
        break;
      case "BreakStatement":
        self.emitAbruptCompletion({
          type: "break",
          target: self.leapManager.getBreakLoc(stmt.label)
        });
        break;
      case "ContinueStatement":
        self.emitAbruptCompletion({
          type: "continue",
          target: self.leapManager.getContinueLoc(stmt.label)
        });
        break;
      case "SwitchStatement":
        var disc = self.emitAssign(self.makeTempVar(), self.explodeExpression(path.get("discriminant")));
        after = loc();
        var defaultLoc = loc();
        var condition = defaultLoc;
        var caseLocs = [];
        var cases = stmt.cases || [];
        for (var i = cases.length - 1; i >= 0; --i) {
          var c = cases[i];
          t.assertSwitchCase(c);
          if (c.test) {
            condition = t.conditionalExpression(t.binaryExpression("===", disc, c.test), caseLocs[i] = loc(), condition);
          } else {
            caseLocs[i] = defaultLoc;
          }
        }
        var discriminant = path.get("discriminant");
        discriminant.replaceWith(condition);
        self.jump(self.explodeExpression(discriminant));
        self.leapManager.withEntry(new leap.SwitchEntry(after), function() {
          path.get("cases").forEach(function(casePath) {
            var i = casePath.key;
            self.mark(caseLocs[i]);
            casePath.get("consequent").forEach(function(path) {
              self.explodeStatement(path);
            });
          });
        });
        self.mark(after);
        if (defaultLoc.value === -1) {
          self.mark(defaultLoc);
          _assert2["default"].strictEqual(after.value, defaultLoc.value);
        }
        break;
      case "IfStatement":
        var elseLoc = stmt.alternate && loc();
        after = loc();
        self.jumpIfNot(self.explodeExpression(path.get("test")), elseLoc || after);
        self.explodeStatement(path.get("consequent"));
        if (elseLoc) {
          self.jump(after);
          self.mark(elseLoc);
          self.explodeStatement(path.get("alternate"));
        }
        self.mark(after);
        break;
      case "ReturnStatement":
        self.emitAbruptCompletion({
          type: "return",
          value: self.explodeExpression(path.get("argument"))
        });
        break;
      case "WithStatement":
        throw new Error("WithStatement not supported in generator functions.");
      case "TryStatement":
        after = loc();
        var handler = stmt.handler;
        var catchLoc = handler && loc();
        var catchEntry = catchLoc && new leap.CatchEntry(catchLoc, handler.param);
        var finallyLoc = stmt.finalizer && loc();
        var finallyEntry = finallyLoc && new leap.FinallyEntry(finallyLoc, after);
        var tryEntry = new leap.TryEntry(self.getUnmarkedCurrentLoc(), catchEntry, finallyEntry);
        self.tryEntries.push(tryEntry);
        self.updateContextPrevLoc(tryEntry.firstLoc);
        self.leapManager.withEntry(tryEntry, function() {
          self.explodeStatement(path.get("block"));
          if (catchLoc) {
            (function() {
              if (finallyLoc) {
                self.jump(finallyLoc);
              } else {
                self.jump(after);
              }
              self.updateContextPrevLoc(self.mark(catchLoc));
              var bodyPath = path.get("handler.body");
              var safeParam = self.makeTempVar();
              self.clearPendingException(tryEntry.firstLoc, safeParam);
              bodyPath.traverse(catchParamVisitor, {
                safeParam: safeParam,
                catchParamName: handler.param.name
              });
              self.leapManager.withEntry(catchEntry, function() {
                self.explodeStatement(bodyPath);
              });
            })();
          }
          if (finallyLoc) {
            self.updateContextPrevLoc(self.mark(finallyLoc));
            self.leapManager.withEntry(finallyEntry, function() {
              self.explodeStatement(path.get("finalizer"));
            });
            self.emit(t.returnStatement(t.callExpression(self.contextProperty("finish"), [finallyEntry.firstLoc])));
          }
        });
        self.mark(after);
        break;
      case "ThrowStatement":
        self.emit(t.throwStatement(self.explodeExpression(path.get("argument"))));
        break;
      default:
        throw new Error("unknown Statement of type " + JSON.stringify(stmt.type));
    }
  };
  var catchParamVisitor = {
    Identifier: function Identifier(path, state) {
      if (path.node.name === state.catchParamName && util.isReference(path)) {
        path.replaceWith(state.safeParam);
      }
    },
    Scope: function Scope(path, state) {
      if (path.scope.hasOwnBinding(state.catchParamName)) {
        path.skip();
      }
    }
  };
  Ep.emitAbruptCompletion = function(record) {
    if (!isValidCompletion(record)) {
      _assert2["default"].ok(false, "invalid completion record: " + JSON.stringify(record));
    }
    _assert2["default"].notStrictEqual(record.type, "normal", "normal completions are not abrupt");
    var abruptArgs = [t.stringLiteral(record.type)];
    if (record.type === "break" || record.type === "continue") {
      t.assertLiteral(record.target);
      abruptArgs[1] = record.target;
    } else if (record.type === "return" || record.type === "throw") {
      if (record.value) {
        t.assertExpression(record.value);
        abruptArgs[1] = record.value;
      }
    }
    this.emit(t.returnStatement(t.callExpression(this.contextProperty("abrupt"), abruptArgs)));
  };
  function isValidCompletion(record) {
    var type = record.type;
    if (type === "normal") {
      return !hasOwn.call(record, "target");
    }
    if (type === "break" || type === "continue") {
      return !hasOwn.call(record, "value") && t.isLiteral(record.target);
    }
    if (type === "return" || type === "throw") {
      return hasOwn.call(record, "value") && !hasOwn.call(record, "target");
    }
    return false;
  }
  Ep.getUnmarkedCurrentLoc = function() {
    return t.numericLiteral(this.listing.length);
  };
  Ep.updateContextPrevLoc = function(loc) {
    if (loc) {
      t.assertLiteral(loc);
      if (loc.value === -1) {
        loc.value = this.listing.length;
      } else {
        _assert2["default"].strictEqual(loc.value, this.listing.length);
      }
    } else {
      loc = this.getUnmarkedCurrentLoc();
    }
    this.emitAssign(this.contextProperty("prev"), loc);
  };
  Ep.explodeExpression = function(path, ignoreResult) {
    var expr = path.node;
    if (expr) {
      t.assertExpression(expr);
    } else {
      return expr;
    }
    var self = this;
    var result = undefined;
    var after = undefined;
    function finish(expr) {
      t.assertExpression(expr);
      if (ignoreResult) {
        self.emit(expr);
      } else {
        return expr;
      }
    }
    if (!meta.containsLeap(expr)) {
      return finish(expr);
    }
    var hasLeapingChildren = meta.containsLeap.onlyChildren(expr);
    function explodeViaTempVar(tempVar, childPath, ignoreChildResult) {
      _assert2["default"].ok(!ignoreChildResult || !tempVar, "Ignoring the result of a child expression but forcing it to " + "be assigned to a temporary variable?");
      var result = self.explodeExpression(childPath, ignoreChildResult);
      if (ignoreChildResult) {} else if (tempVar || hasLeapingChildren && !t.isLiteral(result)) {
        result = self.emitAssign(tempVar || self.makeTempVar(), result);
      }
      return result;
    }
    switch (expr.type) {
      case "MemberExpression":
        return finish(t.memberExpression(self.explodeExpression(path.get("object")), expr.computed ? explodeViaTempVar(null, path.get("property")) : expr.property, expr.computed));
      case "CallExpression":
        var calleePath = path.get("callee");
        var argsPath = path.get("arguments");
        var newCallee = undefined;
        var newArgs = [];
        var hasLeapingArgs = false;
        argsPath.forEach(function(argPath) {
          hasLeapingArgs = hasLeapingArgs || meta.containsLeap(argPath.node);
        });
        if (t.isMemberExpression(calleePath.node)) {
          if (hasLeapingArgs) {
            var newObject = explodeViaTempVar(self.makeTempVar(), calleePath.get("object"));
            var newProperty = calleePath.node.computed ? explodeViaTempVar(null, calleePath.get("property")) : calleePath.node.property;
            newArgs.unshift(newObject);
            newCallee = t.memberExpression(t.memberExpression(newObject, newProperty, calleePath.node.computed), t.identifier("call"), false);
          } else {
            newCallee = self.explodeExpression(calleePath);
          }
        } else {
          newCallee = self.explodeExpression(calleePath);
          if (t.isMemberExpression(newCallee)) {
            newCallee = t.sequenceExpression([t.numericLiteral(0), newCallee]);
          }
        }
        argsPath.forEach(function(argPath) {
          newArgs.push(explodeViaTempVar(null, argPath));
        });
        return finish(t.callExpression(newCallee, newArgs));
      case "NewExpression":
        return finish(t.newExpression(explodeViaTempVar(null, path.get("callee")), path.get("arguments").map(function(argPath) {
          return explodeViaTempVar(null, argPath);
        })));
      case "ObjectExpression":
        return finish(t.objectExpression(path.get("properties").map(function(propPath) {
          if (propPath.isObjectProperty()) {
            return t.objectProperty(propPath.node.key, explodeViaTempVar(null, propPath.get("value")), propPath.node.computed);
          } else {
            return propPath.node;
          }
        })));
      case "ArrayExpression":
        return finish(t.arrayExpression(path.get("elements").map(function(elemPath) {
          return explodeViaTempVar(null, elemPath);
        })));
      case "SequenceExpression":
        var lastIndex = expr.expressions.length - 1;
        path.get("expressions").forEach(function(exprPath) {
          if (exprPath.key === lastIndex) {
            result = self.explodeExpression(exprPath, ignoreResult);
          } else {
            self.explodeExpression(exprPath, true);
          }
        });
        return result;
      case "LogicalExpression":
        after = loc();
        if (!ignoreResult) {
          result = self.makeTempVar();
        }
        var left = explodeViaTempVar(result, path.get("left"));
        if (expr.operator === "&&") {
          self.jumpIfNot(left, after);
        } else {
          _assert2["default"].strictEqual(expr.operator, "||");
          self.jumpIf(left, after);
        }
        explodeViaTempVar(result, path.get("right"), ignoreResult);
        self.mark(after);
        return result;
      case "ConditionalExpression":
        var elseLoc = loc();
        after = loc();
        var test = self.explodeExpression(path.get("test"));
        self.jumpIfNot(test, elseLoc);
        if (!ignoreResult) {
          result = self.makeTempVar();
        }
        explodeViaTempVar(result, path.get("consequent"), ignoreResult);
        self.jump(after);
        self.mark(elseLoc);
        explodeViaTempVar(result, path.get("alternate"), ignoreResult);
        self.mark(after);
        return result;
      case "UnaryExpression":
        return finish(t.unaryExpression(expr.operator, self.explodeExpression(path.get("argument")), !!expr.prefix));
      case "BinaryExpression":
        return finish(t.binaryExpression(expr.operator, explodeViaTempVar(null, path.get("left")), explodeViaTempVar(null, path.get("right"))));
      case "AssignmentExpression":
        return finish(t.assignmentExpression(expr.operator, self.explodeExpression(path.get("left")), self.explodeExpression(path.get("right"))));
      case "UpdateExpression":
        return finish(t.updateExpression(expr.operator, self.explodeExpression(path.get("argument")), expr.prefix));
      case "YieldExpression":
        after = loc();
        var arg = expr.argument && self.explodeExpression(path.get("argument"));
        if (arg && expr.delegate) {
          var _result = self.makeTempVar();
          self.emit(t.returnStatement(t.callExpression(self.contextProperty("delegateYield"), [arg, t.stringLiteral(_result.property.name), after])));
          self.mark(after);
          return _result;
        }
        self.emitAssign(self.contextProperty("next"), after);
        self.emit(t.returnStatement(arg || null));
        self.mark(after);
        return self.contextProperty("sent");
      default:
        throw new Error("unknown Expression of type " + JSON.stringify(expr.type));
    }
  };
  return module.exports;
});

$__System.registerDynamic("102", ["103", "104", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  $__require('103')('getOwnPropertyNames', function() {
    return $__require('104').get;
  });
  return module.exports;
});

$__System.registerDynamic("105", ["4f", "102", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var $ = $__require('4f');
  $__require('102');
  module.exports = function getOwnPropertyNames(it) {
    return $.getNames(it);
  };
  return module.exports;
});

$__System.registerDynamic("106", ["105", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  module.exports = {
    "default": $__require('105'),
    __esModule: true
  };
  return module.exports;
});

$__System.registerDynamic("107", ["108", "103", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var toIObject = $__require('108');
  $__require('103')('getOwnPropertyDescriptor', function($getOwnPropertyDescriptor) {
    return function getOwnPropertyDescriptor(it, key) {
      return $getOwnPropertyDescriptor(toIObject(it), key);
    };
  });
  return module.exports;
});

$__System.registerDynamic("109", ["4f", "107", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var $ = $__require('4f');
  $__require('107');
  module.exports = function getOwnPropertyDescriptor(it, key) {
    return $.getDesc(it, key);
  };
  return module.exports;
});

$__System.registerDynamic("10a", ["109", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  module.exports = {
    "default": $__require('109'),
    __esModule: true
  };
  return module.exports;
});

$__System.registerDynamic("10b", ["106", "10a", "10c", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _Object$getOwnPropertyNames = $__require('106')["default"];
  var _Object$getOwnPropertyDescriptor = $__require('10a')["default"];
  var _Object$defineProperty = $__require('10c')["default"];
  exports["default"] = function(obj, defaults) {
    var keys = _Object$getOwnPropertyNames(defaults);
    for (var i = 0; i < keys.length; i++) {
      var key = keys[i];
      var value = _Object$getOwnPropertyDescriptor(defaults, key);
      if (value && value.configurable && obj[key] === undefined) {
        _Object$defineProperty(obj, key, value);
      }
    }
    return obj;
  };
  exports.__esModule = true;
  return module.exports;
});

$__System.registerDynamic("10d", ["3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  exports["default"] = function(obj, defaults) {
    var newObj = defaults({}, obj);
    delete newObj["default"];
    return newObj;
  };
  exports.__esModule = true;
  return module.exports;
});

$__System.registerDynamic("10e", [], true, function($__require, exports, module) {
  "use strict";
  ;
  var define,
      global = this,
      GLOBAL = this;
  module.exports = function toFastProperties(obj) {
    function f() {}
    f.prototype = obj;
    new f();
    return;
    eval(obj);
  };
  return module.exports;
});

$__System.registerDynamic("10f", ["3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  function compact(array) {
    var index = -1,
        length = array ? array.length : 0,
        resIndex = -1,
        result = [];
    while (++index < length) {
      var value = array[index];
      if (value) {
        result[++resIndex] = value;
      }
    }
    return result;
  }
  module.exports = compact;
  return module.exports;
});

$__System.registerDynamic("110", ["111", "f7", "112", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var getLength = $__require('111'),
      isLength = $__require('f7'),
      toObject = $__require('112');
  function createBaseEach(eachFunc, fromRight) {
    return function(collection, iteratee) {
      var length = collection ? getLength(collection) : 0;
      if (!isLength(length)) {
        return eachFunc(collection, iteratee);
      }
      var index = fromRight ? length : -1,
          iterable = toObject(collection);
      while ((fromRight ? index-- : ++index < length)) {
        if (iteratee(iterable[index], index, iterable) === false) {
          break;
        }
      }
      return collection;
    };
  }
  module.exports = createBaseEach;
  return module.exports;
});

$__System.registerDynamic("91", ["113", "110", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var baseForOwn = $__require('113'),
      createBaseEach = $__require('110');
  var baseEach = createBaseEach(baseForOwn);
  module.exports = baseEach;
  return module.exports;
});

$__System.registerDynamic("114", ["f2", "39", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var bindCallback = $__require('f2'),
      isArray = $__require('39');
  function createForEach(arrayFunc, eachFunc) {
    return function(collection, iteratee, thisArg) {
      return (typeof iteratee == 'function' && thisArg === undefined && isArray(collection)) ? arrayFunc(collection, iteratee) : eachFunc(collection, bindCallback(iteratee, thisArg, 3));
    };
  }
  module.exports = createForEach;
  return module.exports;
});

$__System.registerDynamic("115", ["3e", "91", "114", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var arrayEach = $__require('3e'),
      baseEach = $__require('91'),
      createForEach = $__require('114');
  var forEach = createForEach(arrayEach, baseEach);
  module.exports = forEach;
  return module.exports;
});

$__System.registerDynamic("94", ["115", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  module.exports = $__require('115');
  return module.exports;
});

$__System.registerDynamic("116", ["117", "112", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var baseIsEqual = $__require('117'),
      toObject = $__require('112');
  function baseIsMatch(object, matchData, customizer) {
    var index = matchData.length,
        length = index,
        noCustomizer = !customizer;
    if (object == null) {
      return !length;
    }
    object = toObject(object);
    while (index--) {
      var data = matchData[index];
      if ((noCustomizer && data[2]) ? data[1] !== object[data[0]] : !(data[0] in object)) {
        return false;
      }
    }
    while (++index < length) {
      data = matchData[index];
      var key = data[0],
          objValue = object[key],
          srcValue = data[1];
      if (noCustomizer && data[2]) {
        if (objValue === undefined && !(key in object)) {
          return false;
        }
      } else {
        var result = customizer ? customizer(objValue, srcValue, key) : undefined;
        if (!(result === undefined ? baseIsEqual(srcValue, objValue, customizer, true) : result)) {
          return false;
        }
      }
    }
    return true;
  }
  module.exports = baseIsMatch;
  return module.exports;
});

$__System.registerDynamic("118", ["41", "112", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var keys = $__require('41'),
      toObject = $__require('112');
  function pairs(object) {
    object = toObject(object);
    var index = -1,
        props = keys(object),
        length = props.length,
        result = Array(length);
    while (++index < length) {
      var key = props[index];
      result[index] = [key, object[key]];
    }
    return result;
  }
  module.exports = pairs;
  return module.exports;
});

$__System.registerDynamic("119", ["11a", "118", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var isStrictComparable = $__require('11a'),
      pairs = $__require('118');
  function getMatchData(object) {
    var result = pairs(object),
        length = result.length;
    while (length--) {
      result[length][2] = isStrictComparable(result[length][1]);
    }
    return result;
  }
  module.exports = getMatchData;
  return module.exports;
});

$__System.registerDynamic("11b", ["116", "119", "112", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var baseIsMatch = $__require('116'),
      getMatchData = $__require('119'),
      toObject = $__require('112');
  function baseMatches(source) {
    var matchData = getMatchData(source);
    if (matchData.length == 1 && matchData[0][2]) {
      var key = matchData[0][0],
          value = matchData[0][1];
      return function(object) {
        if (object == null) {
          return false;
        }
        return object[key] === value && (value !== undefined || (key in toObject(object)));
      };
    }
    return function(object) {
      return baseIsMatch(object, matchData);
    };
  }
  module.exports = baseMatches;
  return module.exports;
});

$__System.registerDynamic("11c", ["3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  function arraySome(array, predicate) {
    var index = -1,
        length = array.length;
    while (++index < length) {
      if (predicate(array[index], index, array)) {
        return true;
      }
    }
    return false;
  }
  module.exports = arraySome;
  return module.exports;
});

$__System.registerDynamic("11d", ["11c", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var arraySome = $__require('11c');
  function equalArrays(array, other, equalFunc, customizer, isLoose, stackA, stackB) {
    var index = -1,
        arrLength = array.length,
        othLength = other.length;
    if (arrLength != othLength && !(isLoose && othLength > arrLength)) {
      return false;
    }
    while (++index < arrLength) {
      var arrValue = array[index],
          othValue = other[index],
          result = customizer ? customizer(isLoose ? othValue : arrValue, isLoose ? arrValue : othValue, index) : undefined;
      if (result !== undefined) {
        if (result) {
          continue;
        }
        return false;
      }
      if (isLoose) {
        if (!arraySome(other, function(othValue) {
          return arrValue === othValue || equalFunc(arrValue, othValue, customizer, isLoose, stackA, stackB);
        })) {
          return false;
        }
      } else if (!(arrValue === othValue || equalFunc(arrValue, othValue, customizer, isLoose, stackA, stackB))) {
        return false;
      }
    }
    return true;
  }
  module.exports = equalArrays;
  return module.exports;
});

$__System.registerDynamic("11e", ["3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var boolTag = '[object Boolean]',
      dateTag = '[object Date]',
      errorTag = '[object Error]',
      numberTag = '[object Number]',
      regexpTag = '[object RegExp]',
      stringTag = '[object String]';
  function equalByTag(object, other, tag) {
    switch (tag) {
      case boolTag:
      case dateTag:
        return +object == +other;
      case errorTag:
        return object.name == other.name && object.message == other.message;
      case numberTag:
        return (object != +object) ? other != +other : object == +other;
      case regexpTag:
      case stringTag:
        return object == (other + '');
    }
    return false;
  }
  module.exports = equalByTag;
  return module.exports;
});

$__System.registerDynamic("11f", ["41", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var keys = $__require('41');
  var objectProto = Object.prototype;
  var hasOwnProperty = objectProto.hasOwnProperty;
  function equalObjects(object, other, equalFunc, customizer, isLoose, stackA, stackB) {
    var objProps = keys(object),
        objLength = objProps.length,
        othProps = keys(other),
        othLength = othProps.length;
    if (objLength != othLength && !isLoose) {
      return false;
    }
    var index = objLength;
    while (index--) {
      var key = objProps[index];
      if (!(isLoose ? key in other : hasOwnProperty.call(other, key))) {
        return false;
      }
    }
    var skipCtor = isLoose;
    while (++index < objLength) {
      key = objProps[index];
      var objValue = object[key],
          othValue = other[key],
          result = customizer ? customizer(isLoose ? othValue : objValue, isLoose ? objValue : othValue, key) : undefined;
      if (!(result === undefined ? equalFunc(objValue, othValue, customizer, isLoose, stackA, stackB) : result)) {
        return false;
      }
      skipCtor || (skipCtor = key == 'constructor');
    }
    if (!skipCtor) {
      var objCtor = object.constructor,
          othCtor = other.constructor;
      if (objCtor != othCtor && ('constructor' in object && 'constructor' in other) && !(typeof objCtor == 'function' && objCtor instanceof objCtor && typeof othCtor == 'function' && othCtor instanceof othCtor)) {
        return false;
      }
    }
    return true;
  }
  module.exports = equalObjects;
  return module.exports;
});

$__System.registerDynamic("3c", ["f7", "40", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var isLength = $__require('f7'),
      isObjectLike = $__require('40');
  var argsTag = '[object Arguments]',
      arrayTag = '[object Array]',
      boolTag = '[object Boolean]',
      dateTag = '[object Date]',
      errorTag = '[object Error]',
      funcTag = '[object Function]',
      mapTag = '[object Map]',
      numberTag = '[object Number]',
      objectTag = '[object Object]',
      regexpTag = '[object RegExp]',
      setTag = '[object Set]',
      stringTag = '[object String]',
      weakMapTag = '[object WeakMap]';
  var arrayBufferTag = '[object ArrayBuffer]',
      float32Tag = '[object Float32Array]',
      float64Tag = '[object Float64Array]',
      int8Tag = '[object Int8Array]',
      int16Tag = '[object Int16Array]',
      int32Tag = '[object Int32Array]',
      uint8Tag = '[object Uint8Array]',
      uint8ClampedTag = '[object Uint8ClampedArray]',
      uint16Tag = '[object Uint16Array]',
      uint32Tag = '[object Uint32Array]';
  var typedArrayTags = {};
  typedArrayTags[float32Tag] = typedArrayTags[float64Tag] = typedArrayTags[int8Tag] = typedArrayTags[int16Tag] = typedArrayTags[int32Tag] = typedArrayTags[uint8Tag] = typedArrayTags[uint8ClampedTag] = typedArrayTags[uint16Tag] = typedArrayTags[uint32Tag] = true;
  typedArrayTags[argsTag] = typedArrayTags[arrayTag] = typedArrayTags[arrayBufferTag] = typedArrayTags[boolTag] = typedArrayTags[dateTag] = typedArrayTags[errorTag] = typedArrayTags[funcTag] = typedArrayTags[mapTag] = typedArrayTags[numberTag] = typedArrayTags[objectTag] = typedArrayTags[regexpTag] = typedArrayTags[setTag] = typedArrayTags[stringTag] = typedArrayTags[weakMapTag] = false;
  var objectProto = Object.prototype;
  var objToString = objectProto.toString;
  function isTypedArray(value) {
    return isObjectLike(value) && isLength(value.length) && !!typedArrayTags[objToString.call(value)];
  }
  module.exports = isTypedArray;
  return module.exports;
});

$__System.registerDynamic("120", ["11d", "11e", "11f", "39", "3c", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var equalArrays = $__require('11d'),
      equalByTag = $__require('11e'),
      equalObjects = $__require('11f'),
      isArray = $__require('39'),
      isTypedArray = $__require('3c');
  var argsTag = '[object Arguments]',
      arrayTag = '[object Array]',
      objectTag = '[object Object]';
  var objectProto = Object.prototype;
  var hasOwnProperty = objectProto.hasOwnProperty;
  var objToString = objectProto.toString;
  function baseIsEqualDeep(object, other, equalFunc, customizer, isLoose, stackA, stackB) {
    var objIsArr = isArray(object),
        othIsArr = isArray(other),
        objTag = arrayTag,
        othTag = arrayTag;
    if (!objIsArr) {
      objTag = objToString.call(object);
      if (objTag == argsTag) {
        objTag = objectTag;
      } else if (objTag != objectTag) {
        objIsArr = isTypedArray(object);
      }
    }
    if (!othIsArr) {
      othTag = objToString.call(other);
      if (othTag == argsTag) {
        othTag = objectTag;
      } else if (othTag != objectTag) {
        othIsArr = isTypedArray(other);
      }
    }
    var objIsObj = objTag == objectTag,
        othIsObj = othTag == objectTag,
        isSameTag = objTag == othTag;
    if (isSameTag && !(objIsArr || objIsObj)) {
      return equalByTag(object, other, objTag);
    }
    if (!isLoose) {
      var objIsWrapped = objIsObj && hasOwnProperty.call(object, '__wrapped__'),
          othIsWrapped = othIsObj && hasOwnProperty.call(other, '__wrapped__');
      if (objIsWrapped || othIsWrapped) {
        return equalFunc(objIsWrapped ? object.value() : object, othIsWrapped ? other.value() : other, customizer, isLoose, stackA, stackB);
      }
    }
    if (!isSameTag) {
      return false;
    }
    stackA || (stackA = []);
    stackB || (stackB = []);
    var length = stackA.length;
    while (length--) {
      if (stackA[length] == object) {
        return stackB[length] == other;
      }
    }
    stackA.push(object);
    stackB.push(other);
    var result = (objIsArr ? equalArrays : equalObjects)(object, other, equalFunc, customizer, isLoose, stackA, stackB);
    stackA.pop();
    stackB.pop();
    return result;
  }
  module.exports = baseIsEqualDeep;
  return module.exports;
});

$__System.registerDynamic("117", ["120", "3f", "40", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var baseIsEqualDeep = $__require('120'),
      isObject = $__require('3f'),
      isObjectLike = $__require('40');
  function baseIsEqual(value, other, customizer, isLoose, stackA, stackB) {
    if (value === other) {
      return true;
    }
    if (value == null || other == null || (!isObject(value) && !isObjectLike(other))) {
      return value !== value && other !== other;
    }
    return baseIsEqualDeep(value, other, baseIsEqual, customizer, isLoose, stackA, stackB);
  }
  module.exports = baseIsEqual;
  return module.exports;
});

$__System.registerDynamic("f4", ["3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  function baseSlice(array, start, end) {
    var index = -1,
        length = array.length;
    start = start == null ? 0 : (+start || 0);
    if (start < 0) {
      start = -start > length ? 0 : (length + start);
    }
    end = (end === undefined || end > length) ? length : (+end || 0);
    if (end < 0) {
      end += length;
    }
    length = start > end ? 0 : ((end - start) >>> 0);
    start >>>= 0;
    var result = Array(length);
    while (++index < length) {
      result[index] = array[index + start];
    }
    return result;
  }
  module.exports = baseSlice;
  return module.exports;
});

$__System.registerDynamic("11a", ["3f", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var isObject = $__require('3f');
  function isStrictComparable(value) {
    return value === value && !isObject(value);
  }
  module.exports = isStrictComparable;
  return module.exports;
});

$__System.registerDynamic("f8", ["3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  function last(array) {
    var length = array ? array.length : 0;
    return length ? array[length - 1] : undefined;
  }
  module.exports = last;
  return module.exports;
});

$__System.registerDynamic("121", ["f3", "117", "f4", "39", "f6", "11a", "f8", "112", "f9", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var baseGet = $__require('f3'),
      baseIsEqual = $__require('117'),
      baseSlice = $__require('f4'),
      isArray = $__require('39'),
      isKey = $__require('f6'),
      isStrictComparable = $__require('11a'),
      last = $__require('f8'),
      toObject = $__require('112'),
      toPath = $__require('f9');
  function baseMatchesProperty(path, srcValue) {
    var isArr = isArray(path),
        isCommon = isKey(path) && isStrictComparable(srcValue),
        pathKey = (path + '');
    path = toPath(path);
    return function(object) {
      if (object == null) {
        return false;
      }
      var key = pathKey;
      object = toObject(object);
      if ((isArr || !isCommon) && !(key in object)) {
        object = path.length == 1 ? object : baseGet(object, baseSlice(path, 0, -1));
        if (object == null) {
          return false;
        }
        key = last(path);
        object = toObject(object);
      }
      return object[key] === srcValue ? (srcValue !== undefined || (key in object)) : baseIsEqual(srcValue, object[key], undefined, true);
    };
  }
  module.exports = baseMatchesProperty;
  return module.exports;
});

$__System.registerDynamic("f3", ["112", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var toObject = $__require('112');
  function baseGet(object, path, pathKey) {
    if (object == null) {
      return;
    }
    if (pathKey !== undefined && pathKey in toObject(object)) {
      path = [pathKey];
    }
    var index = 0,
        length = path.length;
    while (object != null && index < length) {
      object = object[path[index++]];
    }
    return (index && index == length) ? object : undefined;
  }
  module.exports = baseGet;
  return module.exports;
});

$__System.registerDynamic("1e", ["3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  function baseToString(value) {
    return value == null ? '' : (value + '');
  }
  module.exports = baseToString;
  return module.exports;
});

$__System.registerDynamic("f9", ["1e", "39", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var baseToString = $__require('1e'),
      isArray = $__require('39');
  var rePropName = /[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\n\\]|\\.)*?)\2)\]/g;
  var reEscapeChar = /\\(\\)?/g;
  function toPath(value) {
    if (isArray(value)) {
      return value;
    }
    var result = [];
    baseToString(value).replace(rePropName, function(match, number, quote, string) {
      result.push(quote ? string.replace(reEscapeChar, '$1') : (number || match));
    });
    return result;
  }
  module.exports = toPath;
  return module.exports;
});

$__System.registerDynamic("122", ["f3", "f9", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var baseGet = $__require('f3'),
      toPath = $__require('f9');
  function basePropertyDeep(path) {
    var pathKey = (path + '');
    path = toPath(path);
    return function(object) {
      return baseGet(object, path, pathKey);
    };
  }
  module.exports = basePropertyDeep;
  return module.exports;
});

$__System.registerDynamic("f6", ["39", "112", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var isArray = $__require('39'),
      toObject = $__require('112');
  var reIsDeepProp = /\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\n\\]|\\.)*?\1)\]/,
      reIsPlainProp = /^\w*$/;
  function isKey(value, object) {
    var type = typeof value;
    if ((type == 'string' && reIsPlainProp.test(value)) || type == 'number') {
      return true;
    }
    if (isArray(value)) {
      return false;
    }
    var result = !reIsDeepProp.test(value);
    return result || (object != null && value in toObject(object));
  }
  module.exports = isKey;
  return module.exports;
});

$__System.registerDynamic("123", ["124", "122", "f6", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var baseProperty = $__require('124'),
      basePropertyDeep = $__require('122'),
      isKey = $__require('f6');
  function property(path) {
    return isKey(path) ? baseProperty(path) : basePropertyDeep(path);
  }
  module.exports = property;
  return module.exports;
});

$__System.registerDynamic("18", ["11b", "121", "f2", "125", "123", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var baseMatches = $__require('11b'),
      baseMatchesProperty = $__require('121'),
      bindCallback = $__require('f2'),
      identity = $__require('125'),
      property = $__require('123');
  function baseCallback(func, thisArg, argCount) {
    var type = typeof func;
    if (type == 'function') {
      return thisArg === undefined ? func : bindCallback(func, thisArg, argCount);
    }
    if (func == null) {
      return identity;
    }
    if (type == 'object') {
      return baseMatches(func);
    }
    return thisArg === undefined ? property(func) : baseMatchesProperty(func, thisArg);
  }
  module.exports = baseCallback;
  return module.exports;
});

$__System.registerDynamic("126", ["3f", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var isObject = $__require('3f');
  function cacheIndexOf(cache, value) {
    var data = cache.data,
        result = (typeof value == 'string' || isObject(value)) ? data.set.has(value) : data.hash[value];
    return result ? 0 : -1;
  }
  module.exports = cacheIndexOf;
  return module.exports;
});

$__System.registerDynamic("127", ["3f", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var isObject = $__require('3f');
  function cachePush(value) {
    var data = this.data;
    if (typeof value == 'string' || isObject(value)) {
      data.set.add(value);
    } else {
      data.hash[value] = true;
    }
  }
  module.exports = cachePush;
  return module.exports;
});

$__System.registerDynamic("128", ["127", "129", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var cachePush = $__require('127'),
      getNative = $__require('129');
  var Set = getNative(global, 'Set');
  var nativeCreate = getNative(Object, 'create');
  function SetCache(values) {
    var length = values ? values.length : 0;
    this.data = {
      'hash': nativeCreate(null),
      'set': new Set
    };
    while (length--) {
      this.push(values[length]);
    }
  }
  SetCache.prototype.push = cachePush;
  module.exports = SetCache;
  return module.exports;
});

$__System.registerDynamic("12a", ["128", "129", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var SetCache = $__require('128'),
      getNative = $__require('129');
  var Set = getNative(global, 'Set');
  var nativeCreate = getNative(Object, 'create');
  function createCache(values) {
    return (nativeCreate && Set) ? new SetCache(values) : null;
  }
  module.exports = createCache;
  return module.exports;
});

$__System.registerDynamic("12b", ["e5", "126", "12a", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var baseIndexOf = $__require('e5'),
      cacheIndexOf = $__require('126'),
      createCache = $__require('12a');
  var LARGE_ARRAY_SIZE = 200;
  function baseUniq(array, iteratee) {
    var index = -1,
        indexOf = baseIndexOf,
        length = array.length,
        isCommon = true,
        isLarge = isCommon && length >= LARGE_ARRAY_SIZE,
        seen = isLarge ? createCache() : null,
        result = [];
    if (seen) {
      indexOf = cacheIndexOf;
      isCommon = false;
    } else {
      isLarge = false;
      seen = iteratee ? [] : result;
    }
    outer: while (++index < length) {
      var value = array[index],
          computed = iteratee ? iteratee(value, index, array) : value;
      if (isCommon && value === value) {
        var seenIndex = seen.length;
        while (seenIndex--) {
          if (seen[seenIndex] === computed) {
            continue outer;
          }
        }
        if (iteratee) {
          seen.push(computed);
        }
        result.push(value);
      } else if (indexOf(seen, computed, 0) < 0) {
        if (iteratee || isLarge) {
          seen.push(computed);
        }
        result.push(value);
      }
    }
    return result;
  }
  module.exports = baseUniq;
  return module.exports;
});

$__System.registerDynamic("12c", ["3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  function sortedUniq(array, iteratee) {
    var seen,
        index = -1,
        length = array.length,
        resIndex = -1,
        result = [];
    while (++index < length) {
      var value = array[index],
          computed = iteratee ? iteratee(value, index, array) : value;
      if (!index || seen !== computed) {
        seen = computed;
        result[++resIndex] = value;
      }
    }
    return result;
  }
  module.exports = sortedUniq;
  return module.exports;
});

$__System.registerDynamic("12d", ["18", "12b", "1a", "12c", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var baseCallback = $__require('18'),
      baseUniq = $__require('12b'),
      isIterateeCall = $__require('1a'),
      sortedUniq = $__require('12c');
  function uniq(array, isSorted, iteratee, thisArg) {
    var length = array ? array.length : 0;
    if (!length) {
      return [];
    }
    if (isSorted != null && typeof isSorted != 'boolean') {
      thisArg = iteratee;
      iteratee = isIterateeCall(array, isSorted, thisArg) ? undefined : isSorted;
      isSorted = false;
    }
    iteratee = iteratee == null ? iteratee : baseCallback(iteratee, thisArg, 3);
    return (isSorted) ? sortedUniq(array, iteratee) : baseUniq(array, iteratee);
  }
  module.exports = uniq;
  return module.exports;
});

$__System.registerDynamic("12e", ["4", "a", "5", "12f", "130"], true, function($__require, exports, module) {
  "use strict";
  ;
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireWildcard = $__require('4')["default"];
  var _interopRequireDefault = $__require('a')["default"];
  var _index = $__require('5');
  var t = _interopRequireWildcard(_index);
  var _constants = $__require('12f');
  var _index2 = $__require('130');
  var _index3 = _interopRequireDefault(_index2);
  _index3["default"]("ArrayExpression", {
    fields: {elements: {
        validate: _index2.chain(_index2.assertValueType("array"), _index2.assertEach(_index2.assertNodeOrValueType("null", "Expression", "SpreadElement"))),
        "default": []
      }},
    visitor: ["elements"],
    aliases: ["Expression"]
  });
  _index3["default"]("AssignmentExpression", {
    fields: {
      operator: {validate: _index2.assertValueType("string")},
      left: {validate: _index2.assertNodeType("LVal")},
      right: {validate: _index2.assertNodeType("Expression")}
    },
    builder: ["operator", "left", "right"],
    visitor: ["left", "right"],
    aliases: ["Expression"]
  });
  _index3["default"]("BinaryExpression", {
    builder: ["operator", "left", "right"],
    fields: {
      operator: {validate: _index2.assertOneOf.apply(undefined, _constants.BINARY_OPERATORS)},
      left: {validate: _index2.assertNodeType("Expression")},
      right: {validate: _index2.assertNodeType("Expression")}
    },
    visitor: ["left", "right"],
    aliases: ["Binary", "Expression"]
  });
  _index3["default"]("Directive", {
    visitor: ["value"],
    fields: {value: {validate: _index2.assertNodeType("DirectiveLiteral")}}
  });
  _index3["default"]("DirectiveLiteral", {
    builder: ["value"],
    fields: {value: {validate: _index2.assertValueType("string")}}
  });
  _index3["default"]("BlockStatement", {
    builder: ["body", "directives"],
    visitor: ["directives", "body"],
    fields: {
      directives: {
        validate: _index2.chain(_index2.assertValueType("array"), _index2.assertEach(_index2.assertNodeType("Directive"))),
        "default": []
      },
      body: {validate: _index2.chain(_index2.assertValueType("array"), _index2.assertEach(_index2.assertNodeType("Statement")))}
    },
    aliases: ["Scopable", "BlockParent", "Block", "Statement"]
  });
  _index3["default"]("BreakStatement", {
    visitor: ["label"],
    fields: {label: {
        validate: _index2.assertNodeType("Identifier"),
        optional: true
      }},
    aliases: ["Statement", "Terminatorless", "CompletionStatement"]
  });
  _index3["default"]("CallExpression", {
    visitor: ["callee", "arguments"],
    fields: {
      callee: {validate: _index2.assertNodeType("Expression")},
      arguments: {validate: _index2.chain(_index2.assertValueType("array"), _index2.assertEach(_index2.assertNodeType("Expression", "SpreadElement")))}
    },
    aliases: ["Expression"]
  });
  _index3["default"]("CatchClause", {
    visitor: ["param", "body"],
    fields: {
      param: {validate: _index2.assertNodeType("Identifier")},
      body: {validate: _index2.assertNodeType("BlockStatement")}
    },
    aliases: ["Scopable"]
  });
  _index3["default"]("ConditionalExpression", {
    visitor: ["test", "consequent", "alternate"],
    fields: {
      test: {validate: _index2.assertNodeType("Expression")},
      consequent: {validate: _index2.assertNodeType("Expression")},
      alternate: {validate: _index2.assertNodeType("Expression")}
    },
    aliases: ["Expression", "Conditional"]
  });
  _index3["default"]("ContinueStatement", {
    visitor: ["label"],
    fields: {label: {
        validate: _index2.assertNodeType("Identifier"),
        optional: true
      }},
    aliases: ["Statement", "Terminatorless", "CompletionStatement"]
  });
  _index3["default"]("DebuggerStatement", {aliases: ["Statement"]});
  _index3["default"]("DoWhileStatement", {
    visitor: ["test", "body"],
    fields: {
      test: {validate: _index2.assertNodeType("Expression")},
      body: {validate: _index2.assertNodeType("Statement")}
    },
    aliases: ["Statement", "BlockParent", "Loop", "While", "Scopable"]
  });
  _index3["default"]("EmptyStatement", {aliases: ["Statement"]});
  _index3["default"]("ExpressionStatement", {
    visitor: ["expression"],
    fields: {expression: {validate: _index2.assertNodeType("Expression")}},
    aliases: ["Statement", "ExpressionWrapper"]
  });
  _index3["default"]("File", {
    builder: ["program", "comments", "tokens"],
    visitor: ["program"],
    fields: {program: {validate: _index2.assertNodeType("Program")}}
  });
  _index3["default"]("ForInStatement", {
    visitor: ["left", "right", "body"],
    aliases: ["Scopable", "Statement", "For", "BlockParent", "Loop", "ForXStatement"],
    fields: {
      left: {validate: _index2.assertNodeType("VariableDeclaration", "LVal")},
      right: {validate: _index2.assertNodeType("Expression")},
      body: {validate: _index2.assertNodeType("Statement")}
    }
  });
  _index3["default"]("ForStatement", {
    visitor: ["init", "test", "update", "body"],
    aliases: ["Scopable", "Statement", "For", "BlockParent", "Loop"],
    fields: {
      init: {
        validate: _index2.assertNodeType("VariableDeclaration", "Expression"),
        optional: true
      },
      test: {
        validate: _index2.assertNodeType("Expression"),
        optional: true
      },
      update: {
        validate: _index2.assertNodeType("Expression"),
        optional: true
      },
      body: {validate: _index2.assertNodeType("Statement")}
    }
  });
  _index3["default"]("FunctionDeclaration", {
    builder: ["id", "params", "body", "generator", "async"],
    visitor: ["id", "params", "body", "returnType", "typeParameters"],
    fields: {
      id: {validate: _index2.assertNodeType("Identifier")},
      params: {validate: _index2.chain(_index2.assertValueType("array"), _index2.assertEach(_index2.assertNodeType("LVal")))},
      body: {validate: _index2.assertNodeType("BlockStatement")},
      generator: {
        "default": false,
        validate: _index2.assertValueType("boolean")
      },
      async: {
        "default": false,
        validate: _index2.assertValueType("boolean")
      }
    },
    aliases: ["Scopable", "Function", "BlockParent", "FunctionParent", "Statement", "Pureish", "Declaration"]
  });
  _index3["default"]("FunctionExpression", {
    inherits: "FunctionDeclaration",
    aliases: ["Scopable", "Function", "BlockParent", "FunctionParent", "Expression", "Pureish"],
    fields: {
      id: {
        validate: _index2.assertNodeType("Identifier"),
        optional: true
      },
      params: {validate: _index2.chain(_index2.assertValueType("array"), _index2.assertEach(_index2.assertNodeType("LVal")))},
      body: {validate: _index2.assertNodeType("BlockStatement")},
      generator: {
        "default": false,
        validate: _index2.assertValueType("boolean")
      },
      async: {
        "default": false,
        validate: _index2.assertValueType("boolean")
      }
    }
  });
  _index3["default"]("Identifier", {
    builder: ["name"],
    visitor: ["typeAnnotation"],
    aliases: ["Expression", "LVal"],
    fields: {name: {validate: function validate(node, key, val) {
          if (!t.isValidIdentifier(val)) {}
        }}}
  });
  _index3["default"]("IfStatement", {
    visitor: ["test", "consequent", "alternate"],
    aliases: ["Statement", "Conditional"],
    fields: {
      test: {validate: _index2.assertNodeType("Expression")},
      consequent: {validate: _index2.assertNodeType("Statement")},
      alternate: {
        optional: true,
        validate: _index2.assertNodeType("Statement")
      }
    }
  });
  _index3["default"]("LabeledStatement", {
    visitor: ["label", "body"],
    aliases: ["Statement"],
    fields: {
      label: {validate: _index2.assertNodeType("Identifier")},
      body: {validate: _index2.assertNodeType("Statement")}
    }
  });
  _index3["default"]("StringLiteral", {
    builder: ["value"],
    fields: {value: {validate: _index2.assertValueType("string")}},
    aliases: ["Expression", "Pureish", "Literal", "Immutable"]
  });
  _index3["default"]("NumericLiteral", {
    builder: ["value"],
    deprecatedAlias: "NumberLiteral",
    fields: {value: {validate: _index2.assertValueType("number")}},
    aliases: ["Expression", "Pureish", "Literal", "Immutable"]
  });
  _index3["default"]("NullLiteral", {aliases: ["Expression", "Pureish", "Literal", "Immutable"]});
  _index3["default"]("BooleanLiteral", {
    builder: ["value"],
    fields: {value: {validate: _index2.assertValueType("boolean")}},
    aliases: ["Expression", "Pureish", "Literal", "Immutable"]
  });
  _index3["default"]("RegExpLiteral", {
    builder: ["pattern", "flags"],
    deprecatedAlias: "RegexLiteral",
    aliases: ["Expression", "Literal"],
    fields: {
      pattern: {validate: _index2.assertValueType("string")},
      flags: {
        validate: _index2.assertValueType("string"),
        "default": ""
      }
    }
  });
  _index3["default"]("LogicalExpression", {
    builder: ["operator", "left", "right"],
    visitor: ["left", "right"],
    aliases: ["Binary", "Expression"],
    fields: {
      operator: {validate: _index2.assertOneOf.apply(undefined, _constants.LOGICAL_OPERATORS)},
      left: {validate: _index2.assertNodeType("Expression")},
      right: {validate: _index2.assertNodeType("Expression")}
    }
  });
  _index3["default"]("MemberExpression", {
    builder: ["object", "property", "computed"],
    visitor: ["object", "property"],
    aliases: ["Expression", "LVal"],
    fields: {
      object: {validate: _index2.assertNodeType("Expression")},
      property: {validate: function validate(node, key, val) {
          var expectedType = node.computed ? "Expression" : "Identifier";
          _index2.assertNodeType(expectedType)(node, key, val);
        }},
      computed: {"default": false}
    }
  });
  _index3["default"]("NewExpression", {
    visitor: ["callee", "arguments"],
    aliases: ["Expression"],
    fields: {
      callee: {validate: _index2.assertNodeType("Expression")},
      arguments: {validate: _index2.chain(_index2.assertValueType("array"), _index2.assertEach(_index2.assertNodeType("Expression", "SpreadElement")))}
    }
  });
  _index3["default"]("Program", {
    visitor: ["directives", "body"],
    builder: ["body", "directives"],
    fields: {
      directives: {
        validate: _index2.chain(_index2.assertValueType("array"), _index2.assertEach(_index2.assertNodeType("Directive"))),
        "default": []
      },
      body: {validate: _index2.chain(_index2.assertValueType("array"), _index2.assertEach(_index2.assertNodeType("Statement")))}
    },
    aliases: ["Scopable", "BlockParent", "Block", "FunctionParent"]
  });
  _index3["default"]("ObjectExpression", {
    visitor: ["properties"],
    aliases: ["Expression"],
    fields: {properties: {validate: _index2.chain(_index2.assertValueType("array"), _index2.assertEach(_index2.assertNodeType("ObjectMethod", "ObjectProperty", "SpreadProperty")))}}
  });
  _index3["default"]("ObjectMethod", {
    builder: ["kind", "key", "params", "body", "computed"],
    fields: {
      kind: {
        validate: _index2.chain(_index2.assertValueType("string"), _index2.assertOneOf("method", "get", "set")),
        "default": "method"
      },
      computed: {
        validate: _index2.assertValueType("boolean"),
        "default": false
      },
      key: {validate: function validate(node, key, val) {
          var expectedTypes = node.computed ? ["Expression"] : ["Identifier", "StringLiteral", "NumericLiteral"];
          _index2.assertNodeType.apply(undefined, expectedTypes)(node, key, val);
        }},
      decorators: {validate: _index2.chain(_index2.assertValueType("array"), _index2.assertEach(_index2.assertNodeType("Decorator")))},
      body: {validate: _index2.assertNodeType("BlockStatement")},
      generator: {
        "default": false,
        validate: _index2.assertValueType("boolean")
      },
      async: {
        "default": false,
        validate: _index2.assertValueType("boolean")
      }
    },
    visitor: ["key", "params", "body", "decorators", "returnType", "typeParameters"],
    aliases: ["UserWhitespacable", "Function", "Scopable", "BlockParent", "FunctionParent", "Method", "ObjectMember"]
  });
  _index3["default"]("ObjectProperty", {
    builder: ["key", "value", "computed", "shorthand", "decorators"],
    fields: {
      computed: {
        validate: _index2.assertValueType("boolean"),
        "default": false
      },
      key: {validate: function validate(node, key, val) {
          var expectedTypes = node.computed ? ["Expression"] : ["Identifier", "StringLiteral", "NumericLiteral"];
          _index2.assertNodeType.apply(undefined, expectedTypes)(node, key, val);
        }},
      value: {validate: _index2.assertNodeType("Expression")},
      shorthand: {
        validate: _index2.assertValueType("boolean"),
        "default": false
      },
      decorators: {
        validate: _index2.chain(_index2.assertValueType("array"), _index2.assertEach(_index2.assertNodeType("Decorator"))),
        optional: true
      }
    },
    visitor: ["key", "value", "decorators"],
    aliases: ["UserWhitespacable", "Property", "ObjectMember"]
  });
  _index3["default"]("RestElement", {
    visitor: ["argument", "typeAnnotation"],
    aliases: ["LVal"],
    fields: {argument: {validate: _index2.assertNodeType("LVal")}}
  });
  _index3["default"]("ReturnStatement", {
    visitor: ["argument"],
    aliases: ["Statement", "Terminatorless", "CompletionStatement"],
    fields: {argument: {
        validate: _index2.assertNodeType("Expression"),
        optional: true
      }}
  });
  _index3["default"]("SequenceExpression", {
    visitor: ["expressions"],
    fields: {expressions: {validate: _index2.chain(_index2.assertValueType("array"), _index2.assertEach(_index2.assertNodeType("Expression")))}},
    aliases: ["Expression"]
  });
  _index3["default"]("SwitchCase", {
    visitor: ["test", "consequent"],
    fields: {
      test: {
        validate: _index2.assertNodeType("Expression"),
        optional: true
      },
      consequent: {validate: _index2.chain(_index2.assertValueType("array"), _index2.assertEach(_index2.assertNodeType("Statement")))}
    }
  });
  _index3["default"]("SwitchStatement", {
    visitor: ["discriminant", "cases"],
    aliases: ["Statement", "BlockParent", "Scopable"],
    fields: {
      discriminant: {validate: _index2.assertNodeType("Expression")},
      cases: {validate: _index2.chain(_index2.assertValueType("array"), _index2.assertEach(_index2.assertNodeType("SwitchCase")))}
    }
  });
  _index3["default"]("ThisExpression", {aliases: ["Expression"]});
  _index3["default"]("ThrowStatement", {
    visitor: ["argument"],
    aliases: ["Statement", "Terminatorless", "CompletionStatement"],
    fields: {argument: {validate: _index2.assertNodeType("Expression")}}
  });
  _index3["default"]("TryStatement", {
    visitor: ["block", "handler", "finalizer"],
    aliases: ["Statement"],
    fields: {
      body: {validate: _index2.assertNodeType("BlockStatement")},
      handler: {
        optional: true,
        handler: _index2.assertNodeType("BlockStatement")
      },
      finalizer: {
        optional: true,
        validate: _index2.assertNodeType("BlockStatement")
      }
    }
  });
  _index3["default"]("UnaryExpression", {
    builder: ["operator", "argument", "prefix"],
    fields: {
      prefix: {"default": true},
      argument: {validate: _index2.assertNodeType("Expression")},
      operator: {validate: _index2.assertOneOf.apply(undefined, _constants.UNARY_OPERATORS)}
    },
    visitor: ["argument"],
    aliases: ["UnaryLike", "Expression"]
  });
  _index3["default"]("UpdateExpression", {
    builder: ["operator", "argument", "prefix"],
    fields: {
      prefix: {"default": false},
      argument: {validate: _index2.assertNodeType("Expression")},
      operator: {validate: _index2.assertOneOf.apply(undefined, _constants.UPDATE_OPERATORS)}
    },
    visitor: ["argument"],
    aliases: ["Expression"]
  });
  _index3["default"]("VariableDeclaration", {
    builder: ["kind", "declarations"],
    visitor: ["declarations"],
    aliases: ["Statement", "Declaration"],
    fields: {
      kind: {validate: _index2.chain(_index2.assertValueType("string"), _index2.assertOneOf("var", "let", "const"))},
      declarations: {validate: _index2.chain(_index2.assertValueType("array"), _index2.assertEach(_index2.assertNodeType("VariableDeclarator")))}
    }
  });
  _index3["default"]("VariableDeclarator", {
    visitor: ["id", "init"],
    fields: {
      id: {validate: _index2.assertNodeType("LVal")},
      init: {
        optional: true,
        validate: _index2.assertNodeType("Expression")
      }
    }
  });
  _index3["default"]("WhileStatement", {
    visitor: ["test", "body"],
    aliases: ["Statement", "BlockParent", "Loop", "While", "Scopable"],
    fields: {
      test: {validate: _index2.assertNodeType("Expression")},
      body: {validate: _index2.assertNodeType("BlockStatement", "Statement")}
    }
  });
  _index3["default"]("WithStatement", {
    visitor: ["object", "body"],
    aliases: ["Statement"],
    fields: {
      object: {object: _index2.assertNodeType("Expression")},
      body: {validate: _index2.assertNodeType("BlockStatement", "Statement")}
    }
  });
  return module.exports;
});

$__System.registerDynamic("131", ["a", "130"], true, function($__require, exports, module) {
  "use strict";
  ;
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireDefault = $__require('a')["default"];
  var _index = $__require('130');
  var _index2 = _interopRequireDefault(_index);
  _index2["default"]("AssignmentPattern", {
    visitor: ["left", "right"],
    aliases: ["Pattern", "LVal"],
    fields: {
      left: {validate: _index.assertNodeType("Identifier")},
      right: {validate: _index.assertNodeType("Expression")}
    }
  });
  _index2["default"]("ArrayPattern", {
    visitor: ["elements", "typeAnnotation"],
    aliases: ["Pattern", "LVal"],
    fields: {elements: {validate: _index.chain(_index.assertValueType("array"), _index.assertEach(_index.assertNodeType("Expression")))}}
  });
  _index2["default"]("ArrowFunctionExpression", {
    builder: ["params", "body", "async"],
    visitor: ["params", "body", "returnType"],
    aliases: ["Scopable", "Function", "BlockParent", "FunctionParent", "Expression", "Pureish"],
    fields: {
      params: {validate: _index.chain(_index.assertValueType("array"), _index.assertEach(_index.assertNodeType("LVal")))},
      body: {validate: _index.assertNodeType("BlockStatement", "Expression")},
      async: {
        validate: _index.assertValueType("boolean"),
        "default": false
      }
    }
  });
  _index2["default"]("ClassBody", {
    visitor: ["body"],
    fields: {body: {validate: _index.chain(_index.assertValueType("array"), _index.assertEach(_index.assertNodeType("ClassMethod", "ClassProperty")))}}
  });
  _index2["default"]("ClassDeclaration", {
    builder: ["id", "superClass", "body", "decorators"],
    visitor: ["id", "body", "superClass", "mixins", "typeParameters", "superTypeParameters", "implements", "decorators"],
    aliases: ["Scopable", "Class", "Statement", "Declaration", "Pureish"],
    fields: {
      id: {validate: _index.assertNodeType("Identifier")},
      body: {validate: _index.assertNodeType("ClassBody")},
      superClass: {
        optional: true,
        validate: _index.assertNodeType("Expression")
      },
      decorators: {validate: _index.chain(_index.assertValueType("array"), _index.assertEach(_index.assertNodeType("Decorator")))}
    }
  });
  _index2["default"]("ClassExpression", {
    inherits: "ClassDeclaration",
    aliases: ["Scopable", "Class", "Expression", "Pureish"],
    fields: {
      id: {
        optional: true,
        validate: _index.assertNodeType("Identifier")
      },
      body: {validate: _index.assertNodeType("ClassBody")},
      superClass: {
        optional: true,
        validate: _index.assertNodeType("Expression")
      },
      decorators: {validate: _index.chain(_index.assertValueType("array"), _index.assertEach(_index.assertNodeType("Decorator")))}
    }
  });
  _index2["default"]("ExportAllDeclaration", {
    visitor: ["source"],
    aliases: ["Statement", "Declaration", "ModuleDeclaration", "ExportDeclaration"],
    fields: {source: {validate: _index.assertNodeType("StringLiteral")}}
  });
  _index2["default"]("ExportDefaultDeclaration", {
    visitor: ["declaration"],
    aliases: ["Statement", "Declaration", "ModuleDeclaration", "ExportDeclaration"],
    fields: {declaration: {validate: _index.assertNodeType("FunctionDeclaration", "ClassDeclaration", "Expression")}}
  });
  _index2["default"]("ExportNamedDeclaration", {
    visitor: ["declaration", "specifiers", "source"],
    aliases: ["Statement", "Declaration", "ModuleDeclaration", "ExportDeclaration"],
    fields: {
      declaration: {
        validate: _index.assertNodeType("Declaration"),
        optional: true
      },
      specifiers: {validate: _index.chain(_index.assertValueType("array"), _index.assertEach(_index.assertNodeType("ExportSpecifier")))},
      source: {
        validate: _index.assertNodeType("StringLiteral"),
        optional: true
      }
    }
  });
  _index2["default"]("ExportSpecifier", {
    visitor: ["local", "exported"],
    aliases: ["ModuleSpecifier"],
    fields: {
      local: {validate: _index.assertNodeType("Identifier")},
      exported: {validate: _index.assertNodeType("Identifier")}
    }
  });
  _index2["default"]("ForOfStatement", {
    visitor: ["left", "right", "body"],
    aliases: ["Scopable", "Statement", "For", "BlockParent", "Loop", "ForXStatement"],
    fields: {
      left: {validate: _index.assertNodeType("VariableDeclaration", "LVal")},
      right: {validate: _index.assertNodeType("Expression")},
      body: {validate: _index.assertNodeType("Statement")}
    }
  });
  _index2["default"]("ImportDeclaration", {
    visitor: ["specifiers", "source"],
    aliases: ["Statement", "Declaration", "ModuleDeclaration"],
    fields: {
      specifiers: {validate: _index.chain(_index.assertValueType("array"), _index.assertEach(_index.assertNodeType("ImportSpecifier", "ImportDefaultSpecifier", "ImportNamespaceSpecifier")))},
      source: {validate: _index.assertNodeType("StringLiteral")}
    }
  });
  _index2["default"]("ImportDefaultSpecifier", {
    visitor: ["local"],
    aliases: ["ModuleSpecifier"],
    fields: {local: {validate: _index.assertNodeType("Identifier")}}
  });
  _index2["default"]("ImportNamespaceSpecifier", {
    visitor: ["local"],
    aliases: ["ModuleSpecifier"],
    fields: {local: {validate: _index.assertNodeType("Identifier")}}
  });
  _index2["default"]("ImportSpecifier", {
    visitor: ["local", "imported"],
    aliases: ["ModuleSpecifier"],
    fields: {
      local: {validate: _index.assertNodeType("Identifier")},
      imported: {validate: _index.assertNodeType("Identifier")}
    }
  });
  _index2["default"]("MetaProperty", {
    visitor: ["meta", "property"],
    aliases: ["Expression"],
    fields: {
      meta: {validate: _index.assertValueType("string")},
      property: {validate: _index.assertValueType("string")}
    }
  });
  _index2["default"]("ClassMethod", {
    aliases: ["Function", "Scopable", "BlockParent", "FunctionParent", "Method"],
    builder: ["kind", "key", "params", "body", "computed", "static"],
    visitor: ["key", "params", "body", "decorators", "returnType", "typeParameters"],
    fields: {
      kind: {
        validate: _index.chain(_index.assertValueType("string"), _index.assertOneOf("get", "set", "method", "constructor")),
        "default": "method"
      },
      computed: {
        "default": false,
        validate: _index.assertValueType("boolean")
      },
      "static": {
        "default": false,
        validate: _index.assertValueType("boolean")
      },
      key: {validate: function validate(node, key, val) {
          var expectedTypes = node.computed ? ["Expression"] : ["Identifier", "StringLiteral", "NumericLiteral"];
          _index.assertNodeType.apply(undefined, expectedTypes)(node, key, val);
        }},
      params: {validate: _index.chain(_index.assertValueType("array"), _index.assertEach(_index.assertNodeType("LVal")))},
      body: {validate: _index.assertNodeType("BlockStatement")},
      generator: {
        "default": false,
        validate: _index.assertValueType("boolean")
      },
      async: {
        "default": false,
        validate: _index.assertValueType("boolean")
      }
    }
  });
  _index2["default"]("ObjectPattern", {
    visitor: ["properties", "typeAnnotation"],
    aliases: ["Pattern", "LVal"],
    fields: {properties: {validate: _index.chain(_index.assertValueType("array"), _index.assertEach(_index.assertNodeType("RestProperty", "Property")))}}
  });
  _index2["default"]("SpreadElement", {
    visitor: ["argument"],
    aliases: ["UnaryLike"],
    fields: {argument: {validate: _index.assertNodeType("Expression")}}
  });
  _index2["default"]("Super", {aliases: ["Expression"]});
  _index2["default"]("TaggedTemplateExpression", {
    visitor: ["tag", "quasi"],
    aliases: ["Expression"],
    fields: {
      tag: {validate: _index.assertNodeType("Expression")},
      quasi: {validate: _index.assertNodeType("TemplateLiteral")}
    }
  });
  _index2["default"]("TemplateElement", {
    builder: ["value", "tail"],
    fields: {
      value: {},
      tail: {
        validate: _index.assertValueType("boolean"),
        "default": false
      }
    }
  });
  _index2["default"]("TemplateLiteral", {
    visitor: ["quasis", "expressions"],
    aliases: ["Expression", "Literal"],
    fields: {
      quasis: {validate: _index.chain(_index.assertValueType("array"), _index.assertEach(_index.assertNodeType("TemplateElement")))},
      expressions: {validate: _index.chain(_index.assertValueType("array"), _index.assertEach(_index.assertNodeType("Expression")))}
    }
  });
  _index2["default"]("YieldExpression", {
    builder: ["argument", "delegate"],
    visitor: ["argument"],
    aliases: ["Expression", "Terminatorless"],
    fields: {
      delegate: {
        validate: _index.assertValueType("boolean"),
        "default": false
      },
      argument: {
        optional: true,
        validate: _index.assertNodeType("Expression")
      }
    }
  });
  return module.exports;
});

$__System.registerDynamic("132", ["a", "130"], true, function($__require, exports, module) {
  "use strict";
  ;
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireDefault = $__require('a')["default"];
  var _index = $__require('130');
  var _index2 = _interopRequireDefault(_index);
  _index2["default"]("AnyTypeAnnotation", {
    aliases: ["Flow", "FlowBaseAnnotation"],
    fields: {}
  });
  _index2["default"]("ArrayTypeAnnotation", {
    visitor: ["elementType"],
    aliases: ["Flow"],
    fields: {}
  });
  _index2["default"]("BooleanTypeAnnotation", {
    aliases: ["Flow", "FlowBaseAnnotation"],
    fields: {}
  });
  _index2["default"]("BooleanLiteralTypeAnnotation", {
    aliases: ["Flow"],
    fields: {}
  });
  _index2["default"]("NullLiteralTypeAnnotation", {
    aliases: ["Flow", "FlowBaseAnnotation"],
    fields: {}
  });
  _index2["default"]("ClassImplements", {
    visitor: ["id", "typeParameters"],
    aliases: ["Flow"],
    fields: {}
  });
  _index2["default"]("ClassProperty", {
    visitor: ["key", "value", "typeAnnotation", "decorators"],
    aliases: ["Flow", "Property"],
    fields: {}
  });
  _index2["default"]("DeclareClass", {
    visitor: ["id", "typeParameters", "extends", "body"],
    aliases: ["Flow", "FlowDeclaration", "Statement", "Declaration"],
    fields: {}
  });
  _index2["default"]("DeclareFunction", {
    visitor: ["id"],
    aliases: ["Flow", "FlowDeclaration", "Statement", "Declaration"],
    fields: {}
  });
  _index2["default"]("DeclareInterface", {
    visitor: ["id", "typeParameters", "extends", "body"],
    aliases: ["Flow", "FlowDeclaration", "Statement", "Declaration"],
    fields: {}
  });
  _index2["default"]("DeclareModule", {
    visitor: ["id", "body"],
    aliases: ["Flow", "FlowDeclaration", "Statement", "Declaration"],
    fields: {}
  });
  _index2["default"]("DeclareTypeAlias", {
    visitor: ["id", "typeParameters", "right"],
    aliases: ["Flow", "FlowDeclaration", "Statement", "Declaration"],
    fields: {}
  });
  _index2["default"]("DeclareVariable", {
    visitor: ["id"],
    aliases: ["Flow", "FlowDeclaration", "Statement", "Declaration"],
    fields: {}
  });
  _index2["default"]("ExistentialTypeParam", {aliases: ["Flow"]});
  _index2["default"]("FunctionTypeAnnotation", {
    visitor: ["typeParameters", "params", "rest", "returnType"],
    aliases: ["Flow"],
    fields: {}
  });
  _index2["default"]("FunctionTypeParam", {
    visitor: ["name", "typeAnnotation"],
    aliases: ["Flow"],
    fields: {}
  });
  _index2["default"]("GenericTypeAnnotation", {
    visitor: ["id", "typeParameters"],
    aliases: ["Flow"],
    fields: {}
  });
  _index2["default"]("InterfaceExtends", {
    visitor: ["id", "typeParameters"],
    aliases: ["Flow"],
    fields: {}
  });
  _index2["default"]("InterfaceDeclaration", {
    visitor: ["id", "typeParameters", "extends", "body"],
    aliases: ["Flow", "FlowDeclaration", "Statement", "Declaration"],
    fields: {}
  });
  _index2["default"]("IntersectionTypeAnnotation", {
    visitor: ["types"],
    aliases: ["Flow"],
    fields: {}
  });
  _index2["default"]("MixedTypeAnnotation", {aliases: ["Flow", "FlowBaseAnnotation"]});
  _index2["default"]("NullableTypeAnnotation", {
    visitor: ["typeAnnotation"],
    aliases: ["Flow"],
    fields: {}
  });
  _index2["default"]("NumericLiteralTypeAnnotation", {
    aliases: ["Flow"],
    fields: {}
  });
  _index2["default"]("NumberTypeAnnotation", {
    aliases: ["Flow", "FlowBaseAnnotation"],
    fields: {}
  });
  _index2["default"]("StringLiteralTypeAnnotation", {
    aliases: ["Flow"],
    fields: {}
  });
  _index2["default"]("StringTypeAnnotation", {
    aliases: ["Flow", "FlowBaseAnnotation"],
    fields: {}
  });
  _index2["default"]("ThisTypeAnnotation", {
    aliases: ["Flow", "FlowBaseAnnotation"],
    fields: {}
  });
  _index2["default"]("TupleTypeAnnotation", {
    visitor: ["types"],
    aliases: ["Flow"],
    fields: {}
  });
  _index2["default"]("TypeofTypeAnnotation", {
    visitor: ["argument"],
    aliases: ["Flow"],
    fields: {}
  });
  _index2["default"]("TypeAlias", {
    visitor: ["id", "typeParameters", "right"],
    aliases: ["Flow", "FlowDeclaration", "Statement", "Declaration"],
    fields: {}
  });
  _index2["default"]("TypeAnnotation", {
    visitor: ["typeAnnotation"],
    aliases: ["Flow"],
    fields: {}
  });
  _index2["default"]("TypeCastExpression", {
    visitor: ["expression", "typeAnnotation"],
    aliases: ["Flow", "ExpressionWrapper", "Expression"],
    fields: {}
  });
  _index2["default"]("TypeParameterDeclaration", {
    visitor: ["params"],
    aliases: ["Flow"],
    fields: {}
  });
  _index2["default"]("TypeParameterInstantiation", {
    visitor: ["params"],
    aliases: ["Flow"],
    fields: {}
  });
  _index2["default"]("ObjectTypeAnnotation", {
    visitor: ["properties", "indexers", "callProperties"],
    aliases: ["Flow"],
    fields: {}
  });
  _index2["default"]("ObjectTypeCallProperty", {
    visitor: ["value"],
    aliases: ["Flow", "UserWhitespacable"],
    fields: {}
  });
  _index2["default"]("ObjectTypeIndexer", {
    visitor: ["id", "key", "value"],
    aliases: ["Flow", "UserWhitespacable"],
    fields: {}
  });
  _index2["default"]("ObjectTypeProperty", {
    visitor: ["key", "value"],
    aliases: ["Flow", "UserWhitespacable"],
    fields: {}
  });
  _index2["default"]("QualifiedTypeIdentifier", {
    visitor: ["id", "qualification"],
    aliases: ["Flow"],
    fields: {}
  });
  _index2["default"]("UnionTypeAnnotation", {
    visitor: ["types"],
    aliases: ["Flow"],
    fields: {}
  });
  _index2["default"]("VoidTypeAnnotation", {
    aliases: ["Flow", "FlowBaseAnnotation"],
    fields: {}
  });
  return module.exports;
});

$__System.registerDynamic("133", ["a", "130"], true, function($__require, exports, module) {
  "use strict";
  ;
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireDefault = $__require('a')["default"];
  var _index = $__require('130');
  var _index2 = _interopRequireDefault(_index);
  _index2["default"]("JSXAttribute", {
    visitor: ["name", "value"],
    aliases: ["JSX", "Immutable"],
    fields: {
      name: {validate: _index.assertNodeType("JSXIdentifier", "JSXNamespacedName")},
      value: {
        optional: true,
        validate: _index.assertNodeType("JSXElement", "StringLiteral", "JSXExpressionContainer")
      }
    }
  });
  _index2["default"]("JSXClosingElement", {
    visitor: ["name"],
    aliases: ["JSX", "Immutable"],
    fields: {name: {validate: _index.assertNodeType("JSXIdentifier", "JSXMemberExpression")}}
  });
  _index2["default"]("JSXElement", {
    builder: ["openingElement", "closingElement", "children", "selfClosing"],
    visitor: ["openingElement", "children", "closingElement"],
    aliases: ["JSX", "Immutable", "Expression"],
    fields: {
      openingElement: {validate: _index.assertNodeType("JSXOpeningElement")},
      closingElement: {
        optional: true,
        validate: _index.assertNodeType("JSXClosingElement")
      },
      children: {validate: _index.chain(_index.assertValueType("array"), _index.assertEach(_index.assertNodeType("JSXText", "JSXExpressionContainer", "JSXElement")))}
    }
  });
  _index2["default"]("JSXEmptyExpression", {aliases: ["JSX", "Expression"]});
  _index2["default"]("JSXExpressionContainer", {
    visitor: ["expression"],
    aliases: ["JSX", "Immutable"],
    fields: {expression: {validate: _index.assertNodeType("Expression")}}
  });
  _index2["default"]("JSXIdentifier", {
    builder: ["name"],
    aliases: ["JSX", "Expression"],
    fields: {name: {validate: _index.assertValueType("string")}}
  });
  _index2["default"]("JSXMemberExpression", {
    visitor: ["object", "property"],
    aliases: ["JSX", "Expression"],
    fields: {
      object: {validate: _index.assertNodeType("JSXMemberExpression", "JSXIdentifier")},
      property: {validate: _index.assertNodeType("JSXIdentifier")}
    }
  });
  _index2["default"]("JSXNamespacedName", {
    visitor: ["namespace", "name"],
    aliases: ["JSX"],
    fields: {
      namespace: {validate: _index.assertNodeType("JSXIdentifier")},
      name: {validate: _index.assertNodeType("JSXIdentifier")}
    }
  });
  _index2["default"]("JSXOpeningElement", {
    builder: ["name", "attributes", "selfClosing"],
    visitor: ["name", "attributes"],
    aliases: ["JSX", "Immutable"],
    fields: {
      name: {validate: _index.assertNodeType("JSXIdentifier", "JSXMemberExpression")},
      selfClosing: {
        "default": false,
        validate: _index.assertValueType("boolean")
      },
      attributes: {validate: _index.chain(_index.assertValueType("array"), _index.assertEach(_index.assertNodeType("JSXAttribute", "JSXSpreadAttribute")))}
    }
  });
  _index2["default"]("JSXSpreadAttribute", {
    visitor: ["argument"],
    aliases: ["JSX"],
    fields: {argument: {validate: _index.assertNodeType("Expression")}}
  });
  _index2["default"]("JSXText", {
    aliases: ["JSX"],
    builder: ["value"],
    fields: {value: {validate: _index.assertValueType("string")}}
  });
  return module.exports;
});

$__System.registerDynamic("134", ["a", "130"], true, function($__require, exports, module) {
  "use strict";
  ;
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireDefault = $__require('a')["default"];
  var _index = $__require('130');
  var _index2 = _interopRequireDefault(_index);
  _index2["default"]("Noop", {visitor: []});
  _index2["default"]("ParenthesizedExpression", {
    visitor: ["expression"],
    aliases: ["Expression", "ExpressionWrapper"],
    fields: {expression: {validate: _index.assertNodeType("Expression")}}
  });
  return module.exports;
});

$__System.registerDynamic("135", ["a", "130"], true, function($__require, exports, module) {
  "use strict";
  ;
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireDefault = $__require('a')["default"];
  var _index = $__require('130');
  var _index2 = _interopRequireDefault(_index);
  _index2["default"]("AwaitExpression", {
    builder: ["argument"],
    visitor: ["argument"],
    aliases: ["Expression", "Terminatorless"],
    fields: {argument: {validate: _index.assertNodeType("Expression")}}
  });
  _index2["default"]("BindExpression", {
    visitor: ["object", "callee"],
    aliases: ["Expression"],
    fields: {}
  });
  _index2["default"]("Decorator", {
    visitor: ["expression"],
    fields: {expression: {validate: _index.assertNodeType("Expression")}}
  });
  _index2["default"]("DoExpression", {
    visitor: ["body"],
    aliases: ["Expression"],
    fields: {body: {validate: _index.assertNodeType("BlockStatement")}}
  });
  _index2["default"]("ExportDefaultSpecifier", {
    visitor: ["exported"],
    aliases: ["ModuleSpecifier"],
    fields: {exported: {validate: _index.assertNodeType("Identifier")}}
  });
  _index2["default"]("ExportNamespaceSpecifier", {
    visitor: ["exported"],
    aliases: ["ModuleSpecifier"],
    fields: {exported: {validate: _index.assertNodeType("Identifier")}}
  });
  _index2["default"]("RestProperty", {
    visitor: ["argument"],
    aliases: ["UnaryLike"],
    fields: {argument: {validate: _index.assertNodeType("LVal")}}
  });
  _index2["default"]("SpreadProperty", {
    visitor: ["argument"],
    aliases: ["UnaryLike"],
    fields: {argument: {validate: _index.assertNodeType("Expression")}}
  });
  return module.exports;
});

$__System.registerDynamic("136", ["130", "12e", "131", "132", "133", "134", "135"], true, function($__require, exports, module) {
  "use strict";
  ;
  var define,
      global = this,
      GLOBAL = this;
  $__require('130');
  $__require('12e');
  $__require('131');
  $__require('132');
  $__require('133');
  $__require('134');
  $__require('135');
  return module.exports;
});

$__System.registerDynamic("130", ["45", "4", "5"], true, function($__require, exports, module) {
  "use strict";
  ;
  var define,
      global = this,
      GLOBAL = this;
  var _getIterator = $__require('45')["default"];
  var _interopRequireWildcard = $__require('4')["default"];
  exports.__esModule = true;
  exports.assertEach = assertEach;
  exports.assertOneOf = assertOneOf;
  exports.assertNodeType = assertNodeType;
  exports.assertNodeOrValueType = assertNodeOrValueType;
  exports.assertValueType = assertValueType;
  exports.chain = chain;
  exports["default"] = defineType;
  var _index = $__require('5');
  var t = _interopRequireWildcard(_index);
  var VISITOR_KEYS = {};
  exports.VISITOR_KEYS = VISITOR_KEYS;
  var ALIAS_KEYS = {};
  exports.ALIAS_KEYS = ALIAS_KEYS;
  var NODE_FIELDS = {};
  exports.NODE_FIELDS = NODE_FIELDS;
  var BUILDER_KEYS = {};
  exports.BUILDER_KEYS = BUILDER_KEYS;
  var DEPRECATED_KEYS = {};
  exports.DEPRECATED_KEYS = DEPRECATED_KEYS;
  function getType(val) {
    if (Array.isArray(val)) {
      return "array";
    } else if (val === null) {
      return "null";
    } else if (val === undefined) {
      return "undefined";
    } else {
      return typeof val;
    }
  }
  function assertEach(callback) {
    function validator(node, key, val) {
      if (!Array.isArray(val))
        return;
      for (var i = 0; i < val.length; i++) {
        callback(node, key + "[" + i + "]", val[i]);
      }
    }
    validator.each = callback;
    return validator;
  }
  function assertOneOf() {
    for (var _len = arguments.length,
        vals = Array(_len),
        _key = 0; _key < _len; _key++) {
      vals[_key] = arguments[_key];
    }
    function validate(node, key, val) {
      if (vals.indexOf(val) < 0) {
        throw new TypeError("Property " + key + " expected value to be one of " + JSON.stringify(vals) + " but got " + JSON.stringify(val));
      }
    }
    validate.oneOf = vals;
    return validate;
  }
  function assertNodeType() {
    for (var _len2 = arguments.length,
        types = Array(_len2),
        _key2 = 0; _key2 < _len2; _key2++) {
      types[_key2] = arguments[_key2];
    }
    function validate(node, key, val) {
      var valid = false;
      for (var _iterator = types,
          _isArray = Array.isArray(_iterator),
          _i = 0,
          _iterator = _isArray ? _iterator : _getIterator(_iterator); ; ) {
        var _ref;
        if (_isArray) {
          if (_i >= _iterator.length)
            break;
          _ref = _iterator[_i++];
        } else {
          _i = _iterator.next();
          if (_i.done)
            break;
          _ref = _i.value;
        }
        var type = _ref;
        if (t.is(type, val)) {
          valid = true;
          break;
        }
      }
      if (!valid) {
        throw new TypeError("Property " + key + " of " + node.type + " expected node to be of a type " + JSON.stringify(types) + " " + ("but instead got " + JSON.stringify(val && val.type)));
      }
    }
    validate.oneOfNodeTypes = types;
    return validate;
  }
  function assertNodeOrValueType() {
    for (var _len3 = arguments.length,
        types = Array(_len3),
        _key3 = 0; _key3 < _len3; _key3++) {
      types[_key3] = arguments[_key3];
    }
    function validate(node, key, val) {
      var valid = false;
      for (var _iterator2 = types,
          _isArray2 = Array.isArray(_iterator2),
          _i2 = 0,
          _iterator2 = _isArray2 ? _iterator2 : _getIterator(_iterator2); ; ) {
        var _ref2;
        if (_isArray2) {
          if (_i2 >= _iterator2.length)
            break;
          _ref2 = _iterator2[_i2++];
        } else {
          _i2 = _iterator2.next();
          if (_i2.done)
            break;
          _ref2 = _i2.value;
        }
        var type = _ref2;
        if (getType(val) === type || t.is(type, val)) {
          valid = true;
          break;
        }
      }
      if (!valid) {
        throw new TypeError("Property " + key + " of " + node.type + " expected node to be of a type " + JSON.stringify(types) + " " + ("but instead got " + JSON.stringify(val && val.type)));
      }
    }
    validate.oneOfNodeOrValueTypes = types;
    return validate;
  }
  function assertValueType(type) {
    function validate(node, key, val) {
      var valid = getType(val) === type;
      if (!valid) {
        throw new TypeError("Property " + key + " expected type of " + type + " but got " + getType(val));
      }
    }
    validate.type = type;
    return validate;
  }
  function chain() {
    for (var _len4 = arguments.length,
        fns = Array(_len4),
        _key4 = 0; _key4 < _len4; _key4++) {
      fns[_key4] = arguments[_key4];
    }
    function validate() {
      for (var _iterator3 = fns,
          _isArray3 = Array.isArray(_iterator3),
          _i3 = 0,
          _iterator3 = _isArray3 ? _iterator3 : _getIterator(_iterator3); ; ) {
        var _ref3;
        if (_isArray3) {
          if (_i3 >= _iterator3.length)
            break;
          _ref3 = _iterator3[_i3++];
        } else {
          _i3 = _iterator3.next();
          if (_i3.done)
            break;
          _ref3 = _i3.value;
        }
        var fn = _ref3;
        fn.apply(undefined, arguments);
      }
    }
    validate.chainOf = fns;
    return validate;
  }
  function defineType(type) {
    var opts = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];
    var inherits = opts.inherits && store[opts.inherits] || {};
    opts.fields = opts.fields || inherits.fields || {};
    opts.visitor = opts.visitor || inherits.visitor || [];
    opts.aliases = opts.aliases || inherits.aliases || [];
    opts.builder = opts.builder || inherits.builder || opts.visitor || [];
    if (opts.deprecatedAlias) {
      DEPRECATED_KEYS[opts.deprecatedAlias] = type;
    }
    var _arr = opts.visitor.concat(opts.builder);
    for (var _i4 = 0; _i4 < _arr.length; _i4++) {
      var key = _arr[_i4];
      opts.fields[key] = opts.fields[key] || {};
    }
    for (var key in opts.fields) {
      var field = opts.fields[key];
      if (field["default"] === undefined) {
        field["default"] = null;
      } else if (!field.validate) {
        field.validate = assertValueType(getType(field["default"]));
      }
    }
    VISITOR_KEYS[type] = opts.visitor;
    BUILDER_KEYS[type] = opts.builder;
    NODE_FIELDS[type] = opts.fields;
    ALIAS_KEYS[type] = opts.aliases;
    store[type] = opts;
  }
  var store = {};
  return module.exports;
});

$__System.registerDynamic("137", ["4", "5"], true, function($__require, exports, module) {
  "use strict";
  ;
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireWildcard = $__require('4')["default"];
  exports.__esModule = true;
  exports.isCompatTag = isCompatTag;
  exports.buildChildren = buildChildren;
  var _index = $__require('5');
  var t = _interopRequireWildcard(_index);
  var isReactComponent = t.buildMatchMemberExpression("React.Component");
  exports.isReactComponent = isReactComponent;
  function isCompatTag(tagName) {
    return !!tagName && /^[a-z]|\-/.test(tagName);
  }
  function cleanJSXElementLiteralChild(child, args) {
    var lines = child.value.split(/\r\n|\n|\r/);
    var lastNonEmptyLine = 0;
    for (var i = 0; i < lines.length; i++) {
      if (lines[i].match(/[^ \t]/)) {
        lastNonEmptyLine = i;
      }
    }
    var str = "";
    for (var i = 0; i < lines.length; i++) {
      var line = lines[i];
      var isFirstLine = i === 0;
      var isLastLine = i === lines.length - 1;
      var isLastNonEmptyLine = i === lastNonEmptyLine;
      var trimmedLine = line.replace(/\t/g, " ");
      if (!isFirstLine) {
        trimmedLine = trimmedLine.replace(/^[ ]+/, "");
      }
      if (!isLastLine) {
        trimmedLine = trimmedLine.replace(/[ ]+$/, "");
      }
      if (trimmedLine) {
        if (!isLastNonEmptyLine) {
          trimmedLine += " ";
        }
        str += trimmedLine;
      }
    }
    if (str)
      args.push(t.stringLiteral(str));
  }
  function buildChildren(node) {
    var elems = [];
    for (var i = 0; i < node.children.length; i++) {
      var child = node.children[i];
      if (t.isJSXText(child)) {
        cleanJSXElementLiteralChild(child, elems);
        continue;
      }
      if (t.isJSXExpressionContainer(child))
        child = child.expression;
      if (t.isJSXEmptyExpression(child))
        continue;
      elems.push(child);
    }
    return elems;
  }
  return module.exports;
});

$__System.registerDynamic("138", ["6b", "4", "5"], true, function($__require, exports, module) {
  "use strict";
  ;
  var define,
      global = this,
      GLOBAL = this;
  var _Object$create = $__require('6b')["default"];
  var _interopRequireWildcard = $__require('4')["default"];
  exports.__esModule = true;
  exports.getBindingIdentifiers = getBindingIdentifiers;
  exports.getOuterBindingIdentifiers = getOuterBindingIdentifiers;
  var _index = $__require('5');
  var t = _interopRequireWildcard(_index);
  function getBindingIdentifiers(node, duplicates, outerOnly) {
    var search = [].concat(node);
    var ids = _Object$create(null);
    while (search.length) {
      var id = search.shift();
      if (!id)
        continue;
      var keys = t.getBindingIdentifiers.keys[id.type];
      if (t.isIdentifier(id)) {
        if (duplicates) {
          var _ids = ids[id.name] = ids[id.name] || [];
          _ids.push(id);
        } else {
          ids[id.name] = id;
        }
        continue;
      }
      if (t.isExportDeclaration(id)) {
        if (t.isDeclaration(node.declaration)) {
          search.push(node.declaration);
        }
        continue;
      }
      if (outerOnly) {
        if (t.isFunctionDeclaration(id)) {
          search.push(id.id);
          continue;
        }
        if (t.isFunctionExpression(id)) {
          continue;
        }
      }
      if (keys) {
        for (var i = 0; i < keys.length; i++) {
          var key = keys[i];
          if (id[key]) {
            search = search.concat(id[key]);
          }
        }
      }
    }
    return ids;
  }
  getBindingIdentifiers.keys = {
    DeclareClass: ["id"],
    DeclareFunction: ["id"],
    DeclareModule: ["id"],
    DeclareVariable: ["id"],
    InterfaceDeclaration: ["id"],
    TypeAlias: ["id"],
    CatchClause: ["param"],
    LabeledStatement: ["label"],
    UnaryExpression: ["argument"],
    AssignmentExpression: ["left"],
    ImportSpecifier: ["local"],
    ImportNamespaceSpecifier: ["local"],
    ImportDefaultSpecifier: ["local"],
    ImportDeclaration: ["specifiers"],
    ExportSpecifier: ["exported"],
    ExportNamespaceSpecifier: ["exported"],
    ExportDefaultSpecifier: ["exported"],
    FunctionDeclaration: ["id", "params"],
    FunctionExpression: ["id", "params"],
    ClassDeclaration: ["id"],
    ClassExpression: ["id"],
    RestElement: ["argument"],
    UpdateExpression: ["argument"],
    RestProperty: ["argument"],
    ObjectProperty: ["value"],
    AssignmentPattern: ["left"],
    ArrayPattern: ["elements"],
    ObjectPattern: ["properties"],
    VariableDeclaration: ["declarations"],
    VariableDeclarator: ["id"]
  };
  function getOuterBindingIdentifiers(node, duplicates) {
    return getBindingIdentifiers(node, duplicates, true);
  }
  return module.exports;
});

$__System.registerDynamic("139", ["13a", "4e", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  $__require('13a');
  module.exports = $__require('4e').Symbol['for'];
  return module.exports;
});

$__System.registerDynamic("13b", ["139", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  module.exports = {
    "default": $__require('139'),
    __esModule: true
  };
  return module.exports;
});

$__System.registerDynamic("12f", ["13b"], true, function($__require, exports, module) {
  "use strict";
  ;
  var define,
      global = this,
      GLOBAL = this;
  var _Symbol$for = $__require('13b')["default"];
  exports.__esModule = true;
  var STATEMENT_OR_BLOCK_KEYS = ["consequent", "body", "alternate"];
  exports.STATEMENT_OR_BLOCK_KEYS = STATEMENT_OR_BLOCK_KEYS;
  var FLATTENABLE_KEYS = ["body", "expressions"];
  exports.FLATTENABLE_KEYS = FLATTENABLE_KEYS;
  var FOR_INIT_KEYS = ["left", "init"];
  exports.FOR_INIT_KEYS = FOR_INIT_KEYS;
  var COMMENT_KEYS = ["leadingComments", "trailingComments", "innerComments"];
  exports.COMMENT_KEYS = COMMENT_KEYS;
  var LOGICAL_OPERATORS = ["||", "&&"];
  exports.LOGICAL_OPERATORS = LOGICAL_OPERATORS;
  var UPDATE_OPERATORS = ["++", "--"];
  exports.UPDATE_OPERATORS = UPDATE_OPERATORS;
  var BOOLEAN_NUMBER_BINARY_OPERATORS = [">", "<", ">=", "<="];
  exports.BOOLEAN_NUMBER_BINARY_OPERATORS = BOOLEAN_NUMBER_BINARY_OPERATORS;
  var EQUALITY_BINARY_OPERATORS = ["==", "===", "!=", "!=="];
  exports.EQUALITY_BINARY_OPERATORS = EQUALITY_BINARY_OPERATORS;
  var COMPARISON_BINARY_OPERATORS = [].concat(EQUALITY_BINARY_OPERATORS, ["in", "instanceof"]);
  exports.COMPARISON_BINARY_OPERATORS = COMPARISON_BINARY_OPERATORS;
  var BOOLEAN_BINARY_OPERATORS = [].concat(COMPARISON_BINARY_OPERATORS, BOOLEAN_NUMBER_BINARY_OPERATORS);
  exports.BOOLEAN_BINARY_OPERATORS = BOOLEAN_BINARY_OPERATORS;
  var NUMBER_BINARY_OPERATORS = ["-", "/", "%", "*", "**", "&", "|", ">>", ">>>", "<<", "^"];
  exports.NUMBER_BINARY_OPERATORS = NUMBER_BINARY_OPERATORS;
  var BINARY_OPERATORS = ["+"].concat(NUMBER_BINARY_OPERATORS, BOOLEAN_BINARY_OPERATORS);
  exports.BINARY_OPERATORS = BINARY_OPERATORS;
  var BOOLEAN_UNARY_OPERATORS = ["delete", "!"];
  exports.BOOLEAN_UNARY_OPERATORS = BOOLEAN_UNARY_OPERATORS;
  var NUMBER_UNARY_OPERATORS = ["+", "-", "++", "--", "~"];
  exports.NUMBER_UNARY_OPERATORS = NUMBER_UNARY_OPERATORS;
  var STRING_UNARY_OPERATORS = ["typeof"];
  exports.STRING_UNARY_OPERATORS = STRING_UNARY_OPERATORS;
  var UNARY_OPERATORS = ["void"].concat(BOOLEAN_UNARY_OPERATORS, NUMBER_UNARY_OPERATORS, STRING_UNARY_OPERATORS);
  exports.UNARY_OPERATORS = UNARY_OPERATORS;
  var INHERIT_KEYS = {
    optional: ["typeAnnotation", "typeParameters", "returnType"],
    force: ["start", "loc", "end"]
  };
  exports.INHERIT_KEYS = INHERIT_KEYS;
  var BLOCK_SCOPED_SYMBOL = _Symbol$for("var used to be block scoped");
  exports.BLOCK_SCOPED_SYMBOL = BLOCK_SCOPED_SYMBOL;
  var NOT_LOCAL_BINDING = _Symbol$for("should not be considered a local binding");
  exports.NOT_LOCAL_BINDING = NOT_LOCAL_BINDING;
  return module.exports;
});

$__System.registerDynamic("13c", ["a", "4", "138", "13d", "5", "12f"], true, function($__require, exports, module) {
  "use strict";
  ;
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireDefault = $__require('a')["default"];
  var _interopRequireWildcard = $__require('4')["default"];
  exports.__esModule = true;
  exports.isBinding = isBinding;
  exports.isReferenced = isReferenced;
  exports.isValidIdentifier = isValidIdentifier;
  exports.isLet = isLet;
  exports.isBlockScoped = isBlockScoped;
  exports.isVar = isVar;
  exports.isSpecifierDefault = isSpecifierDefault;
  exports.isScope = isScope;
  exports.isImmutable = isImmutable;
  var _retrievers = $__require('138');
  var _esutils = $__require('13d');
  var _esutils2 = _interopRequireDefault(_esutils);
  var _index = $__require('5');
  var t = _interopRequireWildcard(_index);
  var _constants = $__require('12f');
  function isBinding(node, parent) {
    var keys = _retrievers.getBindingIdentifiers.keys[parent.type];
    if (keys) {
      for (var i = 0; i < keys.length; i++) {
        var key = keys[i];
        var val = parent[key];
        if (Array.isArray(val)) {
          if (val.indexOf(node) >= 0)
            return true;
        } else {
          if (val === node)
            return true;
        }
      }
    }
    return false;
  }
  function isReferenced(node, parent) {
    switch (parent.type) {
      case "BindExpression":
        return parent.object === node || parent.callee === node;
      case "MemberExpression":
      case "JSXMemberExpression":
        if (parent.property === node && parent.computed) {
          return true;
        } else if (parent.object === node) {
          return true;
        } else {
          return false;
        }
      case "MetaProperty":
        return false;
      case "ObjectProperty":
        if (parent.key === node) {
          return parent.computed;
        }
      case "VariableDeclarator":
        return parent.id !== node;
      case "ArrowFunctionExpression":
      case "FunctionDeclaration":
      case "FunctionExpression":
        var _arr = parent.params;
        for (var _i = 0; _i < _arr.length; _i++) {
          var param = _arr[_i];
          if (param === node)
            return false;
        }
        return parent.id !== node;
      case "ExportSpecifier":
        if (parent.source) {
          return false;
        } else {
          return parent.local === node;
        }
      case "ExportNamespaceSpecifier":
      case "ExportDefaultSpecifier":
        return false;
      case "JSXAttribute":
        return parent.name !== node;
      case "ClassProperty":
        return parent.value === node;
      case "ImportDefaultSpecifier":
      case "ImportNamespaceSpecifier":
      case "ImportSpecifier":
        return false;
      case "ClassDeclaration":
      case "ClassExpression":
        return parent.id !== node;
      case "ClassMethod":
      case "ObjectMethod":
        return parent.key === node && parent.computed;
      case "LabeledStatement":
        return false;
      case "CatchClause":
        return parent.param !== node;
      case "RestElement":
        return false;
      case "AssignmentExpression":
        return parent.right === node;
      case "AssignmentPattern":
        return parent.right === node;
      case "ObjectPattern":
      case "ArrayPattern":
        return false;
    }
    return true;
  }
  function isValidIdentifier(name) {
    if (typeof name !== "string" || _esutils2["default"].keyword.isReservedWordES6(name, true)) {
      return false;
    } else {
      return _esutils2["default"].keyword.isIdentifierNameES6(name);
    }
  }
  function isLet(node) {
    return t.isVariableDeclaration(node) && (node.kind !== "var" || node[_constants.BLOCK_SCOPED_SYMBOL]);
  }
  function isBlockScoped(node) {
    return t.isFunctionDeclaration(node) || t.isClassDeclaration(node) || t.isLet(node);
  }
  function isVar(node) {
    return t.isVariableDeclaration(node, {kind: "var"}) && !node[_constants.BLOCK_SCOPED_SYMBOL];
  }
  function isSpecifierDefault(specifier) {
    return t.isImportDefaultSpecifier(specifier) || t.isIdentifier(specifier.imported || specifier.exported, {name: "default"});
  }
  function isScope(node, parent) {
    if (t.isBlockStatement(node) && t.isFunction(parent, {body: node})) {
      return false;
    }
    return t.isScopable(node);
  }
  function isImmutable(node) {
    if (t.isType(node.type, "Immutable"))
      return true;
    if (t.isIdentifier(node)) {
      if (node.name === "undefined") {
        return true;
      } else {
        return false;
      }
    }
    return false;
  }
  return module.exports;
});

$__System.registerDynamic("13e", ["63", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var $export = $__require('63');
  $export($export.S, 'Number', {MAX_SAFE_INTEGER: 0x1fffffffffffff});
  return module.exports;
});

$__System.registerDynamic("13f", ["13e", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  $__require('13e');
  module.exports = 0x1fffffffffffff;
  return module.exports;
});

$__System.registerDynamic("140", ["13f", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  module.exports = {
    "default": $__require('13f'),
    __esModule: true
  };
  return module.exports;
});

$__System.registerDynamic("141", ["142", "35", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var baseFor = $__require('142'),
      keysIn = $__require('35');
  function baseForIn(object, iteratee) {
    return baseFor(object, iteratee, keysIn);
  }
  module.exports = baseForIn;
  return module.exports;
});

$__System.registerDynamic("3b", ["141", "38", "40", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var baseForIn = $__require('141'),
      isArguments = $__require('38'),
      isObjectLike = $__require('40');
  var objectTag = '[object Object]';
  var objectProto = Object.prototype;
  var hasOwnProperty = objectProto.hasOwnProperty;
  var objToString = objectProto.toString;
  function isPlainObject(value) {
    var Ctor;
    if (!(isObjectLike(value) && objToString.call(value) == objectTag && !isArguments(value)) || (!hasOwnProperty.call(value, 'constructor') && (Ctor = value.constructor, typeof Ctor == 'function' && !(Ctor instanceof Ctor)))) {
      return false;
    }
    var result;
    baseForIn(value, function(subValue, key) {
      result = key;
    });
    return result === undefined || hasOwnProperty.call(value, result);
  }
  module.exports = isPlainObject;
  return module.exports;
});

$__System.registerDynamic("98", ["40", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var isObjectLike = $__require('40');
  var numberTag = '[object Number]';
  var objectProto = Object.prototype;
  var objToString = objectProto.toString;
  function isNumber(value) {
    return typeof value == 'number' || (isObjectLike(value) && objToString.call(value) == numberTag);
  }
  module.exports = isNumber;
  return module.exports;
});

$__System.registerDynamic("2a", ["3f", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var isObject = $__require('3f');
  var regexpTag = '[object RegExp]';
  var objectProto = Object.prototype;
  var objToString = objectProto.toString;
  function isRegExp(value) {
    return isObject(value) && objToString.call(value) == regexpTag;
  }
  module.exports = isRegExp;
  return module.exports;
});

$__System.registerDynamic("143", ["13a", "65", "4e", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  $__require('13a');
  $__require('65');
  module.exports = $__require('4e').Symbol;
  return module.exports;
});

$__System.registerDynamic("a9", ["143", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  module.exports = {
    "default": $__require('143'),
    __esModule: true
  };
  return module.exports;
});

$__System.registerDynamic("144", ["4f", "108", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var $ = $__require('4f'),
      toIObject = $__require('108');
  module.exports = function(object, el) {
    var O = toIObject(object),
        keys = $.getKeys(O),
        length = keys.length,
        index = 0,
        key;
    while (length > index)
      if (O[key = keys[index++]] === el)
        return key;
  };
  return module.exports;
});

$__System.registerDynamic("104", ["108", "4f", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var toIObject = $__require('108'),
      getNames = $__require('4f').getNames,
      toString = {}.toString;
  var windowNames = typeof window == 'object' && Object.getOwnPropertyNames ? Object.getOwnPropertyNames(window) : [];
  var getWindowNames = function(it) {
    try {
      return getNames(it);
    } catch (e) {
      return windowNames.slice();
    }
  };
  module.exports.get = function getOwnPropertyNames(it) {
    if (windowNames && toString.call(it) == '[object Window]')
      return getWindowNames(it);
    return getNames(toIObject(it));
  };
  return module.exports;
});

$__System.registerDynamic("145", ["4f", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var $ = $__require('4f');
  module.exports = function(it) {
    var keys = $.getKeys(it),
        getSymbols = $.getSymbols;
    if (getSymbols) {
      var symbols = getSymbols(it),
          isEnum = $.isEnum,
          i = 0,
          key;
      while (symbols.length > i)
        if (isEnum.call(it, key = symbols[i++]))
          keys.push(key);
    }
    return keys;
  };
  return module.exports;
});

$__System.registerDynamic("13a", ["4f", "146", "5c", "50", "63", "147", "87", "148", "149", "5b", "51", "144", "104", "145", "14a", "cc", "108", "14b", "14c", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var $ = $__require('4f'),
      global = $__require('146'),
      has = $__require('5c'),
      DESCRIPTORS = $__require('50'),
      $export = $__require('63'),
      redefine = $__require('147'),
      $fails = $__require('87'),
      shared = $__require('148'),
      setToStringTag = $__require('149'),
      uid = $__require('5b'),
      wks = $__require('51'),
      keyOf = $__require('144'),
      $names = $__require('104'),
      enumKeys = $__require('145'),
      isArray = $__require('14a'),
      anObject = $__require('cc'),
      toIObject = $__require('108'),
      createDesc = $__require('14b'),
      getDesc = $.getDesc,
      setDesc = $.setDesc,
      _create = $.create,
      getNames = $names.get,
      $Symbol = global.Symbol,
      $JSON = global.JSON,
      _stringify = $JSON && $JSON.stringify,
      setter = false,
      HIDDEN = wks('_hidden'),
      isEnum = $.isEnum,
      SymbolRegistry = shared('symbol-registry'),
      AllSymbols = shared('symbols'),
      useNative = typeof $Symbol == 'function',
      ObjectProto = Object.prototype;
  var setSymbolDesc = DESCRIPTORS && $fails(function() {
    return _create(setDesc({}, 'a', {get: function() {
        return setDesc(this, 'a', {value: 7}).a;
      }})).a != 7;
  }) ? function(it, key, D) {
    var protoDesc = getDesc(ObjectProto, key);
    if (protoDesc)
      delete ObjectProto[key];
    setDesc(it, key, D);
    if (protoDesc && it !== ObjectProto)
      setDesc(ObjectProto, key, protoDesc);
  } : setDesc;
  var wrap = function(tag) {
    var sym = AllSymbols[tag] = _create($Symbol.prototype);
    sym._k = tag;
    DESCRIPTORS && setter && setSymbolDesc(ObjectProto, tag, {
      configurable: true,
      set: function(value) {
        if (has(this, HIDDEN) && has(this[HIDDEN], tag))
          this[HIDDEN][tag] = false;
        setSymbolDesc(this, tag, createDesc(1, value));
      }
    });
    return sym;
  };
  var isSymbol = function(it) {
    return typeof it == 'symbol';
  };
  var $defineProperty = function defineProperty(it, key, D) {
    if (D && has(AllSymbols, key)) {
      if (!D.enumerable) {
        if (!has(it, HIDDEN))
          setDesc(it, HIDDEN, createDesc(1, {}));
        it[HIDDEN][key] = true;
      } else {
        if (has(it, HIDDEN) && it[HIDDEN][key])
          it[HIDDEN][key] = false;
        D = _create(D, {enumerable: createDesc(0, false)});
      }
      return setSymbolDesc(it, key, D);
    }
    return setDesc(it, key, D);
  };
  var $defineProperties = function defineProperties(it, P) {
    anObject(it);
    var keys = enumKeys(P = toIObject(P)),
        i = 0,
        l = keys.length,
        key;
    while (l > i)
      $defineProperty(it, key = keys[i++], P[key]);
    return it;
  };
  var $create = function create(it, P) {
    return P === undefined ? _create(it) : $defineProperties(_create(it), P);
  };
  var $propertyIsEnumerable = function propertyIsEnumerable(key) {
    var E = isEnum.call(this, key);
    return E || !has(this, key) || !has(AllSymbols, key) || has(this, HIDDEN) && this[HIDDEN][key] ? E : true;
  };
  var $getOwnPropertyDescriptor = function getOwnPropertyDescriptor(it, key) {
    var D = getDesc(it = toIObject(it), key);
    if (D && has(AllSymbols, key) && !(has(it, HIDDEN) && it[HIDDEN][key]))
      D.enumerable = true;
    return D;
  };
  var $getOwnPropertyNames = function getOwnPropertyNames(it) {
    var names = getNames(toIObject(it)),
        result = [],
        i = 0,
        key;
    while (names.length > i)
      if (!has(AllSymbols, key = names[i++]) && key != HIDDEN)
        result.push(key);
    return result;
  };
  var $getOwnPropertySymbols = function getOwnPropertySymbols(it) {
    var names = getNames(toIObject(it)),
        result = [],
        i = 0,
        key;
    while (names.length > i)
      if (has(AllSymbols, key = names[i++]))
        result.push(AllSymbols[key]);
    return result;
  };
  var $stringify = function stringify(it) {
    if (it === undefined || isSymbol(it))
      return;
    var args = [it],
        i = 1,
        $$ = arguments,
        replacer,
        $replacer;
    while ($$.length > i)
      args.push($$[i++]);
    replacer = args[1];
    if (typeof replacer == 'function')
      $replacer = replacer;
    if ($replacer || !isArray(replacer))
      replacer = function(key, value) {
        if ($replacer)
          value = $replacer.call(this, key, value);
        if (!isSymbol(value))
          return value;
      };
    args[1] = replacer;
    return _stringify.apply($JSON, args);
  };
  var buggyJSON = $fails(function() {
    var S = $Symbol();
    return _stringify([S]) != '[null]' || _stringify({a: S}) != '{}' || _stringify(Object(S)) != '{}';
  });
  if (!useNative) {
    $Symbol = function Symbol() {
      if (isSymbol(this))
        throw TypeError('Symbol is not a constructor');
      return wrap(uid(arguments.length > 0 ? arguments[0] : undefined));
    };
    redefine($Symbol.prototype, 'toString', function toString() {
      return this._k;
    });
    isSymbol = function(it) {
      return it instanceof $Symbol;
    };
    $.create = $create;
    $.isEnum = $propertyIsEnumerable;
    $.getDesc = $getOwnPropertyDescriptor;
    $.setDesc = $defineProperty;
    $.setDescs = $defineProperties;
    $.getNames = $names.get = $getOwnPropertyNames;
    $.getSymbols = $getOwnPropertySymbols;
    if (DESCRIPTORS && !$__require('14c')) {
      redefine(ObjectProto, 'propertyIsEnumerable', $propertyIsEnumerable, true);
    }
  }
  var symbolStatics = {
    'for': function(key) {
      return has(SymbolRegistry, key += '') ? SymbolRegistry[key] : SymbolRegistry[key] = $Symbol(key);
    },
    keyFor: function keyFor(key) {
      return keyOf(SymbolRegistry, key);
    },
    useSetter: function() {
      setter = true;
    },
    useSimple: function() {
      setter = false;
    }
  };
  $.each.call(('hasInstance,isConcatSpreadable,iterator,match,replace,search,' + 'species,split,toPrimitive,toStringTag,unscopables').split(','), function(it) {
    var sym = wks(it);
    symbolStatics[it] = useNative ? sym : wrap(sym);
  });
  setter = true;
  $export($export.G + $export.W, {Symbol: $Symbol});
  $export($export.S, 'Symbol', symbolStatics);
  $export($export.S + $export.F * !useNative, 'Object', {
    create: $create,
    defineProperty: $defineProperty,
    defineProperties: $defineProperties,
    getOwnPropertyDescriptor: $getOwnPropertyDescriptor,
    getOwnPropertyNames: $getOwnPropertyNames,
    getOwnPropertySymbols: $getOwnPropertySymbols
  });
  $JSON && $export($export.S + $export.F * (!useNative || buggyJSON), 'JSON', {stringify: $stringify});
  setToStringTag($Symbol, 'Symbol');
  setToStringTag(Math, 'Math', true);
  setToStringTag(global.JSON, 'JSON', true);
  return module.exports;
});

$__System.registerDynamic("14d", ["13a", "4e", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  $__require('13a');
  module.exports = $__require('4e').Object.getOwnPropertySymbols;
  return module.exports;
});

$__System.registerDynamic("14e", ["14d", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  module.exports = {
    "default": $__require('14d'),
    __esModule: true
  };
  return module.exports;
});

$__System.registerDynamic("14f", ["9", "45", "a", "4", "150", "5", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _classCallCheck = $__require('9')["default"];
  var _getIterator = $__require('45')["default"];
  var _interopRequireDefault = $__require('a')["default"];
  var _interopRequireWildcard = $__require('4')["default"];
  exports.__esModule = true;
  var _path = $__require('150');
  var _path2 = _interopRequireDefault(_path);
  var _babelTypes = $__require('5');
  var t = _interopRequireWildcard(_babelTypes);
  var testing = "production" === "test";
  var TraversalContext = (function() {
    function TraversalContext(scope, opts, state, parentPath) {
      _classCallCheck(this, TraversalContext);
      this.queue = null;
      this.parentPath = parentPath;
      this.scope = scope;
      this.state = state;
      this.opts = opts;
    }
    TraversalContext.prototype.shouldVisit = function shouldVisit(node) {
      var opts = this.opts;
      if (opts.enter || opts.exit)
        return true;
      if (opts[node.type])
        return true;
      var keys = t.VISITOR_KEYS[node.type];
      if (!keys || !keys.length)
        return false;
      for (var _iterator = keys,
          _isArray = Array.isArray(_iterator),
          _i = 0,
          _iterator = _isArray ? _iterator : _getIterator(_iterator); ; ) {
        var _ref;
        if (_isArray) {
          if (_i >= _iterator.length)
            break;
          _ref = _iterator[_i++];
        } else {
          _i = _iterator.next();
          if (_i.done)
            break;
          _ref = _i.value;
        }
        var key = _ref;
        if (node[key])
          return true;
      }
      return false;
    };
    TraversalContext.prototype.create = function create(node, obj, key, listKey) {
      return _path2["default"].get({
        parentPath: this.parentPath,
        parent: node,
        container: obj,
        key: key,
        listKey: listKey
      });
    };
    TraversalContext.prototype.maybeQueue = function maybeQueue(path, notPriority) {
      if (this.trap) {
        throw new Error("Infinite cycle detected");
      }
      if (this.queue) {
        if (notPriority) {
          this.queue.push(path);
        } else {
          this.priorityQueue.push(path);
        }
      }
    };
    TraversalContext.prototype.visitMultiple = function visitMultiple(container, parent, listKey) {
      if (container.length === 0)
        return false;
      var queue = [];
      for (var key = 0; key < container.length; key++) {
        var node = container[key];
        if (node && this.shouldVisit(node)) {
          queue.push(this.create(parent, container, key, listKey));
        }
      }
      return this.visitQueue(queue);
    };
    TraversalContext.prototype.visitSingle = function visitSingle(node, key) {
      if (this.shouldVisit(node[key])) {
        return this.visitQueue([this.create(node, node, key)]);
      } else {
        return false;
      }
    };
    TraversalContext.prototype.visitQueue = function visitQueue(queue) {
      this.queue = queue;
      this.priorityQueue = [];
      var visited = [];
      var stop = false;
      for (var _i2 = 0; _i2 < queue.length; _i2++) {
        var path = queue[_i2];
        path.resync();
        if (path.contexts.length === 0 || path.contexts[path.contexts.length - 1] !== this) {
          path.pushContext(this);
        }
        if (path.key === null)
          continue;
        if (testing && queue.length >= 1000) {
          this.trap = true;
        }
        if (visited.indexOf(path.node) >= 0)
          continue;
        visited.push(path.node);
        if (path.visit()) {
          stop = true;
          break;
        }
        if (this.priorityQueue.length) {
          stop = this.visitQueue(this.priorityQueue);
          this.priorityQueue = [];
          this.queue = queue;
          if (stop)
            break;
        }
      }
      for (var _i3 = 0; _i3 < queue.length; _i3++) {
        var path = queue[_i3];
        path.popContext();
      }
      this.queue = null;
      return stop;
    };
    TraversalContext.prototype.visit = function visit(node, key) {
      var nodes = node[key];
      if (!nodes)
        return false;
      if (Array.isArray(nodes)) {
        return this.visitMultiple(nodes, node, key);
      } else {
        return this.visitSingle(node, key);
      }
    };
    return TraversalContext;
  })();
  exports["default"] = TraversalContext;
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("37", ["3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  function arrayCopy(source, array) {
    var index = -1,
        length = source.length;
    array || (array = Array(length));
    while (++index < length) {
      array[index] = source[index];
    }
    return array;
  }
  module.exports = arrayCopy;
  return module.exports;
});

$__System.registerDynamic("3e", ["3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  function arrayEach(array, iteratee) {
    var index = -1,
        length = array.length;
    while (++index < length) {
      if (iteratee(array[index], index, array) === false) {
        break;
      }
    }
    return array;
  }
  module.exports = arrayEach;
  return module.exports;
});

$__System.registerDynamic("112", ["3f", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var isObject = $__require('3f');
  function toObject(value) {
    return isObject(value) ? value : Object(value);
  }
  module.exports = toObject;
  return module.exports;
});

$__System.registerDynamic("151", ["112", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var toObject = $__require('112');
  function createBaseFor(fromRight) {
    return function(object, iteratee, keysFunc) {
      var iterable = toObject(object),
          props = keysFunc(object),
          length = props.length,
          index = fromRight ? length : -1;
      while ((fromRight ? index-- : ++index < length)) {
        var key = props[index];
        if (iteratee(iterable[key], key, iterable) === false) {
          break;
        }
      }
      return object;
    };
  }
  module.exports = createBaseFor;
  return module.exports;
});

$__System.registerDynamic("142", ["151", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var createBaseFor = $__require('151');
  var baseFor = createBaseFor();
  module.exports = baseFor;
  return module.exports;
});

$__System.registerDynamic("113", ["142", "41", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var baseFor = $__require('142'),
      keys = $__require('41');
  function baseForOwn(object, iteratee) {
    return baseFor(object, iteratee, keys);
  }
  module.exports = baseForOwn;
  return module.exports;
});

$__System.registerDynamic("152", ["3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var objectProto = Object.prototype;
  var hasOwnProperty = objectProto.hasOwnProperty;
  function initCloneArray(array) {
    var length = array.length,
        result = new array.constructor(length);
    if (length && typeof array[0] == 'string' && hasOwnProperty.call(array, 'index')) {
      result.index = array.index;
      result.input = array.input;
    }
    return result;
  }
  module.exports = initCloneArray;
  return module.exports;
});

$__System.registerDynamic("153", ["3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var ArrayBuffer = global.ArrayBuffer,
      Uint8Array = global.Uint8Array;
  function bufferClone(buffer) {
    var result = new ArrayBuffer(buffer.byteLength),
        view = new Uint8Array(result);
    view.set(new Uint8Array(buffer));
    return result;
  }
  module.exports = bufferClone;
  return module.exports;
});

$__System.registerDynamic("154", ["153", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var bufferClone = $__require('153');
  var boolTag = '[object Boolean]',
      dateTag = '[object Date]',
      numberTag = '[object Number]',
      regexpTag = '[object RegExp]',
      stringTag = '[object String]';
  var arrayBufferTag = '[object ArrayBuffer]',
      float32Tag = '[object Float32Array]',
      float64Tag = '[object Float64Array]',
      int8Tag = '[object Int8Array]',
      int16Tag = '[object Int16Array]',
      int32Tag = '[object Int32Array]',
      uint8Tag = '[object Uint8Array]',
      uint8ClampedTag = '[object Uint8ClampedArray]',
      uint16Tag = '[object Uint16Array]',
      uint32Tag = '[object Uint32Array]';
  var reFlags = /\w*$/;
  function initCloneByTag(object, tag, isDeep) {
    var Ctor = object.constructor;
    switch (tag) {
      case arrayBufferTag:
        return bufferClone(object);
      case boolTag:
      case dateTag:
        return new Ctor(+object);
      case float32Tag:
      case float64Tag:
      case int8Tag:
      case int16Tag:
      case int32Tag:
      case uint8Tag:
      case uint8ClampedTag:
      case uint16Tag:
      case uint32Tag:
        var buffer = object.buffer;
        return new Ctor(isDeep ? bufferClone(buffer) : buffer, object.byteOffset, object.length);
      case numberTag:
      case stringTag:
        return new Ctor(object);
      case regexpTag:
        var result = new Ctor(object.source, reFlags.exec(object));
        result.lastIndex = object.lastIndex;
    }
    return result;
  }
  module.exports = initCloneByTag;
  return module.exports;
});

$__System.registerDynamic("155", ["3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  function initCloneObject(object) {
    var Ctor = object.constructor;
    if (!(typeof Ctor == 'function' && Ctor instanceof Ctor)) {
      Ctor = Object;
    }
    return new Ctor;
  }
  module.exports = initCloneObject;
  return module.exports;
});

$__System.registerDynamic("f1", ["37", "3e", "156", "113", "152", "154", "155", "39", "3f", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var arrayCopy = $__require('37'),
      arrayEach = $__require('3e'),
      baseAssign = $__require('156'),
      baseForOwn = $__require('113'),
      initCloneArray = $__require('152'),
      initCloneByTag = $__require('154'),
      initCloneObject = $__require('155'),
      isArray = $__require('39'),
      isObject = $__require('3f');
  var argsTag = '[object Arguments]',
      arrayTag = '[object Array]',
      boolTag = '[object Boolean]',
      dateTag = '[object Date]',
      errorTag = '[object Error]',
      funcTag = '[object Function]',
      mapTag = '[object Map]',
      numberTag = '[object Number]',
      objectTag = '[object Object]',
      regexpTag = '[object RegExp]',
      setTag = '[object Set]',
      stringTag = '[object String]',
      weakMapTag = '[object WeakMap]';
  var arrayBufferTag = '[object ArrayBuffer]',
      float32Tag = '[object Float32Array]',
      float64Tag = '[object Float64Array]',
      int8Tag = '[object Int8Array]',
      int16Tag = '[object Int16Array]',
      int32Tag = '[object Int32Array]',
      uint8Tag = '[object Uint8Array]',
      uint8ClampedTag = '[object Uint8ClampedArray]',
      uint16Tag = '[object Uint16Array]',
      uint32Tag = '[object Uint32Array]';
  var cloneableTags = {};
  cloneableTags[argsTag] = cloneableTags[arrayTag] = cloneableTags[arrayBufferTag] = cloneableTags[boolTag] = cloneableTags[dateTag] = cloneableTags[float32Tag] = cloneableTags[float64Tag] = cloneableTags[int8Tag] = cloneableTags[int16Tag] = cloneableTags[int32Tag] = cloneableTags[numberTag] = cloneableTags[objectTag] = cloneableTags[regexpTag] = cloneableTags[stringTag] = cloneableTags[uint8Tag] = cloneableTags[uint8ClampedTag] = cloneableTags[uint16Tag] = cloneableTags[uint32Tag] = true;
  cloneableTags[errorTag] = cloneableTags[funcTag] = cloneableTags[mapTag] = cloneableTags[setTag] = cloneableTags[weakMapTag] = false;
  var objectProto = Object.prototype;
  var objToString = objectProto.toString;
  function baseClone(value, isDeep, customizer, key, object, stackA, stackB) {
    var result;
    if (customizer) {
      result = object ? customizer(value, key, object) : customizer(value);
    }
    if (result !== undefined) {
      return result;
    }
    if (!isObject(value)) {
      return value;
    }
    var isArr = isArray(value);
    if (isArr) {
      result = initCloneArray(value);
      if (!isDeep) {
        return arrayCopy(value, result);
      }
    } else {
      var tag = objToString.call(value),
          isFunc = tag == funcTag;
      if (tag == objectTag || tag == argsTag || (isFunc && !object)) {
        result = initCloneObject(isFunc ? {} : value);
        if (!isDeep) {
          return baseAssign(result, value);
        }
      } else {
        return cloneableTags[tag] ? initCloneByTag(value, tag, isDeep) : (object ? value : {});
      }
    }
    stackA || (stackA = []);
    stackB || (stackB = []);
    var length = stackA.length;
    while (length--) {
      if (stackA[length] == value) {
        return stackB[length];
      }
    }
    stackA.push(value);
    stackB.push(result);
    (isArr ? arrayEach : baseForOwn)(value, function(subValue, key) {
      result[key] = baseClone(subValue, isDeep, customizer, key, value, stackA, stackB);
    });
    return result;
  }
  module.exports = baseClone;
  return module.exports;
});

$__System.registerDynamic("4c", ["f1", "f2", "1a", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var baseClone = $__require('f1'),
      bindCallback = $__require('f2'),
      isIterateeCall = $__require('1a');
  function clone(value, isDeep, customizer, thisArg) {
    if (isDeep && typeof isDeep != 'boolean' && isIterateeCall(value, isDeep, customizer)) {
      isDeep = false;
    } else if (typeof isDeep == 'function') {
      thisArg = customizer;
      customizer = isDeep;
      isDeep = false;
    }
    return typeof customizer == 'function' ? baseClone(value, isDeep, bindCallback(customizer, thisArg, 3)) : baseClone(value, isDeep);
  }
  module.exports = clone;
  return module.exports;
});

$__System.registerDynamic("157", ["74", "45", "4", "a", "158", "4a", "5", "4c", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _Object$keys = $__require('74')["default"];
  var _getIterator = $__require('45')["default"];
  var _interopRequireWildcard = $__require('4')["default"];
  var _interopRequireDefault = $__require('a')["default"];
  exports.__esModule = true;
  exports.explode = explode;
  exports.verify = verify;
  exports.merge = merge;
  var _pathLibVirtualTypes = $__require('158');
  var virtualTypes = _interopRequireWildcard(_pathLibVirtualTypes);
  var _babelMessages = $__require('4a');
  var messages = _interopRequireWildcard(_babelMessages);
  var _babelTypes = $__require('5');
  var t = _interopRequireWildcard(_babelTypes);
  var _lodashLangClone = $__require('4c');
  var _lodashLangClone2 = _interopRequireDefault(_lodashLangClone);
  function explode(visitor) {
    if (visitor._exploded)
      return visitor;
    visitor._exploded = true;
    for (var nodeType in visitor) {
      if (shouldIgnoreKey(nodeType))
        continue;
      var parts = nodeType.split("|");
      if (parts.length === 1)
        continue;
      var fns = visitor[nodeType];
      delete visitor[nodeType];
      for (var _i = 0; _i < parts.length; _i++) {
        var part = parts[_i];
        visitor[part] = fns;
      }
    }
    verify(visitor);
    delete visitor.__esModule;
    ensureEntranceObjects(visitor);
    ensureCallbackArrays(visitor);
    var _arr = _Object$keys(visitor);
    for (var _i2 = 0; _i2 < _arr.length; _i2++) {
      var nodeType = _arr[_i2];
      if (shouldIgnoreKey(nodeType))
        continue;
      var wrapper = virtualTypes[nodeType];
      if (!wrapper)
        continue;
      var fns = visitor[nodeType];
      for (var type in fns) {
        fns[type] = wrapCheck(wrapper, fns[type]);
      }
      delete visitor[nodeType];
      if (wrapper.types) {
        var _arr2 = wrapper.types;
        for (var _i4 = 0; _i4 < _arr2.length; _i4++) {
          var type = _arr2[_i4];
          if (visitor[type]) {
            mergePair(visitor[type], fns);
          } else {
            visitor[type] = fns;
          }
        }
      } else {
        mergePair(visitor, fns);
      }
    }
    for (var nodeType in visitor) {
      if (shouldIgnoreKey(nodeType))
        continue;
      var fns = visitor[nodeType];
      var aliases = t.FLIPPED_ALIAS_KEYS[nodeType];
      var deprecratedKey = t.DEPRECATED_KEYS[nodeType];
      if (deprecratedKey) {
        console.trace("Visitor defined for " + nodeType + " but it has been renamed to " + deprecratedKey);
        aliases = [deprecratedKey];
      }
      if (!aliases)
        continue;
      delete visitor[nodeType];
      for (var _iterator = aliases,
          _isArray = Array.isArray(_iterator),
          _i3 = 0,
          _iterator = _isArray ? _iterator : _getIterator(_iterator); ; ) {
        var _ref;
        if (_isArray) {
          if (_i3 >= _iterator.length)
            break;
          _ref = _iterator[_i3++];
        } else {
          _i3 = _iterator.next();
          if (_i3.done)
            break;
          _ref = _i3.value;
        }
        var alias = _ref;
        var existing = visitor[alias];
        if (existing) {
          mergePair(existing, fns);
        } else {
          visitor[alias] = _lodashLangClone2["default"](fns);
        }
      }
    }
    for (var nodeType in visitor) {
      if (shouldIgnoreKey(nodeType))
        continue;
      ensureCallbackArrays(visitor[nodeType]);
    }
    return visitor;
  }
  function verify(visitor) {
    if (visitor._verified)
      return;
    if (typeof visitor === "function") {
      throw new Error(messages.get("traverseVerifyRootFunction"));
    }
    for (var nodeType in visitor) {
      if (nodeType === "enter" || nodeType === "exit") {
        validateVisitorMethods(nodeType, visitor[nodeType]);
      }
      if (shouldIgnoreKey(nodeType))
        continue;
      if (t.TYPES.indexOf(nodeType) < 0) {
        throw new Error(messages.get("traverseVerifyNodeType", nodeType));
      }
      var visitors = visitor[nodeType];
      if (typeof visitors === "object") {
        for (var visitorKey in visitors) {
          if (visitorKey === "enter" || visitorKey === "exit") {
            validateVisitorMethods(nodeType + "." + visitorKey, visitors[visitorKey]);
          } else {
            throw new Error(messages.get("traverseVerifyVisitorProperty", nodeType, visitorKey));
          }
        }
      }
    }
    visitor._verified = true;
  }
  function validateVisitorMethods(path, val) {
    var fns = [].concat(val);
    for (var _iterator2 = fns,
        _isArray2 = Array.isArray(_iterator2),
        _i5 = 0,
        _iterator2 = _isArray2 ? _iterator2 : _getIterator(_iterator2); ; ) {
      var _ref2;
      if (_isArray2) {
        if (_i5 >= _iterator2.length)
          break;
        _ref2 = _iterator2[_i5++];
      } else {
        _i5 = _iterator2.next();
        if (_i5.done)
          break;
        _ref2 = _i5.value;
      }
      var fn = _ref2;
      if (typeof fn !== "function") {
        throw new TypeError("Non-function found defined in " + path + " with type " + typeof fn);
      }
    }
  }
  function merge(visitors) {
    var states = arguments.length <= 1 || arguments[1] === undefined ? [] : arguments[1];
    var rootVisitor = {};
    for (var i = 0; i < visitors.length; i++) {
      var visitor = visitors[i];
      var state = states[i];
      explode(visitor);
      for (var type in visitor) {
        var visitorType = visitor[type];
        if (state)
          visitorType = wrapWithState(visitorType, state);
        var nodeVisitor = rootVisitor[type] = rootVisitor[type] || {};
        mergePair(nodeVisitor, visitorType);
      }
    }
    return rootVisitor;
  }
  function wrapWithState(oldVisitor, state) {
    var newVisitor = {};
    for (var key in oldVisitor) {
      var fns = oldVisitor[key];
      if (!Array.isArray(fns))
        continue;
      fns = fns.map(function(fn) {
        var newFn = function newFn(path) {
          return fn.call(state, path, state);
        };
        newFn.toString = function() {
          return fn.toString();
        };
        return newFn;
      });
      newVisitor[key] = fns;
    }
    return newVisitor;
  }
  function ensureEntranceObjects(obj) {
    for (var key in obj) {
      if (shouldIgnoreKey(key))
        continue;
      var fns = obj[key];
      if (typeof fns === "function") {
        obj[key] = {enter: fns};
      }
    }
  }
  function ensureCallbackArrays(obj) {
    if (obj.enter && !Array.isArray(obj.enter))
      obj.enter = [obj.enter];
    if (obj.exit && !Array.isArray(obj.exit))
      obj.exit = [obj.exit];
  }
  function wrapCheck(wrapper, fn) {
    var newFn = function newFn(path) {
      if (wrapper.checkPath(path)) {
        return fn.apply(this, arguments);
      }
    };
    newFn.toString = function() {
      return fn.toString();
    };
    return newFn;
  }
  function shouldIgnoreKey(key) {
    if (key[0] === "_")
      return true;
    if (key === "enter" || key === "exit" || key === "shouldSkip")
      return true;
    if (key === "blacklist" || key === "noScope" || key === "skipKeys")
      return true;
    return false;
  }
  function mergePair(dest, src) {
    for (var key in src) {
      dest[key] = [].concat(dest[key] || [], src[key]);
    }
  }
  return module.exports;
});

$__System.registerDynamic("158", ["4", "5", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireWildcard = $__require('4')["default"];
  exports.__esModule = true;
  var _babelTypes = $__require('5');
  var t = _interopRequireWildcard(_babelTypes);
  var ReferencedIdentifier = {
    types: ["Identifier", "JSXIdentifier"],
    checkPath: function checkPath(_ref, opts) {
      var node = _ref.node;
      var parent = _ref.parent;
      if (!t.isIdentifier(node, opts)) {
        if (t.isJSXIdentifier(node, opts)) {
          if (_babelTypes.react.isCompatTag(node.name))
            return false;
        } else {
          return false;
        }
      }
      return t.isReferenced(node, parent);
    }
  };
  exports.ReferencedIdentifier = ReferencedIdentifier;
  var ReferencedMemberExpression = {
    types: ["MemberExpression"],
    checkPath: function checkPath(_ref2) {
      var node = _ref2.node;
      var parent = _ref2.parent;
      return t.isMemberExpression(node) && t.isReferenced(node, parent);
    }
  };
  exports.ReferencedMemberExpression = ReferencedMemberExpression;
  var BindingIdentifier = {
    types: ["Identifier"],
    checkPath: function checkPath(_ref3) {
      var node = _ref3.node;
      var parent = _ref3.parent;
      return t.isIdentifier(node) && t.isBinding(node, parent);
    }
  };
  exports.BindingIdentifier = BindingIdentifier;
  var Statement = {
    types: ["Statement"],
    checkPath: function checkPath(_ref4) {
      var node = _ref4.node;
      var parent = _ref4.parent;
      if (t.isStatement(node)) {
        if (t.isVariableDeclaration(node)) {
          if (t.isForXStatement(parent, {left: node}))
            return false;
          if (t.isForStatement(parent, {init: node}))
            return false;
        }
        return true;
      } else {
        return false;
      }
    }
  };
  exports.Statement = Statement;
  var Expression = {
    types: ["Expression"],
    checkPath: function checkPath(path) {
      if (path.isIdentifier()) {
        return path.isReferencedIdentifier();
      } else {
        return t.isExpression(path.node);
      }
    }
  };
  exports.Expression = Expression;
  var Scope = {
    types: ["Scopable"],
    checkPath: function checkPath(path) {
      return t.isScope(path.node, path.parent);
    }
  };
  exports.Scope = Scope;
  var Referenced = {checkPath: function checkPath(path) {
      return t.isReferenced(path.node, path.parent);
    }};
  exports.Referenced = Referenced;
  var BlockScoped = {checkPath: function checkPath(path) {
      return t.isBlockScoped(path.node);
    }};
  exports.BlockScoped = BlockScoped;
  var Var = {
    types: ["VariableDeclaration"],
    checkPath: function checkPath(path) {
      return t.isVar(path.node);
    }
  };
  exports.Var = Var;
  var User = {checkPath: function checkPath(path) {
      return path.node && !!path.node.loc;
    }};
  exports.User = User;
  var Generated = {checkPath: function checkPath(path) {
      return !path.isUser();
    }};
  exports.Generated = Generated;
  var Pure = {checkPath: function checkPath(path, opts) {
      return path.scope.isPure(path.node, opts);
    }};
  exports.Pure = Pure;
  var Flow = {
    types: ["Flow", "ImportDeclaration", "ExportDeclaration"],
    checkPath: function checkPath(_ref5) {
      var node = _ref5.node;
      if (t.isFlow(node)) {
        return true;
      } else if (t.isImportDeclaration(node)) {
        return node.importKind === "type" || node.importKind === "typeof";
      } else if (t.isExportDeclaration(node)) {
        return node.exportKind === "type";
      } else {
        return false;
      }
    }
  };
  exports.Flow = Flow;
  return module.exports;
});

$__System.registerDynamic("159", ["3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var s = 1000;
  var m = s * 60;
  var h = m * 60;
  var d = h * 24;
  var y = d * 365.25;
  module.exports = function(val, options) {
    options = options || {};
    if ('string' == typeof val)
      return parse(val);
    return options.long ? long(val) : short(val);
  };
  function parse(str) {
    str = '' + str;
    if (str.length > 10000)
      return;
    var match = /^((?:\d+)?\.?\d+) *(milliseconds?|msecs?|ms|seconds?|secs?|s|minutes?|mins?|m|hours?|hrs?|h|days?|d|years?|yrs?|y)?$/i.exec(str);
    if (!match)
      return;
    var n = parseFloat(match[1]);
    var type = (match[2] || 'ms').toLowerCase();
    switch (type) {
      case 'years':
      case 'year':
      case 'yrs':
      case 'yr':
      case 'y':
        return n * y;
      case 'days':
      case 'day':
      case 'd':
        return n * d;
      case 'hours':
      case 'hour':
      case 'hrs':
      case 'hr':
      case 'h':
        return n * h;
      case 'minutes':
      case 'minute':
      case 'mins':
      case 'min':
      case 'm':
        return n * m;
      case 'seconds':
      case 'second':
      case 'secs':
      case 'sec':
      case 's':
        return n * s;
      case 'milliseconds':
      case 'millisecond':
      case 'msecs':
      case 'msec':
      case 'ms':
        return n;
    }
  }
  function short(ms) {
    if (ms >= d)
      return Math.round(ms / d) + 'd';
    if (ms >= h)
      return Math.round(ms / h) + 'h';
    if (ms >= m)
      return Math.round(ms / m) + 'm';
    if (ms >= s)
      return Math.round(ms / s) + 's';
    return ms + 'ms';
  }
  function long(ms) {
    return plural(ms, d, 'day') || plural(ms, h, 'hour') || plural(ms, m, 'minute') || plural(ms, s, 'second') || ms + ' ms';
  }
  function plural(ms, n, name) {
    if (ms < n)
      return;
    if (ms < n * 1.5)
      return Math.floor(ms / n) + ' ' + name;
    return Math.ceil(ms / n) + ' ' + name + 's';
  }
  return module.exports;
});

$__System.registerDynamic("15a", ["159", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  exports = module.exports = debug;
  exports.coerce = coerce;
  exports.disable = disable;
  exports.enable = enable;
  exports.enabled = enabled;
  exports.humanize = $__require('159');
  exports.names = [];
  exports.skips = [];
  exports.formatters = {};
  var prevColor = 0;
  var prevTime;
  function selectColor() {
    return exports.colors[prevColor++ % exports.colors.length];
  }
  function debug(namespace) {
    function disabled() {}
    disabled.enabled = false;
    function enabled() {
      var self = enabled;
      var curr = +new Date();
      var ms = curr - (prevTime || curr);
      self.diff = ms;
      self.prev = prevTime;
      self.curr = curr;
      prevTime = curr;
      if (null == self.useColors)
        self.useColors = exports.useColors();
      if (null == self.color && self.useColors)
        self.color = selectColor();
      var args = Array.prototype.slice.call(arguments);
      args[0] = exports.coerce(args[0]);
      if ('string' !== typeof args[0]) {
        args = ['%o'].concat(args);
      }
      var index = 0;
      args[0] = args[0].replace(/%([a-z%])/g, function(match, format) {
        if (match === '%%')
          return match;
        index++;
        var formatter = exports.formatters[format];
        if ('function' === typeof formatter) {
          var val = args[index];
          match = formatter.call(self, val);
          args.splice(index, 1);
          index--;
        }
        return match;
      });
      if ('function' === typeof exports.formatArgs) {
        args = exports.formatArgs.apply(self, args);
      }
      var logFn = enabled.log || exports.log || console.log.bind(console);
      logFn.apply(self, args);
    }
    enabled.enabled = true;
    var fn = exports.enabled(namespace) ? enabled : disabled;
    fn.namespace = namespace;
    return fn;
  }
  function enable(namespaces) {
    exports.save(namespaces);
    var split = (namespaces || '').split(/[\s,]+/);
    var len = split.length;
    for (var i = 0; i < len; i++) {
      if (!split[i])
        continue;
      namespaces = split[i].replace(/\*/g, '.*?');
      if (namespaces[0] === '-') {
        exports.skips.push(new RegExp('^' + namespaces.substr(1) + '$'));
      } else {
        exports.names.push(new RegExp('^' + namespaces + '$'));
      }
    }
  }
  function disable() {
    exports.enable('');
  }
  function enabled(name) {
    var i,
        len;
    for (i = 0, len = exports.skips.length; i < len; i++) {
      if (exports.skips[i].test(name)) {
        return false;
      }
    }
    for (i = 0, len = exports.names.length; i < len; i++) {
      if (exports.names[i].test(name)) {
        return true;
      }
    }
    return false;
  }
  function coerce(val) {
    if (val instanceof Error)
      return val.stack || val.message;
    return val;
  }
  return module.exports;
});

$__System.registerDynamic("13", ["@node/tty", "@node/util", "15a", "@node/fs", "@node/net", "3"], true, function($__require, exports, module) {
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var tty = $__require('@node/tty');
  var util = $__require('@node/util');
  exports = module.exports = $__require('15a');
  exports.log = log;
  exports.formatArgs = formatArgs;
  exports.save = save;
  exports.load = load;
  exports.useColors = useColors;
  exports.colors = [6, 2, 3, 4, 5, 1];
  var fd = parseInt(process.env.DEBUG_FD, 10) || 2;
  var stream = 1 === fd ? process.stdout : 2 === fd ? process.stderr : createWritableStdioStream(fd);
  function useColors() {
    var debugColors = (process.env.DEBUG_COLORS || '').trim().toLowerCase();
    if (0 === debugColors.length) {
      return tty.isatty(fd);
    } else {
      return '0' !== debugColors && 'no' !== debugColors && 'false' !== debugColors && 'disabled' !== debugColors;
    }
  }
  var inspect = (4 === util.inspect.length ? function(v, colors) {
    return util.inspect(v, void 0, void 0, colors);
  } : function(v, colors) {
    return util.inspect(v, {colors: colors});
  });
  exports.formatters.o = function(v) {
    return inspect(v, this.useColors).replace(/\s*\n\s*/g, ' ');
  };
  function formatArgs() {
    var args = arguments;
    var useColors = this.useColors;
    var name = this.namespace;
    if (useColors) {
      var c = this.color;
      args[0] = '  \u001b[3' + c + ';1m' + name + ' ' + '\u001b[0m' + args[0] + '\u001b[3' + c + 'm' + ' +' + exports.humanize(this.diff) + '\u001b[0m';
    } else {
      args[0] = new Date().toUTCString() + ' ' + name + ' ' + args[0];
    }
    return args;
  }
  function log() {
    return stream.write(util.format.apply(this, arguments) + '\n');
  }
  function save(namespaces) {
    if (null == namespaces) {
      delete process.env.DEBUG;
    } else {
      process.env.DEBUG = namespaces;
    }
  }
  function load() {
    return process.env.DEBUG;
  }
  function createWritableStdioStream(fd) {
    var stream;
    var tty_wrap = process.binding('tty_wrap');
    switch (tty_wrap.guessHandleType(fd)) {
      case 'TTY':
        stream = new tty.WriteStream(fd);
        stream._type = 'tty';
        if (stream._handle && stream._handle.unref) {
          stream._handle.unref();
        }
        break;
      case 'FILE':
        var fs = $__require('@node/fs');
        stream = new fs.SyncWriteStream(fd, {autoClose: false});
        stream._type = 'fs';
        break;
      case 'PIPE':
      case 'TCP':
        var net = $__require('@node/net');
        stream = new net.Socket({
          fd: fd,
          readable: false,
          writable: true
        });
        stream.readable = false;
        stream.read = null;
        stream._type = 'pipe';
        if (stream._handle && stream._handle.unref) {
          stream._handle.unref();
        }
        break;
      default:
        throw new Error('Implement me. Unknown stream file type!');
    }
    stream.fd = fd;
    stream._isStdio = true;
    return stream;
  }
  exports.enable(load());
  return module.exports;
});

$__System.registerDynamic("15b", ["3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var NODE_ENV = "production";
  var invariant = function(condition, format, a, b, c, d, e, f) {
    if (NODE_ENV !== 'production') {
      if (format === undefined) {
        throw new Error('invariant requires an error message argument');
      }
    }
    if (!condition) {
      var error;
      if (format === undefined) {
        error = new Error('Minified exception occurred; use the non-minified dev environment ' + 'for the full error message and additional helpful warnings.');
      } else {
        var args = [a, b, c, d, e, f];
        var argIndex = 0;
        error = new Error(format.replace(/%s/g, function() {
          return args[argIndex++];
        }));
        error.name = 'Invariant Violation';
      }
      error.framesToPop = 1;
      throw error;
    }
  };
  module.exports = invariant;
  return module.exports;
});

$__System.registerDynamic("15c", ["4", "a", "5", "150", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireWildcard = $__require('4')["default"];
  var _interopRequireDefault = $__require('a')["default"];
  exports.__esModule = true;
  exports.findParent = findParent;
  exports.find = find;
  exports.getFunctionParent = getFunctionParent;
  exports.getStatementParent = getStatementParent;
  exports.getEarliestCommonAncestorFrom = getEarliestCommonAncestorFrom;
  exports.getDeepestCommonAncestorFrom = getDeepestCommonAncestorFrom;
  exports.getAncestry = getAncestry;
  exports.inType = inType;
  exports.inShadow = inShadow;
  var _babelTypes = $__require('5');
  var t = _interopRequireWildcard(_babelTypes);
  var _index = $__require('150');
  var _index2 = _interopRequireDefault(_index);
  function findParent(callback) {
    var path = this;
    while (path = path.parentPath) {
      if (callback(path))
        return path;
    }
    return null;
  }
  function find(callback) {
    var path = this;
    do {
      if (callback(path))
        return path;
    } while (path = path.parentPath);
    return null;
  }
  function getFunctionParent() {
    return this.findParent(function(path) {
      return path.isFunction() || path.isProgram();
    });
  }
  function getStatementParent() {
    var path = this;
    do {
      if (Array.isArray(path.container)) {
        return path;
      }
    } while (path = path.parentPath);
  }
  function getEarliestCommonAncestorFrom(paths) {
    return this.getDeepestCommonAncestorFrom(paths, function(deepest, i, ancestries) {
      var earliest = undefined;
      var keys = t.VISITOR_KEYS[deepest.type];
      var _arr = ancestries;
      for (var _i = 0; _i < _arr.length; _i++) {
        var ancestry = _arr[_i];
        var path = ancestry[i + 1];
        if (!earliest) {
          earliest = path;
          continue;
        }
        if (path.listKey && earliest.listKey === path.listKey) {
          if (path.key < earliest.key) {
            earliest = path;
            continue;
          }
        }
        var earliestKeyIndex = keys.indexOf(earliest.parentKey);
        var currentKeyIndex = keys.indexOf(path.parentKey);
        if (earliestKeyIndex > currentKeyIndex) {
          earliest = path;
        }
      }
      return earliest;
    });
  }
  function getDeepestCommonAncestorFrom(paths, filter) {
    var _this = this;
    if (!paths.length) {
      return this;
    }
    if (paths.length === 1) {
      return paths[0];
    }
    var minDepth = Infinity;
    var lastCommonIndex = undefined,
        lastCommon = undefined;
    var ancestries = paths.map(function(path) {
      var ancestry = [];
      do {
        ancestry.unshift(path);
      } while ((path = path.parentPath) && path !== _this);
      if (ancestry.length < minDepth) {
        minDepth = ancestry.length;
      }
      return ancestry;
    });
    var first = ancestries[0];
    depthLoop: for (var i = 0; i < minDepth; i++) {
      var shouldMatch = first[i];
      var _arr2 = ancestries;
      for (var _i2 = 0; _i2 < _arr2.length; _i2++) {
        var ancestry = _arr2[_i2];
        if (ancestry[i] !== shouldMatch) {
          break depthLoop;
        }
      }
      lastCommonIndex = i;
      lastCommon = shouldMatch;
    }
    if (lastCommon) {
      if (filter) {
        return filter(lastCommon, lastCommonIndex, ancestries);
      } else {
        return lastCommon;
      }
    } else {
      throw new Error("Couldn't find intersection");
    }
  }
  function getAncestry() {
    var path = this;
    var paths = [];
    do {
      paths.push(path);
    } while (path = path.parentPath);
    return paths;
  }
  function inType() {
    var path = this;
    while (path) {
      var _arr3 = arguments;
      for (var _i3 = 0; _i3 < _arr3.length; _i3++) {
        var type = _arr3[_i3];
        if (path.node.type === type)
          return true;
      }
      path = path.parentPath;
    }
    return false;
  }
  function inShadow(key) {
    var parentFn = this.isFunction() ? this : this.findParent(function(p) {
      return p.isFunction();
    });
    if (!parentFn)
      return;
    if (parentFn.isFunctionExpression() || parentFn.isFunctionDeclaration()) {
      var shadow = parentFn.node.shadow;
      if (shadow && (!key || shadow[key] !== false)) {
        return parentFn;
      }
    } else if (parentFn.isArrowFunctionExpression()) {
      return parentFn;
    }
    return null;
  }
  return module.exports;
});

$__System.registerDynamic("a4", ["3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  exports["default"] = function(obj) {
    return obj && obj.__esModule ? obj["default"] : obj;
  };
  exports.__esModule = true;
  return module.exports;
});

$__System.registerDynamic("15d", ["4", "5", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireWildcard = $__require('4')["default"];
  exports.__esModule = true;
  var _babelTypes = $__require('5');
  var t = _interopRequireWildcard(_babelTypes);
  exports["default"] = function(node) {
    if (!this.isReferenced())
      return;
    var binding = this.scope.getBinding(node.name);
    if (binding) {
      if (binding.identifier.typeAnnotation) {
        return binding.identifier.typeAnnotation;
      } else {
        return getTypeAnnotationBindingConstantViolations(this, node.name);
      }
    }
    if (node.name === "undefined") {
      return t.voidTypeAnnotation();
    } else if (node.name === "NaN" || node.name === "Infinity") {
      return t.numberTypeAnnotation();
    } else if (node.name === "arguments") {}
  };
  function getTypeAnnotationBindingConstantViolations(path, name) {
    var binding = path.scope.getBinding(name);
    var types = [];
    path.typeAnnotation = t.unionTypeAnnotation(types);
    var functionConstantViolations = [];
    var constantViolations = getConstantViolationsBefore(binding, path, functionConstantViolations);
    var testType = getConditionalAnnotation(path, name);
    if (testType) {
      (function() {
        var testConstantViolations = getConstantViolationsBefore(binding, testType.ifStatement);
        constantViolations = constantViolations.filter(function(path) {
          return testConstantViolations.indexOf(path) < 0;
        });
        types.push(testType.typeAnnotation);
      })();
    }
    if (constantViolations.length) {
      constantViolations = constantViolations.concat(functionConstantViolations);
      var _arr = constantViolations;
      for (var _i = 0; _i < _arr.length; _i++) {
        var violation = _arr[_i];
        types.push(violation.getTypeAnnotation());
      }
    }
    if (types.length) {
      return t.createUnionTypeAnnotation(types);
    }
  }
  function getConstantViolationsBefore(binding, path, functions) {
    var violations = binding.constantViolations.slice();
    violations.unshift(binding.path);
    return violations.filter(function(violation) {
      violation = violation.resolve();
      var status = violation._guessExecutionStatusRelativeTo(path);
      if (functions && status === "function")
        functions.push(violation);
      return status === "before";
    });
  }
  function inferAnnotationFromBinaryExpression(name, path) {
    var operator = path.node.operator;
    var right = path.get("right").resolve();
    var left = path.get("left").resolve();
    var target = undefined;
    if (left.isIdentifier({name: name})) {
      target = right;
    } else if (right.isIdentifier({name: name})) {
      target = left;
    }
    if (target) {
      if (operator === "===") {
        return target.getTypeAnnotation();
      } else if (t.BOOLEAN_NUMBER_BINARY_OPERATORS.indexOf(operator) >= 0) {
        return t.numberTypeAnnotation();
      } else {
        return;
      }
    } else {
      if (operator !== "===")
        return;
    }
    var typeofPath = undefined;
    var typePath = undefined;
    if (left.isUnaryExpression({operator: "typeof"})) {
      typeofPath = left;
      typePath = right;
    } else if (right.isUnaryExpression({operator: "typeof"})) {
      typeofPath = right;
      typePath = left;
    }
    if (!typePath && !typeofPath)
      return;
    typePath = typePath.resolve();
    if (!typePath.isLiteral())
      return;
    var typeValue = typePath.node.value;
    if (typeof typeValue !== "string")
      return;
    if (!typeofPath.get("argument").isIdentifier({name: name}))
      return;
    return t.createTypeAnnotationBasedOnTypeof(typePath.node.value);
  }
  function getParentConditionalPath(path) {
    var parentPath = undefined;
    while (parentPath = path.parentPath) {
      if (parentPath.isIfStatement() || parentPath.isConditionalExpression()) {
        if (path.key === "test") {
          return;
        } else {
          return parentPath;
        }
      } else {
        path = parentPath;
      }
    }
  }
  function getConditionalAnnotation(path, name) {
    var ifStatement = getParentConditionalPath(path);
    if (!ifStatement)
      return;
    var test = ifStatement.get("test");
    var paths = [test];
    var types = [];
    do {
      var _path = paths.shift().resolve();
      if (_path.isLogicalExpression()) {
        paths.push(_path.get("left"));
        paths.push(_path.get("right"));
      }
      if (_path.isBinaryExpression()) {
        var type = inferAnnotationFromBinaryExpression(name, _path);
        if (type)
          types.push(type);
      }
    } while (paths.length);
    if (types.length) {
      return {
        typeAnnotation: t.createUnionTypeAnnotation(types),
        ifStatement: ifStatement
      };
    } else {
      return getConditionalAnnotation(ifStatement, name);
    }
  }
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("15e", ["4", "a4", "5", "15d", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireWildcard = $__require('4')["default"];
  var _interopRequire = $__require('a4')["default"];
  exports.__esModule = true;
  exports.VariableDeclarator = VariableDeclarator;
  exports.TypeCastExpression = TypeCastExpression;
  exports.NewExpression = NewExpression;
  exports.TemplateLiteral = TemplateLiteral;
  exports.UnaryExpression = UnaryExpression;
  exports.BinaryExpression = BinaryExpression;
  exports.LogicalExpression = LogicalExpression;
  exports.ConditionalExpression = ConditionalExpression;
  exports.SequenceExpression = SequenceExpression;
  exports.AssignmentExpression = AssignmentExpression;
  exports.UpdateExpression = UpdateExpression;
  exports.StringLiteral = StringLiteral;
  exports.NumericLiteral = NumericLiteral;
  exports.BooleanLiteral = BooleanLiteral;
  exports.NullLiteral = NullLiteral;
  exports.RegExpLiteral = RegExpLiteral;
  exports.ObjectExpression = ObjectExpression;
  exports.ArrayExpression = ArrayExpression;
  exports.RestElement = RestElement;
  exports.CallExpression = CallExpression;
  exports.TaggedTemplateExpression = TaggedTemplateExpression;
  var _babelTypes = $__require('5');
  var t = _interopRequireWildcard(_babelTypes);
  var _infererReference = $__require('15d');
  exports.Identifier = _interopRequire(_infererReference);
  function VariableDeclarator() {
    var id = this.get("id");
    if (id.isIdentifier()) {
      return this.get("init").getTypeAnnotation();
    } else {
      return;
    }
  }
  function TypeCastExpression(node) {
    return node.typeAnnotation;
  }
  TypeCastExpression.validParent = true;
  function NewExpression(node) {
    if (this.get("callee").isIdentifier()) {
      return t.genericTypeAnnotation(node.callee);
    }
  }
  function TemplateLiteral() {
    return t.stringTypeAnnotation();
  }
  function UnaryExpression(node) {
    var operator = node.operator;
    if (operator === "void") {
      return t.voidTypeAnnotation();
    } else if (t.NUMBER_UNARY_OPERATORS.indexOf(operator) >= 0) {
      return t.numberTypeAnnotation();
    } else if (t.STRING_UNARY_OPERATORS.indexOf(operator) >= 0) {
      return t.stringTypeAnnotation();
    } else if (t.BOOLEAN_UNARY_OPERATORS.indexOf(operator) >= 0) {
      return t.booleanTypeAnnotation();
    }
  }
  function BinaryExpression(node) {
    var operator = node.operator;
    if (t.NUMBER_BINARY_OPERATORS.indexOf(operator) >= 0) {
      return t.numberTypeAnnotation();
    } else if (t.BOOLEAN_BINARY_OPERATORS.indexOf(operator) >= 0) {
      return t.booleanTypeAnnotation();
    } else if (operator === "+") {
      var right = this.get("right");
      var left = this.get("left");
      if (left.isBaseType("number") && right.isBaseType("number")) {
        return t.numberTypeAnnotation();
      } else if (left.isBaseType("string") || right.isBaseType("string")) {
        return t.stringTypeAnnotation();
      }
      return t.unionTypeAnnotation([t.stringTypeAnnotation(), t.numberTypeAnnotation()]);
    }
  }
  function LogicalExpression() {
    return t.createUnionTypeAnnotation([this.get("left").getTypeAnnotation(), this.get("right").getTypeAnnotation()]);
  }
  function ConditionalExpression() {
    return t.createUnionTypeAnnotation([this.get("consequent").getTypeAnnotation(), this.get("alternate").getTypeAnnotation()]);
  }
  function SequenceExpression() {
    return this.get("expressions").pop().getTypeAnnotation();
  }
  function AssignmentExpression() {
    return this.get("right").getTypeAnnotation();
  }
  function UpdateExpression(node) {
    var operator = node.operator;
    if (operator === "++" || operator === "--") {
      return t.numberTypeAnnotation();
    }
  }
  function StringLiteral() {
    return t.stringTypeAnnotation();
  }
  function NumericLiteral() {
    return t.numberTypeAnnotation();
  }
  function BooleanLiteral() {
    return t.booleanTypeAnnotation();
  }
  function NullLiteral() {
    return t.nullLiteralTypeAnnotation();
  }
  function RegExpLiteral() {
    return t.genericTypeAnnotation(t.identifier("RegExp"));
  }
  function ObjectExpression() {
    return t.genericTypeAnnotation(t.identifier("Object"));
  }
  function ArrayExpression() {
    return t.genericTypeAnnotation(t.identifier("Array"));
  }
  function RestElement() {
    return ArrayExpression();
  }
  RestElement.validParent = true;
  function Func() {
    return t.genericTypeAnnotation(t.identifier("Function"));
  }
  exports.Function = Func;
  exports.Class = Func;
  function CallExpression() {
    return resolveCall(this.get("callee"));
  }
  function TaggedTemplateExpression() {
    return resolveCall(this.get("tag"));
  }
  function resolveCall(callee) {
    callee = callee.resolve();
    if (callee.isFunction()) {
      if (callee.is("async")) {
        if (callee.is("generator")) {
          return t.genericTypeAnnotation(t.identifier("AsyncIterator"));
        } else {
          return t.genericTypeAnnotation(t.identifier("Promise"));
        }
      } else {
        if (callee.node.returnType) {
          return callee.node.returnType;
        } else {}
      }
    }
  }
  return module.exports;
});

$__System.registerDynamic("15f", ["4", "15e", "5", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireWildcard = $__require('4')["default"];
  exports.__esModule = true;
  exports.getTypeAnnotation = getTypeAnnotation;
  exports._getTypeAnnotation = _getTypeAnnotation;
  exports.isBaseType = isBaseType;
  exports.couldBeBaseType = couldBeBaseType;
  exports.baseTypeStrictlyMatches = baseTypeStrictlyMatches;
  exports.isGenericType = isGenericType;
  var _inferers = $__require('15e');
  var inferers = _interopRequireWildcard(_inferers);
  var _babelTypes = $__require('5');
  var t = _interopRequireWildcard(_babelTypes);
  function getTypeAnnotation() {
    if (this.typeAnnotation)
      return this.typeAnnotation;
    var type = this._getTypeAnnotation() || t.anyTypeAnnotation();
    if (t.isTypeAnnotation(type))
      type = type.typeAnnotation;
    return this.typeAnnotation = type;
  }
  function _getTypeAnnotation() {
    var node = this.node;
    if (!node) {
      if (this.key === "init" && this.parentPath.isVariableDeclarator()) {
        var declar = this.parentPath.parentPath;
        var declarParent = declar.parentPath;
        if (declar.key === "left" && declarParent.isForInStatement()) {
          return t.stringTypeAnnotation();
        }
        if (declar.key === "left" && declarParent.isForOfStatement()) {
          return t.anyTypeAnnotation();
        }
        return t.voidTypeAnnotation();
      } else {
        return;
      }
    }
    if (node.typeAnnotation) {
      return node.typeAnnotation;
    }
    var inferer = inferers[node.type];
    if (inferer) {
      return inferer.call(this, node);
    }
    inferer = inferers[this.parentPath.type];
    if (inferer && inferer.validParent) {
      return this.parentPath.getTypeAnnotation();
    }
  }
  function isBaseType(baseName, soft) {
    return _isBaseType(baseName, this.getTypeAnnotation(), soft);
  }
  function _isBaseType(baseName, type, soft) {
    if (baseName === "string") {
      return t.isStringTypeAnnotation(type);
    } else if (baseName === "number") {
      return t.isNumberTypeAnnotation(type);
    } else if (baseName === "boolean") {
      return t.isBooleanTypeAnnotation(type);
    } else if (baseName === "any") {
      return t.isAnyTypeAnnotation(type);
    } else if (baseName === "mixed") {
      return t.isMixedTypeAnnotation(type);
    } else if (baseName === "void") {
      return t.isVoidTypeAnnotation(type);
    } else {
      if (soft) {
        return false;
      } else {
        throw new Error("Unknown base type " + baseName);
      }
    }
  }
  function couldBeBaseType(name) {
    var type = this.getTypeAnnotation();
    if (t.isAnyTypeAnnotation(type))
      return true;
    if (t.isUnionTypeAnnotation(type)) {
      var _arr = type.types;
      for (var _i = 0; _i < _arr.length; _i++) {
        var type2 = _arr[_i];
        if (t.isAnyTypeAnnotation(type2) || _isBaseType(name, type2, true)) {
          return true;
        }
      }
      return false;
    } else {
      return _isBaseType(name, type, true);
    }
  }
  function baseTypeStrictlyMatches(right) {
    var left = this.getTypeAnnotation();
    right = right.getTypeAnnotation();
    if (!t.isAnyTypeAnnotation(left) && t.isFlowBaseAnnotation(left)) {
      return right.type === left.type;
    }
  }
  function isGenericType(genericName) {
    var type = this.getTypeAnnotation();
    return t.isGenericTypeAnnotation(type) && t.isIdentifier(type.id, {name: genericName});
  }
  return module.exports;
});

$__System.registerDynamic("160", [], true, function($__require, exports, module) {
  ;
  var define,
      global = this,
      GLOBAL = this;
  module.exports = /((['"])(?:(?!\2|\\).|\\(?:\r\n|[\s\S]))*(\2)?|`(?:[^`\\$]|\\[\s\S]|\$(?!\{)|\$\{(?:[^{}]|\{[^}]*\}?)*\}?)*(`)?)|(\/\/.*)|(\/\*(?:[^*]|\*(?!\/))*(\*\/)?)|(\/(?!\*)(?:\[(?:(?![\]\\]).|\\.)*\]|(?![\/\]\\]).|\\.)+\/(?:(?!\s*(?:\b|[\u0080-\uFFFF$\\'"~({]|[+\-!](?!=)|\.?\d))|[gmiyu]{1,5}\b(?![\u0080-\uFFFF$\\]|\s*(?:[+\-*%&|^<>!=?({]|\/(?![\/*])))))|(0[xX][\da-fA-F]+|0[oO][0-7]+|0[bB][01]+|(?:\d*\.\d+|\d+\.?)(?:[eE][+-]?\d+)?)|((?!\d)(?:(?!\s)[$\w\u0080-\uFFFF]|\\u[\da-fA-F]{4}|\\u\{[\da-fA-F]{1,6}\})+)|(--|\+\+|&&|\|\||=>|\.{3}|(?:[+\-*\/%&|^]|<{1,2}|>{1,3}|!=?|={1,2})=?|[?~.,:;[\](){}])|(\s+)|(^$|[\s\S])/g;
  module.exports.matchToToken = function(match) {
    var token = {
      type: "invalid",
      value: match[0]
    };
    if (match[1])
      token.type = "string", token.closed = !!(match[3] || match[4]);
    else if (match[5])
      token.type = "comment";
    else if (match[6])
      token.type = "comment", token.closed = !!match[7];
    else if (match[8])
      token.type = "regex";
    else if (match[9])
      token.type = "number";
    else if (match[10])
      token.type = "name";
    else if (match[11])
      token.type = "punctuator";
    else if (match[12])
      token.type = "whitespace";
    return token;
  };
  return module.exports;
});

$__System.registerDynamic("161", [], true, function($__require, exports, module) {
  ;
  var define,
      global = this,
      GLOBAL = this;
  (function() {
    'use strict';
    function isExpression(node) {
      if (node == null) {
        return false;
      }
      switch (node.type) {
        case 'ArrayExpression':
        case 'AssignmentExpression':
        case 'BinaryExpression':
        case 'CallExpression':
        case 'ConditionalExpression':
        case 'FunctionExpression':
        case 'Identifier':
        case 'Literal':
        case 'LogicalExpression':
        case 'MemberExpression':
        case 'NewExpression':
        case 'ObjectExpression':
        case 'SequenceExpression':
        case 'ThisExpression':
        case 'UnaryExpression':
        case 'UpdateExpression':
          return true;
      }
      return false;
    }
    function isIterationStatement(node) {
      if (node == null) {
        return false;
      }
      switch (node.type) {
        case 'DoWhileStatement':
        case 'ForInStatement':
        case 'ForStatement':
        case 'WhileStatement':
          return true;
      }
      return false;
    }
    function isStatement(node) {
      if (node == null) {
        return false;
      }
      switch (node.type) {
        case 'BlockStatement':
        case 'BreakStatement':
        case 'ContinueStatement':
        case 'DebuggerStatement':
        case 'DoWhileStatement':
        case 'EmptyStatement':
        case 'ExpressionStatement':
        case 'ForInStatement':
        case 'ForStatement':
        case 'IfStatement':
        case 'LabeledStatement':
        case 'ReturnStatement':
        case 'SwitchStatement':
        case 'ThrowStatement':
        case 'TryStatement':
        case 'VariableDeclaration':
        case 'WhileStatement':
        case 'WithStatement':
          return true;
      }
      return false;
    }
    function isSourceElement(node) {
      return isStatement(node) || node != null && node.type === 'FunctionDeclaration';
    }
    function trailingStatement(node) {
      switch (node.type) {
        case 'IfStatement':
          if (node.alternate != null) {
            return node.alternate;
          }
          return node.consequent;
        case 'LabeledStatement':
        case 'ForStatement':
        case 'ForInStatement':
        case 'WhileStatement':
        case 'WithStatement':
          return node.body;
      }
      return null;
    }
    function isProblematicIfStatement(node) {
      var current;
      if (node.type !== 'IfStatement') {
        return false;
      }
      if (node.alternate == null) {
        return false;
      }
      current = node.consequent;
      do {
        if (current.type === 'IfStatement') {
          if (current.alternate == null) {
            return true;
          }
        }
        current = trailingStatement(current);
      } while (current);
      return false;
    }
    module.exports = {
      isExpression: isExpression,
      isStatement: isStatement,
      isIterationStatement: isIterationStatement,
      isSourceElement: isSourceElement,
      isProblematicIfStatement: isProblematicIfStatement,
      trailingStatement: trailingStatement
    };
  }());
  return module.exports;
});

$__System.registerDynamic("162", [], true, function($__require, exports, module) {
  ;
  var define,
      global = this,
      GLOBAL = this;
  (function() {
    'use strict';
    var ES6Regex,
        ES5Regex,
        NON_ASCII_WHITESPACES,
        IDENTIFIER_START,
        IDENTIFIER_PART,
        ch;
    ES5Regex = {
      NonAsciiIdentifierStart: /[\xAA\xB5\xBA\xC0-\xD6\xD8-\xF6\xF8-\u02C1\u02C6-\u02D1\u02E0-\u02E4\u02EC\u02EE\u0370-\u0374\u0376\u0377\u037A-\u037D\u037F\u0386\u0388-\u038A\u038C\u038E-\u03A1\u03A3-\u03F5\u03F7-\u0481\u048A-\u052F\u0531-\u0556\u0559\u0561-\u0587\u05D0-\u05EA\u05F0-\u05F2\u0620-\u064A\u066E\u066F\u0671-\u06D3\u06D5\u06E5\u06E6\u06EE\u06EF\u06FA-\u06FC\u06FF\u0710\u0712-\u072F\u074D-\u07A5\u07B1\u07CA-\u07EA\u07F4\u07F5\u07FA\u0800-\u0815\u081A\u0824\u0828\u0840-\u0858\u08A0-\u08B2\u0904-\u0939\u093D\u0950\u0958-\u0961\u0971-\u0980\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2\u09B6-\u09B9\u09BD\u09CE\u09DC\u09DD\u09DF-\u09E1\u09F0\u09F1\u0A05-\u0A0A\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39\u0A59-\u0A5C\u0A5E\u0A72-\u0A74\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABD\u0AD0\u0AE0\u0AE1\u0B05-\u0B0C\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3D\u0B5C\u0B5D\u0B5F-\u0B61\u0B71\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BD0\u0C05-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C39\u0C3D\u0C58\u0C59\u0C60\u0C61\u0C85-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3\u0CB5-\u0CB9\u0CBD\u0CDE\u0CE0\u0CE1\u0CF1\u0CF2\u0D05-\u0D0C\u0D0E-\u0D10\u0D12-\u0D3A\u0D3D\u0D4E\u0D60\u0D61\u0D7A-\u0D7F\u0D85-\u0D96\u0D9A-\u0DB1\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0E01-\u0E30\u0E32\u0E33\u0E40-\u0E46\u0E81\u0E82\u0E84\u0E87\u0E88\u0E8A\u0E8D\u0E94-\u0E97\u0E99-\u0E9F\u0EA1-\u0EA3\u0EA5\u0EA7\u0EAA\u0EAB\u0EAD-\u0EB0\u0EB2\u0EB3\u0EBD\u0EC0-\u0EC4\u0EC6\u0EDC-\u0EDF\u0F00\u0F40-\u0F47\u0F49-\u0F6C\u0F88-\u0F8C\u1000-\u102A\u103F\u1050-\u1055\u105A-\u105D\u1061\u1065\u1066\u106E-\u1070\u1075-\u1081\u108E\u10A0-\u10C5\u10C7\u10CD\u10D0-\u10FA\u10FC-\u1248\u124A-\u124D\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310\u1312-\u1315\u1318-\u135A\u1380-\u138F\u13A0-\u13F4\u1401-\u166C\u166F-\u167F\u1681-\u169A\u16A0-\u16EA\u16EE-\u16F8\u1700-\u170C\u170E-\u1711\u1720-\u1731\u1740-\u1751\u1760-\u176C\u176E-\u1770\u1780-\u17B3\u17D7\u17DC\u1820-\u1877\u1880-\u18A8\u18AA\u18B0-\u18F5\u1900-\u191E\u1950-\u196D\u1970-\u1974\u1980-\u19AB\u19C1-\u19C7\u1A00-\u1A16\u1A20-\u1A54\u1AA7\u1B05-\u1B33\u1B45-\u1B4B\u1B83-\u1BA0\u1BAE\u1BAF\u1BBA-\u1BE5\u1C00-\u1C23\u1C4D-\u1C4F\u1C5A-\u1C7D\u1CE9-\u1CEC\u1CEE-\u1CF1\u1CF5\u1CF6\u1D00-\u1DBF\u1E00-\u1F15\u1F18-\u1F1D\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59\u1F5B\u1F5D\u1F5F-\u1F7D\u1F80-\u1FB4\u1FB6-\u1FBC\u1FBE\u1FC2-\u1FC4\u1FC6-\u1FCC\u1FD0-\u1FD3\u1FD6-\u1FDB\u1FE0-\u1FEC\u1FF2-\u1FF4\u1FF6-\u1FFC\u2071\u207F\u2090-\u209C\u2102\u2107\u210A-\u2113\u2115\u2119-\u211D\u2124\u2126\u2128\u212A-\u212D\u212F-\u2139\u213C-\u213F\u2145-\u2149\u214E\u2160-\u2188\u2C00-\u2C2E\u2C30-\u2C5E\u2C60-\u2CE4\u2CEB-\u2CEE\u2CF2\u2CF3\u2D00-\u2D25\u2D27\u2D2D\u2D30-\u2D67\u2D6F\u2D80-\u2D96\u2DA0-\u2DA6\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE\u2DD0-\u2DD6\u2DD8-\u2DDE\u2E2F\u3005-\u3007\u3021-\u3029\u3031-\u3035\u3038-\u303C\u3041-\u3096\u309D-\u309F\u30A1-\u30FA\u30FC-\u30FF\u3105-\u312D\u3131-\u318E\u31A0-\u31BA\u31F0-\u31FF\u3400-\u4DB5\u4E00-\u9FCC\uA000-\uA48C\uA4D0-\uA4FD\uA500-\uA60C\uA610-\uA61F\uA62A\uA62B\uA640-\uA66E\uA67F-\uA69D\uA6A0-\uA6EF\uA717-\uA71F\uA722-\uA788\uA78B-\uA78E\uA790-\uA7AD\uA7B0\uA7B1\uA7F7-\uA801\uA803-\uA805\uA807-\uA80A\uA80C-\uA822\uA840-\uA873\uA882-\uA8B3\uA8F2-\uA8F7\uA8FB\uA90A-\uA925\uA930-\uA946\uA960-\uA97C\uA984-\uA9B2\uA9CF\uA9E0-\uA9E4\uA9E6-\uA9EF\uA9FA-\uA9FE\uAA00-\uAA28\uAA40-\uAA42\uAA44-\uAA4B\uAA60-\uAA76\uAA7A\uAA7E-\uAAAF\uAAB1\uAAB5\uAAB6\uAAB9-\uAABD\uAAC0\uAAC2\uAADB-\uAADD\uAAE0-\uAAEA\uAAF2-\uAAF4\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E\uAB30-\uAB5A\uAB5C-\uAB5F\uAB64\uAB65\uABC0-\uABE2\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D\uFA70-\uFAD9\uFB00-\uFB06\uFB13-\uFB17\uFB1D\uFB1F-\uFB28\uFB2A-\uFB36\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBB1\uFBD3-\uFD3D\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFB\uFE70-\uFE74\uFE76-\uFEFC\uFF21-\uFF3A\uFF41-\uFF5A\uFF66-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF\uFFD2-\uFFD7\uFFDA-\uFFDC]/,
      NonAsciiIdentifierPart: /[\xAA\xB5\xBA\xC0-\xD6\xD8-\xF6\xF8-\u02C1\u02C6-\u02D1\u02E0-\u02E4\u02EC\u02EE\u0300-\u0374\u0376\u0377\u037A-\u037D\u037F\u0386\u0388-\u038A\u038C\u038E-\u03A1\u03A3-\u03F5\u03F7-\u0481\u0483-\u0487\u048A-\u052F\u0531-\u0556\u0559\u0561-\u0587\u0591-\u05BD\u05BF\u05C1\u05C2\u05C4\u05C5\u05C7\u05D0-\u05EA\u05F0-\u05F2\u0610-\u061A\u0620-\u0669\u066E-\u06D3\u06D5-\u06DC\u06DF-\u06E8\u06EA-\u06FC\u06FF\u0710-\u074A\u074D-\u07B1\u07C0-\u07F5\u07FA\u0800-\u082D\u0840-\u085B\u08A0-\u08B2\u08E4-\u0963\u0966-\u096F\u0971-\u0983\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2\u09B6-\u09B9\u09BC-\u09C4\u09C7\u09C8\u09CB-\u09CE\u09D7\u09DC\u09DD\u09DF-\u09E3\u09E6-\u09F1\u0A01-\u0A03\u0A05-\u0A0A\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39\u0A3C\u0A3E-\u0A42\u0A47\u0A48\u0A4B-\u0A4D\u0A51\u0A59-\u0A5C\u0A5E\u0A66-\u0A75\u0A81-\u0A83\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABC-\u0AC5\u0AC7-\u0AC9\u0ACB-\u0ACD\u0AD0\u0AE0-\u0AE3\u0AE6-\u0AEF\u0B01-\u0B03\u0B05-\u0B0C\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3C-\u0B44\u0B47\u0B48\u0B4B-\u0B4D\u0B56\u0B57\u0B5C\u0B5D\u0B5F-\u0B63\u0B66-\u0B6F\u0B71\u0B82\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BBE-\u0BC2\u0BC6-\u0BC8\u0BCA-\u0BCD\u0BD0\u0BD7\u0BE6-\u0BEF\u0C00-\u0C03\u0C05-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C39\u0C3D-\u0C44\u0C46-\u0C48\u0C4A-\u0C4D\u0C55\u0C56\u0C58\u0C59\u0C60-\u0C63\u0C66-\u0C6F\u0C81-\u0C83\u0C85-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3\u0CB5-\u0CB9\u0CBC-\u0CC4\u0CC6-\u0CC8\u0CCA-\u0CCD\u0CD5\u0CD6\u0CDE\u0CE0-\u0CE3\u0CE6-\u0CEF\u0CF1\u0CF2\u0D01-\u0D03\u0D05-\u0D0C\u0D0E-\u0D10\u0D12-\u0D3A\u0D3D-\u0D44\u0D46-\u0D48\u0D4A-\u0D4E\u0D57\u0D60-\u0D63\u0D66-\u0D6F\u0D7A-\u0D7F\u0D82\u0D83\u0D85-\u0D96\u0D9A-\u0DB1\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0DCA\u0DCF-\u0DD4\u0DD6\u0DD8-\u0DDF\u0DE6-\u0DEF\u0DF2\u0DF3\u0E01-\u0E3A\u0E40-\u0E4E\u0E50-\u0E59\u0E81\u0E82\u0E84\u0E87\u0E88\u0E8A\u0E8D\u0E94-\u0E97\u0E99-\u0E9F\u0EA1-\u0EA3\u0EA5\u0EA7\u0EAA\u0EAB\u0EAD-\u0EB9\u0EBB-\u0EBD\u0EC0-\u0EC4\u0EC6\u0EC8-\u0ECD\u0ED0-\u0ED9\u0EDC-\u0EDF\u0F00\u0F18\u0F19\u0F20-\u0F29\u0F35\u0F37\u0F39\u0F3E-\u0F47\u0F49-\u0F6C\u0F71-\u0F84\u0F86-\u0F97\u0F99-\u0FBC\u0FC6\u1000-\u1049\u1050-\u109D\u10A0-\u10C5\u10C7\u10CD\u10D0-\u10FA\u10FC-\u1248\u124A-\u124D\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310\u1312-\u1315\u1318-\u135A\u135D-\u135F\u1380-\u138F\u13A0-\u13F4\u1401-\u166C\u166F-\u167F\u1681-\u169A\u16A0-\u16EA\u16EE-\u16F8\u1700-\u170C\u170E-\u1714\u1720-\u1734\u1740-\u1753\u1760-\u176C\u176E-\u1770\u1772\u1773\u1780-\u17D3\u17D7\u17DC\u17DD\u17E0-\u17E9\u180B-\u180D\u1810-\u1819\u1820-\u1877\u1880-\u18AA\u18B0-\u18F5\u1900-\u191E\u1920-\u192B\u1930-\u193B\u1946-\u196D\u1970-\u1974\u1980-\u19AB\u19B0-\u19C9\u19D0-\u19D9\u1A00-\u1A1B\u1A20-\u1A5E\u1A60-\u1A7C\u1A7F-\u1A89\u1A90-\u1A99\u1AA7\u1AB0-\u1ABD\u1B00-\u1B4B\u1B50-\u1B59\u1B6B-\u1B73\u1B80-\u1BF3\u1C00-\u1C37\u1C40-\u1C49\u1C4D-\u1C7D\u1CD0-\u1CD2\u1CD4-\u1CF6\u1CF8\u1CF9\u1D00-\u1DF5\u1DFC-\u1F15\u1F18-\u1F1D\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59\u1F5B\u1F5D\u1F5F-\u1F7D\u1F80-\u1FB4\u1FB6-\u1FBC\u1FBE\u1FC2-\u1FC4\u1FC6-\u1FCC\u1FD0-\u1FD3\u1FD6-\u1FDB\u1FE0-\u1FEC\u1FF2-\u1FF4\u1FF6-\u1FFC\u200C\u200D\u203F\u2040\u2054\u2071\u207F\u2090-\u209C\u20D0-\u20DC\u20E1\u20E5-\u20F0\u2102\u2107\u210A-\u2113\u2115\u2119-\u211D\u2124\u2126\u2128\u212A-\u212D\u212F-\u2139\u213C-\u213F\u2145-\u2149\u214E\u2160-\u2188\u2C00-\u2C2E\u2C30-\u2C5E\u2C60-\u2CE4\u2CEB-\u2CF3\u2D00-\u2D25\u2D27\u2D2D\u2D30-\u2D67\u2D6F\u2D7F-\u2D96\u2DA0-\u2DA6\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE\u2DD0-\u2DD6\u2DD8-\u2DDE\u2DE0-\u2DFF\u2E2F\u3005-\u3007\u3021-\u302F\u3031-\u3035\u3038-\u303C\u3041-\u3096\u3099\u309A\u309D-\u309F\u30A1-\u30FA\u30FC-\u30FF\u3105-\u312D\u3131-\u318E\u31A0-\u31BA\u31F0-\u31FF\u3400-\u4DB5\u4E00-\u9FCC\uA000-\uA48C\uA4D0-\uA4FD\uA500-\uA60C\uA610-\uA62B\uA640-\uA66F\uA674-\uA67D\uA67F-\uA69D\uA69F-\uA6F1\uA717-\uA71F\uA722-\uA788\uA78B-\uA78E\uA790-\uA7AD\uA7B0\uA7B1\uA7F7-\uA827\uA840-\uA873\uA880-\uA8C4\uA8D0-\uA8D9\uA8E0-\uA8F7\uA8FB\uA900-\uA92D\uA930-\uA953\uA960-\uA97C\uA980-\uA9C0\uA9CF-\uA9D9\uA9E0-\uA9FE\uAA00-\uAA36\uAA40-\uAA4D\uAA50-\uAA59\uAA60-\uAA76\uAA7A-\uAAC2\uAADB-\uAADD\uAAE0-\uAAEF\uAAF2-\uAAF6\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E\uAB30-\uAB5A\uAB5C-\uAB5F\uAB64\uAB65\uABC0-\uABEA\uABEC\uABED\uABF0-\uABF9\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D\uFA70-\uFAD9\uFB00-\uFB06\uFB13-\uFB17\uFB1D-\uFB28\uFB2A-\uFB36\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBB1\uFBD3-\uFD3D\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFB\uFE00-\uFE0F\uFE20-\uFE2D\uFE33\uFE34\uFE4D-\uFE4F\uFE70-\uFE74\uFE76-\uFEFC\uFF10-\uFF19\uFF21-\uFF3A\uFF3F\uFF41-\uFF5A\uFF66-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF\uFFD2-\uFFD7\uFFDA-\uFFDC]/
    };
    ES6Regex = {
      NonAsciiIdentifierStart: /[\xAA\xB5\xBA\xC0-\xD6\xD8-\xF6\xF8-\u02C1\u02C6-\u02D1\u02E0-\u02E4\u02EC\u02EE\u0370-\u0374\u0376\u0377\u037A-\u037D\u037F\u0386\u0388-\u038A\u038C\u038E-\u03A1\u03A3-\u03F5\u03F7-\u0481\u048A-\u052F\u0531-\u0556\u0559\u0561-\u0587\u05D0-\u05EA\u05F0-\u05F2\u0620-\u064A\u066E\u066F\u0671-\u06D3\u06D5\u06E5\u06E6\u06EE\u06EF\u06FA-\u06FC\u06FF\u0710\u0712-\u072F\u074D-\u07A5\u07B1\u07CA-\u07EA\u07F4\u07F5\u07FA\u0800-\u0815\u081A\u0824\u0828\u0840-\u0858\u08A0-\u08B2\u0904-\u0939\u093D\u0950\u0958-\u0961\u0971-\u0980\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2\u09B6-\u09B9\u09BD\u09CE\u09DC\u09DD\u09DF-\u09E1\u09F0\u09F1\u0A05-\u0A0A\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39\u0A59-\u0A5C\u0A5E\u0A72-\u0A74\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABD\u0AD0\u0AE0\u0AE1\u0B05-\u0B0C\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3D\u0B5C\u0B5D\u0B5F-\u0B61\u0B71\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BD0\u0C05-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C39\u0C3D\u0C58\u0C59\u0C60\u0C61\u0C85-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3\u0CB5-\u0CB9\u0CBD\u0CDE\u0CE0\u0CE1\u0CF1\u0CF2\u0D05-\u0D0C\u0D0E-\u0D10\u0D12-\u0D3A\u0D3D\u0D4E\u0D60\u0D61\u0D7A-\u0D7F\u0D85-\u0D96\u0D9A-\u0DB1\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0E01-\u0E30\u0E32\u0E33\u0E40-\u0E46\u0E81\u0E82\u0E84\u0E87\u0E88\u0E8A\u0E8D\u0E94-\u0E97\u0E99-\u0E9F\u0EA1-\u0EA3\u0EA5\u0EA7\u0EAA\u0EAB\u0EAD-\u0EB0\u0EB2\u0EB3\u0EBD\u0EC0-\u0EC4\u0EC6\u0EDC-\u0EDF\u0F00\u0F40-\u0F47\u0F49-\u0F6C\u0F88-\u0F8C\u1000-\u102A\u103F\u1050-\u1055\u105A-\u105D\u1061\u1065\u1066\u106E-\u1070\u1075-\u1081\u108E\u10A0-\u10C5\u10C7\u10CD\u10D0-\u10FA\u10FC-\u1248\u124A-\u124D\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310\u1312-\u1315\u1318-\u135A\u1380-\u138F\u13A0-\u13F4\u1401-\u166C\u166F-\u167F\u1681-\u169A\u16A0-\u16EA\u16EE-\u16F8\u1700-\u170C\u170E-\u1711\u1720-\u1731\u1740-\u1751\u1760-\u176C\u176E-\u1770\u1780-\u17B3\u17D7\u17DC\u1820-\u1877\u1880-\u18A8\u18AA\u18B0-\u18F5\u1900-\u191E\u1950-\u196D\u1970-\u1974\u1980-\u19AB\u19C1-\u19C7\u1A00-\u1A16\u1A20-\u1A54\u1AA7\u1B05-\u1B33\u1B45-\u1B4B\u1B83-\u1BA0\u1BAE\u1BAF\u1BBA-\u1BE5\u1C00-\u1C23\u1C4D-\u1C4F\u1C5A-\u1C7D\u1CE9-\u1CEC\u1CEE-\u1CF1\u1CF5\u1CF6\u1D00-\u1DBF\u1E00-\u1F15\u1F18-\u1F1D\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59\u1F5B\u1F5D\u1F5F-\u1F7D\u1F80-\u1FB4\u1FB6-\u1FBC\u1FBE\u1FC2-\u1FC4\u1FC6-\u1FCC\u1FD0-\u1FD3\u1FD6-\u1FDB\u1FE0-\u1FEC\u1FF2-\u1FF4\u1FF6-\u1FFC\u2071\u207F\u2090-\u209C\u2102\u2107\u210A-\u2113\u2115\u2118-\u211D\u2124\u2126\u2128\u212A-\u2139\u213C-\u213F\u2145-\u2149\u214E\u2160-\u2188\u2C00-\u2C2E\u2C30-\u2C5E\u2C60-\u2CE4\u2CEB-\u2CEE\u2CF2\u2CF3\u2D00-\u2D25\u2D27\u2D2D\u2D30-\u2D67\u2D6F\u2D80-\u2D96\u2DA0-\u2DA6\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE\u2DD0-\u2DD6\u2DD8-\u2DDE\u3005-\u3007\u3021-\u3029\u3031-\u3035\u3038-\u303C\u3041-\u3096\u309B-\u309F\u30A1-\u30FA\u30FC-\u30FF\u3105-\u312D\u3131-\u318E\u31A0-\u31BA\u31F0-\u31FF\u3400-\u4DB5\u4E00-\u9FCC\uA000-\uA48C\uA4D0-\uA4FD\uA500-\uA60C\uA610-\uA61F\uA62A\uA62B\uA640-\uA66E\uA67F-\uA69D\uA6A0-\uA6EF\uA717-\uA71F\uA722-\uA788\uA78B-\uA78E\uA790-\uA7AD\uA7B0\uA7B1\uA7F7-\uA801\uA803-\uA805\uA807-\uA80A\uA80C-\uA822\uA840-\uA873\uA882-\uA8B3\uA8F2-\uA8F7\uA8FB\uA90A-\uA925\uA930-\uA946\uA960-\uA97C\uA984-\uA9B2\uA9CF\uA9E0-\uA9E4\uA9E6-\uA9EF\uA9FA-\uA9FE\uAA00-\uAA28\uAA40-\uAA42\uAA44-\uAA4B\uAA60-\uAA76\uAA7A\uAA7E-\uAAAF\uAAB1\uAAB5\uAAB6\uAAB9-\uAABD\uAAC0\uAAC2\uAADB-\uAADD\uAAE0-\uAAEA\uAAF2-\uAAF4\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E\uAB30-\uAB5A\uAB5C-\uAB5F\uAB64\uAB65\uABC0-\uABE2\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D\uFA70-\uFAD9\uFB00-\uFB06\uFB13-\uFB17\uFB1D\uFB1F-\uFB28\uFB2A-\uFB36\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBB1\uFBD3-\uFD3D\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFB\uFE70-\uFE74\uFE76-\uFEFC\uFF21-\uFF3A\uFF41-\uFF5A\uFF66-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF\uFFD2-\uFFD7\uFFDA-\uFFDC]|\uD800[\uDC00-\uDC0B\uDC0D-\uDC26\uDC28-\uDC3A\uDC3C\uDC3D\uDC3F-\uDC4D\uDC50-\uDC5D\uDC80-\uDCFA\uDD40-\uDD74\uDE80-\uDE9C\uDEA0-\uDED0\uDF00-\uDF1F\uDF30-\uDF4A\uDF50-\uDF75\uDF80-\uDF9D\uDFA0-\uDFC3\uDFC8-\uDFCF\uDFD1-\uDFD5]|\uD801[\uDC00-\uDC9D\uDD00-\uDD27\uDD30-\uDD63\uDE00-\uDF36\uDF40-\uDF55\uDF60-\uDF67]|\uD802[\uDC00-\uDC05\uDC08\uDC0A-\uDC35\uDC37\uDC38\uDC3C\uDC3F-\uDC55\uDC60-\uDC76\uDC80-\uDC9E\uDD00-\uDD15\uDD20-\uDD39\uDD80-\uDDB7\uDDBE\uDDBF\uDE00\uDE10-\uDE13\uDE15-\uDE17\uDE19-\uDE33\uDE60-\uDE7C\uDE80-\uDE9C\uDEC0-\uDEC7\uDEC9-\uDEE4\uDF00-\uDF35\uDF40-\uDF55\uDF60-\uDF72\uDF80-\uDF91]|\uD803[\uDC00-\uDC48]|\uD804[\uDC03-\uDC37\uDC83-\uDCAF\uDCD0-\uDCE8\uDD03-\uDD26\uDD50-\uDD72\uDD76\uDD83-\uDDB2\uDDC1-\uDDC4\uDDDA\uDE00-\uDE11\uDE13-\uDE2B\uDEB0-\uDEDE\uDF05-\uDF0C\uDF0F\uDF10\uDF13-\uDF28\uDF2A-\uDF30\uDF32\uDF33\uDF35-\uDF39\uDF3D\uDF5D-\uDF61]|\uD805[\uDC80-\uDCAF\uDCC4\uDCC5\uDCC7\uDD80-\uDDAE\uDE00-\uDE2F\uDE44\uDE80-\uDEAA]|\uD806[\uDCA0-\uDCDF\uDCFF\uDEC0-\uDEF8]|\uD808[\uDC00-\uDF98]|\uD809[\uDC00-\uDC6E]|[\uD80C\uD840-\uD868\uD86A-\uD86C][\uDC00-\uDFFF]|\uD80D[\uDC00-\uDC2E]|\uD81A[\uDC00-\uDE38\uDE40-\uDE5E\uDED0-\uDEED\uDF00-\uDF2F\uDF40-\uDF43\uDF63-\uDF77\uDF7D-\uDF8F]|\uD81B[\uDF00-\uDF44\uDF50\uDF93-\uDF9F]|\uD82C[\uDC00\uDC01]|\uD82F[\uDC00-\uDC6A\uDC70-\uDC7C\uDC80-\uDC88\uDC90-\uDC99]|\uD835[\uDC00-\uDC54\uDC56-\uDC9C\uDC9E\uDC9F\uDCA2\uDCA5\uDCA6\uDCA9-\uDCAC\uDCAE-\uDCB9\uDCBB\uDCBD-\uDCC3\uDCC5-\uDD05\uDD07-\uDD0A\uDD0D-\uDD14\uDD16-\uDD1C\uDD1E-\uDD39\uDD3B-\uDD3E\uDD40-\uDD44\uDD46\uDD4A-\uDD50\uDD52-\uDEA5\uDEA8-\uDEC0\uDEC2-\uDEDA\uDEDC-\uDEFA\uDEFC-\uDF14\uDF16-\uDF34\uDF36-\uDF4E\uDF50-\uDF6E\uDF70-\uDF88\uDF8A-\uDFA8\uDFAA-\uDFC2\uDFC4-\uDFCB]|\uD83A[\uDC00-\uDCC4]|\uD83B[\uDE00-\uDE03\uDE05-\uDE1F\uDE21\uDE22\uDE24\uDE27\uDE29-\uDE32\uDE34-\uDE37\uDE39\uDE3B\uDE42\uDE47\uDE49\uDE4B\uDE4D-\uDE4F\uDE51\uDE52\uDE54\uDE57\uDE59\uDE5B\uDE5D\uDE5F\uDE61\uDE62\uDE64\uDE67-\uDE6A\uDE6C-\uDE72\uDE74-\uDE77\uDE79-\uDE7C\uDE7E\uDE80-\uDE89\uDE8B-\uDE9B\uDEA1-\uDEA3\uDEA5-\uDEA9\uDEAB-\uDEBB]|\uD869[\uDC00-\uDED6\uDF00-\uDFFF]|\uD86D[\uDC00-\uDF34\uDF40-\uDFFF]|\uD86E[\uDC00-\uDC1D]|\uD87E[\uDC00-\uDE1D]/,
      NonAsciiIdentifierPart: /[\xAA\xB5\xB7\xBA\xC0-\xD6\xD8-\xF6\xF8-\u02C1\u02C6-\u02D1\u02E0-\u02E4\u02EC\u02EE\u0300-\u0374\u0376\u0377\u037A-\u037D\u037F\u0386-\u038A\u038C\u038E-\u03A1\u03A3-\u03F5\u03F7-\u0481\u0483-\u0487\u048A-\u052F\u0531-\u0556\u0559\u0561-\u0587\u0591-\u05BD\u05BF\u05C1\u05C2\u05C4\u05C5\u05C7\u05D0-\u05EA\u05F0-\u05F2\u0610-\u061A\u0620-\u0669\u066E-\u06D3\u06D5-\u06DC\u06DF-\u06E8\u06EA-\u06FC\u06FF\u0710-\u074A\u074D-\u07B1\u07C0-\u07F5\u07FA\u0800-\u082D\u0840-\u085B\u08A0-\u08B2\u08E4-\u0963\u0966-\u096F\u0971-\u0983\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2\u09B6-\u09B9\u09BC-\u09C4\u09C7\u09C8\u09CB-\u09CE\u09D7\u09DC\u09DD\u09DF-\u09E3\u09E6-\u09F1\u0A01-\u0A03\u0A05-\u0A0A\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39\u0A3C\u0A3E-\u0A42\u0A47\u0A48\u0A4B-\u0A4D\u0A51\u0A59-\u0A5C\u0A5E\u0A66-\u0A75\u0A81-\u0A83\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABC-\u0AC5\u0AC7-\u0AC9\u0ACB-\u0ACD\u0AD0\u0AE0-\u0AE3\u0AE6-\u0AEF\u0B01-\u0B03\u0B05-\u0B0C\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3C-\u0B44\u0B47\u0B48\u0B4B-\u0B4D\u0B56\u0B57\u0B5C\u0B5D\u0B5F-\u0B63\u0B66-\u0B6F\u0B71\u0B82\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BBE-\u0BC2\u0BC6-\u0BC8\u0BCA-\u0BCD\u0BD0\u0BD7\u0BE6-\u0BEF\u0C00-\u0C03\u0C05-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C39\u0C3D-\u0C44\u0C46-\u0C48\u0C4A-\u0C4D\u0C55\u0C56\u0C58\u0C59\u0C60-\u0C63\u0C66-\u0C6F\u0C81-\u0C83\u0C85-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3\u0CB5-\u0CB9\u0CBC-\u0CC4\u0CC6-\u0CC8\u0CCA-\u0CCD\u0CD5\u0CD6\u0CDE\u0CE0-\u0CE3\u0CE6-\u0CEF\u0CF1\u0CF2\u0D01-\u0D03\u0D05-\u0D0C\u0D0E-\u0D10\u0D12-\u0D3A\u0D3D-\u0D44\u0D46-\u0D48\u0D4A-\u0D4E\u0D57\u0D60-\u0D63\u0D66-\u0D6F\u0D7A-\u0D7F\u0D82\u0D83\u0D85-\u0D96\u0D9A-\u0DB1\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0DCA\u0DCF-\u0DD4\u0DD6\u0DD8-\u0DDF\u0DE6-\u0DEF\u0DF2\u0DF3\u0E01-\u0E3A\u0E40-\u0E4E\u0E50-\u0E59\u0E81\u0E82\u0E84\u0E87\u0E88\u0E8A\u0E8D\u0E94-\u0E97\u0E99-\u0E9F\u0EA1-\u0EA3\u0EA5\u0EA7\u0EAA\u0EAB\u0EAD-\u0EB9\u0EBB-\u0EBD\u0EC0-\u0EC4\u0EC6\u0EC8-\u0ECD\u0ED0-\u0ED9\u0EDC-\u0EDF\u0F00\u0F18\u0F19\u0F20-\u0F29\u0F35\u0F37\u0F39\u0F3E-\u0F47\u0F49-\u0F6C\u0F71-\u0F84\u0F86-\u0F97\u0F99-\u0FBC\u0FC6\u1000-\u1049\u1050-\u109D\u10A0-\u10C5\u10C7\u10CD\u10D0-\u10FA\u10FC-\u1248\u124A-\u124D\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310\u1312-\u1315\u1318-\u135A\u135D-\u135F\u1369-\u1371\u1380-\u138F\u13A0-\u13F4\u1401-\u166C\u166F-\u167F\u1681-\u169A\u16A0-\u16EA\u16EE-\u16F8\u1700-\u170C\u170E-\u1714\u1720-\u1734\u1740-\u1753\u1760-\u176C\u176E-\u1770\u1772\u1773\u1780-\u17D3\u17D7\u17DC\u17DD\u17E0-\u17E9\u180B-\u180D\u1810-\u1819\u1820-\u1877\u1880-\u18AA\u18B0-\u18F5\u1900-\u191E\u1920-\u192B\u1930-\u193B\u1946-\u196D\u1970-\u1974\u1980-\u19AB\u19B0-\u19C9\u19D0-\u19DA\u1A00-\u1A1B\u1A20-\u1A5E\u1A60-\u1A7C\u1A7F-\u1A89\u1A90-\u1A99\u1AA7\u1AB0-\u1ABD\u1B00-\u1B4B\u1B50-\u1B59\u1B6B-\u1B73\u1B80-\u1BF3\u1C00-\u1C37\u1C40-\u1C49\u1C4D-\u1C7D\u1CD0-\u1CD2\u1CD4-\u1CF6\u1CF8\u1CF9\u1D00-\u1DF5\u1DFC-\u1F15\u1F18-\u1F1D\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59\u1F5B\u1F5D\u1F5F-\u1F7D\u1F80-\u1FB4\u1FB6-\u1FBC\u1FBE\u1FC2-\u1FC4\u1FC6-\u1FCC\u1FD0-\u1FD3\u1FD6-\u1FDB\u1FE0-\u1FEC\u1FF2-\u1FF4\u1FF6-\u1FFC\u200C\u200D\u203F\u2040\u2054\u2071\u207F\u2090-\u209C\u20D0-\u20DC\u20E1\u20E5-\u20F0\u2102\u2107\u210A-\u2113\u2115\u2118-\u211D\u2124\u2126\u2128\u212A-\u2139\u213C-\u213F\u2145-\u2149\u214E\u2160-\u2188\u2C00-\u2C2E\u2C30-\u2C5E\u2C60-\u2CE4\u2CEB-\u2CF3\u2D00-\u2D25\u2D27\u2D2D\u2D30-\u2D67\u2D6F\u2D7F-\u2D96\u2DA0-\u2DA6\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE\u2DD0-\u2DD6\u2DD8-\u2DDE\u2DE0-\u2DFF\u3005-\u3007\u3021-\u302F\u3031-\u3035\u3038-\u303C\u3041-\u3096\u3099-\u309F\u30A1-\u30FA\u30FC-\u30FF\u3105-\u312D\u3131-\u318E\u31A0-\u31BA\u31F0-\u31FF\u3400-\u4DB5\u4E00-\u9FCC\uA000-\uA48C\uA4D0-\uA4FD\uA500-\uA60C\uA610-\uA62B\uA640-\uA66F\uA674-\uA67D\uA67F-\uA69D\uA69F-\uA6F1\uA717-\uA71F\uA722-\uA788\uA78B-\uA78E\uA790-\uA7AD\uA7B0\uA7B1\uA7F7-\uA827\uA840-\uA873\uA880-\uA8C4\uA8D0-\uA8D9\uA8E0-\uA8F7\uA8FB\uA900-\uA92D\uA930-\uA953\uA960-\uA97C\uA980-\uA9C0\uA9CF-\uA9D9\uA9E0-\uA9FE\uAA00-\uAA36\uAA40-\uAA4D\uAA50-\uAA59\uAA60-\uAA76\uAA7A-\uAAC2\uAADB-\uAADD\uAAE0-\uAAEF\uAAF2-\uAAF6\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E\uAB30-\uAB5A\uAB5C-\uAB5F\uAB64\uAB65\uABC0-\uABEA\uABEC\uABED\uABF0-\uABF9\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D\uFA70-\uFAD9\uFB00-\uFB06\uFB13-\uFB17\uFB1D-\uFB28\uFB2A-\uFB36\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBB1\uFBD3-\uFD3D\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFB\uFE00-\uFE0F\uFE20-\uFE2D\uFE33\uFE34\uFE4D-\uFE4F\uFE70-\uFE74\uFE76-\uFEFC\uFF10-\uFF19\uFF21-\uFF3A\uFF3F\uFF41-\uFF5A\uFF66-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF\uFFD2-\uFFD7\uFFDA-\uFFDC]|\uD800[\uDC00-\uDC0B\uDC0D-\uDC26\uDC28-\uDC3A\uDC3C\uDC3D\uDC3F-\uDC4D\uDC50-\uDC5D\uDC80-\uDCFA\uDD40-\uDD74\uDDFD\uDE80-\uDE9C\uDEA0-\uDED0\uDEE0\uDF00-\uDF1F\uDF30-\uDF4A\uDF50-\uDF7A\uDF80-\uDF9D\uDFA0-\uDFC3\uDFC8-\uDFCF\uDFD1-\uDFD5]|\uD801[\uDC00-\uDC9D\uDCA0-\uDCA9\uDD00-\uDD27\uDD30-\uDD63\uDE00-\uDF36\uDF40-\uDF55\uDF60-\uDF67]|\uD802[\uDC00-\uDC05\uDC08\uDC0A-\uDC35\uDC37\uDC38\uDC3C\uDC3F-\uDC55\uDC60-\uDC76\uDC80-\uDC9E\uDD00-\uDD15\uDD20-\uDD39\uDD80-\uDDB7\uDDBE\uDDBF\uDE00-\uDE03\uDE05\uDE06\uDE0C-\uDE13\uDE15-\uDE17\uDE19-\uDE33\uDE38-\uDE3A\uDE3F\uDE60-\uDE7C\uDE80-\uDE9C\uDEC0-\uDEC7\uDEC9-\uDEE6\uDF00-\uDF35\uDF40-\uDF55\uDF60-\uDF72\uDF80-\uDF91]|\uD803[\uDC00-\uDC48]|\uD804[\uDC00-\uDC46\uDC66-\uDC6F\uDC7F-\uDCBA\uDCD0-\uDCE8\uDCF0-\uDCF9\uDD00-\uDD34\uDD36-\uDD3F\uDD50-\uDD73\uDD76\uDD80-\uDDC4\uDDD0-\uDDDA\uDE00-\uDE11\uDE13-\uDE37\uDEB0-\uDEEA\uDEF0-\uDEF9\uDF01-\uDF03\uDF05-\uDF0C\uDF0F\uDF10\uDF13-\uDF28\uDF2A-\uDF30\uDF32\uDF33\uDF35-\uDF39\uDF3C-\uDF44\uDF47\uDF48\uDF4B-\uDF4D\uDF57\uDF5D-\uDF63\uDF66-\uDF6C\uDF70-\uDF74]|\uD805[\uDC80-\uDCC5\uDCC7\uDCD0-\uDCD9\uDD80-\uDDB5\uDDB8-\uDDC0\uDE00-\uDE40\uDE44\uDE50-\uDE59\uDE80-\uDEB7\uDEC0-\uDEC9]|\uD806[\uDCA0-\uDCE9\uDCFF\uDEC0-\uDEF8]|\uD808[\uDC00-\uDF98]|\uD809[\uDC00-\uDC6E]|[\uD80C\uD840-\uD868\uD86A-\uD86C][\uDC00-\uDFFF]|\uD80D[\uDC00-\uDC2E]|\uD81A[\uDC00-\uDE38\uDE40-\uDE5E\uDE60-\uDE69\uDED0-\uDEED\uDEF0-\uDEF4\uDF00-\uDF36\uDF40-\uDF43\uDF50-\uDF59\uDF63-\uDF77\uDF7D-\uDF8F]|\uD81B[\uDF00-\uDF44\uDF50-\uDF7E\uDF8F-\uDF9F]|\uD82C[\uDC00\uDC01]|\uD82F[\uDC00-\uDC6A\uDC70-\uDC7C\uDC80-\uDC88\uDC90-\uDC99\uDC9D\uDC9E]|\uD834[\uDD65-\uDD69\uDD6D-\uDD72\uDD7B-\uDD82\uDD85-\uDD8B\uDDAA-\uDDAD\uDE42-\uDE44]|\uD835[\uDC00-\uDC54\uDC56-\uDC9C\uDC9E\uDC9F\uDCA2\uDCA5\uDCA6\uDCA9-\uDCAC\uDCAE-\uDCB9\uDCBB\uDCBD-\uDCC3\uDCC5-\uDD05\uDD07-\uDD0A\uDD0D-\uDD14\uDD16-\uDD1C\uDD1E-\uDD39\uDD3B-\uDD3E\uDD40-\uDD44\uDD46\uDD4A-\uDD50\uDD52-\uDEA5\uDEA8-\uDEC0\uDEC2-\uDEDA\uDEDC-\uDEFA\uDEFC-\uDF14\uDF16-\uDF34\uDF36-\uDF4E\uDF50-\uDF6E\uDF70-\uDF88\uDF8A-\uDFA8\uDFAA-\uDFC2\uDFC4-\uDFCB\uDFCE-\uDFFF]|\uD83A[\uDC00-\uDCC4\uDCD0-\uDCD6]|\uD83B[\uDE00-\uDE03\uDE05-\uDE1F\uDE21\uDE22\uDE24\uDE27\uDE29-\uDE32\uDE34-\uDE37\uDE39\uDE3B\uDE42\uDE47\uDE49\uDE4B\uDE4D-\uDE4F\uDE51\uDE52\uDE54\uDE57\uDE59\uDE5B\uDE5D\uDE5F\uDE61\uDE62\uDE64\uDE67-\uDE6A\uDE6C-\uDE72\uDE74-\uDE77\uDE79-\uDE7C\uDE7E\uDE80-\uDE89\uDE8B-\uDE9B\uDEA1-\uDEA3\uDEA5-\uDEA9\uDEAB-\uDEBB]|\uD869[\uDC00-\uDED6\uDF00-\uDFFF]|\uD86D[\uDC00-\uDF34\uDF40-\uDFFF]|\uD86E[\uDC00-\uDC1D]|\uD87E[\uDC00-\uDE1D]|\uDB40[\uDD00-\uDDEF]/
    };
    function isDecimalDigit(ch) {
      return 0x30 <= ch && ch <= 0x39;
    }
    function isHexDigit(ch) {
      return 0x30 <= ch && ch <= 0x39 || 0x61 <= ch && ch <= 0x66 || 0x41 <= ch && ch <= 0x46;
    }
    function isOctalDigit(ch) {
      return ch >= 0x30 && ch <= 0x37;
    }
    NON_ASCII_WHITESPACES = [0x1680, 0x180E, 0x2000, 0x2001, 0x2002, 0x2003, 0x2004, 0x2005, 0x2006, 0x2007, 0x2008, 0x2009, 0x200A, 0x202F, 0x205F, 0x3000, 0xFEFF];
    function isWhiteSpace(ch) {
      return ch === 0x20 || ch === 0x09 || ch === 0x0B || ch === 0x0C || ch === 0xA0 || ch >= 0x1680 && NON_ASCII_WHITESPACES.indexOf(ch) >= 0;
    }
    function isLineTerminator(ch) {
      return ch === 0x0A || ch === 0x0D || ch === 0x2028 || ch === 0x2029;
    }
    function fromCodePoint(cp) {
      if (cp <= 0xFFFF) {
        return String.fromCharCode(cp);
      }
      var cu1 = String.fromCharCode(Math.floor((cp - 0x10000) / 0x400) + 0xD800);
      var cu2 = String.fromCharCode(((cp - 0x10000) % 0x400) + 0xDC00);
      return cu1 + cu2;
    }
    IDENTIFIER_START = new Array(0x80);
    for (ch = 0; ch < 0x80; ++ch) {
      IDENTIFIER_START[ch] = ch >= 0x61 && ch <= 0x7A || ch >= 0x41 && ch <= 0x5A || ch === 0x24 || ch === 0x5F;
    }
    IDENTIFIER_PART = new Array(0x80);
    for (ch = 0; ch < 0x80; ++ch) {
      IDENTIFIER_PART[ch] = ch >= 0x61 && ch <= 0x7A || ch >= 0x41 && ch <= 0x5A || ch >= 0x30 && ch <= 0x39 || ch === 0x24 || ch === 0x5F;
    }
    function isIdentifierStartES5(ch) {
      return ch < 0x80 ? IDENTIFIER_START[ch] : ES5Regex.NonAsciiIdentifierStart.test(fromCodePoint(ch));
    }
    function isIdentifierPartES5(ch) {
      return ch < 0x80 ? IDENTIFIER_PART[ch] : ES5Regex.NonAsciiIdentifierPart.test(fromCodePoint(ch));
    }
    function isIdentifierStartES6(ch) {
      return ch < 0x80 ? IDENTIFIER_START[ch] : ES6Regex.NonAsciiIdentifierStart.test(fromCodePoint(ch));
    }
    function isIdentifierPartES6(ch) {
      return ch < 0x80 ? IDENTIFIER_PART[ch] : ES6Regex.NonAsciiIdentifierPart.test(fromCodePoint(ch));
    }
    module.exports = {
      isDecimalDigit: isDecimalDigit,
      isHexDigit: isHexDigit,
      isOctalDigit: isOctalDigit,
      isWhiteSpace: isWhiteSpace,
      isLineTerminator: isLineTerminator,
      isIdentifierStartES5: isIdentifierStartES5,
      isIdentifierPartES5: isIdentifierPartES5,
      isIdentifierStartES6: isIdentifierStartES6,
      isIdentifierPartES6: isIdentifierPartES6
    };
  }());
  return module.exports;
});

$__System.registerDynamic("163", ["162"], true, function($__require, exports, module) {
  ;
  var define,
      global = this,
      GLOBAL = this;
  (function() {
    'use strict';
    var code = $__require('162');
    function isStrictModeReservedWordES6(id) {
      switch (id) {
        case 'implements':
        case 'interface':
        case 'package':
        case 'private':
        case 'protected':
        case 'public':
        case 'static':
        case 'let':
          return true;
        default:
          return false;
      }
    }
    function isKeywordES5(id, strict) {
      if (!strict && id === 'yield') {
        return false;
      }
      return isKeywordES6(id, strict);
    }
    function isKeywordES6(id, strict) {
      if (strict && isStrictModeReservedWordES6(id)) {
        return true;
      }
      switch (id.length) {
        case 2:
          return (id === 'if') || (id === 'in') || (id === 'do');
        case 3:
          return (id === 'var') || (id === 'for') || (id === 'new') || (id === 'try');
        case 4:
          return (id === 'this') || (id === 'else') || (id === 'case') || (id === 'void') || (id === 'with') || (id === 'enum');
        case 5:
          return (id === 'while') || (id === 'break') || (id === 'catch') || (id === 'throw') || (id === 'const') || (id === 'yield') || (id === 'class') || (id === 'super');
        case 6:
          return (id === 'return') || (id === 'typeof') || (id === 'delete') || (id === 'switch') || (id === 'export') || (id === 'import');
        case 7:
          return (id === 'default') || (id === 'finally') || (id === 'extends');
        case 8:
          return (id === 'function') || (id === 'continue') || (id === 'debugger');
        case 10:
          return (id === 'instanceof');
        default:
          return false;
      }
    }
    function isReservedWordES5(id, strict) {
      return id === 'null' || id === 'true' || id === 'false' || isKeywordES5(id, strict);
    }
    function isReservedWordES6(id, strict) {
      return id === 'null' || id === 'true' || id === 'false' || isKeywordES6(id, strict);
    }
    function isRestrictedWord(id) {
      return id === 'eval' || id === 'arguments';
    }
    function isIdentifierNameES5(id) {
      var i,
          iz,
          ch;
      if (id.length === 0) {
        return false;
      }
      ch = id.charCodeAt(0);
      if (!code.isIdentifierStartES5(ch)) {
        return false;
      }
      for (i = 1, iz = id.length; i < iz; ++i) {
        ch = id.charCodeAt(i);
        if (!code.isIdentifierPartES5(ch)) {
          return false;
        }
      }
      return true;
    }
    function decodeUtf16(lead, trail) {
      return (lead - 0xD800) * 0x400 + (trail - 0xDC00) + 0x10000;
    }
    function isIdentifierNameES6(id) {
      var i,
          iz,
          ch,
          lowCh,
          check;
      if (id.length === 0) {
        return false;
      }
      check = code.isIdentifierStartES6;
      for (i = 0, iz = id.length; i < iz; ++i) {
        ch = id.charCodeAt(i);
        if (0xD800 <= ch && ch <= 0xDBFF) {
          ++i;
          if (i >= iz) {
            return false;
          }
          lowCh = id.charCodeAt(i);
          if (!(0xDC00 <= lowCh && lowCh <= 0xDFFF)) {
            return false;
          }
          ch = decodeUtf16(ch, lowCh);
        }
        if (!check(ch)) {
          return false;
        }
        check = code.isIdentifierPartES6;
      }
      return true;
    }
    function isIdentifierES5(id, strict) {
      return isIdentifierNameES5(id) && !isReservedWordES5(id, strict);
    }
    function isIdentifierES6(id, strict) {
      return isIdentifierNameES6(id) && !isReservedWordES6(id, strict);
    }
    module.exports = {
      isKeywordES5: isKeywordES5,
      isKeywordES6: isKeywordES6,
      isReservedWordES5: isReservedWordES5,
      isReservedWordES6: isReservedWordES6,
      isRestrictedWord: isRestrictedWord,
      isIdentifierNameES5: isIdentifierNameES5,
      isIdentifierNameES6: isIdentifierNameES6,
      isIdentifierES5: isIdentifierES5,
      isIdentifierES6: isIdentifierES6
    };
  }());
  return module.exports;
});

$__System.registerDynamic("13d", ["161", "162", "163"], true, function($__require, exports, module) {
  ;
  var define,
      global = this,
      GLOBAL = this;
  (function() {
    'use strict';
    exports.ast = $__require('161');
    exports.code = $__require('162');
    exports.keyword = $__require('163');
  }());
  return module.exports;
});

$__System.registerDynamic("164", ["3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var matchOperatorsRe = /[|\\{}()[\]^$+*?.]/g;
  module.exports = function(str) {
    if (typeof str !== 'string') {
      throw new TypeError('Expected a string');
    }
    return str.replace(matchOperatorsRe, '\\$&');
  };
  return module.exports;
});

$__System.registerDynamic("165", [], true, function($__require, exports, module) {
  "use strict";
  ;
  var define,
      global = this,
      GLOBAL = this;
  function assembleStyles() {
    var styles = {
      modifiers: {
        reset: [0, 0],
        bold: [1, 22],
        dim: [2, 22],
        italic: [3, 23],
        underline: [4, 24],
        inverse: [7, 27],
        hidden: [8, 28],
        strikethrough: [9, 29]
      },
      colors: {
        black: [30, 39],
        red: [31, 39],
        green: [32, 39],
        yellow: [33, 39],
        blue: [34, 39],
        magenta: [35, 39],
        cyan: [36, 39],
        white: [37, 39],
        gray: [90, 39]
      },
      bgColors: {
        bgBlack: [40, 49],
        bgRed: [41, 49],
        bgGreen: [42, 49],
        bgYellow: [43, 49],
        bgBlue: [44, 49],
        bgMagenta: [45, 49],
        bgCyan: [46, 49],
        bgWhite: [47, 49]
      }
    };
    styles.colors.grey = styles.colors.gray;
    Object.keys(styles).forEach(function(groupName) {
      var group = styles[groupName];
      Object.keys(group).forEach(function(styleName) {
        var style = group[styleName];
        styles[styleName] = group[styleName] = {
          open: '\u001b[' + style[0] + 'm',
          close: '\u001b[' + style[1] + 'm'
        };
      });
      Object.defineProperty(styles, groupName, {
        value: group,
        enumerable: false
      });
    });
    return styles;
  }
  Object.defineProperty(module, 'exports', {
    enumerable: true,
    get: assembleStyles
  });
  return module.exports;
});

$__System.registerDynamic("166", ["167", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var ansiRegex = $__require('167')();
  module.exports = function(str) {
    return typeof str === 'string' ? str.replace(ansiRegex, '') : str;
  };
  return module.exports;
});

$__System.registerDynamic("167", ["3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  module.exports = function() {
    return /[\u001b\u009b][[()#;?]*(?:[0-9]{1,4}(?:;[0-9]{0,4})*)?[0-9A-ORZcf-nqry=><]/g;
  };
  return module.exports;
});

$__System.registerDynamic("168", ["167", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var ansiRegex = $__require('167');
  var re = new RegExp(ansiRegex().source);
  module.exports = re.test.bind(re);
  return module.exports;
});

$__System.registerDynamic("169", ["3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var argv = process.argv;
  var terminator = argv.indexOf('--');
  var hasFlag = function(flag) {
    flag = '--' + flag;
    var pos = argv.indexOf(flag);
    return pos !== -1 && (terminator !== -1 ? pos < terminator : true);
  };
  module.exports = (function() {
    if ('FORCE_COLOR' in process.env) {
      return true;
    }
    if (hasFlag('no-color') || hasFlag('no-colors') || hasFlag('color=false')) {
      return false;
    }
    if (hasFlag('color') || hasFlag('colors') || hasFlag('color=true') || hasFlag('color=always')) {
      return true;
    }
    if (process.stdout && !process.stdout.isTTY) {
      return false;
    }
    if (process.platform === 'win32') {
      return true;
    }
    if ('COLORTERM' in process.env) {
      return true;
    }
    if (process.env.TERM === 'dumb') {
      return false;
    }
    if (/^screen|^xterm|^vt100|color|ansi|cygwin|linux/i.test(process.env.TERM)) {
      return true;
    }
    return false;
  })();
  return module.exports;
});

$__System.registerDynamic("16a", ["164", "165", "166", "168", "169", "3"], true, function($__require, exports, module) {
  "use strict";
  var process = $__require("3");
  var define,
      global = this,
      GLOBAL = this;
  var escapeStringRegexp = $__require('164');
  var ansiStyles = $__require('165');
  var stripAnsi = $__require('166');
  var hasAnsi = $__require('168');
  var supportsColor = $__require('169');
  var defineProps = Object.defineProperties;
  var isSimpleWindowsTerm = process.platform === 'win32' && !/^xterm/i.test(process.env.TERM);
  function Chalk(options) {
    this.enabled = !options || options.enabled === undefined ? supportsColor : options.enabled;
  }
  if (isSimpleWindowsTerm) {
    ansiStyles.blue.open = '\u001b[94m';
  }
  var styles = (function() {
    var ret = {};
    Object.keys(ansiStyles).forEach(function(key) {
      ansiStyles[key].closeRe = new RegExp(escapeStringRegexp(ansiStyles[key].close), 'g');
      ret[key] = {get: function() {
          return build.call(this, this._styles.concat(key));
        }};
    });
    return ret;
  })();
  var proto = defineProps(function chalk() {}, styles);
  function build(_styles) {
    var builder = function() {
      return applyStyle.apply(builder, arguments);
    };
    builder._styles = _styles;
    builder.enabled = this.enabled;
    builder.__proto__ = proto;
    return builder;
  }
  function applyStyle() {
    var args = arguments;
    var argsLen = args.length;
    var str = argsLen !== 0 && String(arguments[0]);
    if (argsLen > 1) {
      for (var a = 1; a < argsLen; a++) {
        str += ' ' + args[a];
      }
    }
    if (!this.enabled || !str) {
      return str;
    }
    var nestedStyles = this._styles;
    var i = nestedStyles.length;
    var originalDim = ansiStyles.dim.open;
    if (isSimpleWindowsTerm && (nestedStyles.indexOf('gray') !== -1 || nestedStyles.indexOf('grey') !== -1)) {
      ansiStyles.dim.open = '';
    }
    while (i--) {
      var code = ansiStyles[nestedStyles[i]];
      str = code.open + str.replace(code.closeRe, code.open) + code.close;
    }
    ansiStyles.dim.open = originalDim;
    return str;
  }
  function init() {
    var ret = {};
    Object.keys(styles).forEach(function(name) {
      ret[name] = {get: function() {
          return build.call(this, [name]);
        }};
    });
    return ret;
  }
  defineProps(Chalk.prototype, init());
  module.exports = new Chalk();
  module.exports.styles = ansiStyles;
  module.exports.hasColor = hasAnsi;
  module.exports.stripColor = stripAnsi;
  module.exports.supportsColor = supportsColor;
  return module.exports;
});

$__System.registerDynamic("6f", ["a", "76", "160", "13d", "16a"], true, function($__require, exports, module) {
  "use strict";
  ;
  var define,
      global = this,
      GLOBAL = this;
  var _interopRequireDefault = $__require('a')["default"];
  exports.__esModule = true;
  var _repeating = $__require('76');
  var _repeating2 = _interopRequireDefault(_repeating);
  var _jsTokens = $__require('160');
  var _jsTokens2 = _interopRequireDefault(_jsTokens);
  var _esutils = $__require('13d');
  var _esutils2 = _interopRequireDefault(_esutils);
  var _chalk = $__require('16a');
  var _chalk2 = _interopRequireDefault(_chalk);
  function lineNumbers(lines) {
    return lines;
  }
  var defs = {
    string: _chalk2["default"].red,
    punctuator: _chalk2["default"].bold,
    curly: _chalk2["default"].green,
    parens: _chalk2["default"].blue.bold,
    square: _chalk2["default"].yellow,
    keyword: _chalk2["default"].cyan,
    number: _chalk2["default"].magenta,
    regex: _chalk2["default"].magenta,
    comment: _chalk2["default"].grey,
    invalid: _chalk2["default"].inverse
  };
  var NEWLINE = /\r\n|[\n\r\u2028\u2029]/;
  function getTokenType(match) {
    var token = _jsTokens2["default"].matchToToken(match);
    if (token.type === "name" && _esutils2["default"].keyword.isReservedWordES6(token.value)) {
      return "keyword";
    }
    if (token.type === "punctuator") {
      switch (token.value) {
        case "{":
        case "}":
          return "curly";
        case "(":
        case ")":
          return "parens";
        case "[":
        case "]":
          return "square";
      }
    }
    return token.type;
  }
  function highlight(text) {
    return text.replace(_jsTokens2["default"], function() {
      for (var _len = arguments.length,
          args = Array(_len),
          _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }
      var type = getTokenType(args);
      var colorize = defs[type];
      if (colorize) {
        return args[0].split(NEWLINE).map(function(str) {
          return colorize(str);
        }).join("\n");
      } else {
        return args[0];
      }
    });
  }
  exports["default"] = function(rawLines, lineNumber, colNumber) {
    var opts = arguments.length <= 3 || arguments[3] === undefined ? {} : arguments[3];
    colNumber = Math.max(colNumber, 0);
    var highlighted = opts.highlightCode && _chalk2["default"].supportsColor;
    if (highlighted)
      rawLines = highlight(rawLines);
    var lines = rawLines.split(NEWLINE);
    var start = Math.max(lineNumber - 3, 0);
    var end = Math.min(lines.length, lineNumber + 3);
    if (!lineNumber && !colNumber) {
      start = 0;
      end = lines.length;
    }
    var frame = lineNumbers(lines.slice(start, end), {
      start: start + 1,
      before: "  ",
      after: " | ",
      transform: function transform(params) {
        if (params.number !== lineNumber) {
          return;
        }
        if (colNumber) {
          params.line += "\n" + params.before + _repeating2["default"](" ", params.width) + params.after + _repeating2["default"](" ", colNumber - 1) + "^";
        }
        params.before = params.before.replace(/^./, ">");
      }
    }).join("\n");
    if (highlighted) {
      return _chalk2["default"].reset(frame);
    } else {
      return frame;
    }
  };
  module.exports = exports["default"];
  return module.exports;
});

$__System.registerDynamic("71", [], true, function($__require, exports, module) {
  ;
  var define,
      global = this,
      GLOBAL = this;
  (function(f) {
    if (typeof exports === "object" && typeof module !== "undefined") {
      module.exports = f();
    } else if (typeof define === "function" && define.amd) {
      define([], f);
    } else {
      var g;
      if (typeof window !== "undefined") {
        g = window;
      } else if (typeof global !== "undefined") {
        g = global;
      } else if (typeof self !== "undefined") {
        g = self;
      } else {
        g = this;
      }
      g.babylon = f();
    }
  })(function() {
    var define,
        module,
        exports;
    return (function e(t, n, r) {
      function s(o, u) {
        if (!n[o]) {
          if (!t[o]) {
            var a = typeof $__require == "function" && $__require;
            if (!u && a)
              return a(o, !0);
            if (i)
              return i(o, !0);
            var f = new Error("Cannot find module '" + o + "'");
            throw f.code = "MODULE_NOT_FOUND", f;
          }
          var l = n[o] = {exports: {}};
          t[o][0].call(l.exports, function(e) {
            var n = t[o][1][e];
            return s(n ? n : e);
          }, l, l.exports, e, t, n, r);
        }
        return n[o].exports;
      }
      var i = typeof $__require == "function" && $__require;
      for (var o = 0; o < r.length; o++)
        s(r[o]);
      return s;
    })({
      1: [function(_dereq_, module, exports) {
        "use strict";
        var _interopRequireDefault = _dereq_(25)["default"];
        exports.__esModule = true;
        exports.parse = parse;
        var _parser = _dereq_(5);
        var _parser2 = _interopRequireDefault(_parser);
        _dereq_(10);
        _dereq_(9);
        _dereq_(7);
        _dereq_(4);
        _dereq_(8);
        _dereq_(6);
        _dereq_(3);
        var _tokenizerTypes = _dereq_(17);
        _dereq_(15);
        _dereq_(14);
        var _pluginsFlow = _dereq_(11);
        var _pluginsFlow2 = _interopRequireDefault(_pluginsFlow);
        var _pluginsJsx = _dereq_(12);
        var _pluginsJsx2 = _interopRequireDefault(_pluginsJsx);
        _parser.plugins.flow = _pluginsFlow2["default"];
        _parser.plugins.jsx = _pluginsJsx2["default"];
        function parse(input, options) {
          return new _parser2["default"](options, input).parse();
        }
        exports.tokTypes = _tokenizerTypes.types;
      }, {
        "10": 10,
        "11": 11,
        "12": 12,
        "14": 14,
        "15": 15,
        "17": 17,
        "25": 25,
        "3": 3,
        "4": 4,
        "5": 5,
        "6": 6,
        "7": 7,
        "8": 8,
        "9": 9
      }],
      2: [function(_dereq_, module, exports) {
        "use strict";
        exports.__esModule = true;
        exports.getOptions = getOptions;
        var defaultOptions = {
          sourceType: "script",
          sourceFilename: undefined,
          allowReturnOutsideFunction: false,
          allowImportExportEverywhere: false,
          allowSuperOutsideMethod: false,
          plugins: [],
          strictMode: null
        };
        exports.defaultOptions = defaultOptions;
        function getOptions(opts) {
          var options = {};
          for (var key in defaultOptions) {
            options[key] = opts && key in opts ? opts[key] : defaultOptions[key];
          }
          return options;
        }
      }, {}],
      3: [function(_dereq_, module, exports) {
        "use strict";
        var _interopRequireDefault = _dereq_(25)["default"];
        var _index = _dereq_(5);
        var _index2 = _interopRequireDefault(_index);
        function last(stack) {
          return stack[stack.length - 1];
        }
        var pp = _index2["default"].prototype;
        pp.addComment = function(comment) {
          this.state.trailingComments.push(comment);
          this.state.leadingComments.push(comment);
        };
        pp.processComment = function(node) {
          if (node.type === "Program" && node.body.length > 0)
            return;
          var stack = this.state.commentStack;
          var lastChild = undefined,
              trailingComments = undefined,
              i = undefined;
          if (this.state.trailingComments.length > 0) {
            if (this.state.trailingComments[0].start >= node.end) {
              trailingComments = this.state.trailingComments;
              this.state.trailingComments = [];
            } else {
              this.state.trailingComments.length = 0;
            }
          } else {
            var lastInStack = last(stack);
            if (stack.length > 0 && lastInStack.trailingComments && lastInStack.trailingComments[0].start >= node.end) {
              trailingComments = lastInStack.trailingComments;
              lastInStack.trailingComments = null;
            }
          }
          while (stack.length > 0 && last(stack).start >= node.start) {
            lastChild = stack.pop();
          }
          if (lastChild) {
            if (lastChild.leadingComments) {
              if (lastChild !== node && last(lastChild.leadingComments).end <= node.start) {
                node.leadingComments = lastChild.leadingComments;
                lastChild.leadingComments = null;
              } else {
                for (i = lastChild.leadingComments.length - 2; i >= 0; --i) {
                  if (lastChild.leadingComments[i].end <= node.start) {
                    node.leadingComments = lastChild.leadingComments.splice(0, i + 1);
                    break;
                  }
                }
              }
            }
          } else if (this.state.leadingComments.length > 0) {
            if (last(this.state.leadingComments).end <= node.start) {
              node.leadingComments = this.state.leadingComments;
              this.state.leadingComments = [];
            } else {
              for (i = 0; i < this.state.leadingComments.length; i++) {
                if (this.state.leadingComments[i].end > node.start) {
                  break;
                }
              }
              node.leadingComments = this.state.leadingComments.slice(0, i);
              if (node.leadingComments.length === 0) {
                node.leadingComments = null;
              }
              trailingComments = this.state.leadingComments.slice(i);
              if (trailingComments.length === 0) {
                trailingComments = null;
              }
            }
          }
          if (trailingComments) {
            if (trailingComments.length && trailingComments[0].start >= node.start && last(trailingComments).end <= node.end) {
              node.innerComments = trailingComments;
            } else {
              node.trailingComments = trailingComments;
            }
          }
          stack.push(node);
        };
      }, {
        "25": 25,
        "5": 5
      }],
      4: [function(_dereq_, module, exports) {
        "use strict";
        var _Object$create = _dereq_(21)["default"];
        var _interopRequireDefault = _dereq_(25)["default"];
        var _tokenizerTypes = _dereq_(17);
        var _index = _dereq_(5);
        var _index2 = _interopRequireDefault(_index);
        var _utilIdentifier = _dereq_(18);
        var pp = _index2["default"].prototype;
        pp.checkPropClash = function(prop, propHash) {
          if (prop.computed)
            return;
          var key = prop.key;
          var name = undefined;
          switch (key.type) {
            case "Identifier":
              name = key.name;
              break;
            case "StringLiteral":
            case "NumericLiteral":
              name = String(key.value);
              break;
            default:
              return;
          }
          if (name === "__proto__" && prop.kind === "init") {
            if (propHash.proto)
              this.raise(key.start, "Redefinition of __proto__ property");
            propHash.proto = true;
          }
        };
        pp.parseExpression = function(noIn, refShorthandDefaultPos) {
          var startPos = this.state.start,
              startLoc = this.state.startLoc;
          var expr = this.parseMaybeAssign(noIn, refShorthandDefaultPos);
          if (this.match(_tokenizerTypes.types.comma)) {
            var node = this.startNodeAt(startPos, startLoc);
            node.expressions = [expr];
            while (this.eat(_tokenizerTypes.types.comma)) {
              node.expressions.push(this.parseMaybeAssign(noIn, refShorthandDefaultPos));
            }
            this.toReferencedList(node.expressions);
            return this.finishNode(node, "SequenceExpression");
          }
          return expr;
        };
        pp.parseMaybeAssign = function(noIn, refShorthandDefaultPos, afterLeftParse) {
          if (this.match(_tokenizerTypes.types._yield) && this.state.inGenerator) {
            return this.parseYield();
          }
          var failOnShorthandAssign = undefined;
          if (refShorthandDefaultPos) {
            failOnShorthandAssign = false;
          } else {
            refShorthandDefaultPos = {start: 0};
            failOnShorthandAssign = true;
          }
          var startPos = this.state.start;
          var startLoc = this.state.startLoc;
          if (this.match(_tokenizerTypes.types.parenL) || this.match(_tokenizerTypes.types.name)) {
            this.state.potentialArrowAt = this.state.start;
          }
          var left = this.parseMaybeConditional(noIn, refShorthandDefaultPos);
          if (afterLeftParse)
            left = afterLeftParse.call(this, left, startPos, startLoc);
          if (this.state.type.isAssign) {
            var node = this.startNodeAt(startPos, startLoc);
            node.operator = this.state.value;
            node.left = this.match(_tokenizerTypes.types.eq) ? this.toAssignable(left) : left;
            refShorthandDefaultPos.start = 0;
            this.checkLVal(left);
            if (left.extra && left.extra.parenthesized) {
              var errorMsg = undefined;
              if (left.type === "ObjectPattern") {
                errorMsg = "`({a}) = 0` use `({a} = 0)`";
              } else if (left.type === "ArrayPattern") {
                errorMsg = "`([a]) = 0` use `([a] = 0)`";
              }
              if (errorMsg) {
                this.raise(left.start, "You're trying to assign to a parenthesized expression, eg. instead of " + errorMsg);
              }
            }
            this.next();
            node.right = this.parseMaybeAssign(noIn);
            return this.finishNode(node, "AssignmentExpression");
          } else if (failOnShorthandAssign && refShorthandDefaultPos.start) {
            this.unexpected(refShorthandDefaultPos.start);
          }
          return left;
        };
        pp.parseMaybeConditional = function(noIn, refShorthandDefaultPos) {
          var startPos = this.state.start,
              startLoc = this.state.startLoc;
          var expr = this.parseExprOps(noIn, refShorthandDefaultPos);
          if (refShorthandDefaultPos && refShorthandDefaultPos.start)
            return expr;
          if (this.eat(_tokenizerTypes.types.question)) {
            var node = this.startNodeAt(startPos, startLoc);
            node.test = expr;
            node.consequent = this.parseMaybeAssign();
            this.expect(_tokenizerTypes.types.colon);
            node.alternate = this.parseMaybeAssign(noIn);
            return this.finishNode(node, "ConditionalExpression");
          }
          return expr;
        };
        pp.parseExprOps = function(noIn, refShorthandDefaultPos) {
          var startPos = this.state.start,
              startLoc = this.state.startLoc;
          var expr = this.parseMaybeUnary(refShorthandDefaultPos);
          if (refShorthandDefaultPos && refShorthandDefaultPos.start) {
            return expr;
          } else {
            return this.parseExprOp(expr, startPos, startLoc, -1, noIn);
          }
        };
        pp.parseExprOp = function(left, leftStartPos, leftStartLoc, minPrec, noIn) {
          var prec = this.state.type.binop;
          if (prec != null && (!noIn || !this.match(_tokenizerTypes.types._in))) {
            if (prec > minPrec) {
              var node = this.startNodeAt(leftStartPos, leftStartLoc);
              node.left = left;
              node.operator = this.state.value;
              if (node.operator === "**" && left.type === "UnaryExpression" && left.extra && !left.extra.parenthesizedArgument) {
                this.raise(left.argument.start, "Illegal expression. Wrap left hand side or entire exponentiation in parentheses.");
              }
              var op = this.state.type;
              this.next();
              var startPos = this.state.start;
              var startLoc = this.state.startLoc;
              node.right = this.parseExprOp(this.parseMaybeUnary(), startPos, startLoc, op.rightAssociative ? prec - 1 : prec, noIn);
              this.finishNode(node, op === _tokenizerTypes.types.logicalOR || op === _tokenizerTypes.types.logicalAND ? "LogicalExpression" : "BinaryExpression");
              return this.parseExprOp(node, leftStartPos, leftStartLoc, minPrec, noIn);
            }
          }
          return left;
        };
        pp.parseMaybeUnary = function(refShorthandDefaultPos) {
          if (this.state.type.prefix) {
            var node = this.startNode();
            var update = this.match(_tokenizerTypes.types.incDec);
            node.operator = this.state.value;
            node.prefix = true;
            this.next();
            var argType = this.state.type;
            this.addExtra(node, "parenthesizedArgument", argType === _tokenizerTypes.types.parenL);
            node.argument = this.parseMaybeUnary();
            if (refShorthandDefaultPos && refShorthandDefaultPos.start) {
              this.unexpected(refShorthandDefaultPos.start);
            }
            if (update) {
              this.checkLVal(node.argument);
            } else if (this.state.strict && node.operator === "delete" && node.argument.type === "Identifier") {
              this.raise(node.start, "Deleting local variable in strict mode");
            }
            return this.finishNode(node, update ? "UpdateExpression" : "UnaryExpression");
          }
          var startPos = this.state.start,
              startLoc = this.state.startLoc;
          var expr = this.parseExprSubscripts(refShorthandDefaultPos);
          if (refShorthandDefaultPos && refShorthandDefaultPos.start)
            return expr;
          while (this.state.type.postfix && !this.canInsertSemicolon()) {
            var node = this.startNodeAt(startPos, startLoc);
            node.operator = this.state.value;
            node.prefix = false;
            node.argument = expr;
            this.checkLVal(expr);
            this.next();
            expr = this.finishNode(node, "UpdateExpression");
          }
          return expr;
        };
        pp.parseExprSubscripts = function(refShorthandDefaultPos) {
          var startPos = this.state.start,
              startLoc = this.state.startLoc;
          var potentialArrowAt = this.state.potentialArrowAt;
          var expr = this.parseExprAtom(refShorthandDefaultPos);
          if (expr.type === "ArrowFunctionExpression" && expr.start === potentialArrowAt) {
            return expr;
          }
          if (refShorthandDefaultPos && refShorthandDefaultPos.start) {
            return expr;
          }
          return this.parseSubscripts(expr, startPos, startLoc);
        };
        pp.parseSubscripts = function(base, startPos, startLoc, noCalls) {
          for (; ; ) {
            if (!noCalls && this.eat(_tokenizerTypes.types.doubleColon)) {
              var node = this.startNodeAt(startPos, startLoc);
              node.object = base;
              node.callee = this.parseNoCallExpr();
              return this.parseSubscripts(this.finishNode(node, "BindExpression"), startPos, startLoc, noCalls);
            } else if (this.eat(_tokenizerTypes.types.dot)) {
              var node = this.startNodeAt(startPos, startLoc);
              node.object = base;
              node.property = this.parseIdentifier(true);
              node.computed = false;
              base = this.finishNode(node, "MemberExpression");
            } else if (this.eat(_tokenizerTypes.types.bracketL)) {
              var node = this.startNodeAt(startPos, startLoc);
              node.object = base;
              node.property = this.parseExpression();
              node.computed = true;
              this.expect(_tokenizerTypes.types.bracketR);
              base = this.finishNode(node, "MemberExpression");
            } else if (!noCalls && this.match(_tokenizerTypes.types.parenL)) {
              var possibleAsync = this.state.potentialArrowAt === base.start && base.type === "Identifier" && base.name === "async" && !this.canInsertSemicolon();
              this.next();
              var node = this.startNodeAt(startPos, startLoc);
              node.callee = base;
              node.arguments = this.parseCallExpressionArguments(_tokenizerTypes.types.parenR, this.hasPlugin("trailingFunctionCommas"), possibleAsync);
              base = this.finishNode(node, "CallExpression");
              if (possibleAsync && this.shouldParseAsyncArrow()) {
                return this.parseAsyncArrowFromCallExpression(this.startNodeAt(startPos, startLoc), node);
              } else {
                this.toReferencedList(node.arguments);
              }
            } else if (this.match(_tokenizerTypes.types.backQuote)) {
              var node = this.startNodeAt(startPos, startLoc);
              node.tag = base;
              node.quasi = this.parseTemplate();
              base = this.finishNode(node, "TaggedTemplateExpression");
            } else {
              return base;
            }
          }
        };
        pp.parseCallExpressionArguments = function(close, allowTrailingComma, possibleAsyncArrow) {
          var innerParenStart = undefined;
          var elts = [],
              first = true;
          while (!this.eat(close)) {
            if (first) {
              first = false;
            } else {
              this.expect(_tokenizerTypes.types.comma);
              if (allowTrailingComma && this.eat(close))
                break;
            }
            if (this.match(_tokenizerTypes.types.parenL) && !innerParenStart) {
              innerParenStart = this.state.start;
            }
            elts.push(this.parseExprListItem());
          }
          if (possibleAsyncArrow && innerParenStart && this.shouldParseAsyncArrow()) {
            this.unexpected();
          }
          return elts;
        };
        pp.shouldParseAsyncArrow = function() {
          return this.match(_tokenizerTypes.types.arrow);
        };
        pp.parseAsyncArrowFromCallExpression = function(node, call) {
          if (!this.hasPlugin("asyncFunctions"))
            this.unexpected();
          this.expect(_tokenizerTypes.types.arrow);
          return this.parseArrowExpression(node, call.arguments, true);
        };
        pp.parseNoCallExpr = function() {
          var startPos = this.state.start,
              startLoc = this.state.startLoc;
          return this.parseSubscripts(this.parseExprAtom(), startPos, startLoc, true);
        };
        pp.parseExprAtom = function(refShorthandDefaultPos) {
          var node = undefined,
              canBeArrow = this.state.potentialArrowAt === this.state.start;
          switch (this.state.type) {
            case _tokenizerTypes.types._super:
              if (!this.state.inMethod && !this.options.allowSuperOutsideMethod) {
                this.raise(this.state.start, "'super' outside of function or class");
              }
              node = this.startNode();
              this.next();
              if (!this.match(_tokenizerTypes.types.parenL) && !this.match(_tokenizerTypes.types.bracketL) && !this.match(_tokenizerTypes.types.dot)) {
                this.unexpected();
              }
              if (this.match(_tokenizerTypes.types.parenL) && this.state.inMethod !== "constructor" && !this.options.allowSuperOutsideMethod) {
                this.raise(node.start, "super() outside of class constructor");
              }
              return this.finishNode(node, "Super");
            case _tokenizerTypes.types._this:
              node = this.startNode();
              this.next();
              return this.finishNode(node, "ThisExpression");
            case _tokenizerTypes.types._yield:
              if (this.state.inGenerator)
                this.unexpected();
            case _tokenizerTypes.types.name:
              node = this.startNode();
              var allowAwait = this.hasPlugin("asyncFunctions") && this.state.value === "await" && this.state.inAsync;
              var allowYield = this.shouldAllowYieldIdentifier();
              var id = this.parseIdentifier(allowAwait || allowYield);
              if (this.hasPlugin("asyncFunctions")) {
                if (id.name === "await") {
                  if (this.state.inAsync || this.inModule) {
                    return this.parseAwait(node);
                  }
                } else if (id.name === "async" && this.match(_tokenizerTypes.types._function) && !this.canInsertSemicolon()) {
                  this.next();
                  return this.parseFunction(node, false, false, true);
                } else if (canBeArrow && id.name === "async" && this.match(_tokenizerTypes.types.name)) {
                  var params = [this.parseIdentifier()];
                  this.expect(_tokenizerTypes.types.arrow);
                  return this.parseArrowExpression(node, params, true);
                }
              }
              if (canBeArrow && !this.canInsertSemicolon() && this.eat(_tokenizerTypes.types.arrow)) {
                return this.parseArrowExpression(node, [id]);
              }
              return id;
            case _tokenizerTypes.types._do:
              if (this.hasPlugin("doExpressions")) {
                var _node = this.startNode();
                this.next();
                var oldInFunction = this.state.inFunction;
                var oldLabels = this.state.labels;
                this.state.labels = [];
                this.state.inFunction = false;
                _node.body = this.parseBlock(false, true);
                this.state.inFunction = oldInFunction;
                this.state.labels = oldLabels;
                return this.finishNode(_node, "DoExpression");
              }
            case _tokenizerTypes.types.regexp:
              var value = this.state.value;
              node = this.parseLiteral(value.value, "RegExpLiteral");
              node.pattern = value.pattern;
              node.flags = value.flags;
              return node;
            case _tokenizerTypes.types.num:
              return this.parseLiteral(this.state.value, "NumericLiteral");
            case _tokenizerTypes.types.string:
              return this.parseLiteral(this.state.value, "StringLiteral");
            case _tokenizerTypes.types._null:
              node = this.startNode();
              this.next();
              return this.finishNode(node, "NullLiteral");
            case _tokenizerTypes.types._true:
            case _tokenizerTypes.types._false:
              node = this.startNode();
              node.value = this.match(_tokenizerTypes.types._true);
              this.next();
              return this.finishNode(node, "BooleanLiteral");
            case _tokenizerTypes.types.parenL:
              return this.parseParenAndDistinguishExpression(null, null, canBeArrow);
            case _tokenizerTypes.types.bracketL:
              node = this.startNode();
              this.next();
              node.elements = this.parseExprList(_tokenizerTypes.types.bracketR, true, true, refShorthandDefaultPos);
              this.toReferencedList(node.elements);
              return this.finishNode(node, "ArrayExpression");
            case _tokenizerTypes.types.braceL:
              return this.parseObj(false, refShorthandDefaultPos);
            case _tokenizerTypes.types._function:
              return this.parseFunctionExpression();
            case _tokenizerTypes.types.at:
              this.parseDecorators();
            case _tokenizerTypes.types._class:
              node = this.startNode();
              this.takeDecorators(node);
              return this.parseClass(node, false);
            case _tokenizerTypes.types._new:
              return this.parseNew();
            case _tokenizerTypes.types.backQuote:
              return this.parseTemplate();
            case _tokenizerTypes.types.doubleColon:
              node = this.startNode();
              this.next();
              node.object = null;
              var callee = node.callee = this.parseNoCallExpr();
              if (callee.type === "MemberExpression") {
                return this.finishNode(node, "BindExpression");
              } else {
                this.raise(callee.start, "Binding should be performed on object property.");
              }
            default:
              this.unexpected();
          }
        };
        pp.parseFunctionExpression = function() {
          var node = this.startNode();
          var meta = this.parseIdentifier(true);
          if (this.state.inGenerator && this.eat(_tokenizerTypes.types.dot) && this.hasPlugin("functionSent")) {
            return this.parseMetaProperty(node, meta, "sent");
          } else {
            return this.parseFunction(node, false);
          }
        };
        pp.parseMetaProperty = function(node, meta, propertyName) {
          node.meta = meta;
          node.property = this.parseIdentifier(true);
          if (node.property.name !== propertyName) {
            this.raise(node.property.start, "The only valid meta property for new is " + meta.name + "." + propertyName);
          }
          return this.finishNode(node, "MetaProperty");
        };
        pp.parseLiteral = function(value, type) {
          var node = this.startNode();
          this.addExtra(node, "rawValue", value);
          this.addExtra(node, "raw", this.input.slice(this.state.start, this.state.end));
          node.value = value;
          this.next();
          return this.finishNode(node, type);
        };
        pp.parseParenExpression = function() {
          this.expect(_tokenizerTypes.types.parenL);
          var val = this.parseExpression();
          this.expect(_tokenizerTypes.types.parenR);
          return val;
        };
        pp.parseParenAndDistinguishExpression = function(startPos, startLoc, canBeArrow, isAsync, allowOptionalCommaStart) {
          startPos = startPos || this.state.start;
          startLoc = startLoc || this.state.startLoc;
          var val = undefined;
          this.next();
          var innerStartPos = this.state.start,
              innerStartLoc = this.state.startLoc;
          var exprList = [],
              first = true;
          var refShorthandDefaultPos = {start: 0},
              spreadStart = undefined,
              optionalCommaStart = undefined;
          while (!this.match(_tokenizerTypes.types.parenR)) {
            if (first) {
              first = false;
            } else {
              this.expect(_tokenizerTypes.types.comma);
              if (this.match(_tokenizerTypes.types.parenR) && this.hasPlugin("trailingFunctionCommas")) {
                optionalCommaStart = this.state.start;
                break;
              }
            }
            if (this.match(_tokenizerTypes.types.ellipsis)) {
              var spreadNodeStartPos = this.state.start,
                  spreadNodeStartLoc = this.state.startLoc;
              spreadStart = this.state.start;
              exprList.push(this.parseParenItem(this.parseRest(), spreadNodeStartLoc, spreadNodeStartPos));
              break;
            } else {
              exprList.push(this.parseMaybeAssign(false, refShorthandDefaultPos, this.parseParenItem));
            }
          }
          var innerEndPos = this.state.start;
          var innerEndLoc = this.state.startLoc;
          this.expect(_tokenizerTypes.types.parenR);
          if (canBeArrow && !this.canInsertSemicolon() && this.eat(_tokenizerTypes.types.arrow)) {
            for (var _i = 0; _i < exprList.length; _i++) {
              var param = exprList[_i];
              if (param.extra && param.extra.parenthesized)
                this.unexpected(param.extra.parenStart);
            }
            return this.parseArrowExpression(this.startNodeAt(startPos, startLoc), exprList, isAsync);
          }
          if (!exprList.length) {
            if (isAsync) {
              return;
            } else {
              this.unexpected(this.state.lastTokStart);
            }
          }
          if (optionalCommaStart && !allowOptionalCommaStart)
            this.unexpected(optionalCommaStart);
          if (spreadStart)
            this.unexpected(spreadStart);
          if (refShorthandDefaultPos.start)
            this.unexpected(refShorthandDefaultPos.start);
          if (exprList.length > 1) {
            val = this.startNodeAt(innerStartPos, innerStartLoc);
            val.expressions = exprList;
            this.toReferencedList(val.expressions);
            this.finishNodeAt(val, "SequenceExpression", innerEndPos, innerEndLoc);
          } else {
            val = exprList[0];
          }
          this.addExtra(val, "parenthesized", true);
          this.addExtra(val, "parenStart", startPos);
          return val;
        };
        pp.parseParenItem = function(node) {
          return node;
        };
        pp.parseNew = function() {
          var node = this.startNode();
          var meta = this.parseIdentifier(true);
          if (this.eat(_tokenizerTypes.types.dot)) {
            return this.parseMetaProperty(node, meta, "target");
          }
          node.callee = this.parseNoCallExpr();
          if (this.eat(_tokenizerTypes.types.parenL)) {
            node.arguments = this.parseExprList(_tokenizerTypes.types.parenR, this.hasPlugin("trailingFunctionCommas"));
            this.toReferencedList(node.arguments);
          } else {
            node.arguments = [];
          }
          return this.finishNode(node, "NewExpression");
        };
        pp.parseTemplateElement = function() {
          var elem = this.startNode();
          elem.value = {
            raw: this.input.slice(this.state.start, this.state.end).replace(/\r\n?/g, "\n"),
            cooked: this.state.value
          };
          this.next();
          elem.tail = this.match(_tokenizerTypes.types.backQuote);
          return this.finishNode(elem, "TemplateElement");
        };
        pp.parseTemplate = function() {
          var node = this.startNode();
          this.next();
          node.expressions = [];
          var curElt = this.parseTemplateElement();
          node.quasis = [curElt];
          while (!curElt.tail) {
            this.expect(_tokenizerTypes.types.dollarBraceL);
            node.expressions.push(this.parseExpression());
            this.expect(_tokenizerTypes.types.braceR);
            node.quasis.push(curElt = this.parseTemplateElement());
          }
          this.next();
          return this.finishNode(node, "TemplateLiteral");
        };
        pp.parseObj = function(isPattern, refShorthandDefaultPos) {
          var decorators = [];
          var propHash = _Object$create(null);
          var first = true;
          var node = this.startNode();
          node.properties = [];
          this.next();
          while (!this.eat(_tokenizerTypes.types.braceR)) {
            if (first) {
              first = false;
            } else {
              this.expect(_tokenizerTypes.types.comma);
              if (this.eat(_tokenizerTypes.types.braceR))
                break;
            }
            while (this.match(_tokenizerTypes.types.at)) {
              decorators.push(this.parseDecorator());
            }
            var prop = this.startNode(),
                isGenerator = false,
                isAsync = false,
                startPos = undefined,
                startLoc = undefined;
            if (decorators.length) {
              prop.decorators = decorators;
              decorators = [];
            }
            if (this.hasPlugin("objectRestSpread") && this.match(_tokenizerTypes.types.ellipsis)) {
              prop = this.parseSpread();
              prop.type = isPattern ? "RestProperty" : "SpreadProperty";
              node.properties.push(prop);
              continue;
            }
            prop.method = false;
            prop.shorthand = false;
            if (isPattern || refShorthandDefaultPos) {
              startPos = this.state.start;
              startLoc = this.state.startLoc;
            }
            if (!isPattern) {
              isGenerator = this.eat(_tokenizerTypes.types.star);
            }
            if (!isPattern && this.hasPlugin("asyncFunctions") && this.isContextual("async")) {
              if (isGenerator)
                this.unexpected();
              var asyncId = this.parseIdentifier();
              if (this.match(_tokenizerTypes.types.colon) || this.match(_tokenizerTypes.types.parenL) || this.match(_tokenizerTypes.types.braceR)) {
                prop.key = asyncId;
              } else {
                isAsync = true;
                if (this.hasPlugin("asyncGenerators"))
                  isGenerator = this.eat(_tokenizerTypes.types.star);
                this.parsePropertyName(prop);
              }
            } else {
              this.parsePropertyName(prop);
            }
            this.parseObjPropValue(prop, startPos, startLoc, isGenerator, isAsync, isPattern, refShorthandDefaultPos);
            this.checkPropClash(prop, propHash);
            if (prop.shorthand) {
              this.addExtra(prop, "shorthand", true);
            }
            node.properties.push(prop);
          }
          if (decorators.length) {
            this.raise(this.state.start, "You have trailing decorators with no property");
          }
          return this.finishNode(node, isPattern ? "ObjectPattern" : "ObjectExpression");
        };
        pp.parseObjPropValue = function(prop, startPos, startLoc, isGenerator, isAsync, isPattern, refShorthandDefaultPos) {
          if (isAsync || isGenerator || this.match(_tokenizerTypes.types.parenL)) {
            if (isPattern)
              this.unexpected();
            prop.kind = "method";
            prop.method = true;
            this.parseMethod(prop, isGenerator, isAsync);
            return this.finishNode(prop, "ObjectMethod");
          }
          if (this.eat(_tokenizerTypes.types.colon)) {
            prop.value = isPattern ? this.parseMaybeDefault(this.state.start, this.state.startLoc) : this.parseMaybeAssign(false, refShorthandDefaultPos);
            return this.finishNode(prop, "ObjectProperty");
          }
          if (!prop.computed && prop.key.type === "Identifier" && (prop.key.name === "get" || prop.key.name === "set") && !this.match(_tokenizerTypes.types.comma) && !this.match(_tokenizerTypes.types.braceR)) {
            if (isGenerator || isAsync || isPattern)
              this.unexpected();
            prop.kind = prop.key.name;
            this.parsePropertyName(prop);
            this.parseMethod(prop, false);
            var paramCount = prop.kind === "get" ? 0 : 1;
            if (prop.params.length !== paramCount) {
              var start = prop.start;
              if (prop.kind === "get") {
                this.raise(start, "getter should have no params");
              } else {
                this.raise(start, "setter should have exactly one param");
              }
            }
            return this.finishNode(prop, "ObjectMethod");
          }
          if (!prop.computed && prop.key.type === "Identifier") {
            if (isPattern) {
              var illegalBinding = this.isKeyword(prop.key.name);
              if (!illegalBinding && this.state.strict) {
                illegalBinding = _utilIdentifier.reservedWords.strictBind(prop.key.name) || _utilIdentifier.reservedWords.strict(prop.key.name);
              }
              if (illegalBinding) {
                this.raise(prop.key.start, "Binding " + prop.key.name);
              }
              prop.value = this.parseMaybeDefault(startPos, startLoc, prop.key.__clone());
            } else if (this.match(_tokenizerTypes.types.eq) && refShorthandDefaultPos) {
              if (!refShorthandDefaultPos.start) {
                refShorthandDefaultPos.start = this.state.start;
              }
              prop.value = this.parseMaybeDefault(startPos, startLoc, prop.key.__clone());
            } else {
              prop.value = prop.key.__clone();
            }
            prop.shorthand = true;
            return this.finishNode(prop, "ObjectProperty");
          }
          this.unexpected();
        };
        pp.parsePropertyName = function(prop) {
          if (this.eat(_tokenizerTypes.types.bracketL)) {
            prop.computed = true;
            prop.key = this.parseMaybeAssign();
            this.expect(_tokenizerTypes.types.bracketR);
            return prop.key;
          } else {
            prop.computed = false;
            return prop.key = this.match(_tokenizerTypes.types.num) || this.match(_tokenizerTypes.types.string) ? this.parseExprAtom() : this.parseIdentifier(true);
          }
        };
        pp.initFunction = function(node, isAsync) {
          node.id = null;
          node.generator = false;
          node.expression = false;
          if (this.hasPlugin("asyncFunctions")) {
            node.async = !!isAsync;
          }
        };
        pp.parseMethod = function(node, isGenerator, isAsync) {
          var oldInMethod = this.state.inMethod;
          this.state.inMethod = node.kind || true;
          this.initFunction(node, isAsync);
          this.expect(_tokenizerTypes.types.parenL);
          node.params = this.parseBindingList(_tokenizerTypes.types.parenR, false, this.hasPlugin("trailingFunctionCommas"));
          node.generator = isGenerator;
          this.parseFunctionBody(node);
          this.state.inMethod = oldInMethod;
          return node;
        };
        pp.parseArrowExpression = function(node, params, isAsync) {
          this.initFunction(node, isAsync);
          node.params = this.toAssignableList(params, true);
          this.parseFunctionBody(node, true);
          return this.finishNode(node, "ArrowFunctionExpression");
        };
        pp.parseFunctionBody = function(node, allowExpression) {
          var isExpression = allowExpression && !this.match(_tokenizerTypes.types.braceL);
          var oldInAsync = this.state.inAsync;
          this.state.inAsync = node.async;
          if (isExpression) {
            node.body = this.parseMaybeAssign();
            node.expression = true;
          } else {
            var oldInFunc = this.state.inFunction,
                oldInGen = this.state.inGenerator,
                oldLabels = this.state.labels;
            this.state.inFunction = true;
            this.state.inGenerator = node.generator;
            this.state.labels = [];
            node.body = this.parseBlock(true);
            node.expression = false;
            this.state.inFunction = oldInFunc;
            this.state.inGenerator = oldInGen;
            this.state.labels = oldLabels;
          }
          this.state.inAsync = oldInAsync;
          var checkLVal = this.state.strict;
          var checkLValStrict = false;
          var isStrict = false;
          if (allowExpression)
            checkLVal = true;
          if (!isExpression && node.body.directives.length) {
            var _arr = node.body.directives;
            for (var _i2 = 0; _i2 < _arr.length; _i2++) {
              var directive = _arr[_i2];
              if (directive.value.value === "use strict") {
                isStrict = true;
                checkLVal = true;
                checkLValStrict = true;
                break;
              }
            }
          }
          if (isStrict && node.id && node.id.type === "Identifier" && node.id.name === "yield") {
            this.raise(node.id.start, "Binding yield in strict mode");
          }
          if (checkLVal) {
            var nameHash = _Object$create(null);
            var oldStrict = this.state.strict;
            if (checkLValStrict)
              this.state.strict = true;
            if (node.id) {
              this.checkLVal(node.id, true);
            }
            var _arr2 = node.params;
            for (var _i3 = 0; _i3 < _arr2.length; _i3++) {
              var param = _arr2[_i3];
              this.checkLVal(param, true, nameHash);
            }
            this.state.strict = oldStrict;
          }
        };
        pp.parseExprList = function(close, allowTrailingComma, allowEmpty, refShorthandDefaultPos) {
          var elts = [],
              first = true;
          while (!this.eat(close)) {
            if (first) {
              first = false;
            } else {
              this.expect(_tokenizerTypes.types.comma);
              if (allowTrailingComma && this.eat(close))
                break;
            }
            elts.push(this.parseExprListItem(allowEmpty, refShorthandDefaultPos));
          }
          return elts;
        };
        pp.parseExprListItem = function(allowEmpty, refShorthandDefaultPos) {
          var elt = undefined;
          if (allowEmpty && this.match(_tokenizerTypes.types.comma)) {
            elt = null;
          } else if (this.match(_tokenizerTypes.types.ellipsis)) {
            elt = this.parseSpread(refShorthandDefaultPos);
          } else {
            elt = this.parseMaybeAssign(false, refShorthandDefaultPos);
          }
          return elt;
        };
        pp.parseIdentifier = function(liberal) {
          var node = this.startNode();
          if (this.match(_tokenizerTypes.types.name)) {
            if (!liberal && this.state.strict && _utilIdentifier.reservedWords.strict(this.state.value)) {
              this.raise(this.state.start, "The keyword '" + this.state.value + "' is reserved");
            }
            node.name = this.state.value;
          } else if (liberal && this.state.type.keyword) {
            node.name = this.state.type.keyword;
          } else {
            this.unexpected();
          }
          if (!liberal && node.name === "await" && this.state.inAsync) {
            this.raise(node.start, "invalid use of await inside of an async function");
          }
          this.next();
          return this.finishNode(node, "Identifier");
        };
        pp.parseAwait = function(node) {
          if (!this.state.inAsync) {
            this.unexpected();
          }
          if (this.isLineTerminator()) {
            this.unexpected();
          }
          if (this.match(_tokenizerTypes.types.star)) {
            this.raise(node.start, "await* has been removed from the async functions proposal. Use Promise.all() instead.");
          }
          node.argument = this.parseMaybeUnary();
          return this.finishNode(node, "AwaitExpression");
        };
        pp.parseYield = function() {
          var node = this.startNode();
          this.next();
          if (this.match(_tokenizerTypes.types.semi) || this.canInsertSemicolon() || !this.match(_tokenizerTypes.types.star) && !this.state.type.startsExpr) {
            node.delegate = false;
            node.argument = null;
          } else {
            node.delegate = this.eat(_tokenizerTypes.types.star);
            node.argument = this.parseMaybeAssign();
          }
          return this.finishNode(node, "YieldExpression");
        };
      }, {
        "17": 17,
        "18": 18,
        "21": 21,
        "25": 25,
        "5": 5
      }],
      5: [function(_dereq_, module, exports) {
        "use strict";
        var _inherits = _dereq_(24)["default"];
        var _classCallCheck = _dereq_(23)["default"];
        var _interopRequireDefault = _dereq_(25)["default"];
        exports.__esModule = true;
        var _utilIdentifier = _dereq_(18);
        var _options = _dereq_(2);
        var _tokenizer = _dereq_(15);
        var _tokenizer2 = _interopRequireDefault(_tokenizer);
        var plugins = {};
        exports.plugins = plugins;
        var Parser = (function(_Tokenizer) {
          _inherits(Parser, _Tokenizer);
          function Parser(options, input) {
            _classCallCheck(this, Parser);
            options = _options.getOptions(options);
            _Tokenizer.call(this, options, input);
            this.options = options;
            this.inModule = this.options.sourceType === "module";
            this.isReservedWord = _utilIdentifier.reservedWords[6];
            this.input = input;
            this.plugins = this.loadPlugins(this.options.plugins);
            this.filename = options.sourceFilename;
            if (this.state.pos === 0 && this.input[0] === "#" && this.input[1] === "!") {
              this.skipLineComment(2);
            }
          }
          Parser.prototype.hasPlugin = function hasPlugin(name) {
            return !!(this.plugins["*"] || this.plugins[name]);
          };
          Parser.prototype.extend = function extend(name, f) {
            this[name] = f(this[name]);
          };
          Parser.prototype.loadPlugins = function loadPlugins(plugins) {
            var pluginMap = {};
            if (plugins.indexOf("flow") >= 0) {
              plugins = plugins.filter(function(plugin) {
                return plugin !== "flow";
              });
              plugins.push("flow");
            }
            for (var _i = 0; _i < plugins.length; _i++) {
              var _name = plugins[_i];
              if (!pluginMap[_name]) {
                pluginMap[_name] = true;
                var plugin = exports.plugins[_name];
                if (plugin)
                  plugin(this);
              }
            }
            return pluginMap;
          };
          Parser.prototype.parse = function parse() {
            var file = this.startNode();
            var program = this.startNode();
            this.nextToken();
            return this.parseTopLevel(file, program);
          };
          return Parser;
        })(_tokenizer2["default"]);
        exports["default"] = Parser;
      }, {
        "15": 15,
        "18": 18,
        "2": 2,
        "23": 23,
        "24": 24,
        "25": 25
      }],
      6: [function(_dereq_, module, exports) {
        "use strict";
        var _interopRequireDefault = _dereq_(25)["default"];
        var _utilLocation = _dereq_(19);
        var _index = _dereq_(5);
        var _index2 = _interopRequireDefault(_index);
        var pp = _index2["default"].prototype;
        pp.raise = function(pos, message) {
          var loc = _utilLocation.getLineInfo(this.input, pos);
          message += " (" + loc.line + ":" + loc.column + ")";
          var err = new SyntaxError(message);
          err.pos = pos;
          err.loc = loc;
          throw err;
        };
      }, {
        "19": 19,
        "25": 25,
        "5": 5
      }],
      7: [function(_dereq_, module, exports) {
        "use strict";
        var _interopRequireDefault = _dereq_(25)["default"];
        var _tokenizerTypes = _dereq_(17);
        var _index = _dereq_(5);
        var _index2 = _interopRequireDefault(_index);
        var _utilIdentifier = _dereq_(18);
        var pp = _index2["default"].prototype;
        pp.toAssignable = function(node, isBinding) {
          if (node) {
            switch (node.type) {
              case "Identifier":
              case "ObjectPattern":
              case "ArrayPattern":
              case "AssignmentPattern":
                break;
              case "ObjectExpression":
                node.type = "ObjectPattern";
                var _arr = node.properties;
                for (var _i = 0; _i < _arr.length; _i++) {
                  var prop = _arr[_i];
                  if (prop.type === "ObjectMethod") {
                    if (prop.kind === "get" || prop.kind === "set") {
                      this.raise(prop.key.start, "Object pattern can't contain getter or setter");
                    } else {
                      this.raise(prop.key.start, "Object pattern can't contain methods");
                    }
                  } else {
                    this.toAssignable(prop, isBinding);
                  }
                }
                break;
              case "ObjectProperty":
                this.toAssignable(node.value, isBinding);
                break;
              case "SpreadProperty":
                node.type = "RestProperty";
                break;
              case "ArrayExpression":
                node.type = "ArrayPattern";
                this.toAssignableList(node.elements, isBinding);
                break;
              case "AssignmentExpression":
                if (node.operator === "=") {
                  node.type = "AssignmentPattern";
                  delete node.operator;
                } else {
                  this.raise(node.left.end, "Only '=' operator can be used for specifying default value.");
                }
                break;
              case "MemberExpression":
                if (!isBinding)
                  break;
              default:
                this.raise(node.start, "Assigning to rvalue");
            }
          }
          return node;
        };
        pp.toAssignableList = function(exprList, isBinding) {
          var end = exprList.length;
          if (end) {
            var last = exprList[end - 1];
            if (last && last.type === "RestElement") {
              --end;
            } else if (last && last.type === "SpreadElement") {
              last.type = "RestElement";
              var arg = last.argument;
              this.toAssignable(arg, isBinding);
              if (arg.type !== "Identifier" && arg.type !== "MemberExpression" && arg.type !== "ArrayPattern") {
                this.unexpected(arg.start);
              }
              --end;
            }
          }
          for (var i = 0; i < end; i++) {
            var elt = exprList[i];
            if (elt)
              this.toAssignable(elt, isBinding);
          }
          return exprList;
        };
        pp.toReferencedList = function(exprList) {
          return exprList;
        };
        pp.parseSpread = function(refShorthandDefaultPos) {
          var node = this.startNode();
          this.next();
          node.argument = this.parseMaybeAssign(refShorthandDefaultPos);
          return this.finishNode(node, "SpreadElement");
        };
        pp.parseRest = function() {
          var node = this.startNode();
          this.next();
          node.argument = this.parseBindingIdentifier();
          return this.finishNode(node, "RestElement");
        };
        pp.shouldAllowYieldIdentifier = function() {
          return this.match(_tokenizerTypes.types._yield) && !this.state.strict && !this.state.inGenerator;
        };
        pp.parseBindingIdentifier = function() {
          return this.parseIdentifier(this.shouldAllowYieldIdentifier());
        };
        pp.parseBindingAtom = function() {
          switch (this.state.type) {
            case _tokenizerTypes.types._yield:
              if (this.state.strict || this.state.inGenerator)
                this.unexpected();
            case _tokenizerTypes.types.name:
              return this.parseIdentifier(true);
            case _tokenizerTypes.types.bracketL:
              var node = this.startNode();
              this.next();
              node.elements = this.parseBindingList(_tokenizerTypes.types.bracketR, true, true);
              return this.finishNode(node, "ArrayPattern");
            case _tokenizerTypes.types.braceL:
              return this.parseObj(true);
            default:
              this.unexpected();
          }
        };
        pp.parseBindingList = function(close, allowEmpty, allowTrailingComma) {
          var elts = [];
          var first = true;
          while (!this.eat(close)) {
            if (first) {
              first = false;
            } else {
              this.expect(_tokenizerTypes.types.comma);
            }
            if (allowEmpty && this.match(_tokenizerTypes.types.comma)) {
              elts.push(null);
            } else if (allowTrailingComma && this.eat(close)) {
              break;
            } else if (this.match(_tokenizerTypes.types.ellipsis)) {
              elts.push(this.parseAssignableListItemTypes(this.parseRest()));
              this.expect(close);
              break;
            } else {
              var left = this.parseMaybeDefault();
              this.parseAssignableListItemTypes(left);
              elts.push(this.parseMaybeDefault(null, null, left));
            }
          }
          return elts;
        };
        pp.parseAssignableListItemTypes = function(param) {
          return param;
        };
        pp.parseMaybeDefault = function(startPos, startLoc, left) {
          startLoc = startLoc || this.state.startLoc;
          startPos = startPos || this.state.start;
          left = left || this.parseBindingAtom();
          if (!this.eat(_tokenizerTypes.types.eq))
            return left;
          var node = this.startNodeAt(startPos, startLoc);
          node.left = left;
          node.right = this.parseMaybeAssign();
          return this.finishNode(node, "AssignmentPattern");
        };
        pp.checkLVal = function(expr, isBinding, checkClashes) {
          switch (expr.type) {
            case "Identifier":
              if (this.state.strict && (_utilIdentifier.reservedWords.strictBind(expr.name) || _utilIdentifier.reservedWords.strict(expr.name))) {
                this.raise(expr.start, (isBinding ? "Binding " : "Assigning to ") + expr.name + " in strict mode");
              }
              if (checkClashes) {
                var key = "_" + expr.name;
                if (checkClashes[key]) {
                  this.raise(expr.start, "Argument name clash in strict mode");
                } else {
                  checkClashes[key] = true;
                }
              }
              break;
            case "MemberExpression":
              if (isBinding)
                this.raise(expr.start, (isBinding ? "Binding" : "Assigning to") + " member expression");
              break;
            case "ObjectPattern":
              var _arr2 = expr.properties;
              for (var _i2 = 0; _i2 < _arr2.length; _i2++) {
                var prop = _arr2[_i2];
                if (prop.type === "ObjectProperty")
                  prop = prop.value;
                this.checkLVal(prop, isBinding, checkClashes);
              }
              break;
            case "ArrayPattern":
              var _arr3 = expr.elements;
              for (var _i3 = 0; _i3 < _arr3.length; _i3++) {
                var elem = _arr3[_i3];
                if (elem)
                  this.checkLVal(elem, isBinding, checkClashes);
              }
              break;
            case "AssignmentPattern":
              this.checkLVal(expr.left, isBinding, checkClashes);
              break;
            case "RestProperty":
            case "RestElement":
              this.checkLVal(expr.argument, isBinding, checkClashes);
              break;
            default:
              this.raise(expr.start, (isBinding ? "Binding" : "Assigning to") + " rvalue");
          }
        };
      }, {
        "17": 17,
        "18": 18,
        "25": 25,
        "5": 5
      }],
      8: [function(_dereq_, module, exports) {
        "use strict";
        var _classCallCheck = _dereq_(23)["default"];
        var _interopRequireDefault = _dereq_(25)["default"];
        var _index = _dereq_(5);
        var _index2 = _interopRequireDefault(_index);
        var _utilLocation = _dereq_(19);
        var pp = _index2["default"].prototype;
        var Node = (function() {
          function Node(pos, loc, filename) {
            _classCallCheck(this, Node);
            this.type = "";
            this.start = pos;
            this.end = 0;
            this.loc = new _utilLocation.SourceLocation(loc);
            if (filename)
              this.loc.filename = filename;
          }
          Node.prototype.__clone = function __clone() {
            var node2 = new Node();
            for (var key in this) {
              node2[key] = this[key];
            }
            return node2;
          };
          return Node;
        })();
        pp.startNode = function() {
          return new Node(this.state.start, this.state.startLoc, this.filename);
        };
        pp.startNodeAt = function(pos, loc) {
          return new Node(pos, loc, this.filename);
        };
        function finishNodeAt(node, type, pos, loc) {
          node.type = type;
          node.end = pos;
          node.loc.end = loc;
          this.processComment(node);
          return node;
        }
        pp.finishNode = function(node, type) {
          return finishNodeAt.call(this, node, type, this.state.lastTokEnd, this.state.lastTokEndLoc);
        };
        pp.finishNodeAt = function(node, type, pos, loc) {
          return finishNodeAt.call(this, node, type, pos, loc);
        };
      }, {
        "19": 19,
        "23": 23,
        "25": 25,
        "5": 5
      }],
      9: [function(_dereq_, module, exports) {
        "use strict";
        var _Object$create = _dereq_(21)["default"];
        var _interopRequireDefault = _dereq_(25)["default"];
        var _tokenizerTypes = _dereq_(17);
        var _index = _dereq_(5);
        var _index2 = _interopRequireDefault(_index);
        var _utilWhitespace = _dereq_(20);
        var pp = _index2["default"].prototype;
        pp.parseTopLevel = function(file, program) {
          program.sourceType = this.options.sourceType;
          this.parseBlockBody(program, true, true, _tokenizerTypes.types.eof);
          file.program = this.finishNode(program, "Program");
          file.comments = this.state.comments;
          file.tokens = this.state.tokens;
          return this.finishNode(file, "File");
        };
        var loopLabel = {kind: "loop"},
            switchLabel = {kind: "switch"};
        pp.stmtToDirective = function(stmt) {
          var expr = stmt.expression;
          var directiveLiteral = this.startNodeAt(expr.start, expr.loc.start);
          var directive = this.startNodeAt(stmt.start, stmt.loc.start);
          var raw = this.input.slice(expr.start, expr.end);
          var val = directiveLiteral.value = raw.slice(1, -1);
          this.addExtra(directiveLiteral, "raw", raw);
          this.addExtra(directiveLiteral, "rawValue", val);
          directive.value = this.finishNodeAt(directiveLiteral, "DirectiveLiteral", expr.end, expr.loc.end);
          return this.finishNodeAt(directive, "Directive", stmt.end, stmt.loc.end);
        };
        pp.parseStatement = function(declaration, topLevel) {
          if (this.match(_tokenizerTypes.types.at)) {
            this.parseDecorators(true);
          }
          var starttype = this.state.type,
              node = this.startNode();
          switch (starttype) {
            case _tokenizerTypes.types._break:
            case _tokenizerTypes.types._continue:
              return this.parseBreakContinueStatement(node, starttype.keyword);
            case _tokenizerTypes.types._debugger:
              return this.parseDebuggerStatement(node);
            case _tokenizerTypes.types._do:
              return this.parseDoStatement(node);
            case _tokenizerTypes.types._for:
              return this.parseForStatement(node);
            case _tokenizerTypes.types._function:
              if (!declaration)
                this.unexpected();
              return this.parseFunctionStatement(node);
            case _tokenizerTypes.types._class:
              if (!declaration)
                this.unexpected();
              this.takeDecorators(node);
              return this.parseClass(node, true);
            case _tokenizerTypes.types._if:
              return this.parseIfStatement(node);
            case _tokenizerTypes.types._return:
              return this.parseReturnStatement(node);
            case _tokenizerTypes.types._switch:
              return this.parseSwitchStatement(node);
            case _tokenizerTypes.types._throw:
              return this.parseThrowStatement(node);
            case _tokenizerTypes.types._try:
              return this.parseTryStatement(node);
            case _tokenizerTypes.types._let:
            case _tokenizerTypes.types._const:
              if (!declaration)
                this.unexpected();
            case _tokenizerTypes.types._var:
              return this.parseVarStatement(node, starttype);
            case _tokenizerTypes.types._while:
              return this.parseWhileStatement(node);
            case _tokenizerTypes.types._with:
              return this.parseWithStatement(node);
            case _tokenizerTypes.types.braceL:
              return this.parseBlock();
            case _tokenizerTypes.types.semi:
              return this.parseEmptyStatement(node);
            case _tokenizerTypes.types._export:
            case _tokenizerTypes.types._import:
              if (!this.options.allowImportExportEverywhere) {
                if (!topLevel) {
                  this.raise(this.state.start, "'import' and 'export' may only appear at the top level");
                }
                if (!this.inModule) {
                  this.raise(this.state.start, "'import' and 'export' may appear only with 'sourceType: module'");
                }
              }
              return starttype === _tokenizerTypes.types._import ? this.parseImport(node) : this.parseExport(node);
            case _tokenizerTypes.types.name:
              if (this.hasPlugin("asyncFunctions") && this.state.value === "async") {
                var state = this.state.clone();
                this.next();
                if (this.match(_tokenizerTypes.types._function) && !this.canInsertSemicolon()) {
                  this.expect(_tokenizerTypes.types._function);
                  return this.parseFunction(node, true, false, true);
                } else {
                  this.state = state;
                }
              }
          }
          var maybeName = this.state.value;
          var expr = this.parseExpression();
          if (starttype === _tokenizerTypes.types.name && expr.type === "Identifier" && this.eat(_tokenizerTypes.types.colon)) {
            return this.parseLabeledStatement(node, maybeName, expr);
          } else {
            return this.parseExpressionStatement(node, expr);
          }
        };
        pp.takeDecorators = function(node) {
          if (this.state.decorators.length) {
            node.decorators = this.state.decorators;
            this.state.decorators = [];
          }
        };
        pp.parseDecorators = function(allowExport) {
          while (this.match(_tokenizerTypes.types.at)) {
            this.state.decorators.push(this.parseDecorator());
          }
          if (allowExport && this.match(_tokenizerTypes.types._export)) {
            return;
          }
          if (!this.match(_tokenizerTypes.types._class)) {
            this.raise(this.state.start, "Leading decorators must be attached to a class declaration");
          }
        };
        pp.parseDecorator = function() {
          if (!this.hasPlugin("decorators")) {
            this.unexpected();
          }
          var node = this.startNode();
          this.next();
          node.expression = this.parseMaybeAssign();
          return this.finishNode(node, "Decorator");
        };
        pp.parseBreakContinueStatement = function(node, keyword) {
          var isBreak = keyword === "break";
          this.next();
          if (this.isLineTerminator()) {
            node.label = null;
          } else if (!this.match(_tokenizerTypes.types.name)) {
            this.unexpected();
          } else {
            node.label = this.parseIdentifier();
            this.semicolon();
          }
          var i = undefined;
          for (i = 0; i < this.state.labels.length; ++i) {
            var lab = this.state.labels[i];
            if (node.label == null || lab.name === node.label.name) {
              if (lab.kind != null && (isBreak || lab.kind === "loop"))
                break;
              if (node.label && isBreak)
                break;
            }
          }
          if (i === this.state.labels.length)
            this.raise(node.start, "Unsyntactic " + keyword);
          return this.finishNode(node, isBreak ? "BreakStatement" : "ContinueStatement");
        };
        pp.parseDebuggerStatement = function(node) {
          this.next();
          this.semicolon();
          return this.finishNode(node, "DebuggerStatement");
        };
        pp.parseDoStatement = function(node) {
          this.next();
          this.state.labels.push(loopLabel);
          node.body = this.parseStatement(false);
          this.state.labels.pop();
          this.expect(_tokenizerTypes.types._while);
          node.test = this.parseParenExpression();
          this.eat(_tokenizerTypes.types.semi);
          return this.finishNode(node, "DoWhileStatement");
        };
        pp.parseForStatement = function(node) {
          this.next();
          this.state.labels.push(loopLabel);
          this.expect(_tokenizerTypes.types.parenL);
          if (this.match(_tokenizerTypes.types.semi)) {
            return this.parseFor(node, null);
          }
          if (this.match(_tokenizerTypes.types._var) || this.match(_tokenizerTypes.types._let) || this.match(_tokenizerTypes.types._const)) {
            var _init = this.startNode(),
                varKind = this.state.type;
            this.next();
            this.parseVar(_init, true, varKind);
            this.finishNode(_init, "VariableDeclaration");
            if (this.match(_tokenizerTypes.types._in) || this.isContextual("of")) {
              if (_init.declarations.length === 1 && !_init.declarations[0].init) {
                return this.parseForIn(node, _init);
              }
            }
            return this.parseFor(node, _init);
          }
          var refShorthandDefaultPos = {start: 0};
          var init = this.parseExpression(true, refShorthandDefaultPos);
          if (this.match(_tokenizerTypes.types._in) || this.isContextual("of")) {
            this.toAssignable(init);
            this.checkLVal(init);
            return this.parseForIn(node, init);
          } else if (refShorthandDefaultPos.start) {
            this.unexpected(refShorthandDefaultPos.start);
          }
          return this.parseFor(node, init);
        };
        pp.parseFunctionStatement = function(node) {
          this.next();
          return this.parseFunction(node, true);
        };
        pp.parseIfStatement = function(node) {
          this.next();
          node.test = this.parseParenExpression();
          node.consequent = this.parseStatement(false);
          node.alternate = this.eat(_tokenizerTypes.types._else) ? this.parseStatement(false) : null;
          return this.finishNode(node, "IfStatement");
        };
        pp.parseReturnStatement = function(node) {
          if (!this.state.inFunction && !this.options.allowReturnOutsideFunction) {
            this.raise(this.state.start, "'return' outside of function");
          }
          this.next();
          if (this.isLineTerminator()) {
            node.argument = null;
          } else {
            node.argument = this.parseExpression();
            this.semicolon();
          }
          return this.finishNode(node, "ReturnStatement");
        };
        pp.parseSwitchStatement = function(node) {
          this.next();
          node.discriminant = this.parseParenExpression();
          node.cases = [];
          this.expect(_tokenizerTypes.types.braceL);
          this.state.labels.push(switchLabel);
          var cur = undefined;
          for (var sawDefault = undefined; !this.match(_tokenizerTypes.types.braceR); ) {
            if (this.match(_tokenizerTypes.types._case) || this.match(_tokenizerTypes.types._default)) {
              var isCase = this.match(_tokenizerTypes.types._case);
              if (cur)
                this.finishNode(cur, "SwitchCase");
              node.cases.push(cur = this.startNode());
              cur.consequent = [];
              this.next();
              if (isCase) {
                cur.test = this.parseExpression();
              } else {
                if (sawDefault)
                  this.raise(this.state.lastTokStart, "Multiple default clauses");
                sawDefault = true;
                cur.test = null;
              }
              this.expect(_tokenizerTypes.types.colon);
            } else {
              if (cur) {
                cur.consequent.push(this.parseStatement(true));
              } else {
                this.unexpected();
              }
            }
          }
          if (cur)
            this.finishNode(cur, "SwitchCase");
          this.next();
          this.state.labels.pop();
          return this.finishNode(node, "SwitchStatement");
        };
        pp.parseThrowStatement = function(node) {
          this.next();
          if (_utilWhitespace.lineBreak.test(this.input.slice(this.state.lastTokEnd, this.state.start)))
            this.raise(this.state.lastTokEnd, "Illegal newline after throw");
          node.argument = this.parseExpression();
          this.semicolon();
          return this.finishNode(node, "ThrowStatement");
        };
        var empty = [];
        pp.parseTryStatement = function(node) {
          this.next();
          node.block = this.parseBlock();
          node.handler = null;
          if (this.match(_tokenizerTypes.types._catch)) {
            var clause = this.startNode();
            this.next();
            this.expect(_tokenizerTypes.types.parenL);
            clause.param = this.parseBindingAtom();
            this.checkLVal(clause.param, true, _Object$create(null));
            this.expect(_tokenizerTypes.types.parenR);
            clause.body = this.parseBlock();
            node.handler = this.finishNode(clause, "CatchClause");
          }
          node.guardedHandlers = empty;
          node.finalizer = this.eat(_tokenizerTypes.types._finally) ? this.parseBlock() : null;
          if (!node.handler && !node.finalizer) {
            this.raise(node.start, "Missing catch or finally clause");
          }
          return this.finishNode(node, "TryStatement");
        };
        pp.parseVarStatement = function(node, kind) {
          this.next();
          this.parseVar(node, false, kind);
          this.semicolon();
          return this.finishNode(node, "VariableDeclaration");
        };
        pp.parseWhileStatement = function(node) {
          this.next();
          node.test = this.parseParenExpression();
          this.state.labels.push(loopLabel);
          node.body = this.parseStatement(false);
          this.state.labels.pop();
          return this.finishNode(node, "WhileStatement");
        };
        pp.parseWithStatement = function(node) {
          if (this.state.strict)
            this.raise(this.state.start, "'with' in strict mode");
          this.next();
          node.object = this.parseParenExpression();
          node.body = this.parseStatement(false);
          return this.finishNode(node, "WithStatement");
        };
        pp.parseEmptyStatement = function(node) {
          this.next();
          return this.finishNode(node, "EmptyStatement");
        };
        pp.parseLabeledStatement = function(node, maybeName, expr) {
          var _arr = this.state.labels;
          for (var _i = 0; _i < _arr.length; _i++) {
            var label = _arr[_i];
            if (label.name === maybeName) {
              this.raise(expr.start, "Label '" + maybeName + "' is already declared");
            }
          }
          var kind = this.state.type.isLoop ? "loop" : this.match(_tokenizerTypes.types._switch) ? "switch" : null;
          for (var i = this.state.labels.length - 1; i >= 0; i--) {
            var label = this.state.labels[i];
            if (label.statementStart === node.start) {
              label.statementStart = this.state.start;
              label.kind = kind;
            } else {
              break;
            }
          }
          this.state.labels.push({
            name: maybeName,
            kind: kind,
            statementStart: this.state.start
          });
          node.body = this.parseStatement(true);
          this.state.labels.pop();
          node.label = expr;
          return this.finishNode(node, "LabeledStatement");
        };
        pp.parseExpressionStatement = function(node, expr) {
          node.expression = expr;
          this.semicolon();
          return this.finishNode(node, "ExpressionStatement");
        };
        pp.parseBlock = function(allowDirectives) {
          var node = this.startNode();
          this.expect(_tokenizerTypes.types.braceL);
          this.parseBlockBody(node, allowDirectives, false, _tokenizerTypes.types.braceR);
          return this.finishNode(node, "BlockStatement");
        };
        pp.parseBlockBody = function(node, allowDirectives, topLevel, end) {
          node.body = [];
          node.directives = [];
          var parsedNonDirective = false;
          var oldStrict = undefined;
          var octalPosition = undefined;
          while (!this.eat(end)) {
            if (!parsedNonDirective && this.state.containsOctal && !octalPosition) {
              octalPosition = this.state.octalPosition;
            }
            var stmt = this.parseStatement(true, topLevel);
            if (allowDirectives && !parsedNonDirective && stmt.type === "ExpressionStatement" && stmt.expression.type === "StringLiteral" && !stmt.expression.extra.parenthesized) {
              var directive = this.stmtToDirective(stmt);
              node.directives.push(directive);
              if (oldStrict === undefined && directive.value.value === "use strict") {
                oldStrict = this.state.strict;
                this.setStrict(true);
                if (octalPosition) {
                  this.raise(octalPosition, "Octal literal in strict mode");
                }
              }
              continue;
            }
            parsedNo