'use strict';

var _regenerator = require('babel-runtime/regenerator');

var _regenerator2 = _interopRequireDefault(_regenerator);

var _keys = require('babel-runtime/core-js/object/keys');

var _keys2 = _interopRequireDefault(_keys);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var co = require('co');
var extend = require('xtend');
var ora = require('ora');
var getUnusedPackages = require('./get-unused-packages');
var createPackageSummary = require('./create-package-summary');

module.exports = function (currentState) {
    return co( /*#__PURE__*/_regenerator2.default.mark(function _callee() {
        var spinner, cwdPackageJson, dependencies, allDependencies, allDependenciesIncludingMissing, arrayOfPackageInfo;
        return _regenerator2.default.wrap(function _callee$(_context) {
            while (1) {
                switch (_context.prev = _context.next) {
                    case 0:
                        dependencies = function dependencies(pkg) {
                            if (currentState.get('global')) {
                                return currentState.get('globalPackages');
                            }

                            if (currentState.get('ignoreDev')) {
                                return pkg.dependencies;
                            }

                            if (currentState.get('devOnly')) {
                                return pkg.devDependencies;
                            }

                            return extend(pkg.dependencies, pkg.devDependencies);
                        };

                        _context.next = 3;
                        return getUnusedPackages(currentState);

                    case 3:
                        spinner = ora('Checking npm registries for updated packages.');

                        spinner.enabled = spinner.enabled && currentState.get('spinner');
                        spinner.start();

                        cwdPackageJson = currentState.get('cwdPackageJson');
                        allDependencies = dependencies(cwdPackageJson);
                        allDependenciesIncludingMissing = (0, _keys2.default)(extend(allDependencies, currentState.get('missingFromPackageJson')));
                        _context.next = 11;
                        return allDependenciesIncludingMissing.map(function (moduleName) {
                            return createPackageSummary(moduleName, currentState);
                        }).filter(Boolean);

                    case 11:
                        arrayOfPackageInfo = _context.sent;


                        currentState.set('packages', arrayOfPackageInfo);

                        spinner.stop();
                        return _context.abrupt('return', currentState);

                    case 15:
                    case 'end':
                        return _context.stop();
                }
            }
        }, _callee, this);
    }));
};