'use strict';

var _ = require('lodash');
var inquirer = require('inquirer');
var chalk = require('chalk');
var table = require('text-table');
var installPackages = require('./install-packages');
var emoji = require('./emoji');

function updateAll(currentState) {
    var packages = currentState.get('packages');

    if (currentState.get('debug')) {
        console.log('packages', packages);
    }

    var packagesToUpdate = packages.filter(function (packageEntry) {
        return packageEntry.mismatch || packageEntry.notInstalled || packageEntry.bump;
    });

    if (!packagesToUpdate.length) {
        console.log(emoji(':heart:  ') + 'Your modules look ' + chalk.bold('amazing') + '. Keep up the great work.' + emoji(' :heart:'));
        return;
    }

    var saveDependencies = packagesToUpdate.filter(function (pkg) {
        return !pkg.devDependency;
    }).map(function (pkg) {
        return pkg.moduleName + '@' + pkg.latest;
    });

    var saveDevDependencies = packagesToUpdate.filter(function (pkg) {
        return pkg.devDependency;
    }).map(function (pkg) {
        return pkg.moduleName + '@' + pkg.latest;
    });

    var updatedPackages = packagesToUpdate.map(function (pkg) {
        return pkg.moduleName + '@' + pkg.latest;
    }).join(', ');

    if (!currentState.get('global')) {
        if (saveDependencies.length) {
            saveDependencies.unshift('--save');
        }

        if (saveDevDependencies.length) {
            saveDevDependencies.unshift('--save-dev');
        }
    }

    return installPackages(saveDependencies, currentState).then(function (currentState) {
        return installPackages(saveDevDependencies, currentState);
    }).then(function (currentState) {
        console.log('');
        console.log(chalk.green('[npm-check] Update complete!'));
        console.log(chalk.green('[npm-check] ' + updatedPackages));
        console.log(chalk.green('[npm-check] You should re-run your tests to make sure everything works with the updates.'));
        return currentState;
    });
}

module.exports = updateAll;