import { e as execa } from '../shared/nuxi.6b390535.mjs';
import { c as consola } from '../shared/nuxi.b2fdb45d.mjs';
import { b as tryResolveModule } from '../shared/nuxi.e551a86b.mjs';
import { d as defineNuxtCommand } from '../shared/nuxi.a865ab6b.mjs';
import { r as resolve } from '../shared/nuxi.a2d9d2e1.mjs';
import 'node:buffer';
import 'node:path';
import 'node:child_process';
import 'node:process';
import '../shared/nuxi.30bccfab.mjs';
import 'child_process';
import 'path';
import '../shared/nuxi.ed696fbc.mjs';
import 'fs';
import 'assert';
import 'events';
import 'buffer';
import 'stream';
import 'util';
import 'node:url';
import 'os';
import 'node:os';
import 'tty';
import 'node:module';

const MODULE_BUILDER_PKG = "@nuxt/module-builder";
const buildModule = defineNuxtCommand({
  meta: {
    name: "build-module",
    usage: "npx nuxi build-module [--stub] [rootDir]",
    description: `Helper command for using ${MODULE_BUILDER_PKG}`
  },
  async invoke(args) {
    const rootDir = resolve(args._[0] || ".");
    const hasLocal = tryResolveModule(`${MODULE_BUILDER_PKG}/package.json`, rootDir);
    const execArgs = Object.entries({
      "--stub": args.stub
    }).filter(([, value]) => value).map(([key]) => key);
    let cmd = "nuxt-module-build";
    if (!hasLocal) {
      consola.warn(`Cannot find locally installed version of \`${MODULE_BUILDER_PKG}\` (>=0.2.0). Falling back to \`npx ${MODULE_BUILDER_PKG}\``);
      cmd = "npx";
      execArgs.unshift(MODULE_BUILDER_PKG);
    }
    await execa(cmd, execArgs, { preferLocal: true, stdio: "inherit", cwd: rootDir });
  }
});

export { buildModule as default };
