import { c as consola } from '../shared/nuxi.b2fdb45d.mjs';
import { w as writeTypes } from '../shared/nuxi.30988785.mjs';
import { l as loadKit } from '../shared/nuxi.8cc4a579.mjs';
import { c as clearDir } from '../shared/nuxi.74850c25.mjs';
import { o as overrideEnv } from '../shared/nuxi.d21ab543.mjs';
import { a as showVersions } from '../shared/nuxi.1b1e0b8b.mjs';
import { d as defineNuxtCommand } from '../shared/nuxi.a865ab6b.mjs';
import { r as resolve, a as relative } from '../shared/nuxi.a2d9d2e1.mjs';
import '../shared/nuxi.ed696fbc.mjs';
import 'util';
import 'path';
import 'fs';
import 'os';
import 'tty';
import 'node:fs';
import '../shared/nuxi.d0ea9d71.mjs';
import '../shared/nuxi.e551a86b.mjs';
import 'node:module';
import 'node:url';
import 'assert';
import '../shared/nuxi.a3b9dacd.mjs';

const buildCommand = defineNuxtCommand({
  meta: {
    name: "build",
    usage: "npx nuxi build [--prerender] [--dotenv] [rootDir]",
    description: "Build nuxt for production deployment"
  },
  async invoke(args) {
    overrideEnv("production");
    const rootDir = resolve(args._[0] || ".");
    showVersions(rootDir);
    const { loadNuxt, buildNuxt, useNitro } = await loadKit(rootDir);
    const nuxt = await loadNuxt({
      rootDir,
      dotenv: {
        cwd: rootDir,
        fileName: args.dotenv
      },
      defaults: {
        experimental: {
          payloadExtraction: args.prerender ? true : void 0
        }
      },
      overrides: {
        _generate: args.prerender
      }
    });
    const nitro = useNitro?.();
    await clearDir(nuxt.options.buildDir);
    await writeTypes(nuxt);
    nuxt.hook("build:error", (err) => {
      consola.error("Nuxt Build Error:", err);
      process.exit(1);
    });
    await buildNuxt(nuxt);
    if (args.prerender) {
      const dir = nitro?.options.output.publicDir;
      const publicDir = dir ? relative(process.cwd(), dir) : ".output/public";
      consola.success(`You can now deploy \`${publicDir}\` to any static hosting!`);
    }
  }
});

export { buildCommand as default };
