import { buildNuxt } from '@nuxt/kit';
import { c as consola } from '../shared/nuxi.b2fdb45d.mjs';
import { c as clearDir } from '../shared/nuxi.74850c25.mjs';
import { l as loadKit } from '../shared/nuxi.8cc4a579.mjs';
import { w as writeTypes } from '../shared/nuxi.30988785.mjs';
import { d as defineNuxtCommand } from '../shared/nuxi.a865ab6b.mjs';
import { r as resolve, a as relative } from '../shared/nuxi.a2d9d2e1.mjs';
import '../shared/nuxi.ed696fbc.mjs';
import 'util';
import 'path';
import 'fs';
import 'os';
import 'tty';
import 'node:fs';
import '../shared/nuxi.e551a86b.mjs';
import 'node:module';
import 'node:url';
import '../shared/nuxi.d0ea9d71.mjs';

const prepare = defineNuxtCommand({
  meta: {
    name: "prepare",
    usage: "npx nuxi prepare",
    description: "Prepare nuxt for development/build"
  },
  async invoke(args) {
    process.env.NODE_ENV = process.env.NODE_ENV || "production";
    const rootDir = resolve(args._[0] || ".");
    const { loadNuxt } = await loadKit(rootDir);
    const nuxt = await loadNuxt({ rootDir, config: { _prepare: true } });
    await clearDir(nuxt.options.buildDir);
    await buildNuxt(nuxt);
    await writeTypes(nuxt);
    consola.success("Types generated in", relative(process.cwd(), nuxt.options.buildDir));
  }
});

export { prepare as default };
