import { e as execa } from '../shared/nuxi.6b390535.mjs';
import { b as tryResolveModule } from '../shared/nuxi.e551a86b.mjs';
import { l as loadKit } from '../shared/nuxi.8cc4a579.mjs';
import { w as writeTypes } from '../shared/nuxi.30988785.mjs';
import { d as defineNuxtCommand } from '../shared/nuxi.a865ab6b.mjs';
import { r as resolve } from '../shared/nuxi.a2d9d2e1.mjs';
import 'node:buffer';
import 'node:path';
import 'node:child_process';
import 'node:process';
import '../shared/nuxi.30bccfab.mjs';
import 'child_process';
import 'path';
import '../shared/nuxi.ed696fbc.mjs';
import 'fs';
import 'assert';
import 'events';
import 'buffer';
import 'stream';
import 'util';
import 'node:url';
import 'os';
import 'node:os';
import 'node:module';
import 'node:fs';
import '../shared/nuxi.d0ea9d71.mjs';

const typecheck = defineNuxtCommand({
  meta: {
    name: "typecheck",
    usage: "npx nuxi typecheck [rootDir]",
    description: "Runs `vue-tsc` to check types throughout your app."
  },
  async invoke(args) {
    process.env.NODE_ENV = process.env.NODE_ENV || "production";
    const rootDir = resolve(args._[0] || ".");
    const { loadNuxt, buildNuxt } = await loadKit(rootDir);
    const nuxt = await loadNuxt({ rootDir, config: { _prepare: true } });
    await writeTypes(nuxt);
    await buildNuxt(nuxt);
    await nuxt.close();
    const hasLocalInstall = tryResolveModule("typescript", rootDir) && tryResolveModule("vue-tsc/package.json", rootDir);
    if (hasLocalInstall) {
      await execa("vue-tsc", ["--noEmit"], { preferLocal: true, stdio: "inherit", cwd: rootDir });
    } else {
      await execa("npx", "-p vue-tsc -p typescript vue-tsc --noEmit".split(" "), { stdio: "inherit", cwd: rootDir });
    }
  }
});

export { typecheck as default };
