import { promises } from 'node:fs';
import { d as defu } from './nuxi.d0ea9d71.mjs';
import { g as getModulePaths, a as getNearestPackage } from './nuxi.e551a86b.mjs';
import { a as relative, j as join, r as resolve, i as isAbsolute } from './nuxi.a2d9d2e1.mjs';

const writeTypes = async (nuxt) => {
  const modulePaths = getModulePaths(nuxt.options.modulesDir);
  const tsConfig = defu(nuxt.options.typescript?.tsConfig, {
    compilerOptions: {
      jsx: "preserve",
      target: "ESNext",
      module: "ESNext",
      moduleResolution: "Node",
      skipLibCheck: true,
      strict: nuxt.options.typescript?.strict ?? false,
      allowJs: true,
      noEmit: true,
      resolveJsonModule: true,
      allowSyntheticDefaultImports: true,
      types: ["node"],
      baseUrl: relative(nuxt.options.buildDir, nuxt.options.rootDir),
      paths: {}
    },
    include: [
      "./nuxt.d.ts",
      join(relative(nuxt.options.buildDir, nuxt.options.rootDir), "**/*"),
      ...nuxt.options.srcDir !== nuxt.options.rootDir ? [join(relative(nuxt.options.buildDir, nuxt.options.srcDir), "**/*")] : [],
      ...nuxt.options.typescript.includeWorkspace && nuxt.options.workspaceDir !== nuxt.options.rootDir ? [join(relative(nuxt.options.buildDir, nuxt.options.workspaceDir), "**/*")] : []
    ],
    exclude: [
      relative(nuxt.options.buildDir, resolve(nuxt.options.rootDir, "dist"))
    ]
  });
  const aliases = {
    ...nuxt.options.alias,
    "#build": nuxt.options.buildDir
  };
  const excludedAlias = [/^@vue\/.*$/];
  for (const alias in aliases) {
    if (excludedAlias.some((re) => re.test(alias))) {
      continue;
    }
    const relativePath = isAbsolute(aliases[alias]) ? relative(nuxt.options.rootDir, aliases[alias]) || "." : aliases[alias];
    const stats = await promises.stat(resolve(nuxt.options.rootDir, relativePath)).catch(() => null);
    tsConfig.compilerOptions = tsConfig.compilerOptions || {};
    if (stats?.isDirectory()) {
      tsConfig.compilerOptions.paths[alias] = [relativePath];
      tsConfig.compilerOptions.paths[`${alias}/*`] = [`${relativePath}/*`];
    } else {
      tsConfig.compilerOptions.paths[alias] = [relativePath.replace(/(?<=\w)\.\w+$/g, "")];
    }
  }
  const references = [
    ...nuxt.options.modules,
    ...nuxt.options._modules
  ].filter((f) => typeof f === "string").map((id) => ({ types: getNearestPackage(id, modulePaths)?.name || id }));
  if (nuxt.options.experimental?.reactivityTransform) {
    references.push({ types: "vue/macros-global" });
  }
  const declarations = [];
  await nuxt.callHook("prepare:types", { references, declarations, tsConfig });
  const declaration = [
    ...references.map((ref) => {
      if ("path" in ref && isAbsolute(ref.path)) {
        ref.path = relative(nuxt.options.buildDir, ref.path);
      }
      return `/// <reference ${renderAttrs(ref)} />`;
    }),
    ...declarations,
    "",
    "export {}",
    ""
  ].join("\n");
  async function writeFile() {
    const GeneratedBy = "// Generated by nuxi";
    const tsConfigPath = resolve(nuxt.options.buildDir, "tsconfig.json");
    await promises.mkdir(nuxt.options.buildDir, { recursive: true });
    await promises.writeFile(tsConfigPath, GeneratedBy + "\n" + JSON.stringify(tsConfig, null, 2));
    const declarationPath = resolve(nuxt.options.buildDir, "nuxt.d.ts");
    await promises.writeFile(declarationPath, GeneratedBy + "\n" + declaration);
  }
  nuxt.hook("builder:prepared", writeFile);
  await writeFile();
};
function renderAttrs(obj) {
  return Object.entries(obj).map((e) => renderAttr(e[0], e[1])).join(" ");
}
function renderAttr(key, value) {
  return value ? `${key}="${value}"` : "";
}

export { writeTypes as w };
