function toArr(any) {
	return any == null ? [] : Array.isArray(any) ? any : [any];
}

function toVal(out, key, val, opts) {
	var x, old=out[key], nxt=(
		!!~opts.string.indexOf(key) ? (val == null || val === true ? '' : String(val))
		: typeof val === 'boolean' ? val
		: !!~opts.boolean.indexOf(key) ? (val === 'false' ? false : val === 'true' || (out._.push((x = +val,x * 0 === 0) ? x : val),!!val))
		: (x = +val,x * 0 === 0) ? x : val
	);
	out[key] = old == null ? nxt : (Array.isArray(old) ? old.concat(nxt) : [old, nxt]);
}

function mri (args, opts) {
	args = args || [];
	opts = opts || {};

	var k, arr, arg, name, val, out={ _:[] };
	var i=0, j=0, idx=0, len=args.length;

	const alibi = opts.alias !== void 0;
	const strict = opts.unknown !== void 0;
	const defaults = opts.default !== void 0;

	opts.alias = opts.alias || {};
	opts.string = toArr(opts.string);
	opts.boolean = toArr(opts.boolean);

	if (alibi) {
		for (k in opts.alias) {
			arr = opts.alias[k] = toArr(opts.alias[k]);
			for (i=0; i < arr.length; i++) {
				(opts.alias[arr[i]] = arr.concat(k)).splice(i, 1);
			}
		}
	}

	for (i=opts.boolean.length; i-- > 0;) {
		arr = opts.alias[opts.boolean[i]] || [];
		for (j=arr.length; j-- > 0;) opts.boolean.push(arr[j]);
	}

	for (i=opts.string.length; i-- > 0;) {
		arr = opts.alias[opts.string[i]] || [];
		for (j=arr.length; j-- > 0;) opts.string.push(arr[j]);
	}

	if (defaults) {
		for (k in opts.default) {
			name = typeof opts.default[k];
			arr = opts.alias[k] = opts.alias[k] || [];
			if (opts[name] !== void 0) {
				opts[name].push(k);
				for (i=0; i < arr.length; i++) {
					opts[name].push(arr[i]);
				}
			}
		}
	}

	const keys = strict ? Object.keys(opts.alias) : [];

	for (i=0; i < len; i++) {
		arg = args[i];

		if (arg === '--') {
			out._ = out._.concat(args.slice(++i));
			break;
		}

		for (j=0; j < arg.length; j++) {
			if (arg.charCodeAt(j) !== 45) break; // "-"
		}

		if (j === 0) {
			out._.push(arg);
		} else if (arg.substring(j, j + 3) === 'no-') {
			name = arg.substring(j + 3);
			if (strict && !~keys.indexOf(name)) {
				return opts.unknown(arg);
			}
			out[name] = false;
		} else {
			for (idx=j+1; idx < arg.length; idx++) {
				if (arg.charCodeAt(idx) === 61) break; // "="
			}

			name = arg.substring(j, idx);
			val = arg.substring(++idx) || (i+1 === len || (''+args[i+1]).charCodeAt(0) === 45 || args[++i]);
			arr = (j === 2 ? [name] : name);

			for (idx=0; idx < arr.length; idx++) {
				name = arr[idx];
				if (strict && !~keys.indexOf(name)) return opts.unknown('-'.repeat(j) + name);
				toVal(out, name, (idx + 1 < arr.length) || val, opts);
			}
		}
	}

	if (defaults) {
		for (k in opts.default) {
			if (out[k] === void 0) {
				out[k] = opts.default[k];
			}
		}
	}

	if (alibi) {
		for (k in out) {
			arr = opts.alias[k] || [];
			while (arr.length > 0) {
				out[arr.shift()] = out[k];
			}
		}
	}

	return out;
}

const _rDefault = (r) => r.default || r;
const commands = {
  dev: () => import('../chunks/dev.mjs').then(_rDefault),
  build: () => import('../chunks/build.mjs').then(_rDefault),
  "build-module": () => import('../chunks/build-module.mjs').then(_rDefault),
  cleanup: () => import('../chunks/cleanup.mjs').then(_rDefault),
  clean: () => import('../chunks/cleanup.mjs').then(_rDefault),
  preview: () => import('../chunks/preview.mjs').then(_rDefault),
  start: () => import('../chunks/preview.mjs').then(_rDefault),
  analyze: () => import('../chunks/analyze.mjs').then(_rDefault),
  generate: () => import('../chunks/generate.mjs').then(_rDefault),
  prepare: () => import('../chunks/prepare.mjs').then(_rDefault),
  typecheck: () => import('../chunks/typecheck.mjs').then(_rDefault),
  usage: () => import('../chunks/usage.mjs').then(_rDefault),
  info: () => import('../chunks/info.mjs').then(_rDefault),
  init: () => import('../chunks/init.mjs').then(function (n) { return n.i; }).then(_rDefault),
  create: () => import('../chunks/init.mjs').then(function (n) { return n.i; }).then(_rDefault),
  upgrade: () => import('../chunks/upgrade.mjs').then(_rDefault),
  test: () => import('../chunks/test.mjs').then(_rDefault),
  add: () => import('../chunks/add.mjs').then(_rDefault),
  new: () => import('../chunks/add.mjs').then(_rDefault)
};
function defineNuxtCommand(command) {
  return command;
}

export { commands as c, defineNuxtCommand as d, mri as m };
