"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.toOldFormat = exports.toNewFormat = exports.mergeAngularJsonAndGlobProjects = exports.shouldMergeAngularProjects = void 0;
const fs_1 = require("fs");
const path = require("path");
const fileutils_1 = require("../utils/fileutils");
const workspaces_1 = require("../config/workspaces");
const workspace_root_1 = require("../utils/workspace-root");
function shouldMergeAngularProjects(root, includeProjectsFromAngularJson) {
    if ((0, fs_1.existsSync)(path.join(root, 'angular.json')) &&
        // Include projects from angular.json if explicitly required.
        // e.g. when invoked from `packages/devkit/src/utils/convert-nx-executor.ts`
        (includeProjectsFromAngularJson ||
            // Or if a workspace has `@nrwl/angular` installed then projects from `angular.json` to be considered by Nx.
            isNrwlAngularInstalled())) {
        return true;
    }
    else {
        return false;
    }
}
exports.shouldMergeAngularProjects = shouldMergeAngularProjects;
function isNrwlAngularInstalled() {
    try {
        require.resolve('@nrwl/angular');
        return true;
    }
    catch (_a) {
        return false;
    }
}
function readAngularJson() {
    return toNewFormat((0, fileutils_1.readJsonFile)(path.join(workspace_root_1.workspaceRoot, 'angular.json')))
        .projects;
}
function mergeAngularJsonAndGlobProjects(globProjects) {
    const res = readAngularJson();
    const folders = new Set();
    for (let k of Object.keys(res)) {
        folders.add(res[k].root);
    }
    for (let k of Object.keys(globProjects)) {
        if (!folders.has(globProjects[k].root)) {
            res[k] = globProjects[k];
        }
    }
    return res;
}
exports.mergeAngularJsonAndGlobProjects = mergeAngularJsonAndGlobProjects;
function toNewFormat(w) {
    Object.values(w.projects || {}).forEach((projectConfig) => {
        if (projectConfig.architect) {
            (0, workspaces_1.renamePropertyWithStableKeys)(projectConfig, 'architect', 'targets');
        }
        if (projectConfig.schematics) {
            (0, workspaces_1.renamePropertyWithStableKeys)(projectConfig, 'schematics', 'generators');
        }
        Object.values(projectConfig.targets || {}).forEach((target) => {
            if (target.builder !== undefined) {
                (0, workspaces_1.renamePropertyWithStableKeys)(target, 'builder', 'executor');
            }
        });
    });
    if (w.schematics) {
        (0, workspaces_1.renamePropertyWithStableKeys)(w, 'schematics', 'generators');
    }
    if (w.version !== 2) {
        w.version = 2;
    }
    return w;
}
exports.toNewFormat = toNewFormat;
function toOldFormat(w) {
    Object.values(w.projects || {}).forEach((projectConfig) => {
        if (typeof projectConfig === 'string') {
            throw new Error("'project.json' files are incompatible with version 1 workspace schemas.");
        }
        if (projectConfig.targets) {
            (0, workspaces_1.renamePropertyWithStableKeys)(projectConfig, 'targets', 'architect');
        }
        if (projectConfig.generators) {
            (0, workspaces_1.renamePropertyWithStableKeys)(projectConfig, 'generators', 'schematics');
        }
        delete projectConfig.name;
        Object.values(projectConfig.architect || {}).forEach((target) => {
            if (target.executor !== undefined) {
                (0, workspaces_1.renamePropertyWithStableKeys)(target, 'executor', 'builder');
            }
        });
    });
    if (w.generators) {
        (0, workspaces_1.renamePropertyWithStableKeys)(w, 'generators', 'schematics');
    }
    if (w.version !== 1) {
        w.version = 1;
    }
    return w;
}
exports.toOldFormat = toOldFormat;
//# sourceMappingURL=angular-json.js.map