"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.connectToNxCloudCommand = exports.connectToNxCloudIfExplicitlyAsked = void 0;
const tslib_1 = require("tslib");
const output_1 = require("../utils/output");
const package_manager_1 = require("../utils/package-manager");
const child_process_1 = require("child_process");
const configuration_1 = require("../config/configuration");
const nx_cloud_utils_1 = require("../utils/nx-cloud-utils");
const child_process_2 = require("../utils/child-process");
function connectToNxCloudIfExplicitlyAsked(opts) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        if (opts['cloud'] === true) {
            const nxJson = (0, configuration_1.readNxJson)();
            const runners = Object.values(nxJson.tasksRunnerOptions);
            const onlyDefaultRunnerIsUsed = runners.length === 1 && runners[0].runner === 'nx/tasks-runners/default';
            if (!onlyDefaultRunnerIsUsed)
                return;
            output_1.output.log({
                title: '--cloud requires the workspace to be connected to Nx Cloud.',
            });
            (0, child_process_2.runNxSync)(`connect-to-nx-cloud`, {
                stdio: [0, 1, 2],
            });
            output_1.output.success({
                title: 'Your workspace has been successfully connected to Nx Cloud.',
            });
            process.exit(0);
        }
    });
}
exports.connectToNxCloudIfExplicitlyAsked = connectToNxCloudIfExplicitlyAsked;
function connectToNxCloudCommand(promptOverride) {
    var _a;
    var _b;
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        if ((0, nx_cloud_utils_1.isNxCloudUsed)()) {
            output_1.output.log({
                title: '✅ This workspace is already connected to Nx Cloud.',
                bodyLines: [
                    'This means your workspace can use computation caching, distributed task execution, and show you run analytics.',
                    'Go to https://nx.app to learn more.',
                    ' ',
                    'If you have not done so already, please claim this workspace:',
                    `${(0, nx_cloud_utils_1.getNxCloudUrl)()}/orgs/workspace-setup?accessToken=${(0, nx_cloud_utils_1.getNxCloudToken)()}`,
                ],
            });
            return false;
        }
        const res = yield connectToNxCloudPrompt(promptOverride);
        if (!res)
            return false;
        const pmc = (0, package_manager_1.getPackageManagerCommand)();
        if (pmc) {
            (0, child_process_1.execSync)(`${pmc.addDev} @nrwl/nx-cloud@latest`);
        }
        else {
            const nxJson = (0, configuration_1.readNxJson)();
            if (nxJson.installation) {
                (_a = (_b = nxJson.installation).plugins) !== null && _a !== void 0 ? _a : (_b.plugins = {});
                nxJson.installation.plugins['@nrwl/nx-cloud'] = (0, child_process_1.execSync)(`npm view @nrwl/nx-cloud@latest version`).toString();
            }
        }
        (0, child_process_2.runNxSync)(`g @nrwl/nx-cloud:init`, {
            stdio: [0, 1, 2],
        });
        return true;
    });
}
exports.connectToNxCloudCommand = connectToNxCloudCommand;
function connectToNxCloudPrompt(prompt) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        return yield (yield Promise.resolve().then(() => require('enquirer')))
            .prompt([
            {
                name: 'NxCloud',
                message: prompt !== null && prompt !== void 0 ? prompt : `Enable distributed caching to make your CI faster`,
                type: 'autocomplete',
                choices: [
                    {
                        name: 'Yes',
                        hint: 'I want faster builds',
                    },
                    {
                        name: 'No',
                    },
                ],
                initial: 'Yes',
            },
        ])
            .then((a) => a.NxCloud === 'Yes');
    });
}
//# sourceMappingURL=connect.js.map