import { ProjectGraphDependency, ProjectGraphProjectNode } from '../config/project-graph';
import { TaskGraph } from '../config/task-graph';
export interface ProjectGraphClientResponse {
    hash: string;
    projects: ProjectGraphProjectNode[];
    dependencies: Record<string, ProjectGraphDependency[]>;
    layout: {
        appsDir: string;
        libsDir: string;
    };
    affected: string[];
    focus: string;
    groupByFolder: boolean;
    exclude: string[];
}
export interface TaskGraphClientResponse {
    taskGraphs: Record<string, TaskGraph>;
    errors: Record<string, string>;
}
export declare function generateGraph(args: {
    file?: string;
    host?: string;
    port?: number;
    groupByFolder?: boolean;
    watch?: boolean;
    open?: boolean;
    view: 'projects' | 'tasks';
    projects?: string[];
    all?: boolean;
    targets?: string[];
    focus?: string;
    exclude?: string[];
}, affectedProjects: string[]): Promise<void>;
