import { PackageManager } from '../utils/package-manager';
import { PackageJson } from '../utils/package-json';
export declare const packagesWeCareAbout: string[];
export declare const patternsWeIgnoreInCommunityReport: Array<string | RegExp>;
/**
 * Reports relevant version numbers for adding to an Nx issue report
 *
 * @remarks
 *
 * Must be run within an Nx workspace
 *
 */
export declare function reportHandler(): Promise<void>;
export interface ReportData {
    pm: PackageManager;
    pmVersion: string;
    localPlugins: string[];
    communityPlugins: PackageJson[];
    packageVersionsWeCareAbout: {
        package: string;
        version: string;
    }[];
    outOfSyncPackageGroup?: {
        basePackage: string;
        misalignedPackages: {
            name: string;
            version: string;
        }[];
        migrateTarget: string;
    };
    projectGraphError?: Error | null;
}
export declare function getReportData(): Promise<ReportData>;
interface OutOfSyncPackageGroup {
    basePackage: string;
    misalignedPackages: {
        name: string;
        version: string;
    }[];
    migrateTarget: string;
}
export declare function findMisalignedPackagesForPackage(base: PackageJson): undefined | OutOfSyncPackageGroup;
export declare function findInstalledCommunityPlugins(): PackageJson[];
export declare function findInstalledPackagesWeCareAbout(): {
    package: string;
    version: string;
}[];
export {};
